<?php
/**
 * The template for displaying archive pages
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package AnanyaPRO
 * @since 1.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

get_header();
$defaults = ananyapro_get_defaults();
$posts_layout = get_theme_mod( 'ananyapro_blog_posts_layout', $defaults['blog_posts_layout'] );
$page_head_style = get_theme_mod( 'ananyapro_single_page_title_position', $defaults['single_page_title_position'] );
?>
<?php if ( $page_head_style !== 'over-hero-image' ) : ?>
	<div class="archive-page-header">
		<header class="container">
			<?php
			the_archive_title( '<h1 class="page-title"><span class="archive-title">', '<span></h1>' );
			the_archive_description( '<div class="archive-description">', '</div>' );
			?>
		</header><!-- .page-header -->
	</div><!-- archive-page-header-wrapper -->
<?php endif; ?>
<div class="container">
	<div class="row">
		
		<div id="primary" class="content-area  <?php echo esc_attr('blog-layout-'.$posts_layout); ?>">
			<main id="main" class="site-main">

			<?php if ( have_posts() ) : ?>

				<?php
				/* Start the Loop */
				while ( have_posts() ) :
					the_post();

					/*
					 * Include the Post-Type-specific template for the content.
					 * If you want to override this in a child theme, then include a file
					 * called content-___.php (where ___ is the Post Type name) and that will be used instead.
					 */
					get_template_part( 'template-parts/content', get_post_type() );

				endwhile;

				the_posts_pagination( array( 
					'mid_size' => 1, 
					'prev_text' => esc_html__( 'Prev', 'ananyapro' ),
    				'next_text' => esc_html__( 'Next', 'ananyapro' ), 
    			) );
				
			else :

				get_template_part( 'template-parts/content', 'none' );

			endif;
			?>
			</main><!-- #main -->
		</div><!-- primary -->
		<?php get_sidebar(); ?>
	</div><!--row-->
</div><!-- container-->
<?php get_footer();
