/**
 *
 * Theme Customizer enhancements for a better user experience.
 *
 * Contains handlers to make Theme Customizer preview reload changes asynchronously.
 */

( function( $ ) {

	// Collect information from panel-customizer.js about which panels are opening
	wp.customize.bind( 'preview-ready', function() {
		wp.customize.preview.bind( 'section-highlight', function( data ) {
			// If there's an expanded panel section, scroll down to that panel & highlight in the preview
			if ( true === data.expanded ) {
				$.scrollTo( $( '#' + data.section_id ), {
					duration: 600,
					offset: { 'top': -40 }
				} );
				$( '#' + data.section_id ).addClass( 'ananyapro-highlight' );
			// If we've left the panel, remove the highlight and scroll back to the top
			} else {
				$.scrollTo( $( '#feat-content-sec-1' ), {
					duration: 300,
					offset: { 'top': 0 }
				} );
				$( '#' + data.section_id ).removeClass( 'ananyapro-highlight' );
			}
		} );
	} );

	// Site title and description.
	wp.customize( 'blogname', function( value ) {
		value.bind( function( to ) {
			$( '.site-title a' ).text( to );
		} );
	} );
	

	wp.customize( 'blogdescription', function( value ) {
		value.bind( function( to ) {
			$( '.site-description' ).text( to );
		} );
	} );

	//Header/Hero overlay
	wp.customize( 'ananyapro_header_overlay_type', function( value ) {
		value.bind( function( to ) {

			var overlayClassList = ['default-overlay','color-overlay','no-overlay','gradient-overlay'];
			
			overlayClassList.forEach((overlayClass) =>  {
				if( $( '#masthead' ).hasClass(overlayClass) ) {
					$( '#masthead' ).removeClass(overlayClass);
				}
			});
			$( '#masthead' ).addClass(to);
		} );
	} );

	// Header text color.
	wp.customize( 'ananyapro_display_site_title_tagline', function( value ) {
		value.bind( function( to ) {
			if ( false === to ) {
				$( '.site-title, .site-description' ).css( {
					'clip': 'rect(1px, 1px, 1px, 1px)',
					'position': 'absolute'
				} );
			} else {
				$( '.site-title, .site-description' ).css( {
					'color': to,
					'position': 'relative'
				} );
			}
		} );
	} );

	// Header text color.
	wp.customize( 'ananyapro_site_header_text_color', function( value ) {
		value.bind( function( to ) {
			$( '.site-title a, .site-description,#site-navigation .nav-menu-primary > li.menu-item > a, #site-navigation .nav-menu-primary > li.page_item > a,.main-navigation a,.header-social-menu li a i,.header-social-menu li #desktop-search-icon' ).css( {
				'color': to
			} );
			$('#site-navigation .nav-menu-primary > li.menu-item > a > i').css({
				'color': to
			});
			$('.navbar-toggler, .navbar-toggler i').css({
				'color': to
			});
			$( '.header-social-menu ul' ).css({
				'border-left': '1px solid' + to
			});
			$( '.custom-heading, .custom-heading .hero-title, .custom-heading .subheading, .custom-heading .hero-section-btn a, .custom-heading .hero-section-btn a:visited' ).css({
				'color': to
			});
			$( '.custom-heading .hero-section-btn' ).css({
				'border-bottom': '1px solid' + to,
				'color': to
			});
			$( '.home #site-navigation .container' ).css({
				'border-bottom': '1px solid' + to
			});
			$('.hero-btn-border-straight, .hero-btn-border-slight-round, .hero-btn-border-round').css({
				'background': 'transparent !important',
				'border-color': to,
				'color': to
			});
			$('.hero-btn-underline ').css({
				'background': 'transparent !important',
				'border-bottom': '2px solid ' + to,
				'color': to,
				'padding': '15px 0'
			});
			$('.over-hero-page-title .entry-title a, .over-hero-page-title .entry-title a:visited, .over-hero-page-title .entry-description a, .over-hero-page-title .entry-description a:visited, .over-hero-page-title .single-entry-meta a, .over-hero-page-title .single-entry-meta a:visited, .custom-header-other-page .blog-page-title').css({
				'color': to,
			});
			$('.over-hero-page-title .entry-title, .over-hero-page-title .entry-description, .over-hero-page-title .single-entry-meta').css({
				'color': to,
			});
			
		} );
	} );

	// Accent color.
	wp.customize( 'ananyapro_accent_color', function( value ) {
		value.bind( function( to ) {
			$( '.top-cat-link, .entry-meta .posted-on a ' ).css( {
				'border-bottom': '2px solid ' + to
			});
			$( '.widget a:hover, .widget a:focus' ).css( {
				'color': to
			});
			$( '.entry-header a:hover, blockquote:before,.footer-category-links i, .footer-tag-links i,.entry-edit-link a, .entry-edit-link a:visited, .entry-edit-link a:focus, .social-share a i, .social-share a:visited, .social-share a:focus i' ).css( {
				'color': to
			});
			$( '.pagination .current' ).css( {
				'background-color': to,
				'border': '1px solid' + to,
				'color': '#fff'
			});
			$( 'button, input[type=button], input[type=reset], input[type=submit]' ).css( {
				'border-radius': '3px',
				'background': to,
				'color':'#fff'
			} );
			$( '.woocommerce #payment #place_order, .woocommerce-page #payment #place_order, .woocommerce #respond input#submit.alt' ).css( {
				'border-radius': '3px',
				'background': to,
				'color': '#fff'
			} );
			$( '.woocommerce a.button.alt, .woocommerce button.button.alt, .woocommerce input.button.alt, .woocommerce #respond input#submit, .woocommerce a.button, .woocommerce button.button, .woocommerce input.button, #infinite-handle span' ).css( {
				'border-radius': '3px',
				'background': to,
				'color': '#fff'
			} );
			$( '.more-btn-border-straight a, .more-btn-border-straight a:visited, .more-btn-border-straight a:hover, .more-btn-border-slight-round a, .more-btn-border-slight-round a:visited, .more-btn-border-slight-round a:hover, .more-btn-border-round a, .more-btn-border-round a:visited, .more-btn-border-round a:hover' ).css( {
				'border-color': to,
				'background-color': '#fff',
				'color': to
			});
			$( '.more-btn-fill-straight a, .more-btn-fill-straight a:visited, .more-btn-fill-straight a:hover, .more-btn-fill-slight-round a, .more-btn-fill-slight-round a:visited, .more-btn-fill-slight-round a:hover, .more-btn-fill-round a, .more-btn-fill-round a:visited, .more-btn-fill-round a:hover' ).css( {
				'border-color': to,
				'background-color': to,
				'color': '#fff'
			});
			$( '.more-btn-underline a,.more-btn-underline a:visited' ).css( {
				'border-bottom-color': to,
				'color': to
			});
			$( '#secondary  .widget .widget-title' ).css( {
				'border-bottom': '2px solid ' + to,
				'color': to
			} );
			$( '.hero-btn-color-fill-straight,.hero-btn-color-fill-slight-round,.hero-btn-color-fill-round' ).css( {
				'background':to,
				'color': '#fff'
			} );
			$( '.hero-btn-color-border-straight,.hero-btn-color-border-slight-round,.hero-btn-color-border-round' ).css( {
				'border-color':to,
				'color': to,
				'background':transparent,
			} );
			$( '.scrolltop' ).css( {
				'background-color':to,
			} );
		} );
	} );

	// Heor title 
	ananyapro_bind_to_text( 'header_title', '.custom-heading .hero-title' );

	// Heor subtitle 
	ananyapro_bind_to_text( 'header_subtitle', '.custom-heading .subheading' );

	// Heor button text 
	ananyapro_bind_to_text( 'header_button_text', '.hero-section-btn a' );

	// Heor button url
	ananyapro_bind_to_url( 'header_button_url', '.hero-section-btn a' );

	// BodyText color.
	ananyapro_bind_fg_color_css( 'body_text_color', 'body,blockquote,cite,code,kbd, .widget ul li a,.post-navigation a div, .post-navigation a div span, .pagination .page-numbers,.entry-footer, .single-post-entry-footer' );

	// Heading Text color.
	ananyapro_bind_fg_color_css( 'heading_text_color', '.site-content h1,.site-content h2,.site-content h3,.site-content h4,.site-content h5,.site-content h6,.entry-title a, .site-content h2 a, .site-content h3 a,.site-content h4 a,.site-content h5 a,.site-content h6 a' );


	// Menu Text/Link color.
	wp.customize( 'ananyapro_menu_item_color', function( value ) {
		value.bind( function( to ) {
			$( '.no-header-image #site-navigation .header-social-menu ul' ).css( {
				'border-left-color': to
			});
		} );
	} );

	ananyapro_bind_fg_color_css( 'menu_item_color', '.no-header-image #site-navigation .nav-menu-primary > li.menu-item');
	ananyapro_bind_fg_color_css( 'menu_item_color', '.no-header-image #site-navigation .nav-menu-primary > li.menu-item > a');
	ananyapro_bind_fg_color_css( 'menu_item_color', '.no-header-image #site-navigation .nav-menu-primary > li.page_item' );
	ananyapro_bind_fg_color_css( 'menu_item_color', '.no-header-image #site-navigation .nav-menu-primary > li.page_item > a');
	ananyapro_bind_fg_color_css( 'menu_item_color', '.no-header-image #site-navigation .header-social-menu ul' );
	ananyapro_bind_fg_color_css( 'menu_item_color', '.no-header-image #site-navigation .header-social-menu li a i' );
	ananyapro_bind_fg_color_css( 'menu_item_color', '.no-header-image #site-navigation .site-branding .site-title a' );
	ananyapro_bind_fg_color_css( 'menu_item_color', '.no-header-image #site-navigation .site-branding .site-description' );
	ananyapro_bind_fg_color_css( 'menu_item_color', '.no-header-image .navbar-light .navbar-toggler' );
	ananyapro_bind_fg_color_css( 'menu_item_color', '.no-header-image .main-navigation ul ul a' );
	ananyapro_bind_fg_color_css( 'menu_item_color', '.no-header-image .dropdown-toggle:hover' );
	ananyapro_bind_fg_color_css( 'menu_item_color', '.no-header-image .dropdown-toggle:focus' );
	ananyapro_bind_fg_color_css( 'menu_item_color', '.no-header-image .dropdown-toggle' );
	ananyapro_bind_fg_color_css( 'menu_item_color', '.no-header-image .menu-item-cart-icon i' );
	
	

	//Menu Background Color
	ananyapro_bind_bg_color_css( 'menu_bg_color', '.no-header-image #site-navigation' );
	ananyapro_bind_bg_color_css( 'menu_bg_color', '.no-header-image .main-navigation ul,.no-header-image .main-navigation ul ul');
	ananyapro_bind_bg_color_css( 'menu_bg_color', '.no-header-image #socialMenuResponsive,.no-header-image .dropdown-toggle,.no-header-image .dropdown-toggle:after');
	ananyapro_bind_bg_color_css( 'menu_bg_color', '.no-header-image #site-navigation' );

	//post meta color
	ananyapro_bind_fg_color_css( 'post_meta_color', '.entry-meta a,.footer-category-links a, .footer-category-links a:visited, .footer-category-links a:focus, .footer-tag-links a, .footer-tag-links a:visited, .footer-tag-links a:focus ' );
	ananyapro_bind_fg_color_css( 'post_meta_color', '.social-share a, .social-share a:visited, .social-share a:focus ' );
	ananyapro_bind_fg_color_css( 'post_meta_color', '.single-entry-meta a, .single-entry-meta a:visited' );
	ananyapro_bind_fg_color_css( 'post_meta_color', '.entry-meta, .single-entry-meta' );

	//post bg color
	ananyapro_bind_bg_color_css( 'post_bg_color', 'article, .post-navigation, .comments-area, .no-results,#secondary .widget, .pagination .page-numbers' );
	ananyapro_bind_bg_color_css( 'post_bg_color', '.blog-page-header, .archive-page-header, .search-page-header' );
	ananyapro_bind_bg_color_css( 'post_bg_color', '.single-product #main,.archive.woocommerce #main' );
	
	//footer colors
	ananyapro_bind_bg_color_css( 'footer_bg_color', '.site-footer,#footer' );
	ananyapro_bind_fg_color_css( 'footer_text_color', '.site-footer,  #footer, #footer caption');
	ananyapro_bind_fg_color_css( 'footer_heading_color','.site-footer h1, .site-footer h2,.site-footer h3,.site-footer h4,.site-footer h5,.site-footer h6,  #footer .widget-title' );
	ananyapro_bind_fg_color_css( 'footer_link_color', '.site-footer a, #footer .widget a');
	ananyapro_bind_border_color_css( 'footer_link_color', '#footer .widget-title');
	ananyapro_bind_border_color_css( 'footer_link_color', '#footer .widget_calendar table td, #footer .widget_calendar table th');
	ananyapro_bind_border_color_css( 'footer_link_color', '.site-info' );
	//frontpage bg color
	ananyapro_bind_bg_color_css( 'top_widget_section_bg_color', '#fp-widget-sec-top' );
	ananyapro_bind_bg_color_css( 'bottom_widget_section_bg_color', '#fp-widget-sec-bottom' );

	//frontpage button color
	ananyapro_bind_bg_color_css( 'frontpage_button_bg_color', '.featured-content-section .fp-btn-fill-straight,.featured-content-section .fp-btn-fill-slight-round,.featured-content-section .fp-btn-fill-round' );
	ananyapro_bind_bg_color_css( 'frontpage_button_bg_color', '.featured-page-section .fp-btn-fill-straight,.featured-page-section .fp-btn-fill-slight-round,.featured-page-section .fp-btn-fill-round' );
	ananyapro_bind_bg_color_css( 'frontpage_button_bg_color', '.featured-category-section .fp-btn-fill-straight,.featured-category-section .fp-btn-fill-slight-round,.featured-category-section .fp-btn-fill-round' );
	ananyapro_bind_bg_color_css( 'frontpage_button_bg_color', '.cta-section .fp-btn-fill-straight.cta-sec-btn1,.cta-section .fp-btn-fill-slight-round.cta-sec-btn1,.cta-section .fp-btn-fill-round.cta-sec-btn1' );
	ananyapro_bind_bg_color_css( 'frontpage_button_bg_color', '.latest-posts-section .fp-btn-fill-straight,.latest-posts-section .fp-btn-fill-slight-round,.latest-posts-section .fp-btn-fill-round' );
	ananyapro_bind_bg_color_css( 'frontpage_button_bg_color', '.ananyapro-front-page .hero-btn-color-fill-straight,.ananyapro-front-page .hero-btn-color-fill-slight-round,.ananyapro-front-page .hero-btn-color-fill-round' );

	//border color
	ananyapro_bind_border_color_css( 'frontpage_button_border_color', '.featured-content-section .fp-btn-fill-straight,.featured-content-section .fp-btn-fill-slight-round,.featured-content-section .fp-btn-fill-round' );
	ananyapro_bind_border_color_css( 'frontpage_button_border_color', '.featured-content-section .fp-btn-border-straight,.featured-content-section .fp-btn-border-slight-round,.featured-content-section .fp-btn-border-round' );
	ananyapro_bind_border_color_css( 'frontpage_button_border_color', '.featured-page-section .fp-btn-fill-straight,.featured-page-section .fp-btn-fill-slight-round,.featured-page-section .fp-btn-fill-round' );
	ananyapro_bind_border_color_css( 'frontpage_button_border_color', '.featured-page-section .fp-btn-border-straight,.featured-page-section .fp-btn-border-slight-round,.featured-page-section .fp-btn-border-round' );
	ananyapro_bind_border_color_css( 'frontpage_button_border_color', '.featured-category-section .fp-btn-fill-straight,.featured-category-section .fp-btn-fill-slight-round,.featured-category-section .fp-btn-fill-round' );
	ananyapro_bind_border_color_css( 'frontpage_button_border_color', '.featured-category-section .fp-btn-border-straight,.featured-category-section .fp-btn-border-slight-round,.featured-category-section .fp-btn-border-round' );
	ananyapro_bind_border_color_css( 'frontpage_button_border_color', '.cta-section .fp-btn-fill-straight.cta-sec-btn1,.cta-section .fp-btn-fill-slight-round.cta-sec-btn1,.cta-section .fp-btn-fill-round.cta-sec-btn1' );
	ananyapro_bind_border_color_css( 'frontpage_button_border_color', '.cta-section .fp-btn-border-straight.cta-sec-btn1,.cta-section .fp-btn-border-slight-round.cta-sec-btn1,.cta-section .fp-btn-border-round.cta-sec-btn1' );
	ananyapro_bind_border_color_css( 'frontpage_button_border_color', '.latest-posts-section .fp-btn-fill-straight,.latest-posts-section .fp-btn-fill-slight-round,.latest-posts-section .fp-btn-fill-round' );
	ananyapro_bind_border_color_css( 'frontpage_button_border_color', '.latest-posts-section .fp-btn-border-straight,.latest-posts-section .fp-btn-border-slight-round,.latest-posts-section .fp-btn-border-round' );
	ananyapro_bind_border_color_css( 'frontpage_button_border_color', '.ananyapro-front-page .hero-btn-color-border-straight,.ananyapro-front-page .hero-btn-color-border-slight-round,.ananyapro-front-page .hero-btn-color-border-round' );

	ananyapro_bind_border_color_css( 'frontpage_button_border_color','.ananyapro-front-page .hero-btn-accent-color' );
	ananyapro_bind_border_color_css( 'frontpage_button_border_color','.featured-content-section .fp-btn-underline,.featured-page-section .fp-btn-underline,.featured-category-section .fp-btn-underline,.cta-section .fp-btn-underline.cta-sec-btn1,.latest-posts-section .fp-btn-underline' );

	//Frontpage Button Text color
	ananyapro_bind_fg_color_css( 'frontpage_button_text_color', '.featured-content-section .fp-btn-fill-straight,.featured-content-section .fp-btn-fill-slight-round,.featured-content-section .fp-btn-fill-round' );
	ananyapro_bind_fg_color_css( 'frontpage_button_text_color', '.featured-content-section .fp-btn-border-straight,.featured-content-section .fp-btn-border-slight-round,.featured-content-section .fp-btn-border-round' );
	ananyapro_bind_fg_color_css( 'frontpage_button_text_color', '.featured-page-section .fp-btn-fill-straight,.featured-page-section .fp-btn-fill-slight-round,.featured-page-section .fp-btn-fill-round' );
	ananyapro_bind_fg_color_css( 'frontpage_button_text_color', '.featured-page-section .fp-btn-border-straight,.featured-page-section .fp-btn-border-slight-round,.featured-page-section .fp-btn-border-round' );
	ananyapro_bind_fg_color_css( 'frontpage_button_text_color', '.featured-category-section .fp-btn-fill-straight,.featured-category-section .fp-btn-fill-slight-round,.featured-category-section .fp-btn-fill-round' );
	ananyapro_bind_fg_color_css( 'frontpage_button_text_color', '.featured-category-section .fp-btn-border-straight,.featured-category-section .fp-btn-border-slight-round,.featured-category-section .fp-btn-border-round' );
	ananyapro_bind_fg_color_css( 'frontpage_button_text_color', '.cta-section .fp-btn-fill-straight.cta-sec-btn1,.cta-section .fp-btn-fill-slight-round.cta-sec-btn1,.cta-section .fp-btn-fill-round.cta-sec-btn1' );
	ananyapro_bind_fg_color_css( 'frontpage_button_text_color', '.cta-section .fp-btn-border-straight.cta-sec-btn1,.cta-section .fp-btn-border-slight-round.cta-sec-btn1,.cta-section .fp-btn-border-round.cta-sec-btn1' );
	ananyapro_bind_fg_color_css( 'frontpage_button_text_color', '.latest-posts-section .fp-btn-fill-straight,.latest-posts-section .fp-btn-fill-slight-round,.latest-posts-section .fp-btn-fill-round' );
	ananyapro_bind_fg_color_css( 'frontpage_button_text_color', '.latest-posts-section .fp-btn-border-straight,.latest-posts-section .fp-btn-border-slight-round,.latest-posts-section .fp-btn-border-round' );
	ananyapro_bind_fg_color_css( 'frontpage_button_text_color','.ananyapro-front-page .hero-btn-accent-color' );
	ananyapro_bind_fg_color_css( 'frontpage_button_text_color','.featured-content-section .fp-btn-underline,.featured-page-section .fp-btn-underline,.featured-category-section .fp-btn-underline,.cta-section .fp-btn-underline.cta-sec-btn1,.latest-posts-section .fp-btn-underline' );

	ananyapro_bind_fg_color_css( 'frontpage_sec_name_text_color', '.frontpage-section .sec-name');
	ananyapro_bind_fg_color_css( 'frontpage_sec_tagline_text_color','.frontpage-section .sec-tagline');
	ananyapro_bind_bg_color_css( 'recent_post_sec_bg_color', '.latest-posts-section' );
	ananyapro_bind_to_text( 'recent_post_sec_name', '.latest-posts-section .sec-name' );
	ananyapro_bind_to_text( 'recent_post_sec_title', '.latest-posts-section .sec-title' );
	ananyapro_bind_to_text( 'recent_post_sec_tagline', '.latest-posts-section .sec-tagline' );
	ananyapro_bind_to_text( 'view_blog_button_text', '.latest-posts-section .view-blog-wrap a' );

	ananyapro_bind_bg_color_css( 'showcase_cat_sec_bg_color', '.showcase-categories-section' );
	ananyapro_bind_to_text( 'showcase_cat_sec_name', '.showcase-categories-section .sec-name' );
	ananyapro_bind_to_text( 'showcase_cat_sec_title', '.showcase-categories-section .sec-title' );
	ananyapro_bind_to_text( 'showcase_cat_sec_tagline', '.showcase-categories-section .sec-tagline' );
	

	for( sec_no=1; sec_no<=2; sec_no++ ) {

		//Category Section
		ananyapro_bind_bg_color_css( 'content_section_bg_color_sec_'+sec_no, '#feat-content-sec-'+sec_no);
		ananyapro_bind_bg_color_css( 'category_section_bg_color_sec_'+sec_no, '#feat-cat-sec-'+sec_no );
		ananyapro_bind_bg_color_css( 'page_section_bg_color_sec_'+sec_no, '#feat-pages-sec-'+sec_no );
		ananyapro_bind_to_text( 'cat_section_name_sec'+sec_no, '#feat-cat-sec-'+sec_no+' .sec-name' );
		ananyapro_bind_to_text( 'cat_title_sec'+sec_no, '#feat-cat-sec-'+sec_no+' .sec-title' );
		ananyapro_bind_to_text( 'cat_tagline_sec'+sec_no, '#feat-cat-sec-'+sec_no+' .sec-tagline' );
		ananyapro_bind_to_text(  'cat_sec_button_text_'+sec_no, '#feat-cat-sec-'+sec_no+' .cat-view-more-link' );
		
		ananyapro_hide_show_elements( 'hide_cat_post_date_'+sec_no, '#feat-cat-sec-'+sec_no+' .entry-date' );
		ananyapro_hide_show_elements( 'hide_cat_sec_post_excerpt_'+sec_no, '#feat-cat-sec-'+sec_no+' .cat-post-excerpt' );
		ananyapro_hide_show_elements( 'hide_cat_sec_view_more_link_'+sec_no, '#feat-cat-sec-'+sec_no+' .cat-view-more' );
			
		//CTA section
		ananyapro_bind_bg_color_css( 'cta_bg_color_sec'+sec_no, '#cta-sec-'+sec_no );
		ananyapro_bind_to_text( 'cta_section_name_sec'+sec_no, '#cta-sec-'+sec_no+' .sec-name');
		ananyapro_bind_to_text( 'cta_title_sec'+sec_no, '#cta-sec-'+sec_no+' .sec-title');
		ananyapro_bind_to_text( 'cta_tagline_sec'+sec_no, '#cta-sec-'+sec_no+' .sec-tagline');
		ananyapro_bind_to_text( 'cta_content_sec'+sec_no, '#cta-sec-'+sec_no+' .cta-content');
		
		ananyapro_bind_to_url( 'cta_button1_url_sec'.sec_no, '#cta-sec-'+sec_no+' .cta-sec-btn1 a');
		ananyapro_bind_to_url( 'cta_button2_url_sec'.sec_no, '#cta-sec-'+sec_no+' .cta-sec-btn2 a');
		
		ananyapro_bind_fg_color_css( 'frontpage_button_text_color', '#cta-sec-'+sec_no+'.dark  .cta-sec-btn1 a, #cta-sec-'+sec_no+'.dark .cta-sec-btn1 a:visited');
		ananyapro_bind_fg_color_css( 'frontpage_button_border_color','#cta-sec-'+sec_no+'.dark  .cta-sec-btn1.fp-btn-underline a, #cta-sec-'+sec_no+'.dark .cta-sec-btn1.fp-btn-underline a:visited' );
		
		//featured content section
		ananyapro_bind_to_text( 'feat_content_section_name_sec'+sec_no, '#feat-content-sec-'+sec_no+' .sec-name' );
		ananyapro_bind_to_text( 'feat_content_title_sec'+sec_no, '#feat-content-sec-'+sec_no+' .sec-title' );
		ananyapro_bind_to_text( 'feat_content_tagline_sec'+sec_no, '#feat-content-sec-'+sec_no+' .sec-tagline' );
		ananyapro_bind_to_text( 'feat_content_sec'+sec_no, '#feat-content-sec-'+sec_no+' .featured-content' );
		
		ananyapro_bind_to_url( 'feat_button_url_sec'+sec_no, '#feat-content-sec-'+sec_no+' .feat-sec-btn a' )
		ananyapro_bind_image_position( 'feat_content_image_position'+sec_no,sec_no );
		ananyapro_bind_feature_img_src('feat_image_sec'+sec_no,'#feat-content-sec-'+sec_no+' .featured-image img');
		
		//featured pages
		ananyapro_bind_to_text( 'pages_sec_name_'+sec_no, '#feat-pages-sec-'+sec_no+' .sec-name' );
		ananyapro_bind_to_text( 'pages_sec_title_'+sec_no, '#feat-pages-sec-'+sec_no+' .sec-title' );
		ananyapro_bind_to_text( 'pages_sec_tagline_'+sec_no, '#feat-pages-sec-'+sec_no+' .sec-tagline' );
		
		ananyapro_bind_to_text( 'page1_excerpt_sec'+sec_no, '#feat-page-1-sec-'+sec_no+' .page-excerpt' );
		ananyapro_bind_to_text( 'page2_excerpt_sec'+sec_no, '#feat-page-2-sec-'+sec_no+' .page-excerpt' );
		ananyapro_bind_to_text( 'page3_excerpt_sec'+sec_no, '#feat-page-3-sec-'+sec_no+' .page-excerpt' );
	}

	//body font size 
	ananyapro_bind_typography_css( 'body_font_size_desktop', 'body', 'desktop', 'font-size', 'px' );
	ananyapro_bind_typography_css( 'body_font_size_mobile', 'body', 'mobile', 'font-size', 'px' );
	ananyapro_bind_typography_css( 'body_line_height', 'body', 'desktop', 'line-height', '' );
	ananyapro_bind_typography_css( 'body_text_alignment', 'body', '', 'text-align', '' );

	//post title font size
	ananyapro_bind_typography_css( 'hero_title_font_size_desktop', '.custom-heading .hero-title', 'desktop', 'font-size', 'em' );
	ananyapro_bind_typography_css( 'hero_title_font_size_mobile', '.custom-heading .hero-title', 'mobile', 'font-size', 'em' );
	ananyapro_bind_typography_css( 'hero_subtitle_font_size_desktop', '.custom-heading .subheading', 'desktop', 'font-size', 'px' );
	ananyapro_bind_typography_css( 'hero_subtitle_font_size_mobile', '.custom-heading .subheading', 'mobile', 'font-size', 'px' );

	//post title font size
	ananyapro_bind_typography_css( 'post_title_font_size_desktop', '.blog .entry-title, .blog .blog-layout-list-1 article .entry-title, .archive .blog-layout-list-1 article .entry-title, .search .blog-layout-list-1 article .entry-title', 'desktop', 'font-size', 'em' );
	ananyapro_bind_typography_css( 'post_title_font_size_mobile', '.blog .entry-title, .blog .blog-layout-list-1 article .entry-title, .archive .blog-layout-list-1 article .entry-title, .search .blog-layout-list-1 article .entry-title', 'mobile', 'font-size', 'em' );
	ananyapro_bind_typography_css( 'post_title_line_height', '.entry-title', '', 'line-height', '' );
	ananyapro_bind_typography_css( 'post_title_letter_spacing', '.blog .entry-title, .blog .entry-title a', '', 'letter-spacing', 'px' );
	ananyapro_bind_typography_css( 'blog_post_title_transform', '.entry-title, .entry-title a', '', 'text-transform', '' );

	//menu items
	ananyapro_bind_typography_css( 'menu_font_size', '#nav-menu-primary a', 'desktop', 'font-size', 'px' );
	ananyapro_bind_typography_css( 'menu_item_letter_spacing', '#nav-menu-primary a', 'desktop', 'letter-spacing', 'px' );
	ananyapro_bind_typography_css( 'menu_item_transform', '#nav-menu-primary a', '', 'text-transform', '' );
	
	//heading letter spacing
	ananyapro_bind_typography_css( 'heading_line_height', 'h1,h2,h3,h4,h5,h6', '', 'line-height', '' );
	ananyapro_bind_typography_css( 'heading_letter_spacing', 'h1,h2,h3,h4,h5,h6', '', 'letter-spacing', 'px' );

	//heading font size
	for( i = 1; i <= 6; i++ ){
		ananyapro_bind_typography_css( 'heading'+i+'_font_size_desktop', 'h'+i, 'desktop', 'font-size', 'em' );
		ananyapro_bind_typography_css( 'heading'+i+'_font_size_mobile', 'h'+i, 'mobile', 'font-size', 'em' );
	}

	//
	wp.customize( 'header_image', function( value ) {
		value.bind( function( to ) {
			
			var image = wp.customize( 'header_image' )();
			var video = wp.customize( 'header_video' )();

			if( !hasHeaderImage() && !hasHeaderVideo() ) {
				$('#masthead').removeClass( 'has-header-image' );
				$('#masthead').addClass( 'no-header-image' );
				$('.no-header-image .custom-header').css({
					'display':'none'
				});
				$('.no-header-image #site-navigation').css({
					'background-image': 'none'
				});
			} else if( hasHeaderVideo() && !hasHeaderImage() ) {
				$('#masthead').removeClass( 'has-header-image' );
			} else if( hasHeaderImage() ) {
				$('#masthead').addClass( 'has-header-image');
				$('#masthead').removeClass( 'no-header-image' );
				$('.has-header-image .custom-header').css({
					'display':'block'
				});
			}
		} );	
	} );

	wp.customize( 'header_video', function( value ) {
		value.bind( function( to ) {
			
			var image = wp.customize( 'header_image' )();
			var video = wp.customize( 'header_video' )();
			var externalVideo = wp.customize( 'external_header_video' )();

			if ( !hasHeaderImage() && !hasHeaderVideo() ) {
				$('#masthead').removeClass( 'has-header-video' );
				$('#masthead').addClass( 'no-header-image' );
				$('.no-header-image .custom-header').css({
					'display':'none'
				});
				$('.no-header-image #site-navigation').css({
					'background-image': 'none'
				});
			} else if( hasHeaderImage() ){
				$('#masthead').removeClass( 'has-header-video' );
			} else if( hasHeaderVideo() ) {
				$('#masthead').removeClass( 'no-header-image' );
				$('#masthead').addClass( 'has-header-video' );
				$('.has-header-video .custom-header').css({
					'display':'block'
				});
			}
		} );	
	} );

	//frontpage bind button style
	wp.customize( 'ananyapro_frontpage_button_style', function( value ) {
		value.bind( function( to ) {
			var classList = $('.feat-sec-btn' ).attr("class");
			var fp_btn = $('.frontpage-section').find('button');
	
			if( fp_btn.hasClass('fp-btn-fill-straight') ) {
				fp_btn.removeClass('fp-btn-fill-straight');
			} else if( fp_btn.hasClass('fp-btn-fill-slight-round') ) {
				fp_btn.removeClass('fp-btn-fill-slight-round');
			} else if( fp_btn.hasClass('fp-btn-fill-round') ) {
				fp_btn.removeClass('fp-btn-fill-round');
			} else if( fp_btn.hasClass('fp-btn-underline') ) {
				fp_btn.removeClass('fp-btn-underline');
			} else if( fp_btn.hasClass('fp-btn-border-straight') ) {
				fp_btn.removeClass('fp-btn-border-straight');
			} else if( fp_btn.hasClass('fp-btn-border-slight-round') ) {
				fp_btn.removeClass('fp-btn-border-slight-round');
			} else if( fp_btn.hasClass('fp-btn-border-round') ) {
				fp_btn.removeClass('fp-btn-border-round');
			}
			fp_btn.addClass(to);
			$('.fp-btn-border-straight,.fp-btn-border-slight-round,.fp-btn-border-round').css({
				'background-color':'transparent'
			});
			$('.fp-btn-fill-straight,.fp-btn-fill-slight-round,.fp-btn-fill-round').css({
				'background-color':''
			});
		});
	});

	//hero image bind button style
	// wp.customize( 'ananyapro_header_button1_style', function( value ) {
	// 	value.bind( function( to ) {
	// 		var hero_btn = $('.custom-heading').find('#hero-section-btn1');
	// 		var btnClassList = [ 'hero-btn-fill-straight','hero-btn-fill-slight-round',
	// 		'hero-btn-fill-round','hero-btn-border-straight',
	// 		'hero-btn-border-slight-round','hero-btn-border-round',
	// 		'hero-btn-underline','hero-btn-color-fill-straight','hero-btn-color-fill-slight-round','hero-btn-color-fill-round'];
	// 		btnClassList.forEach( (btnClass) =>  {
	// 			if( hero_btn.hasClass(btnClass) ) {
	// 			hero_btn.removeClass(btnClass);
	// 			}
	// 		});
	// 		hero_btn.addClass(to);
	// 	});
	// });

	// //hero image bind button style
	// wp.customize( 'ananyapro_header_button2_style', function( value ) {
	// 	value.bind( function( to ) {
	// 		var hero_btn = $('.custom-heading').find('#hero-section-btn2');
	// 		var btnClassList = [ 'hero-btn-fill-straight','hero-btn-fill-slight-round',
	// 		'hero-btn-fill-round','hero-btn-border-straight',
	// 		'hero-btn-border-slight-round','hero-btn-border-round',
	// 		'hero-btn-underline','hero-btn-color-fill-straight','hero-btn-color-fill-slight-round','hero-btn-color-fill-round' ];
	// 		btnClassList.forEach( (btnClass) =>  {
	// 			if( hero_btn.hasClass(btnClass) ) {
	// 			hero_btn.removeClass(btnClass);
	// 			}
	// 		});
	// 		hero_btn.addClass(to);
	// 	});
	// });

	//hero image bind button style
	wp.customize( 'ananyapro_post_read_more_btn_style', function( value ) {
		value.bind( function( to ) {
			var more_btn = $('.entry-read-more').find('span');
			var btnClassList = [ 'more-btn-fill-straight','more-btn-fill-slight-round',
			'more-btn-fill-round','more-btn-border-straight',
			'more-btn-border-slight-round','more-btn-border-round',
			'more-btn-underline','more-btn-fill-gray-color','more-btn-border-gray-color'];
			btnClassList.forEach( (btnClass) =>  {
				if( more_btn.hasClass(btnClass) ) {
				more_btn.removeClass(btnClass);
				}
			});
			more_btn.addClass(to);
		});
	});

	//header text align style
	wp.customize( 'ananyapro_header_text_alignment', function( value ) {
		value.bind( function( to ) {
			var header_text = $('.custom-heading .col-md-8');
			var alignClassList = ['text-left','text-center','text-right'];
			var justifyClass = ['justify-content-start','justify-content-center','justify-content-end'];
			alignClassList.forEach( (alignClass,i) =>  {
				if( header_text.hasClass(alignClass) ) {
					header_text.removeClass(alignClass);
					header_text.parent().removeClass(justifyClass[i]);
				}
			});
			alignClassList.forEach( (alignClass,i) =>  {
				if( alignClass == to ){
					header_text.addClass(to);
					header_text.parent().addClass(justifyClass[i]);
				}
			});
		});
	});

	//header text align style
	wp.customize( 'ananyapro_header_vertical_text_alignment', function( value ) {
		value.bind( function( to ) {
			var col_div = $('.custom-heading');
			var valignClassList = ['h-top','h-center','h-bottom'];
			valignClassList.forEach( (valignClass) =>  {
				if( col_div.hasClass(valignClass) ) {
					col_div.removeClass(valignClass);
				}
			});
			col_div.addClass(to);
		});
	});

	
	function ananyapro_bind_feature_img_src( id, selectors ) {
		wp.customize( 'ananyapro_'+id, function( value ) {
			value.bind( function( to ) {
				$( selectors ).attr('src',to);
			});
		});
	}
	function ananyapro_bind_bg_color_css( id, selectors ) {
		wp.customize( 'ananyapro_'+id, function( value ) {
			value.bind( function( to ) {
				$( selectors ).css( {
					'background-color':  to
				});
			});
		});
	}

	function ananyapro_bind_fg_color_css( id, selectors ) {
		wp.customize( 'ananyapro_'+id, function( value ) {
			value.bind( function( to ) {
				$( selectors ).css( {
					'color':  to
				});
			});
		});
	}

	function ananyapro_bind_border_color_css( id, selectors ) {
		wp.customize( 'ananyapro_'+id, function( value ) {
			value.bind( function( to ) {
				$( selectors ).css( {
					'border-color':  to
				});
			});
		});
	}

	function ananyapro_bind_to_text( id, selectors ) {
		wp.customize( 'ananyapro_'+id, function( value ) {
			value.bind( function( to ) {
				$( selectors ).text(to);
			});
		});
	}
	
	function ananyapro_bind_to_url( id, selectors ) {
		wp.customize( 'ananyapro_'+id, function( value ) {
			value.bind( function( to ) {
				$( selectors ).attr('href',to);
			});
		});
	}

	function ananyapro_hide_show_elements( id, selectors ) {
		wp.customize( 'ananyapro_'+id, function( value ) {
			value.bind( function( to ) {
				$( selectors ).toggleClass('hide');
			});
		});
	}

	function ananyapro_make_visible( id, selectors, visiblityclass ) {
		wp.customize( 'ananyapro_'+id, function( value ) {
			value.bind( function( to ) {
				$( selectors ).removeClass( classtoremove );
			});
		});
	}

	function ananyapro_bind_typography_css( id, selector, device, property, unit ) {
		//Body mobile font size
		wp.customize( 'ananyapro_'+id, function( value ) {
			value.bind( function( to ) {
				var media_query_start = '';
				var media_query_end = '';
				
				if( 'tablet' === device ) {
					media_query_start = '@media screen and (min-width: 768px) and (max-width: 1024px) {';
					media_query_end = '}';
				} else if( 'mobile' === device ) {
					media_query_start = '@media screen and (max-width: 767px) {';
					media_query_end = '}';
				} else if( 'desktop' === device ) {
					media_query_start = '@media screen and (min-width: 1025px) {';
					media_query_end = '}';
				} else {
					media_query_start = '';
					media_query_end = '';
				}
				
				if ( jQuery( 'style.' + id ).length ) {
					jQuery( 'style.' + id ).remove();
				}
				jQuery( 'head' ).append('<style class ="'+id+ '">' +  media_query_start + selector + ' { ' + property + ': ' + to + unit + ';}' + media_query_end + '</style>'); 
			} );
		} );
	}

	// Whether a header image is available.
	function hasHeaderImage() {
		var image = wp.customize( 'header_image' )();
		return '' !== image && 'remove-header' !== image;
	}

	// Whether a header video is available.
	function hasHeaderVideo() {
		var externalVideo = wp.customize( 'external_header_video' )(),
			video = wp.customize( 'header_video' )();

		return '' !== externalVideo || ( 0 !== video && '' !== video );
	}

	function ananyapro_bind_image_position( id, sec_no) {
		wp.customize( 'ananyapro_'+id, function( value ) {
			value.bind( function( to ) {
				var sec_div = $('#feat-content-sec-'+sec_no);
				var image_div = $('#feat-content-sec-'+sec_no+' .featured-image');
				var content_div = $('#feat-content-sec-'+sec_no+'  .featured-content-wrap');

				var alignClassList = ['items-right','items-left','items-center'];
				var col_class = [ 'col-md-6', 'col-md-6', 'col-md-12' ];
				var col_order_class = ['',' order-md-6',' order-md-12'];
				
				sec_item_align = 'items-'+to;
				
				alignClassList.forEach( (alignClass,i) =>  {
					if( sec_div.hasClass(alignClass) ) {
						sec_div.removeClass(alignClass);
						image_div.removeClass(col_class[i]);
						content_div.removeClass(col_class[i]);
						content_div.removeClass(col_order_class[i]);
					}
				});
				
				alignClassList.forEach( (alignClass,i) =>  {
					if( sec_item_align === alignClass ) {
						sec_div.addClass(sec_item_align);
						image_div.addClass(col_class[i]);
						content_div.addClass(col_class[i]);
						content_div.addClass(col_order_class[i]);
					}
				});
				
			});
		});
	}
} )( jQuery );