/**
 *
 * Theme Customizer enhancements for a better user experience.
 *
 * Contains handlers to make frontpage sections sortable.
 */
jQuery(document).ready(function ($) {

    //Homepage Section Sortable
    function ananyapro_sections_order(container) {
        
        var sections = $(container).sortable('toArray');
       
        var sec_ordered = [];
        $.each(sections, function (index, sec_id) {
            sec_id = sec_id.replace("accordion-section-", "");
            sec_ordered.push(sec_id);
        });
        

        $.ajax({
            url: ananyapro_ajax_object.ajax_url,
            
            type: 'post',
            dataType: 'html',
            data: {
                'action': 'ananyapro_order_sections',
                'sections': sec_ordered,
                'ananyapro_secure_ajax_nonce': ananyapro_ajax_object.security,
            }
        }).done(function (data) {
            $.each(sec_ordered, function (key, value) {
                wp.customize.section(value).priority(key);
            });
            $(container).find('.ananyapro-drag-spinner').hide();
            wp.customize.previewer.refresh();
        });
    }
    $('#sub-accordion-panel-ananyapro_frontpage_panel').sortable({
        axis: 'y',
        helper: 'clone',
        cursor: 'move',
        items: '> li.control-section:not(#accordion-section-ananyapro_featured_genral_settings_section)',
        delay: 150,
        update: function (event, ui) {
            $('#sub-accordion-panel-ananyapro_frontpage_panel').find('.ananyapro-drag-spinner').show();
            ananyapro_sections_order('#sub-accordion-panel-ananyapro_frontpage_panel');
            $('.wp-full-overlay-sidebar-content').scrollTop(0);
        }
    });
});