<?php
/**
 * The template for displaying the footer
 *
 * Contains the closing of the #content div and all content after.
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package AnanyaPRO
 * @since 1.0
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}
$show_scroll_to_top = get_theme_mod( 'ananyapro_show_scroll_to_top', false );
?>

	</div><!-- content -->

	<footer id="colophon" class="site-footer">
		<?php if ( is_active_sidebar( 'ananyapro-footer-widget-area-left' ) || is_active_sidebar( 'ananyapro-footer-widget-area-center' ) || is_active_sidebar( 'ananyapro-footer-widget-area-right' ) ) : ?>
		<div id="footer" class="footer-widget-area">
			<div class="container">
				<div class="row">	
					<div class="col-md-4"><?php dynamic_sidebar( 'ananyapro-footer-widget-area-left' ); ?></div>
					<div class="col-md-4"><?php dynamic_sidebar( 'ananyapro-footer-widget-area-center' ); ?></div>
					<div class="col-md-4"><?php dynamic_sidebar( 'ananyapro-footer-widget-area-right' ); ?></div>
				</div><!-- row -->
			</div><!-- container -->
		</div><!-- footer-widget-area -->
		<?php endif; ?>
		<div class="site-info">
			<div class="site-info-container">
				<?php ananyapro_print_footer_credit_text(); ?>
			</div><!-- site-info-container -->
			<!-- Scroll Top Button -->
			<?php if ( $show_scroll_to_top === true ) : ?>
			<button class="scrolltop">
				<i class="fas fa-angle-up"></i>
			</button>
			<?php endif; ?>
		</div><!-- site-info -->
	</footer><!-- #colophon -->
</div><!-- page -->

<?php wp_footer(); ?>

</body>
</html>
