<?php
/**
 * AnanyaPRO functions and definitions
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package AnanyaPRO
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

if ( ! defined( 'ANANYAPRO_VERSION' ) ) {
	define( 'ANANYAPRO_VERSION', '1.0' );
}

if ( ! defined( 'ANANYAPRO_AUTHOR' ) ) {
	define( 'ANANYAPRO_AUTHOR', 'Falguni Desai' );
}
define( 'ANANYAPRO_PHP_INCLUDE', trailingslashit( get_template_directory() ) . 'inc/' );
define( 'ANANYAPRO_CUSTOMIZER_INCLUDES', ANANYAPRO_PHP_INCLUDE . 'customizer/includes/' );


if ( ! function_exists( 'ananyapro_setup' ) ) :
	/**
	 * Sets up theme defaults and registers support for various WordPress features.
	 *
	 * Note that this function is hooked into the after_setup_theme hook, which
	 * runs before the init hook. The init hook is too late for some features, such
	 * as indicating support for post thumbnails.
	 */
	function ananyapro_setup() {
		/*
		 * Make theme available for translation.
		 * Translations can be filed in the /languages/ directory.
		 * If you're building a theme based on AnanyaPRO, use a find and replace
		 * to change 'ananyapro' to the name of your theme in all the template files.
		 */
		load_theme_textdomain( 'ananyapro', get_template_directory() . '/languages' );

		// Add default posts and comments RSS feed links to head.
		add_theme_support( 'automatic-feed-links' );

		/*
		 * Let WordPress manage the document title.
		 * By adding theme support, we declare that this theme does not use a
		 * hard-coded <title> tag in the document head, and expect WordPress to
		 * provide it for us.
		 */
		add_theme_support( 'title-tag' );

		/*
		 * Enable support for Post Thumbnails on posts and pages.
		 *
		 * @link https://developer.wordpress.org/themes/functionality/featured-images-post-thumbnails/
		 */
		add_theme_support( 'post-thumbnails' );

		// This theme uses wp_nav_menu() in one location.
		register_nav_menus( array(
			'primary-menu' => esc_html__( 'Primary Menu', 'ananyapro' ),
		) );

		/*
		 * Switch default core markup for search form, comment form, and comments
		 * to output valid HTML5.
		 */
		add_theme_support( 'html5', array(
			'search-form',
			'comment-form',
			'comment-list',
			'gallery',
			'caption',
		) );

		$defaults = ananyapro_get_defaults();
		
		// Set up the WordPress core custom background feature.
		add_theme_support( 'custom-background', apply_filters( 'ananyapro_custom_background_args', array(
			'default-color' => $defaults['body_bg_color'],
			'default-image' => '',
		) ) );

		// Add theme support for selective refresh for widgets.
		add_theme_support( 'customize-selective-refresh-widgets' );

		/**
		 * Add support for core custom logo.
		 *
		 * @link https://codex.wordpress.org/Theme_Logo
		 */
		add_theme_support( 'custom-logo', array(
			'height'      => 250,
			'width'       => 250,
			'flex-width'  => true,
			'flex-height' => true,
		) );

		add_image_size( 'ananyapro-prevnext-thumbnail', 80, 80, true );              /* Previous/Next Post navigation */

		add_theme_support( 'woocommerce' );
	}
endif;
add_action( 'after_setup_theme', 'ananyapro_setup' );

/**
 * Set the content width in pixels, based on the theme's design and stylesheet.
 *
 * Priority 0 to make it available to lower priority callbacks.
 *
 * @global int $content_width
 */
function ananyapro_content_width() {
	// This variable is intended to be overruled from themes.
	// Open WPCS issue: {@link https://github.com/WordPress-Coding-Standards/WordPress-Coding-Standards/issues/1043}.
	// phpcs:ignore WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound
	$GLOBALS['content_width'] = apply_filters( 'ananyapro_content_width', 640 );
}
add_action( 'after_setup_theme', 'ananyapro_content_width', 0 );

/**
 * Register widget area.
 *
 * @link https://developer.wordpress.org/themes/functionality/sidebars/#registering-a-sidebar
 */
function ananyapro_widgets_init() {
	//Register for sidebar widget area.
	register_sidebar( array(
		'name'          => esc_html__( 'Sidebar', 'ananyapro' ),
		'id'            => 'ananyapro-sidebar-1',
		'description'   => esc_html__( 'Add widgets here.', 'ananyapro' ),
		'before_widget' => '<section id="%1$s" class="widget %2$s">',
		'after_widget'  => '</section>',
		'before_title'  => '<h2 class="widget-title">',
		'after_title'   => '</h2>',
	) );

	//Regsiger fotter widget area left
	register_sidebar( array(
		'name'          => esc_html__( 'Footer Widget Area - Left', 'ananyapro' ),
		'id'            => 'ananyapro-footer-widget-area-left',
		'description'   => esc_html__( 'Add widgets here.', 'ananyapro' ),
		'before_widget' => '<aside id="%1$s" class="widget %2$s">',
		'after_widget'  => '</aside>',
		'before_title'  => '<h2 class="widget-title"><span>',
		'after_title'   => '</span></h2>',
	) );
	//Regsiger fotter widget area center
	register_sidebar( array(
		'name'          => esc_html__( 'Footer Widget Area - Center', 'ananyapro' ),
		'id'            => 'ananyapro-footer-widget-area-center',
		'description'   => esc_html__( 'Add widgets here.', 'ananyapro' ),
		'before_widget' => '<aside id="%1$s" class="widget %2$s">',
		'after_widget'  => '</aside>',
		'before_title'  => '<h2 class="widget-title"><span>',
		'after_title'   => '</span></h2>',
	) );
	//Regsiger footer widget area Right
	register_sidebar( array(
		'name'          => esc_html__( 'Footer Widget Area - Right', 'ananyapro' ),
		'id'            => 'ananyapro-footer-widget-area-right',
		'description'   => esc_html__( 'Add widgets here.', 'ananyapro' ),
		'before_widget' => '<aside id="%1$s" class="widget %2$s">',
		'after_widget'  => '</aside>',
		'before_title'  => '<h2 class="widget-title"><span>',
		'after_title'   => '<span></h2>',
	) );
	//Regsiger frontpage top  widget area Right
	register_sidebar( array(
		'name'          => esc_html__( 'Frontpage Top Widget Area', 'ananyapro' ),
		'id'            => 'ananyapro-frontpage-widget-area-top',
		'description'   => esc_html__( 'Add widgets here.', 'ananyapro' ),
		'before_widget' => '<aside id="%1$s" class="widget %2$s">',
		'after_widget'  => '</aside>',
		'before_title'  => '<div class="section-header"><h2 class="frontpage-widget-title"><span>',
		'after_title'   => '<span></h2><div class="sec-divider">
				<div class="sec-divider-internal"></div></div></div>',
	) );
	//Regsiger frontpage bottom widget area Right
	register_sidebar( array(
		'name'          => esc_html__( 'Frontpage Bottom Widget Area', 'ananyapro' ),
		'id'            => 'ananyapro-frontpage-widget-area-bottom',
		'description'   => esc_html__( 'Add widgets here.', 'ananyapro' ),
		'before_widget' => '<aside id="%1$s" class="widget %2$s">',
		'after_widget'  => '</aside>',
		'before_title'  => '<div class="section-header"><h2 class="frontpage-widget-title"><span>',
		'after_title'   => '<span></h2><div class="sec-divider">
				<div class="sec-divider-internal"></div></div></div>',
	) );
}
add_action( 'widgets_init', 'ananyapro_widgets_init' );

/**
 * Enqueue scripts and styles.
 */
function ananyapro_scripts() {
	//Enqueue bootstrap style
	wp_enqueue_style( 'ananyapro-bootstrap-style',  get_template_directory_uri().'/assets/bootstrap/css/bootstrap.min.css' );
	
	//Enqueue fontawesome style
	wp_enqueue_style( 'ananyapro-fontawesome-style',  get_template_directory_uri().'/assets/font-awesome/css/all.min.css' );
	//Enqueue v4 compatibility fontawesome style 
	wp_enqueue_style( 'ananyapro-fontawesome-style',  get_template_directory_uri().'/assets/font-awesome/css/v4-shims.min.css' );
		
	//Enqueue AnanyaPRO style
	wp_enqueue_style( 'ananyapro-style', get_stylesheet_uri() );


	//Enqueue navigation script
	wp_enqueue_script( 'ananyapro-navigation', get_template_directory_uri() . '/assets/js/navigation.js', array(), '20151215', true );
	wp_enqueue_script( 'ananyapro-skip-link-focus-fix', get_template_directory_uri() . '/assets//js/skip-link-focus-fix.js', array(), '20151215', true );

	//Enqueue bootstrap js
	wp_enqueue_script( 'ananyapro-bootstrap-js', get_template_directory_uri() . '/assets/bootstrap/js/bootstrap.min.js', array( 'jquery' ), false, true );	
	wp_enqueue_script( 'ananyapro-functions-js', get_template_directory_uri() . '/assets/js/ananyapro.js', array( 'jquery' ), false, true );


	// Scroll effects (only loaded on front page in Customizer)
	if ( ananyapro_is_static_front_page() && is_customize_preview() ) :
		wp_enqueue_script( 'scrollTo', get_template_directory_uri() . '/assets/js/jquery.scrollTo.js', array( 'jquery' ), '20151030', true );
	endif;

	if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
		wp_enqueue_script( 'comment-reply' );
	}

	wp_localize_script(
		'ananyapro-navigation',
		'ananyapro_screenReaderText',
		array(
			'expand'   => '<span class="screen-reader-text">' . esc_html__( 'expand child menu', 'ananyapro' ) . '</span>',
			'collapse' => '<span class="screen-reader-text">' . esc_html__( 'collapse child menu', 'ananyapro' ) . '</span>',
		)
	);
}
add_action( 'wp_enqueue_scripts', 'ananyapro_scripts' );

/**
 * Load google fornts selected by user.
 * @since 1.0
 *
 */
function ananyapro_google_fonts() {

	$fonts_url = '';
	
	$body_font = ananyapro_element_customizer_typography_options_value( 'ananyapro_body_font_select' );
	$heading_font = ananyapro_element_customizer_typography_options_value( 'ananyapro_heading_font_select' );
	
	$fonts_url = '';
	
	if ( '' !== $body_font->family ) {
		$body_font->family = esc_html( $body_font->family );
	} 
	if ( '' !== $heading_font->family ) {
		$heading_font->family = esc_html( $heading_font->family );
	}

	/** Translators: If there are characters in your language that are not
	 * supported by Lora, translate this to 'off'. Do not translate
	 * into your own language.
	 */
	$body_font_on = _x( 'on', 'Google font for body text: on or off', 'ananyapro' );

	/* Translators: If there are characters in your language that are not
	* supported by heading font, translate this to 'off'. Do not translate
	* into your own language.
	*/
	$heading_font_on = _x( 'on', 'Google font for heading text: on or off', 'ananyapro' );

	// Construct url query based on chosen fonts
	if ( 'off' !== $body_font_on || 'off' !== $heading_font_on ) {
		$font_families = array();
		if ( 'off' !== $body_font_on ) {
			$font_families[] = $body_font->family.':'.$body_font->weight;
		}
		if ( 'off' !== $heading_font_on ) {
			$font_families[] = $heading_font->family.':'.$heading_font->weight;
		}
		
		$query_args = array(
			'family' => urlencode( implode( '|', $font_families ) ),
			//'subset' => urlencode( 'cyrillic,latin-ext' ),
		);
		$fonts_url = add_query_arg( $query_args, 'https://fonts.googleapis.com/css' );
	}

	wp_register_style( 'ananyapro-google-fonts', $fonts_url, array(), null );
	wp_enqueue_style( 'ananyapro-google-fonts' );
}

add_action( 'wp_enqueue_scripts', 'ananyapro_google_fonts' );

/**
 * Change Read More link.
 */
function ananyapro_excerpt_more( $more ) {
	$read_more_markup = ananyapro_more_link();
	return $read_more_markup;
}
add_filter( 'excerpt_more', 'ananyapro_excerpt_more' );

function ananyapro_modify_read_more_link() {
    $read_more_markup = ananyapro_more_link();
	return $read_more_markup;
}
add_filter( 'the_content_more_link', 'ananyapro_modify_read_more_link' );


/**
 * Implement the Custom Header feature.
 */
require get_template_directory() . '/inc/custom-header.php';

/**
 * Custom template tags for this theme.
 */
require get_template_directory() . '/inc/template-tags.php';

/**
 * Functions which enhance the theme by hooking into WordPress.
 */
require get_template_directory() . '/inc/template-functions.php';

/**
 * Customizer additions.
 */
require get_template_directory() . '/inc/customizer.php';

/**
 * Includes all cusomizer options files.
 */
require get_template_directory() . '/inc/defaults.php';
require get_template_directory() . '/inc/sanitize-functions.php';
require get_template_directory() . '/inc/customizer-options/custom-page-layout-section.php';
require get_template_directory() . '/inc/customizer-options/custom-blog-page-options.php';
require get_template_directory() . '/inc/customizer-options/custom-single-page-section.php';
require get_template_directory() . '/inc/customizer-options/custom-single-post-section.php';
require get_template_directory() . '/inc/customizer-options/custom-color-section.php';
require get_template_directory() . '/inc/customizer-options/custom-social-media.php';
require get_template_directory() . '/inc/customizer-options/custom-searchbox-option.php';
require get_template_directory() . '/inc/customizer-options/custom-logo.php';
require get_template_directory() . '/inc/customizer-options/custom-footer.php';
require get_template_directory() . '/inc/customizer-options/custom-typography.php';
require get_template_directory() . '/inc/customizer-options/custom-frontpage.php';

require get_template_directory() . '/inc/custom-controls/range/class-range-control.php';
require get_template_directory() . '/inc/custom-controls/typography/class-googlefont-select.php';
require get_template_directory() . '/inc/custom-controls/custom-headline.php';
require get_template_directory() . '/inc/customizer-functions.php';
//require get_template_directory() . '/inc/customizer-options/custom-theme-info.php';

/**
 * Load Jetpack compatibility file.
 */
if ( defined( 'JETPACK__VERSION' ) ) {
	require get_template_directory() . '/inc/jetpack.php';
}

/**
 * Functions to add header video settings.
 * @since 1.0
 */
function ananyapro_header_video_settings( $settings ) {
  $settings['minWidth'] = 680;
  $settings['minHeight'] = 400;
  return $settings;
}
add_filter( 'header_video_settings', 'ananyapro_header_video_settings' );

/**
 * Function which returns social media menu.
 * @since 1.0
 */
if ( ! function_exists( 'ananyapro_return_social_media_menu' ) ) {

	function ananyapro_return_social_media_menu( $social_class='' ) {
		$social_media_icons_html = '';
		$show_serchbox = get_theme_mod( 'ananyapro_searchbox_display_setting', true );
		
		//array of focial media icons which uses 'fas' class
		$fas_elements = array('envelope','envelope-open','envelope-square','shopping-cart','credit-card','gamepad','map-marker','heart','rss','rss-square','info-circle','info','film');

		$social_media_icons_html .= '<div id="socialMenuResponsive" class="'.esc_attr( $social_class ).'">';
			$social_media_icons_html .= '<ul>';
			if( true === get_theme_mod( 'ananyapro_social_media_menu_enable', false) ) {
				for($i=1; $i<=4; $i++ ){
					$social_media_icon[$i] = get_theme_mod( 'ananyapro_social_media_icon_'.$i, 'facebook-f' );
					$social_media_url[$i] = get_theme_mod( 'ananyapro_social_media_url_'.$i, '' );

					//find the fontawesome icon class
					if( in_array( $social_media_icon[$i], $fas_elements ) ){
						$icon_class[$i] = 'fas';	
					} else {
						$icon_class[$i] = 'fab';
					}
					
					if ( '' !== $social_media_url[$i]  ) :
						$social_media_icons_html .= '<li class="menu-item page-item"><a href="'.esc_url( $social_media_url[$i] ).'" target="_blank">
						<i class="'.esc_attr( $icon_class[$i] ).' fa-'.esc_attr( $social_media_icon[$i] ).'"></i></a></li>';
					endif;
				} //for loop end	
			} 
				
			if( true == $show_serchbox ) {
				$social_media_icons_html .= '<li  class="menu-item page-item menu-item-search" id="nav-search">
					<a id="desktop-search-icon" href="#"><span class="screen-reader-text">'. esc_html__( 'Search Icon','ananyapro' ).'</span><i class="fas fa-search"></i></a>
		        <div id="navbar-search-box">'.get_search_form( false ).'</div></li>';
		    } 

		$social_media_icons_html.= '</ul></div>';
		return $social_media_icons_html;
	} 
} 

/**
 * Change excerpt character length to the length entered by user.
 */
function ananyapro_custom_excerpt_length( $length ) {
	$defaults = ananyapro_get_defaults();
	$post_layout_type = get_theme_mod( 'ananyapro_blog_posts_layout', $defaults['blog_posts_layout'] );
    if( 'classic' === $post_layout_type ) {
    	$default_length = 54;
    } elseif(  'list' === $post_layout_type ) {
    	$default_length = 20;
    } elseif(  'grid' === $post_layout_type ) {
    	$default_length = 40;
    } else {
    	$default_length = 54;
    }
	$excerpt_length = get_theme_mod( 'ananyapro_post_excerpt_length', $default_length );
	if( $excerpt_length > 500 || $excerpt_length < 0 ) {
		return 54;
	}
	return $excerpt_length;
}
add_filter( 'excerpt_length', 'ananyapro_custom_excerpt_length', 999 );

function ananyapro_custom_excerpt( $content, $excerpt_length, $excerpt_more )  {
	$excerpt = wp_trim_words( $content, $excerpt_length, $excerpt_more );
	return $excerpt;
}

function ananyapro_the_custom_logo() {
	$defaults = ananyapro_get_defaults();
	$nt_custom_logo_id = get_theme_mod( 'ananyapro_non_transparent_header_logo' );
	$header_image_only_on_front_page = get_theme_mod( 'ananyapro_use_header_image_only_on_front_page_setting', $defaults['header_image_only_on_front_page'] ); 
	//Print non transparent header logo either if no header image on other pages option is selected or no custom logo is present but nt logo is present.
	if( ( !empty( $nt_custom_logo_id ) && !is_front_page() && $header_image_only_on_front_page ) ){
	    
	    if ( $nt_custom_logo_id ) {
	        $nt_custom_logo_attr = array(
	            'class' => 'nt-header-custom-logo',
	        );
	 
	        /*
	         * If the logo alt attribute is empty, get the site title and explicitly
	         * pass it to the attributes used by wp_get_attachment_image().
	         */
	        $image_alt = get_post_meta( $nt_custom_logo_id, '_wp_attachment_image_alt', true );
	        /*
	         * If the alt attribute is not empty, there's no need to explicitly pass
	         * it because wp_get_attachment_image() already adds the alt attribute.
	         */
	        if ( empty( $image_alt ) ) {
		        $html = sprintf(
		            '<a href="%1$s" class="nt-custom-logo-link" rel="home">%2$s</a>',
		            esc_url( home_url( '/' ) ),
		            wp_get_attachment_image( $nt_custom_logo_id, 'full', false, $nt_custom_logo_attr )
		        );
		        echo wp_kses_post( $html );
	    	}
	    } 
	} else {
		//print custom logo
		the_custom_logo();
	}
}

/**
 * Retrieve typography options.
 *
 * @since Ananyapro 1.0
 */
function ananyapro_element_customizer_typography_options_value( $customizer_control_name ) {
	$defaults = ananyapro_get_defaults();
	if('ananyapro_heading_font_select' === $customizer_control_name ) {
		$family = $defaults['heading_font_family'];
		$weight = $defaults['heading_font_weight'];
		$transformstyle = $defaults['heading_font_transformstyle'];
		$category = $defaults['heading_font_category'];
	} else {
		$family = $defaults['body_font_family'];
		$weight = $defaults['body_font_weight'];
		$transformstyle = $defaults['body_font_transformstyle'];
		$category = $defaults['body_font_category'];
	}
	$element_font_options = get_theme_mod( $customizer_control_name , json_encode(
					array(
						'family' => $family,
						'weight' => $weight,
						'transformstyle' => $transformstyle,
						'category' => $category,
					)
				));
	
	$element = json_decode( $element_font_options );
	return $element;
}

/**
 * Use front-page.php when Front page displays is set to a static page.
 *
 * @since 1.0.0
 *
 * @param string $template front-page.php.
 * @return string The template to be used: blank if is_home() is true (defaults to index.php),
 *                otherwise $template.
 */
function ananyapro_front_page_template( $template ) {
	return is_home() ? '' : $template;
}
add_filter( 'frontpage_template', 'ananyapro_front_page_template' );

/**
 * Load theme updater functions.
 * Action is used so that child themes can easily disable.
 */

function ananyapro_theme_updater() {
    require( get_template_directory() . '/updater/theme-updater.php' );
}
add_action( 'after_setup_theme', 'ananyapro_theme_updater' );

/**
 * Load WooCommerce compatibility file.
 */
if ( class_exists( 'WooCommerce' ) ) {
	/**
	 * WooCommerce Compatibility File
	 *
	 * @link https://woocommerce.com/
	 *
	 * @package AnanyaPRO
	 */

	if ( ! function_exists( 'ananyapro_woocommerce_header_cart' ) ) {
		/**
		 * Display Header Cart
		 *
		 * @return void
		 */
		function ananyapro_woocommerce_header_cart( $items, $args ) {

			if ( class_exists( 'WooCommerce' ) ) {
				
				if ( is_cart() ) {
					$class = 'current-menu-item';
				} else {
					$class = '';
				}


				$items .= '<li  id="site-header-cart" class="menu-item page-item menu-item-cart-icon '.esc_attr( $class ).'">';
				$items .= ananyapro_woocommerce_cart_link();
				$items .= '</li>';
			} 
			return $items;
		}
	}
	add_filter( 'wp_nav_menu_items','ananyapro_woocommerce_header_cart', 10, 2 );

	if ( ! function_exists( 'ananyapro_woocommerce_cart_link' ) ) {
		/**
		 * Cart Link
		 * Displayed a link to the cart including the number of items present and the cart total
		 *
		 * @return void
		 */
		function ananyapro_woocommerce_cart_link() {

			$cart_link = '<a class="cart-contents" href="'. esc_url( wc_get_cart_url() ).'" title="'.esc_attr( 'View your shopping cart', 'ananyapro' ).'"><i class="fas fa-shopping-cart"></i><span class="amount">'.wp_kses_data( WC()->cart->get_cart_subtotal() ).'</span> <span class="count">'.wp_kses_data( sprintf( _n( '%d item', '%d items', WC()->cart->get_cart_contents_count(), 'ananyapro' ), WC()->cart->get_cart_contents_count() ) ).'</span>
			</a>';
			return $cart_link;
		}
	}

	if ( ! function_exists( 'ananyapro_woocommerce_cart_link_fragment' ) ) {
		/**
		 * Cart Fragments
		 * Ensure cart contents update when products are added to the cart via AJAX
		 *
		 * @param array $fragments Fragments to refresh via AJAX.
		 * @return array Fragments to refresh via AJAX
		 */
		function ananyapro_woocommerce_cart_link_fragment( $fragments ) {
			global $woocommerce;

			ob_start();
			echo ananyapro_woocommerce_cart_link();
			$fragments['a.cart-contents'] = ob_get_clean();

			return $fragments;
		}
	}
	add_filter( 'woocommerce_add_to_cart_fragments', 'ananyapro_woocommerce_cart_link_fragment' );

/**
 * Set wrapper start for wooCommerce
 */
function ananyapro_wrapper_start() {
	echo '<div class="container">';
	echo '<div class="row">';
	echo '<div id="primary" class="content-area">';
	echo '<main id="main" class="site-main">';
}
remove_action( 'woocommerce_before_main_content', 'woocommerce_output_content_wrapper', 10 );
add_action( 'woocommerce_before_main_content', 'ananyapro_wrapper_start', 10 );


/**
 * Set wrapper end for wooCommerce
 */
function ananyapro_wrapper_end() {
	echo '</main><!-- main -->';
	echo '</div><!-- primary -->';
}
remove_action( 'woocommerce_after_main_content', 'woocommerce_output_content_wrapper_end', 10 );
add_action( 'woocommerce_after_main_content', 'ananyapro_wrapper_end', 10 );

}

/**
 * Set Sidebar end for wooCommerce
 */
function ananyapro_wrapper_woocommerce_sidebar() {
	echo '</div><!-- row -->';
	echo '</div><!-- container -->';
}
remove_action( 'woocommerce_sidebar', 'action_woocommerce_sidebar', 10 ); 
add_action( 'woocommerce_sidebar', 'ananyapro_wrapper_woocommerce_sidebar', 11 );
