<?php
/**
 * The header for our theme
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package AnanyaPRO
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}
?>
<!doctype html>
<html <?php language_attributes(); ?>>
<head>
	<meta charset="<?php bloginfo( 'charset' ); ?>">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<link rel="profile" href="https://gmpg.org/xfn/11">

	<?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>
<?php wp_body_open(); ?>	
<div id="page" class="site">
	<a class="skip-link screen-reader-text" href="#content"><?php esc_html_e( 'Skip to content', 'ananyapro' ); ?></a>

	<?php
		$defaults = ananyapro_get_defaults();
		$overlay_type_class = get_theme_mod( 'ananyapro_header_overlay_type', $defaults['header_overlay'] );
		$page_head_style = get_theme_mod( 'ananyapro_single_page_title_position', $defaults['single_page_title_position'] );
		$post_head_style = get_theme_mod( 'ananyapro_single_post_title_position', $defaults['single_post_title_position'] );
	?>
	<?php 
		$header_media_class = '';
		$header_image_on_only_frontpage = get_theme_mod( 'ananyapro_use_header_image_only_on_front_page_setting', $defaults['header_image_only_on_front_page'] ); 
		if( has_header_image() || has_header_video() ) {
			if( ( is_front_page() ) && has_header_image() && has_header_video() ) {
				$header_media_class = 'has-header-image has-header-video';
			} elseif ( ( is_front_page() ) && has_header_image() ) {
				$header_media_class = 'has-header-image';
			} elseif ( ( is_front_page() ) && has_header_video() ) {
				$header_media_class = 'has-header-video';
			} else {
				if( !$header_image_on_only_frontpage && has_header_image() ){
					$header_media_class = 'has-header-image';
				} else { 
					$overlay_type_class  = '';
					$header_media_class = 'no-header-image';
				}
			} 
		} else {
			$header_media_class = 'no-header-image';
			$overlay_type_class  = '';
		}
		if( ( is_page() || is_archive() || is_home() ) && $page_head_style === 'over-hero-image' )  {
			$page_head_pos = 'page-title-over-hero';
		} elseif(  is_single() && $post_head_style === 'over-hero-image' ){
			$page_head_pos = 'post-title-over-hero';
		}
		else {
			$page_head_pos = 'default-title-pos';
		}
	?>

	<header id="masthead" class="site-header <?php echo esc_attr( $overlay_type_class ); ?> <?php echo esc_attr( $header_media_class );?> <?php echo esc_attr( $page_head_pos ); ?>">
		
		<?php get_template_part( 'template-parts/navigation/navigation', 'top' ); ?>
		
		<?php if ( is_front_page() ) { 
			
			get_template_part( 'template-parts/header/header-media', 'front-page' );
			
		} else { 
			if( ( class_exists( 'WooCommerce' ) && !is_product() && !is_shop() ) || !class_exists( 'WooCommerce' ) ) {
				get_template_part( 'template-parts/header/header-media', 'other-page' );
			} else {
				get_template_part( 'template-parts/header/header-media', 'other-page-woocomm' );
			}
		} ?>
	</header>
	
	<div class="ananyapro-popup-search-form">
        <div class="container">            
                <?php get_search_form(); ?>
        </div>
        <button class="ananyapro-close-popup"><span class="screen-reader-text"><?php __( 'Close Search','ananyapro' ); ?></span><i class="fas fa-times"></i></button>
    </div><!-- ananyapro-popup-search-form -->
    <?php
    //find the page layout  
    $sidebar_pos = ananyapro_find_sidebar_position();
    
    ?>
	<div id="content" class="site-content <?php echo esc_attr( $sidebar_pos ); ?> <?php echo esc_attr( $page_head_pos ); ?>">
