jQuery( document ).ready(function($) {
	"use strict";

	/**
	 * Googe Font Select Custom Control
	 */

	$('.google-fonts-list').each(function (i, obj) {
		if (!$(obj).hasClass('select2-hidden-accessible')) {
			$(obj).select2();
		}
	});

	$('.google-fonts-list').on('change', function() {
		var elementRegularWeight = $(this).parent().parent().find('.google-fonts-weight-style');
		var selectedFont = $(this).val(); 
		var customizerControlName = $(this).attr('control-name');

		// Clear Weight/Style dropdowns
		elementRegularWeight.empty();

		// Get the Google Fonts control object
		var bodyfontcontrol = _wpCustomizeSettings.controls[customizerControlName];

		// Find the index of the selected font
		var indexes = $.map(bodyfontcontrol.ananyaprofontslist, function(obj, index) {
			if(obj.family === selectedFont) {
				return index;
			}
		});
		var index = indexes[0];

		// For the selected Google font show the available weight/style variants
		$.each(bodyfontcontrol.ananyaprofontslist[index].variants, function(val, text) {
			elementRegularWeight.append(
				$('<option></option>').val(text).html(text)
			);
		});

		// Update the font category based on the selected font
		$(this).parent().parent().find('.google-fonts-category').val(bodyfontcontrol.ananyaprofontslist[index].category);

		ananyaproGetAllSelects($(this).parent().parent());
	});

	$('.google_fonts_select_control select').on('change', function() {
		ananyaproGetAllSelects($(this).parent().parent());
	});

	function ananyaproGetAllSelects($element) {
		var selectedFont = {
			family: $element.find('.google-fonts-list').val(),
			weight: $element.find('.google-fonts-weight-style').val(),
			transformstyle: $element.find('.google-fonts-text-transform-style').val(),
			category: $element.find('.google-fonts-category').val()
		};
		
		// Important! Make sure to trigger change event so Customizer knows it has to save the field
		$element.find('.customize-control-google-font-selection').val(JSON.stringify(selectedFont)).trigger('change');
	}
});

