<?php
/**
 * Sample implementation of the Custom Header feature
 *
 * You can add an optional custom header image to header.php like so ...
 *
 * @link https://developer.wordpress.org/themes/functionality/custom-headers/
 *
 * @package AnanyaPRO
 * @since 1.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

/**
 * Set up the WordPress core custom header feature.
 *
 * @uses ananyapro_header_style()
 */
function ananyapro_custom_header_setup() {
	add_theme_support( 'custom-header', apply_filters( 'ananyapro_custom_header_args', array(
		'default-image'         => 	get_parent_theme_file_uri( '/assets/images/header.jpg' ),
        'header-text'			=>	false,
		'width'                 => 	1920,
		'height'                => 	1080,
		'flex-height'           =>	true,
		'flex-width'			=>	true,
		'video'					=> 	true,
		'wp-head-callback'      => 	'ananyapro_header_style',
	) ) );

	register_default_headers(
		array(
			'default-image' => array(
				'url'           => '%s/assets/images/header.jpg',
				'thumbnail_url' => '%s/assets/images/header.jpg',
				'description'   => esc_html__( 'Default Header Image', 'ananyapro' ),
			),
		)
	);
	
}
add_action( 'after_setup_theme', 'ananyapro_custom_header_setup' );

/** 
 * Customizer setting to dispaly full screen header video/image on the front page.
 *
 * @since 1.0.0
 */
function ananyapro_custom_header_image_height_setup( $wp_customize ) {

	$defaults = ananyapro_get_defaults();

	$wp_customize->add_setting( 'ananyapro_display_site_title_tagline', array(
	  'default' 			=> 	true,
	  'transport' 			=> 	'postMessage', 
	  'sanitize_callback' 	=> 	'ananyapro_sanitize_checkbox',
	) );
	$wp_customize->add_control( 'ananyapro_display_site_title_tagline', array(
	  'type' 				=> 	'checkbox',
	  'priority' 			=> 	20, 
	  'section' 			=> 	'title_tagline', 
	  'label' 				=> 	esc_html__( 'Display Site Title and Tagline', 'ananyapro' ),
	  'settings'   			=> 	'ananyapro_display_site_title_tagline',
	) );
	
	$wp_customize->add_panel( 'header_section_panel', array(
	    'priority'       	=> 	21,
	    'capability'     	=> 	'edit_theme_options',
	    'theme_supports' 	=> 	'',
	    'title'          	=> 	esc_html__( 'Header Section', 'ananyapro'),
	    'description'    	=> 	'',
	) );
	//  ================================
    //  = Hero Header Media Type Options
    //  ================================
	$wp_customize->add_section( 'ananyapro_frontpage_header_type_section', array(
	  'title' 		=> 	esc_html__( 'Hero Section Text', 'ananyapro' ),
	  'panel' 		=> 	'header_section_panel', 
	  'priority' 	=> 	1,
	) );

	//  =============================
    //  = Hero Header/Banner Options  
    //  =============================
	$wp_customize->add_setting( 'ananyapro_header_title', array(
	  'default' 			=>	'',
	  'transport' 			=> 	'postMessage', 
	  'sanitize_callback' 	=> 	'wp_kses_post',
	) );
	$wp_customize->add_control( 'ananyapro_header_title', array(
	  'type' 		=> 	'text',
	  'priority' 	=> 	2, 
	  'section' 	=> 	'ananyapro_frontpage_header_type_section', 
	  'label' 		=> 	esc_html__( 'Enter Header/Banner Title', 'ananyapro' ),
	  'description' => 	'<i>'.esc_html__( 'This title will appear over the header image.','ananyapro' ).'</i>',
	  'settings'   	=> 	'ananyapro_header_title',
	) );

	//Hero Header/Banner Subtitle
	$wp_customize->add_setting( 'ananyapro_header_subtitle', array(
	  'default' 			=>  '',
	  'transport' 			=> 	'postMessage', 
	  'sanitize_callback' 	=> 	'wp_kses_post',
	) );
	$wp_customize->add_control( 'ananyapro_header_subtitle', array(
	  'type' 		=> 	'text',
	  'priority' 	=> 	3, 
	  'section' 	=> 	'ananyapro_frontpage_header_type_section', 
	  'label' 		=> 	esc_html__( 'Enter Header/Banner SubTitle', 'ananyapro' ),
	  'description' => 	'<i>'.esc_html__( 'This title will appear over the header image. Enter short title of upto two to three lines to avoid overlaping of the header title with the site title on mobile devices.', 'ananyapro' ).'</i>',
	  'settings'   	=> 	'ananyapro_header_subtitle',
	) );

	$atts 	= 	array(
		    	'hero-btn-fill-straight'		=>	esc_html__('Filled Straight','ananyapro' ),
		    	'hero-btn-fill-slight-round'	=>	esc_html__('Filled Slight Round','ananyapro'),
		    	'hero-btn-fill-round'			=>	esc_html__('Filled Round','ananyapro'),
		    	'hero-btn-border-straight'		=>	esc_html__('Bordered Straight','ananyapro'),
		    	'hero-btn-border-slight-round'	=>	esc_html__('Bordered Slight Round','ananyapro'),
		    	'hero-btn-border-round'			=>	esc_html__('Bordered Round','ananyapro'),
		    	'hero-btn-underline'			=>	esc_html__('Underlined','ananyapro'),
		    	'hero-btn-color-fill-straight'			=>	esc_html__('Straight - Filled with Button/Accent Color','ananyapro'),
		    	'hero-btn-color-fill-slight-round'		=>	esc_html__('Slight Round - Filled with  Button/Accent Color','ananyapro'),
		    	'hero-btn-color-fill-round'			=>	esc_html__('Round - Filled with  Button/Accent Color','ananyapro'),
		    	'hero-btn-color-border-straight'			=>	esc_html__('Straight - Bordered  with Button/Accent Color','ananyapro'),
		    	'hero-btn-color-border-slight-round'		=>	esc_html__('Slight Round - Bordered with  Button/Accent Color','ananyapro'),
		    	'hero-btn-color-border-round'			=>	esc_html__('Round - Bordered with  Button/Accent Color','ananyapro'),
			);
	ananyapro_text_control( 'header_button1_text',  'frontpage_header_type_section', 	esc_html__( 'Button1 text', 'ananyapro' ), '', 'refresh', 4, '' );
	ananyapro_url_control( 'header_button1_url',  'frontpage_header_type_section', esc_html__( 'Button1 URL', 'ananyapro' ), '', 'refresh', 5, '' );
	ananyapro_select_control( 'header_button1_style',  'frontpage_header_type_section', esc_html__( 'Button1 Style', 'ananyapro' ), esc_html__( 'When Filled/Bordered with Button/Accent Color option selected, if fronpgage sections are active frontpage button color will be used. Otherwise accent color will be used.', 'ananyapro' ), $atts, 'refresh', 6, $defaults['hero_read_more_btn_style'] );

	ananyapro_text_control( 'header_button2_text',  'frontpage_header_type_section', 	esc_html__( 'Button2 text', 'ananyapro' ), '', 'refresh', 7, '' );
	ananyapro_url_control( 'header_button2_url',  'frontpage_header_type_section', esc_html__( 'Button2 URL', 'ananyapro' ), '', 'refresh', 8, '' );
	ananyapro_select_control( 'header_button2_style',  'frontpage_header_type_section', esc_html__( 'Button2 Style', 'ananyapro' ), esc_html__( 'When Filled/Bordered with Button/Accent Color option selected, if fronpgage sections are active frontpage button color will be used. Otherwise accent color will be used.', 'ananyapro' ), $atts, 'refresh', 9, $defaults['hero_read_more_btn_style'] );
	
    $wp_customize->add_setting( 'ananyapro_header_text_alignment', array(
        'default' 	 		=> 	$defaults['header_text_alignment'],
        'sanitize_callback' => 	'ananyapro_sanitize_select',
        'transport'			=>	'postMessage',
    ) );
    $wp_customize->add_control( 'ananyapro_header_text_alignment', array(
        'label' 	=> 	esc_html__( 'Header/Banner text alignment', 'ananyapro' ),
        'settings'	=> 'ananyapro_header_text_alignment',
        'section' 	=> 	'ananyapro_frontpage_header_type_section',
        'type' 		=> 	'select',
        'priority' 	=> 	10,
        'choices'		=> 	array(
		    	'text-left'		=>	esc_html__( 'Left', 'ananyapro' ),
		    	'text-right'	=>	esc_html__( 'Right', 'ananyapro' ),
		    	'text-center'	=>	esc_html__( 'Center', 'ananyapro' ),
		    ),
    ) );
    $wp_customize->add_setting( 'ananyapro_header_vertical_text_alignment', array(
        'default' 	 		=> 	$defaults['header_vertical_text_alignment'],
        'sanitize_callback' => 	'ananyapro_sanitize_select',
        'transport'			=>	'postMessage',
    ) );
    $wp_customize->add_control( 'ananyapro_header_vertical_text_alignment', array(
        'label' 	=> 	__( 'Header/Banner text vertical alignment', 'ananyapro' ),
        'settings'	=> 'ananyapro_header_vertical_text_alignment',
        'section' 	=> 	'ananyapro_frontpage_header_type_section',
        'type' 		=> 	'select',
        'priority' 	=> 	11,
        'choices'	=> 	array(
	    	'h-center'	=>	esc_html__( 'Center', 'ananyapro' ),
	    	'h-bottom'	=>	esc_html__( 'Bottom(default)', 'ananyapro' ),
	    ),
    ) );
	//  ===================================================
    //  = Move Header Image Section To Header Section Panel           =
    //  ===================================================
    $wp_customize->get_section( 'header_image' )->panel = 'header_section_panel';
    
	//  ===================================================
    //  = Header Image Options section           =
    //  ===================================================
	$wp_customize->add_section( 'ananyapro_header_media_options_section', array(
	  'title' 		=> 	esc_html__( 'Header Media Options', 'ananyapro' ),
	  'panel' 		=> 	'header_section_panel', 
	  'priority' 	=> 	61,
	) );  
	$wp_customize->add_setting( 'ananyapro_full_screen_header_image_setting', array(
	  'default' 			=> 	$defaults['full_screen_header'],
	  'transport' 			=> 	'refresh', 
	  'sanitize_callback' 	=> 	'ananyapro_sanitize_checkbox',
	) );
	$wp_customize->add_control( 'ananyapro_full_screen_header_image_setting', array(
	  'type' 				=> 	'checkbox',
	  'priority' 			=> 	1, 
	  'section' 			=> 	'ananyapro_header_media_options_section', 
	  'label' 				=> 	esc_html__( 'Full screen header', 'ananyapro' ),
	  'description' 		=> 	esc_html__('(Select the checkbox if you want full screen header video/image on the frontpage/homepage of your website.)', 'ananyapro'),
	  'settings'   			=> 	'ananyapro_full_screen_header_image_setting',
	) );
	$wp_customize->add_setting( 'ananyapro_use_header_image_only_on_front_page_setting', array(
	  'default' 			=> 	$defaults['header_image_only_on_front_page'],
	  'transport' 			=> 	'refresh', 
	  'sanitize_callback' 	=> 	'ananyapro_sanitize_checkbox',
	) );
	$wp_customize->add_control( 'ananyapro_use_header_image_only_on_front_page_setting', array(
	  'type' 			=> 	'checkbox',
	  'priority' 		=> 	2, 
	  'section' 		=> 	'ananyapro_header_media_options_section', 
	  'label' 			=> 	esc_html__( 'Use header image only on frontpage/homepage.', 'ananyapro' ),
	  'description' 	=> 	esc_html__('(Select the checkbox if you do not want to use the header image on single post pages and other pages.)', 'ananyapro'),
	  'settings'   		=> 	'ananyapro_use_header_image_only_on_front_page_setting',
	) );

	//  =============================
    //  = Hero Media Overlay Options 
    //  =============================
    $wp_customize->add_section( 'ananyapro_header_overlay_type_section', array(
	  'title' 		=> 	esc_html__( 'Header Media Overlay', 'ananyapro' ),
	  'panel' 		=> 	'header_section_panel', 
	  'priority' 	=> 	62,
	) );
	$wp_customize->add_setting( 'ananyapro_header_overlay_type', array(
	  'default' 			=> 	$defaults['header_overlay'],
	  'sanitize_callback' 	=> 	'ananyapro_sanitize_radio',
	  'transport'			=>	'postMessage',
	) );
	$wp_customize->add_control( 'ananyapro_header_overlay_type', array(
	  'type' 		=> 'radio',
	  'priority' 	=> 1, 
	  'section' 	=> 'ananyapro_header_overlay_type_section', 
	  'label' 		=> esc_html__( 'Header Overlay Type', 'ananyapro' ),
	  'settings'   	=> 'ananyapro_header_overlay_type',
	  'choices'		=>  array(
		  	'default-overlay' 		=> 	esc_html__( 'Default', 'ananyapro'),
		  	'color-overlay'			=> 	esc_html__( 'Color', 'ananyapro'),
		  	'gradient-overlay'		=>	esc_html__( 'Gradient Overlay', 'ananyapro' ),
		  	'no-overlay' 			=> 	esc_html__( 'No Overlay', 'ananyapro'),
	  ),
	) );

	//Color Overlay Color selection settings
	ananyapro_color_control( 'overlay_color', 'header_overlay_type_section', esc_html__( 'Select color for overlay', 'ananyapro' ), '', 'refresh', 2, $defaults['overlay_color'], 'ananyapro_is_color_overlay' );

	//gradient start color
	ananyapro_color_control(  'gradient_start_color', 'header_overlay_type_section', esc_html__( 'Gradient Start Color', 'ananyapro' ), '', 'refresh', 3, $defaults['gradient_start_color'], 'ananyapro_is_gradient_overlay' );
	//gradient end color
	ananyapro_color_control(  'gradient_end_color', 'header_overlay_type_section', esc_html__( 'Gradient End Color', 'ananyapro' ), '', 'refresh', 4, $defaults['gradient_end_color'], 'ananyapro_is_gradient_overlay' );
	
	//Color opacity control
	$wp_customize->add_setting( 'ananyapro_color_overlay_opacity', 
		array(
		    'default'        	=> 	$defaults['overlay_opacity'],
		    'sanitize_callback' => 	'ananyapro_sanitize_unsigned_floatval',
			'transport'         => 	'refresh',
	));
	$wp_customize->add_control( new Ananyapro_Range_Custom_Control( $wp_customize, 'ananyapro_color_overlay_opacity',
		array(
			'type'			=> 	'ananyapro-range-responsive',
			'description' 	=> 	esc_html__( 'Color Overlay Opacity', 'ananyapro' ),
			'section' 		=> 	'ananyapro_header_overlay_type_section',
			'settings' 		=> 	array(
				'desktop' 	=> 	'ananyapro_color_overlay_opacity'
			),
			'input_attrs' 	=> 	array(
				'desktop' 	=> 	array(
					'min' 	=> 	0,
					'max' 	=> 	1,
					'step' 	=> 	0.1,
					'unit' 	=> 	'',
				),
			),
		)
	) );
	//Gradient opacity control
	$wp_customize->add_setting( 'ananyapro_gradient_overlay_opacity', 
		array(
		    'default'        	=> 	$defaults['overlay_opacity'],
		    'sanitize_callback' => 	'ananyapro_sanitize_unsigned_floatval',
			'transport'         => 	'refresh',
	));
	$wp_customize->add_control( new Ananyapro_Range_Custom_Control( $wp_customize, 'ananyapro_gradient_overlay_opacity',
		array(
			'type'			=> 	'ananyapro-range-responsive',
			'description' 	=> 	esc_html__( 'Gradient Overlay Opacity', 'ananyapro' ),
			'section' 		=> 	'ananyapro_header_overlay_type_section',
			'settings' 		=> 	array(
				'desktop' 	=> 	'ananyapro_gradient_overlay_opacity'
			),
			'input_attrs' 	=> 	array(
				'desktop' 	=> 	array(
					'min' 	=> 	0,
					'max' 	=> 	1,
					'step' 	=> 	0.1,
					'unit' 	=> 	'',
				),
			),
		)
	) );
}
add_action( 'customize_register', 'ananyapro_custom_header_image_height_setup' );

/**
 * Returns true if full screen image option is not selected for front page.
 * @since 1.0.0
 */
function ananyapro_is_header_image_on_other_page_selected( $control ) {
    if ( true === $control->manager->get_setting( 'ananyapro_use_header_image_only_on_front_page_setting' )->value() ) {
        return false;
    } else {
        return true;
    }
}

/**
 * Returns true if header media type is image.
 * @since 1.0.0
 */
function ananyapro_is_header_media_image( $control ) {
	if ( 'image' === $control->manager->get_setting( 'ananyapro_frontpage_header_type' )->value() ) {
		return true;
	} else {
		return false;
	}
}

function ananyapro_is_gradient_overlay( $control ) {
	if ( 'gradient-overlay' === $control->manager->get_setting( 'ananyapro_header_overlay_type' )->value() ) {
        return true;
    } else {
        return false;
    }
}

function ananyapro_is_color_overlay( $control ) {
	if ( 'color-overlay' === $control->manager->get_setting( 'ananyapro_header_overlay_type' )->value() ) {
        return true;
    } else {
        return false;
    }
}

function ananyapro_is_header_overlay_present( $control ) {
	$overlay_type = $control->manager->get_setting( 'ananyapro_header_overlay_type' )->value();
	if ( 'color-overlay' === $overlay_type || 'gradient-overlay' === $overlay_type ) {
		return true;
	} else {
		return false;
	}
}