<?php
/**
 * AnanyaPRO Theme Customizer
 *
 * @package AnanyaPRO
 * @since 1.0
 */

/**
 * Add customizer settings and controls for Blog Page Options.
 *
 * @param WP_Customize_Manager $wp_customize Theme Customizer object.
 *
 */
function ananyapro_custom_theme_options_section_setup( $wp_customize ) {

	$defaults = ananyapro_get_defaults();

	//  =============================================================
    //  = Blog Page Section         =
    //  =============================================================
	$wp_customize->add_section( 'ananyapro_blog_page_options_section', array(
	  'title' 		=> 	esc_html__( 'Blog Page Settings', 'ananyapro' ),
	  'priority' 	=> 	2,
	  'panel' 		=> 	'ananyapro_options_panel',
	) );
	//  =============================================================
    //  = Blog Title          =
    //  =============================================================
	$wp_customize->add_setting( 'ananyapro_blog_page_title', array(
	    'default'        	=> 	$defaults['blog_page_title'],
	    'sanitize_callback' => 	'wp_kses_post',
		'transport'         => 	'refresh',
	));
	$wp_customize->add_control( 'ananyapro_blog_page_title', 
		array(
		    'label'      	=>	esc_html__( 'Blog title', 'ananyapro' ),
		    'section'    	=> 	'ananyapro_blog_page_options_section',
		    'settings'   	=> 	'ananyapro_blog_page_title',
		    'type'       	=> 	'text',
	));
	//  =============================================================
    //  = Blog Description          =
    //  =============================================================
	$wp_customize->add_setting( 'ananyapro_blog_page_description', array(
	    'default'        	=> 	$defaults['blog_page_description'],
	    'sanitize_callback' => 	'wp_kses_post',
		'transport'         => 	'refresh',
	));
	$wp_customize->add_control( 'ananyapro_blog_page_description', 
		array(
		    'label'      	=>	esc_html__( 'Blog Description', 'ananyapro' ),
		    'section'    	=> 	'ananyapro_blog_page_options_section',
		    'settings'   	=> 	'ananyapro_blog_page_description',
		    'type'       	=> 	'text',
	));
	//  =============================================================
    //  = Blog post layout           =
    //  =============================================================
	$wp_customize->add_setting( 'ananyapro_blog_posts_layout', array(
	    'default'        	=> 	$defaults['blog_posts_layout'],
	    'sanitize_callback' => 	'ananyapro_sanitize_select',
		'transport'         => 	'refresh',
	));
	$wp_customize->add_control( 'ananyapro_blog_posts_layout', 
		array(
			'type'       	=> 	'select',
			'label' 		=> 	esc_html__( 'Blog Posts Layout', 'ananyapro' ),
			'description' 	=> 	'',
		    'section'    	=> 	'ananyapro_blog_page_options_section',
		    'settings'   	=> 	'ananyapro_blog_posts_layout',
		    'choices'		=> 	array(
		    	'classic'	=>	esc_html__( 'Classic','ananyapro' ),
		    	'grid'		=>	esc_html__( 'Grid','ananyapro' ),
		    	'list-1'	=>	esc_html__( 'List 1','ananyapro' ),
		    	'list-2'	=>	esc_html__( 'List 2','ananyapro' ),
		    ),
	));
	//  =============================================================
    //  = Post content display option: Post Excerpt/Full Post            =
    //  =============================================================
	$wp_customize->add_setting( 'ananyapro_post_display_type_option', array(
	    'default'        	=> 	$defaults['post_display_type'],
	    'sanitize_callback' => 	'ananyapro_sanitize_radio',
		'transport'         => 	'refresh',
	));
	$wp_customize->add_control( 'ananyapro_post_display_type_option', 
		array(
		    'label'      	=>	esc_html__( 'How would you like to display post content on Blog posts index page?', 'ananyapro' ),
		    'section'    	=> 	'ananyapro_blog_page_options_section',
		    'settings'   	=> 	'ananyapro_post_display_type_option',
		    'type'       	=> 	'radio',
		    'choices'    	=> 	array(
		        'post-excerpt'	=>	esc_html__( 'Post Excerpt', 'ananyapro' ),
		        'full-post'		=>	esc_html__( 'Full Post', 'ananyapro' ),
			),
	));

	//  =============================================================
    //  = Post Excerpt length option      =
    //  =============================================================
    $post_layout_type = get_theme_mod( 'ananyapro_blog_posts_layout', $defaults['blog_posts_layout'] );
    if( 'classic' === $post_layout_type ) {
    	$default_length = 54;
    } elseif(  'list' === $post_layout_type ) {
    	$default_length = 20;
    } elseif(  'grid' === $post_layout_type ) {
    	$default_length = 40;
    } else {
    	$default_length = 54;
    }
    
	$wp_customize->add_setting( 'ananyapro_post_excerpt_length', 
		array(
		    'default'        	=> 	$default_length,
		    'sanitize_callback' => 	'absint',
			'transport'         => 	'refresh',
	));
	$wp_customize->add_control( 'ananyapro_post_excerpt_length', 
		array(
		    'label'      		=>	esc_html__( 'Post excerpt length.', 'ananyapro' ),
		    'section'    		=>	'ananyapro_blog_page_options_section',
		    'settings'   		=> 	'ananyapro_post_excerpt_length',
		    'type'       		=> 	'text',
		    'active_callback' 	=> 	'ananyapro_post_excerpt_length_callback',
	));
	//  =============================================================
    //  = Read More Button Text          =
    //  =============================================================
	$wp_customize->add_setting( 'ananyapro_read_more_btn_text', array(
	    'default'        	=> 	$defaults['read_more_btn_text'],
	    'sanitize_callback' => 	'wp_kses_post',
		'transport'         => 	'refresh',
	));
	$wp_customize->add_control( 'ananyapro_read_more_btn_text', 
		array(
			'label' 		=> 	esc_html__( 'Read More Button Text', 'ananyapro' ),
		    'section'    	=> 	'ananyapro_blog_page_options_section',
		    'settings'   	=> 	'ananyapro_read_more_btn_text',
		    'type'       	=> 	'text',
	));
	//  =============================================================
    //  = Read More Button Style         =
    //  =============================================================
	$wp_customize->add_setting( 'ananyapro_post_read_more_btn_style', array(
	    'default'        	=> 	$defaults['read_more_btn_style'],
	    'sanitize_callback' => 	'ananyapro_sanitize_select',
		'transport'         => 	'refresh',
	));
	$wp_customize->add_control( 'ananyapro_post_read_more_btn_style', 
		array(
			'label' 		=> 	esc_html__( 'Read More Button Style', 'ananyapro' ),
		    'section'    	=> 	'ananyapro_blog_page_options_section',
		    'settings'   	=> 	'ananyapro_post_read_more_btn_style',
		    'type'       	=> 	'select',
		    'choices'		=> 	array(
		    	'more-btn-fill-straight'			=>	esc_html__('Filled & Straight','ananyapro' ),
		    	'more-btn-fill-slight-round'		=>	esc_html__('Filled & Slight Round','ananyapro'),
		    	'more-btn-fill-round'				=>	esc_html__('Filled & Round','ananyapro'),
		    	'more-btn-border-straight'			=>	esc_html__('Bordered & Straight','ananyapro'),
		    	'more-btn-border-slight-round'		=>	esc_html__('Bordered & Slight Round','ananyapro'),
		    	'more-btn-border-round'				=>	esc_html__('Bordered & Round','ananyapro'),
		    	'more-btn-underline'				=>	esc_html__('Underlined','ananyapro'),
		    	'more-btn-fill-gray-color'			=>	esc_html__('Filled with Gray Color','ananyapro'),
		    	'more-btn-border-gray-color'		=>	esc_html__('Bordered Text Color','ananyapro'),
		),
	));

	//  =============================================================
    //  = Disable/Hide footer on blog page           =
    //  =============================================================
	$wp_customize->add_setting( 'ananyapro_hide_blog_page_post_footer_option', array(
	    'default'        	=> 	$defaults['hide_blog_page_post_footer'],
	    'sanitize_callback' => 	'ananyapro_sanitize_checkbox',
		'transport'         => 	'refresh',
	));
	$wp_customize->add_control( 'ananyapro_hide_blog_page_post_footer_option', 
		array(
			'label' 		=> 	esc_html__( 'Hide footer of a post on Blog posts index page.', 'ananyapro' ),
			'description' 	=> 	__( 'If you select this option the blog post footer which has post\'s <em>Category</em> and <em>Social Media Sharing buttons</em> will be removed.', 'ananyapro'),
		    'section'    	=> 	'ananyapro_blog_page_options_section',
		    'settings'   	=> 	'ananyapro_hide_blog_page_post_footer_option',
		    'type'       	=> 	'checkbox',
		    'active_callback' 	=> 	'ananyapro_post_layout_not_list2',
	));
	//Hide Date
	ananyapro_checkbox_control( 'hide_blog_post_date',  'blog_page_options_section', 	esc_html__( 'Hide Date', 'ananyapro' ), '', 'refresh', 10, false );

	//Hide Author
	ananyapro_checkbox_control( 'hide_blog_post_author',  'blog_page_options_section', 	esc_html__( 'Hide Author Name', 'ananyapro' ), '', 'refresh', 11, false );

	//Hide Comment Link
	ananyapro_checkbox_control( 'hide_blog_post_comment_link',  'blog_page_options_section', 	esc_html__( 'Hide Comments Link', 'ananyapro' ), '', 'refresh', 12, false );

	//Hide Featured Image 
	ananyapro_checkbox_control( 'hide_blog_post_featured_image',  'blog_page_options_section', 	esc_html__( 'Hide Featured Image', 'ananyapro' ), '', 'refresh', 13, false );

}
add_action( 'customize_register', 'ananyapro_custom_theme_options_section_setup' );

/**
 * Post Excerpt Length callback function
 */
function ananyapro_post_excerpt_length_callback( $control ) {
    if ( 'post-excerpt' === $control->manager->get_setting( 'ananyapro_post_display_type_option' )->value() ) {
        return true;
    } else {
        return false;
    }
}

/**
 * Post Excerpt Length callback function
 */
function ananyapro_post_layout_not_list2( $control ) {
    if ( 'list-2' !== $control->manager->get_setting( 'ananyapro_blog_posts_layout' )->value() ) {
        return true;
    } else {
        return false;
    }
}
