<?php
/**
 * AnanyaPRO Theme Customizer
 *
 * @package AnanyaPRO
 * @since 1.0
 */

/**
 * Add customizer settings and controls for Color options.
 *
 * @param WP_Customize_Manager $wp_customize Theme Customizer object.
 */
function ananyapro_custom_color_section_setup( $wp_customize ) {

	$defaults = ananyapro_get_defaults();

	//  ==========================================================
	//  =Colors Panel 
	//  ==========================================================
    $wp_customize->add_panel( 'ananyapro_colors_panel', array(
        'priority'       	=> 	40,
        'capability'     	=> 	'edit_theme_options',
        'theme_supports' 	=> 	'',
        'title'          	=> 	esc_html__('Colors', 'ananyapro'),
    ) );

	$wp_customize->get_section( 'colors' )->title = esc_html__('General', 'ananyapro');
    $wp_customize->get_section( 'colors' )->panel = 'ananyapro_colors_panel';
    $wp_customize->get_section( 'colors' )->priority = '1'; 

    // Accent color setting
	$wp_customize->add_setting( 'ananyapro_site_header_text_color', array(
		'default'           =>	$defaults['site_header_text_color'],
		'sanitize_callback' => 	'sanitize_hex_color',
		'transport'         => 	'postMessage',
	) );
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'ananyapro_site_header_text_color', array(
		'label'       		=> 	esc_html__( 'Site Header Text', 'ananyapro' ),
		'section'     		=> 	'colors',
		'settings'    		=> 	'ananyapro_site_header_text_color',
		'priority'   		=> 	0,
	) ) );

	// Accent color setting
	$wp_customize->add_setting( 'ananyapro_accent_color', array(
		'default'           =>	$defaults['accent_color'],
		'sanitize_callback' => 	'sanitize_hex_color',
		'transport'         => 	'postMessage',
	) );
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'ananyapro_accent_color', array(
		'label'       		=> 	esc_html__( 'Accent Color', 'ananyapro' ),
		'section'     		=> 	'colors',
		'settings'    		=> 	'ananyapro_accent_color',
		'description' 		=> 	esc_html__( 'Applied to some of the elements on Page and Post. This color does not apply to Frontpage Sections.', 'ananyapro' ),
	) ) );
	//Heading Text color setting
	$wp_customize->add_setting( 'ananyapro_heading_text_color', array(
		'default'           => 	$defaults['heading_text_color'],
		'sanitize_callback' => 	'sanitize_hex_color',
		'transport'         => 	'postMessage',
	) );
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'ananyapro_heading_text_color', array(
		'label'       		=> 	esc_html__( 'Heading Color', 'ananyapro' ),
		'section'     		=> 	'colors',
		'settings'    		=> 	'ananyapro_heading_text_color',
	) ) );
	//Body Text color setting
	$wp_customize->add_setting( 'ananyapro_body_text_color', array(
		'default'           => 	$defaults['body_text_color'],
		'sanitize_callback' => 	'sanitize_hex_color',
		'transport'         => 	'postMessage',
	) );
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'ananyapro_body_text_color', array(
		'label'       		=> 	esc_html__( 'Text Color', 'ananyapro' ),
		'section'     		=> 	'colors',
		'settings'    		=> 	'ananyapro_body_text_color',
	) ) );
	//  ==========================================================
    //  = Post Color Section         =
    //  ==========================================================
	$wp_customize->add_section( 'ananyapro_post_color_section', array(
	  'title' 				=>	esc_html__( 'Post Colors', 'ananyapro' ),
	  'priority' 			=>	2,
	  'panel' 				=>	'ananyapro_colors_panel',
	) );
	
	//Post meta data color.
	$wp_customize->add_setting( 'ananyapro_post_meta_color', array(
		'default'           => 	$defaults['post_meta_color'],
		'sanitize_callback' => 	'sanitize_hex_color',
		'transport'         => 	'postMessage',
	) );
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'ananyapro_post_meta_color', array(
		'label'       		=> 	esc_html__( 'Post Meta Data Color', 'ananyapro' ),
		'section'     		=> 	'ananyapro_post_color_section',
		'settings'    		=> 	'ananyapro_post_meta_color',
		'description' 		=> 	'<i>'.esc_html__( 'Applied to post meta data like date, author and comment link.', 'ananyapro' ).'</i>',
	) ) );
	//Post background color.
	$wp_customize->add_setting( 'ananyapro_post_bg_color', array(
		'default'           => 	$defaults['post_bg_color'],
		'sanitize_callback' => 	'sanitize_hex_color',
		'transport'         => 	'postMessage',
	) );
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'ananyapro_post_bg_color', array(
		'label'       		=> 	esc_html__( 'Post Background Color', 'ananyapro' ),
		'section'     		=> 	'ananyapro_post_color_section',
		'settings'    		=> 	'ananyapro_post_bg_color',
	) ) );
	//  ==========================================================
    //  = Menu Color Section         =
    //  ==========================================================
	$wp_customize->add_section( 'ananyapro_menu_color_section', array(
	  'title' 				=> 	esc_html__( 'Menu Colors', 'ananyapro' ),
	  'priority' 			=> 	3,
	  'panel' 				=> 	'ananyapro_colors_panel',
	) );
	//Menu Item Text/Link color setting.
	$wp_customize->add_setting( 'ananyapro_menu_item_color', array(
		'default'           => 	$defaults['menu_item_color'],
		'sanitize_callback' => 	'sanitize_hex_color',
		'transport'         => 	'postMessage',
	) );
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'ananyapro_menu_item_color', array(
		'label'       		=> 	esc_html__( 'Menu Item Link/Text Color', 'ananyapro' ),
		'section'     		=>	'ananyapro_menu_color_section',
		'settings'    		=>	'ananyapro_menu_item_color',
		'description' 		=>	'<i>'.esc_html__( 'Applied to menu without header image as background.', 'ananyapro' ).'</i>',
		'active_callback'	=>	'ananyapro_is_no_header_image_or_only_on_frontpage',
	) ) );
	//Menu background color.
	$wp_customize->add_setting( 'ananyapro_menu_bg_color', array(
		'default'           => 	$defaults['menu_bg_color'],
		'sanitize_callback' => 	'sanitize_hex_color',
		'transport'         => 	'postMessage',
	) );
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'ananyapro_menu_bg_color', array(
		'label'       		=> 	esc_html__( 'Menu Background Color', 'ananyapro' ),
		'section'     		=> 	'ananyapro_menu_color_section',
		'settings'    		=> 	'ananyapro_menu_bg_color',
		'description' 		=> 	'<i>'.esc_html__( 'Applied to menu without header image as background.', 'ananyapro' ).'</i>',
		'active_callback'	=>  'ananyapro_is_no_header_image_or_only_on_frontpage',
	) ) );
	//  ==========================================================
    //  = Footer Color Section         =
    //  ==========================================================
	$wp_customize->add_section( 'ananyapro_footer_color_section', array(
	  'title' 				=> 	esc_html__( 'Footer Colors', 'ananyapro' ),
	  'priority' 			=> 	4,
	  'capability' 			=> 	'edit_theme_options',
	  'panel' 				=> 	'ananyapro_colors_panel',
	) );
	//Footer background color.
	$wp_customize->add_setting( 'ananyapro_footer_bg_color', array(
		'default'           => 	$defaults['footer_bg_color'],
		'sanitize_callback' => 	'sanitize_hex_color',
		'transport'         => 	'postMessage',
	) );
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'ananyapro_footer_bg_color', array(
		'label'       		=> 	esc_html__( 'Footer Background Color', 'ananyapro' ),
		'section'     		=> 	'ananyapro_footer_color_section',
		'settings'    		=> 	'ananyapro_footer_bg_color',
	) ) );	
	//Footer Link color.
	$wp_customize->add_setting( 'ananyapro_footer_link_color', array(
		'default'           => 	$defaults['footer_link_color'],
		'sanitize_callback' => 	'sanitize_hex_color',
		'transport'         => 	'postMessage',
	) );
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'ananyapro_footer_link_color', array(
		'label'       		=> 	esc_html__( 'Footer Link Color', 'ananyapro' ),
		'section'     		=> 	'ananyapro_footer_color_section',
		'settings'    		=> 	'ananyapro_footer_link_color',
	) ) );
	//Footer Heading color.
	$wp_customize->add_setting( 'ananyapro_footer_heading_color', array(
		'default'           => 	$defaults['footer_text_color'],
		'sanitize_callback' => 	'sanitize_hex_color',
		'transport'         => 	'postMessage',
	) );
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'ananyapro_footer_heading_color', array(
		'label'       		=> 	esc_html__( 'Footer Heading Color', 'ananyapro' ),
		'section'     		=> 	'ananyapro_footer_color_section',
		'settings'    		=> 	'ananyapro_footer_heading_color',
	) ) );
	//Footer text color.
	$wp_customize->add_setting( 'ananyapro_footer_text_color', array(
		'default'           => 	$defaults['footer_text_color'],
		'sanitize_callback' => 	'sanitize_hex_color',
		'transport'         => 	'postMessage',
	) );
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'ananyapro_footer_text_color', array(
		'label'       		=> 	esc_html__( 'Footer Text Color', 'ananyapro' ),
		'section'     		=> 	'ananyapro_footer_color_section',
		'settings'    		=> 	'ananyapro_footer_text_color',
	) ) );
}
add_action( 'customize_register', 'ananyapro_custom_color_section_setup' );

if ( ! function_exists( 'ananyapro_is_header_image_only_on_frontpage' ) ) :
/**
 * Returns true if option "header image on only front page is selected"..
 */
function ananyapro_is_no_header_image_or_only_on_frontpage( $control ) {
    if ( (true === $control->manager->get_setting( 'ananyapro_use_header_image_only_on_front_page_setting' )->value()) || (!has_header_image() && !has_header_video()) ) {
        return true;
    } else {
        return false;
    }
}
endif;