<?php
/**
 * AnanyaPRO Theme Customizer
 *
 * @package AnanyaPRO
 * @since 1.0
 */
/**
 * Add customizer settings and controls for the footer.
 *
 * @param WP_Customize_Manager $wp_customize Theme Customizer object.
 *
 */
function ananyapro_custom_footer_options_setup( $wp_customize ) {

	$defaults = ananyapro_get_defaults();

	$wp_customize->add_section( 'ananyapro_footer_options_section', array(
	  'title' 		=> 	__( 'Footer', 'ananyapro' ),
	  'priority' 	=> 	4,
	  'panel' 		=> 	'ananyapro_options_panel',
	) );

	//Footer Credit Textarea
	ananyapro_textarea_control( 'footer_credit_text',  'footer_options_section', esc_html__( 'Footer Credit Text', 'ananyapro' ), __( 'Enter <strong>{year}</strong> to update the current year automatically and <strong>{copy}</strong> for the copyright symbol.<br><br>Example: Copyright  {copy} {year} All Rights Reserved', 'ananyapro' ), 'postMessage', 2, $defaults['footer_credit_text'], ''   );

	//Add to top button
	ananyapro_checkbox_control( 'show_scroll_to_top',  'footer_options_section', esc_html__( 'Show Scroll To Top Button', 'ananyapro' ), '', 'refresh', 3, false );
}
add_action( 'customize_register', 'ananyapro_custom_footer_options_setup' );
