<?php
/**
 * AnanyaPRO Theme Customizer
 *
 * @package AnanyaPRO
 * @since 1.0
 */

/**
 * Add customizer settings and controls for Frontpage design.
 *
 * @param WP_Customize_Manager $wp_customize Theme Customizer object.
 *
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

function ananyapro_frontpage_sections_setup( $wp_customize ) {

	$defaults = ananyapro_get_defaults();
	$num_sections =  $defaults['total_no_of_each_type_section'];
	$type_of_sections = 4;
	//set each section priority
	for( $i=1; $i<= $num_sections; $i++ ) {
		$start_val = ($i-1)*$type_of_sections+$i;
		$defaults['feat_content_sec_priority'][$i-1] = $start_val;
		$defaults['feat_page_sec_priority'][$i-1] = $start_val+1;
		$defaults['feat_category_sec_priority'][$i-1] = $start_val+2;
		$defaults['CTA_sec_priority'][$i-1] = $start_val+3;
		$defaults['widget_sec_priority'][$i-1] = $start_val+4;
	}
	
	//add general settengs for featured section
	ananyapro_add_featured_general_settings( $wp_customize, $defaults );
	//add featured content section settings and contorls
	ananyapro_add_featured_content_section_settings( $wp_customize, $defaults );
	//add featured category section settings and contorls
	ananyapro_add_featured_category_section_settings( $wp_customize, $defaults );
	//add featured content section settings and contorls
	ananyapro_add_featured_pages_section_settings( $wp_customize, $defaults );
	//add CTA section settings and contorls
	ananyapro_add_CTA_section_settings( $wp_customize, $defaults );
	ananyapro_latest_post_section( $wp_customize, $defaults );
	ananyapro_showcase_categories_section( $wp_customize, $defaults );
}
add_action( 'customize_register', 'ananyapro_frontpage_sections_setup' );

/**
 * Post per peage Number Input sanitization
 *
 * @param  string		Input value to check
 * @return integer	Returned integer value
 */
if ( ! function_exists( 'ananyapro_sanitize_post_per_page_number' ) ) {
	function ananyapro_sanitize_post_per_page_number( $input ) {
		if( $input < 1 ) {
			$input = 1;
		} elseif( $input > 10 ) {
			$input = 10;
		}
		return absint( $input );
	}
}

/**
 * Return whether we're previewing the front page and it's a static page.
 */
function ananyapro_is_static_front_page() {
	return ( is_front_page() && ! is_home() );
}

if ( !function_exists('ananya_not_btn_underline_style')) {
	function ananya_not_btn_underline_style( $control ){

		if( 'fp-btn-underline' !== $control->manager->get_setting( 'ananyapro_frontpage_button_style' )->value() ) {
			return true;
		}
		else {
			return false;
		}

	}
}

function ananyapro_add_featured_general_settings( $wp_customize, $defaults ) {
	//  ==========================================================
    //  = Frontpage General Settings Section         =
    //  ==========================================================
    $wp_customize->add_section( 'ananyapro_featured_genral_settings_section', array(
	  'title' 		=> 	esc_html__( 'General Settings', 'ananyapro' ),
	  'priority' 	=> 	-1,
	  'panel' 		=> 	'ananyapro_frontpage_panel',
	) );
	//  ==========================================================
    //  = Disable/Hide front page sections           =
    //  ==========================================================
	
	ananyapro_checkbox_control( 'enable_frontpage_sections', 'featured_genral_settings_section', esc_html__( 'Enable All Frontpage Sections', 'ananyapro' ), esc_html__( 'Note : Please go to Homepage Settings and select a Static Page as your homepage displays.', 'ananyapro' ), 'refresh', 1, $defaults['enable_frontpage_sections'] );

	//Frontpage button style
	$choices =	array(
    	'fp-btn-fill-straight'		=>	esc_html__( 'Filled & Straight', 'ananyapro' ),
    	'fp-btn-fill-slight-round'	=>	esc_html__( 'Filled & Slightly Round', 'ananyapro' ),
    	'fp-btn-fill-round'			=>	esc_html__( 'Filled & Round', 'ananyapro' ),
    	'fp-btn-border-straight'	=>	esc_html__( 'Bordered & Straight', 'ananyapro' ),
    	'fp-btn-border-slight-round'=>	esc_html__( 'Bordered & Slightly Round', 'ananyapro' ),
    	'fp-btn-border-round'		=>	esc_html__( 'Bordered & Round', 'ananyapro' ),
    	'fp-btn-underline'			=>	esc_html__( 'Underlined', 'ananyapro' ),
    );
	ananyapro_select_control( 'frontpage_button_style',  'featured_genral_settings_section',  esc_html__( 'Button Style', 'ananyapro' ), '', $choices, 'postMessage', 3, $defaults['frontpage_button_style'] );

	//Frontpage button background color
	ananyapro_color_control(  'frontpage_button_bg_color', 'featured_genral_settings_section', esc_html__( 'Button Background Color', 'ananyapro' ), '','postMessage', 4, $defaults['accent_color'] );

	//Frontpage button border color
	ananyapro_color_control(  'frontpage_button_border_color', 'featured_genral_settings_section', esc_html__( 'Button Border Color', 'ananyapro' ), '','postMessage', 5, $defaults['accent_color'] );

	//Frontpage button text color
	ananyapro_color_control(  'frontpage_button_text_color', 'featured_genral_settings_section', esc_html__( 'Button Text Color', 'ananyapro' ), '','postMessage', 6, $defaults['frontpage_button_text_color'] );

	//Frontpage section overline text color
	ananyapro_color_control(  'frontpage_sec_name_text_color', 'featured_genral_settings_section', esc_html__( 'Section Overline Text Color', 'ananyapro' ), '','postMessage', 7, $defaults['frontpage_sec_name_text_color'] );

	//Frontpage section tagline text color
	ananyapro_color_control(  'frontpage_sec_tagline_text_color', 'featured_genral_settings_section', esc_html__( 'Section Tagline Text Color', 'ananyapro' ), '','postMessage', 8, $defaults['frontpage_sec_tagline_text_color'] );

	//Top widget section background color
	ananyapro_color_control( 'top_widget_section_bg_color', 'featured_genral_settings_section', esc_html__( 'Frontpage Top Widget Section Background color', 'ananyapro' ), '', 'postMessage', 9, $defaults['section_bg_color'] );

	//Bottom widget section background color
	ananyapro_color_control( 'bottom_widget_section_bg_color', 'featured_genral_settings_section', esc_html__( 'Frontpage Bottom Widget Section Background color', 'ananyapro' ), '', 'postMessage', 9, $defaults['section_bg_color'] );
}

function ananyapro_add_featured_content_section_settings( $wp_customize, $defaults ) {
	//  ======================================================
    //  = Featured Content Section     =
    //  ======================================================
	$feat_sec_priority = $defaults['feat_content_sec_priority'];
	$num_sections =  $defaults['total_no_of_each_type_section'];
	
	for($sec_no = 1; $sec_no <= $num_sections; $sec_no++ ) {
		
	    $wp_customize->add_section( 'ananyapro_featured_content_section_'.$sec_no, array(
		  'title' 		=> 	esc_html__( 'Featured Content ', 'ananyapro' ).$sec_no,
		  'priority' 	=> 	ananyapro_get_section_position('ananyapro_featured_content_section_'.$sec_no),
		  'panel' 		=> 	'ananyapro_frontpage_panel',
		) );
	    
	    //Disable/Hide front page sections           =    
		ananyapro_checkbox_control( 'disable_feat_sec'.$sec_no,  'featured_content_section_'.$sec_no, esc_html__( 'Disable this featured content section', 'ananyapro' ), '', 'postMessage', 1, $defaults['disable_feat_sec'] );

		//Section background color
		ananyapro_color_control( 'content_section_bg_color_sec_'.$sec_no, 'featured_content_section_'.$sec_no, esc_html__( 'Section Background color', 'ananyapro' ), '', 'postMessage', 2, $defaults['feat_content_sec_bg'] );

		$choices  =	array(
        	'dark'	=>	esc_html__( 'Dark', 'ananyapro' ),
        	'light'	=>	esc_html__( 'Light', 'ananyapro' ),
		);
		ananyapro_radio_control( 'feat_content_text_color_scheme_sec'.$sec_no,  'featured_content_section_'.$sec_no, esc_html__( 'Select text color scheme', 'ananyapro' ), esc_html__( 'Dark text for lignt background and Light text for dark background.', 'ananyapro' ), $choices, 'refresh', 2, $defaults['section-color-scheme'] );

		//add overline
		ananyapro_text_control( 'feat_content_section_name_sec'.$sec_no,  'featured_content_section_'.$sec_no, esc_html__( 'Section Overline', 'ananyapro' ), '', 'postMessage', 3, $defaults['feat_title_sec'] );

		//add title
		ananyapro_text_control( 'feat_content_title_sec'.$sec_no, 'featured_content_section_'.$sec_no, esc_html( 'Section Title', 'ananyapro' ), '', 'postMessage', 4, $defaults['feat_title_sec'] );

		//add tagline
		ananyapro_text_control( 'feat_content_tagline_sec'.$sec_no, 'featured_content_section_'.$sec_no, esc_html__( 'Section Tagline', 'ananyapro' ), '', 'postMessage', 5, $defaults['feat_tagline_sec'] );

		//add image
	   	ananyapro_image_control( 'feat_image_sec'.$sec_no, 'featured_content_section_'.$sec_no, esc_html__( 'Upload an image', 'ananyapro' ), 'refresh', 7, $defaults['feat_image_sec'] );
	   	
	   	//add image position
		$choices	= 	array(
				    	'left'		=>	esc_html__( 'Left', 'ananyapro' ),
				    	'right'		=>	esc_html__( 'Right', 'ananyapro' ),
				    	'center'	=>	esc_html__( 'Center', 'ananyapro' ),
				    );
		ananyapro_select_control( 'feat_content_image_position'.$sec_no,  'featured_content_section_'.$sec_no, esc_html__( 'Image Position', 'ananyapro' ), '', $choices, 'postMessage', 10, $defaults['feat_image_position'] );
	   	
	   	//add section content
		ananyapro_textarea_control( 'feat_content_sec'.$sec_no,  'featured_content_section_'.$sec_no, esc_html__( 'Content', 'ananyapro' ), '', 'postMessage', 11, $defaults['feat_content_sec'] );

		//add button text
	    ananyapro_text_control( 'feat_button_text_sec'.$sec_no,  'featured_content_section_'.$sec_no, esc_html__( 'Button text', 'ananyapro' ), '', 'refresh', 12, '' );

	    //add button url
	    ananyapro_url_control( 'feat_button_url_sec'.$sec_no,  'featured_content_section_'.$sec_no, esc_html__( 'Button URL', 'ananyapro' ), '', 'refresh', 13, '' );

	    //add selective refresh for section
	    $wp_customize->selective_refresh->add_partial(
			'ananyapro_disable_feat_sec'.$sec_no,
			array(
				'selector'            => '#feat-content-sec-' . $sec_no,
				'render_callback'     => 'ananyapro_display_featured_content_section',
				'container_inclusive' => true,
			)
		);
	} //end of for loop
}

function ananyapro_add_featured_category_section_settings( $wp_customize, $defaults ) {
	//  ==========================================================
    //  = Featured Category Sections        =
    //  ==========================================================
    $terms = get_terms( 'category', array(
	    'orderby'    => 'name',
	    'hide_empty' => 1,
	) );
	$categories['select-category'] = esc_html__( '--Select Category--', 'ananyapro' );
	if ( ! empty( $terms ) && ! is_wp_error( $terms ) ) {
		foreach ($terms as $term) {
			$categories[$term->name] = $term->name.'('.$term->count.')';
		}
	}
	$feat_cat_sec_priority = $defaults['feat_category_sec_priority'];
	$num_sections =  $defaults['total_no_of_each_type_section'];
    for( $i = 1; $i <=$num_sections; $i++ ) {
		
	    $wp_customize->add_section( 'ananyapro_featured_category_section_'.$i, array(
		  'title' 		=> 	esc_html__( 'Categorized Posts  ', 'ananyapro' ).$i,
		  'priority' 	=>  ananyapro_get_section_position( 'ananyapro_featured_category_section_'.$i ),
		  'panel' 		=> 	'ananyapro_frontpage_panel',
		) );
		
	    // Disable/Hide featured category section
	    ananyapro_checkbox_control( 'disable_cat_sec_'.$i,  'featured_category_section_'.$i, esc_html__( 'Disable this category section', 'ananyapro' ), '', 'postMessage', 1, $defaults['disable_cat_sec'] );

	    //Category Section background color
		ananyapro_color_control( 'category_section_bg_color_sec_'.$i, 'featured_category_section_'.$i, esc_html__( 'Section Background color', 'ananyapro' ), '', 'postMessage', 2, $defaults['feat_category_sec_bg'] );

		//text color scheme
		$choices  =	array(
        	'dark'	=>	esc_html__( 'Dark', 'ananyapro' ),
        	'light'	=>	esc_html__( 'Light', 'ananyapro' ),
		);
		ananyapro_radio_control( 'cat_section_text_color_scheme_sec'.$i,  'featured_category_section_'.$i, esc_html__( 'Select text color scheme', 'ananyapro' ), esc_html__( 'Dark text for lignt background and Light text for dark background.', 'ananyapro' ), $choices, 'refresh', 2, $defaults['section-color-scheme'] );

	    //Category section overline
	    ananyapro_text_control( 'cat_section_name_sec'.$i,  'featured_category_section_'.$i, esc_html__( 'Section Overline', 'ananyapro' ), '', 'postMessage', 3, $defaults['feat_title_sec'] );

		//Category section title
		ananyapro_text_control( 'cat_title_sec'.$i,  'featured_category_section_'.$i, esc_html__( 'Section Title', 'ananyapro' ), '', 'postMessage', 4, $defaults['feat_title_sec'] );

		//Category section tagline
		ananyapro_text_control( 'cat_tagline_sec'.$i,  'featured_category_section_'.$i, esc_html__( 'Section Tagline', 'ananyapro' ), '', 'postMessage', 5, $defaults['feat_title_sec'] );

		//Category selection dropdown
		ananyapro_select_control( 'cat_select_'.$i,  'featured_category_section_'.$i, 'Select Category', '', $categories, 'refresh', 6, $defaults['default_cat'] );

		$choices =	array(
			    	'date'		=>	esc_html__( 'Published date','ananyapro'),
			    	'mdate'		=>	esc_html__( 'Modified date','ananyapro' ),
			    	'rand'		=>	esc_html__( 'Random', 'ananyapro' ),
			    );
		ananyapro_select_control( 'cat_sort_order_select_'.$i,  'featured_category_section_'.$i, esc_html__( 'Display Categoriesed Post sorted by', 'ananyapro' ), '', $choices, 'refresh', 7, $defaults['feat_cat_sort_order'] );

		//Category posts - column layout
		$choices =	array(
			    	'column-2'		=>	esc_html__( '2 Columns','ananyapro'),
			    	'column-3'		=>	esc_html__( '3 Columns','ananyapro' ),
			    	'column-4'		=>	esc_html__( '4 Columns', 'ananyapro' ),
			    );
		ananyapro_select_control( 'cat_post_layout_select_'.$i,  'featured_category_section_'.$i, esc_html__( 'Post Layout', 'ananyapro' ), '', $choices, 'refresh', 8, $defaults['feat_cat_layout'] );

		//Category posts - column layout
		$choices =	array(
			    	'style1'		=>	esc_html__( 'Style 1','ananyapro'),
			    	'style2'		=>	esc_html__( 'Style 2','ananyapro' ),
			    );
		ananyapro_select_control( 'cat_post_style_select_'.$i,  'featured_category_section_'.$i, esc_html__( 'Post Style', 'ananyapro' ), '', $choices, 'refresh', 8, $defaults['feat_cat_post_style'] );

		//total number of posts
		$input_attrs = array(
						'min' => 1,
						'max' => 10,
					);
		ananyapro_number_control( 'cat_post_per_page_select_'.$i,  'featured_category_section_'.$i, esc_html__( 'Number of posts to be displayed', 'ananyapro' ), '', $input_attrs, 'refresh', 9, $defaults['feat_cat_no_of_posts_per_sec'], 'ananyapro_sanitize_post_per_page_number' );

		//Category - View More link text
	    ananyapro_text_control( 'cat_sec_button_text_'.$i, 'featured_category_section_'.$i, esc_html__('View More Link Text', 'ananyapro' ), '', 'refresh', 10, $defaults['cat_sec_btn_text'] );

		// Disable/Hide view more link
		ananyapro_checkbox_control( 'hide_cat_sec_view_more_link_'.$i,  'featured_category_section_'.$i, esc_html__( 'Hide view more link', 'ananyapro' ), '', 'postMessage', 11, false );

		// Disable/Hide post excerpt
		ananyapro_checkbox_control( 'hide_cat_post_date_'.$i,  'featured_category_section_'.$i, esc_html__('Hide Post Date', 'ananyapro' ), '', 'postMessage', 12, false, 'ananyapro_is_cat_layout_style2' );

		// Disable/Hide post excerpt
		ananyapro_checkbox_control( 'hide_cat_sec_post_excerpt_'.$i,  'featured_category_section_'.$i, esc_html__('Hide Post Excerpt', 'ananyapro' ), '', 'postMessage', 13, false, 'ananyapro_is_cat_layout_style2' );

		$wp_customize->selective_refresh->add_partial(
			'ananyapro_disable_cat_sec_' . $i,
			array(
				'selector'            => '#feat-cat-sec-' . $i,
				'render_callback'     => 'ananyapro_display_featured_category_section',
				'container_inclusive' => true,
			)
		);
	}
}
function ananyapro_add_featured_pages_section_settings( $wp_customize, $defaults ) {
	
	$feat_page_sec_priority = $defaults['feat_page_sec_priority'];
	$num_sections =  $defaults['total_no_of_each_type_section'];
	// Create a setting and control for each of the sections available in the theme.
	for ( $i = 1; $i <= $num_sections; $i++ ) {
		$wp_customize->add_section( 'ananyapro_featured_pages_section_'.$i, array(
		  'title' 		=> 	esc_html__( 'Featured Pages ', 'ananyapro' ).$i,
		  'priority' 	=>	ananyapro_get_section_position( 'ananyapro_featured_pages_section_'.$i ),
		  'panel' 		=> 	'ananyapro_frontpage_panel',
		) );

		ananyapro_checkbox_control( 'disable_feat_page_sec_'.$i, 'featured_pages_section_'.$i, esc_html__( 'Disable this featured pages section.', 'ananyapro' ), '', 'postMessage', 1, false );

		//Featured Pages Section background color
		ananyapro_color_control( 'page_section_bg_color_sec_'.$i, 'featured_pages_section_'.$i, esc_html__( 'Section Background color', 'ananyapro' ), '', 'postMessage', 2, $defaults['feat_pages_sec_bg'] );

		//text color scheme
		$choices  =	array(
        	'dark'	=>	esc_html__( 'Dark', 'ananyapro' ),
        	'light'	=>	esc_html__( 'Light', 'ananyapro' ),
		);
		ananyapro_radio_control( 'page_section_text_color_scheme_sec'.$i,  'featured_pages_section_'.$i, esc_html__( 'Select text color scheme', 'ananyapro' ), esc_html__( 'Dark text for lignt background and Light text for dark background.', 'ananyapro' ), $choices, 'refresh', 2, $defaults['section-color-scheme'] );

		$choices = array(
			'column-1'	=>	esc_html__( '1 Column-Full Content', 'ananyapro' ),
			'column-3'	=>	esc_html__( '3 Columns-Page Name', 'ananyapro' ),
		);
		ananyapro_radio_control( 'pages_layout_sec'.$i, 'featured_pages_section_'.$i, esc_html__('Section Layout', 'ananyapro' ), '', $choices, 'refresh', 3, $defaults['pages_layout_sec'] );

		ananyapro_text_control( 'pages_sec_name_'.$i, 'featured_pages_section_'.$i, esc_html__('Section Overline', 'ananyapro' ), '', 'postMessage', 4, $defaults['feat_title_sec'] );

		ananyapro_text_control( 'pages_sec_title_'.$i, 'featured_pages_section_'.$i, esc_html__('Section Title', 'ananyapro' ), '', 'postMessage', 5, $defaults['feat_title_sec'] );

		ananyapro_text_control( 'pages_sec_tagline_'.$i, 'featured_pages_section_'.$i, esc_html__( 'Section Tagline', 'ananyapro' ), '', 'postMessage', 6, $defaults['feat_title_sec'] );

		$priority = 9;
		for ($page = 1; $page <= 3; $page++ ) {

			//pages dropdown control
			$wp_customize->add_setting(
				'ananyapro_feat_page' . $page.'_sec'.$i,
				array(
					'default'           => false,
					'sanitize_callback' => 'absint',
					'transport'         => 'refresh',
				)
			);
			$wp_customize->add_control(
				'ananyapro_feat_page' . $page.'_sec'.$i,
				array(
					/* translators: %d: The front page section number. */
					'label'           =>  esc_html__( 'Select the page - ', 'ananyapro' ).$page,
					'description'     => esc_html__( 'Select pages to feature in each area from the dropdowns. Add an image to a section by setting a featured image in the page editor. Empty page selection will not be displayed.', 'ananyapro' ),
					'section'		=> 'ananyapro_featured_pages_section_'.$i,
					'settings'		=>	'ananyapro_feat_page' . $page.'_sec'.$i,
					'type'			=> 'dropdown-pages',
					'allow_addition'  => true,
					'priority'	=> $priority,
				)
			);

			ananyapro_checkbox_control( 'hide_page_title_of_page'.$page.'_sec'.$i,    'featured_pages_section_'.$i, esc_html__('Hide Page', 'ananyapro' ).$page.esc_html__( ' Title', 'ananyapro' ), '', 'refresh', $priority+1, false, 'ananyapro_is_page_layout_1_column' );

			ananyapro_textarea_control( 'page'.$page.'_excerpt_sec'.$i,  'featured_pages_section_'.$i, esc_html__( 'Page', 'ananyapro' ).$page.esc_html__( ' Excerpt - ', 'ananyapro' ), '', 'postMessage', $priority+2, '', 'ananyapro_is_page_layout_3_column' );
			$priority = $priority + 3;
		}

		$wp_customize->selective_refresh->add_partial(
			'ananyapro_disable_feat_page_sec_'.$i,
			array( 
				'selector'            => '#feat-pages-sec-' . $i,
				'render_callback'     => 'ananyapro_display_featured_pages',
				'container_inclusive' => true,
			)
		);
	}
}
function ananyapro_add_CTA_section_settings( $wp_customize, $defaults ) {
	$num_sections =  $defaults['total_no_of_each_type_section'];
	for($sec_no = 1; $sec_no <= $num_sections; $sec_no++ ) {
		
	    $wp_customize->add_section( 'ananyapro_CTA_section_'.$sec_no, array(
			  'title' 		=> 	esc_html__( 'Call To Action ', 'ananyapro' ).$sec_no,
			  'priority' 	=> 	ananyapro_get_section_position( 'ananyapro_CTA_section_'.$sec_no ),
			  'panel' 		=> 	'ananyapro_frontpage_panel',
		) );
	    
	    //Disable/Hide front page sections
		ananyapro_checkbox_control( 'disable_cta_sec'.$sec_no,  'CTA_section_'.$sec_no, esc_html__( 'Disable this CTA section', 'ananyapro' ), '', 'postMessage', 1, $defaults['disable_feat_sec'] );

		$choices  =	array(
		        	'color'				=>	esc_html__( 'Color', 'ananyapro' ),
		        	'gradient'			=>	esc_html__( 'Gradient', 'ananyapro' ),
		        	'image'				=>	esc_html__( 'Image', 'ananyapro' ),
		        	'image-color'		=>	esc_html__( 'Image with Color Overlay', 'ananyapro' ),
		        	'image-gradient'	=>	esc_html__( 'Image with Gradient Overlay', 'ananyapro' ),
					);
		ananyapro_radio_control( 'cta_bg_type_sec'.$sec_no,  'CTA_section_'.$sec_no, esc_html__( 'CTA section\'s Background Type', 'ananyapro' ), '<i>'.esc_html__( 'For Image with color overlay, section background color will be used for overlay color. And for Image with gradient overlay, gradient start and end color will be used for overlay colors.', 'ananyapro' ).'</i>', $choices, 'refresh', 2, $defaults['cta-bg-type'] );

		ananyapro_color_control(  'cta_bg_color_sec'.$sec_no, 'CTA_section_'.$sec_no, esc_html__( 'Section Background Color', 'ananyapro' ), '', 'refresh', 3, $defaults['cta_sec_bg'] );

		ananyapro_color_control(  'cta_gradient_start_color_sec'.$sec_no, 'CTA_section_'.$sec_no, esc_html__( 'Bacground Gradient Start Color', 'ananyapro' ), '', 'refresh', 4, $defaults['gradient_start_color'] );

		ananyapro_color_control(  'cta_gradient_end_color_sec'.$sec_no, 'CTA_section_'.$sec_no, esc_html__( 'Bacground Gradient End Color', 'ananyapro' ), '', 'refresh', 5, $defaults['gradient_end_color'] );

		//Color opacity control
		$wp_customize->add_setting( 'ananyapro_cta_color_overlay_opacity_sec'.$sec_no, 
			array(
			    'default'        	=> 	$defaults['overlay_opacity'],
			    'sanitize_callback' => 	'ananyapro_sanitize_unsigned_floatval',
				'transport'         => 	'refresh',
		));
		$wp_customize->add_control( new Ananyapro_Range_Custom_Control( $wp_customize, 'ananyapro_cta_color_overlay_opacity_sec'.$sec_no,
			array(
				'type'			=> 	'ananyapro-range-responsive',
				'description' 	=> 	esc_html__( 'Color Overlay Opacity', 'ananyapro' ),
				'section' 		=> 	'ananyapro_CTA_section_'.$sec_no,
				'settings' 		=> 	array(
					'desktop' 	=> 	'ananyapro_cta_color_overlay_opacity_sec'.$sec_no
				),
				'input_attrs' 	=> 	array(
					'desktop' 	=> 	array(
						'min' 	=> 	0,
						'max' 	=> 	1,
						'step' 	=> 	0.1,
						'unit' 	=> 	'',
					),
				),
				'priority'		=>	6,
			)
		) );
		//Gradient opacity control
		$wp_customize->add_setting( 'ananyapro_cta_gradient_overlay_opacity_sec'.$sec_no, 
			array(
			    'default'        	=> 	$defaults['overlay_opacity'],
			    'sanitize_callback' => 	'ananyapro_sanitize_unsigned_floatval',
				'transport'         => 	'refresh',
		));
		$wp_customize->add_control( new Ananyapro_Range_Custom_Control( $wp_customize, 'ananyapro_cta_gradient_overlay_opacity_sec'.$sec_no,
			array(
				'type'			=> 	'ananyapro-range-responsive',
				'description' 	=> 	esc_html__( 'Gradient Overlay Opacity', 'ananyapro' ),
				'section' 		=> 	'ananyapro_CTA_section_'.$sec_no,
				'settings' 		=> 	array(
					'desktop' 	=> 	'ananyapro_cta_gradient_overlay_opacity_sec'.$sec_no
				),
				'input_attrs' 	=> 	array(
					'desktop' 	=> 	array(
						'min' 	=> 	0,
						'max' 	=> 	1,
						'step' 	=> 	0.1,
						'unit' 	=> 	'',
					),
				),
				'priority'		=>	7,
			)
		) );

	   	ananyapro_image_control( 'cta_bg_image_sec'.$sec_no,  'CTA_section_'.$sec_no, esc_html__( 'Section Background Image', 'ananyapro' ), 'refresh', 8, $defaults['cta_sec_bg_image'] );

	   	$choices  =	array(
			        	'dark'	=>	esc_html__( 'Dark', 'ananyapro' ),
			        	'light'	=>	esc_html__( 'Light', 'ananyapro' ),
					);
		ananyapro_radio_control( 'cta_text_color_scheme_sec'.$sec_no,  'CTA_section_'.$sec_no, esc_html__( 'Select text color scheme', 'ananyapro' ), esc_html__( 'Dark text for lignt background and Light text for dark background.', 'ananyapro' ), $choices, 'refresh', 9, $defaults['cta-color-scheme'] );

		//Add CTA section name
		ananyapro_text_control( 'cta_section_name_sec'.$sec_no,  'CTA_section_'.$sec_no, esc_html__('Section Overline', 'ananyapro' ), '', 'postMessage', 10, $defaults['feat_title_sec'] );

		//Add CTA section title
		ananyapro_text_control( 'cta_title_sec'.$sec_no,  'CTA_section_'.$sec_no, esc_html__('Section Title', 'ananyapro' ), '', 'postMessage', 11, $defaults['feat_title_sec'] );

		//Add CTA section tagline
		ananyapro_text_control( 'cta_tagline_sec'.$sec_no,  'CTA_section_'.$sec_no, esc_html__('Section Tagline', 'ananyapro' ), '', 'postMessage', 12, $defaults['feat_title_sec'] );

		ananyapro_textarea_control( 'cta_content_sec'.$sec_no,  'CTA_section_'.$sec_no, esc_html__( 'Content', 'ananyapro' ), '', 'postMessage', 13, $defaults['feat_content_sec'] );

		for( $btn = 1; $btn <=2; $btn++ ){
		    ananyapro_text_control( 'cta_button'.$btn.'_text_sec'.$sec_no,  'CTA_section_'.$sec_no, esc_html__( 'Button', 'ananyapro' ).$btn.esc_html__(' Text', 'ananyapro' ), '', 'refresh', (14+$btn-1), '' );

		    ananyapro_url_control( 'cta_button'.$btn.'_url_sec'.$sec_no,  'CTA_section_'.$sec_no, esc_html__( 'Button', 'ananyapro' ).$btn.esc_html__( ' URL', 'ananyapro' ), '', 'postMessage', (15+$btn-1), '' );
		}
		$wp_customize->selective_refresh->add_partial(
			'ananyapro_disable_cta_sec' . $sec_no,
			array(
				'selector'            => '#cta-sec-' . $sec_no,
				'render_callback'     => 'ananyapro_display_CTA_section',
				'container_inclusive' => true
			)
		);
	}
}

function ananyapro_latest_post_section( $wp_customize, $defaults ) {
	$wp_customize->add_section( 'ananyapro_latest_posts_section', array(
	  'title' 		=> 	esc_html__( 'Latest Posts Section', 'ananyapro' ),
	  'priority' 	=> 	ananyapro_get_section_position('ananyapro_latest_posts_section'),
	  'panel' 		=> 	'ananyapro_frontpage_panel',
	) );
	ananyapro_checkbox_control( 'disable_latest_post_sec',  'latest_posts_section', esc_html__('Disable this latest post section', 'ananyapro' ), '', 'postMessage', 1, true );
	
	ananyapro_color_control(  'recent_post_sec_bg_color', 'latest_posts_section', esc_html__( 'Section Backgound Color', 'ananyapro' ) , '', 'postMessage', 2, '#ffffff', '' );
	$choices  =	array(
		        	'dark'	=>	esc_html__( 'Dark', 'ananyapro' ),
		        	'light'	=>	esc_html__( 'Light', 'ananyapro' ),
				);
	ananyapro_radio_control( 'recent_post_text_color_scheme_sec',  'latest_posts_section', esc_html__( 'Select text color scheme', 'ananyapro' ), esc_html__( 'Dark text for lignt background and Light text for dark background.', 'ananyapro' ), $choices, 'refresh', 2, $defaults['section-color-scheme'] );
	ananyapro_text_control( 'recent_post_sec_name',  'latest_posts_section', esc_html__( 'Section Overline', 'ananyapro' ), '', 'postMessage', 3, $defaults['feat_title_sec'] );
	ananyapro_text_control( 'recent_post_sec_title',  'latest_posts_section', esc_html__( 'Section Title', 'ananyapro' ), '', 'postMessage', 4, $defaults['feat_title_sec'] );
	ananyapro_text_control( 'recent_post_sec_tagline',  'latest_posts_section', esc_html__( 'Section Tagline', 'ananyapro' ), '', 'postMessage', 5, $defaults['feat_title_sec'] );
	$atts = array(
		'min' => 1,
		'max' => 10,
	);
	ananyapro_number_control( 'recent_posts_total_no',  'latest_posts_section', esc_html__( 'Total No of Posts', 'ananyapro' ), '', $atts, 'refresh', 6, $defaults['latest_post_total_no_posts'], 'ananyapro_sanitize_post_per_page_number' );

	ananyapro_text_control( 'view_blog_button_text', 'latest_posts_section', esc_html__( 'View Blog Button Text', 'ananyapro' ), '', 'refresh', 7, $defaults['latest_post_view_btn_text'] );

	$wp_customize->selective_refresh->add_partial(
		'ananyapro_disable_latest_post_sec',
		array(
			'selector'            => '#latest-posts-sec',
			'render_callback'     => 'ananyapro_display_latest_posts',
			'container_inclusive' => true,
		)
	);
}

function ananyapro_showcase_categories_section( $wp_customize, $defaults ) {
	$wp_customize->add_section( 'ananyapro_showcase_categories_section', array(
	  'title' 		=> 	esc_html__( 'Showcase any 4 Categories', 'ananyapro' ),
	  'priority' 	=> 	ananyapro_get_section_position('ananyapro_showcase_categories_section'),
	  'panel' 		=> 	'ananyapro_frontpage_panel',
	) );
	$terms = get_terms( 'category', array(
	    'orderby'    => 'name',
	    'hide_empty' => 1,
	) );
	$categories['select-category'] = esc_html__( '--Select Category--', 'ananyapro' );
	if ( ! empty( $terms ) && ! is_wp_error( $terms ) ) {
		foreach ($terms as $term) {
			$categories[$term->name] = $term->name.'('.$term->count.')';
		}
	}

	//Disable/Hide front page sections           =    
	ananyapro_checkbox_control( 'disable_showcase_categories_sec',  'showcase_categories_section', esc_html__( 'Disable this  section', 'ananyapro' ), '', 'postMessage', 1, $defaults['disable_feat_sec'] );

	ananyapro_color_control(  'showcase_cat_sec_bg_color', 'showcase_categories_section', esc_html__( 'Section Backgound Color', 'ananyapro' ) , '', 'postMessage', 2, '#ffffff', '' );

	//Category section overline
    ananyapro_text_control( 'showcase_cat_sec_name', 'showcase_categories_section', esc_html__( 'Section Overline', 'ananyapro' ), '', 'postMessage', 2, $defaults['feat_title_sec'] );

	//Category section title
	ananyapro_text_control( 'showcase_cat_sec_title', 'showcase_categories_section', esc_html__( 'Section Title', 'ananyapro' ), '', 'postMessage', 3, $defaults['feat_title_sec'] );

	//Category section tagline
	ananyapro_text_control( 'showcase_cat_sec_tagline','showcase_categories_section', esc_html__( 'Section Tagline', 'ananyapro' ), '', 'postMessage', 4, $defaults['feat_title_sec'] );

	for( $i=1,$j=2; $i <= 4; $i++,$j+=2 ) {
		ananyapro_select_control( 'showcase_cat_'.$i, 'showcase_categories_section', esc_html__( 'Select Category', 'ananyapro' ).$i, '', $categories, 'refresh', ($j-1)+4, $defaults['default_cat'] );
		ananyapro_image_control( 'showcase_cat_image_'.$i,  'showcase_categories_section', esc_html__( 'Select background image for Category box ', 'ananyapro' ).$i, 'refresh', $j+4,  $defaults['feat_image_sec']  );
	}

	$wp_customize->selective_refresh->add_partial(
		'ananyapro_disable_showcase_categories_sec',
		array(
			'selector'            => '#showcase-categories-section',
			'render_callback'     => 'ananyapro_display_showcase_categories_section',
			'container_inclusive' => true,
		)
	);
}

function ananyapro_is_page_layout_3_column( $control ) {
	$control_id = $control->id;
	$layout_setting = '';
	if( $control_id === 'ananyapro_page1_excerpt_sec1' || $control_id === 'ananyapro_page2_excerpt_sec1' || $control_id === 'ananyapro_page3_excerpt_sec1' ) {
		$layout_setting = $control->manager->get_setting( 'ananyapro_pages_layout_sec1' )->value();
	} else if( $control_id === 'ananyapro_page1_excerpt_sec2' || $control_id === 'ananyapro_page2_excerpt_sec2' || $control_id === 'ananyapro_page3_excerpt_sec2' ) {
		$layout_setting = $control->manager->get_setting( 'ananyapro_pages_layout_sec2' )->value();
	} 
	if( $layout_setting === 'column-3' ) {
		return true;
	} else {
		return false;
	}
}

function ananyapro_is_page_layout_1_column( $control ) {
	$control_id = $control->id;
	$layout_setting = '';
	if( $control_id === 'ananyapro_hide_page_title_of_page1_sec1' || $control_id === 'ananyapro_hide_page_title_of_page2_sec1' || $control_id === 'ananyapro_hide_page_title_of_page3_sec1' ) {
		$layout_setting = $control->manager->get_setting( 'ananyapro_pages_layout_sec1' )->value();
	} else if( $control_id === 'ananyapro_hide_page_title_of_page1_sec2' || $control_id === 'ananyapro_hide_page_title_of_page2_sec2' || $control_id === 'ananyapro_hide_page_title_of_page3_sec2' ) {
		$layout_setting = $control->manager->get_setting( 'ananyapro_pages_layout_sec2' )->value();
	} 
	if( $layout_setting === 'column-1' ) {
		return true;
	} else {
		return false;
	}
}

function ananyapro_is_cat_layout_style2( $control ) {
	$control_id = $control->id;
	$layout_setting = '';
	if( $control_id === 'ananyapro_hide_cat_post_date_1' || $control_id === 'ananyapro_hide_cat_sec_post_excerpt_1' ) {
		$style = $control->manager->get_setting( 'ananyapro_cat_post_style_select_1' )->value();
	} else if( $control_id === 'ananyapro_hide_cat_post_date_2' || $control_id === 'ananyapro_hide_cat_sec_post_excerpt_2'  ) {
		$style = $control->manager->get_setting( 'ananyapro_cat_post_style_select_2' )->value();
	} 
	if( $style === 'style2' ) {
		return true;
	} else {
		return false;
	}
}
