<?php
/**
 * AnanyaPRO Theme Customizer
 *
 * @package AnanyaPRO
 * @since 1.0
 */

/**
 * Add customizer settings and controls for page layout options.
 *
 * @param WP_Customize_Manager $wp_customize Theme Customizer object.
 */

function ananyapro_custom_page_layout_setup( $wp_customize ) {

	$defaults = ananyapro_get_defaults();
	
	//  =======================================================================
    //  = Single Post Option: Use featured image in header section            =
    //  =======================================================================
	$wp_customize->add_section( 'ananyapro_layout_section', array(
	  'title' 		=> 	esc_html__( 'Layout', 'ananyapro' ),
	  'priority' 	=> 	1,
	  'capability' 	=> 	'edit_theme_options',
	  'panel' 		=> 	'ananyapro_options_panel',
	) );
	//  =============================================================
    //  = Static Front page layout           =
    //  =============================================================
    $wp_customize->add_setting( 'ananyapro_static_front_page_layout', array(
	    'default'        	=> 	$defaults['static_front_page_layout'],
	    'sanitize_callback' => 	'ananyapro_sanitize_select',
		'transport'         => 	'refresh',
	));
	$wp_customize->add_control( 'ananyapro_static_front_page_layout', 
		array(
			'type'       	=> 	'select',
			'label' 		=> 	esc_html__( 'Static Front Page Layout', 'ananyapro' ),
			'description' 	=> 	esc_html__( 'This layout selection applies to static frontpage only when Frontpage Sections are disabled.', 'ananyapro' ),
		    'section'    	=> 	'ananyapro_layout_section',
		    'settings'   	=> 	'ananyapro_static_front_page_layout',
		    'choices'		=> 	array(
		    	'left-sidebar'	=>	esc_html__( 'Sidebar/Content', 'ananyapro' ),
		    	'right-sidebar'	=>	esc_html__( 'Content/Sidebar', 'ananyapro' ),
		    	'full-width'	=>	esc_html__( 'Content-Full Width', 'ananyapro' ),
		    	'slim'			=>	esc_html__( 'Content-Slim', 'ananyapro' ),
		    ),
		    'active_callback'	=>	'ananyapro_is_static_page',
	));
	//  =======================================================================
    //  = Blog page layout           =
    //  =======================================================================
    $wp_customize->add_setting( 'ananyapro_blog_page_layout', array(
	    'default'        	=> 	$defaults['blog_page_layout'],
	    'sanitize_callback' => 	'ananyapro_sanitize_select',
		'transport'         => 	'refresh',
	));
	$wp_customize->add_control( 'ananyapro_blog_page_layout', 
		array(
			'type'       	=> 	'select',
			'label' 		=> 	esc_html__( 'Blog Page Layout', 'ananyapro' ),
			'description' 	=> 	'',
		    'section'    	=> 	'ananyapro_layout_section',
		    'settings'   	=> 	'ananyapro_blog_page_layout',
		    'choices'		=> 	array(
		    	'left-sidebar'	=>	esc_html__( 'Sidebar/Content', 'ananyapro' ),
		    	'right-sidebar'	=>	esc_html__( 'Content/Sidebar', 'ananyapro' ),
		    	'full-width'	=>	esc_html__( 'Content-Full Width', 'ananyapro' ),
		    	'slim'			=>	esc_html__( 'Content-Slim', 'ananyapro' ),
		    ),
	));
	//  =======================================================================
    //  = Single page layout           =
    //  =======================================================================
    $wp_customize->add_setting( 'ananyapro_single_page_layout', array(
	    'default'        	=> 	$defaults['single_page_layout'],
	    'sanitize_callback' => 	'ananyapro_sanitize_select',
		'transport'         => 	'refresh',
	));
	$wp_customize->add_control( 'ananyapro_single_page_layout', 
		array(
			'type'       	=> 	'select',
			'label' 		=> 	esc_html__( 'Single Page Layout', 'ananyapro' ),
			'description' 	=> 	'',
		    'section'    	=> 	'ananyapro_layout_section',
		    'settings'   	=> 	'ananyapro_single_page_layout',
		    'choices'		=> 	array(
		    	'left-sidebar'	=>	esc_html__( 'Sidebar/Content', 'ananyapro' ),
		    	'right-sidebar'	=>	esc_html__( 'Content/Sidebar', 'ananyapro' ),
		    	'full-width'	=>	esc_html__( 'Content-Full Width', 'ananyapro' ),
		    	'slim'			=>	esc_html__( 'Content-Slim', 'ananyapro' ),
		    ),
	));
	//  =======================================================================
    //  = Single post layout           =
    //  =======================================================================
    $wp_customize->add_setting( 'ananyapro_single_post_layout', array(
	    'default'        	=> 	$defaults['single_post_layout'],
	    'sanitize_callback' => 	'ananyapro_sanitize_select',
		'transport'         => 	'refresh',
	));
	$wp_customize->add_control( 'ananyapro_single_post_layout', 
		array(
			'type'       	=> 	'select',
			'label' 		=> 	esc_html__( 'Single Post Layout', 'ananyapro' ),
			'description' 	=> 	'',
		    'section'    	=> 	'ananyapro_layout_section',
		    'settings'   	=> 	'ananyapro_single_post_layout',
		    'choices'		=> 	array(
		    	'left-sidebar'	=>	esc_html__( 'Sidebar/Content', 'ananyapro' ),
		    	'right-sidebar'	=>	esc_html__( 'Content/Sidebar', 'ananyapro' ),
		    	'full-width'	=>	esc_html__( 'Content-Full Width', 'ananyapro' ),
		    	'slim'			=>	esc_html__( 'Content-Slim', 'ananyapro' ),
		    ),
	));
}
add_action( 'customize_register', 'ananyapro_custom_page_layout_setup' );

if ( ! function_exists( 'ananyapro_is_static_page' ) ) :
	/**
	 * Active callback to find homepage display option('static page' or 'latest post').
	 *
	 *
	 * @return homepage display option.
	 * @since 1.0
	 */

function ananyapro_is_static_page( $control ) {
	$front_page_setting = get_option( 'show_on_front' );
	$disable_fp_sections = $control->manager->get_setting( 'ananyapro_enable_frontpage_sections' )->value();
	if( 'page' === $front_page_setting && true !== $disable_fp_sections ) {
		return true;
	} else {
		return false;
	}
}
endif; // ananyapro_is_static_page