<?php
/**
 * AnanyaPRO Theme Customizer
 *
 * @package AnanyaPRO
 * @since 1.0
 */

/**
 * Add customizer settings and controls for typography options.
 *
 * @param WP_Customize_Manager $wp_customize Theme Customizer object.
 *
 */
function ananyapro_custom_typography_options_setup( $wp_customize ) {

	$defaults = ananyapro_get_defaults();
	
	//  ==========================================================
    //  =  Body Typography Section        =
    //  ==========================================================
	$wp_customize->add_section( 'ananyapro_body_typography_section', array(
	  'title' 		=> 	esc_html__( 'Body Typography', 'ananyapro' ),
	  'priority' 	=> 	1,
	  'panel' 		=> 	'ananyapro_typography_panel',
	) );
	//  ==========================================================
    //  = Body Font Settings         =
    //  ==========================================================
	$wp_customize->add_setting( 'ananyapro_body_font_select',
		array(
			'default' => json_encode(
				array(
					'family' 			=> 	$defaults['body_font_family'],
					'weight' 			=> 	$defaults['body_font_weight'],
					'transformstyle'	=> 	$defaults['body_font_transformstyle'],
					'category' 			=> 	$defaults['body_font_category'],
				)
			),
			'sanitize_callback' 		=> 'ananyapro_google_font_sanitization'
		)
	);
	$wp_customize->add_control( new Ananya_Google_Font_Select_Custom_Control( $wp_customize, 'ananyapro_body_font_select',
		array(
			'label' 					=>	esc_html__( 'Body Font Family', 'ananyapro' ),
			'description' 				=> 	esc_html__( 'All Google Fonts sorted alphabetically.', 'ananyapro' ),
			'section' 					=> 	'ananyapro_body_typography_section',
			'settings' 					=> 	'ananyapro_body_font_select',
			'input_attrs' 				=> 	array(
				'font_count'			=>	'all',
				'orderby' 				=> 	'alpha',
			),
		)
	) );
	//  ==========================================================
    //  = Body Font Size         =
    //  ==========================================================

	$wp_customize->add_setting( 'ananyapro_body_font_size_desktop',
		array(
			'default' 					=> 	$defaults['body_font_size_desktop'],
			'transport' 				=> 	'postMessage',
			'sanitize_callback' 		=> 	'ananyapro_sanitize_unsigned_integer'
		)
	);
	$wp_customize->add_setting( 'ananyapro_body_font_size_mobile',
		array(
			'default' 					=> 	$defaults['body_font_size_mobile'],
			'transport' 				=> 	'postMessage',
			'sanitize_callback' 		=> 'ananyapro_sanitize_unsigned_integer'
		)
	);
	$wp_customize->add_control( new Ananyapro_Range_Custom_Control( $wp_customize, 'ananyapro_body_font_size_range',
		array(
			'type'			=> 	'ananyapro-range-responsive',
			'label'			=> 	esc_html__( 'Body Font', 'ananyapro'),
			'description' 	=> 	esc_html__( 'Font Size', 'ananyapro' ),
			'section' 		=> 	'ananyapro_body_typography_section',
			'settings' 		=> 	array(
							'desktop' => 'ananyapro_body_font_size_desktop',
							'mobile'  => 'ananyapro_body_font_size_mobile'
							),
			'input_attrs' 	=> 	array(
				'desktop' 	=> 	array(
					'min' 	=> 	10,
					'max' 	=> 	22,
					'step' 	=> 	1,
					'unit' 	=> 	'px',
				),
				'mobile' 	=> 	array(
					'min' 	=> 	10,
					'max' 	=> 	18,
					'step' 	=> 	1,
					'unit' 	=> 	'px',
				),
			),
		)
	) );
	$wp_customize->add_setting( 'ananyapro_body_line_height',
		array(
			'default' 				=> 	$defaults['body_line_height'],
			'transport' 			=> 	'postMessage',
			'sanitize_callback' 	=> 'ananyapro_sanitize_unsigned_floatval'
		)
	);
	$wp_customize->add_control( new Ananyapro_Range_Custom_Control( $wp_customize, 'ananyapro_body_line_height',
		array(
			'type'			=> 	'ananyapro-range-responsive',
			'description' 	=> 	esc_html__( 'Line Height', 'ananyapro' ),
			'section' 		=> 	'ananyapro_body_typography_section',
			'settings' 		=> 	array(
				'desktop' 	=> 	'ananyapro_body_line_height'
			),
			'input_attrs' 	=> 	array(
				'desktop' 	=> 	array(
					'min' 	=> 	1,
					'max' 	=> 	3,
					'step' 	=> 	0.05,
					'unit' 	=> 	'',
				),
			),
		)
	) );
	//  ==========================================================
    //  =  Heading Typography Section        =
    //  ==========================================================
	$wp_customize->add_section( 'ananyapro_heading_typography_section', array(
			'title' 		=>	esc_html__( 'Heading Typography', 'ananyapro' ),
			'priority' 		=>	1,
			'capability' 	=> 	'edit_theme_options',
			'panel' 		=> 	'ananyapro_typography_panel',
	) );
	//  ==========================================================
    //  = Heading Font Settings         =
    //  ==========================================================
	$wp_customize->add_setting( 'ananyapro_heading_font_select',
		array(
			'default' 					=>	json_encode(
				array(
					'family'			=> 	$defaults['heading_font_family'],
					'weight'			=> 	$defaults['heading_font_weight'],
					'transformstyle'	=> 	$defaults['heading_font_transformstyle'],
					'category'			=> 	$defaults['heading_font_category'],
				)
			),
			'sanitize_callback' 		=> 'ananyapro_google_font_sanitization'
		)
	);
	$wp_customize->add_control( new Ananya_Google_Font_Select_Custom_Control( $wp_customize, 'ananyapro_heading_font_select',
		array(
			'label' 		=> 	esc_html__( 'Heading Font Family', 'ananyapro' ),
			'description' 	=> 	esc_html__( 'All Google Fonts sorted alphabetically.', 'ananyapro' ),
			'section' 		=> 	'ananyapro_heading_typography_section',
			'settings' 		=> 	'ananyapro_heading_font_select',
			'input_attrs' 	=> 	array(
				'font_count'=> 	'all',
				'orderby'	=> 	'alpha',
			),
		)
	) );
	//  ==========================================================
    //  = Heading font line height and letter spacing         =
    //  ==========================================================
	$wp_customize->add_setting( 'ananyapro_heading_line_height',
		array(
			'default' 					=>	$defaults['heading_line_height'],
			'transport' 				=> 	'postMessage',
			'sanitize_callback' 		=> 	'ananyapro_sanitize_unsigned_floatval'
		)
	);
	$wp_customize->add_control( new Ananyapro_Range_Custom_Control( $wp_customize, 'ananyapro_heading_line_height',
		array(
			'type'			=> 	'ananyapro-range-responsive',
			'label'			=>	esc_html__( 'Heading Fonts (H1-H6)', 'ananyapro' ),
			'description' 	=> 	esc_html__( 'Line Height', 'ananyapro' ),
			'section' 		=> 	'ananyapro_heading_typography_section',
			'settings' 		=> 	array(
				'desktop' 	=> 	'ananyapro_heading_line_height'
			),
			'input_attrs' 	=> 	array(
				'desktop' 	=> 	array(
					'min' 	=> 	1,
					'max' 	=> 	3,
					'step'	=> 	0.05,
					'unit' 	=> 	'',
				),
			),
		)
	) );
	$wp_customize->add_setting( 'ananyapro_heading_letter_spacing',
		array(
			'default' 			=>	$defaults['heading_letter_spacing'],
			'transport' 		=> 	'postMessage',
			'sanitize_callback' => 	'ananyapro_sanitize_floatval'
		)
	);
	$wp_customize->add_control( new Ananyapro_Range_Custom_Control( $wp_customize, 'ananyapro_heading_letter_spacing',
		array(
			'type'			=> 	'ananyapro-range-responsive',
			'description' 	=> 	esc_html__( 'Letter Spacing', 'ananyapro' ),
			'section' 		=> 	'ananyapro_heading_typography_section',
			'settings' 		=> 	array(
								'desktop' => 'ananyapro_heading_letter_spacing'
								),
			'input_attrs' 	=>	array(
				'desktop' 	=> 	array(
					'min' 	=> 	-2,
					'max' 	=> 	2,
					'step' 	=> 	0.1,
					'unit' 	=> 	'px',
				),
			),
		)
	) );
	//  ==========================================================
    //  = Heading font size         =
    //  ==========================================================
	$wp_customize->add_control( new Ananyapro_Customize_Heading_Control( $wp_customize, 'ananyapro_heading_sec_headline_control',
			array(
				'type'			=> 	'ananyapro-range-responsive',
				'label'			=> 	esc_html__( 'Headings Font Sizes', 'ananyapro' ),
				'description' 	=> 	__( 'Heading Font sizes uses \'em\' unit. Conversion formula for em to px: (px value) =(value in em)*(body font size). For example: If H1 is 3em and body font size is 18px then, H1 = 3*18 = 54px.','ananyapro'),
				'section' 		=> 	'ananyapro_heading_typography_section',
				'settings' => array(),
			)
		) );
	for($i = 1; $i <= 6; $i++ ) {
		$wp_customize->add_setting( 'ananyapro_heading'.$i.'_font_size_desktop',
			array(
				'default'			=>	$defaults['heading'.$i.'_font_size_desktop'],
				'transport' 		=> 	'postMessage',
				'sanitize_callback' => 	'ananyapro_sanitize_unsigned_floatval'
			)
		);
		$wp_customize->add_setting( 'ananyapro_heading'.$i.'_font_size_mobile',
			array(
				'default'			=>	$defaults['heading'.$i.'_font_size_mobile'],
				'transport' 		=> 	'postMessage',
				'sanitize_callback' => 	'ananyapro_sanitize_unsigned_floatval'
			)
		);
		$wp_customize->add_control( new Ananyapro_Range_Custom_Control( $wp_customize, 'ananyapro_heading'.$i.'_font_size_range',
			array(
				'type'			=> 	'ananyapro-range-responsive',
				'label'			=> 	esc_html__( 'Heading ','ananyapro').$i.' (H'.$i.')',
				'description' 	=> 	esc_html__( 'Font Size', 'ananyapro' ),
				'section' 		=> 	'ananyapro_heading_typography_section',
				'settings' 		=> 	array(
										'desktop' => 'ananyapro_heading'.$i.'_font_size_desktop',
										'mobile'  => 'ananyapro_heading'.$i.'_font_size_mobile',
									),
				'input_attrs' 	=> 	array(
					'desktop' 	=> 	array(
						'min' 	=> 	0.5,
						'max' 	=> 	4,
						'step' 	=> 	0.001,
						'unit' 	=> 	'em',
					),
					'mobile' 	=> 	array(
						'min' 	=> 	0.5,
						'max' 	=> 	4,
						'step' 	=> 	0.001,
						'unit' 	=> 	'em',
					),
				),
			)
		) );
	}
	//  ==========================================================
    //  =  Menu Typography Section        =
    //  ==========================================================
	$wp_customize->add_section( 'ananyapro_top_menu_typography_section', array(
	  'title' 		=> 	esc_html__( 'Top Menu Typography', 'ananyapro' ),
	  'priority' 	=> 	1,
	  'capability' 	=> 	'edit_theme_options',
	  'panel' 		=> 	'ananyapro_typography_panel',
	) );
	//============================================================
    //  = Menu Item Font Family        =
    //  ==========================================================
	$wp_customize->add_setting( 'ananyapro_menu_item_font_family', array(
	    'default'        	=> 	$defaults['menu_item_font_family'],
	    'sanitize_callback' => 	'ananyapro_sanitize_select',
		'transport'         => 	'refresh',
	));
	$wp_customize->add_control( 'ananyapro_menu_item_font_family', 
		array(
			'type'       	=> 	'select',
			'label' 		=> 	esc_html__( 'Menu Item Fonts Family : Same As', 'ananyapro' ),
		    'section'    	=> 	'ananyapro_top_menu_typography_section',
		    'settings'   	=> 	'ananyapro_menu_item_font_family',
		    'choices'		=> 	array(
				'body-font'			=>	esc_html__( 'Body Font', 'ananyapro' ),
		    	'heading-font'		=>	esc_html__( 'Heading Font', 'ananyapro' ),
		    ),
	));
	//  ==========================================================
    //  = Menu Font Size         =
    //  ==========================================================

	$wp_customize->add_setting( 'ananyapro_menu_font_size',
		array(
			'default' 			=> 	$defaults['menu_font_size'],
			'transport' 		=> 	'postMessage',
			'sanitize_callback' => 	'ananyapro_sanitize_unsigned_integer'
		)
	);
	$wp_customize->add_control( new Ananyapro_Range_Custom_Control( $wp_customize, 'ananyapro_menu_font_size_range',
		array(
			'type'			=>	'ananyapro-range-responsive',
			'label'			=> 	esc_html__( 'Menu Item', 'ananyapro'),
			'description' 	=> 	esc_html__( 'Font Size', 'ananyapro' ),
			'section' 		=> 	'ananyapro_top_menu_typography_section',
			'settings' 		=> 	array(
									'desktop' => 'ananyapro_menu_font_size',
								),
			'input_attrs' 	=> 	array(
				'desktop' 	=> 	array(
					'min' 	=> 	10,
					'max' 	=> 	20,
					'step' 	=> 	1,
					'unit' 	=> 	'px',
				),
			),
		)
	) );
	$wp_customize->add_setting( 'ananyapro_menu_item_letter_spacing',
		array(
			'default' 			=> 	$defaults['menu_item_letter_spacing'],
			'transport' 		=> 	'postMessage',
			'sanitize_callback' => 	'ananyapro_sanitize_floatval'
		)
	);
	$wp_customize->add_control( new Ananyapro_Range_Custom_Control( $wp_customize, 'ananyapro_menu_item_letter_spacing',
		array(
			'type'			=> 	'ananyapro-range-responsive',
			'description' 	=> 	esc_html__( 'Letter_spacing', 'ananyapro' ),
			'section' 		=> 	'ananyapro_top_menu_typography_section',
			'settings' 		=> 	array(
									'desktop' => 'ananyapro_menu_item_letter_spacing'
								),
			'input_attrs' 	=>	array(
				'desktop' 	=> 	array(
					'min' 	=> 	-2,
					'max' 	=> 	2,
					'step' 	=> 	0.1,
					'unit' 	=> 	'px',
				),
			),
		)
	) );
	//============================================================
    //  = Menu Item Text Transform Section        =
    //  ==========================================================
	$wp_customize->add_setting( 'ananyapro_menu_item_transform', array(
	    'default'        	=> 	$defaults['menu_item_transform'],
	    'sanitize_callback' => 	'ananyapro_sanitize_select',
		'transport'         => 	'postMessage',
	));
	$wp_customize->add_control( 'ananyapro_menu_item_transform', 
		array(
			'type'       	=> 	'select',
			'label' 		=> 	esc_html__( 'Menu Item Text Transform', 'ananyapro' ),
		    'section'    	=> 	'ananyapro_top_menu_typography_section',
		    'settings'   	=> 	'ananyapro_menu_item_transform',
		    'choices'		=> 	array(
				'none'			=>	esc_html__( 'None', 'ananyapro' ),
		    	'lowercase'		=>	esc_html__( 'Lowercase', 'ananyapro' ),
		    	'uppercase'		=>	esc_html__( 'Uppercase', 'ananyapro' ),
		    	'capitalize'	=>	esc_html__( 'Capitalize', 'ananyapro' ),
		    ),
	));

	//  ==========================================================
    //  =  Post Typography Section        =
    //  ==========================================================
	$wp_customize->add_section( 'ananyapro_post_typography_section', array(
	  'title' 				=>	esc_html__( 'Blog Post Typography', 'ananyapro' ),
	  'description'			=>	esc_html__( 'Applies to the posts titles on Index page/Posts page. Not on the single post page.', 'ananyapro' ),
	  'priority' 			=> 	1,
	  'panel' 				=> 	'ananyapro_typography_panel',
	) );
	//  ==========================================================
    //  = Post Title Font Size         =
    //  ==========================================================

	$wp_customize->add_setting( 'ananyapro_post_title_font_size_desktop',
		array(
			'default' 			=> 	$defaults['post_title_font_size_desktop'],
			'transport' 		=> 	'postMessage',
			'sanitize_callback' => 	'ananyapro_sanitize_unsigned_floatval'
		)
	);
	$wp_customize->add_setting( 'ananyapro_post_title_font_size_mobile',
		array(
			'default' 			=> 	$defaults['post_title_font_size_mobile'],
			'transport' 		=> 	'postMessage',
			'sanitize_callback' => 	'ananyapro_sanitize_unsigned_floatval'
		)
	);
	$wp_customize->add_control( new Ananyapro_Range_Custom_Control( $wp_customize, 'ananyapro_post_title_font_size_range',
		array(
			'type'			=>	'ananyapro-range-responsive',
			'label'			=>	esc_html__( 'Post Title', 'ananyapro' ),
			'description' 	=>	esc_html__( 'Font Size', 'ananyapro' ),
			'section' 		=> 	'ananyapro_post_typography_section',
			'settings' 		=> 	array(
									'desktop' => 'ananyapro_post_title_font_size_desktop',
									'mobile'  => 'ananyapro_post_title_font_size_mobile'
								),
			'input_attrs' 	=> 	array(
				'desktop' 	=> 	array(
					'min' 	=> 	1.5,
					'max' 	=> 	4,
					'step' 	=> 	0.01,
					'unit' 	=> 	'em',
				),
				'mobile' 	=> 	array(
					'min' 	=> 	1.5,
					'max' 	=> 	4,
					'step' 	=> 	0.01,
					'unit' 	=> 	'em',
				),
			),
		)
	) );
	$wp_customize->add_setting( 'ananyapro_post_title_line_height',
		array(
			'default' => $defaults['post_title_line_height'],
			'transport' => 'postMessage',
			'sanitize_callback' => 'ananyapro_sanitize_unsigned_floatval'
		)
	);
	$wp_customize->add_control( new Ananyapro_Range_Custom_Control( $wp_customize, 'ananyapro_post_title_line_height',
		array(
			'type'			=>	'ananyapro-range-responsive',
			'description' 	=>	esc_html__( 'Line Height', 'ananyapro' ),
			'section' 		=>	'ananyapro_post_typography_section',
			'settings'		=>	array(
								'desktop' =>	'ananyapro_post_title_line_height'
								),
			'input_attrs' 	=> 	array(
				'desktop'	=> 	array(
					'min' 	=> 	1,
					'max' 	=> 	3,
					'step' 	=> 	0.05,
					'unit' 	=> 	'',
				),
			),
		)
	) );
	$wp_customize->add_setting( 'ananyapro_post_title_letter_spacing',
		array(
			'default' 			=>	$defaults['post_title_letter_spacing'],
			'transport' 		=> 	'postMessage',
			'sanitize_callback' => 	'ananyapro_sanitize_floatval'
		)
	);
	$wp_customize->add_control( new Ananyapro_Range_Custom_Control( $wp_customize, 'ananyapro_post_title_letter_spacing',
		array(
			'type'			=>	'ananyapro-range-responsive',
			'description' 	=> 	esc_html__( 'Letter Spacing', 'ananyapro' ),
			'section' 		=> 	'ananyapro_post_typography_section',
			'settings' 		=> 	array(
									'desktop' => 'ananyapro_post_title_letter_spacing'
								),
			'input_attrs' 	=> 	array(
				'desktop' 	=> 	array(
					'min' 	=> 	-2,
					'max' 	=> 	2,
					'step' 	=> 	0.1,
					'unit' 	=> 	'px',
				),
			),
		)
	) );
	//============================================================
    //  = Blog Post Text Transform Section        =
    //  ==========================================================
	$wp_customize->add_setting( 'ananyapro_blog_post_title_transform', array(
	    'default'        	=> 	$defaults['blog_post_title_transform'],
	    'sanitize_callback' => 	'ananyapro_sanitize_select',
		'transport'         => 	'refresh',
	));
	$wp_customize->add_control( 'ananyapro_blog_post_title_transform', 
		array(
			'type'       	=> 	'select',
			'label' 		=> 	esc_html__( 'Blog Post Title Transform', 'ananyapro' ),
			'description' 	=> 	esc_html__('Inherit option inherits the heading text transform selection of Heading Typography Section.', 'ananyapro' ),
		    'section'    	=> 	'ananyapro_post_typography_section',
		    'settings'   	=> 	'ananyapro_blog_post_title_transform',
		    'choices'		=> 	array(
		    	'inherit'		=>	esc_html__( 'Inherit', 'ananyapro' ),
				'none'			=>	esc_html__( 'None', 'ananyapro' ),
		    	'lowercase'		=>	esc_html__( 'Lowercase', 'ananyapro' ),
		    	'uppercase'		=>	esc_html__( 'Uppercase', 'ananyapro' ),
		    	'capitalize'	=>	esc_html__( 'Capitalize', 'ananyapro' ),
		    ),
	));
	//  ==========================================================
    //  =  Hero Image Typography Section        =
    //  ==========================================================
	$wp_customize->add_section( 'ananyapro_hero_image_typography_section', array(
	  'title' 		=> 	esc_html__( 'Hero Image Typography', 'ananyapro' ),
	  'priority' 	=> 	1,
	  'capability' 	=> 	'edit_theme_options',
	  'panel' 		=> 	'ananyapro_typography_panel',
	) );
	//  ==========================================================
    //  = Hero Image Title and subtitle font size        =
    //  ==========================================================
    $wp_customize->add_setting( 'ananyapro_hero_title_font_size_desktop',
		array(
			'default' 			=> 	$defaults['hero_title_font_size_desktop'],
			'transport' 		=> 	'postMessage',
			'sanitize_callback' =>	'ananyapro_sanitize_unsigned_floatval'
		)
	);
	$wp_customize->add_setting( 'ananyapro_hero_title_font_size_mobile',
		array(
			'default' 			=> 	$defaults['hero_title_font_size_mobile'],
			'transport' 		=> 	'postMessage',
			'sanitize_callback' =>	'ananyapro_sanitize_unsigned_floatval'
		)
	);
	$wp_customize->add_control( new Ananyapro_Range_Custom_Control( $wp_customize, 'ananyapro_hero_title_font_size_range',
		array(
			'type'			=>	'ananyapro-range-responsive',
			'label'			=>	esc_html__( 'Header/Banner Title', 'ananyapro' ),
			'description' 	=> 	esc_html__( 'Font Size', 'ananyapro' ),
			'section' 		=> 	'ananyapro_hero_image_typography_section',
			'settings' 		=> 	array(
								'desktop' => 'ananyapro_hero_title_font_size_desktop',
								'mobile'  => 'ananyapro_hero_title_font_size_mobile'
								),
			'input_attrs' 	=> 	array(
				'desktop' 	=> 	array(
					'min' 	=> 	1.5,
					'max' 	=> 	4,
					'step' 	=> 	0.01,
					'unit' 	=> 	'em',
				),
				'mobile' 	=> 	array(
					'min' 	=> 	1.5,
					'max' 	=> 	4,
					'step' 	=> 	0.01,
					'unit' 	=> 	'em',
				),
			),
		)
	) );
	//hero image subtitle
	$wp_customize->add_setting( 'ananyapro_hero_subtitle_font_size_desktop',
		array(
			'default' 			=> 	$defaults['hero_subtitle_font_size_desktop'],
			'transport' 		=> 	'postMessage',
			'sanitize_callback' => 	'ananyapro_sanitize_unsigned_floatval'
		)
	);
	$wp_customize->add_setting( 'ananyapro_hero_subtitle_font_size_mobile',
		array(
			'default' 			=> 	$defaults['hero_subtitle_font_size_mobile'],
			'transport' 		=> 	'postMessage',
			'sanitize_callback' => 	'ananyapro_sanitize_unsigned_floatval'
		)
	);
	$wp_customize->add_control( new Ananyapro_Range_Custom_Control( $wp_customize, 'ananyapro_hero_subtitle_font_size_range',
		array(
			'type'			=> 	'ananyapro-range-responsive',
			'label'			=>	esc_html__( 'Header/Banner Subtitle', 'ananyapro' ),
			'description' 	=> 	esc_html__( 'Font Size', 'ananyapro' ),
			'section' 		=> 	'ananyapro_hero_image_typography_section',
			'settings' 		=> 	array(
								'desktop' => 'ananyapro_hero_subtitle_font_size_desktop',
								'mobile'  => 'ananyapro_hero_subtitle_font_size_mobile'
								),
			'input_attrs' 	=> 	array(
				'desktop' 	=> 	array(
					'min' 	=> 	12,
					'max' 	=> 	25,
					'step' 	=> 	1,
					'unit' 	=> 	'px',
				),
				'mobile' 	=> 	array(
					'min' 	=> 	12,
					'max' 	=> 	25,
					'step' 	=> 	1,
					'unit' 	=> 	'px',
				),
			),
		)
	) );
}
add_action( 'customize_register', 'ananyapro_custom_typography_options_setup' );