<?php
/**
 * Sets all of our theme defaults.
 *
 * @package AnanyaPRO
 * @since 1.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

if ( ! function_exists( 'ananyapro_get_defaults' ) ) {
	/**
	 * Set default options
	 *
	 * @since 1.0
	 */
	function ananyapro_get_defaults() {
		$customizer_defaults= 	array(
		'site_header_text_color'			=> 'ffffff',
		'header_text_alignment' 			=> 'left',
		'header_vertical_text_alignment'	=> 'h-bottom',
		'full_screen_header'				=>	true,
		'header_image_only_on_front_page'	=>	false,
		'header_height_on_other_pages'		=>	110,
		'header_overlay'					=>	'color-overlay',
		'overlay_opacity'					=>	0.5,
		'overlay_color'						=>	'#000000',
		'blog_page_title'					=>	esc_html__( 'Blog', 'ananyapro'),
		'footer_credit_text'				=>	'Copyright {copy} {year} All Rights Reserved',
		'blog_page_description'				=>	'',
		'blog_posts_layout'					=>	'classic',
		'post_display_type'					=>	'post-excerpt',
		'read_more_btn_text'				=>	'Read More',
		'read_more_btn_style'				=>	'more-btn-fill-straight',
		'hero_read_more_btn_style'			=> 'hero-btn-underline',
		'single_page_title_position'		=> 'default',
		'single_post_title_position'		=> 'default',
		'hide_blog_page_post_footer'		=>	false,
		//color defaults
		'body_bg_color'						=>	'#f8f8f8',
		'accent_color'						=>	'#ec407a',
		'heading_text_color'				=>	'#212121',
		'body_text_color'					=>	'#212121',
		'post_meta_color'					=>	'#424242',
		'post_bg_color'						=>	'#ffffff',
		'menu_item_color'					=>	'#212121',
		'menu_bg_color'						=>	'#ffffff',
		'footer_bg_color'					=>	'#ffffff',
		'footer_link_color'					=>	'#212121',
		'footer_text_color'					=>	'#757575',
		'section_bg_color'					=>	'#ffffff',
		'frontpage_button_text_color'		=> 	'#ffffff',
		'feat_content_sec_bg'				=> 	'#ffffff',
		'feat_pages_sec_bg'					=>	'#f8f8f8',
		'feat_category_sec_bg'				=>	'#f8f8f8',
		'cta_sec_bg'						=>	'#000000',
		'cta_sec_bg_image'					=>	get_parent_theme_file_uri( '/assets/images/header.jpg' ),
		'cta-bg-type'						=>	'image-color',
		'gradient_start_color'				=> 	'#6442ff',
		'gradient_end_color'				=> 	'#0cb4ce',
		'gradient_style'					=> 	'linear',

		//page layout defaults
		'static_front_page_layout'			=>	'right-sidebar',
		'blog_page_layout'					=>	'right-sidebar',
		'single_page_layout'				=>	'right-sidebar',
		'single_post_layout'				=>	'right-sidebar',
		'searchbox_display'					=>	true,
		'hide_single_post_share_option'		=>	false,
		'social_media_menu_enable'			=>	false,
		'social_media_icon'					=>	'facebook-f',
		'social_media_url'					=>	'',
		//Typography defaults
		'heading_font_family'				=>	'Abril Fatface',
		'heading_font_weight'				=>	'regular',
		'heading_font_transformstyle'		=>	'none',
		'heading_font_category'				=>	'sans-serif',
		'body_font_family'					=>	'Open Sans',
		'body_font_weight'					=>	'regular',
		'body_font_transformstyle'			=>	'none',
		'body_font_category'				=>	'sans-serif',
		'body_text_alignment'				=>	'left', //css need to written
		'blog_post_title_alignment'			=>	'left',  //css need to written
		'body_text_transform'				=>	'none',
		'blog_post_title_transform'			=>	'inherit',
		'body_font_size_desktop'			=>	18,
		'body_font_size_mobile'				=>	18,
		'body_line_height'					=>	1.75,
		'hero_title_font_size_desktop'		=> 	3.5,
		'hero_title_font_size_mobile'		=> 	2.2,
		'hero_subtitle_font_size_desktop'	=> 	22,
		'hero_subtitle_font_size_mobile'	=> 	16,
		'post_title_font_size_desktop'		=>	2.441,
		'post_title_font_size_mobile'		=>	1.953,
		'post_title_line_height'			=>	1.2,
		'post_title_letter_spacing'			=>	-1,
		'menu_font_size'					=>	15,
		'menu_item_letter_spacing'			=>	1,
		'menu_item_transform'				=>	'none',
		'menu_item_font_family'				=>	'body-font',
		//headings
		'heading_line_height'				=>	1.2,
		'heading_letter_spacing'			=>	0,
		'heading1_font_size_desktop'		=>	3.052,
		'heading2_font_size_desktop'		=>	2.441,
		'heading3_font_size_desktop'		=>	1.953,
		'heading4_font_size_desktop'		=>	1.563,
		'heading5_font_size_desktop'		=>	1.25,
		'heading6_font_size_desktop'		=>	1,
		'heading1_font_size_mobile'			=>	3.052,
		'heading2_font_size_mobile'			=>	2.441,
		'heading3_font_size_mobile'			=>	1.953,
		'heading4_font_size_mobile'			=>	1.563,
		'heading5_font_size_mobile'			=>	1.25,
		'heading6_font_size_mobile'			=>	1,
		//frontpage sections
		'enable_frontpage_sections'		=>	false,
		'total_no_of_each_type_section'	=>	2,
		'disable_feat_sec'				=>	false,
		'feat_title_sec'				=>	'',
		'feat_tagline_sec'				=>	'',
		'feat_image_sec'				=>	'',
		'feat_image_position'			=>	'left',
		'feat_content_sec'				=>	'',
		'feat_text_sec'					=>	'',
		'feat_url_sec'					=>	'',
		'feat_content_sec_priority'		=>	array(),
		'feat_category_sec_priority'	=>	array(),
		'feat_page_sec_priority'		=>	array(),
		'CTA_sec_priority'				=>	array(),
		'widget_sec_priority'			=>	array(),
		
		//category sec 1
		'disable_cat_sec'				=>	false,
		'default_cat'					=>	'select-category',
		'cat_sec_btn_text'				=>	esc_html__( 'View More', 'ananyapro' ),

		'section_container_layout'		=>	'full-width',
		'feat_cat_sort_order'			=>	'date',
		'feat_cat_layout'				=>	'column-3',
		'feat_cat_post_style'			=>	'style1',
		'feat_cat_no_of_posts_per_sec'	=>	6,
		'frontpage_button_style'		=>	'fp-btn-fill-straight',
		'section-color-scheme'			=>	'dark',
		
		'cta-color-scheme'				=>	'light',
		'pages_layout_sec'				=>	'column-1',
		'page_icon'						=>	'fas fa-bell',
		'latest_post_total_no_posts'	=>	3,
		'latest_post_view_btn_text'		=>	esc_html__( 'See Blog','ananyapro'),
		'hide_feat_page_excerpt'		=>	false,
		'frontpage_sec_name_text_color'	=>	'#919191',
		'frontpage_sec_tagline_text_color'			=>	'#919191',
		);
		return $customizer_defaults;
	}
}