<?php
/**
 * The template for displaying search results pages
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/#search-result
 *
 * @package AnanyaPRO
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

get_header();
$defaults = ananyapro_get_defaults();
$posts_layout = get_theme_mod( 'ananyapro_blog_posts_layout', $defaults['blog_posts_layout'] );
?>
<?php if ( have_posts() ) : ?>
	<header class="search-page-header">
		<div class="container">
		<h1 class="page-title">
			<?php
			/* translators: %s: search query. */
			printf( esc_html__( 'Search Results for: %s', 'ananyapro' ), '<span>' . get_search_query() . '</span>' );
			?>
		</h1>
		</div><!-- container -->
	</header><!-- .search-page-header -->
<?php endif; ?>
<div class="container">
	<div class="row">
		<div id="primary" class="content-area  <?php echo esc_attr('blog-layout-'.$posts_layout); ?>">
			<main id="main" class="site-main">

		<?php if ( have_posts() ) : ?>

			<?php
			/* Start the Loop */
			while ( have_posts() ) :
				the_post();

				/**
				 * Run the loop for the search to output the results.
				 * If you want to overload this in a child theme then include a file
				 * called content-search.php and that will be used instead.
				 */
				get_template_part( 'template-parts/content', 'search' );

			endwhile;

		else :

			get_template_part( 'template-parts/content', 'none' );

		endif;
		?>

			</main><!-- #main -->
			<?php 
			if ( have_posts() ) :
				the_posts_pagination( array( 
					'mid_size' => 1, 
					'prev_text' => esc_html__( 'Prev', 'ananyapro' ),
    				'next_text' => esc_html__( 'Next', 'ananyapro' ), 
    			) );
			endif; ?>
		</div><!-- #primary -->
		<?php get_sidebar(); ?>
	</div><!--row-->
</div><!-- container-->

<?php
get_footer();
