<?php
/**
 * Template part for displaying posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package AnanyaPRO
 * @since 1.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}
$defaults = ananyapro_get_defaults();
$hide_footer = get_theme_mod( 'ananyapro_hide_blog_page_post_footer_option', $defaults['hide_blog_page_post_footer'] );
$single_post_title_position = get_theme_mod( 'ananyapro_single_post_title_position', $defaults['single_page_title_position'] );
$header_image_only_on_front_page = get_theme_mod( 'ananyapro_use_header_image_only_on_front_page_setting', $defaults['header_image_only_on_front_page'] );
$posts_layout = get_theme_mod( 'ananyapro_blog_posts_layout', $defaults['blog_posts_layout'] );
$post_head_style = get_theme_mod( 'ananyapro_single_post_title_position', $defaults['single_post_title_position'] );
$hide_blog_page_featured_image = get_theme_mod( 'ananyapro_hide_blog_post_featured_image', false );
$post_class = '';
if( ! has_post_thumbnail() || ( !is_single() && $hide_blog_page_featured_image && ( 'list-1' === $posts_layout || 'list-2' === $posts_layout ) ) ) {
	$post_class = 'no-featured-image';
}
?>

<article id="post-<?php the_ID(); ?>" <?php post_class( $post_class ); ?>>
		
	<?php if( (is_single() && ( 'default' === $single_post_title_position || !has_header_image() || $header_image_only_on_front_page ) ) || ( class_exists( 'WooCommerce' ) && is_product() ) ) { 
		get_template_part( 'template-parts/posts/entry', 'header' ); 
	}?>
		
	<?php ananyapro_post_thumbnail(); ?>
		
	<div class="post-content-wrapper">

		<?php if( !is_single()) { ?>
		<?php get_template_part( 'template-parts/posts/entry', 'header' ); ?>
		<?php } ?>

		<?php
		//Entry summary/content depending on choice
		$post_display_option = get_theme_mod( 'ananyapro_post_display_type_option', $defaults['post_display_type'] );
		if ( is_search()  || is_archive() || ('post-excerpt' === $post_display_option and ! is_single() ) ) {
			get_template_part( 'template-parts/posts/entry','excerpt' );
		} else {
			get_template_part( 'template-parts/posts/entry', 'content' );
		}
		if( !is_single() && !$hide_footer && 'list-2' !== $posts_layout ) {
			ananyapro_excerpt_entry_footer(); 
		}
		?>
		
		<?php if( is_single() ) { ?>
			<?php ananyapro_single_post_footer(); ?>
		<?php } ?>
	</div><!-- post-content -->
		
</article><!-- #post -->
