<?php
	/**
	 * Template-part for displaying Hero image section.
	 *
	 * @package AnanyaPRO
	 * @since 1.0
	 */

	if ( ! defined( 'ABSPATH' ) ) {
		exit; // Exit if accessed directly.
	}
	$defaults = ananyapro_get_defaults();
	$header_image_only_on_front_page = get_theme_mod( 'ananyapro_use_header_image_only_on_front_page_setting', $defaults['header_image_only_on_front_page'] );
	$page_head_style = get_theme_mod( 'ananyapro_single_page_title_position', $defaults['single_page_title_position'] );
	$post_head_style = get_theme_mod( 'ananyapro_single_post_title_position', $defaults['single_post_title_position'] );

	$page_header_uses_featured_image = get_theme_mod( 'ananyapro_single_page_featured_image_in_header', false );
	$post_header_uses_featured_image = get_theme_mod( 'ananyapro_single_post_featured_image_in_header', false );
	
	$single_post_title_position = get_theme_mod( 'ananyapro_single_post_title_position', $defaults['single_page_title_position'] );
	$single_page_title_position = get_theme_mod( 'ananyapro_single_page_title_position', $defaults['single_page_title_position'] );

	$blog_page_title= get_theme_mod( 'ananyapro_blog_page_title', $defaults['blog_page_title'] );
	$blog_page_description = get_theme_mod( 'ananyapro_blog_page_description', $defaults['blog_page_description'] );
	

	if( has_custom_header() && !$header_image_only_on_front_page ){ ?>

	<div class="custom-header-other-page">

		<div class="custom-header-media">

			<?php if( !is_product() && has_post_thumbnail() && true === $page_header_uses_featured_image ) { ?>

				<div class="wp-custom-header">
					<?php the_post_thumbnail(); ?>
				</div><!-- wp-custom-header -->

			<?php } else {
				the_custom_header_markup(); 
			}

			if ( !is_product() && $page_head_style === 'over-hero-image' ) { ?>
			<div class="over-hero-page-title">
				<div class="container">
					<h2 class="woocommerce-products-header__title page-title"><?php esc_html( woocommerce_page_title() ); ?></h2>
				</div><!-- container -->

			</div><!-- over-hero-page-title -->

			<?php } //end of if ?>

		</div><!-- custom-header-media -->
		
	</div><!-- custom-header-other-page -->
	
	<?php } elseif( (!has_header_image() && !has_header_video() ) || $header_image_only_on_front_page ) {
		
		if ( is_home() && ! is_front_page() && $page_head_style === 'over-hero-image') : ?>
			<div class="blog-page-header">
				<header>
					<?php ananyapro_blog_page_header( $blog_page_title, $blog_page_description ); ?>
				</header>
			</div><!-- blog-page-header -->
			<?php 
		elseif( is_archive() && $page_head_style === 'over-hero-image' ): ?>
			<div class="archive-page-header">
				<header class="container">
					<h2 class="woocommerce-products-header__title page-title"><?php esc_html( woocommerce_page_title() ); ?></h2>
				</header><!-- .page-header -->
			</div><!-- archive-page-header-wrapper -->
			<?php
		endif; 
	}