<?php
/**
 * Displays header top navigation
 *
 * @package AnanyaPRO
 * @since 1.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}
$defaults = ananyapro_get_defaults();
?>

<nav class="main-navigation navbar navbar-light navbar-expand-lg" id="site-navigation">
    <div class="container">
    	<div class="site-branding">
    		<?php ananyapro_the_custom_logo();?>
    		
			<h1 class="site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></h1>
			<?php
			$ananyapro_description = get_bloginfo( 'description', 'display' );
			if ( $ananyapro_description || is_customize_preview() ) :
				?>
				<p class="site-description"><?php echo esc_html( $ananyapro_description ); ?></p>
			<?php endif; ?>
			
		</div><!-- site-branding -->

		
    	<button data-toggle="collapse" data-target=".collapse-grp" class="navbar-toggler" aria-controls="primary-menu navbarResponsive socialMenuResponsive" aria-expanded="false" aria-label="<?php esc_attr_e('Toggle navigation','ananyapro'); ?>"><i class="fas fa-bars"></i></button>

        <?php 
			wp_nav_menu( array(
				'theme_location' 	=> 	'primary-menu',
				'menu_id'        	=> 	'primary-menu',
				'container'         => 	'div',
				'container_id'		=> 	'navbarResponsive',
				'container_class'   => 	'collapse-grp collapse navbar-collapse',
				'menu_id'			=> 	'nav-menu-primary',
				'menu_class'		=> 	'menu nav-menu-primary ml-auto',
				'fallback_cb' 		=> 	'ananyapro_default_menu',
			) ); 
		?>
    	
    	<?php if( true === get_theme_mod( 'ananyapro_social_media_menu_enable', $defaults['social_media_menu_enable'] ) || true === get_theme_mod( 'ananyapro_searchbox_display_setting', $defaults['searchbox_display'] )): ?>
    		<?php echo ananyapro_return_social_media_menu( 'collapse-grp header-social-menu collapse' );// phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?>
    	<?php endif; ?>

    </div><!-- container -->

</nav><!-- navbar-light -->
