<?php
/**
 * Easy Digital Downloads Theme Updater
 *
 * @package EDD Sample Theme
 */

// Includes the files needed for the theme updater
if ( !class_exists( 'EDD_Theme_Updater_Admin' ) ) {
	include( dirname( __FILE__ ) . '/theme-updater-admin.php' );
}

// Loads the updater classes
$updater = new EDD_Theme_Updater_Admin(

	// Config settings
	$config = array(
		'remote_api_url' => 'https://falgunithemes.com', // Site where EDD is hosted
		'item_name'      => 'Ananya PRO', // Name of theme
		'theme_slug'     => 'ananyapro', // Theme slug
		'version'        => ANANYAPRO_VERSION, // The current version of this theme
		'author'         => ANANYAPRO_AUTHOR, // The author of this theme
		'download_id'    => '', // Optional, used for generating a license renewal link
		'renew_url'      => '', // Optional, allows for a custom license renewal link
		'beta'           => false, // Optional, set to true to opt into beta versions
		'item_id'        => '',
	),

	// Strings
	$strings = array(
		'theme-license'             => __( 'Theme License', 'ananyapro' ),
		'enter-key'                 => __( 'Enter your theme license key.', 'ananyapro' ),
		'license-key'               => __( 'License Key', 'ananyapro' ),
		'license-action'            => __( 'License Action', 'ananyapro' ),
		'deactivate-license'        => __( 'Deactivate License', 'ananyapro' ),
		'activate-license'          => __( 'Activate License', 'ananyapro' ),
		'status-unknown'            => __( 'License status is unknown.', 'ananyapro' ),
		'renew'                     => __( 'Renew?', 'ananyapro' ),
		'unlimited'                 => __( 'unlimited', 'ananyapro' ),
		'license-key-is-active'     => __( 'License key is active.', 'ananyapro' ),
		'expires%s'                 => __( 'Expires %s.', 'ananyapro' ),
		'expires-never'             => __( 'Lifetime License.', 'ananyapro' ),
		'%1$s/%2$-sites'            => __( 'You have %1$s / %2$s sites activated.', 'ananyapro' ),
		'license-key-expired-%s'    => __( 'License key expired %s.', 'ananyapro' ),
		'license-key-expired'       => __( 'License key has expired.', 'ananyapro' ),
		'license-keys-do-not-match' => __( 'License keys do not match.', 'ananyapro' ),
		'license-is-inactive'       => __( 'License is inactive.', 'ananyapro' ),
		'license-key-is-disabled'   => __( 'License key is disabled.', 'ananyapro' ),
		'site-is-inactive'          => __( 'Site is inactive.', 'ananyapro' ),
		'license-status-unknown'    => __( 'License status is unknown.', 'ananyapro' ),
		'update-notice'             => __( "Updating this theme will lose any customizations you have made. 'Cancel' to stop, 'OK' to update.", 'ananyapro' ),
		'update-available'          => __('<strong>%1$s %2$s</strong> is available. <a href="%3$s" class="thickbox" title="%4s">Check out what\'s new</a> or <a href="%5$s"%6$s>update now</a>.', 'ananyapro' ),
	)

);
