<?php
/**
 * The template for displaying 404 pages (not found)
 *
 * @link https://codex.wordpress.org/Creating_an_Error_404_Page
 *
 * @package AnanyaPRO
 * @since 1.0
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

get_header();
$defaults = ananyapro_get_defaults();
$posts_layout = get_theme_mod( 'ananyapro_blog_posts_layout', $defaults['blog_posts_layout'] );
?>
<div class="container">
	<div class="row">
		<div id="primary" class="content-area">
			<main id="main" class="site-main">

			<div id="primary" class="content-area">
				<main id="main" class="site-main">

					<section class="error-404 not-found">
						<header class="page-header">
							<h1 class="page-title"><?php esc_html_e( 'Oops! That page can&rsquo;t be found.', 'ananyapro' ); ?></h1>
						</header><!-- page-header -->

						<div class="page-content">
							<p><?php esc_html_e( 'It looks like nothing was found at this location. Maybe try one of the links below or a search?', 'ananyapro' ); ?></p>

							<?php
							get_search_form();

							the_widget( 'WP_Widget_Recent_Posts' );
							?>

							<div class="widget widget_categories">
								<h2 class="widget-title"><?php esc_html_e( 'Most Used Categories', 'ananyapro' ); ?></h2>
								<ul>
									<?php
									wp_list_categories( array(
										'orderby'    => 'count',
										'order'      => 'DESC',
										'show_count' => 1,
										'title_li'   => '',
										'number'     => 10,
									) );
									?>
								</ul>
							</div><!-- widget -->

							<?php
							/* translators: %1$s: smiley */
							$ananyapro_archive_content = '<p>' . sprintf( esc_html__( 'Try looking in the monthly archives. %1$s', 'ananyapro' ), convert_smilies( ':)' ) ) . '</p>';
							the_widget( 'WP_Widget_Archives', 'dropdown=1', "after_title=</h2>$ananyapro_archive_content" );

							the_widget( 'WP_Widget_Tag_Cloud' );
							?>

						</div><!-- page-content -->
					</section><!-- error-404 -->

				</main><!-- main -->
			</div><!-- primary -->
	<?php //get_sidebar(); ?>
	</div><!--.row-->
</div><!-- .container-->
<?php
get_footer();
