(function($) {
  "use strict"; // Start of use strict
  
  /**
   * Calculate and set custom header media height.
   */
  function calculateHeaderHeight() {
    var mainNavHeight = 0, overHeroImageTitle = 0, totalHeight = 0;
    if( $( '.main-navigation' ).length ) {
      mainNavHeight = $( '.main-navigation' ).outerHeight( true );
    }
    if( $( '.over-hero-page-title' ).length ) {
      overHeroImageTitle = $( '.over-hero-page-title' ).outerHeight( true );
    }
    totalHeight = parseInt( mainNavHeight ) + parseInt( overHeroImageTitle );
    $( '.custom-header-other-page .custom-header-media' ).css( 'height', totalHeight );
  }

  $( document ).ready(
    function () {
       calculateHeaderHeight();
    }
  );

  $( window ).resize(function(){
    calculateHeaderHeight();
    }
  );

  /**
   * Control the serchbox events.
   */
  $('#desktop-search-icon').on('click tap',function(event) {
     $('.ananyapro-popup-search-form').addClass('open-search-form');
     var x = setTimeout('jQuery(".ananyapro-popup-search-form .search-form .search-field").focus()', 700);
  });
  
  $('.ananyapro-close-popup').on('click tap', function (event) {
      $('.ananyapro-popup-search-form').removeClass('open-search-form');
      $('#desktop-search-icon').focus();
  });

  /**
   * Change the arrow direction of read more button if RTL is enabled.
   */
  if ( $('body').hasClass('rtl') ) {
    $('.more-link i').removeClass('fa-long-arrow-right');
    $('.more-link i').addClass('fa-long-arrow-left');
  }
  
  /**
   * Loop the focus of elements when tab and tab+shift keys are used in keyboard navigation
   */
  $( ".ananyapro-popup-search-form" ).keydown( function( event ) {

    var tabKey = event.keyCode === 9;
    var shiftKey = event.shiftKey;
    if( shiftKey || tabKey) {
      var selectors = 'a, input, button';
      var parent = $( document ).find('.ananyapro-popup-search-form');
      var elements = parent.find(selectors);
      
      var firstEl = elements[0];
      
      var lastEl = elements[elements.length -1 ];
      
      var activeEl = event.target;

      if ( ! shiftKey && tabKey && lastEl === activeEl ) {
        event.preventDefault();
        firstEl.focus();
      }

      if ( shiftKey && tabKey && firstEl === activeEl ) {
        event.preventDefault();
        lastEl.focus();
      }
    }
  });

  /**
   * loop the focus of elements when tab and tab+shift keys are used in keyboard navigation
   */
  $( '#site-navigation' ).keydown( function( event ) {
    var tabKey,shiftKey,selectors,parent,elements,firstEl,lastEl,activeEl;
    tabKey = event.keyCode === 9;
    shiftKey = event.shiftKey;
    if( shiftKey || tabKey) {
      selectors = 'button, li, a, input[type="search"]';
      parent = $( document ).find('.main-navigation');
      elements = parent.find(selectors);
      elements = elements.filter('button, li, a, input[type="search"]');
      firstEl = elements[1];
      lastEl = elements[elements.length -1 ];
      activeEl = event.target;
      if ( ! shiftKey && tabKey && lastEl === activeEl ) {
        event.preventDefault();
        firstEl.focus();
      }

      if ( shiftKey && tabKey && firstEl === activeEl ) {
        event.preventDefault();
        lastEl.focus();
      }
    }
  });

  /* Scroll Top Button */

  $('.scrolltop').on( 'click', function() {
    $('html, body').animate( { scrollTop : 0 }, 800 );
    return false;
  });

  $( window ).on( 'scroll', function() {
    if ($(this).scrollTop() >= 800 ) {
      $('.scrolltop').fadeIn(350);
    } else {
      $('.scrolltop').fadeOut(350);
    }
  });
})(jQuery); // End of use strict
