/**
 * Scripts within the customizer controls window.
 */
 (function() {

	wp.customize.bind( 'ready', function() {

		// Detect when the section for each panel is expanded (or closed) so we can adjust preview accordingly
		wp.customize.section( 'ananyapro_featured_content_section_1' ).expanded.bind( function( isExpanding ) {
			// isExpanding will = true if you're entering the section, false if you're leaving it
			wp.customize.previewer.send( 'section-highlight', { section_id: 'feat-content-sec-1', expanded: isExpanding } );
		} );
		
		// Detect when the section for each panel is expanded (or closed) so we can adjust preview accordingly
		wp.customize.section( 'ananyapro_featured_content_section_2' ).expanded.bind( function( isExpanding ) {
			// isExpanding will = true if you're entering the section, false if you're leaving it
			wp.customize.previewer.send( 'section-highlight', { section_id: 'feat-content-sec-2', expanded: isExpanding } );
		} );

		// Detect when the section for each panel is expanded (or closed) so we can adjust preview accordingly
		wp.customize.section( 'ananyapro_featured_category_section_1' ).expanded.bind( function( isExpanding ) {
			// isExpanding will = true if you're entering the section, false if you're leaving it
			wp.customize.previewer.send( 'section-highlight', { section_id: 'feat-cat-sec-1', expanded: isExpanding } );
		} );

		// Detect when the section for each panel is expanded (or closed) so we can adjust preview accordingly
		wp.customize.section( 'ananyapro_featured_category_section_2' ).expanded.bind( function( isExpanding ) {
			// isExpanding will = true if you're entering the section, false if you're leaving it
			wp.customize.previewer.send( 'section-highlight', { section_id: 'feat-cat-sec-2', expanded: isExpanding } );
		} );
		
		// Detect when the section for each panel is expanded (or closed) so we can adjust preview accordingly
		wp.customize.section( 'ananyapro_featured_pages_section_1' ).expanded.bind( function( isExpanding ) {
			// isExpanding will = true if you're entering the section, false if you're leaving it
			wp.customize.previewer.send( 'section-highlight', { section_id: 'feat-pages-sec-1', expanded: isExpanding } );
		} );

		// Detect when the section for each panel is expanded (or closed) so we can adjust preview accordingly
		wp.customize.section( 'ananyapro_featured_pages_section_2' ).expanded.bind( function( isExpanding ) {
			// isExpanding will = true if you're entering the section, false if you're leaving it
			wp.customize.previewer.send( 'section-highlight', { section_id: 'feat-pages-sec-2', expanded: isExpanding } );
		} );

		// Detect when the section for each panel is expanded (or closed) so we can adjust preview accordingly
		wp.customize.section( 'ananyapro_CTA_section_1' ).expanded.bind( function( isExpanding ) {
			// isExpanding will = true if you're entering the section, false if you're leaving it
			wp.customize.previewer.send( 'section-highlight', { section_id: 'cta-sec-1', expanded: isExpanding } );
		} );

		// Detect when the section for each panel is expanded (or closed) so we can adjust preview accordingly
		wp.customize.section( 'ananyapro_CTA_section_2' ).expanded.bind( function( isExpanding ) {
			// isExpanding will = true if you're entering the section, false if you're leaving it
			wp.customize.previewer.send( 'section-highlight', { section_id: 'cta-sec-2', expanded: isExpanding } );
		} );
		
		// Only show frontpage background color control when the frontpage button style is underline
		wp.customize( 'ananyapro_frontpage_button_style', function( setting ) {
			wp.customize.control( 'ananyapro_frontpage_button_bg_color', function( control ) {
				var visibility = function() {
					if ( 'fp-btn-underline' !== setting.get() ) {
						control.container.slideDown( 180 );
					} else {
						control.container.slideUp( 180 );
					}
				};
				visibility();
				setting.bind( visibility );
			});
		});

		// Only show gradient color controls when the overlay style is gradient overlay
		wp.customize( 'ananyapro_header_overlay_type', function( setting ) {
			wp.customize.control( 'ananyapro_overlay_color', function( control ) {
				var visibility = function() {
					if ( 'color-overlay' === setting.get() ) {
						control.container.slideDown( 180 );
					} else {
						control.container.slideUp( 180 );
					}
				};
				visibility();
				setting.bind( visibility );
			});
			wp.customize.control( 'ananyapro_gradient_start_color', function( control ) {
				var visibility = function() {
					if ( 'gradient-overlay' === setting.get() ) {
						control.container.slideDown( 180 );
					} else {
						control.container.slideUp( 180 );
					}
				};
				visibility();
				setting.bind( visibility );
			});
			wp.customize.control( 'ananyapro_gradient_end_color', function( control ) {
				var visibility = function() {
					if ( 'gradient-overlay' === setting.get() ) {
						control.container.slideDown( 180 );
					} else {
						control.container.slideUp( 180 );
					}
				};
				visibility();
				setting.bind( visibility );
			});
			wp.customize.control( 'ananyapro_color_overlay_opacity', function( control ) {
				var visibility = function() {
					if ( 'color-overlay' === setting.get() ) {
						control.container.slideDown( 180 );
					} else {
						control.container.slideUp( 180 );
					}
				};
				visibility();
				setting.bind( visibility );
			});
			wp.customize.control( 'ananyapro_gradient_overlay_opacity', function( control ) {
				var visibility = function() {
					if ( 'gradient-overlay' === setting.get() ) {
						control.container.slideDown( 180 );
					} else {
						control.container.slideUp( 180 );
					}
				};
				visibility();
				setting.bind( visibility );
			});

		});

		for( sec_no=1; sec_no <=2; sec_no++ ) {
			//CTA section Background 
			wp.customize( 'ananyapro_cta_bg_type_sec'+sec_no, function( setting ) {
				wp.customize.control( 'ananyapro_cta_bg_color_sec'+sec_no, function( control ) {
					var visibility = function() {
						if ( 'color' === setting.get() || 'image-color' === setting.get() ) {
							control.container.slideDown( 180 );
						} else {
							control.container.slideUp( 180 );
						}
					};
					visibility();
					setting.bind( visibility );
				});
				
				wp.customize.control( 'ananyapro_cta_gradient_start_color_sec'+sec_no, function( control ) {
					var visibility = function() {
						if ( 'gradient' === setting.get() || 'image-gradient' === setting.get() ) {
							control.container.slideDown( 180 );
						} else {
							control.container.slideUp( 180 );
						}
					};
					visibility();
					setting.bind( visibility );
				});
				
				wp.customize.control( 'ananyapro_cta_gradient_end_color_sec'+sec_no, function( control ) {
					var visibility = function() {
						if ( 'gradient' === setting.get() || 'image-gradient' === setting.get() ) {
							control.container.slideDown( 180 );
						} else {
							control.container.slideUp( 180 );
						}
					};
					visibility();
					setting.bind( visibility );
				});
				
				wp.customize.control( 'ananyapro_cta_bg_image_sec'+sec_no, function( control ) {
					var visibility = function() {
						if ( 'image' === setting.get()  || 'image-color' === setting.get()  || 'image-gradient' === setting.get() ) {
							control.container.slideDown( 180 );
						} else {
							control.container.slideUp( 180 );
						}
					};
					visibility();
					setting.bind( visibility );
				});

				wp.customize.control( 'ananyapro_cta_color_overlay_opacity_sec'+sec_no, function( control ) {
					var visibility = function() {
						if ( 'image-color' === setting.get() ) {
							control.container.slideDown( 180 );
						} else {
							control.container.slideUp( 180 );
						}
					};
					visibility();
					setting.bind( visibility );
				});

				wp.customize.control( 'ananyapro_cta_gradient_overlay_opacity_sec'+sec_no, function( control ) {
					var visibility = function() {
						if ( 'image-gradient' === setting.get() ) {
							control.container.slideDown( 180 );
						} else {
							control.container.slideUp( 180 );
						}
					};
					visibility();
					setting.bind( visibility );
				});
				
			});
		}
		wp.customize( 'ananyapro_frontpage_button_style', function( setting ) {
			wp.customize.control( 'ananyapro_frontpage_button_bg_color', function( control ) {
				var visibility = function() {
					if ( 'fp-btn-border-straight' === setting.get() || 'fp-btn-border-slight-round' === setting.get() || 'fp-btn-border-round' === setting.get() || 'fp-btn-underline' ===  setting.get() ) {
						control.container.hide();
					} else {
						control.container.show();
					}
				};
				visibility();
				setting.bind( visibility );
			});
		});

	});
})();