<?php
/**
 * The front page template file
 *
 * If the user has selected a static page for their homepage, this is what will
 * appear.
 * Learn more: https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package AnanyaPRO
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

$defaults = ananyapro_get_defaults();
$enable_frontpage_sections = get_theme_mod( 'ananyapro_enable_frontpage_sections', $defaults['enable_frontpage_sections'] );

if ( get_option( 'show_on_front' ) == 'page' ) {
	if( !$enable_frontpage_sections ) {
		include( get_page_template() );
	} else {
		global $ananyapro_sec_no;
		$ananyapro_frontpage_sections = ananyapro_home_section();
		
		//Dispaly site header
		get_header();

		//Display top widget area
		ananyapro_display_widgets( 'ananyapro-frontpage-widget-area-top', 'top' );

		//Display frontpage sections
		foreach ($ananyapro_frontpage_sections as $key => $section) {
			$section = str_replace(array('ananyapro_','_section'), '', $section);
			$section = str_replace('featured_', 'featured-', $section);
			$section = str_replace('latest_', 'latest-', $section);
			$section = str_replace('showcase_categories', 'showcase-categories', $section);
			$ananyapro_sec_no = preg_replace('/[^0-9]/', '', $section);
			$section = preg_replace('/[0-9]/', '', $section);
			$section = str_replace('_', '', $section);
			get_template_part( 'template-parts/sections/section', $section );
		}
		
		//Display top widget area
		ananyapro_display_widgets( 'ananyapro-frontpage-widget-area-bottom', 'bottom' );

		//Dispaly site footer
	    get_footer();
	}
} else {
	get_header();
	$posts_layout = get_theme_mod( 'ananyapro_blog_posts_layout', $defaults['blog_posts_layout'] );
	?>
	
	<?php if ( have_posts() ) :
		if ( is_home() && ! is_front_page() ) :
			?>
		<div class="blog-page-header">
			<header>
				<h2 class="blog-page-title"><?php echo wp_kses_post( $blog_page_title ); ?></h2>
				<p class="blog-page-description"><?php echo wp_kses_post( $blog_page_title ); ?></p>
			</header>
		</div><!-- blog-page-header -->
		<?php endif; 
	endif; ?>
	
	<div class="container">
		<div class="row">
			<div id="primary" class="content-area <?php echo esc_attr('blog-layout-'.$posts_layout); ?>">
				<main id="main" class="site-main">
			<?php
			if ( have_posts() ) : 
				/* Start the Loop */
				while ( have_posts() ) :
					the_post();
					get_template_part( 'template-parts/content', get_post_type() );
				endwhile;
			else :

				get_template_part( 'template-parts/content', 'none' );

			endif;
			?>
				</main><!-- #main -->
				<?php 
				if ( have_posts() ) :
					the_posts_pagination( array( 
						'mid_size' => 1, 
						'prev_text' => esc_html__( 'Prev', 'ananyapro' ),
	    				'next_text' => esc_html__( 'Next', 'ananyapro' ), 
	    			) );
				endif;
				?>
			</div><!-- #primary -->
			<?php get_sidebar(); ?>
		</div><!--.row-->
	</div><!-- .container-->
	<?php
	get_footer();
} ?>
