<?php
/**
 * The range slider Customizer control.
 *
 * @package AnanyaPRO
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}


/**
 * Create a range slider control.
 * This control allows you to add responsive settings.
 *
 * @since 1.0.0
 */
if ( class_exists( 'WP_Customize_Control' ) ) {
	class Ananyapro_Range_Custom_Control extends WP_Customize_Control {
		/**
		 * The type of control being rendered
		 */
		public $type = 'ananyapro-range-responsive';

		public $description = '';

		/**
		 * Enqueue our scripts and styles
		 */
		public function enqueue() {
			wp_enqueue_script( 'ananyapro-range-control', get_template_directory_uri() . '/inc/custom-controls/range/range.js', array( 'jquery',
					'customize-base',
					'jquery-ui-slider', ), false, true );
			wp_enqueue_style( 'ananyapro-range-control',  get_template_directory_uri() . '/inc/custom-controls/range/range.css', array(), false, 'all' );
		}

		/**
		 * Refresh the parameters passed to the JavaScript via JSON.
		 *
		 * @see WP_Customize_Control::to_json()
		 */
		public function to_json() {
			parent::to_json();

			$this->json['description'] = $this->description;

			foreach ( $this->settings as $setting_key => $setting_id ) {
				$this->json[ $setting_key ] = array(
					'link'  => $this->get_link( $setting_key ),
					'value' => $this->value( $setting_key ),
					'default' => isset( $setting_id->default ) ? $setting_id->default : '',
				);
			}
			$devices = array( 'desktop','tablet','mobile' );
			foreach ( $devices as $device ) {
				$this->json['choices'][ $device ]['min']  = ( isset( $this->choices[ $device ]['min'] ) ) ? $this->choices[ $device ]['min'] : '0';
				$this->json['choices'][ $device ]['max']  = ( isset( $this->choices[ $device ]['max'] ) ) ? $this->choices[ $device ]['max'] : '100';
				$this->json['choices'][ $device ]['step'] = ( isset( $this->choices[ $device ]['step'] ) ) ? $this->choices[ $device ]['step'] : '1';
				$this->json['choices'][ $device ]['unit'] = ( isset( $this->choices[ $device ]['unit'] ) ) ? $this->choices[ $device ]['unit'] : false;
			}
			foreach ( $devices as $device) {
				if( isset( $this->input_attrs[ $device ] ) ) {
					$this->json[$device]['inputAttrs'] = '';
					foreach ( $this->input_attrs[ $device ] as $attr => $value ) {
						if( 'unit' !== $attr ) {
							$this->json[$device]['inputAttrs'] .= $attr . '="' . esc_attr( $value ) . '" ';
						} else {
							$this->json[$device][$attr] = $value;
						}
					}
				}
			}
			
			$this->json['desktop_label'] = __( 'Desktop','ananyapro' );
			$this->json['tablet_label'] = __( 'Tablet','ananyapro' );
			$this->json['mobile_label'] = __( 'Mobile','ananyapro' );
			$this->json['reset_label'] = __( 'Reset to Default','ananyapro' );
			$this->json['unit_label'] = __('Unit (px/em)','ananyapro');		
		}
		/**
		 * Render the control in the customizer
		 */
		public function render_content() {
		}

		/**
		 * An Underscore (JS) template for this control's content (but not its container).
		 *
		 * Class variables for this control class are available in the `data` JS object;
		 * export custom variables by overriding {@see WP_Customize_Control::to_json()}.
		 *
		 * @see WP_Customize_Control::print_template()
		 *
		 * @access protected
		 */
		protected function content_template() { ?>
			<div class="ananyapro-range-responsive-control">
					
				<# if ( data.label ) { #>
					<div class="ananyapro-range-title">
						<# if ( data.label ) { #>
							<h2 class="customize-control-title">{{{ data.label }}}</h2>
						<# } #>
					</div><!-- ananyapro-range-title -->
				<# } #>

				<div class="ananyapro-devices-wrapper">
					<# if ( data.description ) { #>
						<div class="ananyapro-range-description">
							<p class="description">{{{ data.description }}}</p>
						</div><!-- ananyapro-range-description -->
					<# } #>
					
					<div class="ananyapro-devices">
						<# if ( 'undefined' !== typeof (data.desktop ) ) { #>
						<button type="button" class="preview-desktop" aria-pressed="true" data-device="desktop">
							<span class="screen-reader-text">Enter desktop preview mode</span><i class="ananyapro-device-desktop dashicons dashicons-desktop" data-option="desktop" title="{{ data.desktop_label }}"></i>
						</button>
						<# } #>

						<# if ( 'undefined' !== typeof (data.tablet) ) { #>
						<button type="button" class="preview-tablet" aria-pressed="false" data-device="tablet">
							<span class="screen-reader-text">Enter tablet preview mode</span><i class="ananyapro-device-tablet dashicons dashicons-tablet" data-option="tablet" title="{{ data.tablet_label }}"></i>
						</button>
						<# } #>

						<# if ( 'undefined' !== typeof (data.mobile) ) { #>
						<button type="button" class="preview-mobile" aria-pressed="false" data-device="mobile">
							<span class="screen-reader-text">Enter mobile preview mode</span><i class="ananyapro-device-mobile dashicons dashicons-smartphone" data-option="mobile" title="{{ data.mobile_label }}"></i>
						</button>
						<# } #>
					</div><!-- ananyapro-devices -->
				</div><!-- ananyapro-devices-wrapper -->
				<div class="ananyapro-range-responsive-control">
					<# if ( 'undefined' !== typeof ( data.desktop ) ) { #>
					<div class="ananyapro-range-slider range-desktop" data-device="desktop" style="display: none">
						<div class="slider" {{{ data.desktop.inputAttrs }}}></div><input type="number" {{{ data.desktop.inputAttrs }}} value="{{data.desktop.value}}" class="ananyapro-slider-control-value desktop-input" {{{data.desktop.link}}} />
						<span class="value">{{ data.desktop.value }}</span>
						<# if ( data.desktop.unit ) { #><span title="{{ data.unit_label }}" class="unit">{{ data.desktop.unit }}</span><# } #><span title="{{ data.reset_label }}" class="slider-reset dashicons dashicons-image-rotate" slider-reset-value="{{data.desktop.default}}"></span>
					</div>
					<# } #>

					<# if ( 'undefined' !== typeof ( data.tablet ) ) { #>
					<div class="ananyapro-range-slider range-tablet" data-device="tablet" style="display: none">
						<div class="slider" {{{ data.tablet.inputAttrs }}}></div><input type="number" {{{ data.tablet.inputAttrs }}} value="{{data.tablet.value}}" class="ananyapro-slider-control-value tablet-input" {{{data.tablet.link}}} />
						<span class="value">{{ data.tablet.value }}</span>
						<# if ( data.tablet.unit ) { #>
						<span class="value">{{ data.mobile.value }}</span>
						<span title="{{ data.unit_label }}" class="unit">{{ data.tablet.unit }}</span><# } #><span title="{{ data.reset_label }}" class="slider-reset dashicons dashicons-image-rotate" slider-reset-value="{{data.tablet.default}}"></span>
					</div>
					<# } #>

					<# if ( 'undefined' !== typeof ( data.mobile ) ) { #>
					<div class="ananyapro-range-slider range-mobile" data-device="mobile" style="display: none">
						<div class="slider" {{{ data.mobile.inputAttrs }}}></div><input type="number" {{{ data.mobile.inputAttrs }}} value="{{data.mobile.value}}" class="ananyapro-slider-control-value mobile-input" {{{data.mobile.link}}} />
						<span class="value">{{ data.mobile.value }}</span>
						<# if ( data.mobile.unit ) { #>
						<span class="value">{{ data.mobile.value }}</span>
						<span title="{{ data.unit_label }}" class="unit">{{ data.mobile.unit }}</span><# } #><span title="{{ data.reset_label }}" class="slider-reset dashicons dashicons-image-rotate" slider-reset-value="{{data.mobile.default}}"></span>
					</div>
					<# } #>
				</div><!-- ananyapro-range-control -->
			</div><!-- ananyapro-range-responsive-control -->
		<?php }
	}
}