wp.customize.controlConstructor['ananyapro-range-responsive'] = wp.customize.Control.extend({

	ready: function() {

		'use strict';

		var control = this,
			controlClass = '.customize-control-ananyapro-range-responsive',
			footerActions = jQuery( '#customize-footer-actions' );


		//Set the first device icon as active device on load
		jQuery( controlClass + ' .ananyapro-range-responsive-control' ).each( function() {
			var range_control = jQuery( this );
			
			range_control.find( '.ananyapro-devices' ).children( 'button:first-child' ).addClass( 'active' );
			range_control.find( '.ananyapro-range-responsive-control div:first-child' ).show();
			range_control.find( '.ananyapro-range-responsive-control div:not(:first-child)' ).hide();
		});

		//Set the clicked icon as active device and show corresponding range controls
		jQuery( controlClass + ' .ananyapro-devices button' ).on( 'click', function( event ) {
			var device = jQuery( this ).data( 'device' );
			
			jQuery( controlClass + ' .ananyapro-devices button' ).each( function() {
				var device_button = jQuery( this );
				if ( device == device_button.attr( 'data-device' ) ) {
					device_button.addClass( 'active' );
					device_button.siblings().removeClass( 'active' );
				}
			});
			
			jQuery( controlClass + ' .ananyapro-range-responsive-control div' ).each( function() {
				
				var device_block = jQuery( this );
				
				if ( device == device_block.attr( 'data-device' ) ) {
					device_block.show();
					device_block.siblings().hide();
				}
			});
			
			// Set the device we're currently viewing
			wp.customize.previewedDevice.set( jQuery( event.currentTarget ).data( 'device' ) );
		} );

		// Set the selected devices in our control when the Customizer devices are clicked
		footerActions.find( controlClass + ' .devices button' ).on( 'click', function() {			
			var device = jQuery( this ).data( 'device' );
			jQuery( controlClass + ' .ananyapro-devices button' ).each( function() {
				var device_button = jQuery( this );
				if ( device == device_button.attr( 'data-device' ) ) {
					device_button.addClass( 'active' );
					device_button.siblings().removeClass( 'active' );
				}
			});
			jQuery( controlClass + ' .ananyapro-range-responsive-control div' ).each( function() {
				
				var device_block = jQuery( this );
				
				if ( device == device_block.attr( 'data-device' ) ) {
					device_block.show();
					device_block.siblings().hide();
				}
			});			
		} );
		
		// Set our slider defaults and initialise the slider
		jQuery( controlClass + ' .ananyapro-range-slider' ).each(function(){
			var sliderInput = jQuery(this).find('input[type="number"]');
			var sliderValue = jQuery(this).find('.ananyapro-slider-control-value').val();
			var newSlider = jQuery(this).find('.slider');
			var sliderMinValue = parseFloat(newSlider.attr('min'));
			var sliderMaxValue = parseFloat(newSlider.attr('max'));
			var sliderStepValue = parseFloat(newSlider.attr('step'));
			var hiddenSpan = jQuery(this).find('input[type="number"]').next( '.value' );
			
			newSlider.slider({
				value: sliderValue,
				min: sliderMinValue,
				max: sliderMaxValue,
				step: sliderStepValue,	
		   		change: function( event, ui ) {
					newSlider.next().attr('value',ui.value);
					hiddenSpan.text( ui.value );
				},
				slide: function( event, ui ) {
					sliderInput.val(ui.value).change();
					hiddenSpan.text( ui.value );
				}
			});
		});

		// Reset slider and input field back to the default value
		jQuery( controlClass + ' .slider-reset').on('click', function() {

			var resetValue = jQuery(this).attr('slider-reset-value');
			jQuery( this ).parent().find( '.ananyapro-slider-control-value' ).val( resetValue ).change();;
			jQuery( this ).parent().find('.slider' ).slider('value', parseFloat(resetValue));
			jQuery(this).find('input[type="number"]').next( '.value' ).text( resetValue );

		});

		// Update slider if the input field loses focus as it's most likely changed
		jQuery( controlClass + ' .ananyapro-slider-control-value').blur(function() {
			var inputValue = jQuery(this).val();
			var slider = jQuery(this).parent().find('.slider');
			var sliderMinValue = parseFloat(slider.attr('min'));
			var sliderMaxValue = parseFloat(slider.attr('max'));
			
			// Make sure our manual input value doesn't exceed the minimum & maxmium values
			if(inputValue < sliderMinValue) {
				inputValue = sliderMinValue;
				jQuery(this).val(inputValue);
			}
			if(inputValue > sliderMaxValue) {
				inputValue = sliderMaxValue;
				jQuery(this).val(inputValue);
			}
			jQuery(this).parent().find('.slider').slider('value', inputValue);
		});
			
		//Apply changes when desktop slider is changed
		control.container.on( 'input change	', '.desktop-input',
			function(e) {
				var inputVal = jQuery( this ).val();
				if( e.type === 'change' ) {
					
					var slider = jQuery(this).parent().find('.slider');
					var sliderMinValue = parseFloat(slider.attr('min'));
					var sliderMaxValue = parseFloat(slider.attr('max'));
					
					// Make sure our manual input value doesn't exceed the minimum & maxmium values
					if(inputVal < sliderMinValue) {
						inputVal = sliderMinValue;
						
					}
					else if(inputVal > sliderMaxValue) {
						inputVal = sliderMaxValue;
					}
				}
				control.settings['desktop'].set( inputVal );
			}
		);
		
		// Apply changes when tablet slider is changed
		control.container.on( 'input change', '.tablet-input',
			function(e) {
				var inputVal = jQuery( this ).val();
				if( e.type === 'change' ) {
					
					var slider = jQuery(this).parent().find('.slider');
					var sliderMinValue = parseFloat(slider.attr('min'));
					var sliderMaxValue = parseFloat(slider.attr('max'));
					
					// Make sure our manual input value doesn't exceed the minimum & maxmium values
					if(inputVal < sliderMinValue) {
						inputVal = sliderMinValue;
						
					}
					else if(inputVal > sliderMaxValue) {
						inputVal = sliderMaxValue;
					}
				}
				control.settings['tablet'].set( inputVal );
			}
		);
		
		// Apply changes when mobile slider is changed
		control.container.on( 'input change', '.mobile-input',
			function(e) {
				var inputVal = jQuery( this ).val();
				if( e.type === 'change' ) {
					
					var slider = jQuery(this).parent().find('.slider');
					var sliderMinValue = parseFloat(slider.attr('min'));
					var sliderMaxValue = parseFloat(slider.attr('max'));
					
					// Make sure our manual input value doesn't exceed the minimum & maxmium values
					if(inputVal < sliderMinValue) {
						inputVal = sliderMinValue;
						
					}
					else if(inputVal > sliderMaxValue) {
						inputVal = sliderMaxValue;
					}
				}
				control.settings['mobile'].set( inputVal );
			}
		);
	} //end of ready
});