<?php 
//customizer controls functions

/*
** Reusable Functions =====
*/
	// checkbox
	function ananyapro_checkbox_control( $id,  $section, $label, $description, $transport, $priority, $default, $active_callback = '' ) {
		global $wp_customize;

		$wp_customize->add_setting( 'ananyapro_'. $id , array(
			'default'	 		=> 	$default,
			'transport'	 		=> 	$transport,
			'sanitize_callback' => 	'ananyapro_sanitize_checkbox'
		) );
		$wp_customize->add_control( 'ananyapro_'. $id, array(
			'label'				=> 	$label,
			'description'		=>	$description,
			'section'			=> 	'ananyapro_'.$section,
			'settings'  		=> 	'ananyapro_'. $id,
			'type'				=> 	'checkbox',
			'priority'			=> 	$priority,
			'active_callback' 	=> 	$active_callback,
		) );
	}
	// text
	function ananyapro_text_control( $id,  $section, $label, $description, $transport, $priority, $default, $active_callback  = '' ) {
		global $wp_customize;
		$wp_customize->add_setting( 'ananyapro_'. $id, array(
			'default'	 		=> 	$default,
			'transport'	 		=> 	$transport,
			'sanitize_callback' => 	'wp_kses_post',
		) );
		$wp_customize->add_control( 'ananyapro_'. $id, array(
			'label'				=> 	$label,
			'description'		=>	$description,
			'section'			=> 	'ananyapro_'. $section,
			'settings'  		=> 	'ananyapro_'. $id,
			'type'				=> 	'text',
			'priority'			=> 	$priority,
			'active_callback' 	=> 	$active_callback,
		) );
	}

	// color
	function ananyapro_color_control(  $id, $section, $label, $description, $transport, $priority, $default, $active_callback  = '' ) {
		global $wp_customize;
		$wp_customize->add_setting( 'ananyapro_'. $id, array(
			'default'	 		=> 	$default,
			'transport'	 		=> 	$transport,
			'sanitize_callback' => 	'sanitize_hex_color'
		) );
		$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'ananyapro_'. $id, array(
			'label' 			=>  $label,
			'description'		=>	$description,
			'section'			=> 	'ananyapro_'. $section,
			'settings'  		=> 	'ananyapro_'. $id,
			'priority'			=> 	$priority,
			'active_callback' 	=> 	$active_callback,
		) ) );
	}

	// textarea
	function ananyapro_textarea_control( $id,  $section, $label, $description, $transport, $priority, $default, $active_callback = ''   ) {
		global $wp_customize;
		$wp_customize->add_setting( 'ananyapro_'. $id, array(
			'default'	 		=>	$default,
			'transport'	 		=> 	$transport,
			'sanitize_callback' => 	'wp_kses_post',
		) );
		$wp_customize->add_control( 'ananyapro_'. $id, array(
			'label'				=> 	$label, 
			'description'		=> 	$description,
			'section'			=> 	'ananyapro_'. $section,
			'settings'  		=> 	'ananyapro_'. $id,
			'type'				=> 	'textarea',
			'priority'			=> 	$priority,
			'active_callback' 	=> 	$active_callback,
		) );
	}

	// url
	function ananyapro_url_control( $id,  $section, $label, $description, $transport, $priority, $default, $active_callback  = '' ) {
		global $wp_customize;
		$wp_customize->add_setting( 'ananyapro_'. $id, array(
			'default'	 		=> 	$default,
			'transport'	 		=> 	$transport,
			'sanitize_callback' => 	'esc_url_raw',
		) );
		$wp_customize->add_control( 'ananyapro_'. $id, array(
			'label'				=>	$label,
			'description'		=>	$description,
			'section'			=> 	'ananyapro_'. $section,
			'settings'  		=> 	'ananyapro_'. $id,
			'type'				=> 	'text',
			'priority'			=> 	$priority,
			'active_callback' 	=> 	$active_callback,
		) );
	}

	// number absint
	function ananyapro_number_control($id,  $section, $label, $description, $atts, $transport, $priority, $default, $sanitize_fun, $active_callback = '' ) {
		global $wp_customize;

		$wp_customize->add_setting( 'ananyapro_'. $id, array(
			'default'	 		=> 	$default,
			'transport'	 		=> 	$transport,
			'sanitize_callback' => 	$sanitize_fun,
		) );
		$wp_customize->add_control( 'ananyapro_'. $id, array(
			'label'				=> 	$label, 
			'description'		=>	$description,
			'section'			=> 	'ananyapro_'. $section,
			'settings'  		=> 	'ananyapro_'. $id,
			'type'				=> 	'number',
			'input_attrs' 		=> 	$atts,
			'priority'			=> 	$priority,
			'active_callback' 	=> 	$active_callback,
		) );
	}


	// select
	function ananyapro_select_control( $id,  $section, $label, $description, $atts, $transport, $priority, $default, $active_callback  = '' ) {
		global $wp_customize;
		$wp_customize->add_setting( 'ananyapro_'. $id, array(
			'default'	 		=> 	$default,
			'transport'	 		=> 	$transport,
			'sanitize_callback' => 	'ananyapro_sanitize_select'
		) );
		$wp_customize->add_control( 'ananyapro_'. $id, array(
			'label'				=> 	$label, 
			'description'		=>	$description,
			'section'			=> 	'ananyapro_'. $section,
			'settings'  		=> 	'ananyapro_'. $id,
			'type'				=> 	'select',
			'choices' 			=> 	$atts,
			'priority'			=> 	$priority,
			'active_callback' 	=> 	$active_callback,
		) );
	}

	// radio
	function ananyapro_radio_control( $id,  $section, $label, $description, $atts, $transport, $priority, $default, $active_callback  = '' ) {
		global $wp_customize;

		$wp_customize->add_setting( 'ananyapro_'. $id, array(
			'default'	 		=> 	$default,
			'transport'	 		=> 	$transport,
			'sanitize_callback' => 	'ananyapro_sanitize_radio',
		) );
		$wp_customize->add_control( 'ananyapro_'. $id, array(
			'label'				=> 	$label,
			'description'		=>	$description,
			'section'			=> 	'ananyapro_'. $section,
			'settings'  		=> 	'ananyapro_'. $id,
			'type'				=> 	'radio',
			'choices' 			=> 	$atts,
			'priority'			=> 	$priority,
			'active_callback' 	=> 	$active_callback,
		) );
	}

	// image
	function ananyapro_image_control( $id,  $section, $label, $transport, $priority, $default, $active_callback  = '' ) {
		global $wp_customize;
		$wp_customize->add_setting( 'ananyapro_'. $id, array(
		    'default' 				=> 	$default,
		    'transport' 			=> 	$transport,
		    'sanitize_callback' 	=> 	'esc_url_raw'
		) );
		$wp_customize->add_control(
			new WP_Customize_Image_Control( $wp_customize, 'ananyapro_'. $id, array(
				'label'    			=>  $label,
				'section'			=> 	'ananyapro_'. $section,
				'settings'  		=> 	'ananyapro_'. $id,
				'priority' 			=>  $priority,
				'active_callback' 	=> 	$active_callback,
			)
		) );
	}

	// image crop
	function ananyapro_image_crop_control( $id,  $section, $label, $width, $height, $transport, $priority, $default, $active_callback  = '' ) {
		global $wp_customize;
		$wp_customize->add_setting( 'ananyapro_'. $id, array(
			'transport' 			=> 	$transport,
			'sanitize_callback' 	=> 	'absint',
		) );
		$wp_customize->add_control(
			new WP_Customize_Cropped_Image_Control( $wp_customize, 'ananyapro_'. $id, array(
				'label'    			=> 	$label,
				'section'			=> 	'ananyapro_'. $section,
				'settings'  		=> 	'ananyapro_'. $id,
				'flex_width'  		=> 	true,
				'flex_height' 		=> 	true,
				'width'       		=> 	$width,
				'height'      		=> 	$height,
				'priority' 			=> 	$priority,
				'active_callback' 	=> 	$active_callback,
			)
		) );
	}