<?php
/**
 * AnanyaPRO Theme Customizer
 *
 * @package AnanyaPRO
 * @since 1.0
 */

/**
 * Add customizer settings and controls for custom logo.
 *
 * @param WP_Customize_Manager $wp_customize Theme Customizer object.
 *
 */
function ananyapro_custom_logo_options_setup( $wp_customize ) {

	$defaults = ananyapro_get_defaults();
	
	//  ==============================================================
    //  = Custom logo for pages having non transparent header          =
    //  ==============================================================
	$wp_customize->add_setting( 'ananyapro_non_transparent_header_logo', array(
	    'sanitize_callback' 	=>	'absint',
		'transport'         	=> 	'refresh'
	));
	$wp_customize->add_control(
		new WP_Customize_Cropped_Image_Control( $wp_customize, 'ananyapro_non_transparent_header_logo', array(
		    'section' 			=> 	'title_tagline',
		    'settings'  		=> 	'ananyapro_non_transparent_header_logo',
		    'priority'      	=> 	9,
		    'label' 			=> 	esc_html__( 'Logo - Non Transparent Header', 'ananyapro' ),
		    'height'      		=> 	80,
			'width'       		=> 	180,
			'flex-width'  		=> 	true,
			'flex-height' 		=> 	true,
			'active_callback'	=>  'ananyapro_is_header_image_only_on_frontpage',
		))
	);
}
add_action( 'customize_register', 'ananyapro_custom_logo_options_setup' );

if ( ! function_exists( 'ananyapro_is_header_image_only_on_frontpage' ) ) :
/**
 * Returns true if option "header image on only front page is selected"..
 */
function ananyapro_is_header_image_only_on_frontpage( $control ) {
    if ( true === $control->manager->get_setting( 'ananyapro_use_header_image_only_on_front_page_setting' )->value() ) {
        return true;
    } else {
        return false;
    }
}
endif;
