<?php
/**
 * AnanyaPRO Theme Customizer.
 * 
 * @package AnanyaPRO
 * @since 1.0
 */

/**
 * Add customizer settings and controls for custom search box option to Primary Navigation.
 * @param WP_Customize_Manager $wp_customize Theme Customizer object.
 */
function ananyapro_customize_search_box( $wp_customize ) {

	$defaults = ananyapro_get_defaults();
	
	$wp_customize->add_section( 'ananyapro_searchbox_section', 
		array(
			'title'		=> 	esc_html__( 'Search Box', 'ananyapro' ),
			'panel'		=> 	'ananyapro_options_panel',
			'priority' 	=> 	5,
		)
	);
	//Add setting for diplaying search box to primary navigation menu.
	$wp_customize->add_setting(
		'ananyapro_searchbox_display_setting',
		array(
			'default'           => 	$defaults['searchbox_display'],
			'transport'         => 	'refresh',
			'sanitize_callback' => 	'ananyapro_sanitize_checkbox',
		)
	);
	$wp_customize->add_control(
		'ananyapro_searchbox_display_setting',
		array(
			'type' 		=> 	'checkbox',
			'label' 	=> 	esc_html__( 'Add Search button to the Top Navigation.', 'ananyapro' ),
			'priority'	=> 	1,
			'settings'	=> 	'ananyapro_searchbox_display_setting',
			'section'	=> 	'ananyapro_searchbox_section',
		)
	);
}
add_action( 'customize_register', 'ananyapro_customize_search_box' );

