<?php
/**
 * AnanyaPRO Theme Customizer
 *
 * @package AnanyaPRO
 * @since 1.0
 */

/**
 * Add customizer settings and controls for single page options.
 *
 * @param WP_Customize_Manager $wp_customize Theme Customizer object.
 */

function ananyapro_custom_single_page_section_setup( $wp_customize ) {

	$defaults = ananyapro_get_defaults();
	
	//  =======================================================================
    //  = Single Post Option: Use featured image in header section            =
    //  =======================================================================
	$wp_customize->add_section( 'ananyapro_single_page_settings_section', array(
	  'title' 		=> 	esc_html__( 'Single Page Settings', 'ananyapro' ),
	  'priority' 	=> 	3,
	  'panel' 		=> 	'ananyapro_options_panel',
	) );
	$atts = array( 
		'default' 			=>  esc_html__( 'Default', 'ananyapro' ),
		'over-hero-image' 	=>  esc_html__( 'Over the hero image', 'ananyapro' ),
	);
	ananyapro_radio_control( 'single_page_title_position',  'single_page_settings_section', esc_html__( 'Single Page Title Position', 'ananyapro' ), '', $atts, 'refresh', 1, $defaults['single_page_title_position'], 'ananyapro_has_header_image_and_page_no_image_in_header' );

	ananyapro_checkbox_control( 'single_page_featured_image_in_header',  'single_page_settings_section', esc_html__( 'Use page\'s featured image in place of header image in site header.', 'ananyapro' ), '', 'refresh', 2, false, 'ananyapro_has_header_image_and_page_no_image_in_header'  );
}
add_action( 'customize_register', 'ananyapro_custom_single_page_section_setup' );

function ananyapro_has_header_image_and_page_no_image_in_header() {
	$header_image_only_on_front_page = get_theme_mod( 'ananyapro_use_header_image_only_on_front_page_setting', false );
	if( has_header_image() && !$header_image_only_on_front_page ) {
		return true;
	} else {
		return false;
	}
}