<?php
/**
 * AnanyaPRO Theme Customizer
 *
 * @package AnanyaPRO
 * @since 1.0
 */

/**
 * Add customizer settings and controls for single post options.
 *
 * @param WP_Customize_Manager $wp_customize Theme Customizer object.
 */

function ananyapro_custom_single_post_section_setup( $wp_customize ) {

	$defaults = ananyapro_get_defaults();
	
	//  =======================================================================
    //  = Single Post Option: Use featured image in header section            =
    //  =======================================================================
	$wp_customize->add_section( 'ananyapro_single_post_settings_section', array(
	  'title' 		=> 	esc_html__( 'Single Post Settings', 'ananyapro' ),
	  'priority' 	=> 	4,
	  'panel' 		=> 	'ananyapro_options_panel',
	) );
	//  ==============================================================
    //  = Disable/Hide default social media icons on a single page           =
    //  ==============================================================
	$wp_customize->add_setting( 'ananyapro_hide_single_post_share_option', array(
	    'default'        	=> 	$defaults['hide_single_post_share_option'],
	    'transport'         => 	'refresh',
	    'sanitize_callback' => 	'ananyapro_sanitize_checkbox',
	));
	$wp_customize->add_control( 'ananyapro_hide_single_post_share_option', 
		array(
		  	'label' 		=> 	esc_html__( 'Hide social media sharing icons on a single post.', 'ananyapro' ),
		    'section'    	=> 	'ananyapro_single_post_settings_section',
		    'settings'   	=> 	'ananyapro_hide_single_post_share_option',
		    'type'       	=> 	'checkbox',
	));

	$atts = array( 
		'default' 			=>  esc_html__( 'Default', 'ananyapro' ),
		'over-hero-image' 	=>  esc_html__( 'Over the hero image', 'ananyapro' ),
	);
	ananyapro_radio_control( 'single_post_title_position',  'single_post_settings_section', esc_html__( 'Single Post Title Position', 'ananyapro' ), '', $atts, 'refresh', 1, $defaults['single_page_title_position'], 'ananyapro_has_header_image_and_page_no_image_in_header' );

	//Hide Date
	ananyapro_checkbox_control( 'single_post_featured_image_in_header',  'single_post_settings_section', 	esc_html__( 'Use post\'s featured image in place of header image in site header.', 'ananyapro' ), '', 'refresh', 2, false, 'ananyapro_has_header_image_and_page_no_image_in_header' );

	//Hide Date
	ananyapro_checkbox_control( 'hide_single_post_date',  'single_post_settings_section', 	esc_html__( 'Hide Date', 'ananyapro' ), '', 'refresh', 3, false );

	//Hide Author
	ananyapro_checkbox_control( 'hide_single_post_author',  'single_post_settings_section', 	esc_html__( 'Hide Author Name', 'ananyapro' ), '', 'refresh', 4, false );

	//Hide Comment Link
	ananyapro_checkbox_control( 'hide_single_post_comment_link',  'single_post_settings_section', 	esc_html__( 'Hide Comments Link', 'ananyapro' ), '', 'refresh', 5, false );

	//Hide Featured Image 
	ananyapro_checkbox_control( 'hide_single_post_featured_image',  'single_post_settings_section', 	esc_html__( 'Hide Featured Image', 'ananyapro' ), '', 'refresh', 6, false, 'ananyapro_not_post_feat_img_in_site_header' );

}
add_action( 'customize_register', 'ananyapro_custom_single_post_section_setup' );

function ananyapro_not_post_feat_img_in_site_header( $control ) {
	$feat_img_in_siteheader = $control->manager->get_setting( 'ananyapro_single_post_featured_image_in_header' )->value();
	if( !$feat_img_in_siteheader ) {
		return true;
	} else {
		return false;
	}
}
