<?php
/**
 * AnanyaPRO Theme Customizer
 *
 * @package AnanyaPRO
 * @since 1.0
 */

/**
 * Add customizer settings and controls to set up the social media option.
 *
 * @param WP_Customize_Manager $wp_customize Theme Customizer object.
 * @since 1.0.0
 */
function ananyapro_custom_social_media_section_setup( $wp_customize ) {

	$defaults = ananyapro_get_defaults();
	
	//  =============================================================
    //  = Social Media Options: Select any four social media services to display on home page  =
    //  =============================================================
	$wp_customize->add_section( 'ananyapro_social_media_settings_section', array(
	  'title' 		=> 	esc_html__( 'Social Menu Section', 'ananyapro' ),
	  'priority' 	=> 	5,
	  'panel' 		=> 	'ananyapro_options_panel',
	) );
	$wp_customize->add_setting( 'ananyapro_social_media_menu_enable', array(
	  'default' 	=> 	$defaults['social_media_menu_enable'],
	  'transport' 	=> 	'refresh', 
	  'sanitize_callback' => 'ananyapro_sanitize_checkbox',
	) );
	$wp_customize->add_control( 'ananyapro_social_media_menu_enable', array(
	  'type' 		=> 	'checkbox',
	  'priority' 	=> 	1, 
	  'section' 	=> 	'ananyapro_social_media_settings_section', 
	  'label' 		=> 	esc_html__( 'Enable Social Media Icons in top Navigation.', 'ananyapro' ),
	  'settings'   	=> 	'ananyapro_social_media_menu_enable',
	) );

	// Social Icons Array
	$social_media_names = array(
		'facebook-f' 			=> 'Facebook',
		'facebook-square' 		=> 'Facebook Square',
		'twitter' 				=> 'Twitter',
		'twitter-square' 		=> 'Twitter Square',
		'google' 				=> 'Google',
		'linkedin'				=> 'Linkedin Square',
		'linkedin-in' 			=> 'LinkedIn',
		'pinterest' 			=> 'Pinterest',
		'pinterest-square'		=> 'Pinterest Square',
		'behance' 				=> 'Behance',
		'behance-square'		=> 'Behance Square',
		'tumblr' 				=> 'Tumblr',
		'tumblr-square' 		=> 'Tumblr Square',
		'reddit' 				=> 'Reddit',
		'reddit-square' 		=> 'Reddit Square',
		'dribbble' 				=> 'Dribbble',
		'vk' 					=> 'vKontakte',
		'skype' 				=> 'Skype',
		'film' 					=> 'Film',
		'youtube' 				=> 'Youtube',
		'youtube-square' 		=> 'Youtube Square',
		'vimeo-v'				=> 'Vimeo',
		'vimeo'					=> 'Vimeo Square 1',
		'vimeo-square' 			=> 'Vimeo Square 2',
		'soundcloud' 			=> 'Soundcloud',
		'instagram' 			=> 'Instagram',
		'info' 					=> 'Info',
		'info-circle' 			=> 'Info Circle',
		'flickr' 				=> 'Flickr',
		'rss' 					=> 'RSS',
		'rss-square' 			=> 'RSS Square',
		'heart' 				=> 'Heart',
		'github' 				=> 'Github',
		'github-alt' 			=> 'Github Alt',
		'github-square' 		=> 'Github Square',
		'stack-overflow' 		=> 'Stack Overflow',
		'qq' 					=> 'QQ',
		'weibo' 				=> 'Weibo',
		'weixin' 				=> 'Weixin',
		'xing' 					=> 'Xing',
		'xing-square' 			=> 'Xing Square',
		'gamepad' 				=> 'Gamepad',
		'medium' 				=> 'Medium',
		'map-marker' 			=> 'Map Marker',
		'envelope' 				=> 'Envelope',
		'envelope-open' 		=> 'Envelope Open',
		'envelope-square' 		=> 'Envelope Square',
		'spotify'				=> 'Spotify',
		'shopping-cart'			=> esc_html__( 'Cart', 'ananyapro' ),
		'cc-paypal' 			=> 'PayPal',
		'credit-card' 			=> esc_html__( 'Credit Card', 'ananyapro' ), 
	);
	
	for( $count=1; $count<=4; $count++ ) {
		
		$wp_customize->add_setting( 'ananyapro_social_media_icon_'.$count, array(
			'default'	 		=> 	$defaults['social_media_icon'],
			'transport'	 		=> 	'refresh',
			'sanitize_callback' => 	'ananyapro_sanitize_select'
		) );
		$wp_customize->add_control( 'ananyapro_social_media_icon_'.$count, 
			array(
				'label'			=> 	esc_html__( 'Social Media Name', 'ananyapro' ),
				'settings'		=> 	'ananyapro_social_media_icon_'.$count,
				'section'		=> 	'ananyapro_social_media_settings_section',
				'type'			=> 	'select',
				'choices' 		=> 	$social_media_names,
				'priority'		=> 	$count+1,
		) );
		$wp_customize->add_setting( 'ananyapro_social_media_url_'.$count, array(
			'default'	 		=> 	$defaults['social_media_url'],
			'transport'	 		=> 	'refresh',
			'sanitize_callback' => 	'esc_url_raw',
		) );
		$wp_customize->add_control( 'ananyapro_social_media_url_'.$count, 
			array(
				'label'			=> 	esc_html__( 'Social Media URL', 'ananyapro' ),
				'settings'		=> 	'ananyapro_social_media_url_'.$count,
				'section'		=> 	'ananyapro_social_media_settings_section',
				'type'			=> 	'text',
				'priority'		=> 	$count+1,
		) );
	}
}
add_action( 'customize_register', 'ananyapro_custom_social_media_section_setup' );