<?php

/**
 * AnanyaPRO Theme Customizer
 *
 * @package AnanyaPRO
 * @since 1.0
 */

/**
 * Add customizer section and control for Theme Information.
 *
 * @param WP_Customize_Manager $wp_customize Theme Customizer object.
 */
function ananyapro_theme_info( $wp_customize ) {
// Add Section for Theme Information.
$wp_customize->add_section( 'ananyapro_section_theme_info', array(
	'title'    => esc_html__( 'Theme Info', 'ananyapro' ),
	'priority' => 200,
	'panel'    => 'ananyapro_options_panel',
) );

// Add Theme Info Control.
$wp_customize->add_control( new Ananyapro_Customize_Theme_Info_Control(
	$wp_customize, 'ananyapro_theme_info_links', array(
		'section'  => 'ananyapro_section_theme_info',
		'settings' => array(),
		'priority' => 100,
	)
) );
}
add_action( 'customize_register', 'ananyapro_theme_info' );

if ( class_exists( 'WP_Customize_Control' ) ) :

	/**
	 * Displays the theme links in the Customizer.
	 */
	class Ananyapro_Customize_Theme_Info_Control extends WP_Customize_Control {
		/**
		 * Render Control
		 */
		public function render_content() {
			?>

			<div class="theme-info-links">

				<span class="customize-control-title"><?php esc_html_e( 'Theme Information Links', 'ananyapro' ); ?></span>

				<p>
					<a href="<?php echo esc_url( 'https://www.falgunithemes.com/downloads/ananyapro/' ); ?>" target="_blank">
						<?php esc_html_e( 'Theme Homepage', 'ananyapro' ); ?>
					</a>
				</p>

				<p>
					<a href="https://falgunithemes.com/ananyapro-demo/" target="_blank">
						<?php esc_html_e( 'Theme Demo', 'ananyapro' ); ?>
					</a>
				</p>

				<p>
					<a href="<?php echo esc_url( 'https://www.falgunithemes.com/ananyapro-user-guide/' ); ?>" target="_blank">
						<?php esc_html_e( 'Theme Documentation', 'ananyapro' ); ?>
					</a>
				</p>

			</div>

			<?php
		}
	}

endif;