<?php
/**
 * The main template file
 *
 * This is the most generic template file in a WordPress theme
 * and one of the two required files for a theme (the other being style.css).
 * It is used to display a page when nothing more specific matches a query.
 * E.g., it puts together the home page when no home.php file exists.
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package AnanyaPRO
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

get_header();
$defaults = ananyapro_get_defaults();
$posts_layout = get_theme_mod( 'ananyapro_blog_posts_layout', $defaults['blog_posts_layout'] );
$blog_page_title= get_theme_mod( 'ananyapro_blog_page_title', $defaults['blog_page_title'] );
$blog_page_description = get_theme_mod( 'ananyapro_blog_page_description', $defaults['blog_page_description'] );
$page_head_style = get_theme_mod( 'ananyapro_single_page_title_position', $defaults['single_page_title_position'] );
?>
<?php if ( have_posts() ) :
	if ( is_home() && ! is_front_page() && $page_head_style !== 'over-hero-image' ) :
		?>
	<div class="blog-page-header">
		<header>
			<?php if( !empty( $blog_page_title ) || !empty( $blog_page_description )  ) : ?>
			<h2 class="blog-page-title"><span class="blog-title"><?php echo wp_kses_post( $blog_page_title ); ?></span></h2>
			<p class="blog-page-description"><?php echo wp_kses_post( $blog_page_description ); ?></p>
			<?php endif; ?>
		</header>
	</div><!-- blog-page-header -->
	<?php endif; 
endif; ?>
<div class="container">
	<div class="row">
		<div id="primary" class="content-area <?php echo esc_attr('blog-layout-'.$posts_layout); ?>">
			<main id="main" class="site-main">

			<?php
			if ( have_posts() ) : 
				/* Start the Loop */
				while ( have_posts() ) :
					the_post();
					get_template_part( 'template-parts/content', get_post_type() );
				endwhile;
			else :

				get_template_part( 'template-parts/content', 'none' );

			endif;
			?>

			</main><!-- #main -->
			<?php 
			if ( have_posts() ) :
				the_posts_pagination( array( 
					'mid_size' => 1, 
					'prev_text' => esc_html__( 'Prev', 'ananyapro' ),
    				'next_text' => esc_html__( 'Next', 'ananyapro' ), 
    			) );
			endif;
			?>
		</div><!-- #primary -->
		<?php get_sidebar(); ?>
	</div><!--.row-->
</div><!-- .container-->
<?php
get_footer();
