<?php
/**
 * Template part for displaying results in search pages
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package AnanyaPRO
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

$defaults = ananyapro_get_defaults();
$hide_footer = get_theme_mod( 'ananyapro_hide_blog_page_post_footer_option', $defaults['hide_blog_page_post_footer'] );
?>

<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
				
	<?php ananyapro_post_thumbnail(); ?>
	
	<div class="post-content-wrapper">
	
		<?php get_template_part( 'template-parts/posts/entry', 'header' ); ?>

		<?php get_template_part( 'template-parts/posts/entry','excerpt' ); ?>

		<?php
		if( !$hide_footer ) {
			ananyapro_excerpt_entry_footer(); 
		}
		?>
	</div><!-- post-content-wrapper -->
		
</article><!-- #post -->
