<?php
/**
 * Template-part for displaying Hero Image Caption.
 * @package AnanyaPRO
 * @since 1.0
 */

if ( ! defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly.
}

$defaults = ananyapro_get_defaults();
$hero_title = get_theme_mod( 'ananyapro_header_title', '' );
$hero_subtitle = get_theme_mod( 'ananyapro_header_subtitle', '' );
$hero_button1_text = get_theme_mod( 'ananyapro_header_button1_text', '');
$hero_btn1_url = get_theme_mod( 'ananyapro_header_button1_url', '' );
$hero_btn1_style = get_theme_mod( 'ananyapro_header_button1_style', $defaults['hero_read_more_btn_style'] );

$hero_button2_text = get_theme_mod( 'ananyapro_header_button2_text', '');
$hero_btn2_url = get_theme_mod( 'ananyapro_header_button2_url', '' );
$hero_btn2_style = get_theme_mod( 'ananyapro_header_button2_style', $defaults['hero_read_more_btn_style'] );

$hero_text_align = get_theme_mod( 'ananyapro_header_text_alignment', $defaults['header_text_alignment'] );
$hero_vertical_align = get_theme_mod( 'ananyapro_header_vertical_text_alignment', $defaults['header_vertical_text_alignment'] );

$justify = 'text-left';
$text_align = 'text-left';
//Align text over hero image/banner.
if( 'text-left'=== $hero_text_align ) {
	$justify = 'justify-content-start';
	$text_align = 'text-left';
} elseif( 'text-center'=== $hero_text_align ) {
	$justify = 'justify-content-center';
	$text_align = 'text-center';
} elseif( 'text-right' === $hero_text_align ) {
	$justify = 'justify-content-end';
	$text_align = 'text-right';
} 

$vert_align = 'h-bottom';
if( 'h-top'=== $hero_vertical_align ) {
    $vert_align = 'h-top';
} elseif( 'h-center'=== $hero_vertical_align ) {
    $vert_align = 'h-center';
} elseif( 'h-bottom' === $hero_vertical_align ) {
    $vert_align = 'h-bottom';
} 
?>

<div class="custom-heading <?php echo esc_attr( $vert_align ); ?>">
    <div class="container">
    	<div class="row <?php echo esc_attr( $justify ); ?>">
    	<div class="col-md-8 <?php echo esc_attr( $text_align ); ?>">
        	<?php if( $hero_title  || is_customize_preview() ) { ?>
            <h2 class="hero-title"><?php echo wp_kses_post( $hero_title ); ?></h2>
            <?php } ?>
            <?php if( $hero_subtitle  || is_customize_preview() ) { ?>
            <p class="subheading"><?php echo wp_kses_post( $hero_subtitle ); ?></p>
            <?php } ?>
            
            <?php if( '' !== $hero_button1_text  || '' !== $hero_button1_text || is_customize_preview() ) {?>
            <div class="buttons-wrapper">
            <?php } ?>

                <?php if( '' !== $hero_button1_text ) { ?>
                <a href="<?php echo esc_url( $hero_btn1_url ); ?>" target="_blank"><button id="hero-section-btn1" class="button hero-section-btn1 <?php echo esc_attr( $hero_btn1_style ); ?>"><?php echo esc_html( $hero_button1_text ); ?>
                </button></a>
                <?php } ?>

                <?php if( '' !== $hero_button2_text ) { ?>
                <a href="<?php echo esc_url( $hero_btn2_url ); ?>" target="_blank"><button id="hero-section-btn2" class="button hero-section-btn2 <?php echo esc_attr( $hero_btn2_style ); ?>"><?php echo esc_html( $hero_button2_text ); ?>
                </button></a>
                <?php } ?>

            <?php if( '' !== $hero_button1_text  || '' !== $hero_button1_text || is_customize_preview() ) { ?>    
            </div><!-- buttons-wrapper -->
            <?php } ?>
    	</div><!-- col-md-8 -->
    	</div><!-- row -->
    </div><!-- container -->
</div><!-- custom-heading -->
