<?php
/**
 * Header part of an post/article, which includes, article title and meta data.
 *
 *
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

$defaults = ananyapro_get_defaults();
$header_image_only_on_front_page = get_theme_mod( 'ananyapro_use_header_image_only_on_front_page_setting', $defaults['header_image_only_on_front_page'] );
$posts_layout = get_theme_mod( 'ananyapro_blog_posts_layout', $defaults['blog_posts_layout'] );
$hide_date = get_theme_mod( 'ananyapro_hide_blog_post_date', false );
$single_post_title_position = get_theme_mod( 'ananyapro_single_post_title_position', $defaults['single_page_title_position'] );
$page_header_uses_featured_image = get_theme_mod( 'ananyapro_single_page_featured_image_in_header', false );
$post_header_uses_featured_image = get_theme_mod( 'ananyapro_single_post_featured_image_in_header', false );
?>
<header class="entry-header">
	<?php  
	if ( has_post_thumbnail() ) {
		$add_class = 'has-post-thumbnail';
	} else {
		$add_class = '';
	}
	?>
	<?php if ( !is_single() && 'list-2' !== $posts_layout ) { ?>
	<div class="entry-meta">
	<?php if( !$hide_date ) { 
		ananyapro_posted_on(''); 
	} ?>
	</div><!-- entry-date -->
	<?php } ?>
	<?php
	if ( (is_single() && ( 'default' === $single_post_title_position || !has_header_image() || $header_image_only_on_front_page ) ) || ( class_exists( 'WooCommerce' ) && is_product() ) ) :
		the_title( '<h1 class="entry-title">', '</h1>' );
	elseif( !is_single() ):
		the_title( '<h2 class="entry-title"><a href="' . esc_url( get_permalink() ) . '" rel="bookmark">', '</a></h2>' );
	endif;
	//ananyapro_post_categories( 1 );
	if ( 'post' === get_post_type() ) :
		if( !is_singular() && ( 'classic' === $posts_layout  || 'grid' === $posts_layout || 'list-1' === $posts_layout ) ) {
			ananyapro_post_excerpt_meta();
		} elseif( !is_singular() && 'list-2' === $posts_layout ) {
			ananyapro_post_list_excerpt_meta();
		} else {
			if( 'default' === $single_post_title_position  || !has_header_image() || $header_image_only_on_front_page ) {
				ananyapro_single_post_meta();
			}
		}
	endif; ?>
</header><!-- .entry-header -->