/* DUPLICATOR-LITE (PHP BUILD MODE) MYSQL SCRIPT CREATED ON : 2021-10-04 14:40:29 */

/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;

SET FOREIGN_KEY_CHECKS = 0;

CREATE TABLE `psm_actionscheduler_actions` (
  `action_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `hook` varchar(191) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `scheduled_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `scheduled_date_local` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `args` varchar(191) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `schedule` longtext COLLATE utf8mb4_unicode_520_ci,
  `group_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `attempts` int(11) NOT NULL DEFAULT '0',
  `last_attempt_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `last_attempt_local` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `claim_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `extended_args` varchar(8000) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  PRIMARY KEY (`action_id`),
  KEY `hook` (`hook`),
  KEY `status` (`status`),
  KEY `scheduled_date_gmt` (`scheduled_date_gmt`),
  KEY `args` (`args`),
  KEY `group_id` (`group_id`),
  KEY `last_attempt_gmt` (`last_attempt_gmt`),
  KEY `claim_id` (`claim_id`)
) ENGINE=InnoDB AUTO_INCREMENT=25 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `psm_actionscheduler_claims` (
  `claim_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `date_created_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`claim_id`),
  KEY `date_created_gmt` (`date_created_gmt`)
) ENGINE=InnoDB AUTO_INCREMENT=293 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `psm_actionscheduler_groups` (
  `group_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `slug` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`group_id`),
  KEY `slug` (`slug`(191))
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `psm_actionscheduler_logs` (
  `log_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `action_id` bigint(20) unsigned NOT NULL,
  `message` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `log_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `log_date_local` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`log_id`),
  KEY `action_id` (`action_id`),
  KEY `log_date_gmt` (`log_date_gmt`)
) ENGINE=InnoDB AUTO_INCREMENT=71 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `psm_booking` (
  `booking_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `trash` bigint(10) NOT NULL DEFAULT '0',
  `sync_gid` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `is_new` bigint(10) NOT NULL DEFAULT '1',
  `status` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `sort_date` datetime DEFAULT NULL,
  `modification_date` datetime DEFAULT NULL,
  `form` text COLLATE utf8mb4_unicode_520_ci,
  `booking_type` bigint(10) NOT NULL DEFAULT '1',
  PRIMARY KEY (`booking_id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `psm_bookingdates` (
  `booking_dates_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `booking_id` bigint(20) unsigned NOT NULL,
  `booking_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `approved` bigint(20) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`booking_dates_id`),
  UNIQUE KEY `booking_id_dates` (`booking_id`,`booking_date`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `psm_ce4wp_abandoned_checkout` (
  `checkout_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `user_email` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `checkout_contents` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `checkout_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `checkout_updated_ts` int(11) unsigned NOT NULL DEFAULT '0',
  `checkout_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `checkout_created_ts` int(11) unsigned NOT NULL DEFAULT '0',
  `checkout_recovered` datetime DEFAULT '0000-00-00 00:00:00',
  `checkout_recovered_ts` int(11) unsigned DEFAULT '0',
  `checkout_consent` int(11) unsigned NOT NULL DEFAULT '1',
  `checkout_uuid` varchar(36) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`checkout_id`),
  UNIQUE KEY `checkout_uuid` (`checkout_uuid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `psm_ce4wp_contacts` (
  `contact_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `email` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `first_name` varchar(200) COLLATE utf8mb4_unicode_520_ci DEFAULT '',
  `last_name` varchar(200) COLLATE utf8mb4_unicode_520_ci DEFAULT '',
  `telephone` varchar(200) COLLATE utf8mb4_unicode_520_ci DEFAULT '',
  `consent` varchar(200) COLLATE utf8mb4_unicode_520_ci DEFAULT '',
  PRIMARY KEY (`contact_id`),
  UNIQUE KEY `email` (`email`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `psm_commentmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `psm_comments` (
  `comment_ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint(20) unsigned NOT NULL DEFAULT '0',
  `comment_author` tinytext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `comment_author_email` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `comment_karma` int(11) NOT NULL DEFAULT '0',
  `comment_approved` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_type` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'comment',
  `comment_parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `user_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10)),
  KEY `woo_idx_comment_type` (`comment_type`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `psm_cpappbk_forms` (
  `id` mediumint(9) NOT NULL AUTO_INCREMENT,
  `form_name` varchar(250) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `form_structure` mediumtext COLLATE utf8mb4_unicode_520_ci,
  `calendar_language` varchar(250) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `date_format` varchar(250) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `product_name` varchar(250) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `pay_later_label` varchar(250) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `defaultstatus` varchar(250) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `defaultpaidstatus` varchar(250) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `fp_from_email` varchar(250) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `fp_destination_emails` text COLLATE utf8mb4_unicode_520_ci,
  `fp_subject` varchar(250) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `fp_inc_additional_info` varchar(10) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `fp_return_page` varchar(250) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `fp_message` text COLLATE utf8mb4_unicode_520_ci,
  `fp_emailformat` varchar(10) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `fp_emailtomethod` varchar(10) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `fp_destination_emails_field` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `cu_enable_copy_to_user` varchar(10) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `cu_user_email_field` varchar(250) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `cu_subject` varchar(250) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `cu_message` text COLLATE utf8mb4_unicode_520_ci,
  `cu_emailformat` varchar(10) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `fp_emailfrommethod` varchar(10) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `vs_text_maxapp` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `vs_text_is_required` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `vs_text_is_email` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `vs_text_datemmddyyyy` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `vs_text_dateddmmyyyy` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `vs_text_number` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `vs_text_digits` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `vs_text_max` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `vs_text_min` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `vs_text_pageof` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `vs_text_submitbtn` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `vs_text_previousbtn` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `vs_text_nextbtn` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `vs_text_quantity` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `vs_text_cancel` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `vs_text_cost` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `vs_text_nmore` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `cp_user_access` text COLLATE utf8mb4_unicode_520_ci,
  `cp_user_access_settings` varchar(10) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `display_emails_endtime` varchar(10) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `rep_enable` varchar(10) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `rep_days` varchar(10) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `rep_hour` varchar(10) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `rep_emails` text COLLATE utf8mb4_unicode_520_ci,
  `rep_subject` text COLLATE utf8mb4_unicode_520_ci,
  `rep_emailformat` varchar(10) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `rep_message` text COLLATE utf8mb4_unicode_520_ci,
  `cv_enable_captcha` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `cv_width` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `cv_height` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `cv_chars` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `cv_font` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `cv_min_font_size` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `cv_max_font_size` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `cv_noise` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `cv_noise_length` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `cv_background` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `cv_border` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `cv_text_enter_valid_captcha` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  UNIQUE KEY `id` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `psm_cpappbk_messages` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `formid` int(11) NOT NULL,
  `time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `ipaddr` varchar(250) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `notifyto` varchar(250) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `data` mediumtext COLLATE utf8mb4_unicode_520_ci,
  `posted_data` mediumtext COLLATE utf8mb4_unicode_520_ci,
  `whoadded` varchar(250) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  UNIQUE KEY `id` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `psm_duplicator_packages` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(250) NOT NULL,
  `hash` varchar(50) NOT NULL,
  `status` int(11) NOT NULL,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `owner` varchar(60) NOT NULL,
  `package` longtext NOT NULL,
  PRIMARY KEY (`id`),
  KEY `hash` (`hash`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

CREATE TABLE `psm_e_submissions` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(60) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `hash_id` varchar(60) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `main_meta_id` bigint(20) unsigned NOT NULL COMMENT 'Id of main field. to represent the main meta field',
  `post_id` bigint(20) unsigned NOT NULL,
  `referer` varchar(500) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `referer_title` varchar(300) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `element_id` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `form_name` varchar(60) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `campaign_id` bigint(20) unsigned NOT NULL,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `user_ip` varchar(46) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `user_agent` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `actions_count` int(11) DEFAULT '0',
  `actions_succeeded_count` int(11) DEFAULT '0',
  `status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `is_read` tinyint(1) NOT NULL DEFAULT '0',
  `meta` text COLLATE utf8mb4_unicode_520_ci,
  `created_at_gmt` datetime NOT NULL,
  `updated_at_gmt` datetime NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `hash_id_unique_index` (`hash_id`),
  KEY `main_meta_id_index` (`main_meta_id`),
  KEY `hash_id_index` (`hash_id`),
  KEY `type_index` (`type`),
  KEY `post_id_index` (`post_id`),
  KEY `element_id_index` (`element_id`),
  KEY `campaign_id_index` (`campaign_id`),
  KEY `user_id_index` (`user_id`),
  KEY `user_ip_index` (`user_ip`),
  KEY `status_index` (`status`),
  KEY `is_read_index` (`is_read`),
  KEY `created_at_gmt_index` (`created_at_gmt`),
  KEY `updated_at_gmt_index` (`updated_at_gmt`),
  KEY `created_at_index` (`created_at`),
  KEY `updated_at_index` (`updated_at`),
  KEY `referer_index` (`referer`(191)),
  KEY `referer_title_index` (`referer_title`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `psm_e_submissions_actions_log` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `submission_id` bigint(20) unsigned NOT NULL,
  `action_name` varchar(60) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `action_label` varchar(60) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `log` text COLLATE utf8mb4_unicode_520_ci,
  `created_at_gmt` datetime NOT NULL,
  `updated_at_gmt` datetime NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `submission_id_index` (`submission_id`),
  KEY `action_name_index` (`action_name`),
  KEY `status_index` (`status`),
  KEY `created_at_gmt_index` (`created_at_gmt`),
  KEY `updated_at_gmt_index` (`updated_at_gmt`),
  KEY `created_at_index` (`created_at`),
  KEY `updated_at_index` (`updated_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `psm_e_submissions_values` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `submission_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `key` varchar(60) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`id`),
  KEY `submission_id_index` (`submission_id`),
  KEY `key_index` (`key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `psm_imagify_files` (
  `file_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `folder_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `file_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `path` varchar(191) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `hash` varchar(32) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `mime_type` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `modified` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `width` smallint(2) unsigned NOT NULL DEFAULT '0',
  `height` smallint(2) unsigned NOT NULL DEFAULT '0',
  `original_size` int(4) unsigned NOT NULL DEFAULT '0',
  `optimized_size` int(4) unsigned DEFAULT NULL,
  `percent` smallint(2) unsigned DEFAULT NULL,
  `optimization_level` tinyint(1) unsigned DEFAULT NULL,
  `status` varchar(20) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `error` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `data` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`file_id`),
  UNIQUE KEY `path` (`path`),
  KEY `folder_id` (`folder_id`),
  KEY `optimization_level` (`optimization_level`),
  KEY `status` (`status`),
  KEY `modified` (`modified`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `psm_imagify_folders` (
  `folder_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `path` varchar(191) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `active` tinyint(1) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`folder_id`),
  UNIQUE KEY `path` (`path`),
  KEY `active` (`active`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `psm_links` (
  `link_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_name` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_image` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_target` varchar(25) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_description` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_visible` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'Y',
  `link_owner` bigint(20) unsigned NOT NULL DEFAULT '1',
  `link_rating` int(11) NOT NULL DEFAULT '0',
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_notes` mediumtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `link_rss` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `psm_mailchimp_carts` (
  `id` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `email` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `user_id` int(11) DEFAULT NULL,
  `cart` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `created_at` datetime NOT NULL,
  PRIMARY KEY (`email`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `psm_mailchimp_jobs` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `obj_id` text COLLATE utf8mb4_unicode_520_ci,
  `job` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `created_at` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `psm_options` (
  `option_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(191) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `option_value` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `autoload` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`),
  KEY `autoload` (`autoload`)
) ENGINE=InnoDB AUTO_INCREMENT=8300 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `psm_postmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `post_id` (`post_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=3768 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `psm_posts` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_author` bigint(20) unsigned NOT NULL DEFAULT '0',
  `post_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_title` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_excerpt` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'publish',
  `comment_status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'open',
  `ping_status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'open',
  `post_password` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `post_name` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `to_ping` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `pinged` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content_filtered` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `guid` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `menu_order` int(11) NOT NULL DEFAULT '0',
  `post_type` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'post',
  `post_mime_type` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_count` bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`),
  KEY `post_name` (`post_name`(191)),
  KEY `type_status_date` (`post_type`,`post_status`,`post_date`,`ID`),
  KEY `post_parent` (`post_parent`),
  KEY `post_author` (`post_author`)
) ENGINE=InnoDB AUTO_INCREMENT=624 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `psm_term_relationships` (
  `object_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `term_taxonomy_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `term_order` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`object_id`,`term_taxonomy_id`),
  KEY `term_taxonomy_id` (`term_taxonomy_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `psm_term_taxonomy` (
  `term_taxonomy_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `taxonomy` varchar(32) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `description` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `count` bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_taxonomy_id`),
  UNIQUE KEY `term_id_taxonomy` (`term_id`,`taxonomy`),
  KEY `taxonomy` (`taxonomy`)
) ENGINE=InnoDB AUTO_INCREMENT=40 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `psm_termmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `term_id` (`term_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=29 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `psm_terms` (
  `term_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `slug` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `term_group` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_id`),
  KEY `slug` (`slug`(191)),
  KEY `name` (`name`(191))
) ENGINE=InnoDB AUTO_INCREMENT=40 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `psm_usermeta` (
  `umeta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`umeta_id`),
  KEY `user_id` (`user_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=65 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `psm_users` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_login` varchar(60) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_pass` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_nicename` varchar(50) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_email` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_url` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_registered` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `user_activation_key` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_status` int(11) NOT NULL DEFAULT '0',
  `display_name` varchar(250) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`ID`),
  KEY `user_login_key` (`user_login`),
  KEY `user_nicename` (`user_nicename`),
  KEY `user_email` (`user_email`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `psm_wc_admin_note_actions` (
  `action_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `note_id` bigint(20) unsigned NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `label` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `query` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `status` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `is_primary` tinyint(1) NOT NULL DEFAULT '0',
  `actioned_text` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`action_id`),
  KEY `note_id` (`note_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2226 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `psm_wc_admin_notes` (
  `note_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `type` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `locale` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `title` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `content` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `content_data` longtext COLLATE utf8mb4_unicode_520_ci,
  `status` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `source` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_reminder` datetime DEFAULT NULL,
  `is_snoozable` tinyint(1) NOT NULL DEFAULT '0',
  `layout` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `image` varchar(200) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `is_deleted` tinyint(1) NOT NULL DEFAULT '0',
  `icon` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'info',
  PRIMARY KEY (`note_id`)
) ENGINE=InnoDB AUTO_INCREMENT=53 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `psm_wc_category_lookup` (
  `category_tree_id` bigint(20) unsigned NOT NULL,
  `category_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`category_tree_id`,`category_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `psm_wc_customer_lookup` (
  `customer_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `username` varchar(60) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `first_name` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `last_name` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `email` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `date_last_active` timestamp NULL DEFAULT NULL,
  `date_registered` timestamp NULL DEFAULT NULL,
  `country` char(2) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `postcode` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `city` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `state` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`customer_id`),
  UNIQUE KEY `user_id` (`user_id`),
  KEY `email` (`email`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `psm_wc_download_log` (
  `download_log_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `timestamp` datetime NOT NULL,
  `permission_id` bigint(20) unsigned NOT NULL,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `user_ip_address` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT '',
  PRIMARY KEY (`download_log_id`),
  KEY `permission_id` (`permission_id`),
  KEY `timestamp` (`timestamp`),
  CONSTRAINT `fk_psm_wc_download_log_permission_id` FOREIGN KEY (`permission_id`) REFERENCES `psm_woocommerce_downloadable_product_permissions` (`permission_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `psm_wc_order_coupon_lookup` (
  `order_id` bigint(20) unsigned NOT NULL,
  `coupon_id` bigint(20) NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `discount_amount` double NOT NULL DEFAULT '0',
  PRIMARY KEY (`order_id`,`coupon_id`),
  KEY `coupon_id` (`coupon_id`),
  KEY `date_created` (`date_created`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `psm_wc_order_product_lookup` (
  `order_item_id` bigint(20) unsigned NOT NULL,
  `order_id` bigint(20) unsigned NOT NULL,
  `product_id` bigint(20) unsigned NOT NULL,
  `variation_id` bigint(20) unsigned NOT NULL,
  `customer_id` bigint(20) unsigned DEFAULT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `product_qty` int(11) NOT NULL,
  `product_net_revenue` double NOT NULL DEFAULT '0',
  `product_gross_revenue` double NOT NULL DEFAULT '0',
  `coupon_amount` double NOT NULL DEFAULT '0',
  `tax_amount` double NOT NULL DEFAULT '0',
  `shipping_amount` double NOT NULL DEFAULT '0',
  `shipping_tax_amount` double NOT NULL DEFAULT '0',
  PRIMARY KEY (`order_item_id`),
  KEY `order_id` (`order_id`),
  KEY `product_id` (`product_id`),
  KEY `customer_id` (`customer_id`),
  KEY `date_created` (`date_created`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `psm_wc_order_stats` (
  `order_id` bigint(20) unsigned NOT NULL,
  `parent_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_created_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `num_items_sold` int(11) NOT NULL DEFAULT '0',
  `total_sales` double NOT NULL DEFAULT '0',
  `tax_total` double NOT NULL DEFAULT '0',
  `shipping_total` double NOT NULL DEFAULT '0',
  `net_total` double NOT NULL DEFAULT '0',
  `returning_customer` tinyint(1) DEFAULT NULL,
  `status` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `customer_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`order_id`),
  KEY `date_created` (`date_created`),
  KEY `customer_id` (`customer_id`),
  KEY `status` (`status`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `psm_wc_order_tax_lookup` (
  `order_id` bigint(20) unsigned NOT NULL,
  `tax_rate_id` bigint(20) unsigned NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `shipping_tax` double NOT NULL DEFAULT '0',
  `order_tax` double NOT NULL DEFAULT '0',
  `total_tax` double NOT NULL DEFAULT '0',
  PRIMARY KEY (`order_id`,`tax_rate_id`),
  KEY `tax_rate_id` (`tax_rate_id`),
  KEY `date_created` (`date_created`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `psm_wc_product_meta_lookup` (
  `product_id` bigint(20) NOT NULL,
  `sku` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT '',
  `virtual` tinyint(1) DEFAULT '0',
  `downloadable` tinyint(1) DEFAULT '0',
  `min_price` decimal(19,4) DEFAULT NULL,
  `max_price` decimal(19,4) DEFAULT NULL,
  `onsale` tinyint(1) DEFAULT '0',
  `stock_quantity` double DEFAULT NULL,
  `stock_status` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT 'instock',
  `rating_count` bigint(20) DEFAULT '0',
  `average_rating` decimal(3,2) DEFAULT '0.00',
  `total_sales` bigint(20) DEFAULT '0',
  `tax_status` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT 'taxable',
  `tax_class` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT '',
  PRIMARY KEY (`product_id`),
  KEY `virtual` (`virtual`),
  KEY `downloadable` (`downloadable`),
  KEY `stock_status` (`stock_status`),
  KEY `stock_quantity` (`stock_quantity`),
  KEY `onsale` (`onsale`),
  KEY `min_max_price` (`min_price`,`max_price`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `psm_wc_reserved_stock` (
  `order_id` bigint(20) NOT NULL,
  `product_id` bigint(20) NOT NULL,
  `stock_quantity` double NOT NULL DEFAULT '0',
  `timestamp` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `expires` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`order_id`,`product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `psm_wc_tax_rate_classes` (
  `tax_rate_class_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `slug` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`tax_rate_class_id`),
  UNIQUE KEY `slug` (`slug`(191))
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `psm_wc_webhooks` (
  `webhook_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `status` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `name` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `user_id` bigint(20) unsigned NOT NULL,
  `delivery_url` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `secret` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `topic` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_created_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `api_version` smallint(4) NOT NULL,
  `failure_count` smallint(10) NOT NULL DEFAULT '0',
  `pending_delivery` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`webhook_id`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `psm_woocommerce_api_keys` (
  `key_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL,
  `description` varchar(200) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `permissions` varchar(10) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `consumer_key` char(64) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `consumer_secret` char(43) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `nonces` longtext COLLATE utf8mb4_unicode_520_ci,
  `truncated_key` char(7) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `last_access` datetime DEFAULT NULL,
  PRIMARY KEY (`key_id`),
  KEY `consumer_key` (`consumer_key`),
  KEY `consumer_secret` (`consumer_secret`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `psm_woocommerce_attribute_taxonomies` (
  `attribute_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `attribute_name` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `attribute_label` varchar(200) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `attribute_type` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `attribute_orderby` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `attribute_public` int(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`attribute_id`),
  KEY `attribute_name` (`attribute_name`(20))
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `psm_woocommerce_downloadable_product_permissions` (
  `permission_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `download_id` varchar(36) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `product_id` bigint(20) unsigned NOT NULL,
  `order_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `order_key` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `user_email` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `downloads_remaining` varchar(9) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `access_granted` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `access_expires` datetime DEFAULT NULL,
  `download_count` bigint(20) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`permission_id`),
  KEY `download_order_key_product` (`product_id`,`order_id`,`order_key`(16),`download_id`),
  KEY `download_order_product` (`download_id`,`order_id`,`product_id`),
  KEY `order_id` (`order_id`),
  KEY `user_order_remaining_expires` (`user_id`,`order_id`,`downloads_remaining`,`access_expires`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `psm_woocommerce_log` (
  `log_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `timestamp` datetime NOT NULL,
  `level` smallint(4) NOT NULL,
  `source` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `message` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `context` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`log_id`),
  KEY `level` (`level`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `psm_woocommerce_order_itemmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_item_id` bigint(20) unsigned NOT NULL,
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `order_item_id` (`order_item_id`),
  KEY `meta_key` (`meta_key`(32))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `psm_woocommerce_order_items` (
  `order_item_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_item_name` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `order_item_type` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `order_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`order_item_id`),
  KEY `order_id` (`order_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `psm_woocommerce_payment_tokenmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `payment_token_id` bigint(20) unsigned NOT NULL,
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `payment_token_id` (`payment_token_id`),
  KEY `meta_key` (`meta_key`(32))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `psm_woocommerce_payment_tokens` (
  `token_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `gateway_id` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `token` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `type` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `is_default` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`token_id`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `psm_woocommerce_sessions` (
  `session_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `session_key` char(32) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `session_value` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `session_expiry` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`session_id`),
  UNIQUE KEY `session_key` (`session_key`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `psm_woocommerce_shipping_zone_locations` (
  `location_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `zone_id` bigint(20) unsigned NOT NULL,
  `location_code` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `location_type` varchar(40) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `location_id` (`location_id`),
  KEY `location_type_code` (`location_type`(10),`location_code`(20))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `psm_woocommerce_shipping_zone_methods` (
  `zone_id` bigint(20) unsigned NOT NULL,
  `instance_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `method_id` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `method_order` bigint(20) unsigned NOT NULL,
  `is_enabled` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`instance_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `psm_woocommerce_shipping_zones` (
  `zone_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `zone_name` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `zone_order` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`zone_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `psm_woocommerce_tax_rate_locations` (
  `location_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `location_code` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `tax_rate_id` bigint(20) unsigned NOT NULL,
  `location_type` varchar(40) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `tax_rate_id` (`tax_rate_id`),
  KEY `location_type_code` (`location_type`(10),`location_code`(20))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `psm_woocommerce_tax_rates` (
  `tax_rate_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `tax_rate_country` varchar(2) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `tax_rate_state` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `tax_rate` varchar(8) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `tax_rate_name` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `tax_rate_priority` bigint(20) unsigned NOT NULL,
  `tax_rate_compound` int(1) NOT NULL DEFAULT '0',
  `tax_rate_shipping` int(1) NOT NULL DEFAULT '1',
  `tax_rate_order` bigint(20) unsigned NOT NULL,
  `tax_rate_class` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`tax_rate_id`),
  KEY `tax_rate_country` (`tax_rate_country`),
  KEY `tax_rate_state` (`tax_rate_state`(2)),
  KEY `tax_rate_class` (`tax_rate_class`(10)),
  KEY `tax_rate_priority` (`tax_rate_priority`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `psm_yoast_indexable` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `permalink` longtext COLLATE utf8mb4_unicode_520_ci,
  `permalink_hash` varchar(40) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `object_id` bigint(20) DEFAULT NULL,
  `object_type` varchar(32) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `object_sub_type` varchar(32) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `author_id` bigint(20) DEFAULT NULL,
  `post_parent` bigint(20) DEFAULT NULL,
  `title` text COLLATE utf8mb4_unicode_520_ci,
  `description` mediumtext COLLATE utf8mb4_unicode_520_ci,
  `breadcrumb_title` text COLLATE utf8mb4_unicode_520_ci,
  `post_status` varchar(20) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `is_public` tinyint(1) DEFAULT NULL,
  `is_protected` tinyint(1) DEFAULT '0',
  `has_public_posts` tinyint(1) DEFAULT NULL,
  `number_of_pages` int(11) unsigned DEFAULT NULL,
  `canonical` longtext COLLATE utf8mb4_unicode_520_ci,
  `primary_focus_keyword` varchar(191) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `primary_focus_keyword_score` int(3) DEFAULT NULL,
  `readability_score` int(3) DEFAULT NULL,
  `is_cornerstone` tinyint(1) DEFAULT '0',
  `is_robots_noindex` tinyint(1) DEFAULT '0',
  `is_robots_nofollow` tinyint(1) DEFAULT '0',
  `is_robots_noarchive` tinyint(1) DEFAULT '0',
  `is_robots_noimageindex` tinyint(1) DEFAULT '0',
  `is_robots_nosnippet` tinyint(1) DEFAULT '0',
  `twitter_title` text COLLATE utf8mb4_unicode_520_ci,
  `twitter_image` longtext COLLATE utf8mb4_unicode_520_ci,
  `twitter_description` longtext COLLATE utf8mb4_unicode_520_ci,
  `twitter_image_id` varchar(191) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `twitter_image_source` text COLLATE utf8mb4_unicode_520_ci,
  `open_graph_title` text COLLATE utf8mb4_unicode_520_ci,
  `open_graph_description` longtext COLLATE utf8mb4_unicode_520_ci,
  `open_graph_image` longtext COLLATE utf8mb4_unicode_520_ci,
  `open_graph_image_id` varchar(191) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `open_graph_image_source` text COLLATE utf8mb4_unicode_520_ci,
  `open_graph_image_meta` mediumtext COLLATE utf8mb4_unicode_520_ci,
  `link_count` int(11) DEFAULT NULL,
  `incoming_link_count` int(11) DEFAULT NULL,
  `prominent_words_version` int(11) unsigned DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `blog_id` bigint(20) NOT NULL DEFAULT '1',
  `language` varchar(32) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `region` varchar(32) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `schema_page_type` varchar(64) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `schema_article_type` varchar(64) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `has_ancestors` tinyint(1) DEFAULT '0',
  `estimated_reading_time_minutes` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `object_type_and_sub_type` (`object_type`,`object_sub_type`),
  KEY `object_id_and_type` (`object_id`,`object_type`),
  KEY `permalink_hash_and_object_type` (`permalink_hash`,`object_type`),
  KEY `subpages` (`post_parent`,`object_type`,`post_status`,`object_id`),
  KEY `prominent_words` (`prominent_words_version`,`object_type`,`object_sub_type`,`post_status`)
) ENGINE=InnoDB AUTO_INCREMENT=285 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `psm_yoast_indexable_hierarchy` (
  `indexable_id` int(11) unsigned NOT NULL,
  `ancestor_id` int(11) unsigned NOT NULL,
  `depth` int(11) unsigned DEFAULT NULL,
  `blog_id` bigint(20) NOT NULL DEFAULT '1',
  PRIMARY KEY (`indexable_id`,`ancestor_id`),
  KEY `indexable_id` (`indexable_id`),
  KEY `ancestor_id` (`ancestor_id`),
  KEY `depth` (`depth`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `psm_yoast_migrations` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `version` varchar(191) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `psm_yoast_migrations_version` (`version`)
) ENGINE=InnoDB AUTO_INCREMENT=22 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `psm_yoast_primary_term` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint(20) DEFAULT NULL,
  `term_id` bigint(20) DEFAULT NULL,
  `taxonomy` varchar(32) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `blog_id` bigint(20) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `post_taxonomy` (`post_id`,`taxonomy`),
  KEY `post_term` (`post_id`,`term_id`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `psm_yoast_seo_links` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `url` varchar(255) DEFAULT NULL,
  `post_id` bigint(20) unsigned DEFAULT NULL,
  `target_post_id` bigint(20) unsigned DEFAULT NULL,
  `type` varchar(8) DEFAULT NULL,
  `indexable_id` int(11) unsigned DEFAULT NULL,
  `target_indexable_id` int(11) unsigned DEFAULT NULL,
  `height` int(11) unsigned DEFAULT NULL,
  `width` int(11) unsigned DEFAULT NULL,
  `size` int(11) unsigned DEFAULT NULL,
  `language` varchar(32) DEFAULT NULL,
  `region` varchar(32) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `link_direction` (`post_id`,`type`),
  KEY `indexable_link_direction` (`indexable_id`,`type`)
) ENGINE=InnoDB AUTO_INCREMENT=3873 DEFAULT CHARSET=utf8;


/* INSERT TABLE DATA: psm_actionscheduler_actions */
INSERT INTO `psm_actionscheduler_actions` VALUES("18", "wc_stripe_remove_order_locks", "complete", "2021-09-01 19:03:53", "2021-09-01 21:03:53", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1630523033;s:18:\"\0*\0first_timestamp\";i:1625356800;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1630523033;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "0", "1", "2021-09-21 15:37:43", "2021-09-21 17:37:43", "0", NULL);
INSERT INTO `psm_actionscheduler_actions` VALUES("19", "wc_stripe_remove_order_locks", "complete", "2021-09-22 15:37:43", "2021-09-22 17:37:43", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1632325063;s:18:\"\0*\0first_timestamp\";i:1625356800;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1632325063;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "0", "1", "2021-09-22 15:38:13", "2021-09-22 17:38:13", "0", NULL);
INSERT INTO `psm_actionscheduler_actions` VALUES("20", "wc_stripe_remove_order_locks", "complete", "2021-09-23 15:38:13", "2021-09-23 17:38:13", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1632411493;s:18:\"\0*\0first_timestamp\";i:1625356800;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1632411493;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "0", "1", "2021-09-24 14:53:02", "2021-09-24 16:53:02", "0", NULL);
INSERT INTO `psm_actionscheduler_actions` VALUES("21", "wc_stripe_remove_order_locks", "complete", "2021-09-25 14:53:02", "2021-09-25 16:53:02", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1632581582;s:18:\"\0*\0first_timestamp\";i:1625356800;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1632581582;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "0", "1", "2021-09-27 11:52:11", "2021-09-27 13:52:11", "0", NULL);
INSERT INTO `psm_actionscheduler_actions` VALUES("22", "wc_stripe_remove_order_locks", "complete", "2021-09-28 11:52:11", "2021-09-28 13:52:11", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1632829931;s:18:\"\0*\0first_timestamp\";i:1625356800;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1632829931;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "0", "1", "2021-09-30 16:09:17", "2021-09-30 18:09:17", "0", NULL);
INSERT INTO `psm_actionscheduler_actions` VALUES("23", "wc_stripe_remove_order_locks", "complete", "2021-10-01 16:09:17", "2021-10-01 18:09:17", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1633104557;s:18:\"\0*\0first_timestamp\";i:1625356800;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1633104557;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "0", "1", "2021-10-03 16:50:13", "2021-10-03 18:50:13", "0", NULL);
INSERT INTO `psm_actionscheduler_actions` VALUES("24", "wc_stripe_remove_order_locks", "pending", "2021-10-04 16:50:13", "2021-10-04 18:50:13", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1633366213;s:18:\"\0*\0first_timestamp\";i:1625356800;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1633366213;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "0", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL);

/* INSERT TABLE DATA: psm_actionscheduler_groups */
INSERT INTO `psm_actionscheduler_groups` VALUES("1", "action-scheduler-migration");

/* INSERT TABLE DATA: psm_actionscheduler_logs */
INSERT INTO `psm_actionscheduler_logs` VALUES("52", "18", "action créée", "2021-08-31 19:03:53", "2021-08-31 21:03:53");
INSERT INTO `psm_actionscheduler_logs` VALUES("53", "18", "action lancée via WP Cron", "2021-09-21 15:37:43", "2021-09-21 17:37:43");
INSERT INTO `psm_actionscheduler_logs` VALUES("54", "18", "action terminée via WP Cron", "2021-09-21 15:37:43", "2021-09-21 17:37:43");
INSERT INTO `psm_actionscheduler_logs` VALUES("55", "19", "action créée", "2021-09-21 15:37:43", "2021-09-21 17:37:43");
INSERT INTO `psm_actionscheduler_logs` VALUES("56", "19", "action lancée via WP Cron", "2021-09-22 15:38:13", "2021-09-22 17:38:13");
INSERT INTO `psm_actionscheduler_logs` VALUES("57", "19", "action terminée via WP Cron", "2021-09-22 15:38:13", "2021-09-22 17:38:13");
INSERT INTO `psm_actionscheduler_logs` VALUES("58", "20", "action créée", "2021-09-22 15:38:13", "2021-09-22 17:38:13");
INSERT INTO `psm_actionscheduler_logs` VALUES("59", "20", "action lancée via WP Cron", "2021-09-24 14:53:02", "2021-09-24 16:53:02");
INSERT INTO `psm_actionscheduler_logs` VALUES("60", "20", "action terminée via WP Cron", "2021-09-24 14:53:02", "2021-09-24 16:53:02");
INSERT INTO `psm_actionscheduler_logs` VALUES("61", "21", "action créée", "2021-09-24 14:53:02", "2021-09-24 16:53:02");
INSERT INTO `psm_actionscheduler_logs` VALUES("62", "21", "action lancée via WP Cron", "2021-09-27 11:52:11", "2021-09-27 13:52:11");
INSERT INTO `psm_actionscheduler_logs` VALUES("63", "21", "action terminée via WP Cron", "2021-09-27 11:52:11", "2021-09-27 13:52:11");
INSERT INTO `psm_actionscheduler_logs` VALUES("64", "22", "action créée", "2021-09-27 11:52:11", "2021-09-27 13:52:11");
INSERT INTO `psm_actionscheduler_logs` VALUES("65", "22", "action lancée via WP Cron", "2021-09-30 16:09:17", "2021-09-30 18:09:17");
INSERT INTO `psm_actionscheduler_logs` VALUES("66", "22", "action terminée via WP Cron", "2021-09-30 16:09:17", "2021-09-30 18:09:17");
INSERT INTO `psm_actionscheduler_logs` VALUES("67", "23", "action créée", "2021-09-30 16:09:17", "2021-09-30 18:09:17");
INSERT INTO `psm_actionscheduler_logs` VALUES("68", "23", "action lancée via WP Cron", "2021-10-03 16:50:13", "2021-10-03 18:50:13");
INSERT INTO `psm_actionscheduler_logs` VALUES("69", "23", "action terminée via WP Cron", "2021-10-03 16:50:13", "2021-10-03 18:50:13");
INSERT INTO `psm_actionscheduler_logs` VALUES("70", "24", "action créée", "2021-10-03 16:50:13", "2021-10-03 18:50:13");

/* INSERT TABLE DATA: psm_booking */
INSERT INTO `psm_booking` VALUES("1", "0", "", "1", "", "2021-04-29 00:00:00", "2021-04-27 16:30:21", "text^name1^Jony~text^secondname1^Smith~text^email1^example-free@wpbookingcalendar.com~text^phone1^458-77-77~textarea^details1^Reserve a room with sea view", "1");
INSERT INTO `psm_booking` VALUES("2", "0", "", "0", "", "2021-10-18 00:00:00", "2021-10-03 20:06:50", "text^name1^Nathanael~text^secondname1^otsaghe de souza~email^email1^otsaghen@gmail.com~text^phone1^0650620402~textarea^details1^4 personnes", "1");

/* INSERT TABLE DATA: psm_bookingdates */
INSERT INTO `psm_bookingdates` VALUES("1", "1", "2021-04-29 00:00:00", "0");
INSERT INTO `psm_bookingdates` VALUES("2", "1", "2021-04-30 00:00:00", "0");
INSERT INTO `psm_bookingdates` VALUES("3", "1", "2021-05-01 00:00:00", "0");
INSERT INTO `psm_bookingdates` VALUES("4", "2", "2021-10-18 00:00:00", "1");

/* INSERT TABLE DATA: psm_comments */
INSERT INTO `psm_comments` VALUES("1", "1", "Un commentateur WordPress", "wapuu@wordpress.example", "https://wordpress.org/", "", "2021-03-08 09:35:01", "2021-03-08 08:35:01", "Bonjour, ceci est un commentaire.\nPour débuter avec la modération, la modification et la suppression de commentaires, veuillez visiter l’écran des Commentaires dans le Tableau de bord.\nLes avatars des personnes qui commentent arrivent depuis <a href=\"https://gravatar.com\">Gravatar</a>.", "0", "post-trashed", "", "comment", "0", "0");

/* INSERT TABLE DATA: psm_cpappbk_forms */
INSERT INTO `psm_cpappbk_forms` VALUES("1", "Form 1", "[[{\"form_identifier\":\"\",\"name\":\"fieldname1\",\"shortlabel\":\"\",\"index\":0,\"ftype\":\"fapp\",\"userhelp\":\"\",\"userhelpTooltip\":false,\"csslayout\":\"\",\"title\":\"Appointment\",\"services\":[{\"name\":\"Service 1\",\"price\":1,\"duration\":60}],\"openhours\":[{\"name\":\"Default\",\"openhours\":[{\"type\":\"all\",\"d\":\"\",\"h1\":8,\"m1\":0,\"h2\":17,\"m2\":0}]}],\"allOH\":[{\"name\":\"Default\",\"openhours\":[{\"type\":\"all\",\"d\":\"\",\"h1\":8,\"m1\":0,\"h2\":17,\"m2\":0}]}],\"dateFormat\":\"mm/dd/yy\",\"showDropdown\":false,\"dropdownRange\":\"-10:+10\",\"working_dates\":[true,true,true,true,true,true,true],\"numberOfMonths\":1,\"firstDay\":0,\"minDate\":\"0\",\"maxDate\":\"\",\"defaultDate\":\"\",\"invalidDates\":\"\",\"required\":true,\"fBuild\":{}},{\"form_identifier\":\"\",\"name\":\"email\",\"shortlabel\":\"\",\"index\":1,\"ftype\":\"femail\",\"userhelp\":\"\",\"userhelpTooltip\":false,\"csslayout\":\"\",\"title\":\"Email\",\"predefined\":\"\",\"predefinedClick\":false,\"required\":true,\"size\":\"medium\",\"equalTo\":\"\",\"fBuild\":{}}],[{\"title\":\"\",\"description\":\"\",\"formlayout\":\"top_aligned\",\"formtemplate\":\"\",\"evalequations\":1,\"autocomplete\":1}]]", "", "mm/dd/yy", "Booking", "Pay later", "", "", "pierriesaintmaximechateau@gmail.com", "pierriesaintmaximechateau@gmail.com", "Notification to administrator: Booking request received...", "true", "http://localhost:8888/psm", "The following booking request has been received:\n\n<%INFO%>\n\n", "text", "", "", "true", "email", "Confirmation: Your booking has been received...", "Your appointment is received. We look forward to seeing you then.\n\nThis is a copy of the data sent:\n\n<%INFO%>\n\nBest Regards.", "text", "", "Please select a max of  {0} appointments per customer.", "This field is required.", "Please enter a valid email address.", "Please enter a valid date with this format(mm/dd/yyyy)", "Please enter a valid date with this format(dd/mm/yyyy)", "Please enter a valid number.", "Please enter only digits.", "Please enter a value less than or equal to {0}.", "Please enter a value greater than or equal to {0}.", "Page {0} of {0}", "Submit", "Previous", "Next", "Quantity", "Cancel", "Cost", "Selected time is no longer available. Please select a different time.", NULL, "", "", "no", "1", "0", "", "Submissions report...", "text", "Attached you will find the data from the form submissions.", "true", "180", "60", "5", "font1", "25", "35", "200", "4", "ffffff", "000000", "Please enter a valid captcha code.");

/* INSERT TABLE DATA: psm_duplicator_packages */
INSERT INTO `psm_duplicator_packages` VALUES("1", "20211004_pierriesaintmaxime", "3ab34c5515b1c0816270_20211004143712", "22", "2021-10-04 14:40:29", "unknown", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2021-10-04 14:37:12\";s:7:\"Version\";s:5:\"1.4.3\";s:9:\"VersionWP\";s:5:\"5.8.1\";s:9:\"VersionDB\";s:6:\"5.7.32\";s:10:\"VersionPHP\";s:6:\"7.4.12\";s:9:\"VersionOS\";s:6:\"Darwin\";s:2:\"ID\";i:1;s:4:\"Name\";s:27:\"20211004_pierriesaintmaxime\";s:4:\"Hash\";s:35:\"3ab34c5515b1c0816270_20211004143712\";s:8:\"NameHash\";s:63:\"20211004_pierriesaintmaxime_3ab34c5515b1c0816270_20211004143712\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";s:73:\"20211004_pierriesaintmaxime_3ab34c5515b1c0816270_20211004143712_scan.json\";s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";s:4:\"21.9\";s:6:\"WPUser\";s:7:\"unknown\";s:7:\"Archive\";O:11:\"DUP_Archive\":21:{s:10:\"FilterDirs\";s:0:\"\";s:11:\"FilterFiles\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";s:75:\"20211004_pierriesaintmaxime_3ab34c5515b1c0816270_20211004143712_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:29:\"/Applications/MAMP/htdocs/psm\";s:4:\"Size\";i:0;s:4:\"Dirs\";a:0:{}s:5:\"Files\";a:0:{}s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":6:{s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":7:{s:4:\"Size\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":3:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:14:\"RecursiveLinks\";a:0:{}s:10:\"file_count\";i:-1;s:10:\"\0*\0Package\";O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2021-10-04 14:37:12\";s:7:\"Version\";s:5:\"1.4.3\";s:9:\"VersionWP\";s:5:\"5.8.1\";s:9:\"VersionDB\";s:6:\"5.7.32\";s:10:\"VersionPHP\";s:6:\"7.4.12\";s:9:\"VersionOS\";s:6:\"Darwin\";s:2:\"ID\";N;s:4:\"Name\";s:27:\"20211004_pierriesaintmaxime\";s:4:\"Hash\";s:35:\"3ab34c5515b1c0816270_20211004143712\";s:8:\"NameHash\";s:63:\"20211004_pierriesaintmaxime_3ab34c5515b1c0816270_20211004143712\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";N;s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";r:21;s:9:\"Installer\";O:13:\"DUP_Installer\":13:{s:4:\"File\";s:77:\"20211004_pierriesaintmaxime_3ab34c5515b1c0816270_20211004143712_installer.php\";s:4:\"Size\";i:0;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:13:\"OptsDBCharset\";s:0:\"\";s:15:\"OptsDBCollation\";s:0:\"\";s:12:\"OptsSecureOn\";i:0;s:14:\"OptsSecurePass\";s:0:\"\";s:13:\"numFilesAdded\";i:0;s:12:\"numDirsAdded\";i:0;s:10:\"\0*\0Package\";r:63;}s:8:\"Database\";O:12:\"DUP_Database\":15:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";N;s:4:\"File\";s:76:\"20211004_pierriesaintmaxime_3ab34c5515b1c0816270_20211004143712_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:28:\"MySQL Community Server (GPL)\";s:4:\"info\";O:16:\"DUP_DatabaseInfo\":16:{s:9:\"buildMode\";N;s:13:\"collationList\";a:0:{}s:17:\"isTablesUpperCase\";N;s:15:\"isNameUpperCase\";N;s:4:\"name\";N;s:15:\"tablesBaseCount\";N;s:16:\"tablesFinalCount\";N;s:14:\"tablesRowCount\";N;s:16:\"tablesSizeOnDisk\";N;s:18:\"varLowerCaseTables\";i:0;s:7:\"version\";N;s:14:\"versionComment\";N;s:18:\"tableWiseRowCounts\";a:11:{s:27:\"psm_actionscheduler_actions\";s:1:\"7\";s:26:\"psm_actionscheduler_claims\";s:1:\"0\";s:26:\"psm_actionscheduler_groups\";s:1:\"1\";s:24:\"psm_actionscheduler_logs\";s:2:\"19\";s:11:\"psm_booking\";s:1:\"2\";s:16:\"psm_bookingdates\";s:1:\"4\";s:28:\"psm_ce4wp_abandoned_checkout\";s:1:\"0\";s:18:\"psm_ce4wp_contacts\";s:1:\"0\";s:15:\"psm_commentmeta\";s:1:\"0\";s:12:\"psm_comments\";s:1:\"1\";s:17:\"psm_cpappbk_forms\";s:1:\"1\";}s:11:\"triggerList\";a:0:{}s:33:\"\0DUP_DatabaseInfo\0intFieldsStruct\";a:0:{}s:42:\"\0DUP_DatabaseInfo\0indexProcessedSchemaSize\";a:0:{}}s:10:\"\0*\0Package\";r:1;s:24:\"\0DUP_Database\0tempDbPath\";s:138:\"/Applications/MAMP/htdocs/psm/wp-content/backups-dup-lite/tmp/20211004_pierriesaintmaxime_3ab34c5515b1c0816270_20211004143712_database.sql\";s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;s:19:\"sameNameTableExists\";b:0;}s:13:\"BuildProgress\";O:18:\"DUP_Build_Progress\":12:{s:17:\"thread_start_time\";N;s:11:\"initialized\";b:0;s:15:\"installer_built\";b:0;s:15:\"archive_started\";b:0;s:20:\"archive_has_database\";b:0;s:13:\"archive_built\";b:0;s:21:\"database_script_built\";b:0;s:6:\"failed\";b:0;s:7:\"retries\";i:0;s:14:\"build_failures\";a:0:{}s:19:\"validation_failures\";a:0:{}s:27:\"\0DUP_Build_Progress\0package\";r:63;}}s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:5:{i:0;s:38:\"/Applications/MAMP/htdocs/psm/wp-admin\";i:1;s:48:\"/Applications/MAMP/htdocs/psm/wp-content/uploads\";i:2;s:50:\"/Applications/MAMP/htdocs/psm/wp-content/languages\";i:3;s:47:\"/Applications/MAMP/htdocs/psm/wp-content/themes\";i:4;s:41:\"/Applications/MAMP/htdocs/psm/wp-includes\";}s:29:\"\0DUP_Archive\0wpCoreExactPaths\";a:2:{i:0;s:29:\"/Applications/MAMP/htdocs/psm\";i:1;s:40:\"/Applications/MAMP/htdocs/psm/wp-content\";}}s:9:\"Installer\";r:84;s:8:\"Database\";r:98;s:13:\"BuildProgress\";r:141;}");

/* INSERT TABLE DATA: psm_imagify_folders */
INSERT INTO `psm_imagify_folders` VALUES("1", "{{THEMES}}/jorden/", "1");
INSERT INTO `psm_imagify_folders` VALUES("2", "{{THEMES}}/kava/", "1");

/* INSERT TABLE DATA: psm_options */
INSERT INTO `psm_options` VALUES("1", "siteurl", "http://localhost:8888/psm", "yes");
INSERT INTO `psm_options` VALUES("2", "home", "http://localhost:8888/psm", "yes");
INSERT INTO `psm_options` VALUES("3", "blogname", "Pierrie Saint Maxime", "yes");
INSERT INTO `psm_options` VALUES("4", "blogdescription", "Domaine viticole Sauternes-Barsac", "yes");
INSERT INTO `psm_options` VALUES("5", "users_can_register", "0", "yes");
INSERT INTO `psm_options` VALUES("6", "admin_email", "pierriesaintmaximechateau@gmail.com", "yes");
INSERT INTO `psm_options` VALUES("7", "start_of_week", "1", "yes");
INSERT INTO `psm_options` VALUES("8", "use_balanceTags", "0", "yes");
INSERT INTO `psm_options` VALUES("9", "use_smilies", "1", "yes");
INSERT INTO `psm_options` VALUES("10", "require_name_email", "1", "yes");
INSERT INTO `psm_options` VALUES("11", "comments_notify", "1", "yes");
INSERT INTO `psm_options` VALUES("12", "posts_per_rss", "12", "yes");
INSERT INTO `psm_options` VALUES("13", "rss_use_excerpt", "0", "yes");
INSERT INTO `psm_options` VALUES("14", "mailserver_url", "mail.example.com", "yes");
INSERT INTO `psm_options` VALUES("15", "mailserver_login", "login@example.com", "yes");
INSERT INTO `psm_options` VALUES("16", "mailserver_pass", "password", "yes");
INSERT INTO `psm_options` VALUES("17", "mailserver_port", "110", "yes");
INSERT INTO `psm_options` VALUES("18", "default_category", "1", "yes");
INSERT INTO `psm_options` VALUES("19", "default_comment_status", "", "yes");
INSERT INTO `psm_options` VALUES("20", "default_ping_status", "open", "yes");
INSERT INTO `psm_options` VALUES("21", "default_pingback_flag", "", "yes");
INSERT INTO `psm_options` VALUES("22", "posts_per_page", "12", "yes");
INSERT INTO `psm_options` VALUES("23", "date_format", "j F Y", "yes");
INSERT INTO `psm_options` VALUES("24", "time_format", "G\\hi", "yes");
INSERT INTO `psm_options` VALUES("25", "links_updated_date_format", "d F Y G\\hi", "yes");
INSERT INTO `psm_options` VALUES("26", "comment_moderation", "1", "yes");
INSERT INTO `psm_options` VALUES("27", "moderation_notify", "1", "yes");
INSERT INTO `psm_options` VALUES("28", "permalink_structure", "/%postname%/", "yes");
INSERT INTO `psm_options` VALUES("30", "hack_file", "0", "yes");
INSERT INTO `psm_options` VALUES("31", "blog_charset", "UTF-8", "yes");
INSERT INTO `psm_options` VALUES("32", "moderation_keys", "", "no");
INSERT INTO `psm_options` VALUES("33", "active_plugins", "a:25:{i:0;s:21:\"polylang/polylang.php\";i:1;s:30:\"advanced-custom-fields/acf.php\";i:2;s:19:\"akismet/akismet.php\";i:3;s:47:\"appointment-hour-booking/app-booking-plugin.php\";i:4;s:27:\"autoptimize/autoptimize.php\";i:5;s:25:\"booking/wpdev-booking.php\";i:6;s:36:\"contact-form-7/wp-contact-form-7.php\";i:7;s:58:\"creative-mail-by-constant-contact/creative-mail-plugin.php\";i:8;s:25:\"duplicator/duplicator.php\";i:9;s:31:\"elementor-pro/elementor-pro.php\";i:10;s:23:\"elementor/elementor.php\";i:11;s:53:\"facebook-for-woocommerce/facebook-for-woocommerce.php\";i:12;s:51:\"header-footer-elementor/header-footer-elementor.php\";i:13;s:9:\"hello.php\";i:14;s:19:\"imagify/imagify.php\";i:15;s:19:\"jetpack/jetpack.php\";i:16;s:59:\"kliken-marketing-for-google/kliken-marketing-for-google.php\";i:17;s:51:\"mailchimp-for-woocommerce/mailchimp-woocommerce.php\";i:18;s:38:\"woo-stripe-payment/stripe-payments.php\";i:19;s:41:\"woocommerce-colors/woocommerce-colors.php\";i:20;s:57:\"woocommerce-gateway-stripe/woocommerce-gateway-stripe.php\";i:21;s:59:\"woocommerce-paypal-payments/woocommerce-paypal-payments.php\";i:22;s:45:\"woocommerce-services/woocommerce-services.php\";i:23;s:27:\"woocommerce/woocommerce.php\";i:24;s:24:\"wordpress-seo/wp-seo.php\";}", "yes");
INSERT INTO `psm_options` VALUES("34", "category_base", "", "yes");
INSERT INTO `psm_options` VALUES("35", "ping_sites", "http://rpc.pingomatic.com/", "yes");
INSERT INTO `psm_options` VALUES("36", "comment_max_links", "2", "yes");
INSERT INTO `psm_options` VALUES("37", "gmt_offset", "0", "yes");
INSERT INTO `psm_options` VALUES("38", "default_email_category", "1", "yes");
INSERT INTO `psm_options` VALUES("39", "recently_edited", "a:2:{i:0;s:64:\"/Applications/MAMP/htdocs/psm/wp-content/themes/jorden/style.css\";i:2;s:0:\"\";}", "no");
INSERT INTO `psm_options` VALUES("40", "template", "kava", "yes");
INSERT INTO `psm_options` VALUES("41", "stylesheet", "jorden", "yes");
INSERT INTO `psm_options` VALUES("42", "comment_registration", "1", "yes");
INSERT INTO `psm_options` VALUES("43", "html_type", "text/html", "yes");
INSERT INTO `psm_options` VALUES("44", "use_trackback", "0", "yes");
INSERT INTO `psm_options` VALUES("45", "default_role", "subscriber", "yes");
INSERT INTO `psm_options` VALUES("46", "db_version", "49752", "yes");
INSERT INTO `psm_options` VALUES("47", "uploads_use_yearmonth_folders", "1", "yes");
INSERT INTO `psm_options` VALUES("48", "upload_path", "", "yes");
INSERT INTO `psm_options` VALUES("49", "blog_public", "0", "yes");
INSERT INTO `psm_options` VALUES("50", "default_link_category", "2", "yes");
INSERT INTO `psm_options` VALUES("51", "show_on_front", "page", "yes");
INSERT INTO `psm_options` VALUES("52", "tag_base", "", "yes");
INSERT INTO `psm_options` VALUES("53", "show_avatars", "", "yes");
INSERT INTO `psm_options` VALUES("54", "avatar_rating", "G", "yes");
INSERT INTO `psm_options` VALUES("55", "upload_url_path", "", "yes");
INSERT INTO `psm_options` VALUES("56", "thumbnail_size_w", "280", "yes");
INSERT INTO `psm_options` VALUES("57", "thumbnail_size_h", "280", "yes");
INSERT INTO `psm_options` VALUES("58", "thumbnail_crop", "1", "yes");
INSERT INTO `psm_options` VALUES("59", "medium_size_w", "800", "yes");
INSERT INTO `psm_options` VALUES("60", "medium_size_h", "600", "yes");
INSERT INTO `psm_options` VALUES("61", "avatar_default", "mystery", "yes");
INSERT INTO `psm_options` VALUES("62", "large_size_w", "1280", "yes");
INSERT INTO `psm_options` VALUES("63", "large_size_h", "1024", "yes");
INSERT INTO `psm_options` VALUES("64", "image_default_link_type", "", "yes");
INSERT INTO `psm_options` VALUES("65", "image_default_size", "", "yes");
INSERT INTO `psm_options` VALUES("66", "image_default_align", "", "yes");
INSERT INTO `psm_options` VALUES("67", "close_comments_for_old_posts", "", "yes");
INSERT INTO `psm_options` VALUES("68", "close_comments_days_old", "14", "yes");
INSERT INTO `psm_options` VALUES("69", "thread_comments", "1", "yes");
INSERT INTO `psm_options` VALUES("70", "thread_comments_depth", "5", "yes");
INSERT INTO `psm_options` VALUES("71", "page_comments", "", "yes");
INSERT INTO `psm_options` VALUES("72", "comments_per_page", "50", "yes");
INSERT INTO `psm_options` VALUES("73", "default_comments_page", "newest", "yes");
INSERT INTO `psm_options` VALUES("74", "comment_order", "asc", "yes");
INSERT INTO `psm_options` VALUES("75", "sticky_posts", "a:0:{}", "yes");
INSERT INTO `psm_options` VALUES("76", "widget_categories", "a:2:{i:2;a:4:{s:5:\"title\";s:0:\"\";s:5:\"count\";i:0;s:12:\"hierarchical\";i:0;s:8:\"dropdown\";i:0;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `psm_options` VALUES("77", "widget_text", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `psm_options` VALUES("78", "widget_rss", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `psm_options` VALUES("79", "uninstall_plugins", "a:3:{s:45:\"woocommerce-services/woocommerce-services.php\";a:2:{i:0;s:17:\"WC_Connect_Loader\";i:1;s:16:\"plugin_uninstall\";}s:23:\"elementor/elementor.php\";a:2:{i:0;s:21:\"Elementor\\Maintenance\";i:1;s:9:\"uninstall\";}s:27:\"autoptimize/autoptimize.php\";s:29:\"autoptimizeMain::on_uninstall\";}", "no");
INSERT INTO `psm_options` VALUES("80", "timezone_string", "Europe/Paris", "yes");
INSERT INTO `psm_options` VALUES("81", "page_for_posts", "0", "yes");
INSERT INTO `psm_options` VALUES("82", "page_on_front", "88", "yes");
INSERT INTO `psm_options` VALUES("83", "default_post_format", "0", "yes");
INSERT INTO `psm_options` VALUES("84", "link_manager_enabled", "0", "yes");
INSERT INTO `psm_options` VALUES("85", "finished_splitting_shared_terms", "1", "yes");
INSERT INTO `psm_options` VALUES("86", "site_icon", "0", "yes");
INSERT INTO `psm_options` VALUES("87", "medium_large_size_w", "768", "yes");
INSERT INTO `psm_options` VALUES("88", "medium_large_size_h", "0", "yes");
INSERT INTO `psm_options` VALUES("89", "wp_page_for_privacy_policy", "3", "yes");
INSERT INTO `psm_options` VALUES("90", "show_comments_cookies_opt_in", "1", "yes");
INSERT INTO `psm_options` VALUES("91", "admin_email_lifespan", "1647790840", "yes");
INSERT INTO `psm_options` VALUES("92", "disallowed_keys", "", "no");
INSERT INTO `psm_options` VALUES("93", "comment_previously_approved", "1", "yes");
INSERT INTO `psm_options` VALUES("94", "auto_plugin_theme_update_emails", "a:0:{}", "no");
INSERT INTO `psm_options` VALUES("95", "auto_update_core_dev", "enabled", "yes");
INSERT INTO `psm_options` VALUES("96", "auto_update_core_minor", "enabled", "yes");
INSERT INTO `psm_options` VALUES("97", "auto_update_core_major", "enabled", "yes");
INSERT INTO `psm_options` VALUES("98", "initial_db_version", "49752", "yes");
INSERT INTO `psm_options` VALUES("99", "psm_user_roles", "a:9:{s:13:\"administrator\";a:2:{s:4:\"name\";s:13:\"Administrator\";s:12:\"capabilities\";a:115:{s:13:\"switch_themes\";b:1;s:11:\"edit_themes\";b:1;s:16:\"activate_plugins\";b:1;s:12:\"edit_plugins\";b:1;s:10:\"edit_users\";b:1;s:10:\"edit_files\";b:1;s:14:\"manage_options\";b:1;s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:6:\"import\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:8:\"level_10\";b:1;s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:12:\"delete_users\";b:1;s:12:\"create_users\";b:1;s:17:\"unfiltered_upload\";b:1;s:14:\"edit_dashboard\";b:1;s:14:\"update_plugins\";b:1;s:14:\"delete_plugins\";b:1;s:15:\"install_plugins\";b:1;s:13:\"update_themes\";b:1;s:14:\"install_themes\";b:1;s:11:\"update_core\";b:1;s:10:\"list_users\";b:1;s:12:\"remove_users\";b:1;s:13:\"promote_users\";b:1;s:18:\"edit_theme_options\";b:1;s:13:\"delete_themes\";b:1;s:6:\"export\";b:1;s:18:\"manage_woocommerce\";b:1;s:24:\"view_woocommerce_reports\";b:1;s:12:\"edit_product\";b:1;s:12:\"read_product\";b:1;s:14:\"delete_product\";b:1;s:13:\"edit_products\";b:1;s:20:\"edit_others_products\";b:1;s:16:\"publish_products\";b:1;s:21:\"read_private_products\";b:1;s:15:\"delete_products\";b:1;s:23:\"delete_private_products\";b:1;s:25:\"delete_published_products\";b:1;s:22:\"delete_others_products\";b:1;s:21:\"edit_private_products\";b:1;s:23:\"edit_published_products\";b:1;s:20:\"manage_product_terms\";b:1;s:18:\"edit_product_terms\";b:1;s:20:\"delete_product_terms\";b:1;s:20:\"assign_product_terms\";b:1;s:15:\"edit_shop_order\";b:1;s:15:\"read_shop_order\";b:1;s:17:\"delete_shop_order\";b:1;s:16:\"edit_shop_orders\";b:1;s:23:\"edit_others_shop_orders\";b:1;s:19:\"publish_shop_orders\";b:1;s:24:\"read_private_shop_orders\";b:1;s:18:\"delete_shop_orders\";b:1;s:26:\"delete_private_shop_orders\";b:1;s:28:\"delete_published_shop_orders\";b:1;s:25:\"delete_others_shop_orders\";b:1;s:24:\"edit_private_shop_orders\";b:1;s:26:\"edit_published_shop_orders\";b:1;s:23:\"manage_shop_order_terms\";b:1;s:21:\"edit_shop_order_terms\";b:1;s:23:\"delete_shop_order_terms\";b:1;s:23:\"assign_shop_order_terms\";b:1;s:16:\"edit_shop_coupon\";b:1;s:16:\"read_shop_coupon\";b:1;s:18:\"delete_shop_coupon\";b:1;s:17:\"edit_shop_coupons\";b:1;s:24:\"edit_others_shop_coupons\";b:1;s:20:\"publish_shop_coupons\";b:1;s:25:\"read_private_shop_coupons\";b:1;s:19:\"delete_shop_coupons\";b:1;s:27:\"delete_private_shop_coupons\";b:1;s:29:\"delete_published_shop_coupons\";b:1;s:26:\"delete_others_shop_coupons\";b:1;s:25:\"edit_private_shop_coupons\";b:1;s:27:\"edit_published_shop_coupons\";b:1;s:24:\"manage_shop_coupon_terms\";b:1;s:22:\"edit_shop_coupon_terms\";b:1;s:24:\"delete_shop_coupon_terms\";b:1;s:24:\"assign_shop_coupon_terms\";b:1;s:20:\"wpseo_manage_options\";b:1;}}s:6:\"editor\";a:2:{s:4:\"name\";s:6:\"Editor\";s:12:\"capabilities\";a:35:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:15:\"wpseo_bulk_edit\";b:1;}}s:6:\"author\";a:2:{s:4:\"name\";s:6:\"Author\";s:12:\"capabilities\";a:10:{s:12:\"upload_files\";b:1;s:10:\"edit_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:22:\"delete_published_posts\";b:1;}}s:11:\"contributor\";a:2:{s:4:\"name\";s:11:\"Contributor\";s:12:\"capabilities\";a:5:{s:10:\"edit_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;}}s:10:\"subscriber\";a:2:{s:4:\"name\";s:10:\"Subscriber\";s:12:\"capabilities\";a:2:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;}}s:8:\"customer\";a:2:{s:4:\"name\";s:8:\"Customer\";s:12:\"capabilities\";a:1:{s:4:\"read\";b:1;}}s:12:\"shop_manager\";a:2:{s:4:\"name\";s:12:\"Shop manager\";s:12:\"capabilities\";a:92:{s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:4:\"read\";b:1;s:18:\"read_private_pages\";b:1;s:18:\"read_private_posts\";b:1;s:10:\"edit_posts\";b:1;s:10:\"edit_pages\";b:1;s:20:\"edit_published_posts\";b:1;s:20:\"edit_published_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"edit_private_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:17:\"edit_others_pages\";b:1;s:13:\"publish_posts\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_posts\";b:1;s:12:\"delete_pages\";b:1;s:20:\"delete_private_pages\";b:1;s:20:\"delete_private_posts\";b:1;s:22:\"delete_published_pages\";b:1;s:22:\"delete_published_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:19:\"delete_others_pages\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:17:\"moderate_comments\";b:1;s:12:\"upload_files\";b:1;s:6:\"export\";b:1;s:6:\"import\";b:1;s:10:\"list_users\";b:1;s:18:\"edit_theme_options\";b:1;s:18:\"manage_woocommerce\";b:1;s:24:\"view_woocommerce_reports\";b:1;s:12:\"edit_product\";b:1;s:12:\"read_product\";b:1;s:14:\"delete_product\";b:1;s:13:\"edit_products\";b:1;s:20:\"edit_others_products\";b:1;s:16:\"publish_products\";b:1;s:21:\"read_private_products\";b:1;s:15:\"delete_products\";b:1;s:23:\"delete_private_products\";b:1;s:25:\"delete_published_products\";b:1;s:22:\"delete_others_products\";b:1;s:21:\"edit_private_products\";b:1;s:23:\"edit_published_products\";b:1;s:20:\"manage_product_terms\";b:1;s:18:\"edit_product_terms\";b:1;s:20:\"delete_product_terms\";b:1;s:20:\"assign_product_terms\";b:1;s:15:\"edit_shop_order\";b:1;s:15:\"read_shop_order\";b:1;s:17:\"delete_shop_order\";b:1;s:16:\"edit_shop_orders\";b:1;s:23:\"edit_others_shop_orders\";b:1;s:19:\"publish_shop_orders\";b:1;s:24:\"read_private_shop_orders\";b:1;s:18:\"delete_shop_orders\";b:1;s:26:\"delete_private_shop_orders\";b:1;s:28:\"delete_published_shop_orders\";b:1;s:25:\"delete_others_shop_orders\";b:1;s:24:\"edit_private_shop_orders\";b:1;s:26:\"edit_published_shop_orders\";b:1;s:23:\"manage_shop_order_terms\";b:1;s:21:\"edit_shop_order_terms\";b:1;s:23:\"delete_shop_order_terms\";b:1;s:23:\"assign_shop_order_terms\";b:1;s:16:\"edit_shop_coupon\";b:1;s:16:\"read_shop_coupon\";b:1;s:18:\"delete_shop_coupon\";b:1;s:17:\"edit_shop_coupons\";b:1;s:24:\"edit_others_shop_coupons\";b:1;s:20:\"publish_shop_coupons\";b:1;s:25:\"read_private_shop_coupons\";b:1;s:19:\"delete_shop_coupons\";b:1;s:27:\"delete_private_shop_coupons\";b:1;s:29:\"delete_published_shop_coupons\";b:1;s:26:\"delete_others_shop_coupons\";b:1;s:25:\"edit_private_shop_coupons\";b:1;s:27:\"edit_published_shop_coupons\";b:1;s:24:\"manage_shop_coupon_terms\";b:1;s:22:\"edit_shop_coupon_terms\";b:1;s:24:\"delete_shop_coupon_terms\";b:1;s:24:\"assign_shop_coupon_terms\";b:1;}}s:13:\"wpseo_manager\";a:2:{s:4:\"name\";s:11:\"SEO Manager\";s:12:\"capabilities\";a:38:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:15:\"wpseo_bulk_edit\";b:1;s:28:\"wpseo_edit_advanced_metadata\";b:1;s:20:\"wpseo_manage_options\";b:1;s:23:\"view_site_health_checks\";b:1;}}s:12:\"wpseo_editor\";a:2:{s:4:\"name\";s:10:\"SEO Editor\";s:12:\"capabilities\";a:36:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:15:\"wpseo_bulk_edit\";b:1;s:28:\"wpseo_edit_advanced_metadata\";b:1;}}}", "yes");
INSERT INTO `psm_options` VALUES("100", "fresh_site", "0", "yes");
INSERT INTO `psm_options` VALUES("101", "WPLANG", "fr_FR", "yes");
INSERT INTO `psm_options` VALUES("102", "widget_search", "a:2:{i:2;a:1:{s:5:\"title\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `psm_options` VALUES("103", "widget_recent-posts", "a:3:{i:2;a:2:{s:5:\"title\";s:0:\"\";s:6:\"number\";i:5;}i:3;a:3:{s:5:\"title\";s:0:\"\";s:6:\"number\";i:5;s:9:\"show_date\";b:0;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `psm_options` VALUES("104", "widget_recent-comments", "a:2:{i:2;a:2:{s:5:\"title\";s:0:\"\";s:6:\"number\";i:5;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `psm_options` VALUES("105", "widget_archives", "a:2:{i:2;a:3:{s:5:\"title\";s:0:\"\";s:5:\"count\";i:0;s:8:\"dropdown\";i:0;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `psm_options` VALUES("106", "widget_meta", "a:2:{i:2;a:1:{s:5:\"title\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `psm_options` VALUES("107", "sidebars_widgets", "a:3:{s:19:\"wp_inactive_widgets\";a:1:{i:0;s:14:\"recent-posts-3\";}s:9:\"sidebar-1\";a:6:{i:0;s:8:\"search-2\";i:1;s:14:\"recent-posts-2\";i:2;s:17:\"recent-comments-2\";i:3;s:10:\"archives-2\";i:4;s:12:\"categories-2\";i:5;s:6:\"meta-2\";}s:13:\"array_version\";i:3;}", "yes");
INSERT INTO `psm_options` VALUES("108", "cron", "a:26:{i:1633358475;a:1:{s:26:\"action_scheduler_run_queue\";a:1:{s:32:\"0d04ed39571b55704c122d726248bbac\";a:3:{s:8:\"schedule\";s:12:\"every_minute\";s:4:\"args\";a:1:{i:0;s:7:\"WP Cron\";}s:8:\"interval\";i:60;}}}i:1633359307;a:1:{s:20:\"jetpack_clean_nonces\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1633359364;a:1:{s:32:\"woocommerce_cancel_unpaid_orders\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1633361278;a:1:{s:28:\"woocommerce_cleanup_sessions\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1633361663;a:1:{s:33:\"wc_admin_process_orders_milestone\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1633361669;a:1:{s:29:\"wc_admin_unsnooze_admin_notes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1633361702;a:1:{s:34:\"wp_privacy_delete_old_export_files\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1633362907;a:1:{s:20:\"jetpack_v2_heartbeat\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1633369726;a:1:{s:18:\"wp_https_detection\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1633374994;a:1:{s:28:\"elementor/tracker/send_event\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1633379702;a:3:{s:16:\"wp_version_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:17:\"wp_update_plugins\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:16:\"wp_update_themes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1633382761;a:1:{s:15:\"ao_cachechecker\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1633382776;a:2:{s:13:\"wpseo-reindex\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:31:\"wpseo_permalink_structure_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1633382888;a:2:{s:30:\"woocommerce_tracker_send_event\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:33:\"woocommerce_cleanup_personal_data\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1633388400;a:1:{s:27:\"woocommerce_scheduled_sales\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1633392000;a:1:{s:18:\"imagify_sync_files\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1633393678;a:1:{s:24:\"woocommerce_cleanup_logs\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1633399200;a:1:{s:46:\"imagify_update_library_size_calculations_event\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1633422901;a:2:{s:30:\"wp_site_health_scheduled_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}s:32:\"recovery_mode_clean_expired_keys\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1633422920;a:2:{s:19:\"wp_scheduled_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:25:\"delete_expired_transients\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1633422921;a:1:{s:30:\"wp_scheduled_auto_draft_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1633426463;a:1:{s:14:\"wc_admin_daily\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1633438800;a:1:{s:20:\"imagify_rating_event\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1633555738;a:1:{s:25:\"woocommerce_geoip_updater\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:11:\"fifteendays\";s:4:\"args\";a:0:{}s:8:\"interval\";i:1296000;}}}i:1633641976;a:1:{s:16:\"wpseo_ryte_fetch\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}s:7:\"version\";i:2;}", "yes");
INSERT INTO `psm_options` VALUES("109", "widget_pages", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `psm_options` VALUES("110", "widget_calendar", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `psm_options` VALUES("111", "widget_media_audio", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `psm_options` VALUES("112", "widget_media_image", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `psm_options` VALUES("113", "widget_media_gallery", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `psm_options` VALUES("114", "widget_media_video", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `psm_options` VALUES("115", "widget_tag_cloud", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `psm_options` VALUES("116", "widget_nav_menu", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `psm_options` VALUES("117", "widget_custom_html", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `psm_options` VALUES("119", "recovery_keys", "a:0:{}", "yes");
INSERT INTO `psm_options` VALUES("123", "theme_mods_twentytwentyone", "a:2:{s:18:\"custom_css_post_id\";i:-1;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1615204008;s:4:\"data\";a:3:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:3:{i:0;s:8:\"search-2\";i:1;s:14:\"recent-posts-2\";i:2;s:17:\"recent-comments-2\";}s:9:\"sidebar-2\";a:3:{i:0;s:10:\"archives-2\";i:1;s:12:\"categories-2\";i:2;s:6:\"meta-2\";}}}}", "yes");
INSERT INTO `psm_options` VALUES("138", "can_compress_scripts", "1", "no");
INSERT INTO `psm_options` VALUES("147", "finished_updating_comment_type", "1", "yes");
INSERT INTO `psm_options` VALUES("162", "recently_activated", "a:0:{}", "yes");
INSERT INTO `psm_options` VALUES("186", "action_scheduler_hybrid_store_demarkation", "5", "yes");
INSERT INTO `psm_options` VALUES("187", "schema-ActionScheduler_StoreSchema", "3.0.1615196060", "yes");
INSERT INTO `psm_options` VALUES("188", "schema-ActionScheduler_LoggerSchema", "2.0.1615196060", "yes");
INSERT INTO `psm_options` VALUES("191", "woocommerce_schema_version", "430", "yes");
INSERT INTO `psm_options` VALUES("192", "woocommerce_store_address", "15, Quartier Couite, Haut Sahuc, 33210 Preignac", "yes");
INSERT INTO `psm_options` VALUES("193", "woocommerce_store_address_2", "", "yes");
INSERT INTO `psm_options` VALUES("194", "woocommerce_store_city", "sauternes", "yes");
INSERT INTO `psm_options` VALUES("195", "woocommerce_default_country", "FR", "yes");
INSERT INTO `psm_options` VALUES("196", "woocommerce_store_postcode", "33210", "yes");
INSERT INTO `psm_options` VALUES("197", "woocommerce_allowed_countries", "all", "yes");
INSERT INTO `psm_options` VALUES("198", "woocommerce_all_except_countries", "a:0:{}", "yes");
INSERT INTO `psm_options` VALUES("199", "woocommerce_specific_allowed_countries", "a:0:{}", "yes");
INSERT INTO `psm_options` VALUES("200", "woocommerce_ship_to_countries", "", "yes");
INSERT INTO `psm_options` VALUES("201", "woocommerce_specific_ship_to_countries", "a:0:{}", "yes");
INSERT INTO `psm_options` VALUES("202", "woocommerce_default_customer_address", "base", "yes");
INSERT INTO `psm_options` VALUES("203", "woocommerce_calc_taxes", "no", "yes");
INSERT INTO `psm_options` VALUES("204", "woocommerce_enable_coupons", "yes", "yes");
INSERT INTO `psm_options` VALUES("205", "woocommerce_calc_discounts_sequentially", "no", "no");
INSERT INTO `psm_options` VALUES("206", "woocommerce_currency", "EUR", "yes");
INSERT INTO `psm_options` VALUES("207", "woocommerce_currency_pos", "right", "yes");
INSERT INTO `psm_options` VALUES("208", "woocommerce_price_thousand_sep", "", "yes");
INSERT INTO `psm_options` VALUES("209", "woocommerce_price_decimal_sep", ",", "yes");
INSERT INTO `psm_options` VALUES("210", "woocommerce_price_num_decimals", "2", "yes");
INSERT INTO `psm_options` VALUES("211", "woocommerce_shop_page_id", "6", "yes");
INSERT INTO `psm_options` VALUES("212", "woocommerce_cart_redirect_after_add", "no", "yes");
INSERT INTO `psm_options` VALUES("213", "woocommerce_enable_ajax_add_to_cart", "yes", "yes");
INSERT INTO `psm_options` VALUES("214", "woocommerce_placeholder_image", "5", "yes");
INSERT INTO `psm_options` VALUES("215", "woocommerce_weight_unit", "kg", "yes");
INSERT INTO `psm_options` VALUES("216", "woocommerce_dimension_unit", "cm", "yes");
INSERT INTO `psm_options` VALUES("217", "woocommerce_enable_reviews", "yes", "yes");
INSERT INTO `psm_options` VALUES("218", "woocommerce_review_rating_verification_label", "yes", "no");
INSERT INTO `psm_options` VALUES("219", "woocommerce_review_rating_verification_required", "no", "no");
INSERT INTO `psm_options` VALUES("220", "woocommerce_enable_review_rating", "yes", "yes");
INSERT INTO `psm_options` VALUES("221", "woocommerce_review_rating_required", "yes", "no");
INSERT INTO `psm_options` VALUES("222", "woocommerce_manage_stock", "yes", "yes");
INSERT INTO `psm_options` VALUES("223", "woocommerce_hold_stock_minutes", "60", "no");
INSERT INTO `psm_options` VALUES("224", "woocommerce_notify_low_stock", "yes", "no");
INSERT INTO `psm_options` VALUES("225", "woocommerce_notify_no_stock", "yes", "no");
INSERT INTO `psm_options` VALUES("226", "woocommerce_stock_email_recipient", "pierriesaintmaximechateau@gmail.com", "no");
INSERT INTO `psm_options` VALUES("227", "woocommerce_notify_low_stock_amount", "2", "no");
INSERT INTO `psm_options` VALUES("228", "woocommerce_notify_no_stock_amount", "0", "yes");
INSERT INTO `psm_options` VALUES("229", "woocommerce_hide_out_of_stock_items", "no", "yes");
INSERT INTO `psm_options` VALUES("230", "woocommerce_stock_format", "", "yes");
INSERT INTO `psm_options` VALUES("231", "woocommerce_file_download_method", "force", "no");
INSERT INTO `psm_options` VALUES("232", "woocommerce_downloads_require_login", "no", "no");
INSERT INTO `psm_options` VALUES("233", "woocommerce_downloads_grant_access_after_payment", "yes", "no");
INSERT INTO `psm_options` VALUES("234", "woocommerce_downloads_add_hash_to_filename", "yes", "yes");
INSERT INTO `psm_options` VALUES("235", "woocommerce_prices_include_tax", "no", "yes");
INSERT INTO `psm_options` VALUES("236", "woocommerce_tax_based_on", "shipping", "yes");
INSERT INTO `psm_options` VALUES("237", "woocommerce_shipping_tax_class", "inherit", "yes");
INSERT INTO `psm_options` VALUES("238", "woocommerce_tax_round_at_subtotal", "no", "yes");
INSERT INTO `psm_options` VALUES("239", "woocommerce_tax_classes", "", "yes");
INSERT INTO `psm_options` VALUES("240", "woocommerce_tax_display_shop", "excl", "yes");
INSERT INTO `psm_options` VALUES("241", "woocommerce_tax_display_cart", "excl", "yes");
INSERT INTO `psm_options` VALUES("242", "woocommerce_price_display_suffix", "", "yes");
INSERT INTO `psm_options` VALUES("243", "woocommerce_tax_total_display", "itemized", "no");
INSERT INTO `psm_options` VALUES("244", "woocommerce_enable_shipping_calc", "yes", "no");
INSERT INTO `psm_options` VALUES("245", "woocommerce_shipping_cost_requires_address", "no", "yes");
INSERT INTO `psm_options` VALUES("246", "woocommerce_ship_to_destination", "billing", "no");
INSERT INTO `psm_options` VALUES("247", "woocommerce_shipping_debug_mode", "no", "yes");
INSERT INTO `psm_options` VALUES("248", "woocommerce_enable_guest_checkout", "yes", "no");
INSERT INTO `psm_options` VALUES("249", "woocommerce_enable_checkout_login_reminder", "no", "no");
INSERT INTO `psm_options` VALUES("250", "woocommerce_enable_signup_and_login_from_checkout", "no", "no");
INSERT INTO `psm_options` VALUES("251", "woocommerce_enable_myaccount_registration", "no", "no");
INSERT INTO `psm_options` VALUES("252", "woocommerce_registration_generate_username", "yes", "no");
INSERT INTO `psm_options` VALUES("253", "woocommerce_registration_generate_password", "yes", "no");
INSERT INTO `psm_options` VALUES("254", "woocommerce_erasure_request_removes_order_data", "no", "no");
INSERT INTO `psm_options` VALUES("255", "woocommerce_erasure_request_removes_download_data", "no", "no");
INSERT INTO `psm_options` VALUES("256", "woocommerce_allow_bulk_remove_personal_data", "no", "no");
INSERT INTO `psm_options` VALUES("257", "woocommerce_registration_privacy_policy_text", "Vos données personnelles seront utilisées pour vous accompagner au cours de votre visite du site web, gérer l’accès à votre compte, et pour d’autres raisons décrites dans notre [privacy_policy].", "yes");
INSERT INTO `psm_options` VALUES("258", "woocommerce_checkout_privacy_policy_text", "Vos données personnelles seront utilisées pour le traitement de votre commande, vous accompagner au cours de votre visite du site web, et pour d’autres raisons décrites dans notre [privacy_policy].", "yes");
INSERT INTO `psm_options` VALUES("259", "woocommerce_delete_inactive_accounts", "a:2:{s:6:\"number\";s:0:\"\";s:4:\"unit\";s:6:\"months\";}", "no");
INSERT INTO `psm_options` VALUES("260", "woocommerce_trash_pending_orders", "", "no");
INSERT INTO `psm_options` VALUES("261", "woocommerce_trash_failed_orders", "", "no");
INSERT INTO `psm_options` VALUES("262", "woocommerce_trash_cancelled_orders", "", "no");
INSERT INTO `psm_options` VALUES("263", "woocommerce_anonymize_completed_orders", "a:2:{s:6:\"number\";s:0:\"\";s:4:\"unit\";s:6:\"months\";}", "no");
INSERT INTO `psm_options` VALUES("264", "woocommerce_email_from_name", "pierrie saint maxime", "no");
INSERT INTO `psm_options` VALUES("265", "woocommerce_email_from_address", "pierriesaintmaximechateau@gmail.com", "no");
INSERT INTO `psm_options` VALUES("266", "woocommerce_email_header_image", "", "no");
INSERT INTO `psm_options` VALUES("267", "woocommerce_email_footer_text", "{site_title} &mdash; Built with {WooCommerce}", "no");
INSERT INTO `psm_options` VALUES("268", "woocommerce_email_base_color", "#96588a", "no");
INSERT INTO `psm_options` VALUES("269", "woocommerce_email_background_color", "#f7f7f7", "no");
INSERT INTO `psm_options` VALUES("270", "woocommerce_email_body_background_color", "#ffffff", "no");
INSERT INTO `psm_options` VALUES("271", "woocommerce_email_text_color", "#3c3c3c", "no");
INSERT INTO `psm_options` VALUES("272", "woocommerce_merchant_email_notifications", "yes", "no");
INSERT INTO `psm_options` VALUES("273", "woocommerce_cart_page_id", "7", "no");
INSERT INTO `psm_options` VALUES("274", "woocommerce_checkout_page_id", "8", "no");
INSERT INTO `psm_options` VALUES("275", "woocommerce_myaccount_page_id", "9", "no");
INSERT INTO `psm_options` VALUES("276", "woocommerce_terms_page_id", "", "no");
INSERT INTO `psm_options` VALUES("277", "woocommerce_force_ssl_checkout", "no", "yes");
INSERT INTO `psm_options` VALUES("278", "woocommerce_unforce_ssl_checkout", "no", "yes");
INSERT INTO `psm_options` VALUES("279", "woocommerce_checkout_pay_endpoint", "order-pay", "yes");
INSERT INTO `psm_options` VALUES("280", "woocommerce_checkout_order_received_endpoint", "order-received", "yes");
INSERT INTO `psm_options` VALUES("281", "woocommerce_myaccount_add_payment_method_endpoint", "add-payment-method", "yes");
INSERT INTO `psm_options` VALUES("282", "woocommerce_myaccount_delete_payment_method_endpoint", "delete-payment-method", "yes");
INSERT INTO `psm_options` VALUES("283", "woocommerce_myaccount_set_default_payment_method_endpoint", "set-default-payment-method", "yes");
INSERT INTO `psm_options` VALUES("284", "woocommerce_myaccount_orders_endpoint", "orders", "yes");
INSERT INTO `psm_options` VALUES("285", "woocommerce_myaccount_view_order_endpoint", "view-order", "yes");
INSERT INTO `psm_options` VALUES("286", "woocommerce_myaccount_downloads_endpoint", "downloads", "yes");
INSERT INTO `psm_options` VALUES("287", "woocommerce_myaccount_edit_account_endpoint", "edit-account", "yes");
INSERT INTO `psm_options` VALUES("288", "woocommerce_myaccount_edit_address_endpoint", "edit-address", "yes");
INSERT INTO `psm_options` VALUES("289", "woocommerce_myaccount_payment_methods_endpoint", "payment-methods", "yes");
INSERT INTO `psm_options` VALUES("290", "woocommerce_myaccount_lost_password_endpoint", "lost-password", "yes");
INSERT INTO `psm_options` VALUES("291", "woocommerce_logout_endpoint", "customer-logout", "yes");
INSERT INTO `psm_options` VALUES("292", "woocommerce_api_enabled", "no", "yes");
INSERT INTO `psm_options` VALUES("293", "woocommerce_allow_tracking", "yes", "no");
INSERT INTO `psm_options` VALUES("294", "woocommerce_show_marketplace_suggestions", "yes", "no");
INSERT INTO `psm_options` VALUES("295", "woocommerce_single_image_width", "600", "yes");
INSERT INTO `psm_options` VALUES("296", "woocommerce_thumbnail_image_width", "300", "yes");
INSERT INTO `psm_options` VALUES("297", "woocommerce_checkout_highlight_required_fields", "yes", "yes");
INSERT INTO `psm_options` VALUES("298", "woocommerce_demo_store", "yes", "yes");
INSERT INTO `psm_options` VALUES("299", "woocommerce_permalinks", "a:5:{s:12:\"product_base\";s:7:\"produit\";s:13:\"category_base\";s:17:\"categorie-produit\";s:8:\"tag_base\";s:17:\"etiquette-produit\";s:14:\"attribute_base\";s:0:\"\";s:22:\"use_verbose_page_rules\";b:0;}", "yes");
INSERT INTO `psm_options` VALUES("300", "current_theme_supports_woocommerce", "yes", "yes");
INSERT INTO `psm_options` VALUES("301", "woocommerce_queue_flush_rewrite_rules", "no", "yes");
INSERT INTO `psm_options` VALUES("304", "default_product_cat", "15", "yes");
INSERT INTO `psm_options` VALUES("307", "woocommerce_version", "5.1.0", "yes");
INSERT INTO `psm_options` VALUES("308", "woocommerce_db_version", "5.1.0", "yes");
INSERT INTO `psm_options` VALUES("312", "_transient_jetpack_autoloader_plugin_paths", "a:2:{i:0;s:25:\"{{WP_PLUGIN_DIR}}/jetpack\";i:1;s:29:\"{{WP_PLUGIN_DIR}}/woocommerce\";}", "yes");
INSERT INTO `psm_options` VALUES("313", "action_scheduler_lock_async-request-runner", "1633358487", "yes");
INSERT INTO `psm_options` VALUES("314", "woocommerce_admin_notices", "a:1:{i:0;s:20:\"no_secure_connection\";}", "yes");
INSERT INTO `psm_options` VALUES("315", "woocommerce_maxmind_geolocation_settings", "a:1:{s:15:\"database_prefix\";s:32:\"IKPxHcTmtpNurbp0Jo0MqgGqbRyBoAQL\";}", "yes");
INSERT INTO `psm_options` VALUES("316", "_transient_woocommerce_webhook_ids_status_active", "a:0:{}", "yes");
INSERT INTO `psm_options` VALUES("317", "widget_woocommerce_widget_cart", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `psm_options` VALUES("318", "widget_woocommerce_layered_nav_filters", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `psm_options` VALUES("319", "widget_woocommerce_layered_nav", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `psm_options` VALUES("320", "widget_woocommerce_price_filter", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `psm_options` VALUES("321", "widget_woocommerce_product_categories", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `psm_options` VALUES("322", "widget_woocommerce_product_search", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `psm_options` VALUES("323", "widget_woocommerce_product_tag_cloud", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `psm_options` VALUES("324", "widget_woocommerce_products", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `psm_options` VALUES("325", "widget_woocommerce_recently_viewed_products", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `psm_options` VALUES("326", "widget_woocommerce_top_rated_products", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `psm_options` VALUES("327", "widget_woocommerce_recent_reviews", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `psm_options` VALUES("328", "widget_woocommerce_rating_filter", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `psm_options` VALUES("332", "woocommerce_admin_install_timestamp", "1615196063", "yes");
INSERT INTO `psm_options` VALUES("336", "wc_remote_inbox_notifications_specs", "a:0:{}", "yes");
INSERT INTO `psm_options` VALUES("337", "wc_remote_inbox_notifications_stored_state", "O:8:\"stdClass\":3:{s:22:\"there_were_no_products\";b:1;s:22:\"there_are_now_products\";b:1;s:17:\"new_product_count\";i:0;}", "yes");
INSERT INTO `psm_options` VALUES("338", "_transient_wc_count_comments", "O:8:\"stdClass\":7:{s:14:\"total_comments\";i:1;s:3:\"all\";i:1;s:8:\"approved\";s:1:\"1\";s:9:\"moderated\";i:0;s:4:\"spam\";i:0;s:5:\"trash\";i:0;s:12:\"post-trashed\";i:0;}", "yes");
INSERT INTO `psm_options` VALUES("339", "wc_blocks_db_schema_version", "260", "yes");
INSERT INTO `psm_options` VALUES("340", "woocommerce_meta_box_errors", "a:0:{}", "yes");
INSERT INTO `psm_options` VALUES("344", "_transient_woocommerce_reports-transient-version", "1617122731", "yes");
INSERT INTO `psm_options` VALUES("354", "action_scheduler_migration_status", "complete", "yes");
INSERT INTO `psm_options` VALUES("356", "woocommerce_onboarding_profile", "a:10:{s:12:\"setup_client\";b:1;s:8:\"industry\";a:1:{i:0;a:1:{s:4:\"slug\";s:10:\"food-drink\";}}s:13:\"product_types\";a:1:{i:0;s:8:\"physical\";}s:13:\"product_count\";s:4:\"1-10\";s:14:\"selling_venues\";s:12:\"brick-mortar\";s:7:\"revenue\";s:4:\"none\";s:19:\"business_extensions\";a:4:{i:0;s:24:\"facebook-for-woocommerce\";i:1;s:25:\"mailchimp-for-woocommerce\";i:2;s:33:\"creative-mail-by-constant-contact\";i:3;s:27:\"kliken-marketing-for-google\";}s:5:\"theme\";s:6:\"jorden\";s:7:\"plugins\";s:17:\"already-installed\";s:9:\"completed\";b:1;}", "yes");
INSERT INTO `psm_options` VALUES("367", "mailchimp-woocommerce", "a:0:{}", "yes");
INSERT INTO `psm_options` VALUES("369", "mailchimp-woocommerce-store_id", "6045f0a37c6fb", "yes");
INSERT INTO `psm_options` VALUES("370", "mailchimp-woocommerce-store-id-last-verified", "1615196323", "yes");
INSERT INTO `psm_options` VALUES("371", "ce4wp_activated", "1", "yes");
INSERT INTO `psm_options` VALUES("372", "ce4wp_install_date", "2021-03-08 9:38:43", "yes");
INSERT INTO `psm_options` VALUES("374", "woocommerce_kk_wcintegration_settings", "a:3:{s:10:\"account_id\";i:0;s:9:\"app_token\";s:0:\"\";s:12:\"google_token\";s:0:\"\";}", "yes");
INSERT INTO `psm_options` VALUES("377", "ce4wp_handshake_token", "667AC003-BC8B-495D-9EA3-501D8A5448E4", "yes");
INSERT INTO `psm_options` VALUES("378", "ce4wp_handshake_expiration", "1633359362", "yes");
INSERT INTO `psm_options` VALUES("379", "ce4wp_instance_uuid", "6045f0a405023", "yes");
INSERT INTO `psm_options` VALUES("380", "ce4wp_referred_by", "a:4:{s:6:\"plugin\";s:11:\"woocommerce\";s:7:\"version\";s:5:\"5.1.0\";s:4:\"time\";i:1617122850;s:6:\"source\";s:10:\"onboarding\";}", "yes");
INSERT INTO `psm_options` VALUES("382", "facebook_config", "a:4:{s:8:\"pixel_id\";s:1:\"0\";s:7:\"use_pii\";b:1;s:7:\"use_s2s\";b:0;s:12:\"access_token\";s:0:\"\";}", "yes");
INSERT INTO `psm_options` VALUES("383", "ce4wp_abandoned_checkout_db_version", "1.0", "yes");
INSERT INTO `psm_options` VALUES("384", "wc_facebook_for_woocommerce_is_active", "yes", "yes");
INSERT INTO `psm_options` VALUES("404", "current_theme", "Jorden", "yes");
INSERT INTO `psm_options` VALUES("405", "theme_switched", "", "yes");
INSERT INTO `psm_options` VALUES("406", "theme_mods_storefront", "a:3:{s:18:\"nav_menu_locations\";a:0:{}s:18:\"custom_css_post_id\";i:-1;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1616707467;s:4:\"data\";a:7:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:6:{i:0;s:8:\"search-2\";i:1;s:14:\"recent-posts-2\";i:2;s:17:\"recent-comments-2\";i:3;s:10:\"archives-2\";i:4;s:12:\"categories-2\";i:5;s:6:\"meta-2\";}s:8:\"header-1\";a:0:{}s:8:\"footer-1\";a:0:{}s:8:\"footer-2\";a:0:{}s:8:\"footer-3\";a:0:{}s:8:\"footer-4\";a:0:{}}}}", "yes");
INSERT INTO `psm_options` VALUES("407", "woocommerce_catalog_rows", "4", "yes");
INSERT INTO `psm_options` VALUES("408", "woocommerce_catalog_columns", "3", "yes");
INSERT INTO `psm_options` VALUES("409", "woocommerce_maybe_regenerate_images_hash", "7769330881cf28e1cfacdc5c08213d78", "yes");
INSERT INTO `psm_options` VALUES("414", "storefront_nux_fresh_site", "0", "yes");
INSERT INTO `psm_options` VALUES("443", "jetpack_activated", "1", "yes");
INSERT INTO `psm_options` VALUES("446", "jetpack_activation_source", "a:2:{i:0;s:7:\"unknown\";i:1;N;}", "yes");
INSERT INTO `psm_options` VALUES("447", "jetpack_sync_settings_disable", "0", "yes");
INSERT INTO `psm_options` VALUES("448", "jetpack_options", "a:5:{s:7:\"version\";s:14:\"9.5:1615218906\";s:11:\"old_version\";s:14:\"9.5:1615218906\";s:14:\"last_heartbeat\";i:1633279816;s:28:\"fallback_no_verify_ssl_certs\";i:0;s:9:\"time_diff\";i:0;}", "yes");
INSERT INTO `psm_options` VALUES("449", "jetpack_connection_active_plugins", "a:1:{s:7:\"jetpack\";a:1:{s:4:\"name\";s:7:\"Jetpack\";}}", "yes");
INSERT INTO `psm_options` VALUES("450", "wc_connect_options", "a:1:{s:12:\"tos_accepted\";b:1;}", "yes");
INSERT INTO `psm_options` VALUES("452", "jetpack_testimonial", "0", "yes");
INSERT INTO `psm_options` VALUES("455", "jetpack_available_modules", "a:1:{s:3:\"9.5\";a:42:{s:8:\"carousel\";s:3:\"1.5\";s:13:\"comment-likes\";s:3:\"5.1\";s:8:\"comments\";s:3:\"1.4\";s:12:\"contact-form\";s:3:\"1.3\";s:9:\"copy-post\";s:3:\"7.0\";s:20:\"custom-content-types\";s:3:\"3.1\";s:10:\"custom-css\";s:3:\"1.7\";s:21:\"enhanced-distribution\";s:3:\"1.2\";s:16:\"google-analytics\";s:3:\"4.5\";s:19:\"gravatar-hovercards\";s:3:\"1.1\";s:15:\"infinite-scroll\";s:3:\"2.0\";s:8:\"json-api\";s:3:\"1.9\";s:5:\"latex\";s:3:\"1.1\";s:11:\"lazy-images\";s:5:\"5.6.0\";s:5:\"likes\";s:3:\"2.2\";s:8:\"markdown\";s:3:\"2.8\";s:9:\"masterbar\";s:3:\"4.8\";s:7:\"monitor\";s:3:\"2.6\";s:5:\"notes\";s:3:\"1.9\";s:10:\"photon-cdn\";s:3:\"6.6\";s:6:\"photon\";s:3:\"2.0\";s:13:\"post-by-email\";s:3:\"2.0\";s:7:\"protect\";s:3:\"3.4\";s:9:\"publicize\";s:3:\"2.0\";s:13:\"related-posts\";s:3:\"2.9\";s:6:\"search\";s:3:\"5.0\";s:9:\"seo-tools\";s:3:\"4.4\";s:10:\"sharedaddy\";s:3:\"1.1\";s:10:\"shortcodes\";s:3:\"1.1\";s:10:\"shortlinks\";s:3:\"1.1\";s:8:\"sitemaps\";s:3:\"3.9\";s:3:\"sso\";s:3:\"2.6\";s:5:\"stats\";s:3:\"1.1\";s:13:\"subscriptions\";s:3:\"1.2\";s:13:\"tiled-gallery\";s:3:\"2.1\";s:10:\"vaultpress\";s:5:\"0:1.2\";s:18:\"verification-tools\";s:3:\"3.0\";s:10:\"videopress\";s:3:\"2.5\";s:17:\"widget-visibility\";s:3:\"2.4\";s:7:\"widgets\";s:3:\"1.2\";s:21:\"woocommerce-analytics\";s:3:\"8.4\";s:7:\"wordads\";s:5:\"4.5.0\";}}", "yes");
INSERT INTO `psm_options` VALUES("457", "wc_facebook_for_woocommerce_version", "2.3.3", "yes");
INSERT INTO `psm_options` VALUES("461", "do_activate", "0", "yes");
INSERT INTO `psm_options` VALUES("466", "sharing-options", "a:1:{s:6:\"global\";a:5:{s:12:\"button_style\";s:9:\"icon-text\";s:13:\"sharing_label\";s:15:\"Partager&nbsp;:\";s:10:\"open_links\";s:4:\"same\";s:4:\"show\";a:2:{i:0;s:4:\"post\";i:1;s:4:\"page\";}s:6:\"custom\";a:0:{}}}", "yes");
INSERT INTO `psm_options` VALUES("467", "stats_options", "a:7:{s:9:\"admin_bar\";b:1;s:5:\"roles\";a:1:{i:0;s:13:\"administrator\";}s:11:\"count_roles\";a:0:{}s:7:\"blog_id\";b:0;s:12:\"do_not_track\";b:1;s:10:\"hide_smile\";b:1;s:7:\"version\";s:1:\"9\";}", "yes");
INSERT INTO `psm_options` VALUES("481", "_transient_shipping-transient-version", "1615230270", "yes");
INSERT INTO `psm_options` VALUES("508", "elementor_version", "3.4.4", "yes");
INSERT INTO `psm_options` VALUES("509", "elementor_install_history", "a:3:{s:5:\"3.1.3\";i:1615230994;s:5:\"3.1.4\";i:1619518510;s:5:\"3.4.4\";i:1632256560;}", "yes");
INSERT INTO `psm_options` VALUES("511", "_elementor_installed_time", "1615231016", "yes");
INSERT INTO `psm_options` VALUES("512", "elementor_active_kit", "12", "yes");
INSERT INTO `psm_options` VALUES("513", "elementor_scheme_color", "a:4:{i:1;s:7:\"#6ec1e4\";i:2;s:7:\"#54595f\";i:3;s:7:\"#7a7a7a\";i:4;s:7:\"#61ce70\";}", "yes");
INSERT INTO `psm_options` VALUES("514", "elementor_scheme_typography", "a:4:{i:1;a:2:{s:11:\"font_family\";s:6:\"Roboto\";s:11:\"font_weight\";s:3:\"600\";}i:2;a:2:{s:11:\"font_family\";s:11:\"Roboto Slab\";s:11:\"font_weight\";s:3:\"400\";}i:3;a:2:{s:11:\"font_family\";s:6:\"Roboto\";s:11:\"font_weight\";s:3:\"400\";}i:4;a:2:{s:11:\"font_family\";s:6:\"Roboto\";s:11:\"font_weight\";s:3:\"500\";}}", "yes");
INSERT INTO `psm_options` VALUES("515", "elementor_scheme_color-picker", "a:8:{i:1;s:7:\"#6ec1e4\";i:2;s:7:\"#54595f\";i:3;s:7:\"#7a7a7a\";i:4;s:7:\"#61ce70\";i:5;s:7:\"#4054b2\";i:6;s:7:\"#23a455\";i:7;s:4:\"#000\";i:8;s:4:\"#fff\";}", "yes");
INSERT INTO `psm_options` VALUES("516", "elementor_remote_info_library", "a:3:{s:10:\"types_data\";a:3:{s:5:\"block\";a:1:{s:10:\"categories\";a:22:{i:0;s:8:\"404 page\";i:1;s:5:\"about\";i:2;s:7:\"archive\";i:3;s:14:\"call to action\";i:4;s:7:\"clients\";i:5;s:7:\"contact\";i:6;s:3:\"faq\";i:7;s:8:\"features\";i:8;s:6:\"footer\";i:9;s:6:\"header\";i:10;s:4:\"hero\";i:11;s:9:\"portfolio\";i:12;s:7:\"pricing\";i:13;s:15:\"product archive\";i:14;s:8:\"services\";i:15;s:11:\"single page\";i:16;s:11:\"single post\";i:17;s:14:\"single product\";i:18;s:5:\"stats\";i:19;s:9:\"subscribe\";i:20;s:4:\"team\";i:21;s:12:\"testimonials\";}}s:5:\"popup\";a:1:{s:10:\"categories\";a:6:{i:0;s:10:\"bottom bar\";i:1;s:7:\"classic\";i:2;s:6:\"fly-in\";i:3;s:11:\"full screen\";i:4;s:9:\"hello bar\";i:5;s:8:\"slide-in\";}}s:2:\"lp\";a:1:{s:10:\"categories\";a:14:{i:0;s:8:\"Business\";i:1;s:16:\"Coming Soon Page\";i:2;s:5:\"Ebook\";i:3;s:9:\"eCommerce\";i:4;s:9:\"Education\";i:5;s:6:\"Events\";i:6;s:18:\"Health and Fitness\";i:7;s:14:\"Online Service\";i:8;s:7:\"Product\";i:9;s:11:\"Real Estate\";i:10;s:18:\"Social Involvement\";i:11;s:14:\"Thank You Page\";i:12;s:6:\"Travel\";i:13;s:18:\"Under Construction\";}}}s:10:\"categories\";a:22:{i:0;s:8:\"404 page\";i:1;s:5:\"about\";i:2;s:7:\"archive\";i:3;s:14:\"call to action\";i:4;s:7:\"clients\";i:5;s:7:\"contact\";i:6;s:3:\"faq\";i:7;s:8:\"features\";i:8;s:6:\"footer\";i:9;s:6:\"header\";i:10;s:4:\"hero\";i:11;s:9:\"portfolio\";i:12;s:7:\"pricing\";i:13;s:15:\"product archive\";i:14;s:8:\"services\";i:15;s:11:\"single page\";i:16;s:11:\"single post\";i:17;s:14:\"single product\";i:18;s:5:\"stats\";i:19;s:9:\"subscribe\";i:20;s:4:\"team\";i:21;s:12:\"testimonials\";}s:9:\"templates\";a:881:{i:0;a:15:{s:2:\"id\";i:10107;s:5:\"title\";s:34:\"Classic | Promotion | Announcement\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2019/01/balls_small.png\";s:12:\"tmpl_created\";i:1547851373;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:127:\"https://library.elementor.com/popups/classic-promotion-announcement/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:206;s:11:\"trend_index\";i:207;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:1;a:15:{s:2:\"id\";i:14827;s:5:\"title\";s:39:\"Slide-In | Contact | Luxury Real Estate\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2020/07/PopUp.png\";s:12:\"tmpl_created\";i:1595323523;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/popups/slide-in-contact-luxury-real-estate/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:28:\"[\"real estate\",\"realestate\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:559;s:11:\"trend_index\";i:284;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:2;a:15:{s:2:\"id\";i:10158;s:5:\"title\";s:17:\"Classic | Contact\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2019/01/coco_small.png\";s:12:\"tmpl_created\";i:1547852227;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/popups/classic-contact/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:255;s:11:\"trend_index\";i:295;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:3;a:15:{s:2:\"id\";i:10190;s:5:\"title\";s:30:\"Classic | Register | Subscribe\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2019/01/engage_small.png\";s:12:\"tmpl_created\";i:1547885703;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:125:\"https://library.elementor.com/popups/classic-register-subscribe-5/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:214;s:11:\"trend_index\";i:151;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:4;a:15:{s:2:\"id\";i:15075;s:5:\"title\";s:34:\"Slide-In | Menu | Flooring Company\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2020/08/PopUp-1.png\";s:12:\"tmpl_created\";i:1597739605;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:127:\"https://library.elementor.com/popups/slide-in-menu-flooring-company/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:39:\"[\"Flooring company\",\"Flooring website\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:383;s:11:\"trend_index\";i:162;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:5;a:15:{s:2:\"id\";i:15062;s:5:\"title\";s:35:\"Fly-In | Sign up | Flooring Company\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2020/08/PopUp.png\";s:12:\"tmpl_created\";i:1597739629;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:128:\"https://library.elementor.com/popups/fly-in-sign-up-flooring-company/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:39:\"[\"Flooring company\",\"Flooring website\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:625;s:11:\"trend_index\";i:309;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:6;a:15:{s:2:\"id\";i:10256;s:5:\"title\";s:20:\"Classic | Sale | Pop\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2019/01/fruit_small.png\";s:12:\"tmpl_created\";i:1547888909;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/popups/classic-sale-3/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:458;s:11:\"trend_index\";i:597;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:7;a:15:{s:2:\"id\";i:10267;s:5:\"title\";s:29:\"Classic | Contact | Christmas\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2019/01/christmas_small.png\";s:12:\"tmpl_created\";i:1547889047;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/popups/classic-contact-christmas/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:281;s:11:\"trend_index\";i:233;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:8;a:15:{s:2:\"id\";i:10307;s:5:\"title\";s:43:\"Fly In | Promotion | Christmas | Teddy Bear\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2019/01/teddy_small.png\";s:12:\"tmpl_created\";i:1547893266;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:123:\"https://library.elementor.com/popups/fly-in-promotion-christmas/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:641;s:11:\"trend_index\";i:689;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:9;a:15:{s:2:\"id\";i:10318;s:5:\"title\";s:27:\"Classic | Contact | Bicycle\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2019/01/by_small.png\";s:12:\"tmpl_created\";i:1547893367;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/popups/classic-contact-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:327;s:11:\"trend_index\";i:326;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:10;a:15:{s:2:\"id\";i:10339;s:5:\"title\";s:22:\"Fly In | Contact | Spa\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2019/01/spa_small.png\";s:12:\"tmpl_created\";i:1547893603;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/popups/fly-in-contact-spa/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:390;s:11:\"trend_index\";i:393;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:11;a:15:{s:2:\"id\";i:10352;s:5:\"title\";s:23:\"Fly In | Contact | Wine\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2019/01/fly_wine_small.png\";s:12:\"tmpl_created\";i:1547915335;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/popups/fly-in-contact/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:445;s:11:\"trend_index\";i:525;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:12;a:15:{s:2:\"id\";i:10372;s:5:\"title\";s:29:\"Fly In | Register | Subscribe\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2019/01/phone_small.png\";s:12:\"tmpl_created\";i:1547915554;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:124:\"https://library.elementor.com/popups/fly-in-register-subscribe-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:638;s:11:\"trend_index\";i:636;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:13;a:15:{s:2:\"id\";i:10382;s:5:\"title\";s:35:\"Bottom Bar | Announcement | Cookies\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2019/01/bottom_pink_small.png\";s:12:\"tmpl_created\";i:1547916616;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.elementor.com/popups/bottom-bar-announcement/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:10:\"bottom bar\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:242;s:11:\"trend_index\";i:258;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:14;a:15:{s:2:\"id\";i:15259;s:5:\"title\";s:31:\"Hello Bar | Menu | Psychologist\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2020/09/Menu-PopUp.png\";s:12:\"tmpl_created\";i:1600170209;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:124:\"https://library.elementor.com/popups/hello-bar-menu-psychologist/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:34:\"[\"Psychologist\",\"Psychotherapist\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:739;s:11:\"trend_index\";i:583;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:15;a:15:{s:2:\"id\";i:15272;s:5:\"title\";s:32:\"Classic | Contact | Psychologist\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2020/09/PopUp.png\";s:12:\"tmpl_created\";i:1600170487;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:125:\"https://library.elementor.com/popups/classic-contact-psychologist/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:34:\"[\"Psychologist\",\"Psychotherapist\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:578;s:11:\"trend_index\";i:312;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:16;a:15:{s:2:\"id\";i:15414;s:5:\"title\";s:32:\"Classic | Contact | Dance Studio\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2020/10/PopUp.jpg\";s:12:\"tmpl_created\";i:1603180596;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:125:\"https://library.elementor.com/popups/classic-contact-dance-studio/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:16:\"[\"dance studio\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:762;s:11:\"trend_index\";i:650;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:17;a:15:{s:2:\"id\";i:10434;s:5:\"title\";s:27:\"Classic | Sale | Headphones\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2019/01/head_small.png\";s:12:\"tmpl_created\";i:1547961950;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/popups/classic-sale-6/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:359;s:11:\"trend_index\";i:353;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:18;a:15:{s:2:\"id\";i:10444;s:5:\"title\";s:17:\"Classic | Contact\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2019/01/plant_small.png\";s:12:\"tmpl_created\";i:1547962029;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/popups/classic-contact-3/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:385;s:11:\"trend_index\";i:298;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:19;a:15:{s:2:\"id\";i:10467;s:5:\"title\";s:27:\"Bottom Bar | Contact | Lego\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2019/01/tro_small.png\";s:12:\"tmpl_created\";i:1547962277;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/popups/bottom-bar-contact/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:10:\"bottom bar\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:722;s:11:\"trend_index\";i:0;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:20;a:15:{s:2:\"id\";i:10487;s:5:\"title\";s:18:\"Slide In | Contact\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2019/01/acc_small.png\";s:12:\"tmpl_created\";i:1547964527;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/popups/slide-in-contact-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:554;s:11:\"trend_index\";i:618;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:21;a:15:{s:2:\"id\";i:10498;s:5:\"title\";s:14:\"Classic | Sale\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2019/01/pink_small-1.png\";s:12:\"tmpl_created\";i:1547964616;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/popups/classic-sale-7/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:421;s:11:\"trend_index\";i:382;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:22;a:15:{s:2:\"id\";i:10519;s:5:\"title\";s:27:\"Hello Bar | Promotion | App\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2019/01/app_small-1.png\";s:12:\"tmpl_created\";i:1547964801;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/popups/hello-bar-promotion-app-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:585;s:11:\"trend_index\";i:629;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:23;a:15:{s:2:\"id\";i:15580;s:5:\"title\";s:31:\"Fullscreen | Menu | Travel Blog\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2020/11/PopUp-Menu.jpg\";s:12:\"tmpl_created\";i:1606215358;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:124:\"https://library.elementor.com/popups/fullscreen-menu-travel-blog/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:17:\"[\"Blog\",\"Travel\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:673;s:11:\"trend_index\";i:348;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:24;a:15:{s:2:\"id\";i:15570;s:5:\"title\";s:33:\"Classic | Subscribe | Travel Blog\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2020/11/PopUp.jpg\";s:12:\"tmpl_created\";i:1606215555;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:126:\"https://library.elementor.com/popups/classic-subscribe-travel-blog/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:17:\"[\"Blog\",\"Travel\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:709;s:11:\"trend_index\";i:459;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:25;a:15:{s:2:\"id\";i:10569;s:5:\"title\";s:15:\"Slide In | Sale\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2019/01/off_small.png\";s:12:\"tmpl_created\";i:1547967812;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/popups/slide-in-sale/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:529;s:11:\"trend_index\";i:485;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:26;a:15:{s:2:\"id\";i:10590;s:5:\"title\";s:19:\"Full Screen | Login\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2019/01/pass1_small.png\";s:12:\"tmpl_created\";i:1547967978;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/popups/classic-login-6/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:466;s:11:\"trend_index\";i:356;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:27;a:15:{s:2:\"id\";i:10600;s:5:\"title\";s:18:\"Slide In | Contact\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2019/01/orange_small.png\";s:12:\"tmpl_created\";i:1547968080;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/popups/slide-in-contact-3/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:483;s:11:\"trend_index\";i:494;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:28;a:15:{s:2:\"id\";i:10622;s:5:\"title\";s:34:\"Full Screen | Contact | Headphones\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2019/01/full_hear_small.png\";s:12:\"tmpl_created\";i:1547969678;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/popups/full-screen-contact-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:543;s:11:\"trend_index\";i:456;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:29;a:15:{s:2:\"id\";i:10633;s:5:\"title\";s:23:\"Slide In | Login | Lego\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2019/01/tro_small-1.png\";s:12:\"tmpl_created\";i:1547969858;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/popups/slide-in-login/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:675;s:11:\"trend_index\";i:722;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:30;a:15:{s:2:\"id\";i:10644;s:5:\"title\";s:26:\"Fly In | Contact | Webinar\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2019/01/blue_small-1.png\";s:12:\"tmpl_created\";i:1547970814;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:113:\"https://library.elementor.com/popups/fly-in-contact-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:484;s:11:\"trend_index\";i:440;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:31;a:15:{s:2:\"id\";i:10654;s:5:\"title\";s:31:\"Full Screen | Login | Christmas\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2019/01/full_login_small.png\";s:12:\"tmpl_created\";i:1547970917;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:124:\"https://library.elementor.com/popups/full-screen-login-christmas/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:658;s:11:\"trend_index\";i:676;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:32;a:15:{s:2:\"id\";i:10664;s:5:\"title\";s:34:\"Slide In | Contact | Gym | Fitness\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2019/01/slide_gym_small.png\";s:12:\"tmpl_created\";i:1547973928;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/popups/slide-in-contact-4/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:552;s:11:\"trend_index\";i:384;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:33;a:15:{s:2:\"id\";i:10675;s:5:\"title\";s:35:\"Full Screen | Login | Gym | Fitness\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2019/01/gym_full_small.png\";s:12:\"tmpl_created\";i:1547974110;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/popups/full-screen-login-4/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:519;s:11:\"trend_index\";i:477;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:34;a:15:{s:2:\"id\";i:9719;s:5:\"title\";s:30:\"Classic | Subscribe | Register\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2019/01/register_small.png\";s:12:\"tmpl_created\";i:1547976107;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:123:\"https://library.elementor.com/popups/classic-subscribe-register/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:398;s:11:\"trend_index\";i:282;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:35;a:15:{s:2:\"id\";i:10137;s:5:\"title\";s:34:\"Full Screen | Contact | Restaurant\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2019/01/rest_small.png\";s:12:\"tmpl_created\";i:1547976342;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/popups/full-screen-contact/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:570;s:11:\"trend_index\";i:589;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:36;a:15:{s:2:\"id\";i:10244;s:5:\"title\";s:17:\"Bottom Bar | Sale\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2019/01/wow_small.png\";s:12:\"tmpl_created\";i:1547976402;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/popups/bottom-bar-sale/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:10:\"bottom bar\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:623;s:11:\"trend_index\";i:660;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:37;a:15:{s:2:\"id\";i:10127;s:5:\"title\";s:35:\"Fly In | Announcement | Maintenance\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2019/01/pizza_small.png\";s:12:\"tmpl_created\";i:1547984061;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/popups/fly-in-announcement-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:700;s:11:\"trend_index\";i:738;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:38;a:15:{s:2:\"id\";i:10776;s:5:\"title\";s:33:\"Fly In | Contact | Social | Share\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2019/01/social1_small.png\";s:12:\"tmpl_created\";i:1548047055;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:124:\"https://library.elementor.com/popups/fly-in-contact-social-share/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:694;s:11:\"trend_index\";i:694;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:39;a:15:{s:2:\"id\";i:10785;s:5:\"title\";s:33:\"Fly In | Contact | Social | Share\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2019/01/social2_small.png\";s:12:\"tmpl_created\";i:1548047593;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:126:\"https://library.elementor.com/popups/fly-in-contact-social-share-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:468;s:11:\"trend_index\";i:442;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:40;a:15:{s:2:\"id\";i:10794;s:5:\"title\";s:34:\"Classic | Contact | Social | Share\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2019/01/s_small.png\";s:12:\"tmpl_created\";i:1548067619;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:125:\"https://library.elementor.com/popups/classic-contact-social-share/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:430;s:11:\"trend_index\";i:475;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:41;a:15:{s:2:\"id\";i:10871;s:5:\"title\";s:20:\"Bottom Bar | Contact\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2019/01/m_small.png\";s:12:\"tmpl_created\";i:1548074396;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/popups/bottom-bar-contact-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:10:\"bottom bar\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:706;s:11:\"trend_index\";i:0;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:42;a:15:{s:2:\"id\";i:10936;s:5:\"title\";s:25:\"Full Screen | Toggle Menu\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2019/01/menu_small.png\";s:12:\"tmpl_created\";i:1548874587;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.elementor.com/popups/full-screen-toggle-menu/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:478;s:11:\"trend_index\";i:572;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:43;a:15:{s:2:\"id\";i:10964;s:5:\"title\";s:59:\"Classic | Promotion | Coupon | Love | Valentine&#8217;s Day\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2019/02/love_small.png\";s:12:\"tmpl_created\";i:1550039106;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:121:\"https://library.elementor.com/popups/classic-promotion-coupon/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:598;s:11:\"trend_index\";i:664;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:44;a:15:{s:2:\"id\";i:10992;s:5:\"title\";s:59:\"Classic | Promotion | Coupon | Love | Valentine&#8217;s Day\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2019/02/h_small.png\";s:12:\"tmpl_created\";i:1550072007;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:141:\"https://library.elementor.com/popups/classic-promotion-coupon-love-valentines-day/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:668;s:11:\"trend_index\";i:668;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:45;a:15:{s:2:\"id\";i:11005;s:5:\"title\";s:50:\"Classic | Promotion | Love | Valentine&#8217;s Day\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2019/02/bear_small.png\";s:12:\"tmpl_created\";i:1550073303;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/popups/classic-promotion-love-valentines-day/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:680;s:11:\"trend_index\";i:615;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:46;a:15:{s:2:\"id\";i:16553;s:5:\"title\";s:31:\"Fly-In | Contact | Beauty Salon\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2020/12/PopUp.jpg\";s:12:\"tmpl_created\";i:1608622602;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:124:\"https://library.elementor.com/popups/fly-in-contact-beauty-salon/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:23:\"[\"Beauty salon\",\"hair\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:691;s:11:\"trend_index\";i:428;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:47;a:15:{s:2:\"id\";i:11468;s:5:\"title\";s:20:\"Classic | Sale | Gym\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2019/08/PopUp_Small.png\";s:12:\"tmpl_created\";i:1567393182;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:113:\"https://library.elementor.com/popups/classic-sale-gym/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:696;s:11:\"trend_index\";i:740;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:48;a:15:{s:2:\"id\";i:11822;s:5:\"title\";s:30:\"Full Screen | Menu | Portfolio\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2019/09/PopUp_small.png\";s:12:\"tmpl_created\";i:1569429896;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:123:\"https://library.elementor.com/popups/full-screen-menu-portfolio/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:654;s:11:\"trend_index\";i:626;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:49;a:15:{s:2:\"id\";i:11839;s:5:\"title\";s:9:\"Portfolio\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2019/09/Header_small.png\";s:12:\"tmpl_created\";i:1569430015;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/portfolio-9/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:43:\"[\"creative portfolio\",\"header\",\"portfolio\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:189;s:11:\"trend_index\";i:20;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:50;a:15:{s:2:\"id\";i:12229;s:5:\"title\";s:33:\"Slide In | Law Firm | Information\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2019/11/popup.png\";s:12:\"tmpl_created\";i:1572847842;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:126:\"https://library.elementor.com/popups/slide-in-law-firm-information/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:18:\"[\"Law\",\"Law Firm\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:547;s:11:\"trend_index\";i:413;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:51;a:15:{s:2:\"id\";i:12550;s:5:\"title\";s:32:\"Fly-in | Sale | Travel and Tours\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2019/12/PopUp_s.png\";s:12:\"tmpl_created\";i:1575960263;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:124:\"https://library.elementor.com/popups/flyin-sale-travel-and-tours/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:18:\"[\"Tours\",\"Travel\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:754;s:11:\"trend_index\";i:791;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:52;a:15:{s:2:\"id\";i:12540;s:5:\"title\";s:33:\"Classic | Menu | Travel and tours\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2019/12/PopUp_Menu_s.png\";s:12:\"tmpl_created\";i:1575960267;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:126:\"https://library.elementor.com/popups/classic-menu-travel-and-tours/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:18:\"[\"Tours\",\"Travel\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:690;s:11:\"trend_index\";i:714;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:53;a:15:{s:2:\"id\";i:18839;s:5:\"title\";s:27:\"Hello Bar | CTA | eCommerce\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2021/05/350x250.png\";s:12:\"tmpl_created\";i:1621870603;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.elementor.com/popups/hello-bar-cta-ecommerce/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:41:\"[\"Ecommerce\",\"online shop\",\"Sale\",\"Shop\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:54;a:15:{s:2:\"id\";i:12736;s:5:\"title\";s:41:\"Slide In | Contact Us | Magazine and Blog\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2020/01/PopUp_contact_s.png\";s:12:\"tmpl_created\";i:1579060978;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/popups/slide-in-contact-us/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:19:\"[\"Blog\",\"Magazine\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:734;s:11:\"trend_index\";i:686;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:55;a:15:{s:2:\"id\";i:12726;s:5:\"title\";s:52:\"Classic | Newsletter | Subscribe | Magazine and Blog\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2020/01/PopUp_Newsletter_s.png\";s:12:\"tmpl_created\";i:1579061019;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:143:\"https://library.elementor.com/popups/classic-newsletter-subscribe-magazine-and-blog/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:19:\"[\"Blog\",\"Magazine\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:357;s:11:\"trend_index\";i:281;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:56;a:15:{s:2:\"id\";i:13129;s:5:\"title\";s:28:\"Classic | Menu | Photography\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2020/02/PopUp_s.png\";s:12:\"tmpl_created\";i:1582092645;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:121:\"https://library.elementor.com/popups/classic-menu-photography/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:27:\"[\"Photography\",\"portfolio\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:646;s:11:\"trend_index\";i:521;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:57;a:15:{s:2:\"id\";i:9611;s:5:\"title\";s:16:\"Hello Bar | Sale\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2019/01/Top-Bar_Sale_small_01.png\";s:12:\"tmpl_created\";i:1546965350;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/popups/hello-bar-sale-01/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:605;s:11:\"trend_index\";i:603;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:58;a:15:{s:2:\"id\";i:9622;s:5:\"title\";s:19:\"Classic | Promotion\";s:9:\"thumbnail\";s:87:\"https://library.elementor.com/wp-content/uploads/2019/01/classic_promotion_small_02.png\";s:12:\"tmpl_created\";i:1546965896;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/popups/classic-promotion-02/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:607;s:11:\"trend_index\";i:460;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:59;a:15:{s:2:\"id\";i:9631;s:5:\"title\";s:38:\"Slide-in | Sale | Register | Subscribe\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2019/01/Slide-in_Sale_small_01.png\";s:12:\"tmpl_created\";i:1546968270;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:113:\"https://library.elementor.com/popups/slide-in-sale-01/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:661;s:11:\"trend_index\";i:705;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:60;a:15:{s:2:\"id\";i:9662;s:5:\"title\";s:33:\"Bottom Bar | Register | Subscribe\";s:9:\"thumbnail\";s:89:\"https://library.elementor.com/wp-content/uploads/2019/01/Bottom-Bar_Register_small_01.png\";s:12:\"tmpl_created\";i:1547009087;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/popups/bottom-bar-register-01/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:10:\"bottom bar\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:684;s:11:\"trend_index\";i:658;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:61;a:15:{s:2:\"id\";i:13281;s:5:\"title\";s:37:\"Hello Bar | Contact | Interior Design\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2020/04/PopUp.png\";s:12:\"tmpl_created\";i:1586148801;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:130:\"https://library.elementor.com/popups/hello-bar-contact-interior-design/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:19:\"[\"interior design\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:763;s:11:\"trend_index\";i:679;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:62;a:15:{s:2:\"id\";i:9690;s:5:\"title\";s:17:\"Classic | Contact\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2019/01/Classic_Contact_small_01.png\";s:12:\"tmpl_created\";i:1547011716;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/popups/classic-contact-01/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:393;s:11:\"trend_index\";i:571;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:63;a:15:{s:2:\"id\";i:9699;s:5:\"title\";s:33:\"Classic | Contact | Gym | Fitness\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2019/01/Classic_Contact_small_02.png\";s:12:\"tmpl_created\";i:1547015827;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/popups/classic-contact-02/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:475;s:11:\"trend_index\";i:527;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:64;a:15:{s:2:\"id\";i:9571;s:5:\"title\";s:14:\"Fly In | Login\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2019/01/FlyIn_Login_01_small.png\";s:12:\"tmpl_created\";i:1547726151;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/popups/fly-in-login-01/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:622;s:11:\"trend_index\";i:538;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:65;a:15:{s:2:\"id\";i:9740;s:5:\"title\";s:25:\"Classic | Promotion | App\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2019/01/app_small.png\";s:12:\"tmpl_created\";i:1547822836;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/popups/classic-promotion-app/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:624;s:11:\"trend_index\";i:691;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:66;a:15:{s:2:\"id\";i:9762;s:5:\"title\";s:36:\"Classic | Register | Subscribe | Spa\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2019/01/spa_small_classic.png\";s:12:\"tmpl_created\";i:1547824145;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:127:\"https://library.elementor.com/popups/classic-register-subscribe-spa/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:463;s:11:\"trend_index\";i:436;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:67;a:15:{s:2:\"id\";i:13413;s:5:\"title\";s:33:\"Classic | Contact | Online Course\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2020/04/PopUp-Help.jpg\";s:12:\"tmpl_created\";i:1587474761;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:126:\"https://library.elementor.com/popups/classic-contact-online-course/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:29:\"[\"Course Online\",\"Education\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:530;s:11:\"trend_index\";i:369;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:68;a:15:{s:2:\"id\";i:9772;s:5:\"title\";s:27:\"Hello bar | Promotion | App\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2019/01/app_hello_small.png\";s:12:\"tmpl_created\";i:1547824279;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.elementor.com/popups/hello-bar-promotion-app/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:760;s:11:\"trend_index\";i:781;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:69;a:15:{s:2:\"id\";i:13402;s:5:\"title\";s:29:\"Classic | CTA | Online Course\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2020/04/Popup-Course-Completed.jpg\";s:12:\"tmpl_created\";i:1587474772;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/popups/classic-cta-online-course/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:29:\"[\"Course Online\",\"Education\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:619;s:11:\"trend_index\";i:582;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:70;a:15:{s:2:\"id\";i:13422;s:5:\"title\";s:30:\"Classic | Menu | Online Course\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2020/04/PopUp-Menu.jpg\";s:12:\"tmpl_created\";i:1587474782;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:123:\"https://library.elementor.com/popups/classic-menu-online-course/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:29:\"[\"Course Online\",\"Education\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:516;s:11:\"trend_index\";i:432;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:71;a:15:{s:2:\"id\";i:9793;s:5:\"title\";s:13:\"Fly In | Sale\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2019/01/flyin_black_small.png\";s:12:\"tmpl_created\";i:1547831151;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/popups/fly-in-sale/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:670;s:11:\"trend_index\";i:742;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:72;a:15:{s:2:\"id\";i:9836;s:5:\"title\";s:21:\"Classic | Login | Pop\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2019/01/login_b_small.png\";s:12:\"tmpl_created\";i:1547835635;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/popups/classic-login/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:634;s:11:\"trend_index\";i:669;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:73;a:15:{s:2:\"id\";i:9847;s:5:\"title\";s:25:\"Fly In | Promotion | Lego\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2019/01/fly_in_promotion_tro.png\";s:12:\"tmpl_created\";i:1547836956;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:113:\"https://library.elementor.com/popups/fly-in-promotion/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:751;s:11:\"trend_index\";i:838;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:74;a:15:{s:2:\"id\";i:9858;s:5:\"title\";s:27:\"Slide In | Promotion | Wine\";s:9:\"thumbnail\";s:90:\"https://library.elementor.com/wp-content/uploads/2019/01/slide-in_promotion_wine_small.png\";s:12:\"tmpl_created\";i:1547837100;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/popups/slide-in-promotion/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:769;s:11:\"trend_index\";i:684;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:75;a:15:{s:2:\"id\";i:13538;s:5:\"title\";s:32:\"Fly-In | Newsletter | Barbershop\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2020/05/Pop-Up-Page-Small.jpg\";s:12:\"tmpl_created\";i:1589893364;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:125:\"https://library.elementor.com/popups/fly-in-newsletter-barbershop/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:28:\"[\"Barber Shop\",\"Barbershop\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:710;s:11:\"trend_index\";i:667;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:76;a:15:{s:2:\"id\";i:9944;s:5:\"title\";s:33:\"Slide In | Promotion | Headphones\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2019/01/slidein_head_small.png\";s:12:\"tmpl_created\";i:1547841939;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/popups/slide-in-promotion-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:757;s:11:\"trend_index\";i:700;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:77;a:15:{s:2:\"id\";i:9955;s:5:\"title\";s:14:\"Fly In | Login\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2019/01/flyin_login_lock_small.png\";s:12:\"tmpl_created\";i:1547842065;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:109:\"https://library.elementor.com/popups/fly-in-login/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:551;s:11:\"trend_index\";i:627;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:78;a:15:{s:2:\"id\";i:9965;s:5:\"title\";s:30:\"Classic | Register | Subscribe\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2019/01/classic_moon_small.png\";s:12:\"tmpl_created\";i:1547842174;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:125:\"https://library.elementor.com/popups/classic-register-subscribe-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:588;s:11:\"trend_index\";i:591;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:79;a:15:{s:2:\"id\";i:9995;s:5:\"title\";s:27:\"Slide In | Sale | Christmas\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2019/01/slidein_christmas_small.png\";s:12:\"tmpl_created\";i:1547844802;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.elementor.com/popups/slide-in-sale-christmas/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:772;s:11:\"trend_index\";i:817;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:80;a:15:{s:2:\"id\";i:10016;s:5:\"title\";s:16:\"Hello Bar | Sale\";s:9:\"thumbnail\";s:90:\"https://library.elementor.com/wp-content/uploads/2019/01/Hello-Bar_Promotion_bag_small.png\";s:12:\"tmpl_created\";i:1547845062;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/popups/hello-bar-sale/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:792;s:11:\"trend_index\";i:0;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:81;a:15:{s:2:\"id\";i:14067;s:5:\"title\";s:37:\"Slide In | Japanese restaurant | Menu\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2020/06/Menu-Pop-Up-Small.jpg\";s:12:\"tmpl_created\";i:1592290352;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:130:\"https://library.elementor.com/popups/slide-in-japanese-restaurant-menu/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:32:\"[\"Food\",\"Japanese\",\"Restaurant\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:650;s:11:\"trend_index\";i:565;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:82;a:15:{s:2:\"id\";i:10026;s:5:\"title\";s:46:\"Classic | Register | Subscribe | Gym | Fitness\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2019/01/classic_register_small.png\";s:12:\"tmpl_created\";i:1547845205;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:125:\"https://library.elementor.com/popups/classic-register-subscribe-3/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:616;s:11:\"trend_index\";i:587;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:83;a:15:{s:2:\"id\";i:10036;s:5:\"title\";s:43:\"Full Screen | Sale | Promotion | Headphones\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2019/01/full_sale_head_small.png\";s:12:\"tmpl_created\";i:1547845409;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:123:\"https://library.elementor.com/popups/full-screen-sale-promotion/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:614;s:11:\"trend_index\";i:717;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:84;a:15:{s:2:\"id\";i:14111;s:5:\"title\";s:36:\"Classic | Japanese restaurant | Sale\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2020/06/Pop-Up-Page-Small.jpg\";s:12:\"tmpl_created\";i:1592300400;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:129:\"https://library.elementor.com/popups/classic-japanese-restaurant-sale/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:32:\"[\"Food\",\"Japanese\",\"Restaurant\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:717;s:11:\"trend_index\";i:697;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:85;a:15:{s:2:\"id\";i:10057;s:5:\"title\";s:48:\"Hello Bar | Register | Subscribe | Gym | Fitness\";s:9:\"thumbnail\";s:91:\"https://library.elementor.com/wp-content/uploads/2019/01/hello-bar_register_sport_small.png\";s:12:\"tmpl_created\";i:1547847938;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:125:\"https://library.elementor.com/popups/hello-bar-register-subscribe/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:764;s:11:\"trend_index\";i:0;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:86;a:15:{s:2:\"id\";i:10087;s:5:\"title\";s:25:\"Full Screen | Login | Spa\";s:9:\"thumbnail\";s:88:\"https://library.elementor.com/wp-content/uploads/2019/01/full-screen_login_spa_small.png\";s:12:\"tmpl_created\";i:1547848301;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/popups/full-screen-login-spa/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:644;s:11:\"trend_index\";i:632;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:87;a:15:{s:2:\"id\";i:10097;s:5:\"title\";s:37:\"Classic | Register | Subscribe | Lego\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2019/01/classic_lego_small.png\";s:12:\"tmpl_created\";i:1547848411;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:125:\"https://library.elementor.com/popups/classic-register-subscribe-4/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:689;s:11:\"trend_index\";i:758;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:88;a:15:{s:2:\"id\";i:1190;s:5:\"title\";s:26:\"Landing Page &#8211; Hotel\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2017/03/lp2-l.png\";s:12:\"tmpl_created\";i:1490707391;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/landing-page-hotel/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:17:\"[\"Landing Pages\"]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:2;s:11:\"trend_index\";i:1;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:89;a:15:{s:2:\"id\";i:9816;s:5:\"title\";s:30:\"Classic | Sale | Gym | Fitness\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2019/01/classic_sale_sport_small.png\";s:12:\"tmpl_created\";i:1547991876;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/popups/classic-sale-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:720;s:11:\"trend_index\";i:823;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:90;a:15:{s:2:\"id\";i:16645;s:5:\"title\";s:28:\"Headphones &#8211; eCommerce\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2021/01/lp_headphones.png\";s:12:\"tmpl_created\";i:1609944115;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/lp/commerce-headphones/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:9:\"eCommerce\";s:4:\"tags\";s:39:\"[\"Ecommerce\",\"Landing Pages\",\"Product\"]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:633;s:11:\"trend_index\";i:87;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:91;a:15:{s:2:\"id\";i:8505;s:5:\"title\";s:11:\"404 page 01\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2018/05/001.jpg\";s:12:\"tmpl_created\";i:1526415501;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/404-page-01/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:533;s:11:\"trend_index\";i:222;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:92;a:15:{s:2:\"id\";i:9602;s:5:\"title\";s:35:\"Bottom Bar | Announcement | Cookies\";s:9:\"thumbnail\";s:92:\"https://library.elementor.com/wp-content/uploads/2019/01/Bottombar_Announcement_small_01.png\";s:12:\"tmpl_created\";i:1546964559;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:123:\"https://library.elementor.com/popups/bottom-bar-announcement-01/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:10:\"bottom bar\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:600;s:11:\"trend_index\";i:604;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:93;a:15:{s:2:\"id\";i:225;s:5:\"title\";s:27:\"Homepage &#8211; Restaurant\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2016/08/0016.png\";s:12:\"tmpl_created\";i:1470829872;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:109:\"https://library.elementor.com/homepage-restaurant/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:32:\"[\"Food\",\"Homepage\",\"Restaurant\"]\";s:10:\"menu_order\";i:2;s:16:\"popularity_index\";i:1;s:11:\"trend_index\";i:2;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:94;a:15:{s:2:\"id\";i:16762;s:5:\"title\";s:25:\"Conference &#8211; Events\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2021/01/Conference.png\";s:12:\"tmpl_created\";i:1610455119;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/lp/conference-events/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:6:\"Events\";s:4:\"tags\";s:60:\"[\"Conference\",\"Convention\",\"Event\",\"Events\",\"Landing Pages\"]\";s:10:\"menu_order\";i:2;s:16:\"popularity_index\";i:705;s:11:\"trend_index\";i:216;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:95;a:15:{s:2:\"id\";i:8511;s:5:\"title\";s:11:\"404 page 02\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2018/05/002.jpg\";s:12:\"tmpl_created\";i:1526415528;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/404-page-02/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:2;s:16:\"popularity_index\";i:347;s:11:\"trend_index\";i:155;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:96;a:15:{s:2:\"id\";i:463;s:5:\"title\";s:22:\"Homepage &#8211; Study\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2016/10/0022.png\";s:12:\"tmpl_created\";i:1477388340;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:104:\"https://library.elementor.com/homepage-study/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:32:\"[\"Education\",\"Homepage\",\"Study\"]\";s:10:\"menu_order\";i:3;s:16:\"popularity_index\";i:4;s:11:\"trend_index\";i:3;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:97;a:15:{s:2:\"id\";i:10277;s:5:\"title\";s:36:\"Bottom Bar | Promotion | Sale | Book\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2019/01/book_small.png\";s:12:\"tmpl_created\";i:1548055999;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/popups/bottom-bar-promotion-book/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:10:\"bottom bar\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:3;s:16:\"popularity_index\";i:729;s:11:\"trend_index\";i:802;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:98;a:15:{s:2:\"id\";i:11241;s:5:\"title\";s:36:\"Classic | Digital Agency | Marketing\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2019/07/PopUp_small.jpg\";s:12:\"tmpl_created\";i:1564643043;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:129:\"https://library.elementor.com/popups/classic-digital-agency-marketing/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:3;s:16:\"popularity_index\";i:362;s:11:\"trend_index\";i:315;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:99;a:15:{s:2:\"id\";i:8512;s:5:\"title\";s:11:\"404 page 03\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2018/05/003.jpg\";s:12:\"tmpl_created\";i:1526415449;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/404-page-03/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:3;s:16:\"popularity_index\";i:450;s:11:\"trend_index\";i:375;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:100;a:15:{s:2:\"id\";i:18701;s:5:\"title\";s:32:\"Digital Course &#8211; eCommerce\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2021/04/250x280.jpg\";s:12:\"tmpl_created\";i:1618995134;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/lp/digital-course-ecommerce/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:9:\"eCommerce\";s:4:\"tags\";s:57:\"[\"Course Online\",\"Ecommerce\",\"Landing Pages\",\"Marketing\"]\";s:10:\"menu_order\";i:3;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:101;a:15:{s:2:\"id\";i:181;s:5:\"title\";s:23:\"Homepage &#8211; Agency\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2016/08/0019.png\";s:12:\"tmpl_created\";i:1470826567;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:105:\"https://library.elementor.com/homepage-agency/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:32:\"[\"Agency\",\"Creative\",\"Homepage\"]\";s:10:\"menu_order\";i:4;s:16:\"popularity_index\";i:3;s:11:\"trend_index\";i:4;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:102;a:15:{s:2:\"id\";i:8513;s:5:\"title\";s:11:\"404 page 04\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2018/05/004.jpg\";s:12:\"tmpl_created\";i:1526415417;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/404-page-04/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:4;s:16:\"popularity_index\";i:420;s:11:\"trend_index\";i:176;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:103;a:15:{s:2:\"id\";i:18612;s:5:\"title\";s:34:\"Bag Product Sale &#8211; eCommerce\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2021/04/Library-Pic-Bag-Product.jpeg\";s:12:\"tmpl_created\";i:1618395406;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/lp/bag-product-sale-ecommerce/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:9:\"eCommerce\";s:4:\"tags\";s:61:\"[\"Bag\",\"Ecommerce\",\"Landing Pages\",\"Product\",\"Sale\",\"Travel\"]\";s:10:\"menu_order\";i:4;s:16:\"popularity_index\";i:875;s:11:\"trend_index\";i:605;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:104;a:15:{s:2:\"id\";i:9903;s:5:\"title\";s:34:\"Bottom Bar | Promotion | Olive Oil\";s:9:\"thumbnail\";s:93:\"https://library.elementor.com/wp-content/uploads/2019/01/bottom-bar_promotion_olive_small.png\";s:12:\"tmpl_created\";i:1547838896;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/popups/bottom-bar-promotion/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:10:\"bottom bar\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:4;s:16:\"popularity_index\";i:765;s:11:\"trend_index\";i:840;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:105;a:15:{s:2:\"id\";i:150;s:5:\"title\";s:19:\"Product &#8211; App\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2016/08/0003.png\";s:12:\"tmpl_created\";i:1470829879;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:101:\"https://library.elementor.com/product-app/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:5;s:16:\"popularity_index\";i:6;s:11:\"trend_index\";i:5;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:106;a:15:{s:2:\"id\";i:8514;s:5:\"title\";s:11:\"404 Page 05\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2018/05/005.jpg\";s:12:\"tmpl_created\";i:1526415558;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/404-page-05/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:5;s:16:\"popularity_index\";i:419;s:11:\"trend_index\";i:220;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:107;a:15:{s:2:\"id\";i:18644;s:5:\"title\";s:37:\"Camera Product Sale &#8211; eCommerce\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2021/04/camera_sale_featured-img.jpg\";s:12:\"tmpl_created\";i:1618396388;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/lp/camera-product-sale-ecommerce/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:9:\"eCommerce\";s:4:\"tags\";s:59:\"[\"Camera\",\"Ecommerce\",\"Landing Pages\",\"Photography\",\"Sale\"]\";s:10:\"menu_order\";i:5;s:16:\"popularity_index\";i:873;s:11:\"trend_index\";i:535;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:108;a:15:{s:2:\"id\";i:10549;s:5:\"title\";s:33:\"Bottom Bar | Register | Subscribe\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2019/01/com_small.png\";s:12:\"tmpl_created\";i:1547967595;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:126:\"https://library.elementor.com/popups/bottom-bar-register-subscribe/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:10:\"bottom bar\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:6;s:16:\"popularity_index\";i:713;s:11:\"trend_index\";i:666;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:109;a:15:{s:2:\"id\";i:8523;s:5:\"title\";s:11:\"404 page 06\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2018/05/006.jpg\";s:12:\"tmpl_created\";i:1526415291;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/404-page-06/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:6;s:16:\"popularity_index\";i:298;s:11:\"trend_index\";i:268;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:110;a:15:{s:2:\"id\";i:18815;s:5:\"title\";s:25:\"Car Wash &#8211; Business\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2021/05/Library-Pic-Car-Wash.png\";s:12:\"tmpl_created\";i:1621336431;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/lp/car-wash-business/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:45:\"[\"Business\",\"car\",\"Discount\",\"Landing Pages\"]\";s:10:\"menu_order\";i:6;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:111;a:15:{s:2:\"id\";i:19144;s:5:\"title\";s:25:\"Birthday Party Invitation\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2021/06/250x280.png\";s:12:\"tmpl_created\";i:1623848691;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/birthday-party-invitation/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:67:\"[\"Birthday\",\"Event\",\"Landing Pages\",\"Party\",\"RSVD\",\"Save the Date\"]\";s:10:\"menu_order\";i:6;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:112;a:15:{s:2:\"id\";i:16473;s:5:\"title\";s:26:\"Beauty Salon &#8211; About\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2020/12/about-1.jpg\";s:12:\"tmpl_created\";i:1608622373;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/beauty-salon-about/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:23:\"[\"Beauty salon\",\"hair\"]\";s:10:\"menu_order\";i:7;s:16:\"popularity_index\";i:615;s:11:\"trend_index\";i:184;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:113;a:15:{s:2:\"id\";i:8524;s:5:\"title\";s:11:\"404 page 07\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2018/05/007.jpg\";s:12:\"tmpl_created\";i:1526415337;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/404-page-07/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:7;s:16:\"popularity_index\";i:303;s:11:\"trend_index\";i:171;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:114;a:15:{s:2:\"id\";i:18824;s:5:\"title\";s:33:\"Design School &#8211; Coming Soon\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2021/05/250x280-1.png\";s:12:\"tmpl_created\";i:1621336756;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/lp/design-school-coming-soon/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:16:\"Coming Soon Page\";s:4:\"tags\";s:49:\"[\"Coming Soon\",\"Design\",\"Landing Pages\",\"School\"]\";s:10:\"menu_order\";i:7;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:115;a:15:{s:2:\"id\";i:16488;s:5:\"title\";s:28:\"Beauty Salon &#8211; Contact\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2020/12/contact.jpg\";s:12:\"tmpl_created\";i:1608622374;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/beauty-salon-contact/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:23:\"[\"Beauty salon\",\"hair\"]\";s:10:\"menu_order\";i:8;s:16:\"popularity_index\";i:548;s:11:\"trend_index\";i:101;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:116;a:15:{s:2:\"id\";i:8526;s:5:\"title\";s:11:\"404 page 09\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2018/05/009.jpg\";s:12:\"tmpl_created\";i:1526415474;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/404-page-09/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:8;s:16:\"popularity_index\";i:477;s:11:\"trend_index\";i:285;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:117;a:15:{s:2:\"id\";i:18819;s:5:\"title\";s:27:\"Dog Walker &#8211; Business\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2021/05/Library-Pic-Dog-Walker.png\";s:12:\"tmpl_created\";i:1621336601;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/lp/dog-walker-business/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:41:\"[\"Business\",\"Dog\",\"Landing Pages\",\"Pets\"]\";s:10:\"menu_order\";i:8;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:118;a:15:{s:2:\"id\";i:10529;s:5:\"title\";s:36:\"Classic | Announcement | Maintenance\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2019/01/icon_small.png\";s:12:\"tmpl_created\";i:1548046309;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/popups/classic-announcement/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:9;s:16:\"popularity_index\";i:474;s:11:\"trend_index\";i:398;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:119;a:15:{s:2:\"id\";i:16496;s:5:\"title\";s:28:\"Beauty Salon &#8211; Gallery\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2020/12/gallery-1.jpg\";s:12:\"tmpl_created\";i:1608622379;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/beauty-salon-gallery/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:23:\"[\"Beauty salon\",\"hair\"]\";s:10:\"menu_order\";i:9;s:16:\"popularity_index\";i:491;s:11:\"trend_index\";i:90;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:120;a:15:{s:2:\"id\";i:8525;s:5:\"title\";s:11:\"404 page 08\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2018/05/008.jpg\";s:12:\"tmpl_created\";i:1526415374;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/404-page-08/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:9;s:16:\"popularity_index\";i:510;s:11:\"trend_index\";i:575;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:121;a:15:{s:2:\"id\";i:18761;s:5:\"title\";s:33:\"Fashion Store &#8211; Coming Soon\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2021/05/Library-Pic-Fashion-Store.png\";s:12:\"tmpl_created\";i:1621336146;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/lp/fashion-store-coming-soon/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:16:\"Coming Soon Page\";s:4:\"tags\";s:56:\"[\"Coming Soon\",\"Fashion\",\"Landing Pages\",\"Shop\",\"store\"]\";s:10:\"menu_order\";i:9;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:122;a:15:{s:2:\"id\";i:16457;s:5:\"title\";s:25:\"Beauty Salon &#8211; Home\";s:9:\"thumbnail\";s:67:\"https://library.elementor.com/wp-content/uploads/2020/12/home-1.jpg\";s:12:\"tmpl_created\";i:1608622383;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/beauty-salon-home/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:23:\"[\"Beauty salon\",\"hair\"]\";s:10:\"menu_order\";i:10;s:16:\"popularity_index\";i:408;s:11:\"trend_index\";i:56;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:123;a:15:{s:2:\"id\";i:5438;s:5:\"title\";s:7:\"About 1\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/about_black_4.png\";s:12:\"tmpl_created\";i:1520443512;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:104:\"https://library.elementor.com/blocks/about-1/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:10;s:16:\"popularity_index\";i:147;s:11:\"trend_index\";i:9;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:124;a:15:{s:2:\"id\";i:6135;s:5:\"title\";s:8:\"About 10\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/about_black_2.png\";s:12:\"tmpl_created\";i:1520443663;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:105:\"https://library.elementor.com/blocks/about-10/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:11;s:16:\"popularity_index\";i:77;s:11:\"trend_index\";i:47;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:125;a:15:{s:2:\"id\";i:16518;s:5:\"title\";s:29:\"Beauty Salon &#8211; Services\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2020/12/services-1.jpg\";s:12:\"tmpl_created\";i:1608622386;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/beauty-salon-services/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:23:\"[\"Beauty salon\",\"hair\"]\";s:10:\"menu_order\";i:11;s:16:\"popularity_index\";i:664;s:11:\"trend_index\";i:261;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:126;a:15:{s:2:\"id\";i:17060;s:5:\"title\";s:36:\"Private Tutor &#8211; Online Service\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2021/01/Online-Tutor-2.png\";s:12:\"tmpl_created\";i:1610631042;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:121:\"https://library.elementor.com/lp/private-tutor-online-service/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:14:\"Online Service\";s:4:\"tags\";s:64:\"[\"Education\",\"Landing Pages\",\"Online Service\",\"Teacher\",\"Tutor\"]\";s:10:\"menu_order\";i:11;s:16:\"popularity_index\";i:780;s:11:\"trend_index\";i:628;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:127;a:15:{s:2:\"id\";i:15486;s:5:\"title\";s:25:\"Travel Blog &#8211; About\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2020/11/About.jpg\";s:12:\"tmpl_created\";i:1606215720;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/travel-blog-about/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:17:\"[\"Blog\",\"Travel\"]\";s:10:\"menu_order\";i:12;s:16:\"popularity_index\";i:608;s:11:\"trend_index\";i:343;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:128;a:15:{s:2:\"id\";i:17232;s:5:\"title\";s:33:\"Life Coach &#8211; Online Service\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2021/01/Life-Coach.png\";s:12:\"tmpl_created\";i:1610902793;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/lp/life-coach-online-service/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:14:\"Online Service\";s:4:\"tags\";s:38:\"[\"Coach\",\"Landing Pages\",\"Life Coach\"]\";s:10:\"menu_order\";i:12;s:16:\"popularity_index\";i:787;s:11:\"trend_index\";i:751;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:129;a:15:{s:2:\"id\";i:5397;s:5:\"title\";s:8:\"About 11\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/about_white_1.png\";s:12:\"tmpl_created\";i:1520443503;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:105:\"https://library.elementor.com/blocks/about-11/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:12;s:16:\"popularity_index\";i:148;s:11:\"trend_index\";i:43;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:130;a:15:{s:2:\"id\";i:15478;s:5:\"title\";s:27:\"Travel Blog &#8211; Contact\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2020/11/Contact-Us.jpg\";s:12:\"tmpl_created\";i:1606215735;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:109:\"https://library.elementor.com/travel-blog-contact/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:17:\"[\"Blog\",\"Travel\"]\";s:10:\"menu_order\";i:13;s:16:\"popularity_index\";i:687;s:11:\"trend_index\";i:564;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:131;a:15:{s:2:\"id\";i:16932;s:5:\"title\";s:35:\"Finance Consulting &#8211; Business\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2021/01/Finance-Consulting.png\";s:12:\"tmpl_created\";i:1610532170;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.elementor.com/lp/finance-consulting-business/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:80:\"[\"Advisor\",\"Business\",\"Consulting\",\"Finance\",\"Investment\",\"Landing Pages\",\"Tax\"]\";s:10:\"menu_order\";i:13;s:16:\"popularity_index\";i:790;s:11:\"trend_index\";i:630;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:132;a:15:{s:2:\"id\";i:5405;s:5:\"title\";s:8:\"About 12\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/about_black_1.png\";s:12:\"tmpl_created\";i:1520443505;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:105:\"https://library.elementor.com/blocks/about-12/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:13;s:16:\"popularity_index\";i:216;s:11:\"trend_index\";i:50;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:133;a:15:{s:2:\"id\";i:15467;s:5:\"title\";s:24:\"Travel Blog &#8211; Home\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2020/11/Home.jpg\";s:12:\"tmpl_created\";i:1606215756;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/travel-blog-home/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:17:\"[\"Blog\",\"Travel\"]\";s:10:\"menu_order\";i:14;s:16:\"popularity_index\";i:567;s:11:\"trend_index\";i:224;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:134;a:15:{s:2:\"id\";i:16721;s:5:\"title\";s:35:\"Dental &#8211; Health &amp; Fitness\";s:9:\"thumbnail\";s:67:\"https://library.elementor.com/wp-content/uploads/2021/01/Dental.jpg\";s:12:\"tmpl_created\";i:1610448567;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/lp/dental-health-fitness/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:18:\"Health and Fitness\";s:4:\"tags\";s:44:\"[\"Dental\",\"Doctor\",\"Health\",\"Landing Pages\"]\";s:10:\"menu_order\";i:14;s:16:\"popularity_index\";i:801;s:11:\"trend_index\";i:655;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:135;a:15:{s:2:\"id\";i:5421;s:5:\"title\";s:8:\"About 13\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/about_white_3.png\";s:12:\"tmpl_created\";i:1520443509;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:105:\"https://library.elementor.com/blocks/about-13/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:14;s:16:\"popularity_index\";i:215;s:11:\"trend_index\";i:77;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:136;a:15:{s:2:\"id\";i:5533;s:5:\"title\";s:8:\"About 15\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2018/03/about_black_10.png\";s:12:\"tmpl_created\";i:1520443534;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:105:\"https://library.elementor.com/blocks/about-15/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:15;s:16:\"popularity_index\";i:21;s:11:\"trend_index\";i:57;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:137;a:15:{s:2:\"id\";i:15317;s:5:\"title\";s:25:\"Dance Studio &#8211; Home\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2020/10/Home.jpg\";s:12:\"tmpl_created\";i:1603181291;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/dance-studio-home/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:16:\"[\"dance studio\"]\";s:10:\"menu_order\";i:15;s:16:\"popularity_index\";i:596;s:11:\"trend_index\";i:301;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:138;a:15:{s:2:\"id\";i:17269;s:5:\"title\";s:34:\"Electronics Sale &#8211; eCommerce\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2021/01/Electronic-Products.png\";s:12:\"tmpl_created\";i:1610903298;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/lp/electronics-sale-ecommerce/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:9:\"eCommerce\";s:4:\"tags\";s:29:\"[\"Ecommerce\",\"Landing Pages\"]\";s:10:\"menu_order\";i:15;s:16:\"popularity_index\";i:800;s:11:\"trend_index\";i:556;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:139;a:15:{s:2:\"id\";i:5525;s:5:\"title\";s:8:\"About 14\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2018/03/about_white_10.png\";s:12:\"tmpl_created\";i:1520443532;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:105:\"https://library.elementor.com/blocks/about-14/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:16;s:16:\"popularity_index\";i:9;s:11:\"trend_index\";i:29;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:140;a:15:{s:2:\"id\";i:15334;s:5:\"title\";s:26:\"Dance Studio &#8211; About\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2020/10/About.jpg\";s:12:\"tmpl_created\";i:1603181364;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/dance-studio-about/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:16:\"[\"dance studio\"]\";s:10:\"menu_order\";i:16;s:16:\"popularity_index\";i:626;s:11:\"trend_index\";i:373;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:141;a:15:{s:2:\"id\";i:17032;s:5:\"title\";s:42:\"Donate Computer &#8211; Social Involvement\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2021/01/Donation-2.png\";s:12:\"tmpl_created\";i:1610630585;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:127:\"https://library.elementor.com/lp/donate-computer-social-involvement/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:18:\"Social Involvement\";s:4:\"tags\";s:67:\"[\"Computer\",\"Donate\",\"Donation\",\"Kids\",\"Landing Pages\",\"Nonprofit\"]\";s:10:\"menu_order\";i:16;s:16:\"popularity_index\";i:718;s:11:\"trend_index\";i:278;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:142;a:15:{s:2:\"id\";i:10413;s:5:\"title\";s:28:\"Classic | Content Lock | Pop\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2019/01/hot_small.png\";s:12:\"tmpl_created\";i:1547961774;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/popups/classic-content-lock/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:17;s:16:\"popularity_index\";i:752;s:11:\"trend_index\";i:813;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:143;a:15:{s:2:\"id\";i:15349;s:5:\"title\";s:28:\"Dance Studio &#8211; Classes\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2020/10/Classes.jpg\";s:12:\"tmpl_created\";i:1603181425;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/dance-studio-classes/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:16:\"[\"dance studio\"]\";s:10:\"menu_order\";i:17;s:16:\"popularity_index\";i:629;s:11:\"trend_index\";i:458;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:144;a:15:{s:2:\"id\";i:16684;s:5:\"title\";s:34:\"SaaS HR Management &#8211; Product\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2021/01/lp_hr.png\";s:12:\"tmpl_created\";i:1609945486;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/lp/saas-hr-management-product/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:7:\"Product\";s:4:\"tags\";s:39:\"[\"HR\",\"Landing Pages\",\"Product\",\"SaaS\"]\";s:10:\"menu_order\";i:17;s:16:\"popularity_index\";i:708;s:11:\"trend_index\";i:292;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:145;a:15:{s:2:\"id\";i:5429;s:5:\"title\";s:8:\"About 16\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/about_white_4.png\";s:12:\"tmpl_created\";i:1520443510;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:105:\"https://library.elementor.com/blocks/about-16/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:17;s:16:\"popularity_index\";i:59;s:11:\"trend_index\";i:8;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:146;a:15:{s:2:\"id\";i:15366;s:5:\"title\";s:29:\"Dance Studio &#8211; Schedule\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2020/10/Classes-Schedule.jpg\";s:12:\"tmpl_created\";i:1603181056;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/dance-studio-schedule/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:16:\"[\"dance studio\"]\";s:10:\"menu_order\";i:18;s:16:\"popularity_index\";i:698;s:11:\"trend_index\";i:602;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:147;a:15:{s:2:\"id\";i:16660;s:5:\"title\";s:37:\"Medical center &#8211; Online service\";s:9:\"thumbnail\";s:95:\"https://library.elementor.com/wp-content/uploads/2021/01/Online-medical-cosultation-250_280.png\";s:12:\"tmpl_created\";i:1609945122;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/lp/medical-center-online-service/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:14:\"Online Service\";s:4:\"tags\";s:44:\"[\"Landing Pages\",\"medical\",\"Online Service\"]\";s:10:\"menu_order\";i:18;s:16:\"popularity_index\";i:750;s:11:\"trend_index\";i:332;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:148;a:15:{s:2:\"id\";i:5464;s:5:\"title\";s:8:\"About 17\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/about_black_6.png\";s:12:\"tmpl_created\";i:1520443518;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:105:\"https://library.elementor.com/blocks/about-17/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:18;s:16:\"popularity_index\";i:220;s:11:\"trend_index\";i:142;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:149;a:15:{s:2:\"id\";i:10223;s:5:\"title\";s:15:\"Classic | Login\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2019/01/welcome_small.png\";s:12:\"tmpl_created\";i:1547887343;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/popups/classic-login-4/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:19;s:16:\"popularity_index\";i:497;s:11:\"trend_index\";i:503;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:150;a:15:{s:2:\"id\";i:15373;s:5:\"title\";s:28:\"Dance Studio &#8211; Pricing\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2020/10/Pricing.jpg\";s:12:\"tmpl_created\";i:1603181678;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/dance-studio-pricing/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:16:\"[\"dance studio\"]\";s:10:\"menu_order\";i:19;s:16:\"popularity_index\";i:731;s:11:\"trend_index\";i:661;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:151;a:15:{s:2:\"id\";i:10559;s:5:\"title\";s:33:\"Bottom Bar | Register | Subscribe\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2019/01/fly_small.png\";s:12:\"tmpl_created\";i:1547967711;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:128:\"https://library.elementor.com/popups/bottom-bar-register-subscribe-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:10:\"bottom bar\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:19;s:16:\"popularity_index\";i:714;s:11:\"trend_index\";i:729;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:152;a:15:{s:2:\"id\";i:17001;s:5:\"title\";s:36:\"Parental Counseling &#8211; Business\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2021/01/Parenting-Coach-2.png\";s:12:\"tmpl_created\";i:1610534999;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:121:\"https://library.elementor.com/lp/parental-counseling-business/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:99:\"[\"Advisor\",\"Business\",\"Coach\",\"Counseling\",\"Landing Pages\",\"Online Service\",\"Parental\",\"Parenting\"]\";s:10:\"menu_order\";i:19;s:16:\"popularity_index\";i:817;s:11:\"trend_index\";i:0;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:153;a:15:{s:2:\"id\";i:5504;s:5:\"title\";s:8:\"About 18\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/about_white_9.png\";s:12:\"tmpl_created\";i:1520443528;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:105:\"https://library.elementor.com/blocks/about-18/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:19;s:16:\"popularity_index\";i:104;s:11:\"trend_index\";i:46;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:154;a:15:{s:2:\"id\";i:15384;s:5:\"title\";s:28:\"Dance Studio &#8211; Contact\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2020/10/Contact-Us.jpg\";s:12:\"tmpl_created\";i:1603181738;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/dance-studio-contact/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:16:\"[\"dance studio\"]\";s:10:\"menu_order\";i:20;s:16:\"popularity_index\";i:741;s:11:\"trend_index\";i:721;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:155;a:15:{s:2:\"id\";i:10403;s:5:\"title\";s:15:\"Classic | Login\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2019/01/hello_small.png\";s:12:\"tmpl_created\";i:1548056371;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/popups/classic-login-5/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:20;s:16:\"popularity_index\";i:627;s:11:\"trend_index\";i:659;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:156;a:15:{s:2:\"id\";i:16742;s:5:\"title\";s:31:\"Online Course &#8211; Education\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2021/01/Online-Course.png\";s:12:\"tmpl_created\";i:1610454122;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/lp/online-course-education/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:9:\"Education\";s:4:\"tags\";s:55:\"[\"Academy\",\"Course Online\",\"Education\",\"Landing Pages\"]\";s:10:\"menu_order\";i:20;s:16:\"popularity_index\";i:777;s:11:\"trend_index\";i:776;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:157;a:15:{s:2:\"id\";i:5515;s:5:\"title\";s:8:\"About 19\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/about_black_9.png\";s:12:\"tmpl_created\";i:1520443530;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:105:\"https://library.elementor.com/blocks/about-19/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:20;s:16:\"popularity_index\";i:268;s:11:\"trend_index\";i:161;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:158;a:15:{s:2:\"id\";i:15158;s:5:\"title\";s:26:\"Psychologist &#8211; About\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2020/09/About.jpg\";s:12:\"tmpl_created\";i:1600157561;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/psychologist-about/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:34:\"[\"Psychologist\",\"Psychotherapist\"]\";s:10:\"menu_order\";i:21;s:16:\"popularity_index\";i:618;s:11:\"trend_index\";i:426;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:159;a:15:{s:2:\"id\";i:17284;s:5:\"title\";s:38:\"Dietitian &#8211; Health &amp; Fitness\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2021/01/Dietitian.png\";s:12:\"tmpl_created\";i:1610903484;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/lp/dietitian-health-fitness/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:18:\"Health and Fitness\";s:4:\"tags\";s:39:\"[\"Fitness\",\"Health\",\"landscape design\"]\";s:10:\"menu_order\";i:21;s:16:\"popularity_index\";i:814;s:11:\"trend_index\";i:800;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:160;a:15:{s:2:\"id\";i:9913;s:5:\"title\";s:27:\"Classic | Login | Christmas\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2019/01/log_small.png\";s:12:\"tmpl_created\";i:1547841430;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/popups/classic-login-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:21;s:16:\"popularity_index\";i:542;s:11:\"trend_index\";i:417;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:161;a:15:{s:2:\"id\";i:5472;s:5:\"title\";s:7:\"About 2\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/about_white_7.png\";s:12:\"tmpl_created\";i:1520443520;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:104:\"https://library.elementor.com/blocks/about-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:21;s:16:\"popularity_index\";i:210;s:11:\"trend_index\";i:116;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:162;a:15:{s:2:\"id\";i:15197;s:5:\"title\";s:28:\"Psychologist &#8211; Contact\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2020/09/Contact-Us.jpg\";s:12:\"tmpl_created\";i:1600160499;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/psychologist-contact/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:34:\"[\"Psychologist\",\"Psychotherapist\"]\";s:10:\"menu_order\";i:22;s:16:\"popularity_index\";i:666;s:11:\"trend_index\";i:558;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:163;a:15:{s:2:\"id\";i:16897;s:5:\"title\";s:30:\"Personal Chef &#8211; Business\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2021/01/Personal-Chef.png\";s:12:\"tmpl_created\";i:1610466247;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/lp/personal-chef-business/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:53:\"[\"Business\",\"Chef\",\"Food\",\"Landing Pages\",\"Services\"]\";s:10:\"menu_order\";i:22;s:16:\"popularity_index\";i:795;s:11:\"trend_index\";i:617;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:164;a:15:{s:2:\"id\";i:5455;s:5:\"title\";s:8:\"About 20\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/about_white_6.png\";s:12:\"tmpl_created\";i:1520443516;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:105:\"https://library.elementor.com/blocks/about-20/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:22;s:16:\"popularity_index\";i:134;s:11:\"trend_index\";i:70;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:165;a:15:{s:2:\"id\";i:15142;s:5:\"title\";s:25:\"Psychologist &#8211; Home\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2020/09/Home.jpg\";s:12:\"tmpl_created\";i:1600156308;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/psychologist-home/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:34:\"[\"Psychologist\",\"Psychotherapist\"]\";s:10:\"menu_order\";i:23;s:16:\"popularity_index\";i:464;s:11:\"trend_index\";i:297;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:166;a:15:{s:2:\"id\";i:16946;s:5:\"title\";s:52:\"Online Full-Stack Developer Course &#8211; Education\";s:9:\"thumbnail\";s:95:\"https://library.elementor.com/wp-content/uploads/2021/01/Online-Full-Stack-Developer-Course.png\";s:12:\"tmpl_created\";i:1610532778;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:137:\"https://library.elementor.com/lp/online-full-stack-developer-course-education/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:9:\"Education\";s:4:\"tags\";s:76:\"[\"Academy\",\"Coding\",\"Course Online\",\"Developer\",\"Education\",\"Landing Pages\"]\";s:10:\"menu_order\";i:23;s:16:\"popularity_index\";i:805;s:11:\"trend_index\";i:0;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:167;a:15:{s:2:\"id\";i:5413;s:5:\"title\";s:8:\"About 21\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/about_white_2.png\";s:12:\"tmpl_created\";i:1520443507;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:105:\"https://library.elementor.com/blocks/about-21/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:23;s:16:\"popularity_index\";i:83;s:11:\"trend_index\";i:52;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:168;a:15:{s:2:\"id\";i:15188;s:5:\"title\";s:28:\"Psychologist &#8211; Pricing\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2020/09/Pricing.jpg\";s:12:\"tmpl_created\";i:1600159731;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/psychologist-pricing/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:34:\"[\"Psychologist\",\"Psychotherapist\"]\";s:10:\"menu_order\";i:24;s:16:\"popularity_index\";i:732;s:11:\"trend_index\";i:537;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:169;a:15:{s:2:\"id\";i:16868;s:5:\"title\";s:40:\"Virtual Assistant &#8211; Online Service\";s:9:\"thumbnail\";s:88:\"https://library.elementor.com/wp-content/uploads/2021/01/Virtual-Assistant-250x280-1.png\";s:12:\"tmpl_created\";i:1610465656;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:125:\"https://library.elementor.com/lp/virtual-assistant-online-service/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:14:\"Online Service\";s:4:\"tags\";s:46:\"[\"Assistant\",\"Landing Pages\",\"Online Service\"]\";s:10:\"menu_order\";i:24;s:16:\"popularity_index\";i:793;s:11:\"trend_index\";i:757;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:170;a:15:{s:2:\"id\";i:5447;s:5:\"title\";s:7:\"About 3\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/about_white_5.png\";s:12:\"tmpl_created\";i:1520443514;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/about-3-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:24;s:16:\"popularity_index\";i:48;s:11:\"trend_index\";i:12;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:171;a:15:{s:2:\"id\";i:15167;s:5:\"title\";s:29:\"Psychologist &#8211; Services\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2020/09/Services.jpg\";s:12:\"tmpl_created\";i:1600158206;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/psychologist-services/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:34:\"[\"Psychologist\",\"Psychotherapist\"]\";s:10:\"menu_order\";i:25;s:16:\"popularity_index\";i:606;s:11:\"trend_index\";i:379;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:172;a:15:{s:2:\"id\";i:16812;s:5:\"title\";s:40:\"Construction Project &#8211; Real Estate\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2021/01/Construction-Project.png\";s:12:\"tmpl_created\";i:1610463582;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:125:\"https://library.elementor.com/lp/construction-project-real-estate/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:11:\"Real Estate\";s:4:\"tags\";s:59:\"[\"Construction\",\"Landing Pages\",\"Real estate\",\"Realestate\"]\";s:10:\"menu_order\";i:25;s:16:\"popularity_index\";i:796;s:11:\"trend_index\";i:724;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:173;a:15:{s:2:\"id\";i:5480;s:5:\"title\";s:7:\"About 4\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/about_black_7-1.png\";s:12:\"tmpl_created\";i:1520443522;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/about-4-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:25;s:16:\"popularity_index\";i:428;s:11:\"trend_index\";i:303;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:174;a:15:{s:2:\"id\";i:14932;s:5:\"title\";s:30:\"Flooring Company &#8211; About\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2020/08/About.png\";s:12:\"tmpl_created\";i:1597740110;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/flooring-company-about/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:39:\"[\"Flooring company\",\"Flooring website\"]\";s:10:\"menu_order\";i:26;s:16:\"popularity_index\";i:488;s:11:\"trend_index\";i:319;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:175;a:15:{s:2:\"id\";i:6027;s:5:\"title\";s:7:\"About 5\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/about_white_1-1.png\";s:12:\"tmpl_created\";i:1520443639;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/about-5-3/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:26;s:16:\"popularity_index\";i:40;s:11:\"trend_index\";i:40;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:176;a:15:{s:2:\"id\";i:16960;s:5:\"title\";s:44:\"Dog &amp; Cat Food Delivery &#8211; Business\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2021/01/Dog-Food.png\";s:12:\"tmpl_created\";i:1610533581;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:123:\"https://library.elementor.com/lp/dog-cat-food-delivery-business/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:71:\"[\"Business\",\"Cat\",\"Delivery\",\"Dog\",\"Food\",\"Landing Pages\",\"Pet\",\"Pets\"]\";s:10:\"menu_order\";i:26;s:16:\"popularity_index\";i:782;s:11:\"trend_index\";i:510;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:177;a:15:{s:2:\"id\";i:9592;s:5:\"title\";s:26:\"Classic | Promotion | Sale\";s:9:\"thumbnail\";s:87:\"https://library.elementor.com/wp-content/uploads/2019/01/Classic_Promotion_small_01.png\";s:12:\"tmpl_created\";i:1546963720;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/popups/classic-promotion-01/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:26;s:16:\"popularity_index\";i:663;s:11:\"trend_index\";i:807;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:178;a:15:{s:2:\"id\";i:10210;s:5:\"title\";s:29:\"Classic | Promotion | Webinar\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2019/01/web_small-1.png\";s:12:\"tmpl_created\";i:1547886103;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/popups/classic-promotion-webinar/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:27;s:16:\"popularity_index\";i:784;s:11:\"trend_index\";i:0;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:179;a:15:{s:2:\"id\";i:14998;s:5:\"title\";s:32:\"Flooring Company &#8211; Contact\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2020/08/Contact-Us.png\";s:12:\"tmpl_created\";i:1597740222;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/flooring-company-contact/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:39:\"[\"Flooring company\",\"Flooring website\"]\";s:10:\"menu_order\";i:27;s:16:\"popularity_index\";i:553;s:11:\"trend_index\";i:380;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:180;a:15:{s:2:\"id\";i:6036;s:5:\"title\";s:7:\"About 6\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/about_black_1-1.png\";s:12:\"tmpl_created\";i:1520443641;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/about-6-3/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:27;s:16:\"popularity_index\";i:90;s:11:\"trend_index\";i:123;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:181;a:15:{s:2:\"id\";i:17095;s:5:\"title\";s:36:\"Mobile Pet Grooming &#8211; Business\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2021/01/Mobile-Pet-Grooming.png\";s:12:\"tmpl_created\";i:1610632115;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:121:\"https://library.elementor.com/lp/mobile-pet-grooming-business/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:38:\"[\"Dog\",\"Groom\",\"Landing Pages\",\"Pets\"]\";s:10:\"menu_order\";i:27;s:16:\"popularity_index\";i:786;s:11:\"trend_index\";i:731;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:182;a:15:{s:2:\"id\";i:14965;s:5:\"title\";s:32:\"Flooring Company &#8211; Gallery\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2020/08/Gallery.png\";s:12:\"tmpl_created\";i:1597740353;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/flooring-company-gallery/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:39:\"[\"Flooring company\",\"Flooring website\"]\";s:10:\"menu_order\";i:28;s:16:\"popularity_index\";i:371;s:11:\"trend_index\";i:291;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:183;a:15:{s:2:\"id\";i:17245;s:5:\"title\";s:34:\"Marketing Course &#8211; Education\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2021/01/PPC.png\";s:12:\"tmpl_created\";i:1610902958;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/lp/marketing-course-education/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:9:\"Education\";s:4:\"tags\";s:45:\"[\"Course Online\",\"Landing Pages\",\"Marketing\"]\";s:10:\"menu_order\";i:28;s:16:\"popularity_index\";i:770;s:11:\"trend_index\";i:430;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:184;a:15:{s:2:\"id\";i:5488;s:5:\"title\";s:7:\"About 7\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/about_white_8.png\";s:12:\"tmpl_created\";i:1520443524;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:104:\"https://library.elementor.com/blocks/about-7/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:28;s:16:\"popularity_index\";i:307;s:11:\"trend_index\";i:169;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:185;a:15:{s:2:\"id\";i:14947;s:5:\"title\";s:33:\"Flooring company &#8211; Services\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2020/08/Services.png\";s:12:\"tmpl_created\";i:1597740551;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/flooring-company-services/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:39:\"[\"Flooring company\",\"Flooring website\"]\";s:10:\"menu_order\";i:29;s:16:\"popularity_index\";i:538;s:11:\"trend_index\";i:392;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:186;a:15:{s:2:\"id\";i:6122;s:5:\"title\";s:7:\"About 8\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/about_white_2-1.png\";s:12:\"tmpl_created\";i:1520443661;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:104:\"https://library.elementor.com/blocks/about-8/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:29;s:16:\"popularity_index\";i:38;s:11:\"trend_index\";i:26;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:187;a:15:{s:2:\"id\";i:16983;s:5:\"title\";s:41:\"Pilates Instructor &#8211; Online Service\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2021/01/Pilates-Instructor.png\";s:12:\"tmpl_created\";i:1610534138;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:126:\"https://library.elementor.com/lp/pilates-instructor-online-service/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:14:\"Online Service\";s:4:\"tags\";s:70:\"[\"Free Trial\",\"Instructor\",\"Landing Pages\",\"Online Service\",\"Pilates\"]\";s:10:\"menu_order\";i:29;s:16:\"popularity_index\";i:778;s:11:\"trend_index\";i:412;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:188;a:15:{s:2:\"id\";i:14901;s:5:\"title\";s:29:\"Flooring Company &#8211; Home\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2020/08/Home.png\";s:12:\"tmpl_created\";i:1597740474;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/flooring-company-home/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:39:\"[\"Flooring company\",\"Flooring website\"]\";s:10:\"menu_order\";i:30;s:16:\"popularity_index\";i:387;s:11:\"trend_index\";i:185;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:189;a:15:{s:2:\"id\";i:18568;s:5:\"title\";s:32:\"Flower Delivery &#8211; Business\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2021/04/Flower-Delivery.png\";s:12:\"tmpl_created\";i:1617546716;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/lp/flower-delivery-business/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:37:\"[\"Delivery\",\"Flower\",\"Landing Pages\"]\";s:10:\"menu_order\";i:30;s:16:\"popularity_index\";i:874;s:11:\"trend_index\";i:763;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:190;a:15:{s:2:\"id\";i:10047;s:5:\"title\";s:15:\"Classic | Login\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2019/01/yellow_small.png\";s:12:\"tmpl_created\";i:1547847757;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/popups/classic-login-3/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:30;s:16:\"popularity_index\";i:522;s:11:\"trend_index\";i:513;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:191;a:15:{s:2:\"id\";i:5496;s:5:\"title\";s:7:\"About 9\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/about_black_8-1.png\";s:12:\"tmpl_created\";i:1520443526;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:104:\"https://library.elementor.com/blocks/about-9/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:30;s:16:\"popularity_index\";i:523;s:11:\"trend_index\";i:453;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:192;a:15:{s:2:\"id\";i:16917;s:5:\"title\";s:22:\"Webinar &#8211; Events\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2021/01/Webinar-Library-Pic.jpg\";s:12:\"tmpl_created\";i:1610466822;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/lp/webinar-events/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:6:\"Events\";s:4:\"tags\";s:36:\"[\"Events\",\"Landing Pages\",\"Webinar\"]\";s:10:\"menu_order\";i:31;s:16:\"popularity_index\";i:821;s:11:\"trend_index\";i:0;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:193;a:15:{s:2:\"id\";i:8961;s:5:\"title\";s:9:\"archive 1\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/06/Archive_350.1.jpg\";s:12:\"tmpl_created\";i:1528639909;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/archive-1/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"archive\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:31;s:16:\"popularity_index\";i:79;s:11:\"trend_index\";i:15;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:194;a:15:{s:2:\"id\";i:9879;s:5:\"title\";s:38:\"Classic | Register | Subscribe | Leads\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2019/01/dog_small.png\";s:12:\"tmpl_created\";i:1547838416;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:123:\"https://library.elementor.com/popups/classic-register-subscribe/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:31;s:16:\"popularity_index\";i:676;s:11:\"trend_index\";i:761;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:195;a:15:{s:2:\"id\";i:14737;s:5:\"title\";s:32:\"Luxury Real Estate &#8211; About\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2020/07/About.png\";s:12:\"tmpl_created\";i:1595313527;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/luxury-real-estate-about-page/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:28:\"[\"real estate\",\"realestate\"]\";s:10:\"menu_order\";i:31;s:16:\"popularity_index\";i:150;s:11:\"trend_index\";i:447;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:196;a:15:{s:2:\"id\";i:17079;s:5:\"title\";s:42:\"Calls Volunteer &#8211; Social Involvement\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2021/01/Calls-Volunteer.png\";s:12:\"tmpl_created\";i:1610631774;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:127:\"https://library.elementor.com/lp/calls-volunteer-social-involvement/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:18:\"Social Involvement\";s:4:\"tags\";s:68:\"[\"Care\",\"Covid-19\",\"Help\",\"Involvement\",\"Landing Pages\",\"Volunteer\"]\";s:10:\"menu_order\";i:32;s:16:\"popularity_index\";i:854;s:11:\"trend_index\";i:0;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:197;a:15:{s:2:\"id\";i:8969;s:5:\"title\";s:9:\"archive 2\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/06/Archive_350.2.jpg\";s:12:\"tmpl_created\";i:1528700014;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/archive-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"archive\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:32;s:16:\"popularity_index\";i:250;s:11:\"trend_index\";i:124;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:198;a:15:{s:2:\"id\";i:14756;s:5:\"title\";s:34:\"Luxury Real Estate &#8211; Contact\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2020/07/Contact-Us.png\";s:12:\"tmpl_created\";i:1595313519;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:124:\"https://library.elementor.com/luxury-real-estate-contact-us-page/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:28:\"[\"real estate\",\"realestate\"]\";s:10:\"menu_order\";i:32;s:16:\"popularity_index\";i:610;s:11:\"trend_index\";i:569;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:199;a:15:{s:2:\"id\";i:16836;s:5:\"title\";s:33:\"Marketing Agency &#8211; Business\";s:9:\"thumbnail\";s:89:\"https://library.elementor.com/wp-content/uploads/2021/01/Marketing-Agency-Library-Pic.jpg\";s:12:\"tmpl_created\";i:1610464490;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/lp/marketing-agency-business/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:74:\"[\"Agency\",\"Business\",\"Landing Pages\",\"Marketing\",\"Marketing Landing Page\"]\";s:10:\"menu_order\";i:33;s:16:\"popularity_index\";i:816;s:11:\"trend_index\";i:787;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:200;a:15:{s:2:\"id\";i:8973;s:5:\"title\";s:9:\"archive 3\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/06/Archive_350.3.jpg\";s:12:\"tmpl_created\";i:1528700205;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/archive-3/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"archive\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:33;s:16:\"popularity_index\";i:176;s:11:\"trend_index\";i:54;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:201;a:15:{s:2:\"id\";i:14716;s:5:\"title\";s:31:\"Luxury Real Estate &#8211; Home\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2020/07/Home.png\";s:12:\"tmpl_created\";i:1595313512;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/luxury-real-estate-home-page/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:28:\"[\"real estate\",\"realestate\"]\";s:10:\"menu_order\";i:33;s:16:\"popularity_index\";i:394;s:11:\"trend_index\";i:165;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:202;a:15:{s:2:\"id\";i:16785;s:5:\"title\";s:42:\"Gym Promotion &#8211; Health &amp; Fitness\";s:9:\"thumbnail\";s:67:\"https://library.elementor.com/wp-content/uploads/2021/01/Gym-LP.jpg\";s:12:\"tmpl_created\";i:1610455496;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:121:\"https://library.elementor.com/lp/gym-promotion-health-fitness/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:18:\"Health and Fitness\";s:4:\"tags\";s:42:\"[\"Fitness\",\"Gym\",\"Health\",\"Landing Pages\"]\";s:10:\"menu_order\";i:34;s:16:\"popularity_index\";i:820;s:11:\"trend_index\";i:0;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:203;a:15:{s:2:\"id\";i:8977;s:5:\"title\";s:9:\"archive 4\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/06/Archive_350.4.jpg\";s:12:\"tmpl_created\";i:1528700326;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/archive-4/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"archive\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:34;s:16:\"popularity_index\";i:354;s:11:\"trend_index\";i:396;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:204;a:15:{s:2:\"id\";i:14763;s:5:\"title\";s:31:\"Luxury Real Estate &#8211; News\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2020/07/news-Archive.png\";s:12:\"tmpl_created\";i:1595313273;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/luxury-real-estate-news-page/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:28:\"[\"real estate\",\"realestate\"]\";s:10:\"menu_order\";i:34;s:16:\"popularity_index\";i:404;s:11:\"trend_index\";i:167;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:205;a:15:{s:2:\"id\";i:10297;s:5:\"title\";s:14:\"Classic | Sale\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2019/01/s_yellow_small.png\";s:12:\"tmpl_created\";i:1548056099;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/popups/classic-sale-4/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:35;s:16:\"popularity_index\";i:590;s:11:\"trend_index\";i:607;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:206;a:15:{s:2:\"id\";i:18492;s:5:\"title\";s:34:\"Bicycle Pre-Sale &#8211; eCommerce\";s:9:\"thumbnail\";s:90:\"https://library.elementor.com/wp-content/uploads/2021/04/Library-Pic-Bike-Landing-Page.png\";s:12:\"tmpl_created\";i:1617535552;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/lp/bicycle-pre-sale-ecommerce/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:9:\"eCommerce\";s:4:\"tags\";s:34:\"[\"Bicycle\",\"Landing Pages\",\"Sale\"]\";s:10:\"menu_order\";i:35;s:16:\"popularity_index\";i:871;s:11:\"trend_index\";i:826;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:207;a:15:{s:2:\"id\";i:8981;s:5:\"title\";s:9:\"archive 5\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/06/Archive_350.5.jpg\";s:12:\"tmpl_created\";i:1528700484;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/archive-5/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"archive\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:35;s:16:\"popularity_index\";i:333;s:11:\"trend_index\";i:195;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:208;a:15:{s:2:\"id\";i:13960;s:5:\"title\";s:32:\"Japanese restaurant &#8211; Home\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2020/06/Home-Page.jpg\";s:12:\"tmpl_created\";i:1592289775;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/japanese-restaurant-home-page/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:32:\"[\"Food\",\"Japanese\",\"Restaurant\"]\";s:10:\"menu_order\";i:35;s:16:\"popularity_index\";i:537;s:11:\"trend_index\";i:287;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:209;a:15:{s:2:\"id\";i:10393;s:5:\"title\";s:14:\"Classic | Sale\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2019/01/blue_small.png\";s:12:\"tmpl_created\";i:1548056682;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/popups/classic-sale-5/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:36;s:16:\"popularity_index\";i:678;s:11:\"trend_index\";i:837;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:210;a:15:{s:2:\"id\";i:18349;s:5:\"title\";s:39:\"Virtual try-on glasses &#8211; Business\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2021/03/250x280-8.png\";s:12:\"tmpl_created\";i:1614772569;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:124:\"https://library.elementor.com/lp/virtual-try-on-glasses-business/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:64:\"[\"Fashion\",\"Glasses\",\"Landing Pages\",\"Online Service\",\"Virtual\"]\";s:10:\"menu_order\";i:36;s:16:\"popularity_index\";i:848;s:11:\"trend_index\";i:803;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:211;a:15:{s:2:\"id\";i:8985;s:5:\"title\";s:9:\"archive 6\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/06/Archive_350.6.jpg\";s:12:\"tmpl_created\";i:1528700612;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/archive-6/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"archive\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:36;s:16:\"popularity_index\";i:204;s:11:\"trend_index\";i:95;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:212;a:15:{s:2:\"id\";i:13993;s:5:\"title\";s:45:\"Japanese restaurant &#8211; Chef&#8217;s Menu\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2020/06/Chef_s-Menu-Page.jpg\";s:12:\"tmpl_created\";i:1592289691;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.elementor.com/japanese-restaurant-chefs-menu/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:32:\"[\"Food\",\"Japanese\",\"Restaurant\"]\";s:10:\"menu_order\";i:36;s:16:\"popularity_index\";i:651;s:11:\"trend_index\";i:675;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:213;a:15:{s:2:\"id\";i:17458;s:5:\"title\";s:31:\"Moving Company &#8211; Business\";s:9:\"thumbnail\";s:87:\"https://library.elementor.com/wp-content/uploads/2021/02/Library-Pic-Moving-Company.png\";s:12:\"tmpl_created\";i:1612727025;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/lp/moving-company-business/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:46:\"[\"Business\",\"Landing Pages\",\"Movers\",\"moving\"]\";s:10:\"menu_order\";i:37;s:16:\"popularity_index\";i:826;s:11:\"trend_index\";i:767;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:214;a:15:{s:2:\"id\";i:8989;s:5:\"title\";s:9:\"archive 7\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/06/Archive_350.7.jpg\";s:12:\"tmpl_created\";i:1528701063;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/archive-7/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"archive\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:37;s:16:\"popularity_index\";i:208;s:11:\"trend_index\";i:111;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:215;a:15:{s:2:\"id\";i:14012;s:5:\"title\";s:36:\"Japanese restaurant &#8211; Bar Menu\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2020/06/Bar-Menu-Page.jpg\";s:12:\"tmpl_created\";i:1592289665;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/japanese-restaurant-bar-menu/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:32:\"[\"Food\",\"Japanese\",\"Restaurant\"]\";s:10:\"menu_order\";i:37;s:16:\"popularity_index\";i:735;s:11:\"trend_index\";i:829;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:216;a:15:{s:2:\"id\";i:10579;s:5:\"title\";s:14:\"Classic | Sale\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2019/01/sale1_small.png\";s:12:\"tmpl_created\";i:1547967887;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/popups/classic-sale-8/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:38;s:16:\"popularity_index\";i:712;s:11:\"trend_index\";i:782;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:217;a:15:{s:2:\"id\";i:18517;s:5:\"title\";s:29:\"Food Blog &#8211; Coming Soon\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2021/04/Library-Pic-Food-Blog.png\";s:12:\"tmpl_created\";i:1617539897;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/lp/food-blog-coming-soon/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:16:\"Coming Soon Page\";s:4:\"tags\";s:45:\"[\"Blog\",\"Coming Soon\",\"Food\",\"Landing Pages\"]\";s:10:\"menu_order\";i:38;s:16:\"popularity_index\";i:844;s:11:\"trend_index\";i:672;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:218;a:15:{s:2:\"id\";i:8996;s:5:\"title\";s:9:\"archive 8\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/06/Archive_350.8.jpg\";s:12:\"tmpl_created\";i:1528701290;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/archive-8/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"archive\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:38;s:16:\"popularity_index\";i:227;s:11:\"trend_index\";i:153;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:219;a:15:{s:2:\"id\";i:13917;s:5:\"title\";s:33:\"Japanese restaurant &#8211; About\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2020/06/About-Page.jpg\";s:12:\"tmpl_created\";i:1592289629;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/japanese-restaurant-about/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:32:\"[\"Food\",\"Japanese\",\"Restaurant\"]\";s:10:\"menu_order\";i:38;s:16:\"popularity_index\";i:640;s:11:\"trend_index\";i:389;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:220;a:15:{s:2:\"id\";i:17379;s:5:\"title\";s:33:\"IT Service &#8211; Online Service\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2021/02/Library-Pic-IT-Service.png\";s:12:\"tmpl_created\";i:1612713022;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/lp/it-service-online-service/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:14:\"Online Service\";s:4:\"tags\";s:41:\"[\"IT\",\"Landing Pages\",\"Remote\",\"Support\"]\";s:10:\"menu_order\";i:39;s:16:\"popularity_index\";i:806;s:11:\"trend_index\";i:634;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:221;a:15:{s:2:\"id\";i:9001;s:5:\"title\";s:9:\"archive 9\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/06/Archive_350.9.jpg\";s:12:\"tmpl_created\";i:1528701433;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/archive-9/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"archive\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:39;s:16:\"popularity_index\";i:265;s:11:\"trend_index\";i:208;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:222;a:15:{s:2:\"id\";i:13937;s:5:\"title\";s:35:\"Japanese restaurant &#8211; Gallery\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2020/06/Gallery-Page.jpg\";s:12:\"tmpl_created\";i:1592289748;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/japanese-restaurant-gallery/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:32:\"[\"Food\",\"Japanese\",\"Restaurant\"]\";s:10:\"menu_order\";i:39;s:16:\"popularity_index\";i:648;s:11:\"trend_index\";i:551;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:223;a:15:{s:2:\"id\";i:18560;s:5:\"title\";s:52:\"Finance Learning Platform &#8211; Under Construction\";s:9:\"thumbnail\";s:89:\"https://library.elementor.com/wp-content/uploads/2021/04/Library-Pic-Finance-Platform.png\";s:12:\"tmpl_created\";i:1617542761;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:137:\"https://library.elementor.com/lp/finance-learning-platform-under-construction/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:18:\"Under Construction\";s:4:\"tags\";s:27:\"[\"Finance\",\"Landing Pages\"]\";s:10:\"menu_order\";i:40;s:16:\"popularity_index\";i:843;s:11:\"trend_index\";i:561;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:224;a:15:{s:2:\"id\";i:13528;s:5:\"title\";s:22:\"Barbershop &#8211; 404\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2020/05/404-Page.jpg\";s:12:\"tmpl_created\";i:1589893152;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/blocks/barbershop-404/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:34:\"[\"404\",\"Barber Shop\",\"Barbershop\"]\";s:10:\"menu_order\";i:40;s:16:\"popularity_index\";i:768;s:11:\"trend_index\";i:681;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:225;a:15:{s:2:\"id\";i:14030;s:5:\"title\";s:34:\"Japanese restaurant &#8211; Events\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2020/06/Events-Page.jpg\";s:12:\"tmpl_created\";i:1592289713;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/japanese-restaurant-events/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:32:\"[\"Food\",\"Japanese\",\"Restaurant\"]\";s:10:\"menu_order\";i:40;s:16:\"popularity_index\";i:723;s:11:\"trend_index\";i:711;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:226;a:15:{s:2:\"id\";i:18528;s:5:\"title\";s:36:\"Home Decor Store &#8211; Coming Soon\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2021/04/Library-Pic-Home-Decore.png\";s:12:\"tmpl_created\";i:1617541784;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:121:\"https://library.elementor.com/lp/home-decor-store-coming-soon/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:16:\"Coming Soon Page\";s:4:\"tags\";s:57:\"[\"Coming Soon\",\"Decor\",\"interior design\",\"Landing Pages\"]\";s:10:\"menu_order\";i:41;s:16:\"popularity_index\";i:872;s:11:\"trend_index\";i:819;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:227;a:15:{s:2:\"id\";i:13518;s:5:\"title\";s:26:\"Barbershop &#8211; Archive\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2020/05/Blog-Page.jpg\";s:12:\"tmpl_created\";i:1589893157;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/blocks/barbershop-archive/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"archive\";s:4:\"tags\";s:28:\"[\"Barber Shop\",\"Barbershop\"]\";s:10:\"menu_order\";i:41;s:16:\"popularity_index\";i:737;s:11:\"trend_index\";i:523;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:228;a:15:{s:2:\"id\";i:13984;s:5:\"title\";s:40:\"Japanese restaurant &#8211; Reservations\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2020/06/reservations.jpg\";s:12:\"tmpl_created\";i:1592294757;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/japanese-restaurant-reservations/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:32:\"[\"Food\",\"Japanese\",\"Restaurant\"]\";s:10:\"menu_order\";i:41;s:16:\"popularity_index\";i:715;s:11:\"trend_index\";i:727;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:229;a:15:{s:2:\"id\";i:17504;s:5:\"title\";s:29:\"Hair Stylist &#8211; Business\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2021/02/250x280-3.png\";s:12:\"tmpl_created\";i:1612883014;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/lp/hair-stylist-business/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:59:\"[\"Business\",\"Hair\",\"hairdresser\",\"Landing Pages\",\"stylist\"]\";s:10:\"menu_order\";i:42;s:16:\"popularity_index\";i:840;s:11:\"trend_index\";i:806;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:230;a:15:{s:2:\"id\";i:13604;s:5:\"title\";s:25:\"Barbershop &#8211; Footer\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2020/05/Footer-Small.jpg\";s:12:\"tmpl_created\";i:1589893147;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/blocks/barbershop-footer/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:37:\"[\"Barber Shop\",\"Barbershop\",\"footer\"]\";s:10:\"menu_order\";i:42;s:16:\"popularity_index\";i:555;s:11:\"trend_index\";i:267;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:231;a:15:{s:2:\"id\";i:13479;s:5:\"title\";s:23:\"Barbershop &#8211; Home\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2020/05/Home-Page.jpg\";s:12:\"tmpl_created\";i:1589893275;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:105:\"https://library.elementor.com/barbershop-home/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:28:\"[\"Barber Shop\",\"Barbershop\"]\";s:10:\"menu_order\";i:42;s:16:\"popularity_index\";i:683;s:11:\"trend_index\";i:832;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:232;a:15:{s:2:\"id\";i:10180;s:5:\"title\";s:21:\"Fly In | Announcement\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2019/01/glass_small.png\";s:12:\"tmpl_created\";i:1548045309;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/popups/fly-in-announcement-3/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:43;s:16:\"popularity_index\";i:686;s:11:\"trend_index\";i:788;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:233;a:15:{s:2:\"id\";i:18449;s:5:\"title\";s:46:\"Aesthetic Clinic &#8211; Health &#038; Fitness\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2021/03/Aesthetic-Clinic.png\";s:12:\"tmpl_created\";i:1616682181;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:124:\"https://library.elementor.com/lp/aesthetic-clinic-health-fitness/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:18:\"Health and Fitness\";s:4:\"tags\";s:57:\"[\"Aesthetic\",\"Beauty\",\"Fitness\",\"Health\",\"Landing Pages\"]\";s:10:\"menu_order\";i:43;s:16:\"popularity_index\";i:859;s:11:\"trend_index\";i:0;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:234;a:15:{s:2:\"id\";i:13612;s:5:\"title\";s:25:\"Barbershop &#8211; Header\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2020/06/barber-shop-header.jpg\";s:12:\"tmpl_created\";i:1589893142;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/blocks/barbershop-header/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:37:\"[\"Barber Shop\",\"Barbershop\",\"header\"]\";s:10:\"menu_order\";i:43;s:16:\"popularity_index\";i:343;s:11:\"trend_index\";i:137;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:235;a:15:{s:2:\"id\";i:13503;s:5:\"title\";s:24:\"Barbershop &#8211; About\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2020/05/About-Page.jpg\";s:12:\"tmpl_created\";i:1589893289;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/barbershop-about/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:28:\"[\"Barber Shop\",\"Barbershop\"]\";s:10:\"menu_order\";i:43;s:16:\"popularity_index\";i:744;s:11:\"trend_index\";i:739;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:236;a:15:{s:2:\"id\";i:17353;s:5:\"title\";s:44:\"Online Cooking Course &#8211; Online Service\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2021/02/250x280-2.png\";s:12:\"tmpl_created\";i:1612705144;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:129:\"https://library.elementor.com/lp/online-cooking-course-online-service/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:14:\"Online Service\";s:4:\"tags\";s:50:\"[\"Cooking\",\"Course Online\",\"Food\",\"Landing Pages\"]\";s:10:\"menu_order\";i:44;s:16:\"popularity_index\";i:845;s:11:\"trend_index\";i:0;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:237;a:15:{s:2:\"id\";i:13621;s:5:\"title\";s:30:\"Barbershop &#8211; Single Post\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2020/05/Single-Page.jpg\";s:12:\"tmpl_created\";i:1589893137;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/blocks/barbershop-single-post/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:28:\"[\"Barber Shop\",\"Barbershop\"]\";s:10:\"menu_order\";i:44;s:16:\"popularity_index\";i:736;s:11:\"trend_index\";i:580;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:238;a:15:{s:2:\"id\";i:13548;s:5:\"title\";s:27:\"Barbershop &#8211; Services\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2020/05/Services-Page.jpg\";s:12:\"tmpl_created\";i:1589893298;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:109:\"https://library.elementor.com/barbershop-services/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:28:\"[\"Barber Shop\",\"Barbershop\"]\";s:10:\"menu_order\";i:44;s:16:\"popularity_index\";i:761;s:11:\"trend_index\";i:0;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:239;a:15:{s:2:\"id\";i:16527;s:5:\"title\";s:24:\"Beauty Salon &#8211; 404\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2020/12/404.jpg\";s:12:\"tmpl_created\";i:1608622517;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:113:\"https://library.elementor.com/blocks/beauty-salon-404/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:29:\"[\"404\",\"Beauty salon\",\"hair\"]\";s:10:\"menu_order\";i:45;s:16:\"popularity_index\";i:742;s:11:\"trend_index\";i:563;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:240;a:15:{s:2:\"id\";i:18550;s:5:\"title\";s:39:\"Online Store &#8211; Under Construction\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2021/04/Library-Pic-Online-Store.png\";s:12:\"tmpl_created\";i:1617542506;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:124:\"https://library.elementor.com/lp/online-store-under-construction/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:18:\"Under Construction\";s:4:\"tags\";s:59:\"[\"Landing Pages\",\"online shop\",\"Shop\",\"Under Construction\"]\";s:10:\"menu_order\";i:45;s:16:\"popularity_index\";i:832;s:11:\"trend_index\";i:600;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:241;a:15:{s:2:\"id\";i:13560;s:5:\"title\";s:26:\"Barbershop &#8211; Gallery\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2020/05/Gallery-Page.jpg\";s:12:\"tmpl_created\";i:1589893307;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/barbershop-gallery/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:28:\"[\"Barber Shop\",\"Barbershop\"]\";s:10:\"menu_order\";i:45;s:16:\"popularity_index\";i:756;s:11:\"trend_index\";i:822;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:242;a:15:{s:2:\"id\";i:9731;s:5:\"title\";s:26:\"Classic | Sale | Promotion\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2019/01/icecream_small.png\";s:12:\"tmpl_created\";i:1547976166;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:109:\"https://library.elementor.com/popups/classic-sale/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:46;s:16:\"popularity_index\";i:635;s:11:\"trend_index\";i:648;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:243;a:15:{s:2:\"id\";i:16535;s:5:\"title\";s:27:\"Beauty Salon &#8211; Footer\";s:9:\"thumbnail\";s:67:\"https://library.elementor.com/wp-content/uploads/2020/12/Footer.jpg\";s:12:\"tmpl_created\";i:1608622498;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/blocks/beauty-salon-footer/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:32:\"[\"Beauty salon\",\"Footer\",\"hair\"]\";s:10:\"menu_order\";i:46;s:16:\"popularity_index\";i:524;s:11:\"trend_index\";i:126;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:244;a:15:{s:2:\"id\";i:18539;s:5:\"title\";s:40:\"Travel Agency &#8211; Under Construction\";s:9:\"thumbnail\";s:88:\"https://library.elementor.com/wp-content/uploads/2021/04/Library-Pic-Travel-Agency-1.png\";s:12:\"tmpl_created\";i:1617610273;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:125:\"https://library.elementor.com/lp/travel-agency-under-construction/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:18:\"Under Construction\";s:4:\"tags\";s:56:\"[\"Agency\",\"Landing Pages\",\"Travel\",\"Under Construction\"]\";s:10:\"menu_order\";i:46;s:16:\"popularity_index\";i:876;s:11:\"trend_index\";i:652;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:245;a:15:{s:2:\"id\";i:13587;s:5:\"title\";s:26:\"Barbershop &#8211; Contact\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2020/05/Contact-Us-Page.jpg\";s:12:\"tmpl_created\";i:1589893315;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/barbershop-contact/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:28:\"[\"Barber Shop\",\"Barbershop\"]\";s:10:\"menu_order\";i:46;s:16:\"popularity_index\";i:753;s:11:\"trend_index\";i:0;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:246;a:15:{s:2:\"id\";i:16545;s:5:\"title\";s:27:\"Beauty Salon &#8211; Header\";s:9:\"thumbnail\";s:67:\"https://library.elementor.com/wp-content/uploads/2020/12/Header.jpg\";s:12:\"tmpl_created\";i:1608622495;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/blocks/beauty-salon-header/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:32:\"[\"Beauty salon\",\"hair\",\"Header\"]\";s:10:\"menu_order\";i:47;s:16:\"popularity_index\";i:356;s:11:\"trend_index\";i:49;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:247;a:15:{s:2:\"id\";i:18270;s:5:\"title\";s:24:\"Open week &#8211; Events\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2021/03/250x280.png\";s:12:\"tmpl_created\";i:1614767186;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:109:\"https://library.elementor.com/lp/open-week-events/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:6:\"Events\";s:4:\"tags\";s:59:\"[\"Education\",\"Event\",\"Events\",\"Landing Pages\",\"University\"]\";s:10:\"menu_order\";i:47;s:16:\"popularity_index\";i:831;s:11:\"trend_index\";i:673;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:248;a:15:{s:2:\"id\";i:13307;s:5:\"title\";s:26:\"Online Course &#8211; Home\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2020/04/Home.jpg\";s:12:\"tmpl_created\";i:1587474541;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/online-course-home/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:29:\"[\"Course Online\",\"Education\"]\";s:10:\"menu_order\";i:47;s:16:\"popularity_index\";i:230;s:11:\"trend_index\";i:125;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:249;a:15:{s:2:\"id\";i:7686;s:5:\"title\";s:12:\"Blog Posts 1\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2018/03/blog_posts.png\";s:12:\"tmpl_created\";i:1521558047;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:109:\"https://library.elementor.com/blocks/blog-posts-1/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:26:\"[\"archive\",\"Blog\",\"posts\"]\";s:10:\"menu_order\";i:48;s:16:\"popularity_index\";i:131;s:11:\"trend_index\";i:152;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:250;a:15:{s:2:\"id\";i:18300;s:5:\"title\";s:30:\"Makeup Artist &#8211; Business\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2021/03/250x280-2.png\";s:12:\"tmpl_created\";i:1614768608;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/lp/makeup-artist-business/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:79:\"[\"Beauty\",\"Business\",\"Course Online\",\"Landing Pages\",\"Makeup\",\"Online Service\"]\";s:10:\"menu_order\";i:48;s:16:\"popularity_index\";i:861;s:11:\"trend_index\";i:783;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:251;a:15:{s:2:\"id\";i:13328;s:5:\"title\";s:27:\"Online Course &#8211; About\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2020/04/About.jpg\";s:12:\"tmpl_created\";i:1587474558;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:109:\"https://library.elementor.com/online-course-about/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:29:\"[\"Course Online\",\"Education\"]\";s:10:\"menu_order\";i:48;s:16:\"popularity_index\";i:508;s:11:\"trend_index\";i:429;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:252;a:15:{s:2:\"id\";i:18329;s:5:\"title\";s:63:\"Online Real Estate Investment Conference &#8211; Online Service\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2021/03/250x280-5.png\";s:12:\"tmpl_created\";i:1614770404;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:148:\"https://library.elementor.com/lp/online-real-estate-investment-conference-online-service/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:14:\"Online Service\";s:4:\"tags\";s:76:\"[\"Conference\",\"Event\",\"Events\",\"Landing Pages\",\"Online Event\",\"Real estate\"]\";s:10:\"menu_order\";i:49;s:16:\"popularity_index\";i:866;s:11:\"trend_index\";i:779;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:253;a:15:{s:2:\"id\";i:13338;s:5:\"title\";s:33:\"Online Course &#8211; Course Page\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2020/04/Course-Page.png\";s:12:\"tmpl_created\";i:1587474574;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/online-course-course-page/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:29:\"[\"Course Online\",\"Education\"]\";s:10:\"menu_order\";i:49;s:16:\"popularity_index\";i:337;s:11:\"trend_index\";i:310;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:254;a:15:{s:2:\"id\";i:5283;s:5:\"title\";s:9:\"Clients 1\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/clients_white_2.png\";s:12:\"tmpl_created\";i:1520443478;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/clients-1-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"clients\";s:4:\"tags\";s:11:\"[\"clients\"]\";s:10:\"menu_order\";i:49;s:16:\"popularity_index\";i:294;s:11:\"trend_index\";i:202;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:255;a:15:{s:2:\"id\";i:18391;s:5:\"title\";s:45:\"Children&#8217;s Optometrist &#8211; Business\";s:9:\"thumbnail\";s:94:\"https://library.elementor.com/wp-content/uploads/2021/03/Library-Pic-Childrens-Optometrist.png\";s:12:\"tmpl_created\";i:1614773564;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:123:\"https://library.elementor.com/lp/childrens-optometrist-business/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:85:\"[\"Business\",\"Children\",\"Eye\",\"Glasses\",\"Health\",\"Kids\",\"Landing Pages\",\"Optometrist\"]\";s:10:\"menu_order\";i:50;s:16:\"popularity_index\";i:877;s:11:\"trend_index\";i:0;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:256;a:15:{s:2:\"id\";i:13352;s:5:\"title\";s:29:\"Online Course &#8211; Contact\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2020/04/Contact-Us.jpg\";s:12:\"tmpl_created\";i:1587474591;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/online-course-contact/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:29:\"[\"Course Online\",\"Education\"]\";s:10:\"menu_order\";i:50;s:16:\"popularity_index\";i:565;s:11:\"trend_index\";i:533;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:257;a:15:{s:2:\"id\";i:5306;s:5:\"title\";s:10:\"Clients 10\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/clients_black_3.png\";s:12:\"tmpl_created\";i:1520443484;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/blocks/clients-10/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"clients\";s:4:\"tags\";s:11:\"[\"clients\"]\";s:10:\"menu_order\";i:50;s:16:\"popularity_index\";i:657;s:11:\"trend_index\";i:581;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:258;a:15:{s:2:\"id\";i:18366;s:5:\"title\";s:30:\"Car Insurance &#8211; Business\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2021/03/Library-Pic-Car-Insurance.png\";s:12:\"tmpl_created\";i:1614773263;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/lp/car-insurance-business/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:46:\"[\"Business\",\"car\",\"Insurance\",\"Landing Pages\"]\";s:10:\"menu_order\";i:51;s:16:\"popularity_index\";i:869;s:11:\"trend_index\";i:797;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:259;a:15:{s:2:\"id\";i:13187;s:5:\"title\";s:33:\"Interior Design &#8211; Home Page\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2020/04/Home.png\";s:12:\"tmpl_created\";i:1586148661;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/interior-design-home-page/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:30:\"[\"business\",\"interior design\"]\";s:10:\"menu_order\";i:51;s:16:\"popularity_index\";i:331;s:11:\"trend_index\";i:264;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:260;a:15:{s:2:\"id\";i:5341;s:5:\"title\";s:10:\"Clients 11\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/clients_black_4.png\";s:12:\"tmpl_created\";i:1520443491;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/blocks/clients-11/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"clients\";s:4:\"tags\";s:11:\"[\"clients\"]\";s:10:\"menu_order\";i:51;s:16:\"popularity_index\";i:603;s:11:\"trend_index\";i:633;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:261;a:15:{s:2:\"id\";i:18291;s:5:\"title\";s:47:\"Grill Restaurant Food Delivery &#8211; Business\";s:9:\"thumbnail\";s:89:\"https://library.elementor.com/wp-content/uploads/2021/03/Library-Pic-Food-Delivery-LP.png\";s:12:\"tmpl_created\";i:1614767830;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/lp/grill-restaurant-food-delivery-business/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:79:\"[\"Delivery\",\"Delivery Service\",\"Fast Food\",\"Food\",\"Landing Pages\",\"Restaurant\"]\";s:10:\"menu_order\";i:52;s:16:\"popularity_index\";i:819;s:11:\"trend_index\";i:685;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:262;a:15:{s:2:\"id\";i:13199;s:5:\"title\";s:29:\"Interior Design &#8211; About\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2020/04/About.png\";s:12:\"tmpl_created\";i:1586148666;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/interior-design-about/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:30:\"[\"business\",\"interior design\"]\";s:10:\"menu_order\";i:52;s:16:\"popularity_index\";i:316;s:11:\"trend_index\";i:334;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:263;a:15:{s:2:\"id\";i:5315;s:5:\"title\";s:10:\"Clients 12\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2018/03/form_white_4-1.png\";s:12:\"tmpl_created\";i:1520443486;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/blocks/clients-12/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"clients\";s:4:\"tags\";s:11:\"[\"clients\"]\";s:10:\"menu_order\";i:52;s:16:\"popularity_index\";i:485;s:11:\"trend_index\";i:263;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:264;a:15:{s:2:\"id\";i:18340;s:5:\"title\";s:30:\"Restaurant &#8211; Coming Soon\";s:9:\"thumbnail\";s:98:\"https://library.elementor.com/wp-content/uploads/2021/03/Library-Pic-Restuarant-Coming-Soon-LP.png\";s:12:\"tmpl_created\";i:1614772183;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/lp/restaurant-coming-soon/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:16:\"Coming Soon Page\";s:4:\"tags\";s:51:\"[\"Coming Soon\",\"Food\",\"Landing Pages\",\"Restaurant\"]\";s:10:\"menu_order\";i:53;s:16:\"popularity_index\";i:810;s:11:\"trend_index\";i:809;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:265;a:15:{s:2:\"id\";i:13214;s:5:\"title\";s:32:\"Interior Design &#8211; Projects\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2020/04/portfolio_s.jpg\";s:12:\"tmpl_created\";i:1586148672;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/interior-design-projects/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:30:\"[\"business\",\"interior design\"]\";s:10:\"menu_order\";i:53;s:16:\"popularity_index\";i:367;s:11:\"trend_index\";i:323;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:266;a:15:{s:2:\"id\";i:5333;s:5:\"title\";s:10:\"Clients 13\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/form_white_6.png\";s:12:\"tmpl_created\";i:1520443489;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/blocks/clients-13/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"clients\";s:4:\"tags\";s:11:\"[\"clients\"]\";s:10:\"menu_order\";i:53;s:16:\"popularity_index\";i:234;s:11:\"trend_index\";i:128;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:267;a:15:{s:2:\"id\";i:17480;s:5:\"title\";s:42:\"At-home Massage Therapist &#8211; Business\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2021/02/At-Home-Massage-Therapist.jpg\";s:12:\"tmpl_created\";i:1612879264;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:127:\"https://library.elementor.com/lp/at-home-massage-therapist-business/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:60:\"[\"Business\",\"Health\",\"Landing Pages\",\"Services\",\"Therapist\"]\";s:10:\"menu_order\";i:54;s:16:\"popularity_index\";i:856;s:11:\"trend_index\";i:0;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:268;a:15:{s:2:\"id\";i:13229;s:5:\"title\";s:31:\"Interior Design &#8211; Contact\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2020/04/Contact-Us.png\";s:12:\"tmpl_created\";i:1586148677;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:113:\"https://library.elementor.com/interior-design-contact/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:30:\"[\"business\",\"interior design\"]\";s:10:\"menu_order\";i:54;s:16:\"popularity_index\";i:395;s:11:\"trend_index\";i:337;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:269;a:15:{s:2:\"id\";i:5389;s:5:\"title\";s:10:\"Clients 14\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/form_black_9.png\";s:12:\"tmpl_created\";i:1520443501;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/blocks/clients-14/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"clients\";s:4:\"tags\";s:11:\"[\"clients\"]\";s:10:\"menu_order\";i:54;s:16:\"popularity_index\";i:407;s:11:\"trend_index\";i:307;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:270;a:15:{s:2:\"id\";i:10005;s:5:\"title\";s:38:\"Fly In | Promotion | Spa | Body Lotion\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2019/01/Flyin_lotion_small.png\";s:12:\"tmpl_created\";i:1547844909;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/popups/fly-in-promotion-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:54;s:16:\"popularity_index\";i:755;s:11:\"trend_index\";i:760;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:271;a:15:{s:2:\"id\";i:10424;s:5:\"title\";s:21:\"Fly In | Announcement\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2019/01/flower_small.png\";s:12:\"tmpl_created\";i:1547961866;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/popups/fly-in-announcement-4/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:55;s:16:\"popularity_index\";i:677;s:11:\"trend_index\";i:753;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:272;a:15:{s:2:\"id\";i:18317;s:5:\"title\";s:26:\"Insurance &#8211; Business\";s:9:\"thumbnail\";s:87:\"https://library.elementor.com/wp-content/uploads/2021/03/Library-Pic-Life-Insirance.png\";s:12:\"tmpl_created\";i:1614769488;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/lp/insurance-business/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:61:\"[\"Business\",\"Family\",\"Financial\",\"Insurance\",\"Landing Pages\"]\";s:10:\"menu_order\";i:55;s:16:\"popularity_index\";i:870;s:11:\"trend_index\";i:0;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:273;a:15:{s:2:\"id\";i:12948;s:5:\"title\";s:29:\"Photography &#8211; Home Page\";s:9:\"thumbnail\";s:67:\"https://library.elementor.com/wp-content/uploads/2020/02/Home_s.png\";s:12:\"tmpl_created\";i:1582093442;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/photography-home-page/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:27:\"[\"Photography\",\"portfolio\"]\";s:10:\"menu_order\";i:55;s:16:\"popularity_index\";i:241;s:11:\"trend_index\";i:201;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:274;a:15:{s:2:\"id\";i:5298;s:5:\"title\";s:10:\"Clients 15\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/clients_white_3.png\";s:12:\"tmpl_created\";i:1520443482;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/blocks/clients-15/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"clients\";s:4:\"tags\";s:11:\"[\"clients\"]\";s:10:\"menu_order\";i:55;s:16:\"popularity_index\";i:465;s:11:\"trend_index\";i:520;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:275;a:15:{s:2:\"id\";i:9975;s:5:\"title\";s:24:\"Fly In | Promotion | App\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2019/01/flyin_webinar_app_small.png\";s:12:\"tmpl_created\";i:1547842284;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:121:\"https://library.elementor.com/popups/fly-in-promotion-webinar/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:55;s:16:\"popularity_index\";i:774;s:11:\"trend_index\";i:0;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:276;a:15:{s:2:\"id\";i:17401;s:5:\"title\";s:40:\"Conference Thank You Page &#8211; Events\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2021/02/250x280.png\";s:12:\"tmpl_created\";i:1612724753;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:125:\"https://library.elementor.com/lp/conference-thank-you-page-events/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:14:\"Thank You Page\";s:4:\"tags\";s:59:\"[\"Conference\",\"Event\",\"Events\",\"Landing Pages\",\"Thank You\"]\";s:10:\"menu_order\";i:56;s:16:\"popularity_index\";i:799;s:11:\"trend_index\";i:540;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:277;a:15:{s:2:\"id\";i:12798;s:5:\"title\";s:25:\"Photography &#8211; About\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2020/02/About_s.png\";s:12:\"tmpl_created\";i:1582093446;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/photography-about/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:27:\"[\"Photography\",\"portfolio\"]\";s:10:\"menu_order\";i:56;s:16:\"popularity_index\";i:499;s:11:\"trend_index\";i:374;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:278;a:15:{s:2:\"id\";i:5381;s:5:\"title\";s:10:\"Clients 16\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/form_white_9.png\";s:12:\"tmpl_created\";i:1520443499;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/blocks/clients-16/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"clients\";s:4:\"tags\";s:11:\"[\"clients\"]\";s:10:\"menu_order\";i:56;s:16:\"popularity_index\";i:198;s:11:\"trend_index\";i:168;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:279;a:15:{s:2:\"id\";i:10067;s:5:\"title\";s:31:\"Fly In | Announcement | Cookies\";s:9:\"thumbnail\";s:87:\"https://library.elementor.com/wp-content/uploads/2019/01/fly-in_cookie_yellow_small.png\";s:12:\"tmpl_created\";i:1547848075;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/popups/fly-in-announcement/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:56;s:16:\"popularity_index\";i:582;s:11:\"trend_index\";i:619;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:280;a:15:{s:2:\"id\";i:17368;s:5:\"title\";s:38:\"Real Estate Agency &#8211; Real-Estate\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2021/02/Library-Pic-Real-Estate.png\";s:12:\"tmpl_created\";i:1612711814;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:123:\"https://library.elementor.com/lp/real-estate-agency-real-estate/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:11:\"Real Estate\";s:4:\"tags\";s:73:\"[\"Landing Pages\",\"listing\",\"Real estate\",\"Realestate\",\"realtor\",\"realty\"]\";s:10:\"menu_order\";i:57;s:16:\"popularity_index\";i:858;s:11:\"trend_index\";i:777;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:281;a:15:{s:2:\"id\";i:12868;s:5:\"title\";s:27:\"Photography &#8211; Contact\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2020/02/Contact_s.png\";s:12:\"tmpl_created\";i:1582093450;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:109:\"https://library.elementor.com/photography-contact/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:27:\"[\"Photography\",\"portfolio\"]\";s:10:\"menu_order\";i:57;s:16:\"popularity_index\";i:531;s:11:\"trend_index\";i:350;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:282;a:15:{s:2:\"id\";i:5357;s:5:\"title\";s:9:\"Clients 2\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/clients_black_7.png\";s:12:\"tmpl_created\";i:1520443495;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/clients-2-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"clients\";s:4:\"tags\";s:11:\"[\"clients\"]\";s:10:\"menu_order\";i:57;s:16:\"popularity_index\";i:341;s:11:\"trend_index\";i:232;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:283;a:15:{s:2:\"id\";i:17423;s:5:\"title\";s:57:\"Volunteer Calls Thank You Page &#8211; Social Involvement\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2021/02/Volunteer-Calls-TYP.jpg\";s:12:\"tmpl_created\";i:1612726058;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:142:\"https://library.elementor.com/lp/volunteer-calls-thank-you-page-social-involvement/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:14:\"Thank You Page\";s:4:\"tags\";s:62:\"[\"Care\",\"Involvement\",\"Landing Pages\",\"Thank You\",\"Volunteer\"]\";s:10:\"menu_order\";i:58;s:16:\"popularity_index\";i:857;s:11:\"trend_index\";i:818;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:284;a:15:{s:2:\"id\";i:13056;s:5:\"title\";s:28:\"Photography &#8211; Wildlife\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2020/02/Wildlife_s.png\";s:12:\"tmpl_created\";i:1582093454;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/photography-wildlife/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:27:\"[\"Photography\",\"portfolio\"]\";s:10:\"menu_order\";i:58;s:16:\"popularity_index\";i:579;s:11:\"trend_index\";i:656;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:285;a:15:{s:2:\"id\";i:5290;s:5:\"title\";s:9:\"Clients 3\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/clients_black_2.png\";s:12:\"tmpl_created\";i:1520443480;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/clients-3-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"clients\";s:4:\"tags\";s:11:\"[\"clients\"]\";s:10:\"menu_order\";i:58;s:16:\"popularity_index\";i:545;s:11:\"trend_index\";i:502;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:286;a:15:{s:2:\"id\";i:10329;s:5:\"title\";s:25:\"Fly In | Sale | Promotion\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2019/01/organic_small.png\";s:12:\"tmpl_created\";i:1547893478;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/popups/fly-in-sale-promotion/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:59;s:16:\"popularity_index\";i:781;s:11:\"trend_index\";i:0;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:287;a:15:{s:2:\"id\";i:17409;s:5:\"title\";s:37:\"Webinar Thank You Page &#8211; Events\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2021/02/Library-Pic-Webinar-TYP.png\";s:12:\"tmpl_created\";i:1612725644;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/lp/webinar-thank-you-page-events/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:14:\"Thank You Page\";s:4:\"tags\";s:56:\"[\"Event\",\"Events\",\"Landing Pages\",\"Thank You\",\"Webinar\"]\";s:10:\"menu_order\";i:59;s:16:\"popularity_index\";i:868;s:11:\"trend_index\";i:0;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:288;a:15:{s:2:\"id\";i:12922;s:5:\"title\";s:37:\"Photography &#8211; Glowing Jellyfish\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2020/02/Jellyfish_S.png\";s:12:\"tmpl_created\";i:1582093457;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/photography-glowing-jellyfish/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:27:\"[\"Photography\",\"portfolio\"]\";s:10:\"menu_order\";i:59;s:16:\"popularity_index\";i:628;s:11:\"trend_index\";i:532;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:289;a:15:{s:2:\"id\";i:5266;s:5:\"title\";s:9:\"Clients 4\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/clients_white_1.png\";s:12:\"tmpl_created\";i:1520443474;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/clients-4/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"clients\";s:4:\"tags\";s:11:\"[\"clients\"]\";s:10:\"menu_order\";i:59;s:16:\"popularity_index\";i:95;s:11:\"trend_index\";i:134;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:290;a:15:{s:2:\"id\";i:17258;s:5:\"title\";s:32:\"Beauty Product &#8211; eCommerce\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2021/01/Beauty-Product.png\";s:12:\"tmpl_created\";i:1610903153;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/lp/beauty-product-ecommerce/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:9:\"eCommerce\";s:4:\"tags\";s:38:\"[\"beauty\",\"Ecommerce\",\"Landing Pages\"]\";s:10:\"menu_order\";i:60;s:16:\"popularity_index\";i:797;s:11:\"trend_index\";i:703;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:291;a:15:{s:2:\"id\";i:12875;s:5:\"title\";s:36:\"Photography &#8211; Fluttering Birds\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2020/02/Birds_s.png\";s:12:\"tmpl_created\";i:1582093461;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/photography-fluttering-birds/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:27:\"[\"Photography\",\"portfolio\"]\";s:10:\"menu_order\";i:60;s:16:\"popularity_index\";i:693;s:11:\"trend_index\";i:766;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:292;a:15:{s:2:\"id\";i:9650;s:5:\"title\";s:36:\"Fly In | Register | Subscribe | Sale\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2019/01/Fly-In_Register_small_01a.png\";s:12:\"tmpl_created\";i:1547007598;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/popups/fly-in-register_big-01/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:60;s:16:\"popularity_index\";i:771;s:11:\"trend_index\";i:0;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:293;a:15:{s:2:\"id\";i:5275;s:5:\"title\";s:9:\"Clients 5\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/clients_black_1.png\";s:12:\"tmpl_created\";i:1520443476;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/clients-5/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"clients\";s:4:\"tags\";s:11:\"[\"clients\"]\";s:10:\"menu_order\";i:60;s:16:\"popularity_index\";i:334;s:11:\"trend_index\";i:321;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:294;a:15:{s:2:\"id\";i:17435;s:5:\"title\";s:39:\"Gym &#8211; App Service &#8211; Product\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2021/02/250x280-4.png\";s:12:\"tmpl_created\";i:1612726462;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/lp/gym-app-service-product/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:7:\"Product\";s:4:\"tags\";s:58:\"[\"App\",\"Fitness\",\"Gym\",\"Health\",\"Landing Pages\",\"Product\"]\";s:10:\"menu_order\";i:61;s:16:\"popularity_index\";i:767;s:11:\"trend_index\";i:577;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:295;a:15:{s:2:\"id\";i:12962;s:5:\"title\";s:26:\"Photography &#8211; Nature\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2020/02/Nature_s.png\";s:12:\"tmpl_created\";i:1582093465;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/photography-nature/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:27:\"[\"Photography\",\"portfolio\"]\";s:10:\"menu_order\";i:61;s:16:\"popularity_index\";i:592;s:11:\"trend_index\";i:778;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:296;a:15:{s:2:\"id\";i:5349;s:5:\"title\";s:9:\"Clients 7\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/form_white_7.png\";s:12:\"tmpl_created\";i:1520443493;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/clients-7/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"clients\";s:4:\"tags\";s:11:\"[\"clients\"]\";s:10:\"menu_order\";i:61;s:16:\"popularity_index\";i:233;s:11:\"trend_index\";i:92;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:297;a:15:{s:2:\"id\";i:17111;s:5:\"title\";s:33:\"Sunglasses Sale &#8211; eCommerce\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2021/01/Sunglasses-LP-Library-Pic.jpg\";s:12:\"tmpl_created\";i:1610632408;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/lp/sunglasses-sale-ecommerce/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:9:\"eCommerce\";s:4:\"tags\";s:59:\"[\"Ecommerce\",\"Fashion\",\"Landing Pages\",\"Sale\",\"Sunglasses\"]\";s:10:\"menu_order\";i:62;s:16:\"popularity_index\";i:812;s:11:\"trend_index\";i:732;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:298;a:15:{s:2:\"id\";i:12833;s:5:\"title\";s:38:\"Photography &#8211; Blossoming Flowers\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2020/02/Flowers_s.png\";s:12:\"tmpl_created\";i:1582093469;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.elementor.com/photography-blossoming-flowers/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:27:\"[\"Photography\",\"portfolio\"]\";s:10:\"menu_order\";i:62;s:16:\"popularity_index\";i:597;s:11:\"trend_index\";i:750;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:299;a:15:{s:2:\"id\";i:5324;s:5:\"title\";s:9:\"Clients 8\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2018/03/form_white_5-1.png\";s:12:\"tmpl_created\";i:1520443488;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/clients-8/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"clients\";s:4:\"tags\";s:11:\"[\"clients\"]\";s:10:\"menu_order\";i:62;s:16:\"popularity_index\";i:526;s:11:\"trend_index\";i:381;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:300;a:15:{s:2:\"id\";i:10200;s:5:\"title\";s:33:\"Full Screen | Content Lock | Wine\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2019/01/lock_wine_small.png\";s:12:\"tmpl_created\";i:1548055635;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:121:\"https://library.elementor.com/popups/full-screen-content-lock/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:63;s:16:\"popularity_index\";i:719;s:11:\"trend_index\";i:0;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:301;a:15:{s:2:\"id\";i:17223;s:5:\"title\";s:25:\"Fashion &#8211; eCommerce\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2021/01/Commerce-Fashion.png\";s:12:\"tmpl_created\";i:1610902553;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/lp/fashion-ecommerce/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:9:\"eCommerce\";s:4:\"tags\";s:29:\"[\"Ecommerce\",\"Landing Pages\"]\";s:10:\"menu_order\";i:63;s:16:\"popularity_index\";i:808;s:11:\"trend_index\";i:745;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:302;a:15:{s:2:\"id\";i:12898;s:5:\"title\";s:36:\"Photography &#8211; Forest Mushrooms\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2020/02/Mushrooms_s.png\";s:12:\"tmpl_created\";i:1582093473;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/photography-forest-mushrooms/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:27:\"[\"Photography\",\"portfolio\"]\";s:10:\"menu_order\";i:63;s:16:\"popularity_index\";i:667;s:11:\"trend_index\";i:649;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:303;a:15:{s:2:\"id\";i:5368;s:5:\"title\";s:9:\"Clients 9\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/form_white_8.png\";s:12:\"tmpl_created\";i:1520443497;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/clients-9/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"clients\";s:4:\"tags\";s:11:\"[\"clients\"]\";s:10:\"menu_order\";i:63;s:16:\"popularity_index\";i:253;s:11:\"trend_index\";i:273;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:304;a:15:{s:2:\"id\";i:10287;s:5:\"title\";s:34:\"Full Screen | Register | Subscribe\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2019/01/glass_pink_small.png\";s:12:\"tmpl_created\";i:1547994301;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/popups/full-screen-login-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:64;s:16:\"popularity_index\";i:602;s:11:\"trend_index\";i:439;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:305;a:15:{s:2:\"id\";i:17017;s:5:\"title\";s:28:\"Shoes Sale &#8211; eCommerce\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2021/01/Shoes-LP-Library-Pic.jpg\";s:12:\"tmpl_created\";i:1610535361;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:113:\"https://library.elementor.com/lp/shoes-sale-ecommerce/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:9:\"eCommerce\";s:4:\"tags\";s:55:\"[\"Discount\",\"Ecommerce\",\"Landing Pages\",\"Sale\",\"Shoes\"]\";s:10:\"menu_order\";i:64;s:16:\"popularity_index\";i:803;s:11:\"trend_index\";i:642;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:306;a:15:{s:2:\"id\";i:4436;s:5:\"title\";s:11:\"Contact  16\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/02/map_black_2.png\";s:12:\"tmpl_created\";i:1520443293;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/blocks/contact-16/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"contact\";s:4:\"tags\";s:11:\"[\"contact\"]\";s:10:\"menu_order\";i:64;s:16:\"popularity_index\";i:161;s:11:\"trend_index\";i:68;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:307;a:15:{s:2:\"id\";i:12994;s:5:\"title\";s:24:\"Photography &#8211; Pets\";s:9:\"thumbnail\";s:67:\"https://library.elementor.com/wp-content/uploads/2020/02/Pets_s.png\";s:12:\"tmpl_created\";i:1582093477;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/photography-pets/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:27:\"[\"Photography\",\"portfolio\"]\";s:10:\"menu_order\";i:64;s:16:\"popularity_index\";i:612;s:11:\"trend_index\";i:508;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:308;a:15:{s:2:\"id\";i:17301;s:5:\"title\";s:53:\"Personal Chef &#8211; Thank You Page &#8211; Business\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2021/01/TYP-Personal-Chef.jpg\";s:12:\"tmpl_created\";i:1610903622;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:130:\"https://library.elementor.com/lp/personal-chef-thank-you-page-business/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:14:\"Thank You Page\";s:4:\"tags\";s:43:\"[\"Chef\",\"Food\",\"Landing Pages\",\"Thank You\"]\";s:10:\"menu_order\";i:65;s:16:\"popularity_index\";i:823;s:11:\"trend_index\";i:754;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:309;a:15:{s:2:\"id\";i:4420;s:5:\"title\";s:9:\"Contact 1\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/02/map_black_1.png\";s:12:\"tmpl_created\";i:1520443289;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/contact-1-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"contact\";s:4:\"tags\";s:11:\"[\"contact\"]\";s:10:\"menu_order\";i:65;s:16:\"popularity_index\";i:196;s:11:\"trend_index\";i:127;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:310;a:15:{s:2:\"id\";i:12805;s:5:\"title\";s:38:\"Photography &#8211; B&#038;W Portraits\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2020/02/Black_s.png\";s:12:\"tmpl_created\";i:1582093481;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/photography-bw-portraits/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:27:\"[\"Photography\",\"portfolio\"]\";s:10:\"menu_order\";i:65;s:16:\"popularity_index\";i:695;s:11:\"trend_index\";i:735;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:311;a:15:{s:2:\"id\";i:5836;s:5:\"title\";s:10:\"Contact 10\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/contact_white_2.png\";s:12:\"tmpl_created\";i:1520443597;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/blocks/contact-10/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"contact\";s:4:\"tags\";s:11:\"[\"contact\"]\";s:10:\"menu_order\";i:66;s:16:\"popularity_index\";i:114;s:11:\"trend_index\";i:76;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:312;a:15:{s:2:\"id\";i:17313;s:5:\"title\";s:60:\"Development Course  &#8211; Thank You Page &#8211; Education\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2021/01/Dev-Course-TYP-.png\";s:12:\"tmpl_created\";i:1610903776;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:136:\"https://library.elementor.com/lp/development-course-thank-you-page-education/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:14:\"Thank You Page\";s:4:\"tags\";s:57:\"[\"Course Online\",\"Education\",\"Landing Pages\",\"Thank You\"]\";s:10:\"menu_order\";i:66;s:16:\"popularity_index\";i:834;s:11:\"trend_index\";i:0;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:313;a:15:{s:2:\"id\";i:13031;s:5:\"title\";s:33:\"Photography &#8211; Vivid Parrots\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2020/02/Parrots_s.png\";s:12:\"tmpl_created\";i:1582093484;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/photography-vivid-parrots/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:27:\"[\"Photography\",\"portfolio\"]\";s:10:\"menu_order\";i:66;s:16:\"popularity_index\";i:660;s:11:\"trend_index\";i:643;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:314;a:15:{s:2:\"id\";i:9889;s:5:\"title\";s:28:\"Full Screen | Login | Cactus\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2019/01/cac_small.png\";s:12:\"tmpl_created\";i:1547838722;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/popups/full-screen-login/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:66;s:16:\"popularity_index\";i:743;s:11:\"trend_index\";i:713;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:315;a:15:{s:2:\"id\";i:5844;s:5:\"title\";s:10:\"Contact 11\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/contact_black_2.png\";s:12:\"tmpl_created\";i:1520443599;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/blocks/contact-11/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"contact\";s:4:\"tags\";s:11:\"[\"contact\"]\";s:10:\"menu_order\";i:67;s:16:\"popularity_index\";i:289;s:11:\"trend_index\";i:313;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:316;a:15:{s:2:\"id\";i:16192;s:5:\"title\";s:30:\"Management App &#8211; Product\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2017/01/app.-landing-page.jpg\";s:12:\"tmpl_created\";i:1607866881;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/lp/management-app-product/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:7:\"Product\";s:4:\"tags\";s:33:\"[\"App\",\"Landing Pages\",\"Product\"]\";s:10:\"menu_order\";i:67;s:16:\"popularity_index\";i:827;s:11:\"trend_index\";i:765;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:317;a:15:{s:2:\"id\";i:12621;s:5:\"title\";s:26:\"Magazine &#8211; Home Page\";s:9:\"thumbnail\";s:67:\"https://library.elementor.com/wp-content/uploads/2020/01/Home_s.png\";s:12:\"tmpl_created\";i:1579060604;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/magazine-home-page/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:19:\"[\"Blog\",\"Magazine\"]\";s:10:\"menu_order\";i:67;s:16:\"popularity_index\";i:167;s:11:\"trend_index\";i:121;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:318;a:15:{s:2:\"id\";i:10077;s:5:\"title\";s:29:\"Fly In | Register | Subscribe\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2019/01/flyin_register_blue_small.png\";s:12:\"tmpl_created\";i:1547848197;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/popups/fly-in-register-subscribe/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:67;s:16:\"popularity_index\";i:540;s:11:\"trend_index\";i:574;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:319;a:15:{s:2:\"id\";i:15839;s:5:\"title\";s:29:\"Chiropractor &#8211; Business\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2017/05/Landing-Page-Chiropractor.png\";s:12:\"tmpl_created\";i:1607855449;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/lp/chiropractor-business/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:37:\"[\"Business\",\"Health\",\"Landing Pages\"]\";s:10:\"menu_order\";i:68;s:16:\"popularity_index\";i:828;s:11:\"trend_index\";i:709;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:320;a:15:{s:2:\"id\";i:12352;s:5:\"title\";s:24:\"Travel &#8211; Home Page\";s:9:\"thumbnail\";s:67:\"https://library.elementor.com/wp-content/uploads/2019/12/Home_s.png\";s:12:\"tmpl_created\";i:1575960464;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/travel-home-page/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:18:\"[\"Tours\",\"Travel\"]\";s:10:\"menu_order\";i:68;s:16:\"popularity_index\";i:291;s:11:\"trend_index\";i:194;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:321;a:15:{s:2:\"id\";i:4476;s:5:\"title\";s:10:\"Contact 15\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/02/contact_white_4.png\";s:12:\"tmpl_created\";i:1520443303;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/blocks/contact-15/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"contact\";s:4:\"tags\";s:18:\"[\"contact\",\"form\"]\";s:10:\"menu_order\";i:68;s:16:\"popularity_index\";i:229;s:11:\"trend_index\";i:187;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:322;a:15:{s:2:\"id\";i:15827;s:5:\"title\";s:32:\"Creative Agency &#8211; Business\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/07/Get_Started_250.png\";s:12:\"tmpl_created\";i:1607855280;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/lp/creative-agency-business/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:168:\"[\"Agency\",\"bootstrap\",\"Business\",\"corporate\",\"Landing Pages\",\"Marketing Campaign\",\"Marketing Landing Page\",\"Product launch\",\"software\",\"Startup\",\"startup landing page\"]\";s:10:\"menu_order\";i:69;s:16:\"popularity_index\";i:748;s:11:\"trend_index\";i:363;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:323;a:15:{s:2:\"id\";i:10362;s:5:\"title\";s:32:\"Full Screen | Login | Restaurant\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2019/01/vip_small.png\";s:12:\"tmpl_created\";i:1548056253;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/popups/full-screen-login-3/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:69;s:16:\"popularity_index\";i:587;s:11:\"trend_index\";i:560;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:324;a:15:{s:2:\"id\";i:12400;s:5:\"title\";s:20:\"Travel &#8211; About\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2019/12/About.png\";s:12:\"tmpl_created\";i:1575960441;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:102:\"https://library.elementor.com/travel-about/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:18:\"[\"Tours\",\"Travel\"]\";s:10:\"menu_order\";i:69;s:16:\"popularity_index\";i:444;s:11:\"trend_index\";i:445;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:325;a:15:{s:2:\"id\";i:5214;s:5:\"title\";s:10:\"Contact 16\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/form_white_2.png\";s:12:\"tmpl_created\";i:1520443462;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:109:\"https://library.elementor.com/blocks/contact-16-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"contact\";s:4:\"tags\";s:18:\"[\"contact\",\"form\"]\";s:10:\"menu_order\";i:69;s:16:\"popularity_index\";i:194;s:11:\"trend_index\";i:106;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:326;a:15:{s:2:\"id\";i:16120;s:5:\"title\";s:37:\"Life coach Tom &#8211; Online Service\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2017/02/Landin-Page-Coacher.png\";s:12:\"tmpl_created\";i:1607865812;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/lp/life-coach-tom-online-service/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:30:\"[\"Consulting\",\"Landing Pages\"]\";s:10:\"menu_order\";i:70;s:16:\"popularity_index\";i:818;s:11:\"trend_index\";i:796;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:327;a:15:{s:2:\"id\";i:12479;s:5:\"title\";s:20:\"Travel &#8211; Tours\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2019/12/Tours_s.png\";s:12:\"tmpl_created\";i:1575960474;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:102:\"https://library.elementor.com/travel-tours/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:18:\"[\"Tours\",\"Travel\"]\";s:10:\"menu_order\";i:70;s:16:\"popularity_index\";i:539;s:11:\"trend_index\";i:726;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:328;a:15:{s:2:\"id\";i:5230;s:5:\"title\";s:10:\"Contact 17\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/form_white_3.png\";s:12:\"tmpl_created\";i:1520443466;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/blocks/contact-17/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"contact\";s:4:\"tags\";s:18:\"[\"contact\",\"form\"]\";s:10:\"menu_order\";i:70;s:16:\"popularity_index\";i:339;s:11:\"trend_index\";i:335;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:329;a:15:{s:2:\"id\";i:16059;s:5:\"title\";s:34:\"Melbourne Conference &#8211; Event\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2017/01/convention-landing-page.jpg\";s:12:\"tmpl_created\";i:1607864236;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/lp/melbourne-conference-event/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:6:\"Events\";s:4:\"tags\";s:25:\"[\"Event\",\"Landing Pages\"]\";s:10:\"menu_order\";i:71;s:16:\"popularity_index\";i:841;s:11:\"trend_index\";i:0;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:330;a:15:{s:2:\"id\";i:10454;s:5:\"title\";s:29:\"Full Screen | Promotion | App\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2019/01/appy_small.png\";s:12:\"tmpl_created\";i:1548056896;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/popups/full-screen-promotion-app/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:71;s:16:\"popularity_index\";i:776;s:11:\"trend_index\";i:804;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:331;a:15:{s:2:\"id\";i:12466;s:5:\"title\";s:27:\"Travel &#8211; Testimonials\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2019/12/Testimonials.png\";s:12:\"tmpl_created\";i:1575960469;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:109:\"https://library.elementor.com/travel-testimonials/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:18:\"[\"Tours\",\"Travel\"]\";s:10:\"menu_order\";i:71;s:16:\"popularity_index\";i:527;s:11:\"trend_index\";i:481;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:332;a:15:{s:2:\"id\";i:5257;s:5:\"title\";s:10:\"Contact 18\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/form_white_5.png\";s:12:\"tmpl_created\";i:1520443472;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/blocks/contact-18/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"contact\";s:4:\"tags\";s:8:\"[\"form\"]\";s:10:\"menu_order\";i:71;s:16:\"popularity_index\";i:438;s:11:\"trend_index\";i:490;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:333;a:15:{s:2:\"id\";i:5820;s:5:\"title\";s:9:\"Contact 2\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/contact_white_1.png\";s:12:\"tmpl_created\";i:1520443593;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/contact-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"contact\";s:4:\"tags\";s:11:\"[\"contact\"]\";s:10:\"menu_order\";i:72;s:16:\"popularity_index\";i:183;s:11:\"trend_index\";i:357;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:334;a:15:{s:2:\"id\";i:16073;s:5:\"title\";s:56:\"International Women&#8217;s Day Conference &#8211; Event\";s:9:\"thumbnail\";s:109:\"https://library.elementor.com/wp-content/uploads/2017/05/Landing-Page-International-Womens-Day-Conference.png\";s:12:\"tmpl_created\";i:1607864979;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/lp/international-womens-day-conference-event/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:6:\"Events\";s:4:\"tags\";s:25:\"[\"Event\",\"Landing Pages\"]\";s:10:\"menu_order\";i:72;s:16:\"popularity_index\";i:865;s:11:\"trend_index\";i:789;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:335;a:15:{s:2:\"id\";i:12443;s:5:\"title\";s:22:\"Travel &#8211; Gallery\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2019/12/Gallery.png\";s:12:\"tmpl_created\";i:1575960459;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:104:\"https://library.elementor.com/travel-gallery/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:18:\"[\"Tours\",\"Travel\"]\";s:10:\"menu_order\";i:72;s:16:\"popularity_index\";i:467;s:11:\"trend_index\";i:501;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:336;a:15:{s:2:\"id\";i:9803;s:5:\"title\";s:41:\"Full Screen | Register | Contact | Meetup\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2019/01/designme_full_small.png\";s:12:\"tmpl_created\";i:1547831298;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:125:\"https://library.elementor.com/popups/full-screen-register-contact/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:72;s:16:\"popularity_index\";i:701;s:11:\"trend_index\";i:808;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:337;a:15:{s:2:\"id\";i:10611;s:5:\"title\";s:18:\"Full Screen | Sale\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2019/01/fla_small.png\";s:12:\"tmpl_created\";i:1547968868;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:113:\"https://library.elementor.com/popups/full-screen-sale/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:73;s:16:\"popularity_index\";i:779;s:11:\"trend_index\";i:792;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:338;a:15:{s:2:\"id\";i:16085;s:5:\"title\";s:29:\"Tech Conference &#8211; Event\";s:9:\"thumbnail\";s:89:\"https://library.elementor.com/wp-content/uploads/2017/05/Landing-Page-Tech-Conference.png\";s:12:\"tmpl_created\";i:1607865227;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/lp/tech-conference-event/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:6:\"Events\";s:4:\"tags\";s:25:\"[\"Event\",\"Landing Pages\"]\";s:10:\"menu_order\";i:73;s:16:\"popularity_index\";i:851;s:11:\"trend_index\";i:747;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:339;a:15:{s:2:\"id\";i:4411;s:5:\"title\";s:9:\"Contact 3\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/02/map_white_1.png\";s:12:\"tmpl_created\";i:1520443287;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/contact-3-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"contact\";s:4:\"tags\";s:11:\"[\"contact\"]\";s:10:\"menu_order\";i:73;s:16:\"popularity_index\";i:113;s:11:\"trend_index\";i:217;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:340;a:15:{s:2:\"id\";i:12431;s:5:\"title\";s:18:\"Travel &#8211; FAQ\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2019/12/FAQ.png\";s:12:\"tmpl_created\";i:1575960453;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:100:\"https://library.elementor.com/travel-faq/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:18:\"[\"Tours\",\"Travel\"]\";s:10:\"menu_order\";i:73;s:16:\"popularity_index\";i:501;s:11:\"trend_index\";i:387;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:341;a:15:{s:2:\"id\";i:5828;s:5:\"title\";s:9:\"Contact 3\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/contact_black_1.png\";s:12:\"tmpl_created\";i:1520443595;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/contact-3/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"contact\";s:4:\"tags\";s:11:\"[\"contact\"]\";s:10:\"menu_order\";i:74;s:16:\"popularity_index\";i:312;s:11:\"trend_index\";i:495;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:342;a:15:{s:2:\"id\";i:16102;s:5:\"title\";s:38:\"Environmental Conference &#8211; Event\";s:9:\"thumbnail\";s:99:\"https://library.elementor.com/wp-content/uploads/2017/05/Landing-Page-Sustainability-Conference.png\";s:12:\"tmpl_created\";i:1607865473;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:123:\"https://library.elementor.com/lp/environmental-conference-event/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:6:\"Events\";s:4:\"tags\";s:25:\"[\"Event\",\"Landing Pages\"]\";s:10:\"menu_order\";i:74;s:16:\"popularity_index\";i:833;s:11:\"trend_index\";i:772;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:343;a:15:{s:2:\"id\";i:12421;s:5:\"title\";s:27:\"Travel &#8211; Contact Page\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2019/12/Contsct-Us.png\";s:12:\"tmpl_created\";i:1575960445;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:109:\"https://library.elementor.com/travel-contact-page/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:18:\"[\"Tours\",\"Travel\"]\";s:10:\"menu_order\";i:74;s:16:\"popularity_index\";i:571;s:11:\"trend_index\";i:536;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:344;a:15:{s:2:\"id\";i:10508;s:5:\"title\";s:25:\"Full Screen | Welcome Mat\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2019/01/hand_small-1.png\";s:12:\"tmpl_created\";i:1547964711;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/popups/full-screen-welcome-mat-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:75;s:16:\"popularity_index\";i:711;s:11:\"trend_index\";i:793;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:345;a:15:{s:2:\"id\";i:15931;s:5:\"title\";s:37:\"Tokyo Design Conference &#8211; Event\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2018/11/conference-250.png\";s:12:\"tmpl_created\";i:1607861271;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/lp/tokyo-design-conference-event/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:6:\"Events\";s:4:\"tags\";s:17:\"[\"Landing Pages\"]\";s:10:\"menu_order\";i:75;s:16:\"popularity_index\";i:815;s:11:\"trend_index\";i:644;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:346;a:15:{s:2:\"id\";i:11763;s:5:\"title\";s:27:\"Portfolio &#8211; Home Page\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2019/09/Homepage_small.png\";s:12:\"tmpl_created\";i:1569428959;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:109:\"https://library.elementor.com/portfolio-home-page/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:34:\"[\"creative portfolio\",\"portfolio\"]\";s:10:\"menu_order\";i:75;s:16:\"popularity_index\";i:280;s:11:\"trend_index\";i:241;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:347;a:15:{s:2:\"id\";i:4428;s:5:\"title\";s:9:\"Contact 4\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/02/map_white_2.png\";s:12:\"tmpl_created\";i:1520443291;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/contact-4/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"contact\";s:4:\"tags\";s:11:\"[\"contact\"]\";s:10:\"menu_order\";i:75;s:16:\"popularity_index\";i:118;s:11:\"trend_index\";i:131;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:348;a:15:{s:2:\"id\";i:16412;s:5:\"title\";s:36:\"Photography Coupon &#8211; eCommerce\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2017/05/Coupon-02.png\";s:12:\"tmpl_created\";i:1607869919;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:121:\"https://library.elementor.com/lp/photography-coupon-ecommerce/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:9:\"eCommerce\";s:4:\"tags\";s:52:\"[\"Coupon\",\"Ecommerce\",\"Landing Pages\",\"Photography\"]\";s:10:\"menu_order\";i:76;s:16:\"popularity_index\";i:862;s:11:\"trend_index\";i:749;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:349;a:15:{s:2:\"id\";i:11781;s:5:\"title\";s:23:\"Portfolio &#8211; About\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2019/09/About_small.png\";s:12:\"tmpl_created\";i:1569428955;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:105:\"https://library.elementor.com/portfolio-about/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:34:\"[\"creative portfolio\",\"portfolio\"]\";s:10:\"menu_order\";i:76;s:16:\"popularity_index\";i:349;s:11:\"trend_index\";i:290;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:350;a:15:{s:2:\"id\";i:4444;s:5:\"title\";s:9:\"Contact 5\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/02/contact_white_1.png\";s:12:\"tmpl_created\";i:1520443295;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/contact-5/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"contact\";s:4:\"tags\";s:11:\"[\"contact\"]\";s:10:\"menu_order\";i:76;s:16:\"popularity_index\";i:84;s:11:\"trend_index\";i:93;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:351;a:15:{s:2:\"id\";i:9934;s:5:\"title\";s:38:\"Full Screen | Welcome Mat | Teddy Bear\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2019/01/full_mat_teddy_small.png\";s:12:\"tmpl_created\";i:1547841787;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.elementor.com/popups/full-screen-welcome-mat/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:76;s:16:\"popularity_index\";i:681;s:11:\"trend_index\";i:752;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:352;a:15:{s:2:\"id\";i:16183;s:5:\"title\";s:32:\"Luxury Homes &#8211; Real Estate\";s:9:\"thumbnail\";s:67:\"https://library.elementor.com/wp-content/uploads/2017/03/Agency.png\";s:12:\"tmpl_created\";i:1607866726;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/lp/landing-page-agency/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:11:\"Real Estate\";s:4:\"tags\";s:31:\"[\"Landing Pages\",\"Real estate\"]\";s:10:\"menu_order\";i:77;s:16:\"popularity_index\";i:835;s:11:\"trend_index\";i:768;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:353;a:15:{s:2:\"id\";i:11793;s:5:\"title\";s:26:\"Portfolio &#8211; Projects\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2019/09/Projects_small.png\";s:12:\"tmpl_created\";i:1569428951;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/portfolio-projects/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:34:\"[\"creative portfolio\",\"portfolio\"]\";s:10:\"menu_order\";i:77;s:16:\"popularity_index\";i:448;s:11:\"trend_index\";i:467;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:354;a:15:{s:2:\"id\";i:4492;s:5:\"title\";s:9:\"Contact 5\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/02/map_white_3.png\";s:12:\"tmpl_created\";i:1520443307;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/contact-5-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"contact\";s:4:\"tags\";s:11:\"[\"contact\"]\";s:10:\"menu_order\";i:77;s:16:\"popularity_index\";i:37;s:11:\"trend_index\";i:31;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:355;a:15:{s:2:\"id\";i:16420;s:5:\"title\";s:36:\"Spring Sale Coupon &#8211; eCommerce\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2017/05/Coupon-03.png\";s:12:\"tmpl_created\";i:1607899243;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:121:\"https://library.elementor.com/lp/spring-sale-coupon-ecommerce/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:9:\"eCommerce\";s:4:\"tags\";s:55:\"[\"Coupon\",\"Ecommerce\",\"Fashion\",\"Landing Pages\",\"Sale\"]\";s:10:\"menu_order\";i:78;s:16:\"popularity_index\";i:852;s:11:\"trend_index\";i:756;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:356;a:15:{s:2:\"id\";i:11800;s:5:\"title\";s:25:\"Portfolio &#8211; Contact\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2019/09/Contact_small.png\";s:12:\"tmpl_created\";i:1569428946;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/portfolio-contact/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:34:\"[\"creative portfolio\",\"portfolio\"]\";s:10:\"menu_order\";i:78;s:16:\"popularity_index\";i:494;s:11:\"trend_index\";i:449;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:357;a:15:{s:2:\"id\";i:4452;s:5:\"title\";s:9:\"Contact 6\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/02/contact_black_1.png\";s:12:\"tmpl_created\";i:1520443296;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/contact-6/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"contact\";s:4:\"tags\";s:11:\"[\"contact\"]\";s:10:\"menu_order\";i:78;s:16:\"popularity_index\";i:139;s:11:\"trend_index\";i:150;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:358;a:15:{s:2:\"id\";i:9709;s:5:\"title\";s:25:\"Full Screen | Welcome Mat\";s:9:\"thumbnail\";s:95:\"https://library.elementor.com/wp-content/uploads/2019/01/Full-Screen_Welcome-Mat_01_small-1.png\";s:12:\"tmpl_created\";i:1547023834;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:123:\"https://library.elementor.com/popups/full-screen-welcome-mat-01/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:78;s:16:\"popularity_index\";i:728;s:11:\"trend_index\";i:728;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:359;a:15:{s:2:\"id\";i:16427;s:5:\"title\";s:34:\"Dream Car Coupon &#8211; eCommerce\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2017/05/Coupon-01.png\";s:12:\"tmpl_created\";i:1607934325;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/lp/dream-car-coupon-ecommerce/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:9:\"eCommerce\";s:4:\"tags\";s:53:\"[\"Coupon\",\"Ecommerce\",\"Landing Pages\",\"Offer\",\"Sale\"]\";s:10:\"menu_order\";i:79;s:16:\"popularity_index\";i:863;s:11:\"trend_index\";i:0;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:360;a:15:{s:2:\"id\";i:11163;s:5:\"title\";s:32:\"Digital Agency &#8211; Home Page\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2019/07/Home_small.png\";s:12:\"tmpl_created\";i:1564641877;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/digital-agency-home-page/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:30:\"[\"Digital Agency\",\"marketing\"]\";s:10:\"menu_order\";i:79;s:16:\"popularity_index\";i:57;s:11:\"trend_index\";i:32;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:361;a:15:{s:2:\"id\";i:4468;s:5:\"title\";s:9:\"Contact 7\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/02/contact_white_3.png\";s:12:\"tmpl_created\";i:1520443301;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/contact-7/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"contact\";s:4:\"tags\";s:18:\"[\"contact\",\"form\"]\";s:10:\"menu_order\";i:79;s:16:\"popularity_index\";i:127;s:11:\"trend_index\";i:72;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:362;a:15:{s:2:\"id\";i:9671;s:5:\"title\";s:34:\"Hello Bar | Announcement | Cookies\";s:9:\"thumbnail\";s:90:\"https://library.elementor.com/wp-content/uploads/2019/01/Top-Bar_Announcement_small_01.png\";s:12:\"tmpl_created\";i:1547010259;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/popups/hello-bar-announcement-01/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:79;s:16:\"popularity_index\";i:639;s:11:\"trend_index\";i:598;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:363;a:15:{s:2:\"id\";i:10234;s:5:\"title\";s:38:\"Hello Bar | Announcement | Maintenance\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2019/01/pink_small.png\";s:12:\"tmpl_created\";i:1548055049;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/popups/hello-bar-announcement/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:80;s:16:\"popularity_index\";i:746;s:11:\"trend_index\";i:0;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:364;a:15:{s:2:\"id\";i:16433;s:5:\"title\";s:42:\"Leshnik Mega Sale Coupon &#8211; eCommerce\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2017/05/Coupon-04.png\";s:12:\"tmpl_created\";i:1607934474;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:127:\"https://library.elementor.com/lp/leshnik-mega-sale-coupon-ecommerce/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:9:\"eCommerce\";s:4:\"tags\";s:45:\"[\"Coupon\",\"Ecommerce\",\"Landing Pages\",\"Sale\"]\";s:10:\"menu_order\";i:80;s:16:\"popularity_index\";i:867;s:11:\"trend_index\";i:0;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:365;a:15:{s:2:\"id\";i:4484;s:5:\"title\";s:9:\"Contact 8\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/02/contact_black_3.png\";s:12:\"tmpl_created\";i:1520443305;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/contact-8/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"contact\";s:4:\"tags\";s:18:\"[\"contact\",\"form\"]\";s:10:\"menu_order\";i:80;s:16:\"popularity_index\";i:328;s:11:\"trend_index\";i:260;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:366;a:15:{s:2:\"id\";i:9139;s:5:\"title\";s:25:\"Homepage &#8211; Business\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/07/Get_Started_250.png\";s:12:\"tmpl_created\";i:1532949924;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/homepage-business/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:167:\"[\"Agency\",\"bootstrap\",\"business\",\"corporate\",\"Landing Page\",\"marketing campaign\",\"marketing landing page\",\"product launch\",\"software\",\"Startup\",\"startup landing page\"]\";s:10:\"menu_order\";i:80;s:16:\"popularity_index\";i:7;s:11:\"trend_index\";i:7;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:367;a:15:{s:2:\"id\";i:15986;s:5:\"title\";s:40:\"From Freelance to Business &#8211; Ebook\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2017/05/Landing-Page-Ebook-1.png\";s:12:\"tmpl_created\";i:1607862915;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:125:\"https://library.elementor.com/lp/from-freelance-to-business-ebook/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:5:\"Ebook\";s:4:\"tags\";s:143:\"[\"App\",\"author\",\"book\",\"brochure\",\"download\",\"e-book\",\"ebook\",\"Landing Pages\",\"Marketing\",\"Product\",\"publisher\",\"sell online\",\"seo\",\"showcase\"]\";s:10:\"menu_order\";i:81;s:16:\"popularity_index\";i:837;s:11:\"trend_index\";i:0;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:368;a:15:{s:2:\"id\";i:1634;s:5:\"title\";s:33:\"Landing Page &#8211; Chiropractor\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2017/05/Landing-Page-Chiropractor.png\";s:12:\"tmpl_created\";i:1494352119;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/landing-page-chiropractor/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:81;s:16:\"popularity_index\";i:223;s:11:\"trend_index\";i:360;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:369;a:15:{s:2:\"id\";i:4460;s:5:\"title\";s:9:\"Contact 9\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/02/contact_white_2.png\";s:12:\"tmpl_created\";i:1520443298;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/contact-9/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"contact\";s:4:\"tags\";s:11:\"[\"contact\"]\";s:10:\"menu_order\";i:81;s:16:\"popularity_index\";i:99;s:11:\"trend_index\";i:80;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:370;a:15:{s:2:\"id\";i:16002;s:5:\"title\";s:30:\"Architect Manual &#8211; Ebook\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2017/05/Landing-Page-Ebook-2.png\";s:12:\"tmpl_created\";i:1607863075;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/lp/architect-manual-ebook/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:5:\"Ebook\";s:4:\"tags\";s:25:\"[\"Ebook\",\"Landing Pages\"]\";s:10:\"menu_order\";i:82;s:16:\"popularity_index\";i:836;s:11:\"trend_index\";i:827;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:371;a:15:{s:2:\"id\";i:5558;s:5:\"title\";s:5:\"CTA 1\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_white_2.png\";s:12:\"tmpl_created\";i:1520520684;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:102:\"https://library.elementor.com/blocks/cta-1/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:82;s:16:\"popularity_index\";i:129;s:11:\"trend_index\";i:69;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:372;a:15:{s:2:\"id\";i:12143;s:5:\"title\";s:22:\"Law Firm &#8211; About\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2019/11/about.png\";s:12:\"tmpl_created\";i:1572847069;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:104:\"https://library.elementor.com/law-firm-about/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:18:\"[\"Law\",\"Law Firm\"]\";s:10:\"menu_order\";i:82;s:16:\"popularity_index\";i:350;s:11:\"trend_index\";i:344;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:373;a:15:{s:2:\"id\";i:16014;s:5:\"title\";s:23:\"Good Life &#8211; Ebook\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2017/05/Landing-Page-Ebook-3.png\";s:12:\"tmpl_created\";i:1607863305;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/lp/good-life-ebook/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:5:\"Ebook\";s:4:\"tags\";s:25:\"[\"Ebook\",\"Landing Pages\"]\";s:10:\"menu_order\";i:83;s:16:\"popularity_index\";i:807;s:11:\"trend_index\";i:646;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:374;a:15:{s:2:\"id\";i:5939;s:5:\"title\";s:6:\"CTA 10\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_black_13-1.png\";s:12:\"tmpl_created\";i:1520520760;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/blocks/cta-10/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:83;s:16:\"popularity_index\";i:190;s:11:\"trend_index\";i:118;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:375;a:15:{s:2:\"id\";i:12091;s:5:\"title\";s:21:\"Law Firm &#8211; Team\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2019/11/team.png\";s:12:\"tmpl_created\";i:1572847113;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/law-firm-team/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:18:\"[\"Law\",\"Law Firm\"]\";s:10:\"menu_order\";i:83;s:16:\"popularity_index\";i:318;s:11:\"trend_index\";i:314;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:376;a:15:{s:2:\"id\";i:9869;s:5:\"title\";s:28:\"Hello Bar | Promotion | Sale\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2019/01/ru_small.png\";s:12:\"tmpl_created\";i:1547837269;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/popups/hello-bar-promotion/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:83;s:16:\"popularity_index\";i:766;s:11:\"trend_index\";i:820;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:377;a:15:{s:2:\"id\";i:10539;s:5:\"title\";s:19:\"Hello Bar | Contact\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2019/01/hello_pink_small.png\";s:12:\"tmpl_created\";i:1548056994;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:127:\"https://library.elementor.com/popups/hello-bar-register-subscribe-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:84;s:16:\"popularity_index\";i:726;s:11:\"trend_index\";i:810;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:378;a:15:{s:2:\"id\";i:16242;s:5:\"title\";s:37:\"Fashion Season Sale &#8211; eCommerce\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2016/12/fashion-landing-page.jpg\";s:12:\"tmpl_created\";i:1607867761;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/lp/fashion-season-sale-ecommerce/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:9:\"eCommerce\";s:4:\"tags\";s:34:\"[\"Fashion\",\"Landing Pages\",\"Sale\"]\";s:10:\"menu_order\";i:84;s:16:\"popularity_index\";i:813;s:11:\"trend_index\";i:746;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:379;a:15:{s:2:\"id\";i:11129;s:5:\"title\";s:28:\"Digital Agency &#8211; About\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2019/07/About_small.png\";s:12:\"tmpl_created\";i:1564641889;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/digital-agency-about/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:30:\"[\"Digital Agency\",\"marketing\"]\";s:10:\"menu_order\";i:84;s:16:\"popularity_index\";i:182;s:11:\"trend_index\";i:166;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:380;a:15:{s:2:\"id\";i:5930;s:5:\"title\";s:6:\"CTA 11\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_white_15.png\";s:12:\"tmpl_created\";i:1520520758;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/blocks/cta-11/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:84;s:16:\"popularity_index\";i:76;s:11:\"trend_index\";i:84;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:381;a:15:{s:2:\"id\";i:16202;s:5:\"title\";s:39:\"Starlight Nation Festival &#8211; Event\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2016/12/festival.jpg\";s:12:\"tmpl_created\";i:1607867113;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:124:\"https://library.elementor.com/lp/starlight-nation-festival-event/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:6:\"Events\";s:4:\"tags\";s:25:\"[\"Event\",\"Landing Pages\"]\";s:10:\"menu_order\";i:85;s:16:\"popularity_index\";i:842;s:11:\"trend_index\";i:770;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:382;a:15:{s:2:\"id\";i:11572;s:5:\"title\";s:19:\"Gym &#8211; Trainer\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2019/08/Trainer_Small.png\";s:12:\"tmpl_created\";i:1567392934;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:101:\"https://library.elementor.com/gym-trainer/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:7:\"[\"Gym\"]\";s:10:\"menu_order\";i:85;s:16:\"popularity_index\";i:521;s:11:\"trend_index\";i:590;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:383;a:15:{s:2:\"id\";i:5921;s:5:\"title\";s:6:\"CTA 12\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_white_14.png\";s:12:\"tmpl_created\";i:1520520757;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/blocks/cta-12/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:85;s:16:\"popularity_index\";i:278;s:11:\"trend_index\";i:234;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:384;a:15:{s:2:\"id\";i:16139;s:5:\"title\";s:37:\"Financial Consultant &#8211; Business\";s:9:\"thumbnail\";s:94:\"https://library.elementor.com/wp-content/uploads/2017/02/Landing-Page-Financial-consultant.png\";s:12:\"tmpl_created\";i:1607866334;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/lp/financial-consultant-business/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:40:\"[\"Consulting\",\"Finance\",\"Landing Pages\"]\";s:10:\"menu_order\";i:86;s:16:\"popularity_index\";i:824;s:11:\"trend_index\";i:798;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:385;a:15:{s:2:\"id\";i:1504;s:5:\"title\";s:33:\"Landing Page &#8211; Mobile App 3\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2017/05/Landing-Page-app2.png\";s:12:\"tmpl_created\";i:1494352112;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/landing-page-mobile-app-3/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:86;s:16:\"popularity_index\";i:174;s:11:\"trend_index\";i:367;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:386;a:15:{s:2:\"id\";i:5607;s:5:\"title\";s:6:\"CTA 13\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_black_5.png\";s:12:\"tmpl_created\";i:1520520695;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/blocks/cta-13/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:86;s:16:\"popularity_index\";i:42;s:11:\"trend_index\";i:11;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:387;a:15:{s:2:\"id\";i:15822;s:5:\"title\";s:30:\"Family Vacation &#8211; Travel\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2017/03/lp2-l.png\";s:12:\"tmpl_created\";i:1607855143;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/lp/family-vacation-travel/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:6:\"Travel\";s:4:\"tags\";s:37:\"[\"Landing Pages\",\"Travel\",\"Vacation\"]\";s:10:\"menu_order\";i:87;s:16:\"popularity_index\";i:773;s:11:\"trend_index\";i:593;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:388;a:15:{s:2:\"id\";i:6017;s:5:\"title\";s:6:\"CTA 14\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_black_14.png\";s:12:\"tmpl_created\";i:1520520331;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/blocks/cta-14/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:87;s:16:\"popularity_index\";i:152;s:11:\"trend_index\";i:122;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:389;a:15:{s:2:\"id\";i:12133;s:5:\"title\";s:24:\"Law Firm &#8211; Careers\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2019/11/careers.png\";s:12:\"tmpl_created\";i:1572847078;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/law-firm-careers/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:18:\"[\"Law\",\"Law Firm\"]\";s:10:\"menu_order\";i:87;s:16:\"popularity_index\";i:583;s:11:\"trend_index\";i:640;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:390;a:15:{s:2:\"id\";i:15964;s:5:\"title\";s:31:\"Law Convention &#8211; Business\";s:9:\"thumbnail\";s:92:\"https://library.elementor.com/wp-content/uploads/2017/11/Law-Convention-–-Landing-Page.png\";s:12:\"tmpl_created\";i:1607862731;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/lp/law-convention-business/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:36:\"[\"Convention\",\"Landing Pages\",\"Law\"]\";s:10:\"menu_order\";i:88;s:16:\"popularity_index\";i:860;s:11:\"trend_index\";i:794;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:391;a:15:{s:2:\"id\";i:5885;s:5:\"title\";s:6:\"CTA 15\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_white_11.png\";s:12:\"tmpl_created\";i:1520520751;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/blocks/cta-15/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:88;s:16:\"popularity_index\";i:274;s:11:\"trend_index\";i:256;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:392;a:15:{s:2:\"id\";i:12155;s:5:\"title\";s:26:\"Law Firm &#8211; Home Page\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2019/11/home.png\";s:12:\"tmpl_created\";i:1572847054;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/law-firm-home-page/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:18:\"[\"Law\",\"Law Firm\"]\";s:10:\"menu_order\";i:88;s:16:\"popularity_index\";i:193;s:11:\"trend_index\";i:110;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:393;a:15:{s:2:\"id\";i:15910;s:5:\"title\";s:38:\"Litigation Law Office &#8211; Business\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2017/02/Landing-Page-Law-Office.png\";s:12:\"tmpl_created\";i:1607860827;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:123:\"https://library.elementor.com/lp/litigation-law-office-business/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:32:\"[\"Landing Pages\",\"Law\",\"Office\"]\";s:10:\"menu_order\";i:89;s:16:\"popularity_index\";i:825;s:11:\"trend_index\";i:719;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:394;a:15:{s:2:\"id\";i:10147;s:5:\"title\";s:34:\"Hello Bar | Sale | Promotion | Pop\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2019/01/donut_small.png\";s:12:\"tmpl_created\";i:1548055522;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:121:\"https://library.elementor.com/popups/hello-bar-sale-promotion/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:89;s:16:\"popularity_index\";i:775;s:11:\"trend_index\";i:824;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:395;a:15:{s:2:\"id\";i:5877;s:5:\"title\";s:6:\"CTA 16\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_black_10.png\";s:12:\"tmpl_created\";i:1520520749;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/blocks/cta-16/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:89;s:16:\"popularity_index\";i:564;s:11:\"trend_index\";i:677;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:396;a:15:{s:2:\"id\";i:12080;s:5:\"title\";s:24:\"Law Firm &#8211; Partner\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2019/11/partner-1.png\";s:12:\"tmpl_created\";i:1572847120;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/law-firm-partner/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:18:\"[\"Law\",\"Law Firm\"]\";s:10:\"menu_order\";i:89;s:16:\"popularity_index\";i:556;s:11:\"trend_index\";i:471;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:397;a:15:{s:2:\"id\";i:16025;s:5:\"title\";s:33:\"Conoco Mobile App &#8211; Product\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2017/03/app.png\";s:12:\"tmpl_created\";i:1607863511;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/lp/conoco-mobile-app-product/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:7:\"Product\";s:4:\"tags\";s:27:\"[\"Landing Pages\",\"Product\"]\";s:10:\"menu_order\";i:90;s:16:\"popularity_index\";i:789;s:11:\"trend_index\";i:698;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:398;a:15:{s:2:\"id\";i:11074;s:5:\"title\";s:31:\"Digital Agency &#8211; Services\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2019/07/Services_small.png\";s:12:\"tmpl_created\";i:1564641872;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:113:\"https://library.elementor.com/digital-agency-services/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:30:\"[\"Digital Agency\",\"marketing\"]\";s:10:\"menu_order\";i:90;s:16:\"popularity_index\";i:163;s:11:\"trend_index\";i:170;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:399;a:15:{s:2:\"id\";i:5860;s:5:\"title\";s:6:\"CTA 17\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_white_9.png\";s:12:\"tmpl_created\";i:1520520746;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/blocks/cta-17/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:90;s:16:\"popularity_index\";i:120;s:11:\"trend_index\";i:63;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:400;a:15:{s:2:\"id\";i:9923;s:5:\"title\";s:23:\"Slide In | Announcement\";s:9:\"thumbnail\";s:87:\"https://library.elementor.com/wp-content/uploads/2019/01/slide-in_ann_italian_small.png\";s:12:\"tmpl_created\";i:1547841537;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/popups/slide-in-announcement/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:90;s:16:\"popularity_index\";i:699;s:11:\"trend_index\";i:0;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:401;a:15:{s:2:\"id\";i:15853;s:5:\"title\";s:29:\"Me Mobile App &#8211; Product\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2017/05/Landing-Page-app1.png\";s:12:\"tmpl_created\";i:1607857451;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/lp/me-mobile-app-product/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:7:\"Product\";s:4:\"tags\";s:27:\"[\"Landing Pages\",\"Product\"]\";s:10:\"menu_order\";i:91;s:16:\"popularity_index\";i:811;s:11:\"trend_index\";i:704;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:402;a:15:{s:2:\"id\";i:10117;s:5:\"title\";s:23:\"Slide In | Announcement\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2019/01/white_small.png\";s:12:\"tmpl_created\";i:1548066998;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.elementor.com/popups/slide-in-announcement-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:91;s:16:\"popularity_index\";i:727;s:11:\"trend_index\";i:662;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:403;a:15:{s:2:\"id\";i:11506;s:5:\"title\";s:19:\"Gym &#8211; Classes\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2019/08/Classes_Small.png\";s:12:\"tmpl_created\";i:1567392930;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:101:\"https://library.elementor.com/gym-classes/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:7:\"[\"Gym\"]\";s:10:\"menu_order\";i:91;s:16:\"popularity_index\";i:514;s:11:\"trend_index\";i:554;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:404;a:15:{s:2:\"id\";i:5869;s:5:\"title\";s:6:\"CTA 18\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_white_10.png\";s:12:\"tmpl_created\";i:1520520747;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/blocks/cta-18/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:91;s:16:\"popularity_index\";i:345;s:11:\"trend_index\";i:486;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:405;a:15:{s:2:\"id\";i:15844;s:5:\"title\";s:32:\"Torel Mobile App &#8211; Product\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2017/05/Landing-Page-app2.png\";s:12:\"tmpl_created\";i:1607856863;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/lp/torel-mobile-app-product/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:7:\"Product\";s:4:\"tags\";s:27:\"[\"Landing Pages\",\"Product\"]\";s:10:\"menu_order\";i:92;s:16:\"popularity_index\";i:822;s:11:\"trend_index\";i:812;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:406;a:15:{s:2:\"id\";i:1503;s:5:\"title\";s:33:\"Landing Page &#8211; Mobile App 2\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2017/05/Landing-Page-app1.png\";s:12:\"tmpl_created\";i:1494352113;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/landing-page-mobile-app-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:92;s:16:\"popularity_index\";i:165;s:11:\"trend_index\";i:191;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:407;a:15:{s:2:\"id\";i:5542;s:5:\"title\";s:6:\"CTA 19\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_white_1.png\";s:12:\"tmpl_created\";i:1520520681;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/blocks/cta-19/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:92;s:16:\"popularity_index\";i:169;s:11:\"trend_index\";i:270;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:408;a:15:{s:2:\"id\";i:9826;s:5:\"title\";s:33:\"Slide In | Announcement | webinar\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2019/01/web_small-2.png\";s:12:\"tmpl_created\";i:1547835513;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:126:\"https://library.elementor.com/popups/slide-in-announcement-webinar/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:92;s:16:\"popularity_index\";i:745;s:11:\"trend_index\";i:831;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:409;a:15:{s:2:\"id\";i:16041;s:5:\"title\";s:31:\"Nano Mobile App &#8211; Product\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2017/05/Landing-Page-app3.png\";s:12:\"tmpl_created\";i:1607863992;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/lp/landing-page-mobile-app-4/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:7:\"Product\";s:4:\"tags\";s:27:\"[\"Landing Pages\",\"Product\"]\";s:10:\"menu_order\";i:93;s:16:\"popularity_index\";i:847;s:11:\"trend_index\";i:723;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:410;a:15:{s:2:\"id\";i:10478;s:5:\"title\";s:18:\"Slide In | Contact\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2019/01/slide_wow_small.png\";s:12:\"tmpl_created\";i:1548056829;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:113:\"https://library.elementor.com/popups/slide-in-contact/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:93;s:16:\"popularity_index\";i:595;s:11:\"trend_index\";i:559;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:411;a:15:{s:2:\"id\";i:5567;s:5:\"title\";s:5:\"CTA 2\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_black_2.png\";s:12:\"tmpl_created\";i:1520520685;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:102:\"https://library.elementor.com/blocks/cta-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:93;s:16:\"popularity_index\";i:143;s:11:\"trend_index\";i:225;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:412;a:15:{s:2:\"id\";i:12044;s:5:\"title\";s:24:\"Law Firm &#8211; Contact\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2019/11/contsct_us.png\";s:12:\"tmpl_created\";i:1572847130;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/law-firm-contact/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:18:\"[\"Law\",\"Law Firm\"]\";s:10:\"menu_order\";i:93;s:16:\"popularity_index\";i:437;s:11:\"trend_index\";i:304;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:413;a:15:{s:2:\"id\";i:15890;s:5:\"title\";s:39:\"Personal Trainer &#8211; Online Service\";s:9:\"thumbnail\";s:90:\"https://library.elementor.com/wp-content/uploads/2017/02/Landing-Page-Personal-Trainer.png\";s:12:\"tmpl_created\";i:1607860512;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:124:\"https://library.elementor.com/lp/personal-trainer-online-service/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:14:\"Online Service\";s:4:\"tags\";s:35:\"[\"Fitness\",\"Landing Pages\",\"Sport\"]\";s:10:\"menu_order\";i:94;s:16:\"popularity_index\";i:838;s:11:\"trend_index\";i:0;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:414;a:15:{s:2:\"id\";i:5893;s:5:\"title\";s:6:\"CTA 21\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_black_12.png\";s:12:\"tmpl_created\";i:1520520752;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/blocks/cta-21/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:94;s:16:\"popularity_index\";i:259;s:11:\"trend_index\";i:457;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:415;a:15:{s:2:\"id\";i:12124;s:5:\"title\";s:25:\"Law Firm &#8211; Services\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2019/11/services.png\";s:12:\"tmpl_created\";i:1572847096;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/law-firm-services/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:18:\"[\"Law\",\"Law Firm\"]\";s:10:\"menu_order\";i:94;s:16:\"popularity_index\";i:433;s:11:\"trend_index\";i:296;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:416;a:15:{s:2:\"id\";i:16233;s:5:\"title\";s:36:\"Journey Photography &#8211; Business\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2017/03/lp1-l.png\";s:12:\"tmpl_created\";i:1607867416;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:121:\"https://library.elementor.com/lp/journey-photography-business/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:42:\"[\"Business\",\"Landing Pages\",\"Photography\"]\";s:10:\"menu_order\";i:95;s:16:\"popularity_index\";i:788;s:11:\"trend_index\";i:594;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:417;a:15:{s:2:\"id\";i:11056;s:5:\"title\";s:35:\"Digital Agency &#8211; Social Media\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2019/07/Social-Media_small.png\";s:12:\"tmpl_created\";i:1564641867;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/digital-agency-social-media/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:30:\"[\"Digital Agency\",\"marketing\"]\";s:10:\"menu_order\";i:95;s:16:\"popularity_index\";i:297;s:11:\"trend_index\";i:361;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:418;a:15:{s:2:\"id\";i:5634;s:5:\"title\";s:6:\"CTA 24\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_white_6.png\";s:12:\"tmpl_created\";i:1520520699;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/blocks/cta-24/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:95;s:16:\"popularity_index\";i:188;s:11:\"trend_index\";i:255;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:419;a:15:{s:2:\"id\";i:10685;s:5:\"title\";s:32:\"Hello Bar | Register | Subscribe\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2019/01/env_small.png\";s:12:\"tmpl_created\";i:1547974729;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:127:\"https://library.elementor.com/popups/hello-bar-register-subscribe-3/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:96;s:16:\"popularity_index\";i:721;s:11:\"trend_index\";i:814;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:420;a:15:{s:2:\"id\";i:16162;s:5:\"title\";s:29:\"Private Chef &#8211; Business\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2017/02/Landing-Page-Private-Chef.png\";s:12:\"tmpl_created\";i:1607866578;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/lp/private-chef-business/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:24:\"[\"Food\",\"Landing Pages\"]\";s:10:\"menu_order\";i:96;s:16:\"popularity_index\";i:855;s:11:\"trend_index\";i:0;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:421;a:15:{s:2:\"id\";i:5642;s:5:\"title\";s:6:\"CTA 25\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_black_6.png\";s:12:\"tmpl_created\";i:1520520701;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/blocks/cta-25/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:96;s:16:\"popularity_index\";i:226;s:11:\"trend_index\";i:262;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:422;a:15:{s:2:\"id\";i:11536;s:5:\"title\";s:19:\"Gym &#8211; Fitness\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2019/08/Fitness_Small.png\";s:12:\"tmpl_created\";i:1567392927;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:101:\"https://library.elementor.com/gym-fitness/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:7:\"[\"Gym\"]\";s:10:\"menu_order\";i:96;s:16:\"popularity_index\";i:621;s:11:\"trend_index\";i:674;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:423;a:15:{s:2:\"id\";i:16325;s:5:\"title\";s:28:\"Quality Lens &#8211; Product\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2016/08/0006.png\";s:12:\"tmpl_created\";i:1607868782;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:113:\"https://library.elementor.com/lp/quality-lens-product/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:7:\"Product\";s:4:\"tags\";s:27:\"[\"Landing Pages\",\"Product\"]\";s:10:\"menu_order\";i:97;s:16:\"popularity_index\";i:804;s:11:\"trend_index\";i:621;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:424;a:15:{s:2:\"id\";i:5583;s:5:\"title\";s:6:\"CTA 26\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_black_3.png\";s:12:\"tmpl_created\";i:1520520689;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/blocks/cta-26/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:97;s:16:\"popularity_index\";i:117;s:11:\"trend_index\";i:117;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:425;a:15:{s:2:\"id\";i:11545;s:5:\"title\";s:21:\"Gym &#8211; Home Page\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2019/08/Home_Small.png\";s:12:\"tmpl_created\";i:1567392943;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/gym-home-page/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:7:\"[\"Gym\"]\";s:10:\"menu_order\";i:97;s:16:\"popularity_index\";i:310;s:11:\"trend_index\";i:229;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:426;a:15:{s:2:\"id\";i:16332;s:5:\"title\";s:31:\"Luxury Flat &#8211; Real Estate\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2016/08/0007.png\";s:12:\"tmpl_created\";i:1607868929;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/lp/luxury-flat-real-estate/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:11:\"Real Estate\";s:4:\"tags\";s:38:\"[\"flat\",\"Landing Pages\",\"Real estate\"]\";s:10:\"menu_order\";i:98;s:16:\"popularity_index\";i:809;s:11:\"trend_index\";i:707;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:427;a:15:{s:2:\"id\";i:16392;s:5:\"title\";s:30:\"Open House &#8211; Real Estate\";s:9:\"thumbnail\";s:87:\"https://library.elementor.com/wp-content/uploads/2017/05/Landing-Page-Real-Estate-3.png\";s:12:\"tmpl_created\";i:1607869551;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/lp/landing-page-real-estate-5/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:11:\"Real Estate\";s:4:\"tags\";s:150:\"[\"Agent\",\"Business\",\"clean\",\"corporate\",\"flat\",\"google maps\",\"homes\",\"Landing Pages\",\"listing\",\"modern\",\"Real estate\",\"Realestate\",\"realtor\",\"realty\"]\";s:10:\"menu_order\";i:98;s:16:\"popularity_index\";i:839;s:11:\"trend_index\";i:0;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:428;a:15:{s:2:\"id\";i:5904;s:5:\"title\";s:6:\"CTA 27\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_white_13.png\";s:12:\"tmpl_created\";i:1520520754;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/blocks/cta-27/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:98;s:16:\"popularity_index\";i:528;s:11:\"trend_index\";i:517;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:429;a:15:{s:2:\"id\";i:12116;s:5:\"title\";s:24:\"Law Firm &#8211; Service\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2019/11/family_law.png\";s:12:\"tmpl_created\";i:1572847105;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/law-firm-service/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:18:\"[\"Law\",\"Law Firm\"]\";s:10:\"menu_order\";i:98;s:16:\"popularity_index\";i:489;s:11:\"trend_index\";i:339;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:430;a:15:{s:2:\"id\";i:9985;s:5:\"title\";s:20:\"Slide In | Promotion\";s:9:\"thumbnail\";s:87:\"https://library.elementor.com/wp-content/uploads/2019/01/slidein_promotion_av_small.png\";s:12:\"tmpl_created\";i:1547844661;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/popups/slide-in-promotion-3/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:98;s:16:\"popularity_index\";i:758;s:11:\"trend_index\";i:815;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:431;a:15:{s:2:\"id\";i:15950;s:5:\"title\";s:30:\"Stylist &#8211; Online Service\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2017/03/Landing-Page-Stylist.png\";s:12:\"tmpl_created\";i:1607862286;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/lp/stylist-online-service/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:14:\"Online Service\";s:4:\"tags\";s:162:\"[\"cosmetics\",\"Fashion\",\"girly\",\"hairdresser\",\"Landing Pages\",\"lifestyle\",\"makeup\",\"manicure\",\"pedicure\",\"Products\",\"salon\",\"Shop\",\"skincare\",\"stylist\",\"wellness\"]\";s:10:\"menu_order\";i:99;s:16:\"popularity_index\";i:853;s:11:\"trend_index\";i:805;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:432;a:15:{s:2:\"id\";i:16346;s:5:\"title\";s:33:\"Your New Home &#8211; Real Estate\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2017/03/lp3-l.png\";s:12:\"tmpl_created\";i:1607869068;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/lp/your-new-home-real-estate/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:11:\"Real Estate\";s:4:\"tags\";s:31:\"[\"Landing Pages\",\"Real estate\"]\";s:10:\"menu_order\";i:99;s:16:\"popularity_index\";i:791;s:11:\"trend_index\";i:696;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:433;a:15:{s:2:\"id\";i:11094;s:5:\"title\";s:30:\"Digital Agency &#8211; Clients\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2019/07/Clients_small.png\";s:12:\"tmpl_created\";i:1564641885;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/digital-agency-clients/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:30:\"[\"Digital Agency\",\"marketing\"]\";s:10:\"menu_order\";i:99;s:16:\"popularity_index\";i:424;s:11:\"trend_index\";i:424;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:434;a:15:{s:2:\"id\";i:5912;s:5:\"title\";s:6:\"CTA 28\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_black_11.png\";s:12:\"tmpl_created\";i:1520520755;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/blocks/cta-28/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:99;s:16:\"popularity_index\";i:665;s:11:\"trend_index\";i:702;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:435;a:15:{s:2:\"id\";i:16253;s:5:\"title\";s:33:\"Bicycle Adventures &#8211; Travel\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2016/08/0005.png\";s:12:\"tmpl_created\";i:1607867944;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/lp/bicycle-adventures-travel/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:6:\"Travel\";s:4:\"tags\";s:36:\"[\"Bicycle\",\"Landing Pages\",\"Travel\"]\";s:10:\"menu_order\";i:100;s:16:\"popularity_index\";i:785;s:11:\"trend_index\";i:524;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:436;a:15:{s:2:\"id\";i:16358;s:5:\"title\";s:41:\"Sunset Valley Project &#8211; Real Estate\";s:9:\"thumbnail\";s:87:\"https://library.elementor.com/wp-content/uploads/2017/05/Landing-Page-Real-Estate-1.png\";s:12:\"tmpl_created\";i:1607869234;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:126:\"https://library.elementor.com/lp/sunset-valley-project-real-estate/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:11:\"Real Estate\";s:4:\"tags\";s:31:\"[\"Landing Pages\",\"Real estate\"]\";s:10:\"menu_order\";i:100;s:16:\"popularity_index\";i:846;s:11:\"trend_index\";i:743;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:437;a:15:{s:2:\"id\";i:11478;s:5:\"title\";s:17:\"Gym &#8211; About\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2019/08/About_Small.png\";s:12:\"tmpl_created\";i:1567392939;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:99:\"https://library.elementor.com/gym-about/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:7:\"[\"Gym\"]\";s:10:\"menu_order\";i:100;s:16:\"popularity_index\";i:481;s:11:\"trend_index\";i:579;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:438;a:15:{s:2:\"id\";i:5189;s:5:\"title\";s:6:\"CTA 29\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/form_white_1.png\";s:12:\"tmpl_created\";i:1520443456;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/blocks/cta-29/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:8:\"[\"form\"]\";s:10:\"menu_order\";i:100;s:16:\"popularity_index\";i:472;s:11:\"trend_index\";i:631;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:439;a:15:{s:2:\"id\";i:16271;s:5:\"title\";s:42:\"Luxury Travel Destinations  &#8211; Travel\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2017/05/Landing-Page-Truism-1.png\";s:12:\"tmpl_created\";i:1607868120;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:126:\"https://library.elementor.com/lp/luxury-travel-destinations-travel/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:6:\"Travel\";s:4:\"tags\";s:37:\"[\"Landing Pages\",\"Travel\",\"Vacation\"]\";s:10:\"menu_order\";i:101;s:16:\"popularity_index\";i:830;s:11:\"trend_index\";i:833;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:440;a:15:{s:2:\"id\";i:16379;s:5:\"title\";s:33:\"Property Page &#8211; Real Estate\";s:9:\"thumbnail\";s:87:\"https://library.elementor.com/wp-content/uploads/2017/05/Landing-Page-Real-Estate-2.png\";s:12:\"tmpl_created\";i:1607869379;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/lp/property-page-real-estate/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:11:\"Real Estate\";s:4:\"tags\";s:42:\"[\"Landing Pages\",\"Property\",\"Real estate\"]\";s:10:\"menu_order\";i:101;s:16:\"popularity_index\";i:864;s:11:\"trend_index\";i:0;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:441;a:15:{s:2:\"id\";i:11563;s:5:\"title\";s:19:\"Gym &#8211; Pricing\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2019/08/Pricing_Small.png\";s:12:\"tmpl_created\";i:1567392923;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:101:\"https://library.elementor.com/gym-pricing/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:7:\"[\"Gym\"]\";s:10:\"menu_order\";i:101;s:16:\"popularity_index\";i:577;s:11:\"trend_index\";i:736;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:442;a:15:{s:2:\"id\";i:5667;s:5:\"title\";s:5:\"CTA 3\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_white_8.png\";s:12:\"tmpl_created\";i:1520520705;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:102:\"https://library.elementor.com/blocks/cta-3/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:101;s:16:\"popularity_index\";i:171;s:11:\"trend_index\";i:250;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:443;a:15:{s:2:\"id\";i:16283;s:5:\"title\";s:29:\"Vacation Deals &#8211; Travel\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2017/05/Landing-Page-Truism-2.png\";s:12:\"tmpl_created\";i:1607868279;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/lp/vacation-deals-travel/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:6:\"Travel\";s:4:\"tags\";s:37:\"[\"Landing Pages\",\"Travel\",\"Vacation\"]\";s:10:\"menu_order\";i:102;s:16:\"popularity_index\";i:850;s:11:\"trend_index\";i:799;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:444;a:15:{s:2:\"id\";i:11034;s:5:\"title\";s:30:\"Digital Agency &#8211; Contact\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2019/07/Contsct-Us_small.png\";s:12:\"tmpl_created\";i:1564641881;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/contact-digital-agency/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:30:\"[\"Digital Agency\",\"marketing\"]\";s:10:\"menu_order\";i:102;s:16:\"popularity_index\";i:191;s:11:\"trend_index\";i:156;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:445;a:15:{s:2:\"id\";i:5198;s:5:\"title\";s:6:\"CTA 30\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/form_black_1.png\";s:12:\"tmpl_created\";i:1520443458;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/blocks/cta-30/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:8:\"[\"form\"]\";s:10:\"menu_order\";i:102;s:16:\"popularity_index\";i:572;s:11:\"trend_index\";i:511;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:446;a:15:{s:2:\"id\";i:16299;s:5:\"title\";s:29:\"New Adventures &#8211; Travel\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2017/05/Landing-Page-Truism-3.png\";s:12:\"tmpl_created\";i:1607868454;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/lp/new-adventures-travel/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:6:\"Travel\";s:4:\"tags\";s:50:\"[\"Adventures\",\"Landing Pages\",\"Travel\",\"Vacation\"]\";s:10:\"menu_order\";i:103;s:16:\"popularity_index\";i:849;s:11:\"trend_index\";i:830;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:447;a:15:{s:2:\"id\";i:11528;s:5:\"title\";s:19:\"Gym &#8211; Contact\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2019/08/Contact_Small.png\";s:12:\"tmpl_created\";i:1567392917;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:101:\"https://library.elementor.com/gym-contact/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:7:\"[\"Gym\"]\";s:10:\"menu_order\";i:103;s:16:\"popularity_index\";i:505;s:11:\"trend_index\";i:624;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:448;a:15:{s:2:\"id\";i:5206;s:5:\"title\";s:6:\"CTA 31\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/form_black_2.png\";s:12:\"tmpl_created\";i:1520443459;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/blocks/cta-31/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:8:\"[\"form\"]\";s:10:\"menu_order\";i:103;s:16:\"popularity_index\";i:593;s:11:\"trend_index\";i:611;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:449;a:15:{s:2:\"id\";i:519;s:5:\"title\";s:24:\"Homepage &#8211; Fitness\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2016/10/0023.png\";s:12:\"tmpl_created\";i:1477388808;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/homepage-fitness/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:45:\"[\"Fitness\",\"Gym\",\"Health\",\"Homepage\",\"Sport\"]\";s:10:\"menu_order\";i:104;s:16:\"popularity_index\";i:10;s:11:\"trend_index\";i:62;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:450;a:15:{s:2:\"id\";i:16312;s:5:\"title\";s:26:\"Summer Time &#8211; Travel\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2017/11/Vacation-–-Landing-Page.png\";s:12:\"tmpl_created\";i:1607868625;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/lp/summer-time-travel/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:6:\"Travel\";s:4:\"tags\";s:37:\"[\"Landing Pages\",\"Travel\",\"Vacation\"]\";s:10:\"menu_order\";i:104;s:16:\"popularity_index\";i:829;s:11:\"trend_index\";i:0;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:451;a:15:{s:2:\"id\";i:5249;s:5:\"title\";s:6:\"CTA 32\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/form_black_4.png\";s:12:\"tmpl_created\";i:1520443470;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/blocks/cta-32/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:8:\"[\"form\"]\";s:10:\"menu_order\";i:104;s:16:\"popularity_index\";i:512;s:11:\"trend_index\";i:409;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:452;a:15:{s:2:\"id\";i:487;s:5:\"title\";s:29:\"Landing Page &#8211; Vacation\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2016/10/0021.png\";s:12:\"tmpl_created\";i:1477388357;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/landing-page-vacation/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:105;s:16:\"popularity_index\";i:32;s:11:\"trend_index\";i:136;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:453;a:15:{s:2:\"id\";i:15870;s:5:\"title\";s:32:\"Tel Aviv Vacation &#8211; Travel\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2016/10/0021.png\";s:12:\"tmpl_created\";i:1607860195;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/lp/tel-aviv-vacation-travel/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:6:\"Travel\";s:4:\"tags\";s:17:\"[\"Landing Pages\"]\";s:10:\"menu_order\";i:105;s:16:\"popularity_index\";i:802;s:11:\"trend_index\";i:688;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:454;a:15:{s:2:\"id\";i:5550;s:5:\"title\";s:6:\"CTA 33\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_black_1.png\";s:12:\"tmpl_created\";i:1520520682;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/blocks/cta-33/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:105;s:16:\"popularity_index\";i:260;s:11:\"trend_index\";i:562;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:455;a:15:{s:2:\"id\";i:9559;s:5:\"title\";s:16:\"Slide In | Login\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2019/01/slidein_login_01_small.png\";s:12:\"tmpl_created\";i:1546946547;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/popups/slide-in-login-01/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:105;s:16:\"popularity_index\";i:617;s:11:\"trend_index\";i:839;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:456;a:15:{s:2:\"id\";i:5852;s:5:\"title\";s:6:\"CTA 34\";s:9:\"thumbnail\";s:67:\"https://library.elementor.com/wp-content/uploads/2018/03/form_1.png\";s:12:\"tmpl_created\";i:1520443600;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/blocks/cta-34/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:8:\"[\"form\"]\";s:10:\"menu_order\";i:106;s:16:\"popularity_index\";i:563;s:11:\"trend_index\";i:828;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:457;a:15:{s:2:\"id\";i:855;s:5:\"title\";s:37:\"Landing Page &#8211; Personal Trainer\";s:9:\"thumbnail\";s:90:\"https://library.elementor.com/wp-content/uploads/2017/02/Landing-Page-Personal-Trainer.png\";s:12:\"tmpl_created\";i:1494352061;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/landing-page-personal-trainer/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:106;s:16:\"popularity_index\";i:290;s:11:\"trend_index\";i:394;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:458;a:15:{s:2:\"id\";i:16440;s:5:\"title\";s:31:\"Marketing Webinar &#8211; Event\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2016/08/0015.png\";s:12:\"tmpl_created\";i:1607934662;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/lp/marketing-webinar-event/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:6:\"Events\";s:4:\"tags\";s:37:\"[\"Event\",\"Landing Pages\",\"Marketing\"]\";s:10:\"menu_order\";i:106;s:16:\"popularity_index\";i:794;s:11:\"trend_index\";i:762;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:459;a:15:{s:2:\"id\";i:955;s:5:\"title\";s:31:\"Landing Page &#8211; Law Office\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2017/02/Landing-Page-Law-Office.png\";s:12:\"tmpl_created\";i:1494352069;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:113:\"https://library.elementor.com/landing-page-law-office/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:31:\"[\"Landing Page\",\"Law\",\"Office\"]\";s:10:\"menu_order\";i:107;s:16:\"popularity_index\";i:202;s:11:\"trend_index\";i:271;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:460;a:15:{s:2:\"id\";i:16212;s:5:\"title\";s:33:\"Wedding Celebration &#8211; Event\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2016/10/0025.png\";s:12:\"tmpl_created\";i:1607867299;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/lp/wedding-celebration-event/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:6:\"Events\";s:4:\"tags\";s:35:\"[\"Event\",\"Landing Pages\",\"Wedding\"]\";s:10:\"menu_order\";i:107;s:16:\"popularity_index\";i:798;s:11:\"trend_index\";i:730;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:461;a:15:{s:2:\"id\";i:5675;s:5:\"title\";s:5:\"CTA 4\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_black_8.png\";s:12:\"tmpl_created\";i:1520520707;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:102:\"https://library.elementor.com/blocks/cta-4/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:107;s:16:\"popularity_index\";i:391;s:11:\"trend_index\";i:484;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:462;a:15:{s:2:\"id\";i:9752;s:5:\"title\";s:27:\"Slide In | Sale | Promotion\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2019/01/rush_small.png\";s:12:\"tmpl_created\";i:1547823982;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.elementor.com/popups/slide-in-sale-promotion/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:107;s:16:\"popularity_index\";i:740;s:11:\"trend_index\";i:801;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:463;a:15:{s:2:\"id\";i:5591;s:5:\"title\";s:5:\"CTA 5\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_white_4.png\";s:12:\"tmpl_created\";i:1520520691;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:102:\"https://library.elementor.com/blocks/cta-5/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:108;s:16:\"popularity_index\";i:133;s:11:\"trend_index\";i:130;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:464;a:15:{s:2:\"id\";i:9373;s:5:\"title\";s:33:\"Landing Page &#8211; Conference 5\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2018/11/conference-250.png\";s:12:\"tmpl_created\";i:1542811219;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/landing-page-conference-5/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:108;s:16:\"popularity_index\";i:283;s:11:\"trend_index\";i:325;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:465;a:15:{s:2:\"id\";i:974;s:5:\"title\";s:28:\"Landing Page &#8211; Stylist\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2017/03/Landing-Page-Stylist.png\";s:12:\"tmpl_created\";i:1494352071;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/landing-page-stylist/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:146:\"[\"cosmetics\",\"fashion\",\"girly\",\"hairdresser\",\"lifestyle\",\"makeup\",\"manicure\",\"pedicure\",\"products\",\"salon\",\"Shop\",\"skincare\",\"stylist\",\"wellness\"]\";s:10:\"menu_order\";i:109;s:16:\"popularity_index\";i:329;s:11:\"trend_index\";i:512;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:466;a:15:{s:2:\"id\";i:5599;s:5:\"title\";s:5:\"CTA 6\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_black_4.png\";s:12:\"tmpl_created\";i:1520520693;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:102:\"https://library.elementor.com/blocks/cta-6/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:109;s:16:\"popularity_index\";i:252;s:11:\"trend_index\";i:362;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:467;a:15:{s:2:\"id\";i:5575;s:5:\"title\";s:5:\"CTA 7\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_white_3.png\";s:12:\"tmpl_created\";i:1520443543;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:102:\"https://library.elementor.com/blocks/cta-7/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:110;s:16:\"popularity_index\";i:13;s:11:\"trend_index\";i:586;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:468;a:15:{s:2:\"id\";i:11948;s:5:\"title\";s:18:\"Maintenance Mode 3\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2019/10/mm3.png\";s:12:\"tmpl_created\";i:1572153978;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/maintenance-mode-3/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:20:\"[\"Maintenance mode\"]\";s:10:\"menu_order\";i:110;s:16:\"popularity_index\";i:195;s:11:\"trend_index\";i:259;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:469;a:15:{s:2:\"id\";i:754;s:5:\"title\";s:25:\"Services &#8211; Interior\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2017/01/Interior-Services.png\";s:12:\"tmpl_created\";i:1485269691;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/services-interior/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:111;s:16:\"popularity_index\";i:251;s:11:\"trend_index\";i:400;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:470;a:15:{s:2:\"id\";i:5658;s:5:\"title\";s:5:\"CTA 8\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_black_7.png\";s:12:\"tmpl_created\";i:1520520704;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:102:\"https://library.elementor.com/blocks/cta-8/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:111;s:16:\"popularity_index\";i:187;s:11:\"trend_index\";i:235;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:471;a:15:{s:2:\"id\";i:10169;s:5:\"title\";s:37:\"Slide In | Register | Subscribe | App\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2019/01/slideinapp_small.png\";s:12:\"tmpl_created\";i:1547852334;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:126:\"https://library.elementor.com/popups/slide-in-register-subscribe-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:112;s:16:\"popularity_index\";i:546;s:11:\"trend_index\";i:701;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:472;a:15:{s:2:\"id\";i:752;s:5:\"title\";s:24:\"Contact &#8211; Interior\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2017/01/interior-contact.png\";s:12:\"tmpl_created\";i:1485269737;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/contact-interior/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:112;s:16:\"popularity_index\";i:344;s:11:\"trend_index\";i:425;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:473;a:15:{s:2:\"id\";i:5650;s:5:\"title\";s:5:\"CTA 9\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_white_7.png\";s:12:\"tmpl_created\";i:1520520702;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:102:\"https://library.elementor.com/blocks/cta-9/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:112;s:16:\"popularity_index\";i:94;s:11:\"trend_index\";i:148;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:474;a:15:{s:2:\"id\";i:15407;s:5:\"title\";s:24:\"Dance Studio &#8211; 404\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2020/10/404.jpg\";s:12:\"tmpl_created\";i:1603181958;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:113:\"https://library.elementor.com/blocks/dance-studio-404/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:22:\"[\"404\",\"dance studio\"]\";s:10:\"menu_order\";i:113;s:16:\"popularity_index\";i:783;s:11:\"trend_index\";i:710;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:475;a:15:{s:2:\"id\";i:753;s:5:\"title\";s:22:\"About &#8211; Interior\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2017/01/Interior-About.png\";s:12:\"tmpl_created\";i:1485269710;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:104:\"https://library.elementor.com/about-interior/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:113;s:16:\"popularity_index\";i:309;s:11:\"trend_index\";i:435;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:476;a:15:{s:2:\"id\";i:15400;s:5:\"title\";s:27:\"Dance Studio &#8211; Footer\";s:9:\"thumbnail\";s:67:\"https://library.elementor.com/wp-content/uploads/2020/10/Footer.jpg\";s:12:\"tmpl_created\";i:1603181989;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/blocks/dance-studio-footer/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:25:\"[\"dance studio\",\"footer\"]\";s:10:\"menu_order\";i:114;s:16:\"popularity_index\";i:586;s:11:\"trend_index\";i:243;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:477;a:15:{s:2:\"id\";i:751;s:5:\"title\";s:25:\"Homepage &#8211; Interior\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2017/01/interior-home.png\";s:12:\"tmpl_created\";i:1485269743;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/homepage-interior/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:114;s:16:\"popularity_index\";i:258;s:11:\"trend_index\";i:200;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:478;a:15:{s:2:\"id\";i:15391;s:5:\"title\";s:27:\"Dance Studio &#8211; Header\";s:9:\"thumbnail\";s:67:\"https://library.elementor.com/wp-content/uploads/2020/10/Header.jpg\";s:12:\"tmpl_created\";i:1603182011;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/blocks/dance-studio-header/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:25:\"[\"dance studio\",\"header\"]\";s:10:\"menu_order\";i:115;s:16:\"popularity_index\";i:352;s:11:\"trend_index\";i:67;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:479;a:15:{s:2:\"id\";i:2402;s:5:\"title\";s:32:\"Homepage &#8211; Interior Design\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2017/09/Interior.png\";s:12:\"tmpl_created\";i:1506441447;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/homepage-interior-design/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:193:\"[\"Architecture\",\"building\",\"business\",\"Creative\",\"exterior design\",\"furniture design\",\"Gallery\",\"garden design\",\"house\",\"interior design\",\"landscape design\",\"multipurpose\",\"portfolio\",\"studio\"]\";s:10:\"menu_order\";i:115;s:16:\"popularity_index\";i:126;s:11:\"trend_index\";i:257;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:480;a:15:{s:2:\"id\";i:9680;s:5:\"title\";s:23:\"Slide In | Content Lock\";s:9:\"thumbnail\";s:91:\"https://library.elementor.com/wp-content/uploads/2019/01/Slide-in_Content-lock_small_01.png\";s:12:\"tmpl_created\";i:1547010967;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:121:\"https://library.elementor.com/popups/slide-in-content-lock-01/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:115;s:16:\"popularity_index\";i:725;s:11:\"trend_index\";i:725;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:481;a:15:{s:2:\"id\";i:11192;s:5:\"title\";s:14:\"Digital Agency\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2019/07/Footer_small.jpg\";s:12:\"tmpl_created\";i:1564642399;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:113:\"https://library.elementor.com/blocks/digital-agency-5/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:39:\"[\"Digital Agency\",\"footer\",\"marketing\"]\";s:10:\"menu_order\";i:116;s:16:\"popularity_index\";i:172;s:11:\"trend_index\";i:105;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:482;a:15:{s:2:\"id\";i:3626;s:5:\"title\";s:30:\"Snowboard Site &#8211; Contact\";s:9:\"thumbnail\";s:62:\"https://library.elementor.com/wp-content/uploads/2017/12/3.png\";s:12:\"tmpl_created\";i:1513513193;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/snowboard-site-contact/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:116;s:16:\"popularity_index\";i:293;s:11:\"trend_index\";i:637;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:483;a:15:{s:2:\"id\";i:11198;s:5:\"title\";s:14:\"Digital Agency\";s:9:\"thumbnail\";s:92:\"https://library.elementor.com/wp-content/uploads/2020/06/Header-digital-marketing-agency.png\";s:12:\"tmpl_created\";i:1564642395;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:113:\"https://library.elementor.com/blocks/digital-agency-4/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:39:\"[\"Digital Agency\",\"header\",\"marketing\"]\";s:10:\"menu_order\";i:117;s:16:\"popularity_index\";i:34;s:11:\"trend_index\";i:10;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:484;a:15:{s:2:\"id\";i:11966;s:5:\"title\";s:18:\"Maintenance mode 4\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2019/10/mm4.png\";s:12:\"tmpl_created\";i:1572154274;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/maintenance-mode-4/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:20:\"[\"Maintenance mode\"]\";s:10:\"menu_order\";i:117;s:16:\"popularity_index\";i:490;s:11:\"trend_index\";i:595;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:485;a:15:{s:2:\"id\";i:9783;s:5:\"title\";s:31:\"Slide In | Register | Subscribe\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2019/01/slidein_yellow_small.png\";s:12:\"tmpl_created\";i:1547831059;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:124:\"https://library.elementor.com/popups/slide-in-register-subscribe/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:117;s:16:\"popularity_index\";i:534;s:11:\"trend_index\";i:415;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:486;a:15:{s:2:\"id\";i:11204;s:5:\"title\";s:14:\"Digital Agency\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2019/07/404_small.jpg\";s:12:\"tmpl_created\";i:1564642389;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:113:\"https://library.elementor.com/blocks/digital-agency-3/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:36:\"[\"404\",\"Digital Agency\",\"marketing\"]\";s:10:\"menu_order\";i:118;s:16:\"popularity_index\";i:301;s:11:\"trend_index\";i:239;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:487;a:15:{s:2:\"id\";i:3632;s:5:\"title\";s:31:\"Snowboard Site &#8211; Services\";s:9:\"thumbnail\";s:62:\"https://library.elementor.com/wp-content/uploads/2017/12/2.png\";s:12:\"tmpl_created\";i:1513513171;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:113:\"https://library.elementor.com/snowboard-site-services/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:118;s:16:\"popularity_index\";i:222;s:11:\"trend_index\";i:342;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:488;a:15:{s:2:\"id\";i:11220;s:5:\"title\";s:14:\"Digital Agency\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2019/08/Archive_small1.png\";s:12:\"tmpl_created\";i:1564642385;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:113:\"https://library.elementor.com/blocks/digital-agency-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"archive\";s:4:\"tags\";s:30:\"[\"Digital Agency\",\"marketing\"]\";s:10:\"menu_order\";i:119;s:16:\"popularity_index\";i:116;s:11:\"trend_index\";i:73;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:489;a:15:{s:2:\"id\";i:3619;s:5:\"title\";s:31:\"Snowboard Site &#8211; Homepage\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2017/12/home.png\";s:12:\"tmpl_created\";i:1513513137;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:113:\"https://library.elementor.com/snowboard-site-homepage/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:119;s:16:\"popularity_index\";i:232;s:11:\"trend_index\";i:219;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:490;a:15:{s:2:\"id\";i:11231;s:5:\"title\";s:14:\"Digital Agency\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2019/07/Post_small1.png\";s:12:\"tmpl_created\";i:1564642380;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/blocks/digital-agency/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:30:\"[\"Digital Agency\",\"marketing\"]\";s:10:\"menu_order\";i:120;s:16:\"popularity_index\";i:145;s:11:\"trend_index\";i:71;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:491;a:15:{s:2:\"id\";i:9425;s:5:\"title\";s:38:\"Black Friday &#8211;  80&#8217;s style\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/11/unnamed-file.png\";s:12:\"tmpl_created\";i:1542901234;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/black-friday-80s-style/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:120;s:16:\"popularity_index\";i:360;s:11:\"trend_index\";i:472;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:492;a:15:{s:2:\"id\";i:5711;s:5:\"title\";s:5:\"FAQ 1\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/faq_black_2.png\";s:12:\"tmpl_created\";i:1520443571;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:102:\"https://library.elementor.com/blocks/faq-1/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:3:\"faq\";s:4:\"tags\";s:7:\"[\"faq\"]\";s:10:\"menu_order\";i:121;s:16:\"popularity_index\";i:200;s:11:\"trend_index\";i:231;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:493;a:15:{s:2:\"id\";i:11973;s:5:\"title\";s:18:\"Maintenance mode 5\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2019/10/mm5.png\";s:12:\"tmpl_created\";i:1572154523;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/maintenance-mode-5/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:20:\"[\"Maintenance mode\"]\";s:10:\"menu_order\";i:121;s:16:\"popularity_index\";i:418;s:11:\"trend_index\";i:476;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:494;a:15:{s:2:\"id\";i:5737;s:5:\"title\";s:6:\"FAQ 10\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/faq_white_4.png\";s:12:\"tmpl_created\";i:1520443576;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/blocks/faq-10/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:3:\"faq\";s:4:\"tags\";s:7:\"[\"faq\"]\";s:10:\"menu_order\";i:122;s:16:\"popularity_index\";i:155;s:11:\"trend_index\";i:112;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:495;a:15:{s:2:\"id\";i:11981;s:5:\"title\";s:18:\"Maintenance mode 6\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2019/10/mm6.png\";s:12:\"tmpl_created\";i:1572155125;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/maintenance-mode-6/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:20:\"[\"Maintenance mode\"]\";s:10:\"menu_order\";i:122;s:16:\"popularity_index\";i:410;s:11:\"trend_index\";i:390;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:496;a:15:{s:2:\"id\";i:5746;s:5:\"title\";s:6:\"FAQ 11\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/faq_black_4.png\";s:12:\"tmpl_created\";i:1520443578;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/blocks/faq-11/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:3:\"faq\";s:4:\"tags\";s:7:\"[\"faq\"]\";s:10:\"menu_order\";i:123;s:16:\"popularity_index\";i:212;s:11:\"trend_index\";i:305;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:497;a:15:{s:2:\"id\";i:5703;s:5:\"title\";s:6:\"FAQ 13\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/faq_white_2.png\";s:12:\"tmpl_created\";i:1520443569;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/blocks/faq-13/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:3:\"faq\";s:4:\"tags\";s:7:\"[\"faq\"]\";s:10:\"menu_order\";i:124;s:16:\"popularity_index\";i:29;s:11:\"trend_index\";i:38;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:498;a:15:{s:2:\"id\";i:147;s:5:\"title\";s:20:\"Homepage &#8211; App\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2016/08/0004.png\";s:12:\"tmpl_created\";i:1470829868;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:102:\"https://library.elementor.com/homepage-app/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:18:\"[\"App\",\"Homepage\"]\";s:10:\"menu_order\";i:124;s:16:\"popularity_index\";i:5;s:11:\"trend_index\";i:16;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:499;a:15:{s:2:\"id\";i:5719;s:5:\"title\";s:5:\"FAQ 4\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/faq_white_3.png\";s:12:\"tmpl_created\";i:1520443573;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:102:\"https://library.elementor.com/blocks/faq-4/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:3:\"faq\";s:4:\"tags\";s:7:\"[\"faq\"]\";s:10:\"menu_order\";i:125;s:16:\"popularity_index\";i:125;s:11:\"trend_index\";i:251;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:500;a:15:{s:2:\"id\";i:777;s:5:\"title\";s:28:\"Homepage &#8211; Coffee Shop\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2017/01/rest-home.jpg\";s:12:\"tmpl_created\";i:1485273092;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/homepage-coffee-shop/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:41:\"[\"Coffee\",\"Homepage\",\"Restaurant\",\"Shop\"]\";s:10:\"menu_order\";i:125;s:16:\"popularity_index\";i:175;s:11:\"trend_index\";i:414;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:501;a:15:{s:2:\"id\";i:5729;s:5:\"title\";s:5:\"FAQ 5\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/faq_black_3.png\";s:12:\"tmpl_created\";i:1520443575;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:102:\"https://library.elementor.com/blocks/faq-5/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:3:\"faq\";s:4:\"tags\";s:7:\"[\"faq\"]\";s:10:\"menu_order\";i:126;s:16:\"popularity_index\";i:319;s:11:\"trend_index\";i:327;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:502;a:15:{s:2:\"id\";i:2404;s:5:\"title\";s:24:\"Homepage &#8211; Product\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2017/09/product.png\";s:12:\"tmpl_created\";i:1506441452;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/homepage-product/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:103:\"[\"business\",\"colorful\",\"ecommerce\",\"flat\",\"mobile\",\"modern\",\"responsive\",\"retina\",\"Shop\",\"woocommerce\"]\";s:10:\"menu_order\";i:126;s:16:\"popularity_index\";i:164;s:11:\"trend_index\";i:286;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:503;a:15:{s:2:\"id\";i:5755;s:5:\"title\";s:5:\"FAQ 6\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/faq_white_5.png\";s:12:\"tmpl_created\";i:1520443580;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:102:\"https://library.elementor.com/blocks/faq-6/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:3:\"faq\";s:4:\"tags\";s:7:\"[\"faq\"]\";s:10:\"menu_order\";i:127;s:16:\"popularity_index\";i:112;s:11:\"trend_index\";i:180;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:504;a:15:{s:2:\"id\";i:492;s:5:\"title\";s:25:\"Homepage &#8211; Law firm\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2016/10/0024.png\";s:12:\"tmpl_created\";i:1477388365;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/homepage-law-firm/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:25:\"[\"Firm\",\"Homepage\",\"Law\"]\";s:10:\"menu_order\";i:127;s:16:\"popularity_index\";i:14;s:11:\"trend_index\";i:79;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:505;a:15:{s:2:\"id\";i:5764;s:5:\"title\";s:5:\"FAQ 7\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/faq_black_5.png\";s:12:\"tmpl_created\";i:1520443582;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:102:\"https://library.elementor.com/blocks/faq-7/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:3:\"faq\";s:4:\"tags\";s:7:\"[\"faq\"]\";s:10:\"menu_order\";i:128;s:16:\"popularity_index\";i:338;s:11:\"trend_index\";i:474;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:506;a:15:{s:2:\"id\";i:3451;s:5:\"title\";s:39:\"Homepage &#8211; Goodness meal services\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2017/11/goodness-featured-image.png\";s:12:\"tmpl_created\";i:1512054116;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:121:\"https://library.elementor.com/homepage-goodness-meal-services/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:128;s:16:\"popularity_index\";i:266;s:11:\"trend_index\";i:407;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:507;a:15:{s:2:\"id\";i:5684;s:5:\"title\";s:5:\"FAQ 8\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/faq_white_1.png\";s:12:\"tmpl_created\";i:1520443565;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:102:\"https://library.elementor.com/blocks/faq-8/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:3:\"faq\";s:4:\"tags\";s:7:\"[\"faq\"]\";s:10:\"menu_order\";i:129;s:16:\"popularity_index\";i:74;s:11:\"trend_index\";i:193;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:508;a:15:{s:2:\"id\";i:2152;s:5:\"title\";s:26:\"Homepage &#8211; Cake Shop\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2017/07/cake-home.png\";s:12:\"tmpl_created\";i:1499774132;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/homepage-cake-shop/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:39:\"[\"Cake\",\"Homepage\",\"Restaurant\",\"Shop\"]\";s:10:\"menu_order\";i:129;s:16:\"popularity_index\";i:382;s:11:\"trend_index\";i:530;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:509;a:15:{s:2:\"id\";i:5693;s:5:\"title\";s:5:\"FAQ 9\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/faq_black_1.png\";s:12:\"tmpl_created\";i:1520443567;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:102:\"https://library.elementor.com/blocks/faq-9/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:3:\"faq\";s:4:\"tags\";s:7:\"[\"faq\"]\";s:10:\"menu_order\";i:130;s:16:\"popularity_index\";i:224;s:11:\"trend_index\";i:515;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:510;a:15:{s:2:\"id\";i:1068;s:5:\"title\";s:27:\"Homepage &#8211; Copywriter\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2017/03/copywriter.png\";s:12:\"tmpl_created\";i:1488805928;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:109:\"https://library.elementor.com/homepage-copywriter/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:25:\"[\"Copywriter\",\"Homepage\"]\";s:10:\"menu_order\";i:130;s:16:\"popularity_index\";i:249;s:11:\"trend_index\";i:437;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:511;a:15:{s:2:\"id\";i:6053;s:5:\"title\";s:10:\"Features 1\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2018/03/features_black_5.png\";s:12:\"tmpl_created\";i:1520443645;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/blocks/features-1/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"features\";s:4:\"tags\";s:12:\"[\"features\"]\";s:10:\"menu_order\";i:131;s:16:\"popularity_index\";i:179;s:11:\"trend_index\";i:463;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:512;a:15:{s:2:\"id\";i:2813;s:5:\"title\";s:32:\"Homepage &#8211; Creative Agency\";s:9:\"thumbnail\";s:90:\"https://library.elementor.com/wp-content/uploads/2017/11/Creative-Agency-–-Home-Page.png\";s:12:\"tmpl_created\";i:1509615049;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/homepage-creative-agency/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:32:\"[\"Agency\",\"Creative\",\"Homepage\"]\";s:10:\"menu_order\";i:131;s:16:\"popularity_index\";i:130;s:11:\"trend_index\";i:215;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:513;a:15:{s:2:\"id\";i:5991;s:5:\"title\";s:11:\"Features 10\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2018/03/features_white_4.png\";s:12:\"tmpl_created\";i:1520443632;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/features-10/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"features\";s:4:\"tags\";s:12:\"[\"features\"]\";s:10:\"menu_order\";i:132;s:16:\"popularity_index\";i:135;s:11:\"trend_index\";i:265;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:514;a:15:{s:2:\"id\";i:728;s:5:\"title\";s:33:\"Homepage &#8211; Delivery Company\";s:9:\"thumbnail\";s:87:\"https://library.elementor.com/wp-content/uploads/2017/01/delivery-company-home-page.jpg\";s:12:\"tmpl_created\";i:1485269993;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/homepage-delivery-company/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:23:\"[\"Delivery\",\"Homepage\"]\";s:10:\"menu_order\";i:132;s:16:\"popularity_index\";i:324;s:11:\"trend_index\";i:790;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:515;a:15:{s:2:\"id\";i:6044;s:5:\"title\";s:11:\"Features 11\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2018/03/features_white_5.png\";s:12:\"tmpl_created\";i:1520443643;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/features-11/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"features\";s:4:\"tags\";s:12:\"[\"features\"]\";s:10:\"menu_order\";i:133;s:16:\"popularity_index\";i:70;s:11:\"trend_index\";i:163;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:516;a:15:{s:2:\"id\";i:2403;s:5:\"title\";s:29:\"Homepage &#8211; Luxury Hotel\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2017/09/Hotel.png\";s:12:\"tmpl_created\";i:1506441428;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/homepage-luxury-hotel/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:133;s:16:\"popularity_index\";i:314;s:11:\"trend_index\";i:499;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:517;a:15:{s:2:\"id\";i:6212;s:5:\"title\";s:11:\"Features 12\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2018/03/features_white_7.png\";s:12:\"tmpl_created\";i:1520443684;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/features-12/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"features\";s:4:\"tags\";s:12:\"[\"features\"]\";s:10:\"menu_order\";i:134;s:16:\"popularity_index\";i:81;s:11:\"trend_index\";i:98;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:518;a:15:{s:2:\"id\";i:1903;s:5:\"title\";s:20:\"One Page &#8211; Spa\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2017/06/spa.png\";s:12:\"tmpl_created\";i:1496822325;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:102:\"https://library.elementor.com/one-page-spa/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:132:\"[\"beauty\",\"care\",\"girly\",\"hair\",\"Health\",\"hospitality\",\"massage\",\"medical\",\"parlor\",\"physiotherapy\",\"salon\",\"spa\",\"wellness\",\"yoga\"]\";s:10:\"menu_order\";i:134;s:16:\"popularity_index\";i:211;s:11:\"trend_index\";i:320;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:519;a:15:{s:2:\"id\";i:6220;s:5:\"title\";s:10:\"Features 2\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2018/03/features_white_8.png\";s:12:\"tmpl_created\";i:1520443685;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/blocks/features-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"features\";s:4:\"tags\";s:12:\"[\"features\"]\";s:10:\"menu_order\";i:135;s:16:\"popularity_index\";i:88;s:11:\"trend_index\";i:189;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:520;a:15:{s:2:\"id\";i:2123;s:5:\"title\";s:33:\"One Page &#8211; Architect Office\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2017/06/architect.png\";s:12:\"tmpl_created\";i:1499772989;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/one-page-architect-office/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:135;s:16:\"popularity_index\";i:11;s:11:\"trend_index\";i:19;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:521;a:15:{s:2:\"id\";i:5983;s:5:\"title\";s:10:\"Features 3\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2018/03/features_black_3.png\";s:12:\"tmpl_created\";i:1520443630;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/blocks/features-3/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"features\";s:4:\"tags\";s:11:\"[\"featues\"]\";s:10:\"menu_order\";i:136;s:16:\"popularity_index\";i:231;s:11:\"trend_index\";i:351;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:522;a:15:{s:2:\"id\";i:1888;s:5:\"title\";s:32:\"One Page &#8211; Creative Meetup\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2017/06/creative-meetup.png\";s:12:\"tmpl_created\";i:1496822319;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/one-page-creative-meetup/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:136;s:16:\"popularity_index\";i:315;s:11:\"trend_index\";i:771;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:523;a:15:{s:2:\"id\";i:5974;s:5:\"title\";s:10:\"Features 4\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2018/03/features_white_3.png\";s:12:\"tmpl_created\";i:1520443629;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/blocks/features-4/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"features\";s:4:\"tags\";s:12:\"[\"features\"]\";s:10:\"menu_order\";i:137;s:16:\"popularity_index\";i:69;s:11:\"trend_index\";i:181;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:524;a:15:{s:2:\"id\";i:1891;s:5:\"title\";s:35:\"One Page &#8211; Textile Convention\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2017/06/textile-meetup.png\";s:12:\"tmpl_created\";i:1496822323;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/one-page-textile-convention/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:137;s:16:\"popularity_index\";i:503;s:11:\"trend_index\";i:835;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:525;a:15:{s:2:\"id\";i:5624;s:5:\"title\";s:10:\"Features 5\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2018/03/features_black_1.png\";s:12:\"tmpl_created\";i:1520443553;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/blocks/features-5/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"features\";s:4:\"tags\";s:12:\"[\"features\"]\";s:10:\"menu_order\";i:138;s:16:\"popularity_index\";i:93;s:11:\"trend_index\";i:352;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:526;a:15:{s:2:\"id\";i:1880;s:5:\"title\";s:24:\"One Page &#8211; Wedding\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2017/06/wedding.png\";s:12:\"tmpl_created\";i:1496822317;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/one-page-wedding/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:82:\"[\"bride\",\"ceremony\",\"cute\",\"event\",\"fancy\",\"girly\",\"groom\",\"guestbook\",\"marriage\"]\";s:10:\"menu_order\";i:138;s:16:\"popularity_index\";i:535;s:11:\"trend_index\";i:576;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:527;a:15:{s:2:\"id\";i:5615;s:5:\"title\";s:10:\"Features 6\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_white_5.png\";s:12:\"tmpl_created\";i:1520443551;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/blocks/features-6/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"features\";s:4:\"tags\";s:12:\"[\"features\"]\";s:10:\"menu_order\";i:139;s:16:\"popularity_index\";i:41;s:11:\"trend_index\";i:119;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:528;a:15:{s:2:\"id\";i:1885;s:5:\"title\";s:29:\"One Page &#8211; Yacht Rental\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2017/06/yacht-home.png\";s:12:\"tmpl_created\";i:1496822321;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/one-page-yacht-rental/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:139;s:16:\"popularity_index\";i:235;s:11:\"trend_index\";i:610;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:529;a:15:{s:2:\"id\";i:5963;s:5:\"title\";s:10:\"Features 7\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2018/03/features_white_2.png\";s:12:\"tmpl_created\";i:1520443626;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/blocks/features-7/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"features\";s:4:\"tags\";s:12:\"[\"features\"]\";s:10:\"menu_order\";i:140;s:16:\"popularity_index\";i:67;s:11:\"trend_index\";i:133;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:530;a:15:{s:2:\"id\";i:2723;s:5:\"title\";s:34:\"Portfolio &#8211; Graphic Designer\";s:9:\"thumbnail\";s:91:\"https://library.elementor.com/wp-content/uploads/2017/11/Graphic-Designer-–-Portfolio.png\";s:12:\"tmpl_created\";i:1509633883;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/portfolio-graphic-designer/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:140;s:16:\"popularity_index\";i:218;s:11:\"trend_index\";i:300;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:531;a:15:{s:2:\"id\";i:6204;s:5:\"title\";s:10:\"Features 8\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2018/03/progress_black_6.png\";s:12:\"tmpl_created\";i:1520443681;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/blocks/features-8/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"features\";s:4:\"tags\";s:12:\"[\"features\"]\";s:10:\"menu_order\";i:141;s:16:\"popularity_index\";i:217;s:11:\"trend_index\";i:223;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:532;a:15:{s:2:\"id\";i:2145;s:5:\"title\";s:30:\"About &#8211; Delivery Company\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2017/07/delivery-about.png\";s:12:\"tmpl_created\";i:1499774125;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/about-delivery-company/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:10:\"[\"moving\"]\";s:10:\"menu_order\";i:141;s:16:\"popularity_index\";i:403;s:11:\"trend_index\";i:699;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:533;a:15:{s:2:\"id\";i:6196;s:5:\"title\";s:10:\"Features 9\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2018/03/features_white_6.png\";s:12:\"tmpl_created\";i:1520443680;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/blocks/features-9/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"features\";s:4:\"tags\";s:12:\"[\"features\"]\";s:10:\"menu_order\";i:142;s:16:\"popularity_index\";i:106;s:11:\"trend_index\";i:113;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:534;a:15:{s:2:\"id\";i:2155;s:5:\"title\";s:23:\"About &#8211; Cake Shop\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2017/07/cake-about.png\";s:12:\"tmpl_created\";i:1499774130;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:105:\"https://library.elementor.com/about-cake-shop/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:8:\"[\"Food\"]\";s:10:\"menu_order\";i:142;s:16:\"popularity_index\";i:471;s:11:\"trend_index\";i:461;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:535;a:15:{s:2:\"id\";i:15033;s:5:\"title\";s:28:\"Flooring Company &#8211; 404\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2020/08/404.png\";s:12:\"tmpl_created\";i:1597739459;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/blocks/flooring-company-404/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:45:\"[\"404\",\"Flooring company\",\"Flooring website\"]\";s:10:\"menu_order\";i:143;s:16:\"popularity_index\";i:655;s:11:\"trend_index\";i:671;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:536;a:15:{s:2:\"id\";i:1085;s:5:\"title\";s:21:\"About &#8211; Startup\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2017/03/Startup.png\";s:12:\"tmpl_created\";i:1488810874;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/about-startup/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:19:\"[\"About\",\"Startup\"]\";s:10:\"menu_order\";i:143;s:16:\"popularity_index\";i:8;s:11:\"trend_index\";i:36;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:537;a:15:{s:2:\"id\";i:15042;s:5:\"title\";s:32:\"Flooring Company &#8211; Archive\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2020/08/Blog.png\";s:12:\"tmpl_created\";i:1597739084;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:121:\"https://library.elementor.com/blocks/flooring-company-archive/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"archive\";s:4:\"tags\";s:39:\"[\"Flooring company\",\"Flooring website\"]\";s:10:\"menu_order\";i:144;s:16:\"popularity_index\";i:320;s:11:\"trend_index\";i:275;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:538;a:15:{s:2:\"id\";i:15017;s:5:\"title\";s:31:\"Flooring Company &#8211; Footer\";s:9:\"thumbnail\";s:67:\"https://library.elementor.com/wp-content/uploads/2020/08/Footer.png\";s:12:\"tmpl_created\";i:1597738933;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.elementor.com/blocks/flooring-company-footer/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:48:\"[\"Flooring company\",\"Flooring website\",\"footer\"]\";s:10:\"menu_order\";i:145;s:16:\"popularity_index\";i:323;s:11:\"trend_index\";i:192;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:539;a:15:{s:2:\"id\";i:101;s:5:\"title\";s:16:\"About &#8211; CV\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2016/08/0018.png\";s:12:\"tmpl_created\";i:1470829785;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:98:\"https://library.elementor.com/about-cv/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:77:\"[\"creative portfolio\",\"Personal\",\"portfolio\",\"professional\",\"resume\",\"vcard\"]\";s:10:\"menu_order\";i:145;s:16:\"popularity_index\";i:54;s:11:\"trend_index\";i:182;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:540;a:15:{s:2:\"id\";i:15007;s:5:\"title\";s:31:\"Flooring Company &#8211; Header\";s:9:\"thumbnail\";s:67:\"https://library.elementor.com/wp-content/uploads/2020/08/Header.png\";s:12:\"tmpl_created\";i:1597738896;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.elementor.com/blocks/flooring-company-header/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:48:\"[\"Flooring company\",\"Flooring website\",\"header\"]\";s:10:\"menu_order\";i:146;s:16:\"popularity_index\";i:459;s:11:\"trend_index\";i:333;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:541;a:15:{s:2:\"id\";i:15052;s:5:\"title\";s:36:\"Flooring Company &#8211; Single post\";s:9:\"thumbnail\";s:67:\"https://library.elementor.com/wp-content/uploads/2020/08/Single.png\";s:12:\"tmpl_created\";i:1597738858;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:125:\"https://library.elementor.com/blocks/flooring-company-single-post/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:39:\"[\"Flooring company\",\"Flooring website\"]\";s:10:\"menu_order\";i:147;s:16:\"popularity_index\";i:392;s:11:\"trend_index\";i:226;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:542;a:15:{s:2:\"id\";i:213;s:5:\"title\";s:26:\"About &#8211; Architecture\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2016/08/0008.png\";s:12:\"tmpl_created\";i:1470829766;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/about-architecture/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:24:\"[\"About\",\"Architecture\"]\";s:10:\"menu_order\";i:147;s:16:\"popularity_index\";i:20;s:11:\"trend_index\";i:65;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:543;a:15:{s:2:\"id\";i:2802;s:5:\"title\";s:38:\"Portfolio &#8211; Fashion Photographer\";s:9:\"thumbnail\";s:95:\"https://library.elementor.com/wp-content/uploads/2017/11/Fashion-photographer-–-Portfolio.png\";s:12:\"tmpl_created\";i:1509615440;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.elementor.com/portfolio-fashion-photographer/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:148;s:16:\"popularity_index\";i:263;s:11:\"trend_index\";i:504;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:544;a:15:{s:2:\"id\";i:7837;s:5:\"title\";s:9:\"footer 01\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/footer350.14.jpg\";s:12:\"tmpl_created\";i:1524582852;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/footer-01/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:148;s:16:\"popularity_index\";i:495;s:11:\"trend_index\";i:539;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:545;a:15:{s:2:\"id\";i:2828;s:5:\"title\";s:35:\"Landing Page &#8211; Law Convention\";s:9:\"thumbnail\";s:92:\"https://library.elementor.com/wp-content/uploads/2017/11/Law-Convention-–-Landing-Page.png\";s:12:\"tmpl_created\";i:1509631636;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/landing-page-law-convention/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:35:\"[\"Convention\",\"Landing Page\",\"Law\"]\";s:10:\"menu_order\";i:149;s:16:\"popularity_index\";i:423;s:11:\"trend_index\";i:625;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:546;a:15:{s:2:\"id\";i:7937;s:5:\"title\";s:10:\"footer 010\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/footer350.5.jpg\";s:12:\"tmpl_created\";i:1524582665;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/blocks/footer-010/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:149;s:16:\"popularity_index\";i:185;s:11:\"trend_index\";i:115;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:547;a:15:{s:2:\"id\";i:1461;s:5:\"title\";s:28:\"Landing Page &#8211; Ebook 1\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2017/05/Landing-Page-Ebook-1.png\";s:12:\"tmpl_created\";i:1494352121;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/landing-page-ebook-1/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:127:\"[\"App\",\"author\",\"book\",\"brochure\",\"download\",\"e-book\",\"ebook\",\"marketing\",\"product\",\"publisher\",\"sell online\",\"seo\",\"showcase\"]\";s:10:\"menu_order\";i:150;s:16:\"popularity_index\";i:374;s:11:\"trend_index\";i:516;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:548;a:15:{s:2:\"id\";i:7950;s:5:\"title\";s:10:\"footer 011\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/footer350.4.jpg\";s:12:\"tmpl_created\";i:1524582631;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/blocks/footer-011/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:150;s:16:\"popularity_index\";i:244;s:11:\"trend_index\";i:203;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:549;a:15:{s:2:\"id\";i:1460;s:5:\"title\";s:28:\"Landing Page &#8211; Ebook 2\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2017/05/Landing-Page-Ebook-2.png\";s:12:\"tmpl_created\";i:1494352124;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/landing-page-ebook-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:151;s:16:\"popularity_index\";i:426;s:11:\"trend_index\";i:466;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:550;a:15:{s:2:\"id\";i:7959;s:5:\"title\";s:10:\"footer 012\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/footer350.3.jpg\";s:12:\"tmpl_created\";i:1524582605;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/blocks/footer-012/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:151;s:16:\"popularity_index\";i:177;s:11:\"trend_index\";i:140;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:551;a:15:{s:2:\"id\";i:1459;s:5:\"title\";s:28:\"Landing Page &#8211; Ebook 3\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2017/05/Landing-Page-Ebook-3.png\";s:12:\"tmpl_created\";i:1494352125;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/landing-page-ebook-3/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:152;s:16:\"popularity_index\";i:254;s:11:\"trend_index\";i:422;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:552;a:15:{s:2:\"id\";i:7982;s:5:\"title\";s:10:\"footer 013\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/footer350.2.jpg\";s:12:\"tmpl_created\";i:1524582468;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/blocks/footer-013/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:152;s:16:\"popularity_index\";i:209;s:11:\"trend_index\";i:212;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:553;a:15:{s:2:\"id\";i:1052;s:5:\"title\";s:33:\"Landing Page &#8211; Mobile App 1\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2017/03/app.png\";s:12:\"tmpl_created\";i:1488810873;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:113:\"https://library.elementor.com/landing-page-mobile-app/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:153;s:16:\"popularity_index\";i:47;s:11:\"trend_index\";i:158;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:554;a:15:{s:2:\"id\";i:7997;s:5:\"title\";s:10:\"footer 014\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/footer350.1.jpg\";s:12:\"tmpl_created\";i:1524582343;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/blocks/footer-014/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:153;s:16:\"popularity_index\";i:64;s:11:\"trend_index\";i:41;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:555;a:15:{s:2:\"id\";i:1505;s:5:\"title\";s:33:\"Landing Page &#8211; Mobile App 4\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2017/05/Landing-Page-app3.png\";s:12:\"tmpl_created\";i:1494352110;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/landing-page-mobile-app-4/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:154;s:16:\"popularity_index\";i:454;s:11:\"trend_index\";i:547;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:556;a:15:{s:2:\"id\";i:9119;s:5:\"title\";s:10:\"footer 015\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2018/07/Footer_GetStarted_350.png\";s:12:\"tmpl_created\";i:1532428138;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:101:\"https://library.elementor.com/blocks/demo/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:154;s:16:\"popularity_index\";i:240;s:11:\"trend_index\";i:154;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:557;a:15:{s:2:\"id\";i:726;s:5:\"title\";s:33:\"Landing Page &#8211; Conference 1\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2017/01/convention-landing-page.jpg\";s:12:\"tmpl_created\";i:1485270062;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:113:\"https://library.elementor.com/landing-page-conference/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:155;s:16:\"popularity_index\";i:498;s:11:\"trend_index\";i:651;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:558;a:15:{s:2:\"id\";i:7852;s:5:\"title\";s:9:\"footer 02\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/footer350.13.jpg\";s:12:\"tmpl_created\";i:1524582875;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/footer-02/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:155;s:16:\"popularity_index\";i:199;s:11:\"trend_index\";i:96;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:559;a:15:{s:2:\"id\";i:1613;s:5:\"title\";s:33:\"Landing Page &#8211; Conference 2\";s:9:\"thumbnail\";s:109:\"https://library.elementor.com/wp-content/uploads/2017/05/Landing-Page-International-Womens-Day-Conference.png\";s:12:\"tmpl_created\";i:1494352129;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/landing-page-conference-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:156;s:16:\"popularity_index\";i:504;s:11:\"trend_index\";i:464;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:560;a:15:{s:2:\"id\";i:7862;s:5:\"title\";s:9:\"footer 03\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/footer350.12.jpg\";s:12:\"tmpl_created\";i:1524582903;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/footer-03/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:156;s:16:\"popularity_index\";i:137;s:11:\"trend_index\";i:91;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:561;a:15:{s:2:\"id\";i:1612;s:5:\"title\";s:33:\"Landing Page &#8211; Conference 3\";s:9:\"thumbnail\";s:89:\"https://library.elementor.com/wp-content/uploads/2017/05/Landing-Page-Tech-Conference.png\";s:12:\"tmpl_created\";i:1494352127;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/landing-page-conference-3/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:157;s:16:\"popularity_index\";i:549;s:11:\"trend_index\";i:693;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:562;a:15:{s:2:\"id\";i:7871;s:5:\"title\";s:9:\"footer 04\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/footer350.11.jpg\";s:12:\"tmpl_created\";i:1524582927;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/footer-04/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:157;s:16:\"popularity_index\";i:97;s:11:\"trend_index\";i:55;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:563;a:15:{s:2:\"id\";i:1614;s:5:\"title\";s:33:\"Landing Page &#8211; Conference 4\";s:9:\"thumbnail\";s:99:\"https://library.elementor.com/wp-content/uploads/2017/05/Landing-Page-Sustainability-Conference.png\";s:12:\"tmpl_created\";i:1494352131;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/landing-page-conference-4/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:158;s:16:\"popularity_index\";i:447;s:11:\"trend_index\";i:657;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:564;a:15:{s:2:\"id\";i:7884;s:5:\"title\";s:9:\"footer 05\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/footer350.10.jpg\";s:12:\"tmpl_created\";i:1524582944;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/footer-05/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:158;s:16:\"popularity_index\";i:92;s:11:\"trend_index\";i:109;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:565;a:15:{s:2:\"id\";i:906;s:5:\"title\";s:29:\"Landing Page &#8211;  Coacher\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2017/02/Landin-Page-Coacher.png\";s:12:\"tmpl_created\";i:1494352066;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/landing-page-coacher/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:159;s:16:\"popularity_index\";i:302;s:11:\"trend_index\";i:397;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:566;a:15:{s:2:\"id\";i:7892;s:5:\"title\";s:9:\"footer 06\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/footer350.9.jpg\";s:12:\"tmpl_created\";i:1524583015;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/footer-06/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:159;s:16:\"popularity_index\";i:132;s:11:\"trend_index\";i:146;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:567;a:15:{s:2:\"id\";i:879;s:5:\"title\";s:41:\"Landing Page &#8211; Financial Consultant\";s:9:\"thumbnail\";s:94:\"https://library.elementor.com/wp-content/uploads/2017/02/Landing-Page-Financial-consultant.png\";s:12:\"tmpl_created\";i:1494352064;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:123:\"https://library.elementor.com/landing-page-financial-consultant/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:160;s:16:\"popularity_index\";i:305;s:11:\"trend_index\";i:406;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:568;a:15:{s:2:\"id\";i:7904;s:5:\"title\";s:9:\"footer 07\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/footer350.8.jpg\";s:12:\"tmpl_created\";i:1524582814;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/footer-07/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:160;s:16:\"popularity_index\";i:203;s:11:\"trend_index\";i:186;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:569;a:15:{s:2:\"id\";i:926;s:5:\"title\";s:33:\"Landing Page &#8211; Private Chef\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2017/02/Landing-Page-Private-Chef.png\";s:12:\"tmpl_created\";i:1494352068;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/landing-page-private-chef/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:161;s:16:\"popularity_index\";i:461;s:11:\"trend_index\";i:549;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:570;a:15:{s:2:\"id\";i:7917;s:5:\"title\";s:9:\"footer 08\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/footer350.7.jpg\";s:12:\"tmpl_created\";i:1524582788;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/footer-08/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:161;s:16:\"popularity_index\";i:89;s:11:\"trend_index\";i:144;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:571;a:15:{s:2:\"id\";i:1032;s:5:\"title\";s:27:\"Landing Page &#8211; Agency\";s:9:\"thumbnail\";s:67:\"https://library.elementor.com/wp-content/uploads/2017/03/Agency.png\";s:12:\"tmpl_created\";i:1488810866;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:109:\"https://library.elementor.com/landing-page-agency/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:162;s:16:\"popularity_index\";i:462;s:11:\"trend_index\";i:715;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:572;a:15:{s:2:\"id\";i:7927;s:5:\"title\";s:9:\"footer 09\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/footer350.6.jpg\";s:12:\"tmpl_created\";i:1524582691;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/footer-09/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:162;s:16:\"popularity_index\";i:178;s:11:\"trend_index\";i:100;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:573;a:15:{s:2:\"id\";i:730;s:5:\"title\";s:24:\"Landing Page &#8211; App\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2017/01/app.-landing-page.jpg\";s:12:\"tmpl_created\";i:1485273430;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/landing-page-app/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:17:\"[\"Landing Pages\"]\";s:10:\"menu_order\";i:163;s:16:\"popularity_index\";i:386;s:11:\"trend_index\";i:614;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:574;a:15:{s:2:\"id\";i:643;s:5:\"title\";s:29:\"Landing Page &#8211; Festival\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2016/12/festival.jpg\";s:12:\"tmpl_created\";i:1481549290;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/landing-page-festival/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:164;s:16:\"popularity_index\";i:518;s:11:\"trend_index\";i:748;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:575;a:15:{s:2:\"id\";i:542;s:5:\"title\";s:28:\"Landing Page &#8211; Wedding\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2016/10/0025.png\";s:12:\"tmpl_created\";i:1477388484;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/landing-page-wedding/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:165;s:16:\"popularity_index\";i:128;s:11:\"trend_index\";i:355;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:576;a:15:{s:2:\"id\";i:1187;s:5:\"title\";s:32:\"Landing Page &#8211; Photography\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2017/03/lp1-l.png\";s:12:\"tmpl_created\";i:1490707385;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/landing-page-photography/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:166;s:16:\"popularity_index\";i:53;s:11:\"trend_index\";i:196;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:577;a:15:{s:2:\"id\";i:641;s:5:\"title\";s:28:\"Landing Page &#8211; Fashion\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2016/12/fashion-landing-page.jpg\";s:12:\"tmpl_created\";i:1481549264;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/landing-page-fashion/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:167;s:16:\"popularity_index\";i:355;s:11:\"trend_index\";i:480;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:578;a:15:{s:2:\"id\";i:189;s:5:\"title\";s:30:\"Landing Page &#8211; Tourism 1\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2016/08/0005.png\";s:12:\"tmpl_created\";i:1470820715;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/landing-page-tourism/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:168;s:16:\"popularity_index\";i:17;s:11:\"trend_index\";i:107;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:579;a:15:{s:2:\"id\";i:1547;s:5:\"title\";s:30:\"Landing Page &#8211; Tourism 2\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2017/05/Landing-Page-Truism-1.png\";s:12:\"tmpl_created\";i:1494352115;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/landing-page-tourism-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:169;s:16:\"popularity_index\";i:377;s:11:\"trend_index\";i:491;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:580;a:15:{s:2:\"id\";i:4676;s:5:\"title\";s:8:\"Footer 7\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2018/03/footer_7.png\";s:12:\"tmpl_created\";i:1522014215;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:105:\"https://library.elementor.com/blocks/footer_7/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:10:\"[\"footer\"]\";s:10:\"menu_order\";i:169;s:16:\"popularity_index\";i:237;s:11:\"trend_index\";i:346;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:581;a:15:{s:2:\"id\";i:1546;s:5:\"title\";s:30:\"Landing Page &#8211; Tourism 3\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2017/05/Landing-Page-Truism-2.png\";s:12:\"tmpl_created\";i:1494352116;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/landing-page-tourism-3/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:170;s:16:\"popularity_index\";i:550;s:11:\"trend_index\";i:690;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:582;a:15:{s:2:\"id\";i:7627;s:5:\"title\";s:8:\"Footer 8\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/footer_hero_1.png\";s:12:\"tmpl_created\";i:1521547332;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:105:\"https://library.elementor.com/blocks/footer-8/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:10:\"[\"footer\"]\";s:10:\"menu_order\";i:170;s:16:\"popularity_index\";i:100;s:11:\"trend_index\";i:83;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:583;a:15:{s:2:\"id\";i:1545;s:5:\"title\";s:30:\"Landing Page &#8211; Tourism 4\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2017/05/Landing-Page-Truism-3.png\";s:12:\"tmpl_created\";i:1494352118;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/landing-page-tourism-4/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:171;s:16:\"popularity_index\";i:425;s:11:\"trend_index\";i:404;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:584;a:15:{s:2:\"id\";i:7638;s:5:\"title\";s:8:\"Footer 9\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/footer_hero_2.png\";s:12:\"tmpl_created\";i:1521547502;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:105:\"https://library.elementor.com/blocks/footer-9/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:10:\"[\"footer\"]\";s:10:\"menu_order\";i:171;s:16:\"popularity_index\";i:124;s:11:\"trend_index\";i:147;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:585;a:15:{s:2:\"id\";i:11424;s:5:\"title\";s:3:\"GYM\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2019/08/404_Small.png\";s:12:\"tmpl_created\";i:1567393309;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:102:\"https://library.elementor.com/blocks/gym-5/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:13:\"[\"404\",\"Gym\"]\";s:10:\"menu_order\";i:172;s:16:\"popularity_index\";i:679;s:11:\"trend_index\";i:769;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:586;a:15:{s:2:\"id\";i:2714;s:5:\"title\";s:30:\"Landing Page &#8211; Tourism 5\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2017/11/Vacation-–-Landing-Page.png\";s:12:\"tmpl_created\";i:1509631782;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/landing-page-tourism-5/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:172;s:16:\"popularity_index\";i:415;s:11:\"trend_index\";i:584;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:587;a:15:{s:2:\"id\";i:195;s:5:\"title\";s:28:\"Landing Page &#8211; Product\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2016/08/0006.png\";s:12:\"tmpl_created\";i:1470820765;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/landing-page-product/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:173;s:16:\"popularity_index\";i:72;s:11:\"trend_index\";i:242;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:588;a:15:{s:2:\"id\";i:11435;s:5:\"title\";s:3:\"GYM\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2019/08/Archiv_Small.png\";s:12:\"tmpl_created\";i:1567393296;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:102:\"https://library.elementor.com/blocks/gym-4/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"archive\";s:4:\"tags\";s:7:\"[\"Gym\"]\";s:10:\"menu_order\";i:173;s:16:\"popularity_index\";i:441;s:11:\"trend_index\";i:507;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:589;a:15:{s:2:\"id\";i:197;s:5:\"title\";s:34:\"Landing Page &#8211; Real Estate 1\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2016/08/0007.png\";s:12:\"tmpl_created\";i:1470825711;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/landing-page-real-estate/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:174;s:16:\"popularity_index\";i:162;s:11:\"trend_index\";i:366;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:590;a:15:{s:2:\"id\";i:11445;s:5:\"title\";s:3:\"GYM\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2019/08/Post_Small.png\";s:12:\"tmpl_created\";i:1567393229;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:102:\"https://library.elementor.com/blocks/gym-3/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:7:\"[\"Gym\"]\";s:10:\"menu_order\";i:174;s:16:\"popularity_index\";i:452;s:11:\"trend_index\";i:479;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:591;a:15:{s:2:\"id\";i:1193;s:5:\"title\";s:34:\"Landing Page &#8211; Real Estate 2\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2017/03/lp3-l.png\";s:12:\"tmpl_created\";i:1490707422;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/landing-page-real-estate-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:175;s:16:\"popularity_index\";i:86;s:11:\"trend_index\";i:245;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:592;a:15:{s:2:\"id\";i:11453;s:5:\"title\";s:3:\"GYM\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2019/08/Footer_Small.png\";s:12:\"tmpl_created\";i:1567393224;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:102:\"https://library.elementor.com/blocks/gym-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:16:\"[\"footer\",\"Gym\"]\";s:10:\"menu_order\";i:175;s:16:\"popularity_index\";i:270;s:11:\"trend_index\";i:331;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:593;a:15:{s:2:\"id\";i:1415;s:5:\"title\";s:34:\"Landing Page &#8211; Real Estate 3\";s:9:\"thumbnail\";s:87:\"https://library.elementor.com/wp-content/uploads/2017/05/Landing-Page-Real-Estate-1.png\";s:12:\"tmpl_created\";i:1494352106;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/landing-page-real-estate-3/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:176;s:16:\"popularity_index\";i:381;s:11:\"trend_index\";i:462;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:594;a:15:{s:2:\"id\";i:11461;s:5:\"title\";s:3:\"GYM\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2020/06/Header-gym-and-fitness.png\";s:12:\"tmpl_created\";i:1567393219;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:100:\"https://library.elementor.com/blocks/gym/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:16:\"[\"Gym\",\"header\"]\";s:10:\"menu_order\";i:176;s:16:\"popularity_index\";i:201;s:11:\"trend_index\";i:135;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:595;a:15:{s:2:\"id\";i:1414;s:5:\"title\";s:34:\"Landing Page &#8211; Real Estate 4\";s:9:\"thumbnail\";s:87:\"https://library.elementor.com/wp-content/uploads/2017/05/Landing-Page-Real-Estate-2.png\";s:12:\"tmpl_created\";i:1494352107;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/landing-page-real-estate-4/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:177;s:16:\"popularity_index\";i:573;s:11:\"trend_index\";i:670;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:596;a:15:{s:2:\"id\";i:7596;s:5:\"title\";s:8:\"Header 1\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/header350.12.jpg\";s:12:\"tmpl_created\";i:1521546999;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:105:\"https://library.elementor.com/blocks/header-1/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:10:\"[\"header\"]\";s:10:\"menu_order\";i:177;s:16:\"popularity_index\";i:33;s:11:\"trend_index\";i:17;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:597;a:15:{s:2:\"id\";i:1413;s:5:\"title\";s:34:\"Landing Page &#8211; Real Estate 5\";s:9:\"thumbnail\";s:87:\"https://library.elementor.com/wp-content/uploads/2017/05/Landing-Page-Real-Estate-3.png\";s:12:\"tmpl_created\";i:1494352109;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/landing-page-real-estate-5/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:134:\"[\"Agent\",\"business\",\"clean\",\"corporate\",\"flat\",\"google maps\",\"homes\",\"listing\",\"modern\",\"real estate\",\"realestate\",\"realtor\",\"realty\"]\";s:10:\"menu_order\";i:178;s:16:\"popularity_index\";i:486;s:11:\"trend_index\";i:444;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:598;a:15:{s:2:\"id\";i:7801;s:5:\"title\";s:9:\"header 10\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/header350.9.jpg\";s:12:\"tmpl_created\";i:1524583659;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/header-10/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:178;s:16:\"popularity_index\";i:51;s:11:\"trend_index\";i:14;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:599;a:15:{s:2:\"id\";i:1573;s:5:\"title\";s:29:\"Landing Page &#8211; Coupon 1\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2017/05/Coupon-02.png\";s:12:\"tmpl_created\";i:1494352133;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/landing-page-coupon-1/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:17:\"[\"Landing Pages\"]\";s:10:\"menu_order\";i:179;s:16:\"popularity_index\";i:594;s:11:\"trend_index\";i:687;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:600;a:15:{s:2:\"id\";i:7812;s:5:\"title\";s:9:\"header 11\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/header350.10.jpg\";s:12:\"tmpl_created\";i:1524583298;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/header-11/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:179;s:16:\"popularity_index\";i:96;s:11:\"trend_index\";i:103;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:601;a:15:{s:2:\"id\";i:1572;s:5:\"title\";s:29:\"Landing Page &#8211; Coupon 2\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2017/05/Coupon-03.png\";s:12:\"tmpl_created\";i:1494352134;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/landing-page-coupon-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:17:\"[\"Landing Pages\"]\";s:10:\"menu_order\";i:180;s:16:\"popularity_index\";i:632;s:11:\"trend_index\";i:774;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:602;a:15:{s:2:\"id\";i:7825;s:5:\"title\";s:9:\"header 12\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/header350.11.jpg\";s:12:\"tmpl_created\";i:1524583273;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/header-12/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:180;s:16:\"popularity_index\";i:63;s:11:\"trend_index\";i:75;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:603;a:15:{s:2:\"id\";i:1570;s:5:\"title\";s:29:\"Landing Page &#8211; Coupon 3\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2017/05/Coupon-01.png\";s:12:\"tmpl_created\";i:1494352136;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/landing-page-coupon-3/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:181;s:16:\"popularity_index\";i:674;s:11:\"trend_index\";i:785;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:604;a:15:{s:2:\"id\";i:9127;s:5:\"title\";s:9:\"header 13\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2018/07/Header_get_started_1200V3.png\";s:12:\"tmpl_created\";i:1532428699;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/header-13/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:181;s:16:\"popularity_index\";i:61;s:11:\"trend_index\";i:58;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:605;a:15:{s:2:\"id\";i:1571;s:5:\"title\";s:29:\"Landing Page &#8211; Coupon 4\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2017/05/Coupon-04.png\";s:12:\"tmpl_created\";i:1494352138;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/landing-page-coupon-4/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:182;s:16:\"popularity_index\";i:647;s:11:\"trend_index\";i:737;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:606;a:15:{s:2:\"id\";i:7615;s:5:\"title\";s:8:\"Header 2\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/header350.1.jpg\";s:12:\"tmpl_created\";i:1521547237;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:105:\"https://library.elementor.com/blocks/header-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:10:\"[\"header\"]\";s:10:\"menu_order\";i:182;s:16:\"popularity_index\";i:30;s:11:\"trend_index\";i:33;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:607;a:15:{s:2:\"id\";i:192;s:5:\"title\";s:28:\"Landing Page &#8211; Webinar\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2016/08/0015.png\";s:12:\"tmpl_created\";i:1470820734;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/landing-page-webinar/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:17:\"[\"Landing Pages\"]\";s:10:\"menu_order\";i:183;s:16:\"popularity_index\";i:141;s:11:\"trend_index\";i:388;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:608;a:15:{s:2:\"id\";i:7713;s:5:\"title\";s:8:\"header 3\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/header350.2.jpg\";s:12:\"tmpl_created\";i:1524584780;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:105:\"https://library.elementor.com/blocks/header-3/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:183;s:16:\"popularity_index\";i:43;s:11:\"trend_index\";i:28;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:609;a:15:{s:2:\"id\";i:2141;s:5:\"title\";s:32:\"Contact &#8211; Delivery Company\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2017/07/delivery-contact.png\";s:12:\"tmpl_created\";i:1499774122;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/contact-delivery-company/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:184;s:16:\"popularity_index\";i:363;s:11:\"trend_index\";i:678;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:610;a:15:{s:2:\"id\";i:7724;s:5:\"title\";s:8:\"header 4\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/header350.3.jpg\";s:12:\"tmpl_created\";i:1524583367;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:105:\"https://library.elementor.com/blocks/header-4/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:184;s:16:\"popularity_index\";i:24;s:11:\"trend_index\";i:13;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:611;a:15:{s:2:\"id\";i:137;s:5:\"title\";s:22:\"Contact &#8211; Modern\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2016/08/0013.png\";s:12:\"tmpl_created\";i:1470829828;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:104:\"https://library.elementor.com/contact-modern/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:185;s:16:\"popularity_index\";i:55;s:11:\"trend_index\";i:210;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:612;a:15:{s:2:\"id\";i:7734;s:5:\"title\";s:8:\"header 5\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/header350.4.jpg\";s:12:\"tmpl_created\";i:1524583436;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:105:\"https://library.elementor.com/blocks/header-5/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:185;s:16:\"popularity_index\";i:36;s:11:\"trend_index\";i:18;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:613;a:15:{s:2:\"id\";i:256;s:5:\"title\";s:26:\"Contact &#8211; Restaurant\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2016/08/0011.png\";s:12:\"tmpl_created\";i:1470829796;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/contact-restaurant/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:186;s:16:\"popularity_index\";i:154;s:11:\"trend_index\";i:370;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:614;a:15:{s:2:\"id\";i:7744;s:5:\"title\";s:8:\"Header 6\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/header350.5.jpg\";s:12:\"tmpl_created\";i:1524584784;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:105:\"https://library.elementor.com/blocks/header-6/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:186;s:16:\"popularity_index\";i:65;s:11:\"trend_index\";i:94;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:615;a:15:{s:2:\"id\";i:2150;s:5:\"title\";s:25:\"Contact &#8211; Cake Shop\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2017/07/cake-contact.png\";s:12:\"tmpl_created\";i:1499774127;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/contact-cake-shop/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:187;s:16:\"popularity_index\";i:85;s:11:\"trend_index\";i:247;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:616;a:15:{s:2:\"id\";i:7754;s:5:\"title\";s:8:\"header 7\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/header350.6.jpg\";s:12:\"tmpl_created\";i:1524583712;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:105:\"https://library.elementor.com/blocks/header-7/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:187;s:16:\"popularity_index\";i:111;s:11:\"trend_index\";i:143;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:617;a:15:{s:2:\"id\";i:223;s:5:\"title\";s:21:\"Contact &#8211; Hotel\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2016/08/0002.png\";s:12:\"tmpl_created\";i:1470820471;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/contact-hotel/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:188;s:16:\"popularity_index\";i:157;s:11:\"trend_index\";i:354;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:618;a:15:{s:2:\"id\";i:7771;s:5:\"title\";s:8:\"header 8\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/header350.7.jpg\";s:12:\"tmpl_created\";i:1524583540;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:105:\"https://library.elementor.com/blocks/header-8/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:188;s:16:\"popularity_index\";i:91;s:11:\"trend_index\";i:60;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:619;a:15:{s:2:\"id\";i:7787;s:5:\"title\";s:8:\"header 9\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/header350.8.jpg\";s:12:\"tmpl_created\";i:1524583598;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:105:\"https://library.elementor.com/blocks/header-9/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:189;s:16:\"popularity_index\";i:102;s:11:\"trend_index\";i:78;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:620;a:15:{s:2:\"id\";i:184;s:5:\"title\";s:23:\"Services &#8211; Moving\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2016/08/0017.png\";s:12:\"tmpl_created\";i:1470829889;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:105:\"https://library.elementor.com/services-moving/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:190;s:16:\"popularity_index\";i:26;s:11:\"trend_index\";i:89;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:621;a:15:{s:2:\"id\";i:6266;s:5:\"title\";s:6:\"Hero 1\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/heroo_black_4.png\";s:12:\"tmpl_created\";i:1520443695;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/blocks/hero-1/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"hero\";s:4:\"tags\";s:8:\"[\"hero\"]\";s:10:\"menu_order\";i:190;s:16:\"popularity_index\";i:52;s:11:\"trend_index\";i:35;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:622;a:15:{s:2:\"id\";i:5783;s:5:\"title\";s:7:\"Hero 10\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2018/03/header_2.png\";s:12:\"tmpl_created\";i:1520443586;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:104:\"https://library.elementor.com/blocks/hero-10/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"hero\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:191;s:16:\"popularity_index\";i:365;s:11:\"trend_index\";i:567;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:623;a:15:{s:2:\"id\";i:625;s:5:\"title\";s:31:\"Services &#8211; Cake Shop Menu\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2016/12/cake-shop-menu.jpg\";s:12:\"tmpl_created\";i:1481549196;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:113:\"https://library.elementor.com/services-cake-shop-menu/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:191;s:16:\"popularity_index\";i:642;s:11:\"trend_index\";i:733;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:624;a:15:{s:2:\"id\";i:5773;s:5:\"title\";s:7:\"Hero 11\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2018/03/header_1.png\";s:12:\"tmpl_created\";i:1520443584;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:104:\"https://library.elementor.com/blocks/hero-11/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"hero\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:192;s:16:\"popularity_index\";i:39;s:11:\"trend_index\";i:179;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:625;a:15:{s:2:\"id\";i:187;s:5:\"title\";s:20:\"Services &#8211; Fun\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2016/08/0001.png\";s:12:\"tmpl_created\";i:1470829892;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:102:\"https://library.elementor.com/services-fun/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:192;s:16:\"popularity_index\";i:109;s:11:\"trend_index\";i:338;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:626;a:15:{s:2:\"id\";i:238;s:5:\"title\";s:27:\"Services &#8211; Consulting\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2016/08/0014.png\";s:12:\"tmpl_created\";i:1470829865;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:109:\"https://library.elementor.com/services-consulting/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:193;s:16:\"popularity_index\";i:25;s:11:\"trend_index\";i:51;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:627;a:15:{s:2:\"id\";i:5238;s:5:\"title\";s:7:\"Hero 12\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/form_white_4.png\";s:12:\"tmpl_created\";i:1520443468;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:104:\"https://library.elementor.com/blocks/hero-12/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"hero\";s:4:\"tags\";s:8:\"[\"hero\"]\";s:10:\"menu_order\";i:193;s:16:\"popularity_index\";i:611;s:11:\"trend_index\";i:555;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:628;a:15:{s:2:\"id\";i:647;s:5:\"title\";s:33:\"Services &#8211; Coffee Shop Menu\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2016/12/restaurant-menu.jpg\";s:12:\"tmpl_created\";i:1481549320;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/services-coffee-shop-menu/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:194;s:16:\"popularity_index\";i:517;s:11:\"trend_index\";i:529;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:629;a:15:{s:2:\"id\";i:6274;s:5:\"title\";s:6:\"Hero 2\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/heroo_black_5.png\";s:12:\"tmpl_created\";i:1520443698;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/blocks/hero-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"hero\";s:4:\"tags\";s:8:\"[\"hero\"]\";s:10:\"menu_order\";i:194;s:16:\"popularity_index\";i:87;s:11:\"trend_index\";i:88;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:630;a:15:{s:2:\"id\";i:6239;s:5:\"title\";s:6:\"Hero 3\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/heroo_black_1.png\";s:12:\"tmpl_created\";i:1520443689;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/blocks/hero-3/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"hero\";s:4:\"tags\";s:8:\"[\"hero\"]\";s:10:\"menu_order\";i:195;s:16:\"popularity_index\";i:23;s:11:\"trend_index\";i:34;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:631;a:15:{s:2:\"id\";i:2138;s:5:\"title\";s:33:\"Services &#8211; Delivery Company\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2017/07/delivery-services.png\";s:12:\"tmpl_created\";i:1499774119;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/services-delivery-company/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:195;s:16:\"popularity_index\";i:456;s:11:\"trend_index\";i:545;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:632;a:15:{s:2:\"id\";i:823;s:5:\"title\";s:19:\"Pricing &#8211; App\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2017/01/pricing-app.jpg\";s:12:\"tmpl_created\";i:1485272966;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/pricing-app-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:196;s:16:\"popularity_index\";i:384;s:11:\"trend_index\";i:416;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:633;a:15:{s:2:\"id\";i:6258;s:5:\"title\";s:6:\"Hero 4\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/heroo_black_3.png\";s:12:\"tmpl_created\";i:1520443693;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/blocks/hero-4/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"hero\";s:4:\"tags\";s:8:\"[\"hero\"]\";s:10:\"menu_order\";i:196;s:16:\"popularity_index\";i:479;s:11:\"trend_index\";i:470;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:634;a:15:{s:2:\"id\";i:824;s:5:\"title\";s:24:\"Pricing &#8211; Software\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2017/01/pricing-software.png\";s:12:\"tmpl_created\";i:1485272900;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/pricing-software-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:197;s:16:\"popularity_index\";i:409;s:11:\"trend_index\";i:534;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:635;a:15:{s:2:\"id\";i:6249;s:5:\"title\";s:6:\"Hero 5\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/heroo_black_2.png\";s:12:\"tmpl_created\";i:1520443691;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/blocks/hero-5/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"hero\";s:4:\"tags\";s:8:\"[\"hero\"]\";s:10:\"menu_order\";i:197;s:16:\"popularity_index\";i:56;s:11:\"trend_index\";i:85;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:636;a:15:{s:2:\"id\";i:825;s:5:\"title\";s:24:\"Product &#8211; Speakers\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2017/01/product-page.jpg\";s:12:\"tmpl_created\";i:1485272513;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/product-speakers/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:198;s:16:\"popularity_index\";i:439;s:11:\"trend_index\";i:418;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:637;a:15:{s:2:\"id\";i:6230;s:5:\"title\";s:6:\"Hero 6\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/heroo_white_1.png\";s:12:\"tmpl_created\";i:1520443687;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/blocks/hero-6/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"hero\";s:4:\"tags\";s:8:\"[\"hero\"]\";s:10:\"menu_order\";i:198;s:16:\"popularity_index\";i:406;s:11:\"trend_index\";i:542;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:638;a:15:{s:2:\"id\";i:5801;s:5:\"title\";s:6:\"Hero 7\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2018/03/header_4.png\";s:12:\"tmpl_created\";i:1520443589;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/blocks/hero-7/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"hero\";s:4:\"tags\";s:8:\"[\"hero\"]\";s:10:\"menu_order\";i:199;s:16:\"popularity_index\";i:15;s:11:\"trend_index\";i:37;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:639;a:15:{s:2:\"id\";i:245;s:5:\"title\";s:21:\"Product &#8211; Clean\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2016/08/0020.png\";s:12:\"tmpl_created\";i:1470829876;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/product-clean/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:48:\"[\"Fast\",\"minimal\",\"minimalistic\",\"seo\",\"simple\"]\";s:10:\"menu_order\";i:199;s:16:\"popularity_index\";i:107;s:11:\"trend_index\";i:276;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:640;a:15:{s:2:\"id\";i:5811;s:5:\"title\";s:6:\"Hero 8\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2018/03/header_5.png\";s:12:\"tmpl_created\";i:1520443591;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/blocks/hero-8/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"hero\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:200;s:16:\"popularity_index\";i:105;s:11:\"trend_index\";i:86;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:641;a:15:{s:2:\"id\";i:1075;s:5:\"title\";s:19:\"Shop &#8211; Sweets\";s:9:\"thumbnail\";s:67:\"https://library.elementor.com/wp-content/uploads/2017/03/Sweets.png\";s:12:\"tmpl_created\";i:1488810871;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:101:\"https://library.elementor.com/shop-sweets/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:154:\"[\"bakery\",\"beverage\",\"business\",\"cafe\",\"candy bar\",\"catering\",\"delivery service\",\"Food\",\"online shop\",\"pastry\",\"Restaurant\",\"store\",\"sweet shop\",\"sweets\"]\";s:10:\"menu_order\";i:200;s:16:\"popularity_index\";i:68;s:11:\"trend_index\";i:174;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:642;a:15:{s:2:\"id\";i:5792;s:5:\"title\";s:6:\"Hero 9\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2018/03/header_3.png\";s:12:\"tmpl_created\";i:1520443588;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/blocks/hero-9/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"hero\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:201;s:16:\"popularity_index\";i:225;s:11:\"trend_index\";i:244;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:643;a:15:{s:2:\"id\";i:1051;s:5:\"title\";s:24:\"Blog Post &#8211; Launch\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2017/03/post-cloud.png\";s:12:\"tmpl_created\";i:1488810869;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blog-post-launch/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:210:\"[\"Agency\",\"bootstrap\",\"business\",\"corporate\",\"Landing Page\",\"launch\",\"marketing campaign\",\"marketing landing page\",\"marketing template landing page\",\"product launch\",\"software\",\"Startup\",\"startup landing page\"]\";s:10:\"menu_order\";i:201;s:16:\"popularity_index\";i:16;s:11:\"trend_index\";i:27;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:644;a:15:{s:2:\"id\";i:1245;s:5:\"title\";s:13:\"Coming Soon 1\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2017/03/Coming-Soon-1.png\";s:12:\"tmpl_created\";i:1491207184;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/coming-soon-1/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:202;s:16:\"popularity_index\";i:257;s:11:\"trend_index\";i:252;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:645;a:15:{s:2:\"id\";i:13251;s:5:\"title\";s:27:\"Interior Design &#8211; 404\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2020/04/404.png\";s:12:\"tmpl_created\";i:1586148737;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/blocks/interior-design-404/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:30:\"[\"business\",\"interior design\"]\";s:10:\"menu_order\";i:202;s:16:\"popularity_index\";i:730;s:11:\"trend_index\";i:795;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:646;a:15:{s:2:\"id\";i:1247;s:5:\"title\";s:13:\"Coming Soon 2\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2017/03/Coming-Soon-2.png\";s:12:\"tmpl_created\";i:1491207138;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/coming-soon-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:203;s:16:\"popularity_index\";i:35;s:11:\"trend_index\";i:48;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:647;a:15:{s:2:\"id\";i:13244;s:5:\"title\";s:30:\"Interior Design &#8211; Footer\";s:9:\"thumbnail\";s:67:\"https://library.elementor.com/wp-content/uploads/2020/04/Footer.png\";s:12:\"tmpl_created\";i:1586148742;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/blocks/interior-design-footer/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:39:\"[\"business\",\"footer\",\"interior design\"]\";s:10:\"menu_order\";i:203;s:16:\"popularity_index\";i:322;s:11:\"trend_index\";i:178;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:648;a:15:{s:2:\"id\";i:1248;s:5:\"title\";s:13:\"Coming Soon 3\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2017/03/Coming-Soon-3.png\";s:12:\"tmpl_created\";i:1491207050;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/coming-soon-3/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:204;s:16:\"popularity_index\";i:427;s:11:\"trend_index\";i:601;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:649;a:15:{s:2:\"id\";i:13236;s:5:\"title\";s:30:\"Interior Design &#8211; Header\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2020/06/Header-interior-design.png\";s:12:\"tmpl_created\";i:1586148746;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/blocks/interior-design-header/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:39:\"[\"business\",\"header\",\"interior design\"]\";s:10:\"menu_order\";i:204;s:16:\"popularity_index\";i:146;s:11:\"trend_index\";i:64;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:650;a:15:{s:2:\"id\";i:1249;s:5:\"title\";s:13:\"Coming Soon 4\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2017/03/Coming-Soon-4.png\";s:12:\"tmpl_created\";i:1491207380;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/coming-soon-4/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:205;s:16:\"popularity_index\";i:469;s:11:\"trend_index\";i:638;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:651;a:15:{s:2:\"id\";i:13259;s:5:\"title\";s:36:\"Interior Design &#8211; News Archive\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2020/04/Archiv-Blog.png\";s:12:\"tmpl_created\";i:1586148733;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:125:\"https://library.elementor.com/blocks/interior-design-news-archive/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"archive\";s:4:\"tags\";s:30:\"[\"business\",\"interior design\"]\";s:10:\"menu_order\";i:205;s:16:\"popularity_index\";i:436;s:11:\"trend_index\";i:132;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:652;a:15:{s:2:\"id\";i:1250;s:5:\"title\";s:13:\"Coming Soon 5\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2017/03/Coming-Soon-5.png\";s:12:\"tmpl_created\";i:1491207450;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/coming-soon-5/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:206;s:16:\"popularity_index\";i:82;s:11:\"trend_index\";i:104;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:653;a:15:{s:2:\"id\";i:13267;s:5:\"title\";s:35:\"Interior Design &#8211; Single News\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2020/04/Post.png\";s:12:\"tmpl_created\";i:1586148728;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:124:\"https://library.elementor.com/blocks/interior-design-single-news/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:30:\"[\"business\",\"interior design\"]\";s:10:\"menu_order\";i:206;s:16:\"popularity_index\";i:402;s:11:\"trend_index\";i:108;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:654;a:15:{s:2:\"id\";i:1260;s:5:\"title\";s:18:\"Maintenance Mode 1\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2017/03/Coming-Soon-6.png\";s:12:\"tmpl_created\";i:1491207507;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/maintenance-mode-1/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:20:\"[\"Maintenance mode\"]\";s:10:\"menu_order\";i:207;s:16:\"popularity_index\";i:506;s:11:\"trend_index\";i:623;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:655;a:15:{s:2:\"id\";i:13274;s:5:\"title\";s:38:\"Interior Design &#8211; Single Project\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2020/04/Single-Project-.png\";s:12:\"tmpl_created\";i:1586148723;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:127:\"https://library.elementor.com/blocks/interior-design-single-project/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:30:\"[\"business\",\"interior design\"]\";s:10:\"menu_order\";i:207;s:16:\"popularity_index\";i:601;s:11:\"trend_index\";i:324;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:656;a:15:{s:2:\"id\";i:1261;s:5:\"title\";s:18:\"Maintenance Mode 2\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2017/04/Coming-Soon-7.png\";s:12:\"tmpl_created\";i:1491207584;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/maintenance-mode-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:20:\"[\"Maintenance mode\"]\";s:10:\"menu_order\";i:208;s:16:\"popularity_index\";i:98;s:11:\"trend_index\";i:164;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:657;a:15:{s:2:\"id\";i:14058;s:5:\"title\";s:36:\"Japanese restaurant &#8211; 404 page\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2020/06/404-Page.jpg\";s:12:\"tmpl_created\";i:1592290211;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:125:\"https://library.elementor.com/blocks/japanese-restaurant-404-page/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:38:\"[\"404\",\"Food\",\"Japanese\",\"Restaurant\"]\";s:10:\"menu_order\";i:208;s:16:\"popularity_index\";i:724;s:11:\"trend_index\";i:647;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:658;a:15:{s:2:\"id\";i:1272;s:5:\"title\";s:13:\"Coming Soon 8\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2017/03/Coming-Soon-8.png\";s:12:\"tmpl_created\";i:1491207674;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/coming-soon-8/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:209;s:16:\"popularity_index\";i:296;s:11:\"trend_index\";i:317;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:659;a:15:{s:2:\"id\";i:14050;s:5:\"title\";s:34:\"Japanese restaurant &#8211; Footer\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2020/06/Footer-Small.jpg\";s:12:\"tmpl_created\";i:1592290247;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:123:\"https://library.elementor.com/blocks/japanese-restaurant-footer/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:41:\"[\"Food\",\"footer\",\"Japanese\",\"Restaurant\"]\";s:10:\"menu_order\";i:209;s:16:\"popularity_index\";i:317;s:11:\"trend_index\";i:238;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:660;a:15:{s:2:\"id\";i:1279;s:5:\"title\";s:13:\"Coming Soon 9\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2017/03/Coming-Soon-9.png\";s:12:\"tmpl_created\";i:1491207756;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/coming-soon-9/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:210;s:16:\"popularity_index\";i:160;s:11:\"trend_index\";i:403;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:661;a:15:{s:2:\"id\";i:14042;s:5:\"title\";s:34:\"Japanese restaurant &#8211; Header\";s:9:\"thumbnail\";s:87:\"https://library.elementor.com/wp-content/uploads/2020/06/japanese-restaurant-header.jpg\";s:12:\"tmpl_created\";i:1592290277;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:123:\"https://library.elementor.com/blocks/japanese-restaurant-header/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:41:\"[\"Food\",\"header\",\"Japanese\",\"Restaurant\"]\";s:10:\"menu_order\";i:210;s:16:\"popularity_index\";i:411;s:11:\"trend_index\";i:274;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:662;a:15:{s:2:\"id\";i:1745;s:5:\"title\";s:14:\"Coming Soon 10\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2017/05/login-002.png\";s:12:\"tmpl_created\";i:1494849745;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:104:\"https://library.elementor.com/coming-soon-10/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:211;s:16:\"popularity_index\";i:292;s:11:\"trend_index\";i:371;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:663;a:15:{s:2:\"id\";i:12164;s:5:\"title\";s:20:\"Law Firm &#8211; 404\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2019/11/404.png\";s:12:\"tmpl_created\";i:1572846979;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:109:\"https://library.elementor.com/blocks/law-firm-404/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:24:\"[\"404\",\"Law\",\"Law Firm\"]\";s:10:\"menu_order\";i:211;s:16:\"popularity_index\";i:704;s:11:\"trend_index\";i:716;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:664;a:15:{s:2:\"id\";i:1742;s:5:\"title\";s:12:\"Login Page 1\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2017/05/login-003.png\";s:12:\"tmpl_created\";i:1494849744;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:100:\"https://library.elementor.com/login-page/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:212;s:16:\"popularity_index\";i:470;s:11:\"trend_index\";i:616;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:665;a:15:{s:2:\"id\";i:12170;s:5:\"title\";s:23:\"Law Firm &#8211; Archiv\";s:9:\"thumbnail\";s:67:\"https://library.elementor.com/wp-content/uploads/2019/11/archiv.png\";s:12:\"tmpl_created\";i:1572846967;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/blocks/law-firm-archiv/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"archive\";s:4:\"tags\";s:18:\"[\"Law\",\"Law Firm\"]\";s:10:\"menu_order\";i:212;s:16:\"popularity_index\";i:431;s:11:\"trend_index\";i:294;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:666;a:15:{s:2:\"id\";i:1748;s:5:\"title\";s:12:\"Login Page 2\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2017/05/login-001.png\";s:12:\"tmpl_created\";i:1494849742;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:102:\"https://library.elementor.com/login-page-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:213;s:16:\"popularity_index\";i:313;s:11:\"trend_index\";i:306;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:667;a:15:{s:2:\"id\";i:12179;s:5:\"title\";s:23:\"Law Firm &#8211; Footer\";s:9:\"thumbnail\";s:67:\"https://library.elementor.com/wp-content/uploads/2019/11/footer.png\";s:12:\"tmpl_created\";i:1572846958;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/blocks/law-firm-footer/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:27:\"[\"footer\",\"Law\",\"Law Firm\"]\";s:10:\"menu_order\";i:213;s:16:\"popularity_index\";i:388;s:11:\"trend_index\";i:240;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:668;a:15:{s:2:\"id\";i:3963;s:5:\"title\";s:32:\"Restaurant Site &#8211; Homepage\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/01/R.HomepageThumb.png\";s:12:\"tmpl_created\";i:1516284821;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/restaurant-site-homepage/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:109:\"[\"bar\",\"cafe\",\"cooking\",\"drink\",\"events\",\"fast food\",\"Food\",\"menu\",\"modern\",\"reservation\",\"Shop\",\"snack bar\"]\";s:10:\"menu_order\";i:214;s:16:\"popularity_index\";i:238;s:11:\"trend_index\";i:61;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:669;a:15:{s:2:\"id\";i:12194;s:5:\"title\";s:23:\"Law Firm &#8211; Header\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2020/06/Header-law-firm.png\";s:12:\"tmpl_created\";i:1572846935;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/blocks/law-firm-header/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:27:\"[\"header\",\"Law\",\"Law Firm\"]\";s:10:\"menu_order\";i:214;s:16:\"popularity_index\";i:80;s:11:\"trend_index\";i:39;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:670;a:15:{s:2:\"id\";i:12203;s:5:\"title\";s:30:\"Law Firm &#8211; Search Archiv\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2019/11/search_result.png\";s:12:\"tmpl_created\";i:1572846925;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/blocks/law-firm-search-archiv/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"archive\";s:4:\"tags\";s:18:\"[\"Law\",\"Law Firm\"]\";s:10:\"menu_order\";i:215;s:16:\"popularity_index\";i:493;s:11:\"trend_index\";i:433;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:671;a:15:{s:2:\"id\";i:3969;s:5:\"title\";s:28:\"Restaurant Site &#8211; Menu\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/01/R.MenuThumb.png\";s:12:\"tmpl_created\";i:1516284829;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/restaurant-site-menu/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:109:\"[\"bar\",\"cafe\",\"cooking\",\"drink\",\"events\",\"fast food\",\"Food\",\"menu\",\"modern\",\"reservation\",\"Shop\",\"snack bar\"]\";s:10:\"menu_order\";i:215;s:16:\"popularity_index\";i:440;s:11:\"trend_index\";i:543;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:672;a:15:{s:2:\"id\";i:12212;s:5:\"title\";s:28:\"Law Firm &#8211; Single Post\";s:9:\"thumbnail\";s:67:\"https://library.elementor.com/wp-content/uploads/2019/11/single.png\";s:12:\"tmpl_created\";i:1572846914;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/blocks/law-firm-single-post/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:18:\"[\"Law\",\"Law Firm\"]\";s:10:\"menu_order\";i:216;s:16:\"popularity_index\";i:326;s:11:\"trend_index\";i:214;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:673;a:15:{s:2:\"id\";i:3966;s:5:\"title\";s:29:\"Restaurant Site &#8211; About\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2018/01/R.AboutThumb.png.png\";s:12:\"tmpl_created\";i:1516284839;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/restaurant-site-about/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:109:\"[\"bar\",\"cafe\",\"cooking\",\"drink\",\"events\",\"fast food\",\"Food\",\"menu\",\"modern\",\"reservation\",\"Shop\",\"snack bar\"]\";s:10:\"menu_order\";i:216;s:16:\"popularity_index\";i:275;s:11:\"trend_index\";i:528;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:674;a:15:{s:2:\"id\";i:3972;s:5:\"title\";s:31:\"Restaurant Site &#8211; Contact\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2018/01/R.ContactThumb.png\";s:12:\"tmpl_created\";i:1516284847;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:113:\"https://library.elementor.com/restaurant-site-contact/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:109:\"[\"bar\",\"cafe\",\"cooking\",\"drink\",\"events\",\"fast food\",\"Food\",\"menu\",\"modern\",\"reservation\",\"Shop\",\"snack bar\"]\";s:10:\"menu_order\";i:217;s:16:\"popularity_index\";i:405;s:11:\"trend_index\";i:588;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:675;a:15:{s:2:\"id\";i:14772;s:5:\"title\";s:35:\"Luxury Real Estate &#8211; 404 page\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2020/07/404.png\";s:12:\"tmpl_created\";i:1595315728;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:124:\"https://library.elementor.com/blocks/luxury-real-estate-404-page/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:34:\"[\"404\",\"Real estate\",\"Realestate\"]\";s:10:\"menu_order\";i:217;s:16:\"popularity_index\";i:759;s:11:\"trend_index\";i:720;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:676;a:15:{s:2:\"id\";i:2080;s:5:\"title\";s:27:\"Ski Resort &#8211; Homepage\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2017/10/Ski-Resort-Home-Page.png\";s:12:\"tmpl_created\";i:1508161124;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:109:\"https://library.elementor.com/ski-resort-homepage/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:218;s:16:\"popularity_index\";i:358;s:11:\"trend_index\";i:612;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:677;a:15:{s:2:\"id\";i:14779;s:5:\"title\";s:33:\"Luxury Real Estate &#8211; Footer\";s:9:\"thumbnail\";s:67:\"https://library.elementor.com/wp-content/uploads/2020/07/Footer.png\";s:12:\"tmpl_created\";i:1595315743;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/blocks/luxury-real-estate-footer/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:37:\"[\"footer\",\"real estate\",\"realestate\"]\";s:10:\"menu_order\";i:218;s:16:\"popularity_index\";i:536;s:11:\"trend_index\";i:505;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:678;a:15:{s:2:\"id\";i:14790;s:5:\"title\";s:33:\"Luxury Real Estate &#8211; Header\";s:9:\"thumbnail\";s:67:\"https://library.elementor.com/wp-content/uploads/2020/07/Header.png\";s:12:\"tmpl_created\";i:1595315760;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/blocks/luxury-real-estate-header/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:37:\"[\"header\",\"real estate\",\"realestate\"]\";s:10:\"menu_order\";i:219;s:16:\"popularity_index\";i:101;s:11:\"trend_index\";i:157;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:679;a:15:{s:2:\"id\";i:2088;s:5:\"title\";s:24:\"Ski Resort &#8211; About\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2017/10/Ski-Resort-About.png\";s:12:\"tmpl_created\";i:1508161129;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/ski-resort-about/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:219;s:16:\"popularity_index\";i:487;s:11:\"trend_index\";i:683;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:680;a:15:{s:2:\"id\";i:14809;s:5:\"title\";s:45:\"Luxury Real Estate &#8211; Properties Archive\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2020/07/Properties.png\";s:12:\"tmpl_created\";i:1595315826;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/blocks/luxury-real-estate-properties-archive/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"archive\";s:4:\"tags\";s:28:\"[\"real estate\",\"realestate\"]\";s:10:\"menu_order\";i:220;s:16:\"popularity_index\";i:414;s:11:\"trend_index\";i:420;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:681;a:15:{s:2:\"id\";i:2085;s:5:\"title\";s:27:\"Ski Resort &#8211; Services\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2017/10/Ski-Resort-Services.png\";s:12:\"tmpl_created\";i:1508161134;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:109:\"https://library.elementor.com/ski-resort-services/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:220;s:16:\"popularity_index\";i:620;s:11:\"trend_index\";i:0;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:682;a:15:{s:2:\"id\";i:14816;s:5:\"title\";s:47:\"Luxury Real Estate &#8211; Property single post\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2020/07/Single-Property-.png\";s:12:\"tmpl_created\";i:1595315847;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:136:\"https://library.elementor.com/blocks/luxury-real-estate-property-single-post/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:28:\"[\"real estate\",\"realestate\"]\";s:10:\"menu_order\";i:221;s:16:\"popularity_index\";i:541;s:11:\"trend_index\";i:665;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:683;a:15:{s:2:\"id\";i:2462;s:5:\"title\";s:23:\"Architect &#8211; About\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2017/10/architect-–-about.png\";s:12:\"tmpl_created\";i:1508243317;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:105:\"https://library.elementor.com/architect-about/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:221;s:16:\"popularity_index\";i:364;s:11:\"trend_index\";i:383;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:684;a:15:{s:2:\"id\";i:14799;s:5:\"title\";s:38:\"Luxury Real Estate &#8211; single post\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2020/07/Post.png\";s:12:\"tmpl_created\";i:1595315792;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:127:\"https://library.elementor.com/blocks/luxury-real-estate-single-post/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:28:\"[\"real estate\",\"realestate\"]\";s:10:\"menu_order\";i:222;s:16:\"popularity_index\";i:369;s:11:\"trend_index\";i:441;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:685;a:15:{s:2:\"id\";i:2362;s:5:\"title\";s:26:\"Architect &#8211; Projects\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2017/10/Architect-Projects.png\";s:12:\"tmpl_created\";i:1508243335;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/architect-projects/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:222;s:16:\"popularity_index\";i:460;s:11:\"trend_index\";i:443;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:686;a:15:{s:2:\"id\";i:614;s:5:\"title\";s:25:\"Architect &#8211; Contact\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2016/12/architect-contact.jpg\";s:12:\"tmpl_created\";i:1481549169;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/architect-contact/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:223;s:16:\"popularity_index\";i:335;s:11:\"trend_index\";i:446;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:687;a:15:{s:2:\"id\";i:12635;s:5:\"title\";s:20:\"Magazine &#8211; 404\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2020/01/404_s.png\";s:12:\"tmpl_created\";i:1579060746;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:109:\"https://library.elementor.com/blocks/magazine-404/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:25:\"[\"404\",\"Blog\",\"Magazine\"]\";s:10:\"menu_order\";i:223;s:16:\"popularity_index\";i:645;s:11:\"trend_index\";i:734;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:688;a:15:{s:2:\"id\";i:2126;s:5:\"title\";s:37:\"Construction Company &#8211; Homepage\";s:9:\"thumbnail\";s:91:\"https://library.elementor.com/wp-content/uploads/2017/10/Construction-Company-Home-Page.png\";s:12:\"tmpl_created\";i:1508325849;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/construction-company-homepage/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:224;s:16:\"popularity_index\";i:271;s:11:\"trend_index\";i:311;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:689;a:15:{s:2:\"id\";i:12643;s:5:\"title\";s:24:\"Magazine &#8211; Archiv1\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2020/01/Archiv1_s.png\";s:12:\"tmpl_created\";i:1579060737;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:113:\"https://library.elementor.com/blocks/magazine-archiv1/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"archive\";s:4:\"tags\";s:19:\"[\"Blog\",\"Magazine\"]\";s:10:\"menu_order\";i:224;s:16:\"popularity_index\";i:346;s:11:\"trend_index\";i:272;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:690;a:15:{s:2:\"id\";i:2129;s:5:\"title\";s:34:\"Construction Company &#8211; About\";s:9:\"thumbnail\";s:87:\"https://library.elementor.com/wp-content/uploads/2017/10/Construction-Company-About.png\";s:12:\"tmpl_created\";i:1508325881;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/construction-company-about/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:225;s:16:\"popularity_index\";i:321;s:11:\"trend_index\";i:448;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:691;a:15:{s:2:\"id\";i:12669;s:5:\"title\";s:23:\"Magazine &#8211; Footer\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2020/01/Footer_s.png\";s:12:\"tmpl_created\";i:1579060715;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/blocks/magazine-footer/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:28:\"[\"Blog\",\"footer\",\"Magazine\"]\";s:10:\"menu_order\";i:225;s:16:\"popularity_index\";i:442;s:11:\"trend_index\";i:349;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:692;a:15:{s:2:\"id\";i:2135;s:5:\"title\";s:36:\"Construction Company &#8211; Contact\";s:9:\"thumbnail\";s:89:\"https://library.elementor.com/wp-content/uploads/2017/10/Construction-Company-Contact.png\";s:12:\"tmpl_created\";i:1508325922;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/construction-company-contact/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:226;s:16:\"popularity_index\";i:370;s:11:\"trend_index\";i:473;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:693;a:15:{s:2:\"id\";i:12678;s:5:\"title\";s:23:\"Magazine &#8211; Header\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2020/06/Header-magazine.png\";s:12:\"tmpl_created\";i:1579060701;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/blocks/magazine-header/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:28:\"[\"Blog\",\"header\",\"Magazine\"]\";s:10:\"menu_order\";i:226;s:16:\"popularity_index\";i:295;s:11:\"trend_index\";i:197;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:694;a:15:{s:2:\"id\";i:2094;s:5:\"title\";s:28:\"Plants Shop &#8211; Homepage\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2017/11/Plants-Shop-Home.png\";s:12:\"tmpl_created\";i:1509621053;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/plants-shop-homepage/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:227;s:16:\"popularity_index\";i:269;s:11:\"trend_index\";i:254;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:695;a:15:{s:2:\"id\";i:12661;s:5:\"title\";s:23:\"Magazine &#8211; Search\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2020/01/Search_s.png\";s:12:\"tmpl_created\";i:1579060722;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/blocks/magazine-search/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"archive\";s:4:\"tags\";s:19:\"[\"Blog\",\"Magazine\"]\";s:10:\"menu_order\";i:227;s:16:\"popularity_index\";i:396;s:11:\"trend_index\";i:509;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:696;a:15:{s:2:\"id\";i:2120;s:5:\"title\";s:25:\"Plants Shop &#8211; About\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2017/11/Plants-Shop-About.png\";s:12:\"tmpl_created\";i:1509631820;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/plants-shop-about/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:228;s:16:\"popularity_index\";i:376;s:11:\"trend_index\";i:573;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:697;a:15:{s:2:\"id\";i:12688;s:5:\"title\";s:30:\"Magazine &#8211; Single Post 1\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2020/01/Post2_s.png\";s:12:\"tmpl_created\";i:1579060692;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/blocks/magazine-single-post-1/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:19:\"[\"Blog\",\"Magazine\"]\";s:10:\"menu_order\";i:228;s:16:\"popularity_index\";i:342;s:11:\"trend_index\";i:175;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:698;a:15:{s:2:\"id\";i:3153;s:5:\"title\";s:14:\"Halloween Pack\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2017/10/halloween.png\";s:12:\"tmpl_created\";i:1508950132;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:104:\"https://library.elementor.com/halloween-pack/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:229;s:16:\"popularity_index\";i:685;s:11:\"trend_index\";i:775;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:699;a:15:{s:2:\"id\";i:12699;s:5:\"title\";s:30:\"Magazine &#8211; Single Post 2\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2020/01/Post3_s.png\";s:12:\"tmpl_created\";i:1579060680;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/blocks/magazine-single-post-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:19:\"[\"Blog\",\"Magazine\"]\";s:10:\"menu_order\";i:229;s:16:\"popularity_index\";i:348;s:11:\"trend_index\";i:129;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:700;a:15:{s:2:\"id\";i:3338;s:5:\"title\";s:31:\"Black Friday &#8211; Nature Set\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2017/11/black-friday-1.png\";s:12:\"tmpl_created\";i:1511203351;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:113:\"https://library.elementor.com/black-friday-nature-set/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:230;s:16:\"popularity_index\";i:604;s:11:\"trend_index\";i:786;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:701;a:15:{s:2:\"id\";i:12707;s:5:\"title\";s:30:\"Magazine &#8211; Single Post 3\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2020/01/Post1_s.png\";s:12:\"tmpl_created\";i:1579060669;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/blocks/magazine-single-post-3/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:19:\"[\"Blog\",\"Magazine\"]\";s:10:\"menu_order\";i:230;s:16:\"popularity_index\";i:476;s:11:\"trend_index\";i:246;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:702;a:15:{s:2:\"id\";i:3339;s:5:\"title\";s:35:\"Black Friday &#8211; Pop-Styled Set\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2017/11/black-friday-2.png\";s:12:\"tmpl_created\";i:1511203636;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/black-friday-pop-styled-set/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:231;s:16:\"popularity_index\";i:561;s:11:\"trend_index\";i:836;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:703;a:15:{s:2:\"id\";i:12716;s:5:\"title\";s:30:\"Magazine &#8211; Single Post 3\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2020/01/Post4_s.png\";s:12:\"tmpl_created\";i:1579060659;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:121:\"https://library.elementor.com/blocks/magazine-single-post-3-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:19:\"[\"Blog\",\"Magazine\"]\";s:10:\"menu_order\";i:231;s:16:\"popularity_index\";i:513;s:11:\"trend_index\";i:489;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:704;a:15:{s:2:\"id\";i:3335;s:5:\"title\";s:31:\"Black Friday &#8211; Retail Set\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2017/11/black-friday-4.png\";s:12:\"tmpl_created\";i:1511203246;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:113:\"https://library.elementor.com/black-friday-retail-set/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:232;s:16:\"popularity_index\";i:560;s:11:\"trend_index\";i:680;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:705;a:15:{s:2:\"id\";i:12652;s:5:\"title\";s:17:\"Magazine- Archiv2\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2020/01/Archiv2_s.png\";s:12:\"tmpl_created\";i:1579060730;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:113:\"https://library.elementor.com/blocks/magazine-archiv2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"archive\";s:4:\"tags\";s:19:\"[\"Blog\",\"Magazine\"]\";s:10:\"menu_order\";i:232;s:16:\"popularity_index\";i:525;s:11:\"trend_index\";i:585;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:706;a:15:{s:2:\"id\";i:3340;s:5:\"title\";s:41:\"Black Friday &#8211; Software Product Set\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2017/11/black-friday-3.png\";s:12:\"tmpl_created\";i:1511203713;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:123:\"https://library.elementor.com/black-friday-software-product-set/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:233;s:16:\"popularity_index\";i:502;s:11:\"trend_index\";i:592;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:707;a:15:{s:2:\"id\";i:13361;s:5:\"title\";s:25:\"Online Course &#8211; 404\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2020/04/404.jpg\";s:12:\"tmpl_created\";i:1587474710;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/blocks/online-course-404/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:35:\"[\"404\",\"Course Online\",\"Education\"]\";s:10:\"menu_order\";i:233;s:16:\"popularity_index\";i:682;s:11:\"trend_index\";i:498;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:708;a:15:{s:2:\"id\";i:3517;s:5:\"title\";s:27:\"Christmas &#8211; Gift Shop\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2017/12/XmasThumb.png\";s:12:\"tmpl_created\";i:1513877937;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:109:\"https://library.elementor.com/christmas-gift-shop/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:234;s:16:\"popularity_index\";i:580;s:11:\"trend_index\";i:834;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:709;a:15:{s:2:\"id\";i:13387;s:5:\"title\";s:32:\"Online Course &#8211; End Lesson\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2020/04/Lesson-End-.jpg\";s:12:\"tmpl_created\";i:1587474682;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:121:\"https://library.elementor.com/blocks/online-course-end-lesson/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:29:\"[\"Course Online\",\"Education\"]\";s:10:\"menu_order\";i:234;s:16:\"popularity_index\";i:653;s:11:\"trend_index\";i:408;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:710;a:15:{s:2:\"id\";i:3734;s:5:\"title\";s:28:\"Christmas &#8211; Car Agency\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2017/12/cover-lib-v3.png\";s:12:\"tmpl_created\";i:1514197794;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/christmas-car-agency/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:235;s:16:\"popularity_index\";i:575;s:11:\"trend_index\";i:622;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:711;a:15:{s:2:\"id\";i:13369;s:5:\"title\";s:28:\"Online Course &#8211; Footer\";s:9:\"thumbnail\";s:67:\"https://library.elementor.com/wp-content/uploads/2020/04/Footer.jpg\";s:12:\"tmpl_created\";i:1587474701;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/blocks/online-course-footer/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:38:\"[\"Course Online\",\"Education\",\"footer\"]\";s:10:\"menu_order\";i:235;s:16:\"popularity_index\";i:389;s:11:\"trend_index\";i:308;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:712;a:15:{s:2:\"id\";i:3764;s:5:\"title\";s:33:\"Christmas &#8211; Interior Design\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2017/12/cover-lib-v6.png\";s:12:\"tmpl_created\";i:1514198234;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/christmas-interior-design/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:236;s:16:\"popularity_index\";i:566;s:11:\"trend_index\";i:708;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:713;a:15:{s:2:\"id\";i:13378;s:5:\"title\";s:28:\"Online Course &#8211; Header\";s:9:\"thumbnail\";s:92:\"https://library.elementor.com/wp-content/uploads/2020/06/Header-education-online-courses.jpg\";s:12:\"tmpl_created\";i:1587474693;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/blocks/online-course-header/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:38:\"[\"Course Online\",\"Education\",\"header\"]\";s:10:\"menu_order\";i:236;s:16:\"popularity_index\";i:492;s:11:\"trend_index\";i:519;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:714;a:15:{s:2:\"id\";i:3565;s:5:\"title\";s:27:\"Christmas &#8211; Tree Shop\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2017/12/XmasTreeThumb.png\";s:12:\"tmpl_created\";i:1514204382;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:109:\"https://library.elementor.com/christmas-tree-shop/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:237;s:16:\"popularity_index\";i:455;s:11:\"trend_index\";i:469;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:715;a:15:{s:2:\"id\";i:13395;s:5:\"title\";s:34:\"Online Course &#8211; Start Lesson\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2020/04/Lesson-Start.jpg\";s:12:\"tmpl_created\";i:1587474673;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:123:\"https://library.elementor.com/blocks/online-course-start-lesson/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:29:\"[\"Course Online\",\"Education\"]\";s:10:\"menu_order\";i:237;s:16:\"popularity_index\";i:672;s:11:\"trend_index\";i:578;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:716;a:15:{s:2:\"id\";i:3862;s:5:\"title\";s:35:\"Christmas &#8211; Design Conference\";s:9:\"thumbnail\";s:63:\"https://library.elementor.com/wp-content/uploads/2017/12/q1.png\";s:12:\"tmpl_created\";i:1514206745;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/christmas-design-conference/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:238;s:16:\"popularity_index\";i:473;s:11:\"trend_index\";i:518;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:717;a:15:{s:2:\"id\";i:13089;s:5:\"title\";s:23:\"Photography &#8211; 404\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2020/02/404_s.png\";s:12:\"tmpl_created\";i:1582091623;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/blocks/photography-404/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:33:\"[\"404\",\"Photography\",\"portfolio\"]\";s:10:\"menu_order\";i:238;s:16:\"popularity_index\";i:702;s:11:\"trend_index\";i:706;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:718;a:15:{s:2:\"id\";i:3777;s:5:\"title\";s:39:\"Christmas &#8211; Snowboard Competition\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2017/12/cover-lib-v7.png\";s:12:\"tmpl_created\";i:1514205420;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:121:\"https://library.elementor.com/christmas-snowboard-competition/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:239;s:16:\"popularity_index\";i:509;s:11:\"trend_index\";i:682;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:719;a:15:{s:2:\"id\";i:13096;s:5:\"title\";s:32:\"Photography &#8211; Archiv Media\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2020/02/Archiv_s.png\";s:12:\"tmpl_created\";i:1582091742;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:121:\"https://library.elementor.com/blocks/photography-archiv-media/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"archive\";s:4:\"tags\";s:27:\"[\"Photography\",\"portfolio\"]\";s:10:\"menu_order\";i:239;s:16:\"popularity_index\";i:631;s:11:\"trend_index\";i:405;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:720;a:15:{s:2:\"id\";i:420;s:5:\"title\";s:11:\"Hero UI Kit\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2016/09/library-ui-kit-cover.png\";s:12:\"tmpl_created\";i:1475067229;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:101:\"https://library.elementor.com/hero-ui-kit/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:240;s:16:\"popularity_index\";i:22;s:11:\"trend_index\";i:160;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:721;a:15:{s:2:\"id\";i:13103;s:5:\"title\";s:26:\"Photography &#8211; Footer\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2020/02/Footer_s.png\";s:12:\"tmpl_created\";i:1582091903;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/blocks/photography-footer/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:36:\"[\"footer\",\"Photography\",\"portfolio\"]\";s:10:\"menu_order\";i:240;s:16:\"popularity_index\";i:422;s:11:\"trend_index\";i:230;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:722;a:15:{s:2:\"id\";i:13112;s:5:\"title\";s:26:\"Photography &#8211; Header\";s:9:\"thumbnail\";s:89:\"https://library.elementor.com/wp-content/uploads/2020/06/Header-photography-portfolio.png\";s:12:\"tmpl_created\";i:1582092483;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/blocks/photography-header/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:36:\"[\"header\",\"Photography\",\"portfolio\"]\";s:10:\"menu_order\";i:241;s:16:\"popularity_index\";i:325;s:11:\"trend_index\";i:205;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:723;a:15:{s:2:\"id\";i:13120;s:5:\"title\";s:31:\"Photography &#8211; Single Post\";s:9:\"thumbnail\";s:67:\"https://library.elementor.com/wp-content/uploads/2020/02/Post_s.png\";s:12:\"tmpl_created\";i:1582092351;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.elementor.com/blocks/photography-single-post/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:27:\"[\"Photography\",\"portfolio\"]\";s:10:\"menu_order\";i:242;s:16:\"popularity_index\";i:671;s:11:\"trend_index\";i:645;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:724;a:15:{s:2:\"id\";i:11807;s:5:\"title\";s:9:\"Portfolio\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2019/09/404_small.png\";s:12:\"tmpl_created\";i:1569430070;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:109:\"https://library.elementor.com/blocks/portfolio-20/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:40:\"[\"404\",\"creative portfolio\",\"portfolio\"]\";s:10:\"menu_order\";i:243;s:16:\"popularity_index\";i:480;s:11:\"trend_index\";i:497;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:725;a:15:{s:2:\"id\";i:11832;s:5:\"title\";s:9:\"Portfolio\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2019/09/Footer_small.png\";s:12:\"tmpl_created\";i:1569430019;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:109:\"https://library.elementor.com/blocks/portfolio-19/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:43:\"[\"creative portfolio\",\"footer\",\"portfolio\"]\";s:10:\"menu_order\";i:244;s:16:\"popularity_index\";i:246;s:11:\"trend_index\";i:102;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:726;a:15:{s:2:\"id\";i:11847;s:5:\"title\";s:9:\"Portfolio\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2019/09/Archiv_small.png\";s:12:\"tmpl_created\";i:1569430010;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/portfolio-8/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"archive\";s:4:\"tags\";s:34:\"[\"creative portfolio\",\"portfolio\"]\";s:10:\"menu_order\";i:245;s:16:\"popularity_index\";i:336;s:11:\"trend_index\";i:455;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:727;a:15:{s:2:\"id\";i:11854;s:5:\"title\";s:9:\"Portfolio\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2019/09/Post_small.png\";s:12:\"tmpl_created\";i:1569429983;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/portfolio/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:34:\"[\"creative portfolio\",\"portfolio\"]\";s:10:\"menu_order\";i:246;s:16:\"popularity_index\";i:482;s:11:\"trend_index\";i:609;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:728;a:15:{s:2:\"id\";i:11890;s:5:\"title\";s:9:\"Portfolio\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2020/06/Header-design-portfolio.png\";s:12:\"tmpl_created\";i:1571907344;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/portfolio-9/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:43:\"[\"creative portfolio\",\"header\",\"portfolio\"]\";s:10:\"menu_order\";i:247;s:16:\"popularity_index\";i:306;s:11:\"trend_index\";i:364;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:729;a:15:{s:2:\"id\";i:11861;s:5:\"title\";s:27:\"Portfolio &#8211; Project 1\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2019/09/Project1_small.png\";s:12:\"tmpl_created\";i:1569429975;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/blocks/portfolio-project-1/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:34:\"[\"creative portfolio\",\"portfolio\"]\";s:10:\"menu_order\";i:248;s:16:\"popularity_index\";i:643;s:11:\"trend_index\";i:764;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:730;a:15:{s:2:\"id\";i:11870;s:5:\"title\";s:27:\"Portfolio &#8211; Project 2\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2019/09/Project2_small.png\";s:12:\"tmpl_created\";i:1569429964;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/blocks/portfolio-project-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:34:\"[\"creative portfolio\",\"portfolio\"]\";s:10:\"menu_order\";i:249;s:16:\"popularity_index\";i:662;s:11:\"trend_index\";i:816;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:731;a:15:{s:2:\"id\";i:11897;s:5:\"title\";s:27:\"Portfolio &#8211; Project 2\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2019/09/Project2_small.png\";s:12:\"tmpl_created\";i:1569494236;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/blocks/portfolio-project-2-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:34:\"[\"creative portfolio\",\"portfolio\"]\";s:10:\"menu_order\";i:250;s:16:\"popularity_index\";i:733;s:11:\"trend_index\";i:744;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:732;a:15:{s:2:\"id\";i:11877;s:5:\"title\";s:27:\"Portfolio &#8211; Project 3\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2019/09/Project3_small.png\";s:12:\"tmpl_created\";i:1569429954;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/blocks/portfolio-project-3/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:34:\"[\"creative portfolio\",\"portfolio\"]\";s:10:\"menu_order\";i:251;s:16:\"popularity_index\";i:692;s:11:\"trend_index\";i:0;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:733;a:15:{s:2:\"id\";i:5019;s:5:\"title\";s:11:\"Portfolio 1\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2018/03/portfolio_black_1.png\";s:12:\"tmpl_created\";i:1520520580;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/portfolio-1/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:9:\"portfolio\";s:4:\"tags\";s:13:\"[\"portfolio\"]\";s:10:\"menu_order\";i:252;s:16:\"popularity_index\";i:170;s:11:\"trend_index\";i:236;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:734;a:15:{s:2:\"id\";i:5141;s:5:\"title\";s:12:\"Portfolio 10\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2018/03/portfolio_white_10.png\";s:12:\"tmpl_created\";i:1520520601;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:109:\"https://library.elementor.com/blocks/portfolio-10/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:9:\"portfolio\";s:4:\"tags\";s:13:\"[\"portfolio\"]\";s:10:\"menu_order\";i:253;s:16:\"popularity_index\";i:416;s:11:\"trend_index\";i:478;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:735;a:15:{s:2:\"id\";i:5027;s:5:\"title\";s:12:\"Portfolio 11\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2018/03/portfolio_white_2.png\";s:12:\"tmpl_created\";i:1520520581;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:109:\"https://library.elementor.com/blocks/portfolio-11/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:9:\"portfolio\";s:4:\"tags\";s:13:\"[\"portfolio\"]\";s:10:\"menu_order\";i:254;s:16:\"popularity_index\";i:304;s:11:\"trend_index\";i:421;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:736;a:15:{s:2:\"id\";i:5037;s:5:\"title\";s:12:\"Portfolio 12\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2018/03/portfolio_white_3.png\";s:12:\"tmpl_created\";i:1520520583;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:109:\"https://library.elementor.com/blocks/portfolio-12/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:9:\"portfolio\";s:4:\"tags\";s:13:\"[\"portfolio\"]\";s:10:\"menu_order\";i:255;s:16:\"popularity_index\";i:279;s:11:\"trend_index\";i:399;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:737;a:15:{s:2:\"id\";i:5057;s:5:\"title\";s:12:\"Portfolio 13\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2018/03/portfolio_white_4.png\";s:12:\"tmpl_created\";i:1520520586;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:109:\"https://library.elementor.com/blocks/portfolio-13/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:9:\"portfolio\";s:4:\"tags\";s:13:\"[\"portfolio\"]\";s:10:\"menu_order\";i:256;s:16:\"popularity_index\";i:239;s:11:\"trend_index\";i:288;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:738;a:15:{s:2:\"id\";i:5071;s:5:\"title\";s:12:\"Portfolio 14\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2018/03/portfolio_white_5.png\";s:12:\"tmpl_created\";i:1520520588;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:109:\"https://library.elementor.com/blocks/portfolio-14/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:9:\"portfolio\";s:4:\"tags\";s:13:\"[\"portfolio\"]\";s:10:\"menu_order\";i:257;s:16:\"popularity_index\";i:276;s:11:\"trend_index\";i:329;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:739;a:15:{s:2:\"id\";i:5090;s:5:\"title\";s:12:\"Portfolio 15\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2018/03/portfolio_white_6.png\";s:12:\"tmpl_created\";i:1520520591;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:109:\"https://library.elementor.com/blocks/portfolio-15/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:9:\"portfolio\";s:4:\"tags\";s:13:\"[\"portfolio\"]\";s:10:\"menu_order\";i:258;s:16:\"popularity_index\";i:186;s:11:\"trend_index\";i:283;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:740;a:15:{s:2:\"id\";i:5098;s:5:\"title\";s:12:\"Portfolio 16\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2018/03/portfolio_white_7.png\";s:12:\"tmpl_created\";i:1520520593;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:109:\"https://library.elementor.com/blocks/portfolio-16/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:9:\"portfolio\";s:4:\"tags\";s:13:\"[\"portfolio\"]\";s:10:\"menu_order\";i:259;s:16:\"popularity_index\";i:156;s:11:\"trend_index\";i:211;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:741;a:15:{s:2:\"id\";i:5115;s:5:\"title\";s:12:\"Portfolio 17\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2018/03/portfolio_white_8.png\";s:12:\"tmpl_created\";i:1520520596;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:109:\"https://library.elementor.com/blocks/portfolio-17/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:9:\"portfolio\";s:4:\"tags\";s:13:\"[\"portfolio\"]\";s:10:\"menu_order\";i:260;s:16:\"popularity_index\";i:19;s:11:\"trend_index\";i:22;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:742;a:15:{s:2:\"id\";i:5133;s:5:\"title\";s:12:\"Portfolio 18\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2018/03/portfolio_white_9.png\";s:12:\"tmpl_created\";i:1520520599;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:109:\"https://library.elementor.com/blocks/portfolio-18/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:9:\"portfolio\";s:4:\"tags\";s:13:\"[\"portfolio\"]\";s:10:\"menu_order\";i:261;s:16:\"popularity_index\";i:180;s:11:\"trend_index\";i:280;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:743;a:15:{s:2:\"id\";i:5149;s:5:\"title\";s:11:\"Portfolio 2\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2018/03/portfolio_black_10.png\";s:12:\"tmpl_created\";i:1520520602;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/portfolio-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:9:\"portfolio\";s:4:\"tags\";s:13:\"[\"portfolio\"]\";s:10:\"menu_order\";i:262;s:16:\"popularity_index\";i:413;s:11:\"trend_index\";i:635;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:744;a:15:{s:2:\"id\";i:5045;s:5:\"title\";s:11:\"Portfolio 3\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2018/03/portfolio_black_2.png\";s:12:\"tmpl_created\";i:1520443423;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/portfolio-3/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:9:\"portfolio\";s:4:\"tags\";s:13:\"[\"portfolio\"]\";s:10:\"menu_order\";i:263;s:16:\"popularity_index\";i:636;s:11:\"trend_index\";i:608;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:745;a:15:{s:2:\"id\";i:5082;s:5:\"title\";s:11:\"Portfolio 4\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2018/03/portfolio_black_4.png\";s:12:\"tmpl_created\";i:1520520589;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/portfolio-4/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:9:\"portfolio\";s:4:\"tags\";s:13:\"[\"portfolio\"]\";s:10:\"menu_order\";i:264;s:16:\"popularity_index\";i:558;s:11:\"trend_index\";i:654;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:746;a:15:{s:2:\"id\";i:5107;s:5:\"title\";s:11:\"Portfolio 5\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2018/03/portfolio_black_7.png\";s:12:\"tmpl_created\";i:1520520594;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/portfolio-5/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:9:\"portfolio\";s:4:\"tags\";s:13:\"[\"portfolio\"]\";s:10:\"menu_order\";i:265;s:16:\"popularity_index\";i:380;s:11:\"trend_index\";i:347;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:747;a:15:{s:2:\"id\";i:5125;s:5:\"title\";s:11:\"Portfolio 6\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2018/03/portfolio_black_8.png\";s:12:\"tmpl_created\";i:1520520597;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/portfolio-6/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:9:\"portfolio\";s:4:\"tags\";s:13:\"[\"portfolio\"]\";s:10:\"menu_order\";i:266;s:16:\"popularity_index\";i:236;s:11:\"trend_index\";i:386;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:748;a:15:{s:2:\"id\";i:5007;s:5:\"title\";s:11:\"Portfolio 7\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2018/03/portfolio_white_1.png\";s:12:\"tmpl_created\";i:1520520578;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/portfolio-7/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:9:\"portfolio\";s:4:\"tags\";s:13:\"[\"portfolio\"]\";s:10:\"menu_order\";i:267;s:16:\"popularity_index\";i:44;s:11:\"trend_index\";i:183;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:749;a:15:{s:2:\"id\";i:4509;s:5:\"title\";s:9:\"Pricing 1\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/02/price_black_1.png\";s:12:\"tmpl_created\";i:1520443310;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/pricing-1/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"pricing\";s:4:\"tags\";s:11:\"[\"pricing\"]\";s:10:\"menu_order\";i:268;s:16:\"popularity_index\";i:703;s:11:\"trend_index\";i:641;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:750;a:15:{s:2:\"id\";i:4553;s:5:\"title\";s:10:\"Pricing 10\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/02/price_white_4.png\";s:12:\"tmpl_created\";i:1520443319;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/blocks/pricing-10/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"pricing\";s:4:\"tags\";s:11:\"[\"pricing\"]\";s:10:\"menu_order\";i:269;s:16:\"popularity_index\";i:511;s:11:\"trend_index\";i:506;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:751;a:15:{s:2:\"id\";i:4572;s:5:\"title\";s:10:\"Pricing 11\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/02/price_white_5.png\";s:12:\"tmpl_created\";i:1520443324;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/blocks/pricing-11/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"pricing\";s:4:\"tags\";s:11:\"[\"pricing\"]\";s:10:\"menu_order\";i:270;s:16:\"popularity_index\";i:308;s:11:\"trend_index\";i:248;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:752;a:15:{s:2:\"id\";i:4580;s:5:\"title\";s:10:\"Pricing 12\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/02/price_white_6.png\";s:12:\"tmpl_created\";i:1520443326;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/blocks/pricing-12/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"pricing\";s:4:\"tags\";s:11:\"[\"pricing\"]\";s:10:\"menu_order\";i:271;s:16:\"popularity_index\";i:576;s:11:\"trend_index\";i:526;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:753;a:15:{s:2:\"id\";i:4597;s:5:\"title\";s:10:\"Pricing 13\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/02/price_white_7.png\";s:12:\"tmpl_created\";i:1520443330;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/blocks/pricing-13/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"pricing\";s:4:\"tags\";s:11:\"[\"pricing\"]\";s:10:\"menu_order\";i:272;s:16:\"popularity_index\";i:613;s:11:\"trend_index\";i:450;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:754;a:15:{s:2:\"id\";i:4613;s:5:\"title\";s:10:\"Pricing 14\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/02/price_white_8.png\";s:12:\"tmpl_created\";i:1520443334;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/blocks/pricing-14/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"pricing\";s:4:\"tags\";s:11:\"[\"pricing\"]\";s:10:\"menu_order\";i:273;s:16:\"popularity_index\";i:581;s:11:\"trend_index\";i:568;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:755;a:15:{s:2:\"id\";i:4529;s:5:\"title\";s:9:\"Pricing 2\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/02/price_black_2.png\";s:12:\"tmpl_created\";i:1520443314;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/pricing-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"pricing\";s:4:\"tags\";s:11:\"[\"pricing\"]\";s:10:\"menu_order\";i:274;s:16:\"popularity_index\";i:609;s:11:\"trend_index\";i:613;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:756;a:15:{s:2:\"id\";i:4545;s:5:\"title\";s:9:\"Pricing 3\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/02/price_black_3.png\";s:12:\"tmpl_created\";i:1520443317;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/pricing-3/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"pricing\";s:4:\"tags\";s:11:\"[\"pricing\"]\";s:10:\"menu_order\";i:275;s:16:\"popularity_index\";i:707;s:11:\"trend_index\";i:825;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:757;a:15:{s:2:\"id\";i:4562;s:5:\"title\";s:9:\"Pricing 4\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/02/price_black_4.png\";s:12:\"tmpl_created\";i:1520443322;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/pricing-4/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"pricing\";s:4:\"tags\";s:11:\"[\"pricing\"]\";s:10:\"menu_order\";i:276;s:16:\"popularity_index\";i:697;s:11:\"trend_index\";i:821;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:758;a:15:{s:2:\"id\";i:4589;s:5:\"title\";s:9:\"Pricing 5\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/02/price_black_6.png\";s:12:\"tmpl_created\";i:1520443327;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/pricing-5/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"pricing\";s:4:\"tags\";s:11:\"[\"pricing\"]\";s:10:\"menu_order\";i:277;s:16:\"popularity_index\";i:716;s:11:\"trend_index\";i:639;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:759;a:15:{s:2:\"id\";i:4605;s:5:\"title\";s:9:\"Pricing 6\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/02/price_black_7.png\";s:12:\"tmpl_created\";i:1520443332;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/pricing-6/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"pricing\";s:4:\"tags\";s:11:\"[\"pricing\"]\";s:10:\"menu_order\";i:278;s:16:\"popularity_index\";i:738;s:11:\"trend_index\";i:773;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:760;a:15:{s:2:\"id\";i:4500;s:5:\"title\";s:9:\"Pricing 7\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/02/price_white_1.png\";s:12:\"tmpl_created\";i:1520443308;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/pricing-7/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"pricing\";s:4:\"tags\";s:11:\"[\"pricing\"]\";s:10:\"menu_order\";i:279;s:16:\"popularity_index\";i:500;s:11:\"trend_index\";i:451;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:761;a:15:{s:2:\"id\";i:4521;s:5:\"title\";s:9:\"Pricing 8\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/02/price_white_2.png\";s:12:\"tmpl_created\";i:1520443312;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/pricing-8/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"pricing\";s:4:\"tags\";s:11:\"[\"pricing\"]\";s:10:\"menu_order\";i:280;s:16:\"popularity_index\";i:311;s:11:\"trend_index\";i:372;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:762;a:15:{s:2:\"id\";i:4537;s:5:\"title\";s:9:\"Pricing 9\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/02/price_white_3.png\";s:12:\"tmpl_created\";i:1520443315;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/pricing-9/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"pricing\";s:4:\"tags\";s:11:\"[\"pricing\"]\";s:10:\"menu_order\";i:281;s:16:\"popularity_index\";i:589;s:11:\"trend_index\";i:841;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:763;a:15:{s:2:\"id\";i:9239;s:5:\"title\";s:17:\"product archive 1\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2018/07/product-archive-350-1.png\";s:12:\"tmpl_created\";i:1532953482;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/blocks/product-archive-1/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:15:\"product archive\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:282;s:16:\"popularity_index\";i:60;s:11:\"trend_index\";i:25;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:764;a:15:{s:2:\"id\";i:9247;s:5:\"title\";s:17:\"product archive 2\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2018/07/product-archive-350-2.png\";s:12:\"tmpl_created\";i:1532953793;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/blocks/product-archive-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:15:\"product archive\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:283;s:16:\"popularity_index\";i:71;s:11:\"trend_index\";i:30;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:765;a:15:{s:2:\"id\";i:9254;s:5:\"title\";s:17:\"product archive 3\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2018/07/product-archive-350-3.png\";s:12:\"tmpl_created\";i:1532954032;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/blocks/product-archive-3/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:15:\"product archive\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:284;s:16:\"popularity_index\";i:73;s:11:\"trend_index\";i:44;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:766;a:15:{s:2:\"id\";i:15204;s:5:\"title\";s:24:\"Psychologist &#8211; 404\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2020/09/404.jpg\";s:12:\"tmpl_created\";i:1600161419;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:113:\"https://library.elementor.com/blocks/psychologist-404/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:40:\"[\"404\",\"Psychologist\",\"Psychotherapist\"]\";s:10:\"menu_order\";i:285;s:16:\"popularity_index\";i:574;s:11:\"trend_index\";i:493;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:767;a:15:{s:2:\"id\";i:15212;s:5:\"title\";s:28:\"Psychologist &#8211; Archive\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2020/09/Blog.jpg\";s:12:\"tmpl_created\";i:1600162340;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/blocks/psychologist-archive/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"archive\";s:4:\"tags\";s:34:\"[\"Psychologist\",\"Psychotherapist\"]\";s:10:\"menu_order\";i:286;s:16:\"popularity_index\";i:379;s:11:\"trend_index\";i:358;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:768;a:15:{s:2:\"id\";i:15219;s:5:\"title\";s:27:\"Psychologist &#8211; Footer\";s:9:\"thumbnail\";s:67:\"https://library.elementor.com/wp-content/uploads/2020/09/Footer.jpg\";s:12:\"tmpl_created\";i:1600163069;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/blocks/psychologist-footer/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:43:\"[\"footer\",\"Psychologist\",\"Psychotherapist\"]\";s:10:\"menu_order\";i:287;s:16:\"popularity_index\";i:599;s:11:\"trend_index\";i:500;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:769;a:15:{s:2:\"id\";i:15230;s:5:\"title\";s:27:\"Psychologist &#8211; Header\";s:9:\"thumbnail\";s:67:\"https://library.elementor.com/wp-content/uploads/2020/09/Header.png\";s:12:\"tmpl_created\";i:1600163444;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/blocks/psychologist-header/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:43:\"[\"header\",\"Psychologist\",\"Psychotherapist\"]\";s:10:\"menu_order\";i:288;s:16:\"popularity_index\";i:429;s:11:\"trend_index\";i:423;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:770;a:15:{s:2:\"id\";i:15240;s:5:\"title\";s:34:\"Psychologist &#8211; single post 1\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2020/09/Single-Post.png\";s:12:\"tmpl_created\";i:1600164087;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:123:\"https://library.elementor.com/blocks/psychologist-single-post-1/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:34:\"[\"Psychologist\",\"Psychotherapist\"]\";s:10:\"menu_order\";i:289;s:16:\"popularity_index\";i:562;s:11:\"trend_index\";i:570;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:771;a:15:{s:2:\"id\";i:15251;s:5:\"title\";s:34:\"Psychologist &#8211; single post 2\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2020/09/Single-Service-Page.png\";s:12:\"tmpl_created\";i:1600165179;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:123:\"https://library.elementor.com/blocks/psychologist-single-post-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:34:\"[\"Psychologist\",\"Psychotherapist\"]\";s:10:\"menu_order\";i:290;s:16:\"popularity_index\";i:507;s:11:\"trend_index\";i:368;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:772;a:15:{s:2:\"id\";i:4313;s:5:\"title\";s:11:\"Services 13\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/02/Service_white_8.png\";s:12:\"tmpl_created\";i:1520443268;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/services-13/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"services\";s:4:\"tags\";s:12:\"[\"services\"]\";s:10:\"menu_order\";i:291;s:16:\"popularity_index\";i:115;s:11:\"trend_index\";i:53;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:773;a:15:{s:2:\"id\";i:4324;s:5:\"title\";s:11:\"Services 14\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/02/Service_white_9.png\";s:12:\"tmpl_created\";i:1520443270;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/services-14/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"services\";s:4:\"tags\";s:12:\"[\"services\"]\";s:10:\"menu_order\";i:292;s:16:\"popularity_index\";i:277;s:11:\"trend_index\";i:138;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:774;a:15:{s:2:\"id\";i:4368;s:5:\"title\";s:11:\"Services 16\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2018/02/Service_white_13.png\";s:12:\"tmpl_created\";i:1520443279;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/services-16/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"services\";s:4:\"tags\";s:12:\"[\"services\"]\";s:10:\"menu_order\";i:293;s:16:\"popularity_index\";i:62;s:11:\"trend_index\";i:59;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:775;a:15:{s:2:\"id\";i:4391;s:5:\"title\";s:11:\"Services 17\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2018/02/Service_white_14.png\";s:12:\"tmpl_created\";i:1520443283;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/services-17/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"services\";s:4:\"tags\";s:12:\"[\"services\"]\";s:10:\"menu_order\";i:294;s:16:\"popularity_index\";i:153;s:11:\"trend_index\";i:120;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:776;a:15:{s:2:\"id\";i:4235;s:5:\"title\";s:11:\"Services 18\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/02/Service_white_2.png\";s:12:\"tmpl_created\";i:1520443251;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/services-18/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"services\";s:4:\"tags\";s:12:\"[\"services\"]\";s:10:\"menu_order\";i:295;s:16:\"popularity_index\";i:273;s:11:\"trend_index\";i:172;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:777;a:15:{s:2:\"id\";i:4357;s:5:\"title\";s:11:\"Services 20\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2018/02/Service_white_12.png\";s:12:\"tmpl_created\";i:1520443277;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/services-20/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"services\";s:4:\"tags\";s:12:\"[\"services\"]\";s:10:\"menu_order\";i:296;s:16:\"popularity_index\";i:45;s:11:\"trend_index\";i:45;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:778;a:15:{s:2:\"id\";i:4341;s:5:\"title\";s:11:\"Services 21\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2018/02/Service_white_11.png\";s:12:\"tmpl_created\";i:1520443274;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/services-21/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"services\";s:4:\"tags\";s:12:\"[\"services\"]\";s:10:\"menu_order\";i:297;s:16:\"popularity_index\";i:142;s:11:\"trend_index\";i:114;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:779;a:15:{s:2:\"id\";i:4332;s:5:\"title\";s:11:\"Services 22\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2018/02/Service_white_10.png\";s:12:\"tmpl_created\";i:1520443272;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/services-22/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"services\";s:4:\"tags\";s:12:\"[\"services\"]\";s:10:\"menu_order\";i:298;s:16:\"popularity_index\";i:138;s:11:\"trend_index\";i:149;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:780;a:15:{s:2:\"id\";i:4212;s:5:\"title\";s:11:\"Services 23\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/02/Service_white_1.png\";s:12:\"tmpl_created\";i:1520443248;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/services-23/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"services\";s:4:\"tags\";s:12:\"[\"services\"]\";s:10:\"menu_order\";i:299;s:16:\"popularity_index\";i:136;s:11:\"trend_index\";i:302;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:781;a:15:{s:2:\"id\";i:4276;s:5:\"title\";s:11:\"Services 24\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/02/Service_black_4.png\";s:12:\"tmpl_created\";i:1520443261;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/services-24/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"services\";s:4:\"tags\";s:12:\"[\"services\"]\";s:10:\"menu_order\";i:300;s:16:\"popularity_index\";i:353;s:11:\"trend_index\";i:514;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:782;a:15:{s:2:\"id\";i:4260;s:5:\"title\";s:11:\"Services 25\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/02/Service_black_3.png\";s:12:\"tmpl_created\";i:1520443257;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/services-25/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"services\";s:4:\"tags\";s:12:\"[\"services\"]\";s:10:\"menu_order\";i:301;s:16:\"popularity_index\";i:184;s:11:\"trend_index\";i:209;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:783;a:15:{s:2:\"id\";i:4244;s:5:\"title\";s:11:\"Services 26\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/02/Service_black_2.png\";s:12:\"tmpl_created\";i:1520443253;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/services-26/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"services\";s:4:\"tags\";s:12:\"[\"services\"]\";s:10:\"menu_order\";i:302;s:16:\"popularity_index\";i:544;s:11:\"trend_index\";i:596;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:784;a:15:{s:2:\"id\";i:4400;s:5:\"title\";s:11:\"Services 27\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2018/02/Service_black_13.png\";s:12:\"tmpl_created\";i:1520443285;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/services-27/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"services\";s:4:\"tags\";s:12:\"[\"services\"]\";s:10:\"menu_order\";i:303;s:16:\"popularity_index\";i:286;s:11:\"trend_index\";i:438;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:785;a:15:{s:2:\"id\";i:4376;s:5:\"title\";s:11:\"Services 28\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2018/02/Service_black_12.png\";s:12:\"tmpl_created\";i:1520443281;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/services-28/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"services\";s:4:\"tags\";s:12:\"[\"services\"]\";s:10:\"menu_order\";i:304;s:16:\"popularity_index\";i:151;s:11:\"trend_index\";i:249;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:786;a:15:{s:2:\"id\";i:4349;s:5:\"title\";s:11:\"Services 29\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2018/02/Service_black_11.png\";s:12:\"tmpl_created\";i:1520443275;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/services-29/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"services\";s:4:\"tags\";s:12:\"[\"services\"]\";s:10:\"menu_order\";i:305;s:16:\"popularity_index\";i:330;s:11:\"trend_index\";i:483;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:787;a:15:{s:2:\"id\";i:4227;s:5:\"title\";s:11:\"Services 30\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/02/Service_black_1.png\";s:12:\"tmpl_created\";i:1520443250;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/services-30/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"services\";s:4:\"tags\";s:12:\"[\"services\"]\";s:10:\"menu_order\";i:306;s:16:\"popularity_index\";i:351;s:11:\"trend_index\";i:553;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:788;a:15:{s:2:\"id\";i:6162;s:5:\"title\";s:11:\"Services 31\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2018/03/progress_white_1.png\";s:12:\"tmpl_created\";i:1520443668;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/services-31/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"stats\";s:4:\"tags\";s:9:\"[\"Stats\"]\";s:10:\"menu_order\";i:307;s:16:\"popularity_index\";i:372;s:11:\"trend_index\";i:550;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:789;a:15:{s:2:\"id\";i:4302;s:5:\"title\";s:10:\"Services 5\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/02/Service_white_7.png\";s:12:\"tmpl_created\";i:1520443266;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/blocks/services-5/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"services\";s:4:\"tags\";s:12:\"[\"services\"]\";s:10:\"menu_order\";i:308;s:16:\"popularity_index\";i:58;s:11:\"trend_index\";i:97;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:790;a:15:{s:2:\"id\";i:4293;s:5:\"title\";s:10:\"Services 6\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/02/Service_white_6.png\";s:12:\"tmpl_created\";i:1520443265;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/blocks/services-6/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"services\";s:4:\"tags\";s:12:\"[\"services\"]\";s:10:\"menu_order\";i:309;s:16:\"popularity_index\";i:288;s:11:\"trend_index\";i:269;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:791;a:15:{s:2:\"id\";i:4284;s:5:\"title\";s:10:\"Services 7\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/02/Service_white_5.png\";s:12:\"tmpl_created\";i:1520443263;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/blocks/services-7/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"services\";s:4:\"tags\";s:12:\"[\"services\"]\";s:10:\"menu_order\";i:310;s:16:\"popularity_index\";i:27;s:11:\"trend_index\";i:21;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:792;a:15:{s:2:\"id\";i:4268;s:5:\"title\";s:10:\"Services 8\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/02/Service_white_4.png\";s:12:\"tmpl_created\";i:1520443259;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/blocks/services-8/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"services\";s:4:\"tags\";s:12:\"[\"services\"]\";s:10:\"menu_order\";i:311;s:16:\"popularity_index\";i:173;s:11:\"trend_index\";i:213;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:793;a:15:{s:2:\"id\";i:4252;s:5:\"title\";s:10:\"Services 9\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/02/Service_white_3.png\";s:12:\"tmpl_created\";i:1520443255;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/blocks/services-9/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"services\";s:4:\"tags\";s:12:\"[\"services\"]\";s:10:\"menu_order\";i:312;s:16:\"popularity_index\";i:46;s:11:\"trend_index\";i:99;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:794;a:15:{s:2:\"id\";i:8676;s:5:\"title\";s:13:\"single page 1\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2018/05/S_P350.6.jpg\";s:12:\"tmpl_created\";i:1527682423;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/blocks/single-page-1/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:313;s:16:\"popularity_index\";i:285;s:11:\"trend_index\";i:145;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:795;a:15:{s:2:\"id\";i:8678;s:5:\"title\";s:13:\"single page 2\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2018/05/S_P350.2.jpg\";s:12:\"tmpl_created\";i:1527682780;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/blocks/single-page-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:314;s:16:\"popularity_index\";i:140;s:11:\"trend_index\";i:82;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:796;a:15:{s:2:\"id\";i:8679;s:5:\"title\";s:13:\"single page 3\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2018/05/S_P350.3.jpg\";s:12:\"tmpl_created\";i:1527682847;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/blocks/single-page-3/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:315;s:16:\"popularity_index\";i:122;s:11:\"trend_index\";i:23;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:797;a:15:{s:2:\"id\";i:8680;s:5:\"title\";s:13:\"single page 4\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2018/05/S_P350.1.jpg\";s:12:\"tmpl_created\";i:1527682896;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/blocks/single-page-4/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:316;s:16:\"popularity_index\";i:373;s:11:\"trend_index\";i:190;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:798;a:15:{s:2:\"id\";i:8681;s:5:\"title\";s:13:\"single page 5\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2018/05/S_P350.5.jpg\";s:12:\"tmpl_created\";i:1527682969;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/blocks/single-page-5/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:317;s:16:\"popularity_index\";i:287;s:11:\"trend_index\";i:218;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:799;a:15:{s:2:\"id\";i:8682;s:5:\"title\";s:13:\"single page 6\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2018/05/S_P350.4.jpg\";s:12:\"tmpl_created\";i:1527683026;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/blocks/single-page-6/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:318;s:16:\"popularity_index\";i:412;s:11:\"trend_index\";i:227;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:800;a:15:{s:2:\"id\";i:8703;s:5:\"title\";s:13:\"single page 7\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2018/05/S_P350.7.jpg\";s:12:\"tmpl_created\";i:1527683072;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/blocks/single-page-7/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:319;s:16:\"popularity_index\";i:401;s:11:\"trend_index\";i:316;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:801;a:15:{s:2:\"id\";i:7650;s:5:\"title\";s:13:\"Single Post 1\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2018/03/single_post_1_v2.jpg\";s:12:\"tmpl_created\";i:1521557736;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/blocks/single-post-1/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:24:\"[\"Blog\",\"Post\",\"Single\"]\";s:10:\"menu_order\";i:320;s:16:\"popularity_index\";i:119;s:11:\"trend_index\";i:266;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:802;a:15:{s:2:\"id\";i:7663;s:5:\"title\";s:13:\"Single Post 2\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2018/03/single_post_2_v2.jpg\";s:12:\"tmpl_created\";i:1521547761;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/blocks/single-post-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:24:\"[\"Blog\",\"Post\",\"Single\"]\";s:10:\"menu_order\";i:321;s:16:\"popularity_index\";i:50;s:11:\"trend_index\";i:139;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:803;a:15:{s:2:\"id\";i:9296;s:5:\"title\";s:13:\"Single Post 3\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2018/09/3002.jpg\";s:12:\"tmpl_created\";i:1537440673;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/blocks/single-post-3/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:322;s:16:\"popularity_index\";i:213;s:11:\"trend_index\";i:204;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:804;a:15:{s:2:\"id\";i:9301;s:5:\"title\";s:13:\"Single Post 4\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2018/09/3003.jpg\";s:12:\"tmpl_created\";i:1537440661;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/blocks/single-post-4/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:323;s:16:\"popularity_index\";i:248;s:11:\"trend_index\";i:336;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:805;a:15:{s:2:\"id\";i:9313;s:5:\"title\";s:13:\"Single Post 5\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2018/09/3001.jpg\";s:12:\"tmpl_created\";i:1537440798;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/blocks/single-post-5/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:324;s:16:\"popularity_index\";i:197;s:11:\"trend_index\";i:177;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:806;a:15:{s:2:\"id\";i:9343;s:5:\"title\";s:13:\"Single Post 6\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2018/09/3004.jpg\";s:12:\"tmpl_created\";i:1537443531;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/blocks/single-post-6/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:325;s:16:\"popularity_index\";i:228;s:11:\"trend_index\";i:279;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:807;a:15:{s:2:\"id\";i:9349;s:5:\"title\";s:13:\"Single Post 7\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2018/09/3005.jpg\";s:12:\"tmpl_created\";i:1537443903;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/blocks/single-post-7/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:326;s:16:\"popularity_index\";i:158;s:11:\"trend_index\";i:253;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:808;a:15:{s:2:\"id\";i:9174;s:5:\"title\";s:17:\"single product 01\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2018/07/single_product01_350.png\";s:12:\"tmpl_created\";i:1532950125;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/blocks/single-product-01/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"single product\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:327;s:16:\"popularity_index\";i:31;s:11:\"trend_index\";i:6;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:809;a:15:{s:2:\"id\";i:9178;s:5:\"title\";s:17:\"single product 02\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2018/07/single_product02_350new.png\";s:12:\"tmpl_created\";i:1532951997;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/blocks/single-product-02/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"single product\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:328;s:16:\"popularity_index\";i:66;s:11:\"trend_index\";i:42;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:810;a:15:{s:2:\"id\";i:9180;s:5:\"title\";s:17:\"single product 03\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2018/07/single_product03_350.png\";s:12:\"tmpl_created\";i:1532952302;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/blocks/single-product-03/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"single product\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:329;s:16:\"popularity_index\";i:108;s:11:\"trend_index\";i:66;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:811;a:15:{s:2:\"id\";i:9182;s:5:\"title\";s:17:\"single product 04\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2018/07/single_product040_350.png\";s:12:\"tmpl_created\";i:1532952606;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/blocks/single-product-04/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"single product\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:330;s:16:\"popularity_index\";i:123;s:11:\"trend_index\";i:81;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:812;a:15:{s:2:\"id\";i:6114;s:5:\"title\";s:7:\"Stats 1\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/numbers_black_6.png\";s:12:\"tmpl_created\";i:1520443659;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:104:\"https://library.elementor.com/blocks/stats-1/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"stats\";s:4:\"tags\";s:11:\"[\"numbers\"]\";s:10:\"menu_order\";i:331;s:16:\"popularity_index\";i:434;s:11:\"trend_index\";i:692;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:813;a:15:{s:2:\"id\";i:6178;s:5:\"title\";s:8:\"Stats 10\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2018/03/progress_white_2.png\";s:12:\"tmpl_created\";i:1520443676;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:105:\"https://library.elementor.com/blocks/stats-10/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"stats\";s:4:\"tags\";s:9:\"[\"Stats\"]\";s:10:\"menu_order\";i:332;s:16:\"popularity_index\";i:435;s:11:\"trend_index\";i:755;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:814;a:15:{s:2:\"id\";i:6170;s:5:\"title\";s:8:\"Stats 11\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2018/03/progress_black_2.png\";s:12:\"tmpl_created\";i:1520443670;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:105:\"https://library.elementor.com/blocks/stats-11/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"stats\";s:4:\"tags\";s:9:\"[\"Stats\"]\";s:10:\"menu_order\";i:333;s:16:\"popularity_index\";i:366;s:11:\"trend_index\";i:552;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:815;a:15:{s:2:\"id\";i:6186;s:5:\"title\";s:8:\"Stats 12\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2018/03/progress_white_3.png\";s:12:\"tmpl_created\";i:1520443678;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:105:\"https://library.elementor.com/blocks/stats-12/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"stats\";s:4:\"tags\";s:9:\"[\"Stats\"]\";s:10:\"menu_order\";i:334;s:16:\"popularity_index\";i:569;s:11:\"trend_index\";i:811;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:816;a:15:{s:2:\"id\";i:6071;s:5:\"title\";s:8:\"Stats 13\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/numbers_white_3.png\";s:12:\"tmpl_created\";i:1520443649;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:105:\"https://library.elementor.com/blocks/stats-13/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"stats\";s:4:\"tags\";s:11:\"[\"numbers\"]\";s:10:\"menu_order\";i:335;s:16:\"popularity_index\";i:168;s:11:\"trend_index\";i:328;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:817;a:15:{s:2:\"id\";i:6106;s:5:\"title\";s:7:\"Stats 2\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/numbers_white_6.png\";s:12:\"tmpl_created\";i:1520443657;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:104:\"https://library.elementor.com/blocks/stats-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"stats\";s:4:\"tags\";s:11:\"[\"numbers\"]\";s:10:\"menu_order\";i:336;s:16:\"popularity_index\";i:361;s:11:\"trend_index\";i:784;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:818;a:15:{s:2:\"id\";i:6079;s:5:\"title\";s:7:\"Stats 3\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/numbers_white_4.png\";s:12:\"tmpl_created\";i:1520443651;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:104:\"https://library.elementor.com/blocks/stats-3/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"stats\";s:4:\"tags\";s:11:\"[\"numbers\"]\";s:10:\"menu_order\";i:337;s:16:\"popularity_index\";i:284;s:11:\"trend_index\";i:385;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:819;a:15:{s:2:\"id\";i:6089;s:5:\"title\";s:7:\"Stats 4\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/numbers_white_5.png\";s:12:\"tmpl_created\";i:1520443653;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:104:\"https://library.elementor.com/blocks/stats-4/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"stats\";s:4:\"tags\";s:9:\"[\"Stats\"]\";s:10:\"menu_order\";i:338;s:16:\"popularity_index\";i:205;s:11:\"trend_index\";i:452;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:820;a:15:{s:2:\"id\";i:6063;s:5:\"title\";s:7:\"Stats 5\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/numbers_white_2.png\";s:12:\"tmpl_created\";i:1520443647;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:104:\"https://library.elementor.com/blocks/stats-5/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"stats\";s:4:\"tags\";s:11:\"[\"numbers\"]\";s:10:\"menu_order\";i:339;s:16:\"popularity_index\";i:181;s:11:\"trend_index\";i:419;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:821;a:15:{s:2:\"id\";i:6097;s:5:\"title\";s:7:\"Stats 6\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/numbers_black_2.png\";s:12:\"tmpl_created\";i:1520443655;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:104:\"https://library.elementor.com/blocks/stats-6/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"stats\";s:4:\"tags\";s:11:\"[\"numbers\"]\";s:10:\"menu_order\";i:340;s:16:\"popularity_index\";i:264;s:11:\"trend_index\";i:492;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:822;a:15:{s:2:\"id\";i:5956;s:5:\"title\";s:7:\"Stats 7\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/numbers_black_1.png\";s:12:\"tmpl_created\";i:1520443623;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:104:\"https://library.elementor.com/blocks/stats-7/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"stats\";s:4:\"tags\";s:9:\"[\"Stats\"]\";s:10:\"menu_order\";i:341;s:16:\"popularity_index\";i:532;s:11:\"trend_index\";i:541;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:823;a:15:{s:2:\"id\";i:5947;s:5:\"title\";s:7:\"Stats 8\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/numbers_white_1.png\";s:12:\"tmpl_created\";i:1520443621;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:104:\"https://library.elementor.com/blocks/stats-8/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"stats\";s:4:\"tags\";s:9:\"[\"Stats\"]\";s:10:\"menu_order\";i:342;s:16:\"popularity_index\";i:368;s:11:\"trend_index\";i:531;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:824;a:15:{s:2:\"id\";i:6152;s:5:\"title\";s:7:\"Stats 9\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2018/03/progress_black_1.png\";s:12:\"tmpl_created\";i:1520443666;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:104:\"https://library.elementor.com/blocks/stats-9/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"stats\";s:4:\"tags\";s:9:\"[\"Stats\"]\";s:10:\"menu_order\";i:343;s:16:\"popularity_index\";i:272;s:11:\"trend_index\";i:557;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:825;a:15:{s:2:\"id\";i:5157;s:5:\"title\";s:11:\"Subscribe 1\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2018/03/subscribe_white_1.png\";s:12:\"tmpl_created\";i:1520443448;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/subscribe-1/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:9:\"subscribe\";s:4:\"tags\";s:20:\"[\"form\",\"subscribe\"]\";s:10:\"menu_order\";i:344;s:16:\"popularity_index\";i:340;s:11:\"trend_index\";i:293;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:826;a:15:{s:2:\"id\";i:5181;s:5:\"title\";s:11:\"Subscribe 2\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2018/03/subscribe_black_2.png\";s:12:\"tmpl_created\";i:1520443454;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/blocks/subscribe-2-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:9:\"subscribe\";s:4:\"tags\";s:20:\"[\"form\",\"subscribe\"]\";s:10:\"menu_order\";i:345;s:16:\"popularity_index\";i:451;s:11:\"trend_index\";i:340;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:827;a:15:{s:2:\"id\";i:5165;s:5:\"title\";s:11:\"Subscribe 3\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2018/03/subscribe_black_1.png\";s:12:\"tmpl_created\";i:1520443450;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/subscribe-3/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:9:\"subscribe\";s:4:\"tags\";s:20:\"[\"form\",\"subscribe\"]\";s:10:\"menu_order\";i:346;s:16:\"popularity_index\";i:520;s:11:\"trend_index\";i:620;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:828;a:15:{s:2:\"id\";i:5222;s:5:\"title\";s:11:\"Subscribe 4\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2018/03/subscribe_black_3.png\";s:12:\"tmpl_created\";i:1520443464;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/subscribe-4/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:9:\"subscribe\";s:4:\"tags\";s:20:\"[\"form\",\"subscribe\"]\";s:10:\"menu_order\";i:347;s:16:\"popularity_index\";i:397;s:11:\"trend_index\";i:427;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:829;a:15:{s:2:\"id\";i:5173;s:5:\"title\";s:11:\"Subscribe 5\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2018/03/subscribe_white_2.png\";s:12:\"tmpl_created\";i:1520443452;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/subscribe-5/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:9:\"subscribe\";s:4:\"tags\";s:20:\"[\"form\",\"subscribe\"]\";s:10:\"menu_order\";i:348;s:16:\"popularity_index\";i:261;s:11:\"trend_index\";i:237;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:830;a:15:{s:2:\"id\";i:4801;s:5:\"title\";s:7:\"Team 11\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/team_black_8.png\";s:12:\"tmpl_created\";i:1520443369;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:104:\"https://library.elementor.com/blocks/team-11/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"team\";s:4:\"tags\";s:8:\"[\"team\"]\";s:10:\"menu_order\";i:349;s:16:\"popularity_index\";i:332;s:11:\"trend_index\";i:188;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:831;a:15:{s:2:\"id\";i:4770;s:5:\"title\";s:7:\"Team 12\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/team_white_6.png\";s:12:\"tmpl_created\";i:1520443364;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/team-12-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"team\";s:4:\"tags\";s:8:\"[\"team\"]\";s:10:\"menu_order\";i:350;s:16:\"popularity_index\";i:432;s:11:\"trend_index\";i:488;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:832;a:15:{s:2:\"id\";i:4727;s:5:\"title\";s:7:\"Team 13\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/team_black_2.png\";s:12:\"tmpl_created\";i:1520443356;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:104:\"https://library.elementor.com/blocks/team-13/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"team\";s:4:\"tags\";s:8:\"[\"team\"]\";s:10:\"menu_order\";i:351;s:16:\"popularity_index\";i:375;s:11:\"trend_index\";i:345;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:833;a:15:{s:2:\"id\";i:5999;s:5:\"title\";s:7:\"Team 14\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/team_black_10.png\";s:12:\"tmpl_created\";i:1520443634;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:104:\"https://library.elementor.com/blocks/team-14/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"team\";s:4:\"tags\";s:8:\"[\"team\"]\";s:10:\"menu_order\";i:352;s:16:\"popularity_index\";i:110;s:11:\"trend_index\";i:318;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:834;a:15:{s:2:\"id\";i:4698;s:5:\"title\";s:7:\"Team 15\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/team_black_1.png\";s:12:\"tmpl_created\";i:1520443350;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:104:\"https://library.elementor.com/blocks/team-15/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"team\";s:4:\"tags\";s:8:\"[\"team\"]\";s:10:\"menu_order\";i:353;s:16:\"popularity_index\";i:449;s:11:\"trend_index\";i:410;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:835;a:15:{s:2:\"id\";i:4781;s:5:\"title\";s:7:\"Team 16\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/team_white_7.png\";s:12:\"tmpl_created\";i:1520443365;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:104:\"https://library.elementor.com/blocks/team-16/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"team\";s:4:\"tags\";s:8:\"[\"team\"]\";s:10:\"menu_order\";i:354;s:16:\"popularity_index\";i:267;s:11:\"trend_index\";i:330;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:836;a:15:{s:2:\"id\";i:6144;s:5:\"title\";s:7:\"Team 17\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/team_white_11.png\";s:12:\"tmpl_created\";i:1520443664;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:104:\"https://library.elementor.com/blocks/team-17/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"team\";s:4:\"tags\";s:8:\"[\"team\"]\";s:10:\"menu_order\";i:355;s:16:\"popularity_index\";i:166;s:11:\"trend_index\";i:365;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:837;a:15:{s:2:\"id\";i:4793;s:5:\"title\";s:7:\"Team 18\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/team_white_8.png\";s:12:\"tmpl_created\";i:1520443367;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:104:\"https://library.elementor.com/blocks/team-18/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"team\";s:4:\"tags\";s:8:\"[\"team\"]\";s:10:\"menu_order\";i:356;s:16:\"popularity_index\";i:207;s:11:\"trend_index\";i:173;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:838;a:15:{s:2:\"id\";i:4809;s:5:\"title\";s:7:\"Team 19\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/team_white_9.png\";s:12:\"tmpl_created\";i:1520443371;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:104:\"https://library.elementor.com/blocks/team-19/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"team\";s:4:\"tags\";s:8:\"[\"team\"]\";s:10:\"menu_order\";i:357;s:16:\"popularity_index\";i:300;s:11:\"trend_index\";i:465;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:839;a:15:{s:2:\"id\";i:4736;s:5:\"title\";s:7:\"Team 20\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/team_white_4.png\";s:12:\"tmpl_created\";i:1520443358;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:104:\"https://library.elementor.com/blocks/team-20/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"team\";s:4:\"tags\";s:8:\"[\"team\"]\";s:10:\"menu_order\";i:358;s:16:\"popularity_index\";i:144;s:11:\"trend_index\";i:159;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:840;a:15:{s:2:\"id\";i:4818;s:5:\"title\";s:7:\"Team 21\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/team_black_9.png\";s:12:\"tmpl_created\";i:1520443373;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:104:\"https://library.elementor.com/blocks/team-21/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"team\";s:4:\"tags\";s:8:\"[\"team\"]\";s:10:\"menu_order\";i:359;s:16:\"popularity_index\";i:515;s:11:\"trend_index\";i:606;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:841;a:15:{s:2:\"id\";i:4759;s:5:\"title\";s:7:\"Team 22\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/team_white_5.png\";s:12:\"tmpl_created\";i:1520443362;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:104:\"https://library.elementor.com/blocks/team-22/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"team\";s:4:\"tags\";s:8:\"[\"team\"]\";s:10:\"menu_order\";i:360;s:16:\"popularity_index\";i:299;s:11:\"trend_index\";i:376;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:842;a:15:{s:2:\"id\";i:4746;s:5:\"title\";s:7:\"Team 23\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/team_black_4.png\";s:12:\"tmpl_created\";i:1520443360;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:104:\"https://library.elementor.com/blocks/team-23/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"team\";s:4:\"tags\";s:8:\"[\"team\"]\";s:10:\"menu_order\";i:361;s:16:\"popularity_index\";i:282;s:11:\"trend_index\";i:378;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:843;a:15:{s:2:\"id\";i:4718;s:5:\"title\";s:6:\"Team 4\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/team_white_3.png\";s:12:\"tmpl_created\";i:1520443354;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/blocks/team-4/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"team\";s:4:\"tags\";s:8:\"[\"team\"]\";s:10:\"menu_order\";i:362;s:16:\"popularity_index\";i:192;s:11:\"trend_index\";i:359;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:844;a:15:{s:2:\"id\";i:4706;s:5:\"title\";s:6:\"Team 5\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/team_white_2.png\";s:12:\"tmpl_created\";i:1520443352;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/blocks/team-5/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"team\";s:4:\"tags\";s:8:\"[\"team\"]\";s:10:\"menu_order\";i:363;s:16:\"popularity_index\";i:149;s:11:\"trend_index\";i:299;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:845;a:15:{s:2:\"id\";i:6008;s:5:\"title\";s:6:\"Team 6\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/team_white_10.png\";s:12:\"tmpl_created\";i:1520443636;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/blocks/team-6/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"team\";s:4:\"tags\";s:8:\"[\"team\"]\";s:10:\"menu_order\";i:364;s:16:\"popularity_index\";i:75;s:11:\"trend_index\";i:277;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:846;a:15:{s:2:\"id\";i:4690;s:5:\"title\";s:6:\"Team 7\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/team_white_1.png\";s:12:\"tmpl_created\";i:1520443348;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/blocks/team-7/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"team\";s:4:\"tags\";s:8:\"[\"team\"]\";s:10:\"menu_order\";i:365;s:16:\"popularity_index\";i:243;s:11:\"trend_index\";i:402;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:847;a:15:{s:2:\"id\";i:4921;s:5:\"title\";s:14:\"Testimonial 10\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2018/03/testimonials_black_5.png\";s:12:\"tmpl_created\";i:1520520562;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/blocks/testimonial-10/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:12:\"testimonials\";s:4:\"tags\";s:15:\"[\"Testimonial\"]\";s:10:\"menu_order\";i:366;s:16:\"popularity_index\";i:219;s:11:\"trend_index\";i:198;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:848;a:15:{s:2:\"id\";i:4889;s:5:\"title\";s:14:\"Testimonial 11\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/customers-2.jpg\";s:12:\"tmpl_created\";i:1520520556;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/blocks/testimonial-11/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:12:\"testimonials\";s:4:\"tags\";s:15:\"[\"Testimonial\"]\";s:10:\"menu_order\";i:367;s:16:\"popularity_index\";i:557;s:11:\"trend_index\";i:522;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:849;a:15:{s:2:\"id\";i:4871;s:5:\"title\";s:14:\"Testimonial 12\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2018/03/testimonials_black_3.png\";s:12:\"tmpl_created\";i:1520520552;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/blocks/testimonial-12/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:12:\"testimonials\";s:4:\"tags\";s:15:\"[\"Testimonial\"]\";s:10:\"menu_order\";i:368;s:16:\"popularity_index\";i:262;s:11:\"trend_index\";i:391;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:850;a:15:{s:2:\"id\";i:4854;s:5:\"title\";s:14:\"Testimonial 13\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2018/03/testimonials_black_2.png\";s:12:\"tmpl_created\";i:1520520549;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/blocks/testimonial-13/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:12:\"testimonials\";s:4:\"tags\";s:15:\"[\"Testimonial\"]\";s:10:\"menu_order\";i:369;s:16:\"popularity_index\";i:637;s:11:\"trend_index\";i:741;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:851;a:15:{s:2:\"id\";i:4995;s:5:\"title\";s:14:\"Testimonial 14\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2018/03/testimonials_black_12.png\";s:12:\"tmpl_created\";i:1520520577;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/blocks/testimonial-14/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:12:\"testimonials\";s:4:\"tags\";s:15:\"[\"Testimonial\"]\";s:10:\"menu_order\";i:370;s:16:\"popularity_index\";i:400;s:11:\"trend_index\";i:411;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:852;a:15:{s:2:\"id\";i:4979;s:5:\"title\";s:14:\"Testimonial 15\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2018/03/testimonials_black_10.png\";s:12:\"tmpl_created\";i:1520520573;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/blocks/testimonial-15/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:12:\"testimonials\";s:4:\"tags\";s:15:\"[\"Testimonial\"]\";s:10:\"menu_order\";i:371;s:16:\"popularity_index\";i:568;s:11:\"trend_index\";i:544;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:853;a:15:{s:2:\"id\";i:4835;s:5:\"title\";s:14:\"Testimonial 16\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2018/03/testimonials_black_1.png\";s:12:\"tmpl_created\";i:1520520546;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/blocks/testimonial-16/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:12:\"testimonials\";s:4:\"tags\";s:15:\"[\"Testimonial\"]\";s:10:\"menu_order\";i:372;s:16:\"popularity_index\";i:399;s:11:\"trend_index\";i:401;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:854;a:15:{s:2:\"id\";i:4987;s:5:\"title\";s:14:\"Testimonial 17\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2018/03/testimonials_white_12-1.png\";s:12:\"tmpl_created\";i:1520520575;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/blocks/testimonial-17/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:12:\"testimonials\";s:4:\"tags\";s:15:\"[\"Testimonial\"]\";s:10:\"menu_order\";i:373;s:16:\"popularity_index\";i:159;s:11:\"trend_index\";i:199;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:855;a:15:{s:2:\"id\";i:4843;s:5:\"title\";s:14:\"Testimonial 18\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2018/03/testimonials_white_2.png\";s:12:\"tmpl_created\";i:1520520548;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/blocks/testimonial-18/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:12:\"testimonials\";s:4:\"tags\";s:15:\"[\"Testimonial\"]\";s:10:\"menu_order\";i:374;s:16:\"popularity_index\";i:457;s:11:\"trend_index\";i:780;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:856;a:15:{s:2:\"id\";i:4863;s:5:\"title\";s:14:\"Testimonial 19\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2018/03/testimonials_white_3.png\";s:12:\"tmpl_created\";i:1520520551;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/blocks/testimonial-19/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:12:\"testimonials\";s:4:\"tags\";s:15:\"[\"Testimonial\"]\";s:10:\"menu_order\";i:375;s:16:\"popularity_index\";i:245;s:11:\"trend_index\";i:599;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:857;a:15:{s:2:\"id\";i:4880;s:5:\"title\";s:14:\"Testimonial 20\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/customers-1.jpg\";s:12:\"tmpl_created\";i:1520520554;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/blocks/testimonial-20/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:12:\"testimonials\";s:4:\"tags\";s:15:\"[\"Testimonial\"]\";s:10:\"menu_order\";i:376;s:16:\"popularity_index\";i:446;s:11:\"trend_index\";i:653;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:858;a:15:{s:2:\"id\";i:4897;s:5:\"title\";s:14:\"Testimonial 21\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2018/03/testimonials_white_5.png\";s:12:\"tmpl_created\";i:1520520557;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/blocks/testimonial-21/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:12:\"testimonials\";s:4:\"tags\";s:15:\"[\"Testimonial\"]\";s:10:\"menu_order\";i:377;s:16:\"popularity_index\";i:78;s:11:\"trend_index\";i:289;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:859;a:15:{s:2:\"id\";i:4905;s:5:\"title\";s:14:\"Testimonial 22\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2018/03/testimonials_white_6.png\";s:12:\"tmpl_created\";i:1520520559;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/blocks/testimonial-22/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:12:\"testimonials\";s:4:\"tags\";s:15:\"[\"Testimonial\"]\";s:10:\"menu_order\";i:378;s:16:\"popularity_index\";i:121;s:11:\"trend_index\";i:221;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:860;a:15:{s:2:\"id\";i:4913;s:5:\"title\";s:14:\"Testimonial 23\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2018/03/testimonials_white_7.png\";s:12:\"tmpl_created\";i:1520520561;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/blocks/testimonial-23/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:12:\"testimonials\";s:4:\"tags\";s:15:\"[\"Testimonial\"]\";s:10:\"menu_order\";i:379;s:16:\"popularity_index\";i:247;s:11:\"trend_index\";i:566;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:861;a:15:{s:2:\"id\";i:4826;s:5:\"title\";s:14:\"Testimonial 24\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2018/03/testimonials_white_1.png\";s:12:\"tmpl_created\";i:1520520544;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:113:\"https://library.elementor.com/blocks/testimonial-24-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:12:\"testimonials\";s:4:\"tags\";s:15:\"[\"Testimonial\"]\";s:10:\"menu_order\";i:380;s:16:\"popularity_index\";i:256;s:11:\"trend_index\";i:395;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:862;a:15:{s:2:\"id\";i:4929;s:5:\"title\";s:14:\"Testimonial 24\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2018/03/testimonials_white_8.png\";s:12:\"tmpl_created\";i:1520520564;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/blocks/testimonial-24/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:12:\"testimonials\";s:4:\"tags\";s:15:\"[\"Testimonial\"]\";s:10:\"menu_order\";i:381;s:16:\"popularity_index\";i:49;s:11:\"trend_index\";i:206;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:863;a:15:{s:2:\"id\";i:4963;s:5:\"title\";s:14:\"Testimonial 25\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2018/03/testimonials_white_10.png\";s:12:\"tmpl_created\";i:1520520570;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:113:\"https://library.elementor.com/blocks/testimonial-25-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:12:\"testimonials\";s:4:\"tags\";s:15:\"[\"Testimonial\"]\";s:10:\"menu_order\";i:382;s:16:\"popularity_index\";i:417;s:11:\"trend_index\";i:546;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:864;a:15:{s:2:\"id\";i:4971;s:5:\"title\";s:14:\"Testimonial 26\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2018/03/testimonials_white_11.png\";s:12:\"tmpl_created\";i:1520520572;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/blocks/testimonial-26/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:12:\"testimonials\";s:4:\"tags\";s:15:\"[\"Testimonial\"]\";s:10:\"menu_order\";i:383;s:16:\"popularity_index\";i:649;s:11:\"trend_index\";i:718;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:865;a:15:{s:2:\"id\";i:4947;s:5:\"title\";s:14:\"Testimonial 27\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2018/03/testimonials_white_9.png\";s:12:\"tmpl_created\";i:1520520567;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/blocks/testimonial-27/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:12:\"testimonials\";s:4:\"tags\";s:15:\"[\"Testimonial\"]\";s:10:\"menu_order\";i:384;s:16:\"popularity_index\";i:221;s:11:\"trend_index\";i:496;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:866;a:15:{s:2:\"id\";i:4955;s:5:\"title\";s:14:\"Testimonial 29\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2018/03/testimonials_black_9.png\";s:12:\"tmpl_created\";i:1520520569;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/blocks/testimonial-29/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:12:\"testimonials\";s:4:\"tags\";s:15:\"[\"Testimonial\"]\";s:10:\"menu_order\";i:385;s:16:\"popularity_index\";i:378;s:11:\"trend_index\";i:695;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:867;a:15:{s:2:\"id\";i:4939;s:5:\"title\";s:13:\"Testimonial 9\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2018/03/testimonials_black_8.png\";s:12:\"tmpl_created\";i:1520520565;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/blocks/testimonial-9/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:12:\"testimonials\";s:4:\"tags\";s:15:\"[\"Testimonial\"]\";s:10:\"menu_order\";i:386;s:16:\"popularity_index\";i:103;s:11:\"trend_index\";i:341;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:868;a:15:{s:2:\"id\";i:12509;s:5:\"title\";s:18:\"Travel &#8211; 404\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2019/12/404.png\";s:12:\"tmpl_created\";i:1575960378;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/blocks/travel-404/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:24:\"[\"404\",\"Tours\",\"Travel\"]\";s:10:\"menu_order\";i:387;s:16:\"popularity_index\";i:747;s:11:\"trend_index\";i:712;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:869;a:15:{s:2:\"id\";i:12516;s:5:\"title\";s:27:\"Travel &#8211; Archive Blog\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2019/12/Archiv_s.png\";s:12:\"tmpl_created\";i:1575960387;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/blocks/travel-archive-blog/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"archive\";s:4:\"tags\";s:18:\"[\"Tours\",\"Travel\"]\";s:10:\"menu_order\";i:388;s:16:\"popularity_index\";i:496;s:11:\"trend_index\";i:487;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:870;a:15:{s:2:\"id\";i:12500;s:5:\"title\";s:21:\"Travel &#8211; Header\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2020/06/Header-travel-and-tours.png\";s:12:\"tmpl_created\";i:1575960371;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/blocks/travel-header/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:27:\"[\"header\",\"Tours\",\"Travel\"]\";s:10:\"menu_order\";i:389;s:16:\"popularity_index\";i:443;s:11:\"trend_index\";i:434;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:871;a:15:{s:2:\"id\";i:12524;s:5:\"title\";s:26:\"Travel &#8211; Single Post\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2019/12/Single_Post_s.png\";s:12:\"tmpl_created\";i:1575960397;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/blocks/travel-single-post/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:18:\"[\"Tours\",\"Travel\"]\";s:10:\"menu_order\";i:390;s:16:\"popularity_index\";i:591;s:11:\"trend_index\";i:663;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:872;a:15:{s:2:\"id\";i:12531;s:5:\"title\";s:31:\"Travel &#8211; Single Post Tour\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2019/12/Single_Tour_s.png\";s:12:\"tmpl_created\";i:1575960404;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.elementor.com/blocks/travel-single-post-tour/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:18:\"[\"Tours\",\"Travel\"]\";s:10:\"menu_order\";i:391;s:16:\"popularity_index\";i:630;s:11:\"trend_index\";i:548;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:873;a:15:{s:2:\"id\";i:12492;s:5:\"title\";s:14:\"Travel -Footer\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2019/12/Footer_s.png\";s:12:\"tmpl_created\";i:1575960358;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/blocks/travel-footer/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:27:\"[\"footer\",\"Tours\",\"Travel\"]\";s:10:\"menu_order\";i:392;s:16:\"popularity_index\";i:453;s:11:\"trend_index\";i:322;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:874;a:15:{s:2:\"id\";i:15498;s:5:\"title\";s:23:\"Travel Blog &#8211; 404\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2020/11/404.jpg\";s:12:\"tmpl_created\";i:1606215636;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/blocks/travel-blog-404/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:23:\"[\"404\",\"Blog\",\"Travel\"]\";s:10:\"menu_order\";i:393;s:16:\"popularity_index\";i:749;s:11:\"trend_index\";i:759;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:875;a:15:{s:2:\"id\";i:15508;s:5:\"title\";s:29:\"Travel Blog &#8211; Archive 1\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2020/11/Archive-1-350.jpg\";s:12:\"tmpl_created\";i:1606215649;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/blocks/travel-blog-archive-1/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"archive\";s:4:\"tags\";s:17:\"[\"Blog\",\"Travel\"]\";s:10:\"menu_order\";i:394;s:16:\"popularity_index\";i:659;s:11:\"trend_index\";i:468;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:876;a:15:{s:2:\"id\";i:15518;s:5:\"title\";s:29:\"Travel Blog &#8211; Archive 2\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2020/11/Archive-2-350-Copy.jpg\";s:12:\"tmpl_created\";i:1606215663;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/blocks/travel-blog-archive-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"archive\";s:4:\"tags\";s:17:\"[\"Blog\",\"Travel\"]\";s:10:\"menu_order\";i:395;s:16:\"popularity_index\";i:688;s:11:\"trend_index\";i:431;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:877;a:15:{s:2:\"id\";i:15528;s:5:\"title\";s:26:\"Travel Blog &#8211; Footer\";s:9:\"thumbnail\";s:67:\"https://library.elementor.com/wp-content/uploads/2020/11/Footer.jpg\";s:12:\"tmpl_created\";i:1606215673;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/blocks/travel-blog-footer/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:26:\"[\"Blog\",\"Footer\",\"Travel\"]\";s:10:\"menu_order\";i:396;s:16:\"popularity_index\";i:656;s:11:\"trend_index\";i:377;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:878;a:15:{s:2:\"id\";i:15536;s:5:\"title\";s:26:\"Travel Blog &#8211; Header\";s:9:\"thumbnail\";s:67:\"https://library.elementor.com/wp-content/uploads/2020/11/Header.jpg\";s:12:\"tmpl_created\";i:1606215625;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/blocks/travel-blog-header/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:26:\"[\"Blog\",\"Header\",\"Travel\"]\";s:10:\"menu_order\";i:397;s:16:\"popularity_index\";i:584;s:11:\"trend_index\";i:228;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:879;a:15:{s:2:\"id\";i:15545;s:5:\"title\";s:33:\"Travel Blog &#8211; Single Post 1\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2020/11/Single-1-350.jpg\";s:12:\"tmpl_created\";i:1606215684;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/blocks/travel-blog-single-post-1/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:17:\"[\"Blog\",\"Travel\"]\";s:10:\"menu_order\";i:398;s:16:\"popularity_index\";i:669;s:11:\"trend_index\";i:482;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:880;a:15:{s:2:\"id\";i:15556;s:5:\"title\";s:33:\"Travel Blog &#8211; Single Post 2\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2020/11/Single-2-350.jpg\";s:12:\"tmpl_created\";i:1606215613;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/blocks/travel-blog-single-post-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:17:\"[\"Blog\",\"Travel\"]\";s:10:\"menu_order\";i:399;s:16:\"popularity_index\";i:652;s:11:\"trend_index\";i:454;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}}}", "no");
INSERT INTO `psm_options` VALUES("517", "elementor_remote_info_feed_data", "a:5:{i:0;a:5:{s:5:\"title\";s:55:\"What Is Material Design? Definition, Uses, and Examples\";s:7:\"excerpt\";s:147:\"Material Design is the standard for designing and creating websites and apps. Discover why and learn how to use it to make a user-friendly website.\";s:7:\"created\";i:1612263675;s:5:\"badge\";s:0:\"\";s:3:\"url\";s:123:\"https://elementor.com/blog/what-is-material-design/?utm_source=wp-overview-widget&utm_medium=wp-dash&utm_campaign=news-feed\";}i:1;a:5:{s:5:\"title\";s:53:\"Elementor SEO: How To Optimize Your Elementor Website\";s:7:\"excerpt\";s:154:\"SEO is crucial to the success of any website, but to many users, it still remains a mystery. Discover what SEO is and how to use it to optimize your site.\";s:7:\"created\";i:1611838485;s:5:\"badge\";s:0:\"\";s:3:\"url\";s:113:\"https://elementor.com/blog/elementor-seo/?utm_source=wp-overview-widget&utm_medium=wp-dash&utm_campaign=news-feed\";}i:2;a:5:{s:5:\"title\";s:97:\"Introducing Elementor 3.1: Experiments, Performance Enhancements, And a New Landing Page Workflow\";s:7:\"excerpt\";s:162:\"The new Elementor version 3.1 features performance improvements, a new Landing Page area and workflow to manage your marketing pages, and exploratory experiments.\";s:7:\"created\";i:1611665700;s:5:\"badge\";s:11:\"New Feature\";s:3:\"url\";s:125:\"https://elementor.com/blog/introducing-elementor-3-1/?utm_source=wp-overview-widget&utm_medium=wp-dash&utm_campaign=news-feed\";}i:3;a:5:{s:5:\"title\";s:33:\"How To Redirect URLs in WordPress\";s:7:\"excerpt\";s:152:\"Redirecting visitors from one page to another is an important part of website maintenance. Explore all the reasons for redirects and how to create them.\";s:7:\"created\";i:1611143960;s:5:\"badge\";s:0:\"\";s:3:\"url\";s:122:\"https://elementor.com/blog/redirect-url-wordpress/?utm_source=wp-overview-widget&utm_medium=wp-dash&utm_campaign=news-feed\";}i:4;a:5:{s:5:\"title\";s:33:\"How to Create the Perfect Favicon\";s:7:\"excerpt\";s:140:\"Favicons are an integral part of building up your brand and a recognizable website. Understand what they are, and how to use them correctly.\";s:7:\"created\";i:1610975844;s:5:\"badge\";s:0:\"\";s:3:\"url\";s:122:\"https://elementor.com/blog/favicon-complete-guide/?utm_source=wp-overview-widget&utm_medium=wp-dash&utm_campaign=news-feed\";}}", "no");
INSERT INTO `psm_options` VALUES("720", "_transient_health-check-site-status-result", "{\"good\":13,\"recommended\":5,\"critical\":1}", "yes");
INSERT INTO `psm_options` VALUES("758", "woocommerce_tracker_last_send", "1633019317", "yes");
INSERT INTO `psm_options` VALUES("768", "woocommerce_tracker_ua", "a:9:{i:0;s:119:\"Mozilla/5.0 (Macintosh; Intel Mac OS X 11_1_0) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/89.0.4389.82 Safari/537.36\";i:1;s:119:\"Mozilla/5.0 (Macintosh; Intel Mac OS X 11_1_0) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/89.0.4389.90 Safari/537.36\";i:2;s:120:\"Mozilla/5.0 (Macintosh; Intel Mac OS X 11_1_0) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/89.0.4389.128 Safari/537.36\";i:3;s:120:\"Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.93 Safari/537.36\";i:4;s:121:\"Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.114 Safari/537.36\";i:5;s:121:\"Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.164 Safari/537.36\";i:6;s:121:\"Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/92.0.4515.131 Safari/537.36\";i:7;s:121:\"Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/92.0.4515.159 Safari/537.36\";i:8;s:120:\"Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/93.0.4577.82 Safari/537.36\";}", "yes");
INSERT INTO `psm_options` VALUES("783", "auto_core_update_notified", "a:4:{s:4:\"type\";s:7:\"success\";s:5:\"email\";s:35:\"pierriesaintmaximechateau@gmail.com\";s:7:\"version\";s:5:\"5.8.1\";s:9:\"timestamp\";i:1632238677;}", "no");
INSERT INTO `psm_options` VALUES("788", "https_detection_errors", "a:1:{s:20:\"https_request_failed\";a:1:{i:0;s:28:\"La demande HTTPS a échoué.\";}}", "yes");
INSERT INTO `psm_options` VALUES("833", "_transient_product_query-transient-version", "1633355226", "yes");
INSERT INTO `psm_options` VALUES("869", "theme_mods_twentynineteen", "a:4:{i:0;b:0;s:18:\"nav_menu_locations\";a:1:{s:6:\"menu-1\";i:16;}s:18:\"custom_css_post_id\";i:-1;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1619516635;s:4:\"data\";a:2:{s:19:\"wp_inactive_widgets\";a:1:{i:0;s:14:\"recent-posts-3\";}s:9:\"sidebar-1\";a:6:{i:0;s:8:\"search-2\";i:1;s:14:\"recent-posts-2\";i:2;s:17:\"recent-comments-2\";i:3;s:10:\"archives-2\";i:4;s:12:\"categories-2\";i:5;s:6:\"meta-2\";}}}}", "yes");
INSERT INTO `psm_options` VALUES("882", "acf_version", "5.10.2", "yes");
INSERT INTO `psm_options` VALUES("884", "widget_akismet_widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `psm_options` VALUES("885", "autoptimize_version", "2.9.2", "yes");
INSERT INTO `psm_options` VALUES("886", "autoptimize_service_availablity", "a:2:{s:12:\"extra_imgopt\";a:3:{s:6:\"status\";s:2:\"up\";s:5:\"hosts\";a:1:{i:1;s:28:\"https://sp-ao.shortpixel.ai/\";}s:16:\"launch-threshold\";s:4:\"4096\";}s:7:\"critcss\";a:2:{s:6:\"status\";s:2:\"up\";s:5:\"hosts\";a:1:{i:1;s:24:\"https://criticalcss.com/\";}}}", "yes");
INSERT INTO `psm_options` VALUES("887", "autoptimize_ccss_version", "AO_2.9.2", "yes");
INSERT INTO `psm_options` VALUES("889", "autoptimize_imgopt_launched", "on", "yes");
INSERT INTO `psm_options` VALUES("892", "polylang", "a:14:{s:7:\"browser\";i:1;s:7:\"rewrite\";i:1;s:12:\"hide_default\";i:1;s:10:\"force_lang\";i:1;s:13:\"redirect_lang\";i:0;s:13:\"media_support\";i:1;s:9:\"uninstall\";i:0;s:4:\"sync\";a:0:{}s:10:\"post_types\";a:0:{}s:10:\"taxonomies\";a:0:{}s:7:\"domains\";a:0:{}s:7:\"version\";s:5:\"3.0.3\";s:16:\"first_activation\";i:1616707571;s:16:\"previous_version\";s:5:\"2.9.2\";}", "yes");
INSERT INTO `psm_options` VALUES("893", "polylang_wpml_strings", "a:0:{}", "yes");
INSERT INTO `psm_options` VALUES("894", "widget_polylang", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `psm_options` VALUES("895", "wpseo", "a:42:{s:8:\"tracking\";b:0;s:22:\"license_server_version\";b:0;s:15:\"ms_defaults_set\";b:0;s:40:\"ignore_search_engines_discouraged_notice\";b:0;s:19:\"indexing_first_time\";b:1;s:16:\"indexing_started\";b:0;s:15:\"indexing_reason\";s:26:\"permalink_settings_changed\";s:29:\"indexables_indexing_completed\";b:1;s:7:\"version\";s:6:\"16.0.2\";s:16:\"previous_version\";s:6:\"15.9.1\";s:20:\"disableadvanced_meta\";b:1;s:30:\"enable_headless_rest_endpoints\";b:1;s:17:\"ryte_indexability\";b:1;s:11:\"baiduverify\";s:0:\"\";s:12:\"googleverify\";s:0:\"\";s:8:\"msverify\";s:0:\"\";s:12:\"yandexverify\";s:0:\"\";s:9:\"site_type\";s:0:\"\";s:20:\"has_multiple_authors\";s:0:\"\";s:16:\"environment_type\";s:0:\"\";s:23:\"content_analysis_active\";b:1;s:23:\"keyword_analysis_active\";b:1;s:21:\"enable_admin_bar_menu\";b:1;s:26:\"enable_cornerstone_content\";b:1;s:18:\"enable_xml_sitemap\";b:1;s:24:\"enable_text_link_counter\";b:1;s:22:\"show_onboarding_notice\";b:1;s:18:\"first_activated_on\";i:1616707576;s:13:\"myyoast-oauth\";b:0;s:26:\"semrush_integration_active\";b:1;s:14:\"semrush_tokens\";a:0:{}s:20:\"semrush_country_code\";s:2:\"us\";s:19:\"permalink_structure\";s:12:\"/%postname%/\";s:8:\"home_url\";s:25:\"http://localhost:8888/psm\";s:18:\"dynamic_permalinks\";b:0;s:17:\"category_base_url\";s:0:\"\";s:12:\"tag_base_url\";s:0:\"\";s:21:\"custom_taxonomy_slugs\";a:14:{s:8:\"language\";s:8:\"language\";s:17:\"post_translations\";s:17:\"post_translations\";s:13:\"term_language\";s:13:\"term_language\";s:17:\"term_translations\";s:17:\"term_translations\";s:22:\"elementor_library_type\";s:22:\"elementor_library_type\";s:26:\"elementor_library_category\";s:26:\"elementor_library_category\";s:12:\"product_type\";s:12:\"product_type\";s:18:\"product_visibility\";s:18:\"product_visibility\";s:11:\"product_cat\";s:17:\"categorie-produit\";s:11:\"product_tag\";s:17:\"etiquette-produit\";s:22:\"product_shipping_class\";s:22:\"product_shipping_class\";s:8:\"pa_color\";s:8:\"pa_color\";s:14:\"fb_product_set\";s:14:\"fb_product_set\";s:19:\"elementor_font_type\";s:19:\"elementor_font_type\";}s:29:\"enable_enhanced_slack_sharing\";b:1;s:25:\"zapier_integration_active\";b:0;s:19:\"zapier_subscription\";a:0:{}s:14:\"zapier_api_key\";s:0:\"\";}", "yes");
INSERT INTO `psm_options` VALUES("896", "yoast_migrations_free", "a:1:{s:7:\"version\";s:6:\"16.0.2\";}", "yes");
INSERT INTO `psm_options` VALUES("899", "wpseo_titles", "a:125:{s:17:\"forcerewritetitle\";b:0;s:9:\"separator\";s:7:\"sc-dash\";s:16:\"title-home-wpseo\";s:42:\"%%sitename%% %%page%% %%sep%% %%sitedesc%%\";s:18:\"title-author-wpseo\";s:50:\"%%name%%, auteur/autrice sur %%sitename%% %%page%%\";s:19:\"title-archive-wpseo\";s:38:\"%%date%% %%page%% %%sep%% %%sitename%%\";s:18:\"title-search-wpseo\";s:65:\"Vous avez cherché %%searchphrase%% %%page%% %%sep%% %%sitename%%\";s:15:\"title-404-wpseo\";s:38:\"Page non trouvée %%sep%% %%sitename%%\";s:19:\"metadesc-home-wpseo\";s:0:\"\";s:21:\"metadesc-author-wpseo\";s:0:\"\";s:22:\"metadesc-archive-wpseo\";s:0:\"\";s:9:\"rssbefore\";s:0:\"\";s:8:\"rssafter\";s:64:\"L’article %%POSTLINK%% est apparu en premier sur %%BLOGLINK%%.\";s:20:\"noindex-author-wpseo\";b:0;s:28:\"noindex-author-noposts-wpseo\";b:1;s:21:\"noindex-archive-wpseo\";b:1;s:14:\"disable-author\";b:0;s:12:\"disable-date\";b:0;s:19:\"disable-post_format\";b:0;s:18:\"disable-attachment\";b:1;s:23:\"is-media-purge-relevant\";b:0;s:20:\"breadcrumbs-404crumb\";s:30:\"Erreur 404 : Page introuvable\";s:29:\"breadcrumbs-display-blog-page\";b:0;s:20:\"breadcrumbs-boldlast\";b:0;s:25:\"breadcrumbs-archiveprefix\";s:13:\"Archives pour\";s:18:\"breadcrumbs-enable\";b:1;s:16:\"breadcrumbs-home\";s:7:\"Accueil\";s:18:\"breadcrumbs-prefix\";s:0:\"\";s:24:\"breadcrumbs-searchprefix\";s:18:\"Vous avez cherché\";s:15:\"breadcrumbs-sep\";s:7:\"&raquo;\";s:12:\"website_name\";s:0:\"\";s:11:\"person_name\";s:0:\"\";s:11:\"person_logo\";s:0:\"\";s:14:\"person_logo_id\";i:0;s:22:\"alternate_website_name\";s:0:\"\";s:12:\"company_logo\";s:0:\"\";s:15:\"company_logo_id\";i:0;s:12:\"company_name\";s:0:\"\";s:17:\"company_or_person\";s:7:\"company\";s:25:\"company_or_person_user_id\";b:0;s:17:\"stripcategorybase\";b:0;s:10:\"title-post\";s:39:\"%%title%% %%page%% %%sep%% %%sitename%%\";s:13:\"metadesc-post\";s:0:\"\";s:12:\"noindex-post\";b:0;s:23:\"display-metabox-pt-post\";b:1;s:23:\"post_types-post-maintax\";i:0;s:21:\"schema-page-type-post\";s:7:\"WebPage\";s:24:\"schema-article-type-post\";s:7:\"Article\";s:10:\"title-page\";s:39:\"%%title%% %%page%% %%sep%% %%sitename%%\";s:13:\"metadesc-page\";s:0:\"\";s:12:\"noindex-page\";b:0;s:23:\"display-metabox-pt-page\";b:1;s:23:\"post_types-page-maintax\";i:0;s:21:\"schema-page-type-page\";s:7:\"WebPage\";s:24:\"schema-article-type-page\";s:4:\"None\";s:16:\"title-attachment\";s:39:\"%%title%% %%page%% %%sep%% %%sitename%%\";s:19:\"metadesc-attachment\";s:0:\"\";s:18:\"noindex-attachment\";b:0;s:29:\"display-metabox-pt-attachment\";b:1;s:29:\"post_types-attachment-maintax\";i:0;s:27:\"schema-page-type-attachment\";s:7:\"WebPage\";s:30:\"schema-article-type-attachment\";s:4:\"None\";s:18:\"title-tax-category\";s:57:\"Archives des %%term_title%% %%page%% %%sep%% %%sitename%%\";s:21:\"metadesc-tax-category\";s:0:\"\";s:28:\"display-metabox-tax-category\";b:1;s:20:\"noindex-tax-category\";b:0;s:18:\"title-tax-post_tag\";s:57:\"Archives des %%term_title%% %%page%% %%sep%% %%sitename%%\";s:21:\"metadesc-tax-post_tag\";s:0:\"\";s:28:\"display-metabox-tax-post_tag\";b:1;s:20:\"noindex-tax-post_tag\";b:0;s:21:\"title-tax-post_format\";s:57:\"Archives des %%term_title%% %%page%% %%sep%% %%sitename%%\";s:24:\"metadesc-tax-post_format\";s:0:\"\";s:31:\"display-metabox-tax-post_format\";b:1;s:23:\"noindex-tax-post_format\";b:1;s:20:\"title-e-landing-page\";s:39:\"%%title%% %%page%% %%sep%% %%sitename%%\";s:23:\"metadesc-e-landing-page\";s:0:\"\";s:22:\"noindex-e-landing-page\";b:0;s:33:\"display-metabox-pt-e-landing-page\";b:1;s:33:\"post_types-e-landing-page-maintax\";i:0;s:31:\"schema-page-type-e-landing-page\";s:7:\"WebPage\";s:34:\"schema-article-type-e-landing-page\";s:4:\"None\";s:23:\"title-elementor_library\";s:39:\"%%title%% %%page%% %%sep%% %%sitename%%\";s:26:\"metadesc-elementor_library\";s:0:\"\";s:25:\"noindex-elementor_library\";b:0;s:36:\"display-metabox-pt-elementor_library\";b:1;s:36:\"post_types-elementor_library-maintax\";i:0;s:34:\"schema-page-type-elementor_library\";s:7:\"WebPage\";s:37:\"schema-article-type-elementor_library\";s:4:\"None\";s:13:\"title-product\";s:39:\"%%title%% %%page%% %%sep%% %%sitename%%\";s:16:\"metadesc-product\";s:0:\"\";s:15:\"noindex-product\";b:0;s:26:\"display-metabox-pt-product\";b:1;s:26:\"post_types-product-maintax\";i:0;s:24:\"schema-page-type-product\";s:7:\"WebPage\";s:27:\"schema-article-type-product\";s:4:\"None\";s:23:\"title-ptarchive-product\";s:51:\"%%pt_plural%% Archive %%page%% %%sep%% %%sitename%%\";s:26:\"metadesc-ptarchive-product\";s:0:\"\";s:25:\"bctitle-ptarchive-product\";s:0:\"\";s:25:\"noindex-ptarchive-product\";b:0;s:21:\"title-tax-product_cat\";s:57:\"Archives des %%term_title%% %%page%% %%sep%% %%sitename%%\";s:24:\"metadesc-tax-product_cat\";s:0:\"\";s:31:\"display-metabox-tax-product_cat\";b:1;s:23:\"noindex-tax-product_cat\";b:0;s:29:\"taxonomy-product_cat-ptparent\";i:0;s:21:\"title-tax-product_tag\";s:57:\"Archives des %%term_title%% %%page%% %%sep%% %%sitename%%\";s:24:\"metadesc-tax-product_tag\";s:0:\"\";s:31:\"display-metabox-tax-product_tag\";b:1;s:23:\"noindex-tax-product_tag\";b:0;s:29:\"taxonomy-product_tag-ptparent\";i:0;s:32:\"title-tax-product_shipping_class\";s:57:\"Archives des %%term_title%% %%page%% %%sep%% %%sitename%%\";s:35:\"metadesc-tax-product_shipping_class\";s:0:\"\";s:42:\"display-metabox-tax-product_shipping_class\";b:1;s:34:\"noindex-tax-product_shipping_class\";b:0;s:40:\"taxonomy-product_shipping_class-ptparent\";i:0;s:18:\"title-elementor-hf\";s:39:\"%%title%% %%page%% %%sep%% %%sitename%%\";s:21:\"metadesc-elementor-hf\";s:0:\"\";s:20:\"noindex-elementor-hf\";b:0;s:31:\"display-metabox-pt-elementor-hf\";b:1;s:31:\"post_types-elementor-hf-maintax\";i:0;s:29:\"schema-page-type-elementor-hf\";s:7:\"WebPage\";s:32:\"schema-article-type-elementor-hf\";s:4:\"None\";s:24:\"title-tax-fb_product_set\";s:57:\"Archives des %%term_title%% %%page%% %%sep%% %%sitename%%\";s:27:\"metadesc-tax-fb_product_set\";s:0:\"\";s:34:\"display-metabox-tax-fb_product_set\";b:1;s:26:\"noindex-tax-fb_product_set\";b:0;s:32:\"taxonomy-fb_product_set-ptparent\";i:0;}", "yes");
INSERT INTO `psm_options` VALUES("900", "wpseo_social", "a:18:{s:13:\"facebook_site\";s:0:\"\";s:13:\"instagram_url\";s:0:\"\";s:12:\"linkedin_url\";s:0:\"\";s:11:\"myspace_url\";s:0:\"\";s:16:\"og_default_image\";s:0:\"\";s:19:\"og_default_image_id\";s:0:\"\";s:18:\"og_frontpage_title\";s:0:\"\";s:17:\"og_frontpage_desc\";s:0:\"\";s:18:\"og_frontpage_image\";s:0:\"\";s:21:\"og_frontpage_image_id\";s:0:\"\";s:9:\"opengraph\";b:1;s:13:\"pinterest_url\";s:0:\"\";s:15:\"pinterestverify\";s:0:\"\";s:7:\"twitter\";b:1;s:12:\"twitter_site\";s:0:\"\";s:17:\"twitter_card_type\";s:19:\"summary_large_image\";s:11:\"youtube_url\";s:0:\"\";s:13:\"wikipedia_url\";s:0:\"\";}", "yes");
INSERT INTO `psm_options` VALUES("901", "wpseo_flush_rewrite", "1", "yes");
INSERT INTO `psm_options` VALUES("905", "wpseo_ryte", "a:2:{s:6:\"status\";i:-1;s:10:\"last_fetch\";i:1633279815;}", "yes");
INSERT INTO `psm_options` VALUES("929", "wpcf7", "a:2:{s:7:\"version\";s:5:\"5.4.2\";s:13:\"bulk_validate\";a:4:{s:9:\"timestamp\";i:1616707598;s:7:\"version\";s:3:\"5.4\";s:11:\"count_valid\";i:1;s:13:\"count_invalid\";i:0;}}", "yes");
INSERT INTO `psm_options` VALUES("943", "elementor_log", "a:16:{s:32:\"f342273a7ba4ab3542262dff38f076d6\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2021-03-25 22:27:15\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:50:\"Elementor data updater process has been completed.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:9:\"Elementor\";s:4:\"from\";s:5:\"3.1.3\";s:2:\"to\";s:5:\"3.1.4\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2021-03-25 22:27:15\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:9:\"Elementor\";s:4:\"from\";s:5:\"3.1.3\";s:2:\"to\";s:5:\"3.1.4\";}s:7:\"message\";s:50:\"Elementor data updater process has been completed.\";s:4:\"type\";s:4:\"info\";}}s:32:\"1a48d9e9962fdab7a00bd435a4e1ad19\";O:31:\"Elementor\\Core\\Logger\\Items\\PHP\":9:{s:7:\"\0*\0file\";s:86:\"/Applications/MAMP/htdocs/psm/wp-content/plugins/elementor/includes/managers/image.php\";s:7:\"\0*\0line\";i:86;s:7:\"\0*\0date\";s:19:\"2021-04-27 12:19:03\";s:7:\"\0*\0type\";s:6:\"notice\";s:10:\"\0*\0message\";s:51:\"Trying to access array offset on value of type bool\";s:7:\"\0*\0meta\";a:1:{s:5:\"trace\";a:1:{i:0;a:3:{s:8:\"function\";s:8:\"shutdown\";s:5:\"class\";s:29:\"Elementor\\Core\\Logger\\Manager\";s:4:\"type\";s:2:\"->\";}}}s:8:\"\0*\0times\";i:13;s:14:\"\0*\0times_dates\";a:13:{i:0;s:19:\"2021-04-27 12:19:03\";i:1;s:19:\"2021-04-27 12:45:31\";i:2;s:19:\"2021-07-28 18:23:33\";i:3;s:19:\"2021-07-29 15:26:28\";i:4;s:19:\"2021-08-14 10:11:42\";i:5;s:19:\"2021-08-14 10:34:55\";i:6;s:19:\"2021-08-19 01:12:34\";i:7;s:19:\"2021-08-30 21:40:53\";i:8;s:19:\"2021-09-21 18:42:28\";i:9;s:19:\"2021-09-21 18:43:36\";i:10;s:19:\"2021-09-21 19:57:44\";i:11;s:19:\"2021-09-21 19:58:03\";i:12;s:19:\"2021-09-21 19:59:31\";}s:7:\"\0*\0args\";a:5:{s:4:\"type\";s:6:\"notice\";s:7:\"message\";s:51:\"Trying to access array offset on value of type bool\";s:4:\"file\";s:86:\"/Applications/MAMP/htdocs/psm/wp-content/plugins/elementor/includes/managers/image.php\";s:4:\"line\";i:86;s:5:\"trace\";b:1;}}s:32:\"2cc3fadf832176ee6086ee0cb2692535\";O:31:\"Elementor\\Core\\Logger\\Items\\PHP\":9:{s:7:\"\0*\0file\";s:94:\"/Applications/MAMP/htdocs/psm/wp-content/plugins/elementor/core/common/modules/ajax/module.php\";s:7:\"\0*\0line\";i:171;s:7:\"\0*\0date\";s:19:\"2021-04-27 12:55:58\";s:7:\"\0*\0type\";s:6:\"notice\";s:10:\"\0*\0message\";s:21:\"Undefined index: data\";s:7:\"\0*\0meta\";a:1:{s:5:\"trace\";a:1:{i:0;a:3:{s:8:\"function\";s:8:\"shutdown\";s:5:\"class\";s:29:\"Elementor\\Core\\Logger\\Manager\";s:4:\"type\";s:2:\"->\";}}}s:8:\"\0*\0times\";i:39;s:14:\"\0*\0times_dates\";a:39:{i:0;s:19:\"2021-04-27 12:55:58\";i:1;s:19:\"2021-04-27 13:04:53\";i:2;s:19:\"2021-04-27 14:40:55\";i:3;s:19:\"2021-04-27 16:09:29\";i:4;s:19:\"2021-04-28 10:37:23\";i:5;s:19:\"2021-04-28 13:05:49\";i:6;s:19:\"2021-05-06 10:16:13\";i:7;s:19:\"2021-05-06 10:32:54\";i:8;s:19:\"2021-05-06 10:34:39\";i:9;s:19:\"2021-05-06 10:39:16\";i:10;s:19:\"2021-07-28 16:38:01\";i:11;s:19:\"2021-07-28 18:23:19\";i:12;s:19:\"2021-08-14 10:09:56\";i:13;s:19:\"2021-08-14 10:11:09\";i:14;s:19:\"2021-08-14 10:15:57\";i:15;s:19:\"2021-08-14 10:34:48\";i:16;s:19:\"2021-08-15 14:41:11\";i:17;s:19:\"2021-08-15 15:00:55\";i:18;s:19:\"2021-08-15 15:04:12\";i:19;s:19:\"2021-08-30 21:18:01\";i:20;s:19:\"2021-08-30 21:40:27\";i:21;s:19:\"2021-08-31 01:06:40\";i:22;s:19:\"2021-08-31 19:00:25\";i:23;s:19:\"2021-09-21 17:47:27\";i:24;s:19:\"2021-09-21 19:57:31\";i:25;s:19:\"2021-09-21 19:58:25\";i:26;s:19:\"2021-09-21 20:14:01\";i:27;s:19:\"2021-09-21 20:16:48\";i:28;s:19:\"2021-09-22 01:56:07\";i:29;s:19:\"2021-09-22 17:20:27\";i:30;s:19:\"2021-09-27 14:05:25\";i:31;s:19:\"2021-09-27 14:08:59\";i:32;s:19:\"2021-09-27 14:17:40\";i:33;s:19:\"2021-10-03 19:23:06\";i:34;s:19:\"2021-10-03 19:24:35\";i:35;s:19:\"2021-10-03 23:03:15\";i:36;s:19:\"2021-10-03 23:03:37\";i:37;s:19:\"2021-10-03 23:03:45\";i:38;s:19:\"2021-10-04 12:46:19\";}s:7:\"\0*\0args\";a:5:{s:4:\"type\";s:6:\"notice\";s:7:\"message\";s:21:\"Undefined index: data\";s:4:\"file\";s:94:\"/Applications/MAMP/htdocs/psm/wp-content/plugins/elementor/core/common/modules/ajax/module.php\";s:4:\"line\";i:171;s:5:\"trace\";b:1;}}s:32:\"7e57dac891bd53e9dd219afe156b0888\";O:31:\"Elementor\\Core\\Logger\\Items\\PHP\":9:{s:7:\"\0*\0file\";s:115:\"/Applications/MAMP/htdocs/psm/wp-content/plugins/elementor-pro/modules/theme-builder/classes/conditions-manager.php\";s:7:\"\0*\0line\";i:281;s:7:\"\0*\0date\";s:19:\"2021-04-27 13:33:32\";s:7:\"\0*\0type\";s:5:\"error\";s:10:\"\0*\0message\";s:1056:\"Uncaught Error: Call to a member function update_meta() on bool in /Applications/MAMP/htdocs/psm/wp-content/plugins/elementor-pro/modules/theme-builder/classes/conditions-manager.php:281\nStack trace:\n#0 /Applications/MAMP/htdocs/psm/wp-content/plugins/elementor-pro/modules/theme-builder/classes/conditions-manager.php(162): ElementorPro\\Modules\\ThemeBuilder\\Classes\\Conditions_Manager-&gt;save_conditions(NULL, Array)\n#1 [internal function]: ElementorPro\\Modules\\ThemeBuilder\\Classes\\Conditions_Manager-&gt;ajax_save_theme_template_conditions(Array, Object(Elementor\\Core\\Common\\Modules\\Ajax\\Module))\n#2 /Applications/MAMP/htdocs/psm/wp-content/plugins/elementor/core/common/modules/ajax/module.php(171): call_user_func(Array, Array, Object(Elementor\\Core\\Common\\Modules\\Ajax\\Module))\n#3 /Applications/MAMP/htdocs/psm/wp-includes/class-wp-hook.php(292): Elementor\\Core\\Common\\Modules\\Ajax\\Module-&gt;handle_ajax_request(&#039;&#039;)\n#4 /Applications/MAMP/htdocs/psm/wp-includes/class-wp-hook.php(316): WP_Hook-&gt;apply_filters(&#039;&#039;, Array)\n#5 /A\";s:7:\"\0*\0meta\";a:1:{s:5:\"trace\";a:1:{i:0;a:3:{s:8:\"function\";s:8:\"shutdown\";s:5:\"class\";s:29:\"Elementor\\Core\\Logger\\Manager\";s:4:\"type\";s:2:\"->\";}}}s:8:\"\0*\0times\";i:3;s:14:\"\0*\0times_dates\";a:3:{i:0;s:19:\"2021-04-27 13:33:32\";i:1;s:19:\"2021-04-27 14:02:21\";i:2;s:19:\"2021-04-27 15:59:50\";}s:7:\"\0*\0args\";a:5:{s:4:\"type\";s:5:\"error\";s:7:\"message\";s:1024:\"Uncaught Error: Call to a member function update_meta() on bool in /Applications/MAMP/htdocs/psm/wp-content/plugins/elementor-pro/modules/theme-builder/classes/conditions-manager.php:281\nStack trace:\n#0 /Applications/MAMP/htdocs/psm/wp-content/plugins/elementor-pro/modules/theme-builder/classes/conditions-manager.php(162): ElementorPro\\Modules\\ThemeBuilder\\Classes\\Conditions_Manager->save_conditions(NULL, Array)\n#1 [internal function]: ElementorPro\\Modules\\ThemeBuilder\\Classes\\Conditions_Manager->ajax_save_theme_template_conditions(Array, Object(Elementor\\Core\\Common\\Modules\\Ajax\\Module))\n#2 /Applications/MAMP/htdocs/psm/wp-content/plugins/elementor/core/common/modules/ajax/module.php(171): call_user_func(Array, Array, Object(Elementor\\Core\\Common\\Modules\\Ajax\\Module))\n#3 /Applications/MAMP/htdocs/psm/wp-includes/class-wp-hook.php(292): Elementor\\Core\\Common\\Modules\\Ajax\\Module->handle_ajax_request(\'\')\n#4 /Applications/MAMP/htdocs/psm/wp-includes/class-wp-hook.php(316): WP_Hook->apply_filters(\'\', Array)\n#5 /A\";s:4:\"file\";s:115:\"/Applications/MAMP/htdocs/psm/wp-content/plugins/elementor-pro/modules/theme-builder/classes/conditions-manager.php\";s:4:\"line\";i:281;s:5:\"trace\";b:1;}}s:32:\"f3926008caad789235bd907e6c7a4743\";O:31:\"Elementor\\Core\\Logger\\Items\\PHP\":9:{s:7:\"\0*\0file\";s:115:\"/Applications/MAMP/htdocs/psm/wp-content/plugins/elementor-pro/modules/theme-builder/classes/conditions-manager.php\";s:7:\"\0*\0line\";i:162;s:7:\"\0*\0date\";s:19:\"2021-04-27 15:43:56\";s:7:\"\0*\0type\";s:6:\"notice\";s:10:\"\0*\0message\";s:31:\"Undefined index: editor_post_id\";s:7:\"\0*\0meta\";a:1:{s:5:\"trace\";a:1:{i:0;a:3:{s:8:\"function\";s:8:\"shutdown\";s:5:\"class\";s:29:\"Elementor\\Core\\Logger\\Manager\";s:4:\"type\";s:2:\"->\";}}}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2021-04-27 15:43:56\";}s:7:\"\0*\0args\";a:5:{s:4:\"type\";s:6:\"notice\";s:7:\"message\";s:31:\"Undefined index: editor_post_id\";s:4:\"file\";s:115:\"/Applications/MAMP/htdocs/psm/wp-content/plugins/elementor-pro/modules/theme-builder/classes/conditions-manager.php\";s:4:\"line\";i:162;s:5:\"trace\";b:1;}}s:32:\"761e4b519e30da1fd4db4c1cdd01f36f\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2021-09-21 22:35:59\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:47:\"Elementor data updater process has been queued.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:9:\"Elementor\";s:4:\"from\";s:5:\"3.1.4\";s:2:\"to\";s:5:\"3.4.4\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2021-09-21 22:35:59\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:9:\"Elementor\";s:4:\"from\";s:5:\"3.1.4\";s:2:\"to\";s:5:\"3.4.4\";}s:7:\"message\";s:47:\"Elementor data updater process has been queued.\";s:4:\"type\";s:4:\"info\";}}s:32:\"b9cb5cde541d3c6a8af3267d7102bff1\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2021-09-21 22:35:59\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:36:\"elementor::elementor_updater Started\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2021-09-21 22:35:59\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:36:\"elementor::elementor_updater Started\";s:4:\"type\";s:4:\"info\";}}s:32:\"7e4593b46338caeec7344ec9e346b70e\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2021-09-21 22:35:59\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:44:\"Elementor/Upgrades - _on_each_version Start \";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2021-09-21 22:35:59\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:44:\"Elementor/Upgrades - _on_each_version Start \";s:4:\"type\";s:4:\"info\";}}s:32:\"63a3a7c6ac092dbddd3b91634975fdc5\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2021-09-21 22:36:00\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:46:\"Elementor/Upgrades - _on_each_version Finished\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2021-09-21 22:36:00\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:46:\"Elementor/Upgrades - _on_each_version Finished\";s:4:\"type\";s:4:\"info\";}}s:32:\"ef39cc3464158065869a3da1413da362\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2021-09-21 22:36:00\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:70:\"Elementor/Upgrades - _v_3_2_0_migrate_breakpoints_to_new_system Start \";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2021-09-21 22:36:00\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:70:\"Elementor/Upgrades - _v_3_2_0_migrate_breakpoints_to_new_system Start \";s:4:\"type\";s:4:\"info\";}}s:32:\"123f58a21de6838c755641dac23348b3\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2021-09-21 22:36:00\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:72:\"Elementor/Upgrades - _v_3_2_0_migrate_breakpoints_to_new_system Finished\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2021-09-21 22:36:00\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:72:\"Elementor/Upgrades - _v_3_2_0_migrate_breakpoints_to_new_system Finished\";s:4:\"type\";s:4:\"info\";}}s:32:\"106f38846a7339cfcd2fc4fabf4928d5\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2021-09-21 22:36:00\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:50:\"Elementor data updater process has been completed.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:9:\"Elementor\";s:4:\"from\";s:5:\"3.1.4\";s:2:\"to\";s:5:\"3.4.4\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2021-09-21 22:36:00\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:9:\"Elementor\";s:4:\"from\";s:5:\"3.1.4\";s:2:\"to\";s:5:\"3.4.4\";}s:7:\"message\";s:50:\"Elementor data updater process has been completed.\";s:4:\"type\";s:4:\"info\";}}s:32:\"08c845980a1baa519ed40b5c8ab931d0\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2021-09-21 22:36:02\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:47:\"Elementor data updater process has been queued.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:9:\"Elementor\";s:4:\"from\";s:5:\"3.1.4\";s:2:\"to\";s:5:\"3.4.4\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2021-09-21 22:36:02\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:9:\"Elementor\";s:4:\"from\";s:5:\"3.1.4\";s:2:\"to\";s:5:\"3.4.4\";}s:7:\"message\";s:47:\"Elementor data updater process has been queued.\";s:4:\"type\";s:4:\"info\";}}s:32:\"5abe705189c5a5e9eacd1c1a2d438c34\";O:31:\"Elementor\\Core\\Logger\\Items\\PHP\":9:{s:7:\"\0*\0file\";s:86:\"/Applications/MAMP/htdocs/psm/wp-content/plugins/elementor/includes/managers/image.php\";s:7:\"\0*\0line\";i:34;s:7:\"\0*\0date\";s:19:\"2021-09-22 17:17:24\";s:7:\"\0*\0type\";s:6:\"notice\";s:10:\"\0*\0message\";s:21:\"Undefined index: size\";s:7:\"\0*\0meta\";a:1:{s:5:\"trace\";a:1:{i:0;a:3:{s:8:\"function\";s:8:\"shutdown\";s:5:\"class\";s:29:\"Elementor\\Core\\Logger\\Manager\";s:4:\"type\";s:2:\"->\";}}}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2021-09-22 17:17:24\";}s:7:\"\0*\0args\";a:5:{s:4:\"type\";s:6:\"notice\";s:7:\"message\";s:21:\"Undefined index: size\";s:4:\"file\";s:86:\"/Applications/MAMP/htdocs/psm/wp-content/plugins/elementor/includes/managers/image.php\";s:4:\"line\";i:34;s:5:\"trace\";b:1;}}s:32:\"521026f76beb57e5cfc5ffe0a567856b\";O:31:\"Elementor\\Core\\Logger\\Items\\PHP\":9:{s:7:\"\0*\0file\";s:101:\"/Applications/MAMP/htdocs/psm/wp-content/plugins/elementor/includes/libraries/bfi-thumb/bfi-thumb.php\";s:7:\"\0*\0line\";i:547;s:7:\"\0*\0date\";s:19:\"2021-09-24 16:53:30\";s:7:\"\0*\0type\";s:5:\"error\";s:10:\"\0*\0message\";s:80:\"Allowed memory size of 134217728 bytes exhausted (tried to allocate 32768 bytes)\";s:7:\"\0*\0meta\";a:1:{s:5:\"trace\";a:1:{i:0;a:3:{s:8:\"function\";s:8:\"shutdown\";s:5:\"class\";s:29:\"Elementor\\Core\\Logger\\Manager\";s:4:\"type\";s:2:\"->\";}}}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2021-09-24 16:53:30\";}s:7:\"\0*\0args\";a:5:{s:4:\"type\";s:5:\"error\";s:7:\"message\";s:80:\"Allowed memory size of 134217728 bytes exhausted (tried to allocate 32768 bytes)\";s:4:\"file\";s:101:\"/Applications/MAMP/htdocs/psm/wp-content/plugins/elementor/includes/libraries/bfi-thumb/bfi-thumb.php\";s:4:\"line\";i:547;s:5:\"trace\";b:1;}}s:32:\"55d8e13b3ea1f0844733138f8002775f\";O:31:\"Elementor\\Core\\Logger\\Items\\PHP\":9:{s:7:\"\0*\0file\";s:115:\"/Applications/MAMP/htdocs/psm/wp-content/plugins/elementor-pro/modules/theme-builder/classes/conditions-manager.php\";s:7:\"\0*\0line\";i:281;s:7:\"\0*\0date\";s:19:\"2021-10-04 12:54:32\";s:7:\"\0*\0type\";s:5:\"error\";s:10:\"\0*\0message\";s:1056:\"Uncaught Error: Call to a member function update_meta() on bool in /Applications/MAMP/htdocs/psm/wp-content/plugins/elementor-pro/modules/theme-builder/classes/conditions-manager.php:281\nStack trace:\n#0 /Applications/MAMP/htdocs/psm/wp-content/plugins/elementor-pro/modules/theme-builder/classes/conditions-manager.php(162): ElementorPro\\Modules\\ThemeBuilder\\Classes\\Conditions_Manager-&gt;save_conditions(NULL, Array)\n#1 [internal function]: ElementorPro\\Modules\\ThemeBuilder\\Classes\\Conditions_Manager-&gt;ajax_save_theme_template_conditions(Array, Object(Elementor\\Core\\Common\\Modules\\Ajax\\Module))\n#2 /Applications/MAMP/htdocs/psm/wp-content/plugins/elementor/core/common/modules/ajax/module.php(171): call_user_func(Array, Array, Object(Elementor\\Core\\Common\\Modules\\Ajax\\Module))\n#3 /Applications/MAMP/htdocs/psm/wp-includes/class-wp-hook.php(303): Elementor\\Core\\Common\\Modules\\Ajax\\Module-&gt;handle_ajax_request(&#039;&#039;)\n#4 /Applications/MAMP/htdocs/psm/wp-includes/class-wp-hook.php(327): WP_Hook-&gt;apply_filters(&#039;&#039;, Array)\n#5 /A\";s:7:\"\0*\0meta\";a:1:{s:5:\"trace\";a:1:{i:0;a:3:{s:8:\"function\";s:8:\"shutdown\";s:5:\"class\";s:29:\"Elementor\\Core\\Logger\\Manager\";s:4:\"type\";s:2:\"->\";}}}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2021-10-04 12:54:32\";}s:7:\"\0*\0args\";a:5:{s:4:\"type\";s:5:\"error\";s:7:\"message\";s:1024:\"Uncaught Error: Call to a member function update_meta() on bool in /Applications/MAMP/htdocs/psm/wp-content/plugins/elementor-pro/modules/theme-builder/classes/conditions-manager.php:281\nStack trace:\n#0 /Applications/MAMP/htdocs/psm/wp-content/plugins/elementor-pro/modules/theme-builder/classes/conditions-manager.php(162): ElementorPro\\Modules\\ThemeBuilder\\Classes\\Conditions_Manager->save_conditions(NULL, Array)\n#1 [internal function]: ElementorPro\\Modules\\ThemeBuilder\\Classes\\Conditions_Manager->ajax_save_theme_template_conditions(Array, Object(Elementor\\Core\\Common\\Modules\\Ajax\\Module))\n#2 /Applications/MAMP/htdocs/psm/wp-content/plugins/elementor/core/common/modules/ajax/module.php(171): call_user_func(Array, Array, Object(Elementor\\Core\\Common\\Modules\\Ajax\\Module))\n#3 /Applications/MAMP/htdocs/psm/wp-includes/class-wp-hook.php(303): Elementor\\Core\\Common\\Modules\\Ajax\\Module->handle_ajax_request(\'\')\n#4 /Applications/MAMP/htdocs/psm/wp-includes/class-wp-hook.php(327): WP_Hook->apply_filters(\'\', Array)\n#5 /A\";s:4:\"file\";s:115:\"/Applications/MAMP/htdocs/psm/wp-content/plugins/elementor-pro/modules/theme-builder/classes/conditions-manager.php\";s:4:\"line\";i:281;s:5:\"trace\";b:1;}}}", "no");
INSERT INTO `psm_options` VALUES("960", "woocommerce_admin_version", "2.0.2", "yes");
INSERT INTO `psm_options` VALUES("961", "jetpack_content_post_details_date", "1", "yes");
INSERT INTO `psm_options` VALUES("962", "jetpack_content_post_details_categories", "1", "yes");
INSERT INTO `psm_options` VALUES("963", "jetpack_content_post_details_tags", "1", "yes");
INSERT INTO `psm_options` VALUES("964", "jetpack_content_post_details_author", "1", "yes");
INSERT INTO `psm_options` VALUES("965", "jetpack_content_post_details_comment", "1", "yes");
INSERT INTO `psm_options` VALUES("981", "wc_facebook_for_woocommerce_lifecycle_events", "[{\"name\":\"upgrade\",\"time\":1616711347,\"version\":\"2.3.3\",\"data\":{\"from_version\":\"2.3.2\"}},{\"name\":\"install\",\"time\":1615222512,\"version\":\"2.3.2\"}]", "no");
INSERT INTO `psm_options` VALUES("982", "wc_facebook_for_woocommerce_milestone_version", "2.3.3", "yes");
INSERT INTO `psm_options` VALUES("989", "woocommerce_task_list_tracked_completed_tasks", "a:4:{i:0;s:13:\"store_details\";i:1;s:8:\"products\";i:2;s:8:\"payments\";i:3;s:10:\"appearance\";}", "yes");
INSERT INTO `psm_options` VALUES("1000", "woocommerce_task_list_welcome_modal_dismissed", "yes", "yes");
INSERT INTO `psm_options` VALUES("1008", "pand-d83e5fe4823f8f867dc30d3bb0b6c7de", "1643911636", "no");
INSERT INTO `psm_options` VALUES("1009", "pll_dismissed_notices", "a:2:{i:0;s:6:\"wizard\";i:1;s:8:\"lingotek\";}", "yes");
INSERT INTO `psm_options` VALUES("1010", "kk_wc_welcome_message_dismissed", "1", "yes");
INSERT INTO `psm_options` VALUES("1062", "nav_menu_options", "a:2:{i:0;b:0;s:8:\"auto_add\";a:0:{}}", "yes");
INSERT INTO `psm_options` VALUES("1125", "theme_mods_kava", "a:157:{i:0;b:0;s:18:\"nav_menu_locations\";a:1:{s:4:\"main\";i:16;}s:24:\"woocommerce_accent_color\";s:7:\"#27d18b\";s:16:\"blog_layout_type\";s:7:\"default\";s:10:\"blog_style\";s:7:\"default\";s:12:\"show_tagline\";b:1;s:14:\"page_preloader\";b:1;s:19:\"header_social_links\";b:1;s:19:\"footer_social_links\";b:1;s:14:\"container_type\";s:9:\"fullwidth\";s:13:\"sidebar_width\";s:3:\"1/3\";s:15:\"show_page_title\";b:1;s:16:\"totop_visibility\";b:1;s:22:\"totop_vertical_padding\";s:1:\"0\";s:24:\"totop_horizontal_padding\";s:1:\"0\";s:19:\"totop_border_radius\";s:1:\"0\";s:14:\"totop_bg_color\";b:0;s:16:\"totop_icon_color\";b:0;s:20:\"totop_bg_color_hover\";b:0;s:22:\"totop_icon_color_hover\";b:0;s:12:\"accent_color\";s:7:\"#398ffc\";s:18:\"primary_text_color\";s:7:\"#3b3d42\";s:20:\"secondary_text_color\";s:7:\"#a1a2a4\";s:17:\"invert_text_color\";s:7:\"#ffffff\";s:10:\"link_color\";s:7:\"#398ffc\";s:16:\"link_hover_color\";s:7:\"#3b3d42\";s:8:\"h1_color\";s:7:\"#3b3d42\";s:8:\"h2_color\";s:7:\"#3b3d42\";s:8:\"h3_color\";s:7:\"#3b3d42\";s:8:\"h4_color\";s:7:\"#3b3d42\";s:8:\"h5_color\";s:7:\"#3b3d42\";s:8:\"h6_color\";s:7:\"#3b3d42\";s:16:\"body_font_family\";s:18:\"Roboto, sans-serif\";s:15:\"body_font_style\";s:6:\"normal\";s:16:\"body_font_weight\";s:3:\"300\";s:14:\"body_font_size\";s:2:\"14\";s:16:\"body_line_height\";s:3:\"1.6\";s:19:\"body_letter_spacing\";s:1:\"0\";s:18:\"body_character_set\";s:5:\"latin\";s:15:\"body_text_align\";s:4:\"left\";s:14:\"h1_font_family\";s:18:\"Roboto, sans-serif\";s:13:\"h1_font_style\";s:6:\"normal\";s:14:\"h1_font_weight\";s:3:\"400\";s:12:\"h1_font_size\";s:2:\"56\";s:14:\"h1_line_height\";s:3:\"1.4\";s:17:\"h1_letter_spacing\";s:1:\"0\";s:16:\"h1_character_set\";s:5:\"latin\";s:13:\"h1_text_align\";s:7:\"inherit\";s:14:\"h2_font_family\";s:18:\"Roboto, sans-serif\";s:13:\"h2_font_style\";s:6:\"normal\";s:14:\"h2_font_weight\";s:3:\"400\";s:12:\"h2_font_size\";s:2:\"40\";s:14:\"h2_line_height\";s:3:\"1.4\";s:17:\"h2_letter_spacing\";s:1:\"0\";s:16:\"h2_character_set\";s:5:\"latin\";s:13:\"h2_text_align\";s:7:\"inherit\";s:14:\"h3_font_family\";s:18:\"Roboto, sans-serif\";s:13:\"h3_font_style\";s:6:\"normal\";s:14:\"h3_font_weight\";s:3:\"400\";s:12:\"h3_font_size\";s:2:\"28\";s:14:\"h3_line_height\";s:3:\"1.4\";s:17:\"h3_letter_spacing\";s:1:\"0\";s:16:\"h3_character_set\";s:5:\"latin\";s:13:\"h3_text_align\";s:7:\"inherit\";s:14:\"h4_font_family\";s:18:\"Roboto, sans-serif\";s:13:\"h4_font_style\";s:6:\"normal\";s:14:\"h4_font_weight\";s:3:\"400\";s:12:\"h4_font_size\";s:2:\"20\";s:14:\"h4_line_height\";s:3:\"1.5\";s:17:\"h4_letter_spacing\";s:1:\"0\";s:16:\"h4_character_set\";s:5:\"latin\";s:13:\"h4_text_align\";s:7:\"inherit\";s:14:\"h5_font_family\";s:18:\"Roboto, sans-serif\";s:13:\"h5_font_style\";s:6:\"normal\";s:14:\"h5_font_weight\";s:3:\"300\";s:12:\"h5_font_size\";s:2:\"18\";s:14:\"h5_line_height\";s:3:\"1.5\";s:17:\"h5_letter_spacing\";s:1:\"0\";s:16:\"h5_character_set\";s:5:\"latin\";s:13:\"h5_text_align\";s:7:\"inherit\";s:14:\"h6_font_family\";s:18:\"Roboto, sans-serif\";s:13:\"h6_font_style\";s:6:\"normal\";s:14:\"h6_font_weight\";s:3:\"500\";s:12:\"h6_font_size\";s:2:\"14\";s:14:\"h6_line_height\";s:3:\"1.5\";s:17:\"h6_letter_spacing\";s:1:\"0\";s:16:\"h6_character_set\";s:5:\"latin\";s:13:\"h6_text_align\";s:7:\"inherit\";s:23:\"header_logo_font_family\";s:22:\"Montserrat, sans-serif\";s:22:\"header_logo_font_style\";s:6:\"normal\";s:23:\"header_logo_font_weight\";s:3:\"700\";s:21:\"header_logo_font_size\";s:2:\"26\";s:25:\"header_logo_character_set\";s:5:\"latin\";s:16:\"menu_font_family\";s:18:\"Roboto, sans-serif\";s:15:\"menu_font_style\";s:6:\"normal\";s:16:\"menu_font_weight\";s:3:\"400\";s:14:\"menu_font_size\";s:2:\"14\";s:16:\"menu_line_height\";s:3:\"1.4\";s:19:\"menu_letter_spacing\";s:1:\"0\";s:18:\"menu_character_set\";s:5:\"latin\";s:23:\"breadcrumbs_font_family\";s:18:\"Roboto, sans-serif\";s:22:\"breadcrumbs_font_style\";s:6:\"normal\";s:23:\"breadcrumbs_font_weight\";s:3:\"400\";s:21:\"breadcrumbs_font_size\";s:2:\"11\";s:23:\"breadcrumbs_line_height\";s:3:\"1.5\";s:26:\"breadcrumbs_letter_spacing\";s:1:\"0\";s:25:\"breadcrumbs_character_set\";s:5:\"latin\";s:18:\"button_font_family\";s:18:\"Roboto, sans-serif\";s:17:\"button_font_style\";s:6:\"normal\";s:18:\"button_font_weight\";s:3:\"900\";s:16:\"button_font_size\";s:2:\"11\";s:18:\"button_line_height\";s:1:\"1\";s:21:\"button_letter_spacing\";s:1:\"1\";s:20:\"button_character_set\";s:5:\"latin\";s:15:\"header_bg_color\";s:7:\"#ffffff\";s:15:\"header_bg_image\";N;s:16:\"header_bg_repeat\";s:6:\"repeat\";s:20:\"header_bg_position_x\";s:6:\"center\";s:20:\"header_bg_attachment\";s:6:\"scroll\";s:16:\"top_panel_enable\";b:1;s:12:\"top_panel_bg\";s:7:\"#ffffff\";s:16:\"footer_copyright\";s:75:\"&copy; %%year%% Kava | Thème Wordpress polyvalent optimisé pour Elementor\";s:21:\"blog_sidebar_position\";s:17:\"one-right-sidebar\";s:20:\"blog_navigation_type\";s:10:\"navigation\";s:16:\"blog_sticky_type\";s:4:\"icon\";s:17:\"blog_sticky_label\";s:12:\"Mis en avant\";s:16:\"blog_post_author\";b:1;s:22:\"blog_post_publish_date\";b:1;s:20:\"blog_post_categories\";b:1;s:14:\"blog_post_tags\";b:1;s:18:\"blog_post_comments\";b:1;s:17:\"blog_post_excerpt\";b:1;s:29:\"blog_post_excerpt_words_count\";s:2:\"50\";s:19:\"blog_read_more_type\";s:4:\"text\";s:19:\"blog_read_more_text\";s:4:\"Plus\";s:23:\"single_sidebar_position\";s:17:\"one-right-sidebar\";s:18:\"single_post_author\";b:1;s:24:\"single_post_publish_date\";b:1;s:22:\"single_post_categories\";b:1;s:16:\"single_post_tags\";b:1;s:20:\"single_post_comments\";b:1;s:19:\"single_author_block\";b:1;s:21:\"related_posts_visible\";b:1;s:25:\"related_posts_block_title\";s:19:\"Articles similaires\";s:19:\"related_posts_count\";s:1:\"4\";s:18:\"related_posts_grid\";s:1:\"2\";s:19:\"related_posts_image\";b:1;s:26:\"related_posts_publish_date\";b:1;s:20:\"related_posts_author\";b:0;s:19:\"related_posts_title\";b:1;s:21:\"related_posts_excerpt\";b:0;s:23:\"breadcrumbs_visibillity\";b:1;s:29:\"breadcrumbs_front_visibillity\";b:0;s:22:\"breadcrumbs_page_title\";b:0;s:21:\"breadcrumbs_path_type\";s:8:\"minified\";s:18:\"custom_css_post_id\";i:-1;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1617031681;s:4:\"data\";a:3:{s:19:\"wp_inactive_widgets\";a:0:{}s:7:\"sidebar\";a:6:{i:0;s:8:\"search-2\";i:1;s:14:\"recent-posts-2\";i:2;s:17:\"recent-comments-2\";i:3;s:10:\"archives-2\";i:4;s:12:\"categories-2\";i:5;s:6:\"meta-2\";}s:12:\"sidebar-shop\";a:0:{}}}}", "yes");
INSERT INTO `psm_options` VALUES("1137", "theme_mods_jorden", "a:9:{s:11:\"custom_logo\";i:135;s:18:\"custom_css_post_id\";i:-1;s:12:\"accent_color\";s:7:\"#ffffff\";s:10:\"link_color\";s:7:\"#dd3333\";s:18:\"nav_menu_locations\";a:0:{}s:16:\"footer_copyright\";s:0:\"\";s:23:\"breadcrumbs_visibillity\";b:0;s:22:\"breadcrumbs_page_title\";b:0;s:19:\"footer_social_links\";b:0;}", "yes");
INSERT INTO `psm_options` VALUES("1150", "kava-extra-settings", "a:9:{s:37:\"disable_content_container_archive_cpt\";a:4:{s:4:\"post\";s:4:\"true\";s:14:\"e-landing-page\";s:4:\"true\";s:7:\"product\";s:4:\"true\";s:14:\"search_results\";s:4:\"true\";}s:36:\"disable_content_container_single_cpt\";a:5:{s:4:\"post\";s:4:\"true\";s:4:\"page\";s:4:\"true\";s:14:\"e-landing-page\";s:4:\"true\";s:7:\"product\";s:4:\"true\";s:8:\"404_page\";s:4:\"true\";}s:20:\"single_post_template\";s:7:\"default\";s:17:\"available_modules\";a:4:{s:12:\"blog-layouts\";s:4:\"true\";s:11:\"breadcrumbs\";s:4:\"true\";s:12:\"post-formats\";s:4:\"true\";s:3:\"woo\";s:4:\"true\";}s:30:\"enable_theme_customize_options\";s:4:\"true\";s:20:\"enqueue_theme_styles\";s:4:\"true\";s:24:\"enqueue_theme_js_scripts\";s:4:\"true\";s:19:\"enqueue_dynamic_css\";s:4:\"true\";s:17:\"cache_dynamic_css\";s:5:\"false\";}", "yes");
INSERT INTO `psm_options` VALUES("1421", "_transient_product-transient-version", "1630425909", "yes");
INSERT INTO `psm_options` VALUES("1422", "wc_facebook_background_product_sync_job_f7775b6554323146c4213a98ae103ab0", "{\"requests\":{\"p-77\":\"UPDATE\"},\"id\":\"f7775b6554323146c4213a98ae103ab0\",\"created_at\":\"2021-03-30 18:04:56\",\"created_by\":1,\"status\":\"completed\",\"started_processing_at\":\"2021-03-30 18:04:57\",\"updated_at\":\"2021-03-30 18:04:57\",\"total\":1,\"progress\":1,\"completed_at\":\"2021-03-30 18:04:57\"}", "no");
INSERT INTO `psm_options` VALUES("1428", "fb_product_set_children", "a:0:{}", "yes");
INSERT INTO `psm_options` VALUES("1464", "woocommerce_ces_tracks_queue", "a:0:{}", "yes");
INSERT INTO `psm_options` VALUES("1467", "woocommerce_clear_ces_tracks_queue_for_page", "", "yes");
INSERT INTO `psm_options` VALUES("1485", "wc_stripe_wh_monitor_began_at", "1617122909", "yes");
INSERT INTO `psm_options` VALUES("1486", "wc_stripe_wh_last_success_at", "0", "yes");
INSERT INTO `psm_options` VALUES("1487", "wc_stripe_wh_last_failure_at", "0", "yes");
INSERT INTO `psm_options` VALUES("1488", "wc_stripe_wh_last_error", "validation_succeeded", "yes");
INSERT INTO `psm_options` VALUES("1489", "wc_stripe_show_style_notice", "no", "yes");
INSERT INTO `psm_options` VALUES("1490", "wc_stripe_show_sca_notice", "no", "yes");
INSERT INTO `psm_options` VALUES("1535", "woocommerce_onboarding_homepage_post_id", "88", "yes");
INSERT INTO `psm_options` VALUES("1557", "theme_mods_bravada", "a:4:{i:0;b:0;s:18:\"nav_menu_locations\";a:1:{s:7:\"primary\";i:16;}s:18:\"custom_css_post_id\";i:-1;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1617134539;s:4:\"data\";a:8:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-2\";a:6:{i:0;s:8:\"search-2\";i:1;s:14:\"recent-posts-2\";i:2;s:17:\"recent-comments-2\";i:3;s:10:\"archives-2\";i:4;s:12:\"categories-2\";i:5;s:6:\"meta-2\";}s:9:\"sidebar-1\";a:1:{i:0;s:14:\"recent-posts-3\";}s:18:\"footer-widget-area\";a:0:{}s:26:\"content-widget-area-before\";a:0:{}s:25:\"content-widget-area-after\";a:0:{}s:18:\"widget-area-header\";a:0:{}s:24:\"widget-area-side-section\";a:0:{}}}}", "yes");
INSERT INTO `psm_options` VALUES("1568", "theme_mods_nisarg", "a:3:{s:18:\"custom_css_post_id\";i:-1;s:18:\"nav_menu_locations\";a:1:{s:7:\"primary\";i:16;}s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1617136256;s:4:\"data\";a:8:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-2\";a:6:{i:0;s:8:\"search-2\";i:1;s:14:\"recent-posts-2\";i:2;s:17:\"recent-comments-2\";i:3;s:10:\"archives-2\";i:4;s:12:\"categories-2\";i:5;s:6:\"meta-2\";}s:9:\"sidebar-1\";a:1:{i:0;s:14:\"recent-posts-3\";}s:18:\"footer-widget-area\";a:0:{}s:26:\"content-widget-area-before\";a:0:{}s:25:\"content-widget-area-after\";a:0:{}s:18:\"widget-area-header\";a:0:{}s:24:\"widget-area-side-section\";a:0:{}}}}", "yes");
INSERT INTO `psm_options` VALUES("1571", "theme_switched_via_customizer", "", "yes");
INSERT INTO `psm_options` VALUES("1572", "customize_stashed_theme_mods", "a:0:{}", "no");
INSERT INTO `psm_options` VALUES("1639", "theme_mods_ananyapro", "a:51:{i:0;b:0;s:18:\"nav_menu_locations\";a:1:{s:12:\"primary-menu\";i:16;}s:18:\"custom_css_post_id\";i:-1;s:12:\"header_image\";s:102:\"http://localhost:8888/psm/wp-content/uploads/2021/03/thomas-schaefer-ApoYbda6_3Y-unsplash-1-scaled.jpg\";s:17:\"header_image_data\";O:8:\"stdClass\":5:{s:13:\"attachment_id\";i:61;s:3:\"url\";s:102:\"http://localhost:8888/psm/wp-content/uploads/2021/03/thomas-schaefer-ApoYbda6_3Y-unsplash-1-scaled.jpg\";s:13:\"thumbnail_url\";s:102:\"http://localhost:8888/psm/wp-content/uploads/2021/03/thomas-schaefer-ApoYbda6_3Y-unsplash-1-scaled.jpg\";s:6:\"height\";i:1707;s:5:\"width\";i:2560;}s:40:\"ananyapro_header_vertical_text_alignment\";s:8:\"h-center\";s:53:\"ananyapro_use_header_image_only_on_front_page_setting\";b:1;s:29:\"ananyapro_header_overlay_type\";s:13:\"color-overlay\";s:31:\"ananyapro_color_overlay_opacity\";d:0.4;s:22:\"ananyapro_header_title\";s:39:\"Château Pierrie Saint Maxime Sauternes\";s:29:\"ananyapro_header_button1_text\";s:21:\"Découvrir le domaine\";s:31:\"ananyapro_header_text_alignment\";s:11:\"text-center\";s:30:\"ananyapro_header_button2_style\";s:18:\"hero-btn-underline\";s:22:\"ananyapro_accent_color\";s:7:\"#000000\";s:25:\"ananyapro_menu_item_color\";s:7:\"#ffffff\";s:23:\"ananyapro_post_bg_color\";s:7:\"#ffffff\";s:23:\"ananyapro_menu_bg_color\";s:7:\"#6d6d6d\";s:32:\"ananyapro_frontpage_button_style\";s:24:\"fp-btn-fill-slight-round\";s:35:\"ananyapro_frontpage_button_bg_color\";s:7:\"#dd3333\";s:39:\"ananyapro_frontpage_button_border_color\";s:7:\"#dd3333\";s:27:\"ananyapro_disable_feat_sec1\";b:0;s:40:\"ananyapro_content_section_bg_color_sec_1\";s:7:\"#ffffff\";s:45:\"ananyapro_feat_content_text_color_scheme_sec1\";s:4:\"dark\";s:40:\"ananyapro_feat_content_section_name_sec1\";s:62:\"Un domaine viticole se situant au coeur du vignoble Sauternais\";s:33:\"ananyapro_feat_content_title_sec1\";s:32:\"Le Château Pierrie Saint Maxime\";s:38:\"ananyapro_feat_content_image_position1\";s:5:\"right\";s:27:\"ananyapro_pages_layout_sec1\";s:8:\"column-3\";s:33:\"ananyapro_disable_feat_page_sec_1\";b:0;s:41:\"ananyapro_category_section_bg_color_sec_1\";s:7:\"#111111\";s:16:\"background_color\";s:6:\"ffffff\";s:35:\"ananyapro_enable_frontpage_sections\";b:1;s:25:\"ananyapro_feat_image_sec1\";s:100:\"http://localhost:8888/psm/wp-content/uploads/2021/03/propriétaire-chateau-pierrie-saint-maxime.png\";s:35:\"ananyapro_feat_content_tagline_sec1\";s:0:\"\";s:27:\"ananyapro_feat_content_sec1\";s:195:\"La propriété se situe sur les appellations Sauternes et Graves. Aujourd’hui, le vignoble compte 18 ha en AOC Sauternes, 8 ha en AOC Graves Supérieurs et Graves Rouge, et 2 ha en AOC Bordeaux\";s:31:\"ananyapro_feat_button_text_sec1\";s:21:\"Découvrir le domaine\";s:28:\"ananyapro_frontpage_sections\";a:10:{i:0;s:36:\"ananyapro_featured_content_section_1\";i:1;s:34:\"ananyapro_featured_pages_section_1\";i:2;s:37:\"ananyapro_showcase_categories_section\";i:3;s:37:\"ananyapro_featured_category_section_1\";i:4;s:23:\"ananyapro_CTA_section_1\";i:5;s:36:\"ananyapro_featured_content_section_2\";i:6;s:34:\"ananyapro_featured_pages_section_2\";i:7;s:37:\"ananyapro_featured_category_section_2\";i:8;s:23:\"ananyapro_CTA_section_2\";i:9;s:30:\"ananyapro_latest_posts_section\";}s:37:\"ananyapro_page_section_bg_color_sec_1\";s:7:\"#f4f4f4\";s:27:\"ananyapro_pages_sec_title_1\";s:8:\"Nos Vins\";s:25:\"ananyapro_feat_page1_sec1\";i:26;s:28:\"ananyapro_page1_excerpt_sec1\";s:169:\"Le vin du Château Lange est élaboré avec nos meilleures parcelles. Se sont, pour la plupart, de vieilles vignes sur sols graveleux, situées sur la commune de Bommes.\";s:25:\"ananyapro_feat_page2_sec1\";i:28;s:26:\"ananyapro_pages_sec_name_1\";s:70:\"Le Château Pierrie Saint Maxime possède une large sélection de vins\";s:28:\"ananyapro_page2_excerpt_sec1\";s:134:\"Le Sauternes du Château Pierrie Saint Maxime est élaboré à partir de 90% de Sémillon, 5 % de Muscadelle et 5 % de Sauvignon Gris.\";s:44:\"ananyapro_cat_section_text_color_scheme_sec1\";s:5:\"light\";s:24:\"ananyapro_cat_title_sec1\";s:7:\"hhjhkhk\";s:34:\"ananyapro_cat_post_layout_select_1\";s:8:\"column-4\";s:30:\"ananyapro_showcase_cat_image_2\";s:81:\"http://localhost:8888/psm/wp-content/uploads/2021/03/bouteille-détouré_-1.png\";s:30:\"ananyapro_showcase_cat_image_1\";s:62:\"http://localhost:8888/psm/wp-content/uploads/2021/03/psm-1.png\";s:30:\"ananyapro_showcase_cat_image_3\";s:62:\"http://localhost:8888/psm/wp-content/uploads/2021/03/psm-1.png\";s:30:\"ananyapro_showcase_cat_image_4\";s:81:\"http://localhost:8888/psm/wp-content/uploads/2021/03/bouteille-détouré_-1.png\";s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1619516077;s:4:\"data\";a:7:{s:19:\"wp_inactive_widgets\";a:0:{}s:19:\"ananyapro-sidebar-1\";a:6:{i:0;s:8:\"search-2\";i:1;s:14:\"recent-posts-2\";i:2;s:17:\"recent-comments-2\";i:3;s:10:\"archives-2\";i:4;s:12:\"categories-2\";i:5;s:6:\"meta-2\";}s:33:\"ananyapro-footer-widget-area-left\";a:0:{}s:35:\"ananyapro-footer-widget-area-center\";a:0:{}s:34:\"ananyapro-footer-widget-area-right\";a:1:{i:0;s:14:\"recent-posts-3\";}s:35:\"ananyapro-frontpage-widget-area-top\";a:0:{}s:38:\"ananyapro-frontpage-widget-area-bottom\";a:0:{}}}}", "yes");
INSERT INTO `psm_options` VALUES("2014", "elementor_connect_site_key", "984cc23193e8dc6d3d43f97f41194f1c", "yes");
INSERT INTO `psm_options` VALUES("2016", "elementor_allow_tracking", "yes", "yes");
INSERT INTO `psm_options` VALUES("2017", "elementor_tracker_last_send", "1633018157", "yes");
INSERT INTO `psm_options` VALUES("2024", "theme_switch_menu_locations", "a:1:{s:6:\"menu-1\";i:16;}", "yes");
INSERT INTO `psm_options` VALUES("2152", "elementor_pro_version", "3.2.1", "yes");
INSERT INTO `psm_options` VALUES("2153", "widget_elementor-library", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `psm_options` VALUES("2154", "_elementor_pro_installed_time", "1619518510", "yes");
INSERT INTO `psm_options` VALUES("2155", "elementor_submissions_db_version", "5", "yes");
INSERT INTO `psm_options` VALUES("2159", "elementor_pro_license_key", "ep-r4OzSTF0l6houFzFhdHU1619518550J5qH0cKQ2Dej", "yes");
INSERT INTO `psm_options` VALUES("2160", "_elementor_pro_license_data_fallback", "a:2:{s:7:\"timeout\";i:1633437453;s:5:\"value\";s:367:\"{\"expires\":\"2022-04-27 10:10:38\",\"payment_id\":10382433,\"subscription_id\":10382433,\"customer_name\":\"yani ouhab\",\"customer_email\":\"otsaghen@gmail.com\",\"price_id\":1,\"license_limit\":1,\"site_count\":0,\"activations_left\":1,\"success\":true,\"license\":\"valid\",\"item_id\":6630546,\"item_name\":\"Elementor Pro - Personal\",\"subscriptions\":\"enable\",\"checksum\":\"checksum\",\"features\":[]}\";}", "yes");
INSERT INTO `psm_options` VALUES("2161", "_elementor_pro_license_data", "a:2:{s:7:\"timeout\";i:1633394253;s:5:\"value\";s:367:\"{\"expires\":\"2022-04-27 10:10:38\",\"payment_id\":10382433,\"subscription_id\":10382433,\"customer_name\":\"yani ouhab\",\"customer_email\":\"otsaghen@gmail.com\",\"price_id\":1,\"license_limit\":1,\"site_count\":0,\"activations_left\":1,\"success\":true,\"license\":\"valid\",\"item_id\":6630546,\"item_name\":\"Elementor Pro - Personal\",\"subscriptions\":\"enable\",\"checksum\":\"checksum\",\"features\":[]}\";}", "yes");
INSERT INTO `psm_options` VALUES("2162", "_elementor_pro_api_requests_lock", "a:2:{s:16:\"get_license_data\";i:1633343852;s:11:\"get_version\";i:1633349215;}", "yes");
INSERT INTO `psm_options` VALUES("2164", "elementor_fonts_manager_font_types", "a:0:{}", "yes");
INSERT INTO `psm_options` VALUES("2165", "elementor_fonts_manager_fonts", "a:0:{}", "yes");
INSERT INTO `psm_options` VALUES("2166", "elementor_custom_icon_sets_config", "a:0:{}", "yes");
INSERT INTO `psm_options` VALUES("2178", "elementor_pro_theme_builder_conditions", "a:3:{s:6:\"footer\";a:1:{i:435;a:1:{i:0;s:15:\"include/general\";}}s:6:\"single\";a:4:{i:226;a:1:{i:0;s:21:\"include/singular/page\";}i:224;a:1:{i:0;s:21:\"include/singular/page\";}i:214;a:1:{i:0;s:15:\"include/product\";}i:140;a:1:{i:0;s:21:\"include/singular/page\";}}s:6:\"header\";a:1:{i:132;a:1:{i:0;s:15:\"include/general\";}}}", "yes");
INSERT INTO `psm_options` VALUES("2326", "_transient_wc_attribute_taxonomies", "a:1:{i:0;O:8:\"stdClass\":6:{s:12:\"attribute_id\";s:1:\"1\";s:14:\"attribute_name\";s:5:\"color\";s:15:\"attribute_label\";s:5:\"Color\";s:14:\"attribute_type\";s:6:\"select\";s:17:\"attribute_orderby\";s:10:\"menu_order\";s:16:\"attribute_public\";s:1:\"0\";}}", "yes");
INSERT INTO `psm_options` VALUES("2327", "pa_color_children", "a:0:{}", "yes");
INSERT INTO `psm_options` VALUES("2332", "wc_facebook_background_product_sync_job_ff0bc22b5d7174c41ad907e2451419cc", "{\"requests\":{\"p-170\":\"UPDATE\"},\"id\":\"ff0bc22b5d7174c41ad907e2451419cc\",\"created_at\":\"2021-04-27 14:17:46\",\"created_by\":1,\"status\":\"completed\",\"started_processing_at\":\"2021-04-27 14:17:49\",\"updated_at\":\"2021-04-27 14:17:49\",\"total\":1,\"progress\":1,\"completed_at\":\"2021-04-27 14:17:49\"}", "no");
INSERT INTO `psm_options` VALUES("2375", "woocommerce_task_list_appearance_complete", "1", "yes");
INSERT INTO `psm_options` VALUES("2376", "woocommerce_demo_store_notice", "Produits de récoltant issu de l\'A.O.C Sauternes-Barsac", "yes");
INSERT INTO `psm_options` VALUES("2512", "elementor_pro_remote_info_api_data_3.2.1", "a:2:{s:7:\"timeout\";i:1633399616;s:5:\"value\";s:35981:\"{\"stable_version\":\"3.4.1\",\"last_updated\":\"2021-08-31 15:40:43\",\"sections\":\"a:2:{s:11:\\\"description\\\";s:161:\\\"Elementor Pro adds new features to the Elementor Page Builder plugin. Control your conversions, your user engagement, your entire website, from one page builder.\\\";s:9:\\\"changelog\\\";s:31708:\\\"<h4>3.4.1 - 2021-09-01<\\/h4>\\n<ul>\\n<li>Fix: Sticky functionality is not working if the Additional Custom Breakpoints experiment is active (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/16186\\\">#16186<\\/a>)<\\/li>\\n<li>Fix: Slideshow skin UI glitch in Media Carousel widget<\\/li>\\n<li>Fix: Product price typography weight control is not working as expected in Menu Cart widget<\\/li>\\n<\\/ul>\\n<h4>3.4.0 - 2021-09-01<\\/h4>\\n<ul>\\n<li>Tweak: Added new Mini Cart layout type in Menu Cart widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/11312\\\">#11312<\\/a>)<\\/li>\\n<li>Tweak: Added styling options for Cart, Products, and Cart buttons in Menu Cart widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/14952\\\">#14952<\\/a>)<\\/li>\\n<li>Tweak: Added the ability to open cart automatically when an item is added in Menu Cart widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/14119\\\">#14119<\\/a>)<\\/li>\\n<li>Tweak: Added the ability to remove an item from cart without reloading the page with an AJAX request (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/9531\\\">#9531<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/10875\\\">#10875<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/11309\\\">#11309<\\/a>)<\\/li>\\n<li>Tweak: Added Load More AJAX functionality to Posts widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/12126\\\">#12126<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/1284\\\">#1284<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/14557\\\">#14557<\\/a>)<\\/li>\\n<li>Tweak: Added Vimeo support to the Video Playlist widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/15319\\\">#15319<\\/a>)<\\/li>\\n<li>Tweak: Improved asset loading performance by serving lighter JS files (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/8572\\\">#8572<\\/a>)<\\/li>\\n<li>Tweak: Added query string to the URL only after the first video is played in Video Playlist widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/15348\\\">#15348<\\/a>)<\\/li>\\n<li>Tweak: Added various layout options with more responsive controls and cart structure options in Menu Cart widget<\\/li>\\n<li>Tweak: Added the option to open the menu cart by click or hover in Menu Cart widget<\\/li>\\n<li>Tweak: Added the ability to choose a specific product to draw data from in WooCommerce Dynamic tags<\\/li>\\n<li>Tweak: Removed auto-scroll to the widget location when arriving from external URL in Video Playlist widget<\\/li>\\n<li>Tweak: Removed the Video Playlist widget from the Experiments list<\\/li>\\n<li>Tweak: Added descriptive error messages for MailChimp action after submit and on form submit in Forms widget<\\/li>\\n<li>Tweak: Added tooltip trigger None and Hover for link in Hotspot widget<\\/li>\\n<li>Tweak: Added responsive controls to Offset and Effects Offset in Sticky options<\\/li>\\n<li>Tweak: Added responsive control to Alignment in Testimonial Carousel widget<\\/li>\\n<li>Tweak: Adjusted Motion Effects module to support future feature<\\/li>\\n<li>Tweak: Added future compatibility to support better loading of <code>eicons<\\/code> font<\\/li>\\n<li>Tweak: Changed Rename Part title and button color in Theme Builder<\\/li>\\n<li>Fix: Products don\'t appear on the cart while editing in Menu Cart widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/15451\\\">#15451<\\/a>)<\\/li>\\n<li>Fix: Videos always start muted in the Video Playlist widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/15292\\\">#15292<\\/a>)<\\/li>\\n<li>Fix: Unnecessary spacing if submenu indicator is set to None in Nav Menu widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/15365\\\">#15365<\\/a>)<\\/li>\\n<li>Fix: MailChimp double opt-in feature doesn\'t work in Forms widget<\\/li>\\n<li>Fix: Fetching MailChimp groups field blocks the loading of the rest of the fields in the Form widget<\\/li>\\n<li>Fix: Missing field IDs causes forms not to be sent in Forms widget<\\/li>\\n<li>Fix: Full Content Skin is not working properly when inserted twice on the same page in Posts widget<\\/li>\\n<li>Fix: Avoid Duplicates option doesn\'t exclude manual selections in Posts widget<\\/li>\\n<li>Fix: Submenu indicator alignment issue in Nav menu widget<\\/li>\\n<li>Fix: Query control deprecated message appears when debug mode is defined<\\/li>\\n<li>Fix: Tweet Button icon incorrect color and size when the icon is rendered as SVG in Blockquote widget<\\/li>\\n<li>Fix: Video icon size is not changing on Active state in Video Playlist widget<\\/li>\\n<li>Fix: Header icon color is not working in Table Of Content widget<\\/li>\\n<li>Fix: Icons style glitches when Font Awesome Inline experiment is active in Video Playlist widget<\\/li>\\n<li>Fix: Bullet markers are not visible on preview mode when Font Awesome Inline experiment is active in Table of Content widget<\\/li>\\n<li>Fix: UI Glitch when Font-Awesome Inline experiment is active in Price Table widget<\\/li>\\n<li>Fix: Submenu Indicator appears larger when Font Awesome Inline experiment is active in Nav Menu widget<\\/li>\\n<li>Fix: Part name is deleted when clicking on the &quot;Change&quot; Button without changing the name in Theme Builder<\\/li>\\n<li>Fix: Redundant pagination queries in the Editor<\\/li>\\n<li>Deprecated: Remove all usages of <code>Elementor\\\\Utils::get_create_new_post_url()<\\/code><\\/li>\\n<li>Deprecated: See all deprecations to this version in our <a href=\\\"https:\\/\\/developers.elementor.com\\/v3-4-planned-deprecations\\/\\\">Developers Deprecations Post<\\/a><\\/li>\\n<\\/ul>\\n<h4>3.3.8 - 2021-08-23<\\/h4>\\n<ul>\\n<li>Fix: Products grid width issue when adjusting columns and rows in Products widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/16001\\\">#16001<\\/a>)<\\/li>\\n<li>Fix: Font Awesome Inline experiment causes icons glitch in Price Table widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/16045\\\">#16045<\\/a>)<\\/li>\\n<li>Fix: reCAPTCHA v3 <code>z-index<\\/code> is lower than the Section\'s background color<\\/li>\\n<li>Fix: Style missing when Font Awesome inline experiment is active in Post Info widget<\\/li>\\n<li>Fix: Font Awesome icons were not loaded in Post Info widget<\\/li>\\n<li>Fix: Zero character can\'t be used as a placeholder in Number field in Form widget<\\/li>\\n<li>Fix: Carousels are not working properly in the Editor when Additional Custom Breakpoints experiment is active<\\/li>\\n<\\/ul>\\n<h4>3.3.7 - 2021-08-15<\\/h4>\\n<ul>\\n<li>Tweak: Added support for Additional Custom Breakpoints in Nav Menu widget<\\/li>\\n<li>Tweak: Added support for Additional Custom breakpoints in Motion Effects<\\/li>\\n<li>Fix: Columns didn\'t respond to changes in Gallery widget if Additional Custom Breakpoints Experiment is active<\\/li>\\n<\\/ul>\\n<h4>3.3.6 - 2021-08-10<\\/h4>\\n<ul>\\n<li>Tweak: Added support for future feature in Nav Menu widget<\\/li>\\n<li>Fix: WooCommerce responsive grid styles are not being reflected in Product Related widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/15857\\\">#15857<\\/a>)<\\/li>\\n<li>Fix: WooCommerce responsive grid styles are not being reflected in Upsells widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/15857\\\">#15857<\\/a>)<\\/li>\\n<li>Fix: WooCommerce responsive grid styles are not being reflected in Product Categories widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/15857\\\">#15857<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>3.3.5 - 2021-08-01<\\/h4>\\n<ul>\\n<li>Fix: Responsive layout glitches in Products and Products Archive widgets (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/15773\\\">#15773<\\/a>)<\\/li>\\n<li>Fix: reCAPTCHA V3 integration conflict with required fields validation in Forms widget<\\/li>\\n<\\/ul>\\n<h4>3.3.4 - 2021-07-21<\\/h4>\\n<ul>\\n<li>Fix: Grid layout glitch in WooCommerce Products Archive widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/15718\\\">#15718<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>3.3.3 - 2021-07-20<\\/h4>\\n<ul>\\n<li>Tweak: Added a descriptive message in Collect Submissions action after submit<\\/li>\\n<li>Tweak: Added future compatibility for Additional Custom Breakpoints for Pro widgets<\\/li>\\n<li>Fix: Some widget style breaks when Improved CSS Loading Experiment is active in certain cases (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/15632\\\">#15632<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/15683\\\">#15683<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/15660\\\">#15660<\\/a>)<\\/li>\\n<li>Fix: Translation update keep appearing as available after install (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/14297\\\">#14297<\\/a>)<\\/li>\\n<li>Fix: Wrong default icon color when using Font Awesome icons as inline SVG in Call to Action widget<\\/li>\\n<\\/ul>\\n<h4>3.3.2 - 2021-07-13<\\/h4>\\n<ul>\\n<li>Tweak: Updated plugin description<\\/li>\\n<li>Fix: MailChimp tags in form widget replaced existing tags (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/11111\\\">#11111<\\/a>)<\\/li>\\n<li>Fix: Clicking videos from the items list in edit mode doesn\\u2019t initiate videos properly<\\/li>\\n<li>Fix: User unauthorized message when activated but not connected in Kit Library<\\/li>\\n<li>Fix: Carousel widgets did not support additional custom breakpoint responsive values<\\/li>\\n<li>Fix: Tab border is overridden by the Section background color in Video Playlist widget<\\/li>\\n<li>Fix: Widgets style breaks when Improved CSS Load experiment is active in a Single Page template and Post Content widget<\\/li>\\n<\\/ul>\\n<h4>3.3.1 - 2021-06-20<\\/h4>\\n<ul>\\n<li>Tweak: Added support for more Theme Builder display conditions in Export \\/ Import experiment<\\/li>\\n<li>Tweak: Adjusted License page heading structure for future feature<\\/li>\\n<li>Tweak: Adjusted Font Awesome icon for allowing support for future feature<\\/li>\\n<li>Fix: <code>frontend.min.js<\\/code> file size increased in Elementor Pro 3.3.0 (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/15278\\\">#15278<\\/a>)<\\/li>\\n<li>Fix: Prevent conditions from being reset when object cache is enabled in site (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/13299\\\">#13299<\\/a>)<\\/li>\\n<li>Fix: Custom Code publish modal responsiveness issues (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/14519\\\">#14519<\\/a>)<\\/li>\\n<li>Fix: Populating fields with options programmatically doesn\'t appear in Submissions screen (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/10671\\\">#10671<\\/a>)<\\/li>\\n<li>Fix: Large images are not shown on the Image Carousel widget when set via Toolset dynamic tag<\\/li>\\n<li>Fix: Enable inline editing to the inner content tabs in Video Playlist widget<\\/li>\\n<li>Fix: Clicking on the video list doesn\'t play videos properly in Video Playlist widget<\\/li>\\n<li>Fix: Hide Play Icon control when Image overlay is toggled off in Video Playlist widget<\\/li>\\n<li>Fix: Removed extra space below the player when viewing from mobile view in Video Playlist widget<\\/li>\\n<li>Fix: Import button is not working properly in Theme Builder interface<\\/li>\\n<li>Fix: Preview Dynamic Content as control is not updating preview and throws an error in Popup Builder<\\/li>\\n<\\/ul>\\n<h4>3.3.0 - 2021-06-08<\\/h4>\\n<ul>\\n<li>New: Video Playlist widget - Add Engaging Video Content to Your Website (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/11859\\\">#11859<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7803\\\">#7803<\\/a>)<\\/li>\\n<li>New: Hotspot widget - Create Interactive Images With Contextually Relevant Information (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7282\\\">#7282<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2768\\\">#2768<\\/a>)<\\/li>\\n<li>Tweak: Accessibility improvements for sub-menus in Nav Menu widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/13859\\\">#13859<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/13810\\\">#13810<\\/a>)<\\/li>\\n<li>Tweak: MailChimp action after submit can now add new tags to existing subscribers in Forms widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/11111\\\">#11111<\\/a>)<\\/li>\\n<li>Tweak: Added <code>elementor_pro\\/forms\\/record\\/actions_before<\\/code> to filter the record before it sent to Actions After Submit in Forms widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/14261\\\">#14261<\\/a>)<\\/li>\\n<li>Tweak: Yoast SEO breadcrumbs widget can be used in Elementor without the need of enabling them in Yoast setting<\\/li>\\n<li>Tweak: Added future support for widgets CSS conditional loading (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/10329\\\">#10329<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/14229\\\">#14229<\\/a>)<\\/li>\\n<li>Tweak: Added future support for Sticky JS library conditional loading<\\/li>\\n<li>Tweak: Added future support for Import \\/ Export experiment<\\/li>\\n<li>Tweak: Preparations and fixes for Import Export Experiment in Pro version<\\/li>\\n<li>Tweak: Added gradient button capabilities to Login widget buttons<\\/li>\\n<li>Tweak: Added gradient button capabilities to Slides widget button<\\/li>\\n<li>Tweak: Added gradient button capabilities to Price Table widget button<\\/li>\\n<li>Tweak: Added gradient button capabilities to Flip Box widget button<\\/li>\\n<li>Tweak: Added Code Highlight widget Developers Documentation<\\/li>\\n<li>Tweak: Adjusted Submissions page for future updates<\\/li>\\n<li>Tweak: Added <code>em<\\/code> and <code>%<\\/code> units for padding control in Carousel widgets<\\/li>\\n<li>Tweak: Shorten currency name to currency symbol in PayPal button widget<\\/li>\\n<li>Fix: Custom Fonts URLs should be replaced when replace URL is triggered (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7376\\\">#7376<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/10382\\\">#10382<\\/a>)<\\/li>\\n<li>Fix: The currency symbol size changed in the Price Table widget if enabling sale (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/13519\\\">#13519<\\/a>)<\\/li>\\n<li>Fix: Nav Menu widget is not loading Font Awesome submenu icons (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/9907\\\">#9907<\\/a>)<\\/li>\\n<li>Fix: Hamburger toggle is not working in Nav menu widget<\\/li>\\n<li>Fix: Activation bug for IDN domains<\\/li>\\n<li>Fix: Conditions modal responsive glitches in Custom Code<\\/li>\\n<li>Fix: Duplicated strings in Custom Code module<\\/li>\\n<li>Fix: Enable resize option for code input field in Custom Code<\\/li>\\n<li>Fix: &quot;Save &amp; Close &quot;button in Custom Code\'s Conditions modal was not visible on small screen sizes<\\/li>\\n<li>Fix: Removing a column from a section in the navigator resulted in an empty section<\\/li>\\n<li>Fix: Recommend option is cut If the layout is not &quot;Standard&quot; in the Facebook Button widget<\\/li>\\n<li>Fix: Video item does not play without adding an image in Media Carousel widget<\\/li>\\n<li>Fix: <code>search-plus<\\/code> icon missing from panel in Media Carousel widget<\\/li>\\n<li>Fix: UI hover state glitch in Media Carousel widget<\\/li>\\n<li>Fix: PHP notice was thrown when trying to import a kit without overrideConditions parameter in Kit Import flow<\\/li>\\n<li>Fix: Templates conditions not imported if there are no conflicts in Import Export Experiment<\\/li>\\n<li>Fix: Non english values are not encoded properly on Submissions export<\\/li>\\n<li>Fix: Theme Builder import is not working properly<\\/li>\\n<li>Fix: UI glitch when no global widgets were found in Editor Panel<\\/li>\\n<li>Deprecated: See all deprecations to this version in our <a href=\\\"https:\\/\\/developers.elementor.com\\/v3-3-planned-deprecations\\/\\\">Developers Deprecations Post<\\/a><\\/li>\\n<\\/ul>\\n<h4>3.2.2 - 2021-05-05<\\/h4>\\n<ul>\\n<li>Tweak: Added support for Expert tier templates in Templates Library<\\/li>\\n<li>Tweak: Updated compatibility tag to support Elementor v3.2.x<\\/li>\\n<li>Tweak: Added compatibility for future Library improvements<\\/li>\\n<li>Fix: Toolset image dynamic field is not working with Gallery widget<\\/li>\\n<\\/ul>\\n<h4>3.2.1 - 2021-03-21<\\/h4>\\n<ul>\\n<li>Tweak: Added strings context in PayPal button and Price Table widgets<\\/li>\\n<li>Tweak: Added support for future Import \\/ Export Kit feature<\\/li>\\n<li>Fix: Submissions with over than 191 characters weren\'t indexed properly<\\/li>\\n<\\/ul>\\n<h4>3.2.0 - 2021-03-16<\\/h4>\\n<ul>\\n<li>New: PayPal Button widget - Collect PayPal payments directly from your site<\\/li>\\n<li>Experiment: Submissions - Save all of your form submissions in one place (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/1686\\\">#1686<\\/a>)<\\/li>\\n<li>Tweak: Added Stay In Column option to Inner Section element (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7956\\\">#7956<\\/a>)<\\/li>\\n<li>Tweak: Adjusted \'Max Height\' control range in Table of Contents widget<\\/li>\\n<li>Tweak: Changed descriptive text in Create Custom Code screen<\\/li>\\n<li>Tweak: Added support for dynamic capabilities in Code Highlight widget<\\/li>\\n<li>Tweak: Added support for future load on demand for <code>share-link<\\/code> library<\\/li>\\n<li>Tweak: Added support for future load on demand for <code>dialog<\\/code> library in Popup<\\/li>\\n<li>Tweak: Allow overwriting the assets URL when using a mirror domain<\\/li>\\n<li>Fix: Animation was triggered multiple times when accessing the viewport in certain cases in Animated Headline widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/13951\\\">#13951<\\/a>)<\\/li>\\n<li>Fix: Location is not being updated after a Custom Code snippet is published (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/13971\\\">#13971<\\/a>)<\\/li>\\n<li>Fix: Custom Fonts CSS files were not updated after regenerating CSS files<\\/li>\\n<li>Fix: Conditions modal is not responsive in Custom Code<\\/li>\\n<li>Fix: Empty order buttons are displayed in Custom Fonts screen<\\/li>\\n<li>Fix: Typo in \'Reply To\' Email action after submit placeholder in Forms widget<\\/li>\\n<li>Fix: Unnecessary Save Draft button in Custom Code<\\/li>\\n<li>Fix: RTL glitches in Custom Code<\\/li>\\n<li>Fix: Sanitized options in the editor to enforce better security policies<\\/li>\\n<li>Deprecated: See all deprecations to this version in our (<a href=\\\"https:\\/\\/developers.elementor.com\\/v3-2-planned-deprecations\\/\\\">Developers Deprecations Post<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>3.1.1 - 2021-02-23<\\/h4>\\n<ul>\\n<li>Tweak: Adjusted \'Max Height\' control range in Table of Contents widget<\\/li>\\n<li>Fix: Popup event handler is undefined (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/11475\\\">#11475<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/10690\\\">#10690<\\/a>)<\\/li>\\n<li>Fix: Conditions modal is not responsive in Custom Code<\\/li>\\n<li>Fix: RTL glitches in Code Highlight widget<\\/li>\\n<li>Fix: Minor UI glitches in Code Highlight widget<\\/li>\\n<li>Fix: Users can\'t get Pro Developer Edition version updates<\\/li>\\n<\\/ul>\\n<h4>3.1.0 - 2021-02-16<\\/h4>\\n<ul>\\n<li>New: Introducing Custom Code - Add custom code snippets to your site, including <code>head<\\/code>, <code>body<\\/code> start and <code>body<\\/code> end<\\/li>\\n<li>New: Meet Code Highlight widget - showcase any syntax with highlighted UI (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5815\\\">#5815<\\/a>)<\\/li>\\n<li>Experiment: Improved Pro widgets performance by loading JS and Swiper assets conditionally in frontend (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/8572\\\">#8572<\\/a>, <a href=\\\"https:\\/\\/developers.elementor.com\\/experiment-optimized-asset-loading\\/\\\">Developer Documentation<\\/a>)<\\/li>\\n<li>Tweak: Added Compatibility Tag support in Elementor Pro (<a href=\\\"https:\\/\\/developers.elementor.com\\/compatibility-tag\\/\\\">Developer Documentation<\\/a>)<\\/li>\\n<li>Tweak: Added Dynamic capabilities to Rotating Text animation in Animated Headline widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4625\\\">#4625<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/8569\\\">#8569<\\/a>)<\\/li>\\n<li>Tweak: Added an option to set Selected color for Typing effect in Animated Headline widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5403\\\">#5403<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7826\\\">#7826<\\/a>)<\\/li>\\n<li>Tweak: Added animation Loop option for Animated Headline (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/9749\\\">#9749<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2457\\\">#2457<\\/a>)<\\/li>\\n<li>Tweak: Added timing options for Animated Headline widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4392\\\">#4392<\\/a>)<\\/li>\\n<li>Tweak: Added dynamic capabilities for Testimonial Carousel widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/8569\\\">#8569<\\/a>)<\\/li>\\n<li>Tweak: Added dynamic capabilities for Price Table widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4242\\\">#4242<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/8569\\\">#8569<\\/a>)<\\/li>\\n<li>Tweak: Added Word Wrap control to Code Highlight widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/13577\\\">#13577<\\/a>)<\\/li>\\n<li>Tweak: Upgraded Font Awesome Pro library to v5.15.1<\\/li>\\n<li>Tweak: Improved method of loading field mapping repeater in Form widget (<a href=\\\"https:\\/\\/developers.elementor.com\\/how-to-add-a-repeater-control-to-elementor-add-on\\/\\\">Developer Documentation<\\/a>)<\\/li>\\n<li>Tweak: Added &quot;Show on Browsers&quot; Popup Advanced Rule<\\/li>\\n<li>Tweak: Added real-time JS handling to prevent redundant renders in Slides widget and all Carousel widgets<\\/li>\\n<li>Tweak: Import scroll utility from core and remove it from Pro<\\/li>\\n<li>Tweak: Added alignment options for Post Excerpt widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/9757\\\">#9757<\\/a>)<\\/li>\\n<li>Tweak: Changed alignment control to work with selectors in Share Buttons<\\/li>\\n<li>Tweak: Upgraded to Webpack 5, Grunt-Webpack 4 and TerserPlugin instead of UglifyJsPlugin<\\/li>\\n<li>Fix: Steps Divider is not vertically aligned in Multi Step Form widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/12569\\\">#12569<\\/a>)<\\/li>\\n<li>Fix: Slides are playing in an infinite loop mode even when the option is disabled in Slides Widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6726\\\">#6726<\\/a>)<\\/li>\\n<li>Fix: Redundant spacing is added to Share Buttons widget<\\/li>\\n<li>Fix: Step buttons text is not updated without a page reload in Forms widget<\\/li>\\n<li>Fix: Overflow issue in certain animations in Animated Headline widget<\\/li>\\n<li>Fix: When dragging a new Testimonial Carousel there is a console error thrown<\\/li>\\n<li>Fix: Step Buttons are cut in mobile view in Multi Step Form<\\/li>\\n<li>Fix: Submit and Step buttons size differences when using Twenty Twenty theme<\\/li>\\n<li>Fix: Duplicate button Text Color control in Slides widget<\\/li>\\n<li>Fix: JS error is thrown when editing and saving global widgets<\\/li>\\n<li>Fix: <code>get_version<\\/code> API function may fail with Redis \\/ DB cache<\\/li>\\n<li>Fix: Multiple license check requests are created in certain cases<\\/li>\\n<li>Deprecated: Deprecate methods prefixed with an underscore and replace them with unprefixed methods<\\/li>\\n<li>Deprecated: See all deprecations to this version in our <a href=\\\"https:\\/\\/developers.elementor.com\\/v3-1-planned-deprecations\\/\\\">Developers Deprecations Post<\\/a><\\/li>\\n<\\/ul>\\n<h4>3.0.10 - 2021-01-20<\\/h4>\\n<ul>\\n<li>Tweak: Added Editing Handles string translation compatibility with Elementor Pro v3.1<\\/li>\\n<\\/ul>\\n<h4>3.0.9 - 2020-12-29<\\/h4>\\n<ul>\\n<li>Tweak: Added compatibility to support Elementor 3.1.0<\\/li>\\n<li>Fix: Wrong phrasing of Import template success message in Theme Builder<\\/li>\\n<li>Fix: Border color glitch in Theme Builder<\\/li>\\n<\\/ul>\\n<h4>3.0.8 - 2020-11-26<\\/h4>\\n<ul>\\n<li>Fix: Navigation arrows UI glitch in Media Carousel widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/13172\\\">#13172<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>3.0.7 - 2020-11-25<\\/h4>\\n<ul>\\n<li>Fix: Console Error when dragging Testimonials Carousel widget<\\/li>\\n<li>Fix: Arrows of Testimonial and Reviews Carousel widgets navigate to the wrong direction in RTL websites<\\/li>\\n<li>Fix: Removed the conditional loading of Webpack<\\/li>\\n<li>Fix: Fatal error is thrown after deleting an associated custom taxonomy when Posts widget with Cards skin has a badge<\\/li>\\n<li>Fix: Upload JSON files only when the user allowed to prevent security issues<\\/li>\\n<li>Fix: Gallery not displayed in Theme Builder templates preview<\\/li>\\n<\\/ul>\\n<h4>3.0.6 - 2020-11-04<\\/h4>\\n<ul>\\n<li>Tweak: Updated the embedded post in Facebook Embed widget<\\/li>\\n<li>Fix: Minor UI glitches in Theme Builder\'s conditions screen footer<\\/li>\\n<li>Fix: Template type changes into Single Page after conditions change in Theme Builder<\\/li>\\n<li>Fix: Redundant Custom Caption option in Site Logo widget<\\/li>\\n<li>Fix: Removed unused code in Drip integration<\\/li>\\n<li>Fix: Removed Weibo and WeChat social networks due to website and links inactivity from Share Buttons widget<\\/li>\\n<li>Fix: Removed redundant code from Portfolio and Post Navigation widgets<\\/li>\\n<\\/ul>\\n<h4>3.0.5 - 2020-09-23<\\/h4>\\n<ul>\\n<li>Fix: If the default page layout is set to &quot;Canvas&quot; Headers and Footers cannot be edited<\\/li>\\n<li>Fix: Product Image Dynamic Tag throws an error when no image is set<\\/li>\\n<li>Fix: Missing Single document placeholder in Theme Builder<\\/li>\\n<li>Fix: Document editing handles inherit the <code>font-family<\\/code> from 3rd party source<\\/li>\\n<li>Fix: Can\'t add linebreaks to Textarea input when used as Multi Step Form<\\/li>\\n<li>Fix: Incorrect width in Facebook Page widget<\\/li>\\n<li>Fix: Added compatibility to allow the use of \'get_create_url\' in Theme Builder<\\/li>\\n<\\/ul>\\n<h4>3.0.4 - 2020-09-09<\\/h4>\\n<ul>\\n<li>Fix: Autogenerated screenshots appear in WP Media Library modal (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/12304\\\">#12304<\\/a>)<\\/li>\\n<li>Fix: Make sure Elementor Posts widget Pagination doesn\'t interfere with 3rd party plugins (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/12126\\\">#12126<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/12127\\\">#12127<\\/a>)<\\/li>\\n<li>Fix: Shrinking conditions indicator in Theme Builder<\\/li>\\n<li>Fix: Column can\'t be dragged and dropped if it populates a Global widget<\\/li>\\n<li>Fix: Styles are missing from Single templates in some edge cases<\\/li>\\n<\\/ul>\\n<h4>3.0.3 - 2020-09-02<\\/h4>\\n<ul>\\n<li>Fix: Pagination doesn\'t work in WordPress 5.5 (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/12126\\\">#12126<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/12127\\\">#12127<\\/a>)<\\/li>\\n<li>Fix: Change delete template action to &quot;Move to Trash&quot; in the new Theme Builder view<\\/li>\\n<\\/ul>\\n<h4>3.0.2 - 2020-08-31<\\/h4>\\n<ul>\\n<li>Tweak: Replaced WordPress &quot;Learn More&quot; links with dynamic links for better control over time (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/12312\\\">#12312<\\/a>)<\\/li>\\n<li>Tweak: UI tweaks to the Conditions screen In the new Theme Builder<\\/li>\\n<li>Fix: Motion Effects not working when assigned to a column and throws JS error when DOM optimization is disabled (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/12299\\\">#12299<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/12275\\\">#12275<\\/a>)<\\/li>\\n<li>Fix: Multiple Galleries display all the images in the Lightbox slideshow (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/11809\\\">#11809<\\/a>)<\\/li>\\n<li>Fix: Old Theme Builder is being opened when accessing through the Finder<\\/li>\\n<li>Fix: Mixed templates import glitch in Theme Builder<\\/li>\\n<li>Fix: Card icon sizes in Theme Builder<\\/li>\\n<li>Fix: Preview button leads to <code>render_mode<\\/code> instead of preview when importing a template from the new Theme Builder<\\/li>\\n<\\/ul>\\n<h4>3.0.1 - 2020-08-26<\\/h4>\\n<ul>\\n<li>Tweak: Keep previous Theme Builder when accessing from the WP Dashboard for legacy support<\\/li>\\n<li>Tweak: Updated video tutorials in Theme Builder<\\/li>\\n<li>Tweak: Don\'t show auto-screenshots in the Media Library (Props <a href=\\\"https:\\/\\/github.com\\/black-eye\\\">@black-eye<\\/a>)<\\/li>\\n<li>Fix: Repeater items throws <code>childView<\\/code> is undefined message in Forms widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/12239\\\">#12239<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/12221\\\">#12221<\\/a>)<\\/li>\\n<li>Fix: Misspelling of the word &quot;occurred&quot; in Form widget default error message (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/12137\\\">#12137<\\/a>)<\\/li>\\n<li>Fix: Facebook comments not showing up (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/12157\\\">#12157<\\/a>)<\\/li>\\n<li>Fix: Check for conflicts in Theme Builder doesn\'t work properly<\\/li>\\n<li>Fix: Minor UI fixes in Theme Builder<\\/li>\\n<li>Fix: Dark mode glitches in Theme Builder<\\/li>\\n<li>Fix: Global Site Part toaster appears when you publish a Popup<\\/li>\\n<li>Fix: Site Parts aren\'t in the correct order in Theme Builder<\\/li>\\n<li>Fix: Date field caused forms to get corrupted in Forms widget<\\/li>\\n<li>Fix: Theme Builder application page is forbidden<\\/li>\\n<\\/ul>\\n<h4>3.0.0 - 2020-08-23<\\/h4>\\n<ul>\\n<li>New: Introducing the new and improved Theme Builder<\\/li>\\n<li>Tweak: Removed <code>.elementor-inner<\\/code> and <code>.elementor-column-wrap<\\/code> from DOM output to improve performance (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7351\\\">#7351<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7817\\\">#7817<\\/a>, <a href=\\\"https:\\/\\/developers.elementor.com\\/dom-improvements-ahead-html-wrappers-removal-from-v3-0\\/\\\">Developers Blog Post<\\/a>)<\\/li>\\n<li>Tweak: Added contextual anchors ID support to Table of Contents widgets (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/10052\\\">#10052<\\/a>)<\\/li>\\n<li>Tweak: Added WeChat and Weibo social networks to Share Buttons widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/11554\\\">#11554<\\/a>)<\\/li>\\n<li>Tweak: Added Dynamic capabilities for Redirect after Login\\/Logout in Login widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/11343\\\">#11343<\\/a>)<\\/li>\\n<li>Tweak: Added Blend Mode and CSS Filters controls to adjust the Background Overlay in Flipbox widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/11653\\\">#11653<\\/a>)<\\/li>\\n<li>Tweak: Added responsive capabilities to Toggle Button styling in Nav Menu widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/8269\\\">#8269<\\/a>)<\\/li>\\n<li>Tweak: Added responsive Text Alignment control in Call to Action widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/11968\\\">#11968<\\/a>)<\\/li>\\n<li>Tweak: Added dynamic content to Ribbon element in Call to Action widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/10364\\\">#10364<\\/a>)<\\/li>\\n<li>Tweak: Converted uses of Color and Typography Schemes to Global Colors and Fonts<\\/li>\\n<li>Tweak: Separated Title and Description control fields labels in Call to Action widget<\\/li>\\n<li>Tweak: Removed unnecessary style in WC Product with variations<\\/li>\\n<li>Tweak: Converted Portfolio, Posts and Share Buttons widgets to use CSS Variable-based Elementor Grid (<a href=\\\"https:\\/\\/developers.elementor.com\\/elementor-dropping-support-ie\\/\\\">Developers Blog Post<\\/a>)<\\/li>\\n<li>Tweak: Added Date Modified option to Posts widget metadata<\\/li>\\n<li>Fix: PHP 7.4 compatibility to Media Carousel widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/11355\\\">#11355<\\/a>)<\\/li>\\n<li>Fix: Divider alignment issue in Post Info widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/11628\\\">#11628<\\/a>)<\\/li>\\n<li>Fix: Color doesn\\u2019t change in Products Archive Description widget<\\/li>\\n<li>Fix: WC Product variations layout breaks when using Variation Swatches plugin<\\/li>\\n<li>Fix: WC Product variations layout issue<\\/li>\\n<li>Fix: WC Product variations mobile zoom-in glitch<\\/li>\\n<li>Fix: Can\'t edit a Popup after accessing Theme Style<\\/li>\\n<li>Fix: Twitter icon missing in Blockquote widget<\\/li>\\n<li>Fix: Removed redundant default text color from Share Buttons minimal skin<\\/li>\\n<li>Fix: UI glitch in Display Conditions modal<\\/li>\\n<li>Fix: Insert template button UI glitch in Templates Library<\\/li>\\n<li>Fix: Added sanitization to post titles in WordPress dashboard for better security<\\/li>\\n<li>Fix: Show when arriving from search engines rule doesn\'t work in Popup<\\/li>\\n<li>Fix: Child categories are shown with a different parent category in Query control<\\/li>\\n<li>Deprecated: See all deprecations to this version in our <a href=\\\"https:\\/\\/developers.elementor.com\\/v3-0-planned-deprecations\\/\\\">Developers Deprecations Post<\\/a><\\/li>\\n<\\/ul>\\\";}\",\"new_version\":\"3.4.1\",\"name\":\"Elementor Pro\",\"slug\":\"elementor-pro\",\"url\":\"https:\\/\\/elementor.com\\/pro\\/changelog\\/\",\"homepage\":\"https:\\/\\/elementor.com\\/pro\\/\",\"requires\":\"5.0\",\"tested\":\"5.8.1\",\"elementor_requires\":\"3.0.1\",\"package\":\"https:\\/\\/my.elementor.com\\/edd-sl\\/package_download\\/MTYzMzQzNTYxNjplcC1yNE96U1RGMGw2aG91RnpGaGRIVTE2MTk1MTg1NTBKNXFIMGNLUTJEZWo6MToxMzVkOThlYTkwZGQ2M2U0ZDNlYTU1YmUzMTI1MmZlNjpodHRwQC8vbG9jYWxob3N0QDg4ODgvcHNtOjA=\",\"download_link\":\"https:\\/\\/my.elementor.com\\/edd-sl\\/package_download\\/MTYzMzQzNTYxNjplcC1yNE96U1RGMGw2aG91RnpGaGRIVTE2MTk1MTg1NTBKNXFIMGNLUTJEZWo6MToxMzVkOThlYTkwZGQ2M2U0ZDNlYTU1YmUzMTI1MmZlNjpodHRwQC8vbG9jYWxob3N0QDg4ODgvcHNtOjA=\",\"banners\":{\"2x\":\"https:\\/\\/ps.w.org\\/elementor\\/assets\\/banner-1544x500.png?rev=1475479\",\"1x\":\"https:\\/\\/ps.w.org\\/elementor\\/assets\\/banner-772x250.png?rev=1475479\"},\"icons\":{\"svg\":\"https:\\/\\/ps.w.org\\/elementor\\/assets\\/icon.svg\"},\"canary_deployment\":{\"plugin_info\":{\"new_version\":\"3.4.0\",\"name\":\"Elementor Pro\",\"slug\":\"elementor-pro\",\"url\":\"https:\\/\\/elementor.com\\/pro\\/changelog\\/\",\"homepage\":\"https:\\/\\/elementor.com\\/pro\\/\",\"requires\":\"5.0\",\"tested\":\"5.8.1\",\"elementor_requires\":\"3.0.1\",\"package\":\"https:\\/\\/my.elementor.com\\/edd-sl\\/previous_download\\/MTYzMzQzNTYxNjplcC1yNE96U1RGMGw2aG91RnpGaGRIVTE2MTk1MTg1NTBKNXFIMGNLUTJEZWo6MTozLjQuMDoyNWVhY2M1NzljNjJkZjFiYmQ5MmM0NTg3Y2U5ZDdjMjpodHRwQC8vbG9jYWxob3N0QDg4ODgvcHNt\",\"download_link\":\"https:\\/\\/my.elementor.com\\/edd-sl\\/previous_download\\/MTYzMzQzNTYxNjplcC1yNE96U1RGMGw2aG91RnpGaGRIVTE2MTk1MTg1NTBKNXFIMGNLUTJEZWo6MTozLjQuMDoyNWVhY2M1NzljNjJkZjFiYmQ5MmM0NTg3Y2U5ZDdjMjpodHRwQC8vbG9jYWxob3N0QDg4ODgvcHNt\",\"banners\":{\"2x\":\"https:\\/\\/ps.w.org\\/elementor\\/assets\\/banner-1544x500.png?rev=1475479\",\"1x\":\"https:\\/\\/ps.w.org\\/elementor\\/assets\\/banner-772x250.png?rev=1475479\"},\"icons\":{\"svg\":\"https:\\/\\/ps.w.org\\/elementor\\/assets\\/icon.svg\"}},\"conditions\":[[{\"type\":\"language\",\"languages\":[\"he_IL\",\"nl_NL\",\"en_GB\",\"en_NZ\",\"en_ZA\",\"en_AU\",\"en_CA\",\"sv_SE\",\"da_DK\",\"fr_FR\",\"nl_NL\",\"nb_NO\",\"de_AT\",\"fi\",\"it_IT\",\"nn_NO\",\"de_CH\",\"en_GB\",\"is_IS\",\"ga\",\"fr_BE\",\"nl_BE\",\"ast\",\"lb_LU\",\"es_ES\",\"pt_PT\",\"mlt\"],\"operator\":\"in\"}]]},\"translations\":[{\"language\":\"fr_FR\",\"updated\":\"2021-08-11 20:57:15+0000\",\"package\":\"http:\\/\\/translate.elementor.com\\/wp-content\\/uploads\\/pro-translations\\/elementor-pro-fr_FR.zip\"}]}\";}", "yes");
INSERT INTO `psm_options` VALUES("2523", "booking_activation_process", "Off", "yes");
INSERT INTO `psm_options` VALUES("2524", "booking_admin_cal_count", "2", "yes");
INSERT INTO `psm_options` VALUES("2525", "booking_skin", "/css/skins/traditional.css", "yes");
INSERT INTO `psm_options` VALUES("2526", "booking_num_per_page", "10", "yes");
INSERT INTO `psm_options` VALUES("2527", "booking_sort_order", "", "yes");
INSERT INTO `psm_options` VALUES("2528", "booking_default_toolbar_tab", "filter", "yes");
INSERT INTO `psm_options` VALUES("2529", "booking_listing_default_view_mode", "vm_calendar", "yes");
INSERT INTO `psm_options` VALUES("2530", "booking_view_days_num", "90", "yes");
INSERT INTO `psm_options` VALUES("2531", "booking_max_monthes_in_calendar", "1y", "yes");
INSERT INTO `psm_options` VALUES("2532", "booking_client_cal_count", "1", "yes");
INSERT INTO `psm_options` VALUES("2533", "booking_start_day_weeek", "0", "yes");
INSERT INTO `psm_options` VALUES("2534", "booking_title_after_reservation", "Merci pour votre réservation.  Nous vous enverrons une confirmation de votre réservation le plus tôt possible.", "yes");
INSERT INTO `psm_options` VALUES("2535", "booking_title_after_reservation_time", "7000", "yes");
INSERT INTO `psm_options` VALUES("2536", "booking_type_of_thank_you_message", "message", "yes");
INSERT INTO `psm_options` VALUES("2537", "booking_thank_you_page_URL", "/thank-you", "yes");
INSERT INTO `psm_options` VALUES("2538", "booking_is_use_autofill_4_logged_user", "Off", "yes");
INSERT INTO `psm_options` VALUES("2539", "booking_date_format", "j F Y", "yes");
INSERT INTO `psm_options` VALUES("2540", "booking_is_use_localized_time_format", "Off", "yes");
INSERT INTO `psm_options` VALUES("2541", "booking_date_view_type", "short", "yes");
INSERT INTO `psm_options` VALUES("2542", "booking_is_delete_if_deactive", "Off", "yes");
INSERT INTO `psm_options` VALUES("2543", "booking_dif_colors_approval_pending", "On", "yes");
INSERT INTO `psm_options` VALUES("2544", "booking_is_use_hints_at_admin_panel", "On", "yes");
INSERT INTO `psm_options` VALUES("2545", "booking_is_not_load_bs_script_in_client", "Off", "yes");
INSERT INTO `psm_options` VALUES("2546", "booking_is_not_load_bs_script_in_admin", "Off", "yes");
INSERT INTO `psm_options` VALUES("2547", "booking_is_load_js_css_on_specific_pages", "Off", "yes");
INSERT INTO `psm_options` VALUES("2548", "booking_is_show_system_debug_log", "Off", "yes");
INSERT INTO `psm_options` VALUES("2549", "booking_pages_for_load_js_css", "", "yes");
INSERT INTO `psm_options` VALUES("2550", "booking_type_of_day_selections", "multiple", "yes");
INSERT INTO `psm_options` VALUES("2551", "booking_timeslot_picker", "On", "yes");
INSERT INTO `psm_options` VALUES("2552", "booking_timeslot_picker_skin", "/css/time_picker_skins/grey.css", "yes");
INSERT INTO `psm_options` VALUES("2553", "booking_timeslot_day_bg_as_available", "On", "yes");
INSERT INTO `psm_options` VALUES("2554", "booking_form_is_using_bs_css", "On", "yes");
INSERT INTO `psm_options` VALUES("2555", "booking_form_format_type", "vertical", "yes");
INSERT INTO `psm_options` VALUES("2556", "booking_form_field_active1", "On", "yes");
INSERT INTO `psm_options` VALUES("2557", "booking_form_field_required1", "On", "yes");
INSERT INTO `psm_options` VALUES("2558", "booking_form_field_label1", "First Name", "yes");
INSERT INTO `psm_options` VALUES("2559", "booking_form_field_active2", "On", "yes");
INSERT INTO `psm_options` VALUES("2560", "booking_form_field_required2", "On", "yes");
INSERT INTO `psm_options` VALUES("2561", "booking_form_field_label2", "Last Name", "yes");
INSERT INTO `psm_options` VALUES("2562", "booking_form_field_active3", "On", "yes");
INSERT INTO `psm_options` VALUES("2563", "booking_form_field_required3", "On", "yes");
INSERT INTO `psm_options` VALUES("2564", "booking_form_field_label3", "Email", "yes");
INSERT INTO `psm_options` VALUES("2565", "booking_form_field_active4", "On", "yes");
INSERT INTO `psm_options` VALUES("2566", "booking_form_field_required4", "Off", "yes");
INSERT INTO `psm_options` VALUES("2567", "booking_form_field_label4", "Phone", "yes");
INSERT INTO `psm_options` VALUES("2568", "booking_form_field_active5", "On", "yes");
INSERT INTO `psm_options` VALUES("2569", "booking_form_field_required5", "Off", "yes");
INSERT INTO `psm_options` VALUES("2570", "booking_form_field_label5", "Details", "yes");
INSERT INTO `psm_options` VALUES("2571", "booking_form_field_active6", "Off", "yes");
INSERT INTO `psm_options` VALUES("2572", "booking_form_field_required6", "Off", "yes");
INSERT INTO `psm_options` VALUES("2573", "booking_form_field_label6", "Visitors", "yes");
INSERT INTO `psm_options` VALUES("2574", "booking_form_field_values6", "1\n2\n3\n4", "yes");
INSERT INTO `psm_options` VALUES("2575", "booking_is_days_always_available", "Off", "yes");
INSERT INTO `psm_options` VALUES("2576", "booking_is_show_pending_days_as_available", "Off", "yes");
INSERT INTO `psm_options` VALUES("2577", "booking_check_on_server_if_dates_free", "Off", "yes");
INSERT INTO `psm_options` VALUES("2578", "booking_unavailable_days_num_from_today", "0", "yes");
INSERT INTO `psm_options` VALUES("2579", "booking_unavailable_day0", "Off", "yes");
INSERT INTO `psm_options` VALUES("2580", "booking_unavailable_day1", "Off", "yes");
INSERT INTO `psm_options` VALUES("2581", "booking_unavailable_day2", "Off", "yes");
INSERT INTO `psm_options` VALUES("2582", "booking_unavailable_day3", "Off", "yes");
INSERT INTO `psm_options` VALUES("2583", "booking_unavailable_day4", "Off", "yes");
INSERT INTO `psm_options` VALUES("2584", "booking_unavailable_day5", "Off", "yes");
INSERT INTO `psm_options` VALUES("2585", "booking_unavailable_day6", "Off", "yes");
INSERT INTO `psm_options` VALUES("2586", "booking_menu_position", "top", "yes");
INSERT INTO `psm_options` VALUES("2587", "booking_user_role_booking", "editor", "yes");
INSERT INTO `psm_options` VALUES("2588", "booking_user_role_addbooking", "editor", "yes");
INSERT INTO `psm_options` VALUES("2589", "booking_user_role_resources", "editor", "yes");
INSERT INTO `psm_options` VALUES("2590", "booking_user_role_settings", "administrator", "yes");
INSERT INTO `psm_options` VALUES("2591", "booking_is_email_reservation_adress", "On", "yes");
INSERT INTO `psm_options` VALUES("2592", "booking_email_reservation_adress", "&quot;Booking system&quot; &lt;pierriesaintmaximechateau@gmail.com&gt;", "yes");
INSERT INTO `psm_options` VALUES("2593", "booking_email_reservation_from_adress", "[visitoremail]", "yes");
INSERT INTO `psm_options` VALUES("2594", "booking_email_reservation_subject", "Nouvelle réservation", "yes");
INSERT INTO `psm_options` VALUES("2595", "booking_email_reservation_content", "Vous devez d\'approuver une nouvelle réservation [bookingtype] pour [dates]&lt;br/&gt;&lt;br/&gt;Informations détaillées:&lt;br/&gt; [content]&lt;br/&gt;&lt;br/&gt; Actuellement une nouvelle réservation est en attente d\'approbation. S\'il vous plaît visitez le panneau de modération [moderatelink]&lt;br/&gt;&lt;br/&gt;  Merci, Pierrie Saint Maxime&lt;br/&gt;[siteurl]", "yes");
INSERT INTO `psm_options` VALUES("2596", "booking_is_email_newbookingbyperson_adress", "Off", "yes");
INSERT INTO `psm_options` VALUES("2597", "booking_email_newbookingbyperson_adress", "&quot;Booking system&quot; &lt;pierriesaintmaximechateau@gmail.com&gt;", "yes");
INSERT INTO `psm_options` VALUES("2598", "booking_email_newbookingbyperson_subject", "Nouvelle réservation", "yes");
INSERT INTO `psm_options` VALUES("2599", "booking_email_newbookingbyperson_content", "Votre réservation [bookingtype] pour:[dates] est en cours de traitement! Nous vous enverrons une confirmation par mail. &lt;br/&gt;&lt;br/&gt;[content]&lt;br/&gt;&lt;br/&gt; Merci,Pierrie Saint Maxime&lt;br/&gt;[siteurl]", "yes");
INSERT INTO `psm_options` VALUES("2600", "booking_is_email_approval_adress", "On", "yes");
INSERT INTO `psm_options` VALUES("2601", "booking_is_email_approval_send_copy_to_admin", "Off", "yes");
INSERT INTO `psm_options` VALUES("2602", "booking_email_approval_adress", "&quot;Booking system&quot; &lt;pierriesaintmaximechateau@gmail.com&gt;", "yes");
INSERT INTO `psm_options` VALUES("2603", "booking_email_approval_subject", "Votre réservation a été approuvée", "yes");
INSERT INTO `psm_options` VALUES("2604", "booking_email_approval_content", "Votre réservation [bookingtype] pour : [dates]a été approuvée. &lt;br/&gt;&lt;br/&gt;[content]&lt;br/&gt;&lt;br/&gt;Merci, Pierrie Saint Maxime&lt;br/&gt;[siteurl]", "yes");
INSERT INTO `psm_options` VALUES("2605", "booking_is_email_deny_adress", "On", "yes");
INSERT INTO `psm_options` VALUES("2606", "booking_is_email_deny_send_copy_to_admin", "Off", "yes");
INSERT INTO `psm_options` VALUES("2607", "booking_email_deny_adress", "&quot;Booking system&quot; &lt;pierriesaintmaximechateau@gmail.com&gt;", "yes");
INSERT INTO `psm_options` VALUES("2608", "booking_email_deny_subject", "Votre réservation a été refusée", "yes");
INSERT INTO `psm_options` VALUES("2609", "booking_email_deny_content", "Votre réservation [bookingtype] pour [dates] a été annulée. &lt;br/&gt;[denyreason]&lt;br/&gt;&lt;br/&gt;[content]&lt;br/&gt;&lt;br/&gt;Merci, Pierrie Saint Maxime&lt;br/&gt;[siteurl]", "yes");
INSERT INTO `psm_options` VALUES("2610", "booking_widget_title", "Formulaire de réservation", "yes");
INSERT INTO `psm_options` VALUES("2611", "booking_widget_show", "booking_form", "yes");
INSERT INTO `psm_options` VALUES("2612", "booking_widget_type", "1", "yes");
INSERT INTO `psm_options` VALUES("2613", "booking_widget_calendar_count", "1", "yes");
INSERT INTO `psm_options` VALUES("2614", "booking_widget_last_field", "", "yes");
INSERT INTO `psm_options` VALUES("2615", "booking_wpdev_copyright_adminpanel", "On", "yes");
INSERT INTO `psm_options` VALUES("2616", "booking_is_show_powered_by_notice", "On", "yes");
INSERT INTO `psm_options` VALUES("2617", "booking_is_use_captcha", "Off", "yes");
INSERT INTO `psm_options` VALUES("2618", "booking_is_show_legend", "Off", "yes");
INSERT INTO `psm_options` VALUES("2619", "booking_send_button_title", "Envoyer", "yes");
INSERT INTO `psm_options` VALUES("2620", "booking_legend_is_show_item_available", "On", "yes");
INSERT INTO `psm_options` VALUES("2621", "booking_legend_text_for_item_available", "Disponible", "yes");
INSERT INTO `psm_options` VALUES("2622", "booking_legend_is_show_item_pending", "On", "yes");
INSERT INTO `psm_options` VALUES("2623", "booking_legend_text_for_item_pending", "En attente", "yes");
INSERT INTO `psm_options` VALUES("2624", "booking_legend_is_show_item_approved", "On", "yes");
INSERT INTO `psm_options` VALUES("2625", "booking_legend_text_for_item_approved", "Réservé", "yes");
INSERT INTO `psm_options` VALUES("2626", "booking_legend_is_show_numbers", "Off", "yes");
INSERT INTO `psm_options` VALUES("2627", "booking_email_new_admin", "a:15:{s:7:\"enabled\";s:2:\"On\";s:2:\"to\";s:35:\"pierriesaintmaximechateau@gmail.com\";s:7:\"to_name\";s:14:\"Booking system\";s:4:\"from\";s:35:\"pierriesaintmaximechateau@gmail.com\";s:9:\"from_name\";s:14:\"Booking system\";s:7:\"subject\";s:21:\"Nouvelle réservation\";s:7:\"content\";s:324:\"Vous devez d\'approuver une nouvelle réservation [bookingtype] pour [dates]<br/><br/>Informations détaillées:<br/> [content]<br/><br/> Actuellement une nouvelle réservation est en attente d\'approbation. S\'il vous plaît visitez le panneau de modération [moderatelink]<br/><br/>  Merci, Pierrie Saint Maxime<br/>[siteurl]\";s:14:\"header_content\";s:0:\"\";s:14:\"footer_content\";s:0:\"\";s:13:\"template_file\";s:5:\"plain\";s:10:\"base_color\";s:7:\"#557da1\";s:16:\"background_color\";s:7:\"#f5f5f5\";s:10:\"body_color\";s:7:\"#fdfdfd\";s:10:\"text_color\";s:7:\"#505050\";s:18:\"email_content_type\";s:4:\"html\";}", "yes");
INSERT INTO `psm_options` VALUES("2628", "booking_email_new_visitor", "a:13:{s:7:\"enabled\";s:2:\"On\";s:4:\"from\";s:35:\"pierriesaintmaximechateau@gmail.com\";s:9:\"from_name\";s:14:\"Booking system\";s:7:\"subject\";s:21:\"Nouvelle réservation\";s:7:\"content\";s:191:\"Votre réservation [bookingtype] pour:[dates] est en cours de traitement! Nous vous enverrons une confirmation par mail. <br/><br/>[content]<br/><br/> Merci,Pierrie Saint Maxime<br/>[siteurl]\";s:14:\"header_content\";s:0:\"\";s:14:\"footer_content\";s:0:\"\";s:13:\"template_file\";s:5:\"plain\";s:10:\"base_color\";s:7:\"#557da1\";s:16:\"background_color\";s:7:\"#f5f5f5\";s:10:\"body_color\";s:7:\"#fdfdfd\";s:10:\"text_color\";s:7:\"#505050\";s:18:\"email_content_type\";s:4:\"html\";}", "yes");
INSERT INTO `psm_options` VALUES("2629", "booking_email_approved", "a:16:{s:7:\"enabled\";s:2:\"On\";s:13:\"copy_to_admin\";s:3:\"Off\";s:2:\"to\";s:35:\"pierriesaintmaximechateau@gmail.com\";s:7:\"to_name\";s:14:\"Booking system\";s:4:\"from\";s:35:\"pierriesaintmaximechateau@gmail.com\";s:9:\"from_name\";s:14:\"Booking system\";s:7:\"subject\";s:37:\"Votre réservation a été approuvée\";s:7:\"content\";s:137:\"Votre réservation [bookingtype] pour : [dates]a été approuvée. <br/><br/>[content]<br/><br/>Merci, Pierrie Saint Maxime<br/>[siteurl]\";s:14:\"header_content\";s:0:\"\";s:14:\"footer_content\";s:0:\"\";s:13:\"template_file\";s:5:\"plain\";s:10:\"base_color\";s:7:\"#557da1\";s:16:\"background_color\";s:7:\"#f5f5f5\";s:10:\"body_color\";s:7:\"#fdfdfd\";s:10:\"text_color\";s:7:\"#505050\";s:18:\"email_content_type\";s:4:\"html\";}", "yes");
INSERT INTO `psm_options` VALUES("2630", "booking_email_deleted", "a:16:{s:7:\"enabled\";s:2:\"On\";s:13:\"copy_to_admin\";s:3:\"Off\";s:2:\"to\";s:35:\"pierriesaintmaximechateau@gmail.com\";s:7:\"to_name\";s:14:\"Booking system\";s:4:\"from\";s:35:\"pierriesaintmaximechateau@gmail.com\";s:9:\"from_name\";s:14:\"Booking system\";s:7:\"subject\";s:35:\"Votre réservation a été refusée\";s:7:\"content\";s:151:\"Votre réservation [bookingtype] pour [dates] a été annulée. <br/>[denyreason]<br/><br/>[content]<br/><br/>Merci, Pierrie Saint Maxime<br/>[siteurl]\";s:14:\"header_content\";s:0:\"\";s:14:\"footer_content\";s:0:\"\";s:13:\"template_file\";s:5:\"plain\";s:10:\"base_color\";s:7:\"#557da1\";s:16:\"background_color\";s:7:\"#f5f5f5\";s:10:\"body_color\";s:7:\"#fdfdfd\";s:10:\"text_color\";s:7:\"#505050\";s:18:\"email_content_type\";s:4:\"html\";}", "yes");
INSERT INTO `psm_options` VALUES("2631", "booking_email_deny", "a:16:{s:7:\"enabled\";s:2:\"On\";s:13:\"copy_to_admin\";s:3:\"Off\";s:2:\"to\";s:35:\"pierriesaintmaximechateau@gmail.com\";s:7:\"to_name\";s:14:\"Booking system\";s:4:\"from\";s:35:\"pierriesaintmaximechateau@gmail.com\";s:9:\"from_name\";s:14:\"Booking system\";s:7:\"subject\";s:35:\"Votre réservation a été refusée\";s:7:\"content\";s:151:\"Votre réservation [bookingtype] pour [dates] a été annulée. <br/>[denyreason]<br/><br/>[content]<br/><br/>Merci, Pierrie Saint Maxime<br/>[siteurl]\";s:14:\"header_content\";s:0:\"\";s:14:\"footer_content\";s:0:\"\";s:13:\"template_file\";s:5:\"plain\";s:10:\"base_color\";s:7:\"#557da1\";s:16:\"background_color\";s:7:\"#f5f5f5\";s:10:\"body_color\";s:7:\"#fdfdfd\";s:10:\"text_color\";s:7:\"#505050\";s:18:\"email_content_type\";s:4:\"html\";}", "yes");
INSERT INTO `psm_options` VALUES("2632", "booking_email_trash", "a:16:{s:7:\"enabled\";s:2:\"On\";s:13:\"copy_to_admin\";s:3:\"Off\";s:2:\"to\";s:35:\"pierriesaintmaximechateau@gmail.com\";s:7:\"to_name\";s:14:\"Booking system\";s:4:\"from\";s:35:\"pierriesaintmaximechateau@gmail.com\";s:9:\"from_name\";s:14:\"Booking system\";s:7:\"subject\";s:35:\"Votre réservation a été refusée\";s:7:\"content\";s:151:\"Votre réservation [bookingtype] pour [dates] a été annulée. <br/>[denyreason]<br/><br/>[content]<br/><br/>Merci, Pierrie Saint Maxime<br/>[siteurl]\";s:14:\"header_content\";s:0:\"\";s:14:\"footer_content\";s:0:\"\";s:13:\"template_file\";s:5:\"plain\";s:10:\"base_color\";s:7:\"#557da1\";s:16:\"background_color\";s:7:\"#f5f5f5\";s:10:\"body_color\";s:7:\"#fdfdfd\";s:10:\"text_color\";s:7:\"#505050\";s:18:\"email_content_type\";s:4:\"html\";}", "yes");
INSERT INTO `psm_options` VALUES("2633", "booking_form_structure_type", "vertical", "yes");
INSERT INTO `psm_options` VALUES("2634", "booking_menu_go_pro", "show", "yes");
INSERT INTO `psm_options` VALUES("2635", "booking_ics_force_import", "Off", "yes");
INSERT INTO `psm_options` VALUES("2636", "booking_ics_force_trash_before_import", "Off", "yes");
INSERT INTO `psm_options` VALUES("2637", "booking_form", "<div class=\"wpbc_booking_form_structure wpbc_vertical\">\n  <div class=\"wpbc_structure_calendar\">\n    [calendar]\n  </div>\n  <div class=\"wpbc_structure_form\">\n     <p>First Name*:<br />[text* name]</p>\n     <p>Last Name*:<br />[text* secondname]</p>\n     <p>Email*:<br />[email* email]</p>\n     <p>Phone:<br />[text phone]</p>\n     <p>Details:<br />[textarea details]</p>\n     <p>[captcha]</p>\n     <p>[submit class:btn \"Envoyer\"]</p>\n  </div>\n</div>\n<div class=\"wpbc_booking_form_footer\"></div>", "yes");
INSERT INTO `psm_options` VALUES("2638", "booking_form_show", "<div style=\"text-align:left;word-wrap: break-word;\">\n  <strong>First Name</strong>: <span class=\"fieldvalue\">[name]</span><br/>\n  <strong>Last Name</strong>: <span class=\"fieldvalue\">[secondname]</span><br/>\n  <strong>Email</strong>: <span class=\"fieldvalue\">[email]</span><br/>\n  <strong>Phone</strong>: <span class=\"fieldvalue\">[phone]</span><br/>\n  <strong>Details</strong>: <span class=\"fieldvalue\">[details]</span><br/>\n</div>", "yes");
INSERT INTO `psm_options` VALUES("2639", "booking_form_visual", "a:9:{i:0;a:2:{s:4:\"type\";s:8:\"calendar\";s:10:\"obligatory\";s:2:\"On\";}i:1;a:6:{s:4:\"type\";s:4:\"text\";s:4:\"name\";s:4:\"name\";s:10:\"obligatory\";s:3:\"Off\";s:6:\"active\";s:2:\"On\";s:8:\"required\";s:2:\"On\";s:5:\"label\";s:10:\"First Name\";}i:2;a:6:{s:4:\"type\";s:4:\"text\";s:4:\"name\";s:10:\"secondname\";s:10:\"obligatory\";s:3:\"Off\";s:6:\"active\";s:2:\"On\";s:8:\"required\";s:2:\"On\";s:5:\"label\";s:9:\"Last Name\";}i:3;a:6:{s:4:\"type\";s:5:\"email\";s:4:\"name\";s:5:\"email\";s:10:\"obligatory\";s:2:\"On\";s:6:\"active\";s:2:\"On\";s:8:\"required\";s:2:\"On\";s:5:\"label\";s:5:\"Email\";}i:4;a:7:{s:4:\"type\";s:6:\"select\";s:4:\"name\";s:8:\"visitors\";s:10:\"obligatory\";s:3:\"Off\";s:6:\"active\";s:3:\"Off\";s:8:\"required\";s:3:\"Off\";s:5:\"label\";s:8:\"Visitors\";s:5:\"value\";s:7:\"1\n2\n3\n4\";}i:5;a:6:{s:4:\"type\";s:4:\"text\";s:4:\"name\";s:5:\"phone\";s:10:\"obligatory\";s:3:\"Off\";s:6:\"active\";s:2:\"On\";s:8:\"required\";s:3:\"Off\";s:5:\"label\";s:5:\"Phone\";}i:6;a:6:{s:4:\"type\";s:8:\"textarea\";s:4:\"name\";s:7:\"details\";s:10:\"obligatory\";s:3:\"Off\";s:6:\"active\";s:2:\"On\";s:8:\"required\";s:3:\"Off\";s:5:\"label\";s:7:\"Details\";}i:7;a:6:{s:4:\"type\";s:7:\"captcha\";s:4:\"name\";s:7:\"captcha\";s:10:\"obligatory\";s:2:\"On\";s:6:\"active\";s:3:\"Off\";s:8:\"required\";s:2:\"On\";s:5:\"label\";s:0:\"\";}i:8;a:6:{s:4:\"type\";s:6:\"submit\";s:4:\"name\";s:6:\"submit\";s:10:\"obligatory\";s:2:\"On\";s:6:\"active\";s:2:\"On\";s:8:\"required\";s:2:\"On\";s:5:\"label\";s:7:\"Envoyer\";}}", "yes");
INSERT INTO `psm_options` VALUES("2640", "booking_gcal_feed", "", "yes");
INSERT INTO `psm_options` VALUES("2641", "booking_gcal_events_from", "month-start", "yes");
INSERT INTO `psm_options` VALUES("2642", "booking_gcal_events_from_offset", "", "yes");
INSERT INTO `psm_options` VALUES("2643", "booking_gcal_events_from_offset_type", "", "yes");
INSERT INTO `psm_options` VALUES("2644", "booking_gcal_events_until", "any", "yes");
INSERT INTO `psm_options` VALUES("2645", "booking_gcal_events_until_offset", "", "yes");
INSERT INTO `psm_options` VALUES("2646", "booking_gcal_events_until_offset_type", "", "yes");
INSERT INTO `psm_options` VALUES("2647", "booking_gcal_events_max", "25", "yes");
INSERT INTO `psm_options` VALUES("2648", "booking_gcal_api_key", "", "yes");
INSERT INTO `psm_options` VALUES("2649", "booking_gcal_timezone", "", "yes");
INSERT INTO `psm_options` VALUES("2650", "booking_gcal_is_send_email", "Off", "yes");
INSERT INTO `psm_options` VALUES("2651", "booking_gcal_auto_import_is_active", "Off", "yes");
INSERT INTO `psm_options` VALUES("2652", "booking_gcal_auto_import_time", "24", "yes");
INSERT INTO `psm_options` VALUES("2653", "booking_gcal_events_form_fields", "s:101:\"a:3:{s:5:\"title\";s:9:\"text^name\";s:11:\"description\";s:16:\"textarea^details\";s:5:\"where\";s:5:\"text^\";}\";", "yes");
INSERT INTO `psm_options` VALUES("2654", "booking_version_num", "8.8.2", "yes");
INSERT INTO `psm_options` VALUES("2657", "widget_bookingwidget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `psm_options` VALUES("2659", "booking_activation_redirect_for_version", "8.8.2", "yes");
INSERT INTO `psm_options` VALUES("2950", "wc_facebook_background_product_sync_job_8849a62915fdde7e48b3aa423fd55de4", "{\"requests\":{\"p-204\":\"UPDATE\"},\"id\":\"8849a62915fdde7e48b3aa423fd55de4\",\"created_at\":\"2021-04-28 10:46:58\",\"created_by\":1,\"status\":\"completed\",\"started_processing_at\":\"2021-04-28 10:46:59\",\"updated_at\":\"2021-04-28 10:46:59\",\"total\":1,\"progress\":1,\"completed_at\":\"2021-04-28 10:46:59\"}", "no");
INSERT INTO `psm_options` VALUES("2963", "wc_facebook_background_product_sync_job_f042c4e0e0e0a5f2b9b4bb911c269777", "{\"requests\":{\"p-205\":\"UPDATE\"},\"id\":\"f042c4e0e0e0a5f2b9b4bb911c269777\",\"created_at\":\"2021-04-28 10:48:22\",\"created_by\":1,\"status\":\"completed\",\"started_processing_at\":\"2021-04-28 10:48:25\",\"updated_at\":\"2021-04-28 10:48:25\",\"total\":1,\"progress\":1,\"completed_at\":\"2021-04-28 10:48:25\"}", "no");
INSERT INTO `psm_options` VALUES("3087", "wpseo_taxonomy_meta", "a:1:{s:11:\"product_cat\";a:2:{i:28;a:3:{s:13:\"wpseo_focuskw\";s:14:\"Bordeaux rouge\";s:13:\"wpseo_linkdex\";s:2:\"36\";s:19:\"wpseo_content_score\";s:2:\"90\";}i:26;a:4:{s:10:\"wpseo_desc\";s:95:\"Cette catégorie regroupe les vins en grave blanc produits par le château pierrie saint maxime\";s:13:\"wpseo_focuskw\";s:12:\"Graves Blanc\";s:13:\"wpseo_linkdex\";s:2:\"37\";s:19:\"wpseo_content_score\";s:2:\"90\";}}}", "yes");
INSERT INTO `psm_options` VALUES("3093", "product_cat_children", "a:0:{}", "yes");
INSERT INTO `psm_options` VALUES("3106", "wc_facebook_background_product_sync_job_3179d08eeba7a75acf4d7bc5a02d262f", "{\"requests\":{\"p-210\":\"UPDATE\"},\"id\":\"3179d08eeba7a75acf4d7bc5a02d262f\",\"created_at\":\"2021-04-28 11:53:52\",\"created_by\":1,\"status\":\"completed\",\"started_processing_at\":\"2021-04-28 11:53:54\",\"updated_at\":\"2021-04-28 11:53:54\",\"total\":1,\"progress\":1,\"completed_at\":\"2021-04-28 11:53:54\"}", "no");
INSERT INTO `psm_options` VALUES("3113", "wc_facebook_background_product_sync_job_75c7103f01c2b30f673e94e89c3c8aaf", "{\"requests\":{\"p-211\":\"UPDATE\"},\"id\":\"75c7103f01c2b30f673e94e89c3c8aaf\",\"created_at\":\"2021-04-28 11:58:13\",\"created_by\":1,\"status\":\"completed\",\"started_processing_at\":\"2021-04-28 11:58:15\",\"updated_at\":\"2021-04-28 11:58:15\",\"total\":1,\"progress\":1,\"completed_at\":\"2021-04-28 11:58:15\"}", "no");
INSERT INTO `psm_options` VALUES("3120", "wc_facebook_background_product_sync_job_0f1cc1a709ce81787989ca9ee781d716", "{\"requests\":{\"p-212\":\"UPDATE\"},\"id\":\"0f1cc1a709ce81787989ca9ee781d716\",\"created_at\":\"2021-04-28 12:00:55\",\"created_by\":1,\"status\":\"completed\",\"started_processing_at\":\"2021-04-28 12:00:56\",\"updated_at\":\"2021-04-28 12:00:56\",\"total\":1,\"progress\":1,\"completed_at\":\"2021-04-28 12:00:56\"}", "no");
INSERT INTO `psm_options` VALUES("3126", "wc_facebook_background_product_sync_job_35178b93d26afc6361cd0a53227a399a", "{\"requests\":{\"p-213\":\"UPDATE\"},\"id\":\"35178b93d26afc6361cd0a53227a399a\",\"created_at\":\"2021-04-28 12:03:54\",\"created_by\":1,\"status\":\"completed\",\"started_processing_at\":\"2021-04-28 12:03:56\",\"updated_at\":\"2021-04-28 12:03:56\",\"total\":1,\"progress\":1,\"completed_at\":\"2021-04-28 12:03:56\"}", "no");
INSERT INTO `psm_options` VALUES("3142", "elementor_library_category_children", "a:0:{}", "yes");
INSERT INTO `psm_options` VALUES("3227", "woocommerce_thumbnail_cropping", "uncropped", "yes");
INSERT INTO `psm_options` VALUES("3228", "woocommerce_shop_page_display", "", "yes");
INSERT INTO `psm_options` VALUES("4450", "woocommerce_inbox_variant_assignment", "9", "yes");
INSERT INTO `psm_options` VALUES("4451", "wc_stripe_version", "5.2.3", "yes");
INSERT INTO `psm_options` VALUES("4469", "stripe_wc_version", "3.3.4", "yes");
INSERT INTO `psm_options` VALUES("4575", "widget_block", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `psm_options` VALUES("4577", "wp_force_deactivated_plugins", "a:0:{}", "yes");
INSERT INTO `psm_options` VALUES("5042", "elementor_safe_mode_allowed_plugins", "a:3:{s:9:\"elementor\";s:23:\"elementor/elementor.php\";s:13:\"elementor_pro\";s:31:\"elementor-pro/elementor-pro.php\";s:11:\"woocommerce\";s:27:\"woocommerce/woocommerce.php\";}", "yes");
INSERT INTO `psm_options` VALUES("5043", "elementor_safe_mode_created_mu_dir", "1", "yes");
INSERT INTO `psm_options` VALUES("5044", "elementor_safe_mode_token", "b40ff29337fd44c91fb79d34ec3a53b3", "yes");
INSERT INTO `psm_options` VALUES("5045", "elementor_safe_mode", "yes", "yes");
INSERT INTO `psm_options` VALUES("5231", "woocommerce_thumbnail_cropping_custom_width", "2", "yes");
INSERT INTO `psm_options` VALUES("5232", "woocommerce_thumbnail_cropping_custom_height", "5", "yes");
INSERT INTO `psm_options` VALUES("5517", "woocommerce_colors", "a:3:{s:9:\"secondary\";s:7:\"#dd3333\";s:9:\"contentbg\";s:7:\"#fcfcfc\";s:7:\"primary\";s:7:\"#ffffff\";}", "yes");
INSERT INTO `psm_options` VALUES("5518", "woocommerce_colors_css", "p.demo_store{background-color:#fff;color:#808080;}.woocommerce small.note{color:#777;}.woocommerce .woocommerce-breadcrumb{color:#777;}.woocommerce .woocommerce-breadcrumb a{color:#777;}.woocommerce div.product span.price,.woocommerce div.product p.price{color:#77a464;}.woocommerce div.product .stock{color:#77a464;}.woocommerce span.onsale{background-color:#77a464;color:#fff;}.woocommerce ul.products li.product .price{color:#77a464;}.woocommerce ul.products li.product .price .from{color:rgba(132, 132, 132, 0.5);}.woocommerce nav.woocommerce-pagination ul{border:1px solid #bd2020;}.woocommerce nav.woocommerce-pagination ul li{border-right:1px solid #bd2020;}.woocommerce nav.woocommerce-pagination ul li span.current,.woocommerce nav.woocommerce-pagination ul li a:hover,.woocommerce nav.woocommerce-pagination ul li a:focus{background:#d33;color:#3a0a0a;}.woocommerce a.button,.woocommerce button.button,.woocommerce input.button,.woocommerce #respond input#submit{color:#fff;background-color:#d33;}.woocommerce a.button:hover,.woocommerce button.button:hover,.woocommerce input.button:hover,.woocommerce #respond input#submit:hover{background-color:#c22;color:#fff;}.woocommerce a.button.alt,.woocommerce button.button.alt,.woocommerce input.button.alt,.woocommerce #respond input#submit.alt{background-color:#fff;color:#808080;}.woocommerce a.button.alt:hover,.woocommerce button.button.alt:hover,.woocommerce input.button.alt:hover,.woocommerce #respond input#submit.alt:hover{background-color:#eee;color:#808080;}.woocommerce a.button.alt.disabled,.woocommerce button.button.alt.disabled,.woocommerce input.button.alt.disabled,.woocommerce #respond input#submit.alt.disabled,.woocommerce a.button.alt:disabled,.woocommerce button.button.alt:disabled,.woocommerce input.button.alt:disabled,.woocommerce #respond input#submit.alt:disabled,.woocommerce a.button.alt:disabled[disabled],.woocommerce button.button.alt:disabled[disabled],.woocommerce input.button.alt:disabled[disabled],.woocommerce #respond input#submit.alt:disabled[disabled],.woocommerce a.button.alt.disabled:hover,.woocommerce button.button.alt.disabled:hover,.woocommerce input.button.alt.disabled:hover,.woocommerce #respond input#submit.alt.disabled:hover,.woocommerce a.button.alt:disabled:hover,.woocommerce button.button.alt:disabled:hover,.woocommerce input.button.alt:disabled:hover,.woocommerce #respond input#submit.alt:disabled:hover,.woocommerce a.button.alt:disabled[disabled]:hover,.woocommerce button.button.alt:disabled[disabled]:hover,.woocommerce input.button.alt:disabled[disabled]:hover,.woocommerce #respond input#submit.alt:disabled[disabled]:hover{background-color:#fff;color:#808080;}.woocommerce a.button:disabled:hover,.woocommerce button.button:disabled:hover,.woocommerce input.button:disabled:hover,.woocommerce #respond input#submit:disabled:hover,.woocommerce a.button.disabled:hover,.woocommerce button.button.disabled:hover,.woocommerce input.button.disabled:hover,.woocommerce #respond input#submit.disabled:hover,.woocommerce a.button:disabled[disabled]:hover,.woocommerce button.button:disabled[disabled]:hover,.woocommerce input.button:disabled[disabled]:hover,.woocommerce #respond input#submit:disabled[disabled]:hover{background-color:#d33;}.woocommerce #reviews h2 small{color:#777;}.woocommerce #reviews h2 small a{color:#777;}.woocommerce #reviews #comments ol.commentlist li .meta{color:#777;}.woocommerce #reviews #comments ol.commentlist li img.avatar{background:#d33;border:1px solid #db2626;}.woocommerce #reviews #comments ol.commentlist li .comment-text{border:1px solid #db2626;}.woocommerce #reviews #comments ol.commentlist #respond{border:1px solid #db2626;}.woocommerce .star-rating:before{color:#bd2020;}.woocommerce.widget_shopping_cart .total,.woocommerce .widget_shopping_cart .total{border-top:3px double #d33;}.woocommerce form.login,.woocommerce form.checkout_coupon,.woocommerce form.register{border:1px solid #bd2020;}.woocommerce .order_details li{border-right:1px dashed #bd2020;}.woocommerce .widget_price_filter .ui-slider .ui-slider-handle{background-color:#fff;}.woocommerce .widget_price_filter .ui-slider .ui-slider-range{background-color:#fff;}.woocommerce .widget_price_filter .price_slider_wrapper .ui-widget-content{background-color:#bbb;}.woocommerce-cart table.cart td.actions .coupon .input-text{border:1px solid #bd2020;}.woocommerce-cart .cart-collaterals .cart_totals p small{color:#777;}.woocommerce-cart .cart-collaterals .cart_totals table small{color:#777;}.woocommerce-cart .cart-collaterals .cart_totals .discount td{color:#77a464;}.woocommerce-cart .cart-collaterals .cart_totals tr td,.woocommerce-cart .cart-collaterals .cart_totals tr th{border-top:1px solid #d33;}.woocommerce-checkout .checkout .create-account small{color:#777;}.woocommerce-checkout #payment{background:#d33;}.woocommerce-checkout #payment ul.payment_methods{border-bottom:1px solid #bd2020;}.woocommerce-checkout #payment div.payment_box{background-color:#d32323;color:#fff;}.woocommerce-checkout #payment div.payment_box input.input-text,.woocommerce-checkout #payment div.payment_box textarea{border-color:#a81c1c;border-top-color:#921818;}.woocommerce-checkout #payment div.payment_box ::-webkit-input-placeholder{color:#921818;}.woocommerce-checkout #payment div.payment_box :-moz-placeholder{color:#921818;}.woocommerce-checkout #payment div.payment_box :-ms-input-placeholder{color:#921818;}.woocommerce-checkout #payment div.payment_box span.help{color:#777;}.woocommerce-checkout #payment div.payment_box:after{content:\"\";display:block;border:8px solid #d32323;border-right-color:transparent;border-left-color:transparent;border-top-color:transparent;position:absolute;top:-3px;left:0;margin:-1em 0 0 2em;}", "yes");
INSERT INTO `psm_options` VALUES("6721", "_transient_timeout_wc_shipping_method_count_legacy", "1634830826", "no");
INSERT INTO `psm_options` VALUES("6722", "_transient_wc_shipping_method_count_legacy", "a:2:{s:7:\"version\";s:10:\"1615230270\";s:5:\"value\";i:0;}", "no");
INSERT INTO `psm_options` VALUES("6751", "_transient_timeout_wc_low_stock_count", "1634831417", "no");
INSERT INTO `psm_options` VALUES("6752", "_transient_wc_low_stock_count", "0", "no");
INSERT INTO `psm_options` VALUES("6753", "_transient_timeout_wc_outofstock_count", "1634831417", "no");
INSERT INTO `psm_options` VALUES("6754", "_transient_wc_outofstock_count", "0", "no");
INSERT INTO `psm_options` VALUES("6775", "_transient_timeout_jetpack_file_data_9.5", "1634745045", "no");
INSERT INTO `psm_options` VALUES("6776", "_transient_jetpack_file_data_9.5", "a:50:{s:32:\"d3576702faeb399eb47ad20f586c3804\";a:14:{s:4:\"name\";s:8:\"Carousel\";s:11:\"description\";s:75:\"Display images and galleries in a gorgeous, full-screen browsing experience\";s:4:\"sort\";s:2:\"22\";s:20:\"recommendation_order\";s:2:\"12\";s:10:\"introduced\";s:3:\"1.5\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:2:\"No\";s:13:\"auto_activate\";s:2:\"No\";s:11:\"module_tags\";s:17:\"Photos and Videos\";s:7:\"feature\";s:10:\"Appearance\";s:25:\"additional_search_queries\";s:80:\"gallery, carousel, diaporama, slideshow, images, lightbox, exif, metadata, image\";s:12:\"plan_classes\";s:0:\"\";}s:32:\"55409a5f8388b8d33e2350ef80de3ea3\";a:14:{s:4:\"name\";s:13:\"Comment Likes\";s:11:\"description\";s:64:\"Increase visitor engagement by adding a Like button to comments.\";s:4:\"sort\";s:2:\"39\";s:20:\"recommendation_order\";s:2:\"17\";s:10:\"introduced\";s:3:\"5.1\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:2:\"No\";s:11:\"module_tags\";s:6:\"Social\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:37:\"like widget, like button, like, likes\";s:12:\"plan_classes\";s:0:\"\";}s:32:\"e914e6d31cb61f5a9ef86e1b9573430e\";a:14:{s:4:\"name\";s:8:\"Comments\";s:11:\"description\";s:81:\"Let visitors use a WordPress.com, Twitter, Facebook, or Google account to comment\";s:4:\"sort\";s:2:\"20\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"1.4\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:2:\"No\";s:11:\"module_tags\";s:6:\"Social\";s:7:\"feature\";s:10:\"Engagement\";s:25:\"additional_search_queries\";s:53:\"comments, comment, facebook, twitter, google+, social\";s:12:\"plan_classes\";s:0:\"\";}s:32:\"f1b8c61705fb18eb8c8584c9f9cdffd9\";a:14:{s:4:\"name\";s:12:\"Contact Form\";s:11:\"description\";s:81:\"Add a customizable contact form to any post or page using the Jetpack Form Block.\";s:4:\"sort\";s:2:\"15\";s:20:\"recommendation_order\";s:2:\"14\";s:10:\"introduced\";s:3:\"1.3\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:2:\"No\";s:13:\"auto_activate\";s:3:\"Yes\";s:11:\"module_tags\";s:5:\"Other\";s:7:\"feature\";s:7:\"Writing\";s:25:\"additional_search_queries\";s:214:\"contact, form, grunion, feedback, submission, contact form, email, feedback, contact form plugin, custom form, custom form plugin, form builder, forms, form maker, survey, contact by jetpack, contact us, forms free\";s:12:\"plan_classes\";s:0:\"\";}s:32:\"4fca6eb23a793155d69fdb119a094926\";a:14:{s:4:\"name\";s:9:\"Copy Post\";s:11:\"description\";s:77:\"Enable the option to copy entire posts and pages, including tags and settings\";s:4:\"sort\";s:2:\"15\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"7.0\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:2:\"No\";s:13:\"auto_activate\";s:2:\"No\";s:11:\"module_tags\";s:7:\"Writing\";s:7:\"feature\";s:7:\"Writing\";s:25:\"additional_search_queries\";s:15:\"copy, duplicate\";s:12:\"plan_classes\";s:0:\"\";}s:32:\"cfdac01e3c3c529f93a8f49edef1f5db\";a:14:{s:4:\"name\";s:20:\"Custom content types\";s:11:\"description\";s:74:\"Display different types of content on your site with custom content types.\";s:4:\"sort\";s:2:\"34\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"3.1\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:2:\"No\";s:13:\"auto_activate\";s:2:\"No\";s:11:\"module_tags\";s:7:\"Writing\";s:7:\"feature\";s:7:\"Writing\";s:25:\"additional_search_queries\";s:72:\"cpt, custom post types, portfolio, portfolios, testimonial, testimonials\";s:12:\"plan_classes\";s:0:\"\";}s:32:\"4b9137ecf507290743735fb1f94535df\";a:14:{s:4:\"name\";s:10:\"Custom CSS\";s:11:\"description\";s:88:\"Adds options for CSS preprocessor use, disabling the theme\'s CSS, or custom image width.\";s:4:\"sort\";s:1:\"2\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"1.7\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:2:\"No\";s:13:\"auto_activate\";s:2:\"No\";s:11:\"module_tags\";s:10:\"Appearance\";s:7:\"feature\";s:10:\"Appearance\";s:25:\"additional_search_queries\";s:108:\"css, customize, custom, style, editor, less, sass, preprocessor, font, mobile, appearance, theme, stylesheet\";s:12:\"plan_classes\";s:0:\"\";}s:32:\"95d75b38d76d2ee1b5b537026eadb8ff\";a:14:{s:4:\"name\";s:21:\"Enhanced Distribution\";s:11:\"description\";s:27:\"Increase reach and traffic.\";s:4:\"sort\";s:1:\"5\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"1.2\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:6:\"Public\";s:11:\"module_tags\";s:7:\"Writing\";s:7:\"feature\";s:10:\"Engagement\";s:25:\"additional_search_queries\";s:54:\"google, seo, firehose, search, broadcast, broadcasting\";s:12:\"plan_classes\";s:0:\"\";}s:32:\"f1bb571a95c5de1e6adaf9db8567c039\";a:14:{s:4:\"name\";s:0:\"\";s:11:\"description\";s:0:\"\";s:4:\"sort\";s:0:\"\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:0:\"\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:0:\"\";s:13:\"auto_activate\";s:0:\"\";s:11:\"module_tags\";s:0:\"\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:0:\"\";s:12:\"plan_classes\";s:0:\"\";}s:32:\"822f9ef1281dace3fb7cc420c77d24e0\";a:14:{s:4:\"name\";s:16:\"Google Analytics\";s:11:\"description\";s:56:\"Set up Google Analytics without touching a line of code.\";s:4:\"sort\";s:2:\"37\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"4.5\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:2:\"No\";s:11:\"module_tags\";s:0:\"\";s:7:\"feature\";s:10:\"Engagement\";s:25:\"additional_search_queries\";s:37:\"webmaster, google, analytics, console\";s:12:\"plan_classes\";s:37:\"business, premium, security, complete\";}s:32:\"c167275f926ef0eefaec9a679bd88d34\";a:14:{s:4:\"name\";s:19:\"Gravatar Hovercards\";s:11:\"description\";s:58:\"Enable pop-up business cards over commenters’ Gravatars.\";s:4:\"sort\";s:2:\"11\";s:20:\"recommendation_order\";s:2:\"13\";s:10:\"introduced\";s:3:\"1.1\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:2:\"No\";s:13:\"auto_activate\";s:2:\"No\";s:11:\"module_tags\";s:18:\"Social, Appearance\";s:7:\"feature\";s:10:\"Appearance\";s:25:\"additional_search_queries\";s:20:\"gravatar, hovercards\";s:12:\"plan_classes\";s:0:\"\";}s:32:\"58cbd4585a74829a1c88aa9c295f3993\";a:14:{s:4:\"name\";s:15:\"Infinite Scroll\";s:11:\"description\";s:53:\"Automatically load new content when a visitor scrolls\";s:4:\"sort\";s:2:\"26\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"2.0\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:2:\"No\";s:13:\"auto_activate\";s:2:\"No\";s:11:\"module_tags\";s:10:\"Appearance\";s:7:\"feature\";s:10:\"Appearance\";s:25:\"additional_search_queries\";s:33:\"scroll, infinite, infinite scroll\";s:12:\"plan_classes\";s:0:\"\";}s:32:\"d4a35eabc948caefad71a0d3303b95c8\";a:14:{s:4:\"name\";s:8:\"JSON API\";s:11:\"description\";s:51:\"Allow applications to securely access your content.\";s:4:\"sort\";s:2:\"19\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"1.9\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:6:\"Public\";s:11:\"module_tags\";s:19:\"Writing, Developers\";s:7:\"feature\";s:7:\"General\";s:25:\"additional_search_queries\";s:50:\"api, rest, develop, developers, json, klout, oauth\";s:12:\"plan_classes\";s:0:\"\";}s:32:\"7b0c670bc3f8209dc83abb8610e23a89\";a:14:{s:4:\"name\";s:14:\"Beautiful Math\";s:11:\"description\";s:74:\"Use the LaTeX markup language to write mathematical equations and formulas\";s:4:\"sort\";s:2:\"12\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"1.1\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:2:\"No\";s:13:\"auto_activate\";s:2:\"No\";s:11:\"module_tags\";s:7:\"Writing\";s:7:\"feature\";s:7:\"Writing\";s:25:\"additional_search_queries\";s:47:\"latex, math, equation, equations, formula, code\";s:12:\"plan_classes\";s:0:\"\";}s:32:\"b00e4e6c109ce6f77b5c83fbaaaead4c\";a:14:{s:4:\"name\";s:11:\"Lazy Images\";s:11:\"description\";s:137:\"Speed up your site and create a smoother viewing experience by loading images as visitors scroll down the screen, instead of all at once.\";s:4:\"sort\";s:2:\"24\";s:20:\"recommendation_order\";s:2:\"14\";s:10:\"introduced\";s:5:\"5.6.0\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:2:\"No\";s:13:\"auto_activate\";s:2:\"No\";s:11:\"module_tags\";s:23:\"Appearance, Recommended\";s:7:\"feature\";s:10:\"Appearance\";s:25:\"additional_search_queries\";s:150:\"mobile, theme, fast images, fast image, image, lazy, lazy load, lazyload, images, lazy images, thumbnail, image lazy load, lazy loading, load, loading\";s:12:\"plan_classes\";s:0:\"\";}s:32:\"8e46c72906c928eca634ac2c8b1bc84f\";a:14:{s:4:\"name\";s:5:\"Likes\";s:11:\"description\";s:63:\"Give visitors an easy way to show they appreciate your content.\";s:4:\"sort\";s:2:\"23\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"2.2\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:2:\"No\";s:11:\"module_tags\";s:6:\"Social\";s:7:\"feature\";s:10:\"Engagement\";s:25:\"additional_search_queries\";s:26:\"like, likes, wordpress.com\";s:12:\"plan_classes\";s:0:\"\";}s:32:\"2df2264a07aff77e0556121e33349dce\";a:14:{s:4:\"name\";s:8:\"Markdown\";s:11:\"description\";s:50:\"Write posts or pages in plain-text Markdown syntax\";s:4:\"sort\";s:2:\"31\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"2.8\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:2:\"No\";s:13:\"auto_activate\";s:2:\"No\";s:11:\"module_tags\";s:7:\"Writing\";s:7:\"feature\";s:7:\"Writing\";s:25:\"additional_search_queries\";s:12:\"md, markdown\";s:12:\"plan_classes\";s:0:\"\";}s:32:\"0337eacae47d30c946cb9fc4e5ece649\";a:14:{s:4:\"name\";s:50:\"WordPress.com Toolbar and Dashboard customizations\";s:11:\"description\";s:201:\"Replaces the admin bar with a useful toolbar to quickly manage your site via WordPress.com. Also adds additional customizations to the WPAdmin dashboard experience for better compatibility with WP.com.\";s:4:\"sort\";s:2:\"38\";s:20:\"recommendation_order\";s:2:\"16\";s:10:\"introduced\";s:3:\"4.8\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:2:\"No\";s:11:\"module_tags\";s:7:\"General\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:33:\"adminbar, masterbar, colorschemes\";s:12:\"plan_classes\";s:0:\"\";}s:32:\"cb5d81445061b89d19cb9c7754697a39\";a:14:{s:4:\"name\";s:0:\"\";s:11:\"description\";s:0:\"\";s:4:\"sort\";s:0:\"\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:0:\"\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:0:\"\";s:13:\"auto_activate\";s:0:\"\";s:11:\"module_tags\";s:0:\"\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:0:\"\";s:12:\"plan_classes\";s:0:\"\";}s:32:\"ea0fbbd64080c81a90a784924603588c\";a:14:{s:4:\"name\";s:0:\"\";s:11:\"description\";s:0:\"\";s:4:\"sort\";s:0:\"\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:0:\"\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:0:\"\";s:13:\"auto_activate\";s:0:\"\";s:11:\"module_tags\";s:0:\"\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:0:\"\";s:12:\"plan_classes\";s:0:\"\";}s:32:\"5c53fdb3633ba3232f60180116900273\";a:14:{s:4:\"name\";s:0:\"\";s:11:\"description\";s:0:\"\";s:4:\"sort\";s:0:\"\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:0:\"\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:0:\"\";s:13:\"auto_activate\";s:0:\"\";s:11:\"module_tags\";s:0:\"\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:0:\"\";s:12:\"plan_classes\";s:0:\"\";}s:32:\"40b97d9ce396339d3e8e46b833a045b5\";a:14:{s:4:\"name\";s:0:\"\";s:11:\"description\";s:0:\"\";s:4:\"sort\";s:0:\"\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:0:\"\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:0:\"\";s:13:\"auto_activate\";s:0:\"\";s:11:\"module_tags\";s:0:\"\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:0:\"\";s:12:\"plan_classes\";s:0:\"\";}s:32:\"0739df64747f2d02c140f23ce6c19cd8\";a:14:{s:4:\"name\";s:0:\"\";s:11:\"description\";s:0:\"\";s:4:\"sort\";s:0:\"\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:0:\"\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:0:\"\";s:13:\"auto_activate\";s:0:\"\";s:11:\"module_tags\";s:0:\"\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:0:\"\";s:12:\"plan_classes\";s:0:\"\";}s:32:\"c54bb0a65b39f1316da8632197a88a4e\";a:14:{s:4:\"name\";s:7:\"Monitor\";s:11:\"description\";s:117:\"Jetpack’s downtime monitoring will continuously watch your site and alert you the moment that downtime is detected.\";s:4:\"sort\";s:2:\"28\";s:20:\"recommendation_order\";s:2:\"10\";s:10:\"introduced\";s:3:\"2.6\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:2:\"No\";s:11:\"module_tags\";s:11:\"Recommended\";s:7:\"feature\";s:8:\"Security\";s:25:\"additional_search_queries\";s:123:\"monitor, uptime, downtime, monitoring, maintenance, maintenance mode, offline, site is down, site down, down, repair, error\";s:12:\"plan_classes\";s:0:\"\";}s:32:\"cc013f4c5480c7bdc1e7edb2f410bf3c\";a:14:{s:4:\"name\";s:13:\"Notifications\";s:11:\"description\";s:57:\"Receive instant notifications of site comments and likes.\";s:4:\"sort\";s:2:\"13\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"1.9\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:3:\"Yes\";s:11:\"module_tags\";s:5:\"Other\";s:7:\"feature\";s:7:\"General\";s:25:\"additional_search_queries\";s:62:\"notification, notifications, toolbar, adminbar, push, comments\";s:12:\"plan_classes\";s:0:\"\";}s:32:\"b3b34928b1e549bb52f866accc0450c5\";a:14:{s:4:\"name\";s:9:\"Asset CDN\";s:11:\"description\";s:154:\"Jetpack’s Site Accelerator loads your site faster by optimizing your images and serving your images and static files from our global network of servers.\";s:4:\"sort\";s:2:\"26\";s:20:\"recommendation_order\";s:1:\"1\";s:10:\"introduced\";s:3:\"6.6\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:2:\"No\";s:13:\"auto_activate\";s:2:\"No\";s:11:\"module_tags\";s:42:\"Photos and Videos, Appearance, Recommended\";s:7:\"feature\";s:23:\"Recommended, Appearance\";s:25:\"additional_search_queries\";s:160:\"site accelerator, accelerate, static, assets, javascript, css, files, performance, cdn, bandwidth, content delivery network, pagespeed, combine js, optimize css\";s:12:\"plan_classes\";s:0:\"\";}s:32:\"714284944f56d6936a40f3309900bc8e\";a:14:{s:4:\"name\";s:9:\"Image CDN\";s:11:\"description\";s:141:\"Mirrors and serves your images from our free and fast image CDN, improving your site’s performance with no additional load on your servers.\";s:4:\"sort\";s:2:\"25\";s:20:\"recommendation_order\";s:1:\"1\";s:10:\"introduced\";s:3:\"2.0\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:2:\"No\";s:11:\"module_tags\";s:42:\"Photos and Videos, Appearance, Recommended\";s:7:\"feature\";s:23:\"Recommended, Appearance\";s:25:\"additional_search_queries\";s:171:\"photon, photo cdn, image cdn, speed, compression, resize, responsive images, responsive, content distribution network, optimize, page speed, image optimize, photon jetpack\";s:12:\"plan_classes\";s:0:\"\";}s:32:\"348754bc914ee02c72d9af445627784c\";a:14:{s:4:\"name\";s:0:\"\";s:11:\"description\";s:0:\"\";s:4:\"sort\";s:0:\"\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:0:\"\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:0:\"\";s:13:\"auto_activate\";s:0:\"\";s:11:\"module_tags\";s:0:\"\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:0:\"\";s:12:\"plan_classes\";s:0:\"\";}s:32:\"041704e207c4c59eea93e0499c908bff\";a:14:{s:4:\"name\";s:13:\"Post by email\";s:11:\"description\";s:33:\"Publish posts by sending an email\";s:4:\"sort\";s:2:\"14\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"2.0\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:2:\"No\";s:11:\"module_tags\";s:7:\"Writing\";s:7:\"feature\";s:7:\"Writing\";s:25:\"additional_search_queries\";s:20:\"post by email, email\";s:12:\"plan_classes\";s:0:\"\";}s:32:\"26e6cb3e08a6cfd0811c17e7c633c72c\";a:14:{s:4:\"name\";s:7:\"Protect\";s:11:\"description\";s:151:\"Enabling brute force protection will prevent bots and hackers from attempting to log in to your website with common username and password combinations.\";s:4:\"sort\";s:1:\"1\";s:20:\"recommendation_order\";s:1:\"4\";s:10:\"introduced\";s:3:\"3.4\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:3:\"Yes\";s:11:\"module_tags\";s:11:\"Recommended\";s:7:\"feature\";s:8:\"Security\";s:25:\"additional_search_queries\";s:173:\"security, jetpack protect, secure, protection, botnet, brute force, protect, login, bot, password, passwords, strong passwords, strong password, wp-login.php,  protect admin\";s:12:\"plan_classes\";s:0:\"\";}s:32:\"915a504082f797395713fd01e0e2e713\";a:14:{s:4:\"name\";s:9:\"Publicize\";s:11:\"description\";s:128:\"Publicize makes it easy to share your site’s posts on several social media networks automatically when you publish a new post.\";s:4:\"sort\";s:2:\"10\";s:20:\"recommendation_order\";s:1:\"7\";s:10:\"introduced\";s:3:\"2.0\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:2:\"No\";s:11:\"module_tags\";s:19:\"Social, Recommended\";s:7:\"feature\";s:10:\"Engagement\";s:25:\"additional_search_queries\";s:220:\"facebook, jetpack publicize, twitter, tumblr, linkedin, social, tweet, connections, sharing, social media, automated, automated sharing, auto publish, auto tweet and like, auto tweet, facebook auto post, facebook posting\";s:12:\"plan_classes\";s:0:\"\";}s:32:\"9243c1a718566213f4eaf3b44cf14b07\";a:14:{s:4:\"name\";s:13:\"Related posts\";s:11:\"description\";s:113:\"Keep visitors engaged on your blog by highlighting relevant and new content at the bottom of each published post.\";s:4:\"sort\";s:2:\"29\";s:20:\"recommendation_order\";s:1:\"9\";s:10:\"introduced\";s:3:\"2.9\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:2:\"No\";s:11:\"module_tags\";s:11:\"Recommended\";s:7:\"feature\";s:10:\"Engagement\";s:25:\"additional_search_queries\";s:360:\"related, jetpack related posts, related posts for wordpress, related posts, popular posts, popular, related content, related post, contextual, context, contextual related posts, related articles, similar posts, easy related posts, related page, simple related posts, free related posts, related thumbnails, similar, engagement, yet another related posts plugin\";s:12:\"plan_classes\";s:0:\"\";}s:32:\"583e4cda5596ee1b28a19cde33f438be\";a:14:{s:4:\"name\";s:6:\"Search\";s:11:\"description\";s:102:\"Help visitors quickly find answers with highly relevant instant search results and powerful filtering.\";s:4:\"sort\";s:2:\"34\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"5.0\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:5:\"false\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:2:\"No\";s:11:\"module_tags\";s:0:\"\";s:7:\"feature\";s:6:\"Search\";s:25:\"additional_search_queries\";s:110:\"search, elastic, elastic search, elasticsearch, fast search, search results, search performance, google search\";s:12:\"plan_classes\";s:18:\"business, complete\";}s:32:\"15346c1f7f2a5f29d34378774ecfa830\";a:14:{s:4:\"name\";s:9:\"SEO Tools\";s:11:\"description\";s:50:\"Better results on search engines and social media.\";s:4:\"sort\";s:2:\"35\";s:20:\"recommendation_order\";s:2:\"15\";s:10:\"introduced\";s:3:\"4.4\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:2:\"No\";s:11:\"module_tags\";s:18:\"Social, Appearance\";s:7:\"feature\";s:7:\"Traffic\";s:25:\"additional_search_queries\";s:81:\"search engine optimization, social preview, meta description, custom title format\";s:12:\"plan_classes\";s:0:\"\";}s:32:\"72a0ff4cfae86074a7cdd2dcd432ef11\";a:14:{s:4:\"name\";s:7:\"Sharing\";s:11:\"description\";s:120:\"Add Twitter, Facebook and Google+ buttons at the bottom of each post, making it easy for visitors to share your content.\";s:4:\"sort\";s:1:\"7\";s:20:\"recommendation_order\";s:1:\"6\";s:10:\"introduced\";s:3:\"1.1\";s:7:\"changed\";s:3:\"1.2\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:2:\"No\";s:13:\"auto_activate\";s:2:\"No\";s:11:\"module_tags\";s:19:\"Social, Recommended\";s:7:\"feature\";s:10:\"Engagement\";s:25:\"additional_search_queries\";s:229:\"share, sharing, sharedaddy, social buttons, buttons, share facebook, share twitter, social media sharing, social media share, social share, icons, email, facebook, twitter, linkedin, pinterest, pocket, social widget, social media\";s:12:\"plan_classes\";s:0:\"\";}s:32:\"bb8c6c190aaec212a7ab6e940165af4d\";a:14:{s:4:\"name\";s:16:\"Shortcode Embeds\";s:11:\"description\";s:177:\"Shortcodes are WordPress-specific markup that let you add media from popular sites. This feature is no longer necessary as the editor now handles media embeds rather gracefully.\";s:4:\"sort\";s:1:\"3\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"1.1\";s:7:\"changed\";s:3:\"1.2\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:2:\"No\";s:13:\"auto_activate\";s:2:\"No\";s:11:\"module_tags\";s:46:\"Photos and Videos, Social, Writing, Appearance\";s:7:\"feature\";s:7:\"Writing\";s:25:\"additional_search_queries\";s:236:\"shortcodes, shortcode, embeds, media, bandcamp, dailymotion, facebook, flickr, google calendars, google maps, google+, polldaddy, recipe, recipes, scribd, slideshare, slideshow, slideshows, soundcloud, ted, twitter, vimeo, vine, youtube\";s:12:\"plan_classes\";s:0:\"\";}s:32:\"1abd31fe07ae4fb0f8bb57dc24592219\";a:14:{s:4:\"name\";s:16:\"WP.me Shortlinks\";s:11:\"description\";s:47:\"Generates shorter links using the wp.me domain.\";s:4:\"sort\";s:1:\"8\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"1.1\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:2:\"No\";s:11:\"module_tags\";s:6:\"Social\";s:7:\"feature\";s:7:\"Writing\";s:25:\"additional_search_queries\";s:17:\"shortlinks, wp.me\";s:12:\"plan_classes\";s:0:\"\";}s:32:\"cae5f097f8d658e0b0ae50733d7c6476\";a:14:{s:4:\"name\";s:8:\"Sitemaps\";s:11:\"description\";s:50:\"Make it easy for search engines to find your site.\";s:4:\"sort\";s:2:\"13\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"3.9\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:2:\"No\";s:13:\"auto_activate\";s:2:\"No\";s:11:\"module_tags\";s:20:\"Recommended, Traffic\";s:7:\"feature\";s:11:\"Recommended\";s:25:\"additional_search_queries\";s:39:\"sitemap, traffic, search, site map, seo\";s:12:\"plan_classes\";s:0:\"\";}s:32:\"e9b8318133b2f95e7906cedb3557a87d\";a:14:{s:4:\"name\";s:14:\"Secure Sign On\";s:11:\"description\";s:63:\"Allow users to log in to this site using WordPress.com accounts\";s:4:\"sort\";s:2:\"30\";s:20:\"recommendation_order\";s:1:\"5\";s:10:\"introduced\";s:3:\"2.6\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:2:\"No\";s:11:\"module_tags\";s:10:\"Developers\";s:7:\"feature\";s:8:\"Security\";s:25:\"additional_search_queries\";s:51:\"sso, single sign on, login, log in, 2fa, two-factor\";s:12:\"plan_classes\";s:0:\"\";}s:32:\"17e66a12031ccf11d8d45ceee0955f05\";a:14:{s:4:\"name\";s:10:\"Site Stats\";s:11:\"description\";s:44:\"Collect valuable traffic stats and insights.\";s:4:\"sort\";s:1:\"1\";s:20:\"recommendation_order\";s:1:\"2\";s:10:\"introduced\";s:3:\"1.1\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:3:\"Yes\";s:11:\"module_tags\";s:23:\"Site Stats, Recommended\";s:7:\"feature\";s:10:\"Engagement\";s:25:\"additional_search_queries\";s:54:\"statistics, tracking, analytics, views, traffic, stats\";s:12:\"plan_classes\";s:0:\"\";}s:32:\"346cf9756e7c1252acecb9a8ca81a21c\";a:14:{s:4:\"name\";s:13:\"Subscriptions\";s:11:\"description\";s:58:\"Let visitors subscribe to new posts and comments via email\";s:4:\"sort\";s:1:\"9\";s:20:\"recommendation_order\";s:1:\"8\";s:10:\"introduced\";s:3:\"1.2\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:2:\"No\";s:11:\"module_tags\";s:6:\"Social\";s:7:\"feature\";s:10:\"Engagement\";s:25:\"additional_search_queries\";s:74:\"subscriptions, subscription, email, follow, followers, subscribers, signup\";s:12:\"plan_classes\";s:0:\"\";}s:32:\"4f84d218792a6efa06ed6feae09c4dd5\";a:14:{s:4:\"name\";s:0:\"\";s:11:\"description\";s:0:\"\";s:4:\"sort\";s:0:\"\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:0:\"\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:0:\"\";s:13:\"auto_activate\";s:0:\"\";s:11:\"module_tags\";s:0:\"\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:0:\"\";s:12:\"plan_classes\";s:0:\"\";}s:32:\"ca086af79d0d9dccacc934ccff5b4fd7\";a:14:{s:4:\"name\";s:15:\"Tiled Galleries\";s:11:\"description\";s:61:\"Display image galleries in a variety of elegant arrangements.\";s:4:\"sort\";s:2:\"24\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"2.1\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:2:\"No\";s:13:\"auto_activate\";s:2:\"No\";s:11:\"module_tags\";s:17:\"Photos and Videos\";s:7:\"feature\";s:10:\"Appearance\";s:25:\"additional_search_queries\";s:43:\"gallery, tiles, tiled, grid, mosaic, images\";s:12:\"plan_classes\";s:0:\"\";}s:32:\"43c24feb7c541c376af93e0251c1a261\";a:14:{s:4:\"name\";s:20:\"Backups and Scanning\";s:11:\"description\";s:100:\"Protect your site with daily or real-time backups and automated virus scanning and threat detection.\";s:4:\"sort\";s:2:\"32\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:5:\"0:1.2\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:5:\"false\";s:4:\"free\";s:5:\"false\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:2:\"No\";s:11:\"module_tags\";s:0:\"\";s:7:\"feature\";s:16:\"Security, Health\";s:25:\"additional_search_queries\";s:386:\"backup, cloud backup, database backup, restore, wordpress backup, backup plugin, wordpress backup plugin, back up, backup wordpress, backwpup, vaultpress, backups, off-site backups, offsite backup, offsite, off-site, antivirus, malware scanner, security, virus, viruses, prevent viruses, scan, anti-virus, antimalware, protection, safe browsing, malware, wp security, wordpress security\";s:12:\"plan_classes\";s:47:\"personal, business, premium, security, complete\";}s:32:\"b9396d8038fc29140b499098d2294d79\";a:14:{s:4:\"name\";s:17:\"Site verification\";s:11:\"description\";s:58:\"Establish your site\'s authenticity with external services.\";s:4:\"sort\";s:2:\"33\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"3.0\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:2:\"No\";s:13:\"auto_activate\";s:3:\"Yes\";s:11:\"module_tags\";s:0:\"\";s:7:\"feature\";s:10:\"Engagement\";s:25:\"additional_search_queries\";s:56:\"webmaster, seo, google, bing, pinterest, search, console\";s:12:\"plan_classes\";s:0:\"\";}s:32:\"afe184082e106c1bdfe1ee844f98aef3\";a:14:{s:4:\"name\";s:10:\"VideoPress\";s:11:\"description\";s:101:\"Save on hosting storage and bandwidth costs by streaming fast, ad-free video from our global network.\";s:4:\"sort\";s:2:\"27\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"2.5\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:5:\"false\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:0:\"\";s:11:\"module_tags\";s:17:\"Photos and Videos\";s:7:\"feature\";s:7:\"Writing\";s:25:\"additional_search_queries\";s:118:\"video, videos, videopress, video gallery, video player, videoplayer, mobile video, vimeo, youtube, html5 video, stream\";s:12:\"plan_classes\";s:37:\"business, premium, security, complete\";}s:32:\"44637d43460370af9a1b31ce3ccec0cd\";a:14:{s:4:\"name\";s:17:\"Widget Visibility\";s:11:\"description\";s:42:\"Control where widgets appear on your site.\";s:4:\"sort\";s:2:\"17\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"2.4\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:2:\"No\";s:13:\"auto_activate\";s:2:\"No\";s:11:\"module_tags\";s:10:\"Appearance\";s:7:\"feature\";s:10:\"Appearance\";s:25:\"additional_search_queries\";s:54:\"widget visibility, logic, conditional, widgets, widget\";s:12:\"plan_classes\";s:0:\"\";}s:32:\"694c105a5c3b659acfcddad220048d08\";a:14:{s:4:\"name\";s:21:\"Extra Sidebar Widgets\";s:11:\"description\";s:49:\"Provides additional widgets for use on your site.\";s:4:\"sort\";s:1:\"4\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"1.2\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:2:\"No\";s:13:\"auto_activate\";s:2:\"No\";s:11:\"module_tags\";s:18:\"Social, Appearance\";s:7:\"feature\";s:10:\"Appearance\";s:25:\"additional_search_queries\";s:65:\"widget, widgets, facebook, gallery, twitter, gravatar, image, rss\";s:12:\"plan_classes\";s:0:\"\";}s:32:\"21b59e7bb3fe0784e7525ad11ad8a8f6\";a:14:{s:4:\"name\";s:21:\"WooCommerce Analytics\";s:11:\"description\";s:53:\"Enhanced analytics for WooCommerce and Jetpack users.\";s:4:\"sort\";s:2:\"13\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"8.4\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:3:\"Yes\";s:11:\"module_tags\";s:18:\"Other, Recommended\";s:7:\"feature\";s:10:\"Engagement\";s:25:\"additional_search_queries\";s:69:\"woocommerce, analytics, stats, statistics, tracking, analytics, views\";s:12:\"plan_classes\";s:0:\"\";}s:32:\"ae15da72c5802d72f320640bad669561\";a:14:{s:4:\"name\";s:3:\"Ads\";s:11:\"description\";s:60:\"Earn income by allowing Jetpack to display high quality ads.\";s:4:\"sort\";s:1:\"1\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:5:\"4.5.0\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:2:\"No\";s:11:\"module_tags\";s:19:\"Traffic, Appearance\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:26:\"advertising, ad codes, ads\";s:12:\"plan_classes\";s:37:\"premium, business, security, complete\";}}", "no");
INSERT INTO `psm_options` VALUES("6930", "_elementor_settings_update_time", "1632247420", "yes");
INSERT INTO `psm_options` VALUES("6931", "elementor_cpt_support", "a:4:{i:0;s:4:\"post\";i:1;s:4:\"page\";i:2;s:14:\"e-landing-page\";i:3;s:7:\"product\";}", "yes");
INSERT INTO `psm_options` VALUES("6932", "elementor_disable_color_schemes", "", "yes");
INSERT INTO `psm_options` VALUES("6933", "elementor_disable_typography_schemes", "", "yes");
INSERT INTO `psm_options` VALUES("6934", "elementor_notice", "", "yes");
INSERT INTO `psm_options` VALUES("6935", "elementor_pro_recaptcha_site_key", "", "yes");
INSERT INTO `psm_options` VALUES("6936", "elementor_pro_recaptcha_secret_key", "", "yes");
INSERT INTO `psm_options` VALUES("6937", "elementor_pro_recaptcha_v3_site_key", "", "yes");
INSERT INTO `psm_options` VALUES("6938", "elementor_pro_recaptcha_v3_secret_key", "", "yes");
INSERT INTO `psm_options` VALUES("6939", "elementor_pro_recaptcha_v3_threshold", "0.5", "yes");
INSERT INTO `psm_options` VALUES("6940", "elementor_pro_facebook_app_id", "", "yes");
INSERT INTO `psm_options` VALUES("6941", "elementor_pro_mailchimp_api_key", "", "yes");
INSERT INTO `psm_options` VALUES("6942", "elementor_validate_api_data", "", "yes");
INSERT INTO `psm_options` VALUES("6943", "elementor_pro_drip_api_token", "", "yes");
INSERT INTO `psm_options` VALUES("6944", "elementor_pro_activecampaign_api_key", "", "yes");
INSERT INTO `psm_options` VALUES("6945", "elementor_pro_activecampaign_api_url", "", "yes");
INSERT INTO `psm_options` VALUES("6946", "elementor_pro_getresponse_api_key", "", "yes");
INSERT INTO `psm_options` VALUES("6947", "elementor_pro_convertkit_api_key", "", "yes");
INSERT INTO `psm_options` VALUES("6948", "elementor_pro_mailerlite_api_key", "", "yes");
INSERT INTO `psm_options` VALUES("6949", "elementor_use_mini_cart_template", "initial", "yes");
INSERT INTO `psm_options` VALUES("6950", "elementor_typekit-kit-id", "", "yes");
INSERT INTO `psm_options` VALUES("6951", "elementor_font_awesome_pro_kit_id", "", "yes");
INSERT INTO `psm_options` VALUES("6952", "elementor_css_print_method", "external", "yes");
INSERT INTO `psm_options` VALUES("6953", "elementor_editor_break_lines", "", "yes");
INSERT INTO `psm_options` VALUES("6954", "elementor_unfiltered_files_upload", "", "yes");
INSERT INTO `psm_options` VALUES("6955", "elementor_load_fa4_shim", "", "yes");
INSERT INTO `psm_options` VALUES("6956", "elementor_experiment-e_dom_optimization", "default", "yes");
INSERT INTO `psm_options` VALUES("6957", "elementor_experiment-e_optimized_assets_loading", "default", "yes");
INSERT INTO `psm_options` VALUES("6958", "elementor_experiment-a11y_improvements", "default", "yes");
INSERT INTO `psm_options` VALUES("6959", "elementor_experiment-landing-pages", "default", "yes");
INSERT INTO `psm_options` VALUES("6960", "elementor_experiment-form-submissions", "default", "yes");
INSERT INTO `psm_options` VALUES("6970", "auto_update_plugins", "a:3:{i:0;s:23:\"elementor/elementor.php\";i:1;s:58:\"creative-mail-by-constant-contact/creative-mail-plugin.php\";i:2;s:36:\"contact-form-7/wp-contact-form-7.php\";}", "no");
INSERT INTO `psm_options` VALUES("6978", "hfe_plugin_is_activated", "yes", "yes");
INSERT INTO `psm_options` VALUES("6979", "_hfe_db_version", "1.6.4", "yes");
INSERT INTO `psm_options` VALUES("6980", "bsf_analytics_installed_time", "1632247618", "no");
INSERT INTO `psm_options` VALUES("7015", "ce4wp_contacts_db_version", "1.0", "yes");
INSERT INTO `psm_options` VALUES("7024", "elementor_controls_usage", "a:8:{s:7:\"wp-post\";a:7:{s:14:\"image-carousel\";a:2:{s:5:\"count\";i:1;s:8:\"controls\";a:2:{s:7:\"content\";a:1:{s:22:\"section_image_carousel\";a:8:{s:8:\"carousel\";i:1;s:14:\"thumbnail_size\";i:1;s:14:\"slides_to_show\";i:1;s:16:\"slides_to_scroll\";i:1;s:10:\"navigation\";i:1;s:21:\"slides_to_show_tablet\";i:1;s:23:\"slides_to_scroll_tablet\";i:1;s:7:\"link_to\";i:1;}}s:5:\"style\";a:1:{s:19:\"section_style_image\";a:3:{s:22:\"gallery_vertical_align\";i:1;s:20:\"image_spacing_custom\";i:1;s:19:\"image_border_radius\";i:1;}}}}s:6:\"column\";a:2:{s:5:\"count\";i:7;s:8:\"controls\";a:3:{s:5:\"style\";a:1:{s:14:\"section_border\";a:3:{s:13:\"border_border\";i:1;s:12:\"border_width\";i:1;s:12:\"border_color\";i:1;}}s:8:\"advanced\";a:1:{s:16:\"section_advanced\";a:6:{s:7:\"padding\";i:3;s:14:\"padding_tablet\";i:1;s:14:\"padding_mobile\";i:1;s:13:\"margin_mobile\";i:2;s:6:\"margin\";i:1;s:13:\"margin_tablet\";i:1;}}s:6:\"layout\";a:1:{s:6:\"layout\";a:2:{s:12:\"_inline_size\";i:3;s:19:\"_inline_size_tablet\";i:3;}}}}s:7:\"section\";a:2:{s:5:\"count\";i:5;s:8:\"controls\";a:3:{s:6:\"layout\";a:2:{s:14:\"section_layout\";a:4:{s:6:\"height\";i:2;s:13:\"custom_height\";i:2;s:6:\"_title\";i:2;s:13:\"content_width\";i:4;}s:17:\"section_structure\";a:1:{s:9:\"structure\";i:1;}}s:5:\"style\";a:3:{s:18:\"section_background\";a:7:{s:21:\"background_background\";i:2;s:16:\"background_color\";i:1;s:16:\"background_image\";i:1;s:17:\"background_repeat\";i:1;s:15:\"background_size\";i:1;s:26:\"background_position_tablet\";i:1;s:26:\"background_position_mobile\";i:1;}s:14:\"section_border\";a:3:{s:13:\"border_border\";i:1;s:12:\"border_width\";i:1;s:12:\"border_color\";i:1;}s:26:\"section_background_overlay\";a:3:{s:29:\"background_overlay_background\";i:1;s:24:\"background_overlay_color\";i:1;s:26:\"background_overlay_opacity\";i:1;}}s:8:\"advanced\";a:1:{s:16:\"section_advanced\";a:5:{s:7:\"padding\";i:1;s:13:\"margin_mobile\";i:2;s:14:\"padding_tablet\";i:1;s:6:\"margin\";i:1;s:13:\"margin_tablet\";i:1;}}}}s:11:\"text-editor\";a:2:{s:5:\"count\";i:1;s:8:\"controls\";a:3:{s:5:\"style\";a:1:{s:13:\"section_style\";a:8:{s:5:\"align\";i:1;s:10:\"text_color\";i:1;s:21:\"typography_typography\";i:1;s:22:\"typography_font_family\";i:1;s:20:\"typography_font_size\";i:1;s:22:\"typography_font_weight\";i:1;s:12:\"align_tablet\";i:1;s:25:\"typography_text_transform\";i:1;}}s:7:\"content\";a:1:{s:14:\"section_editor\";a:1:{s:6:\"editor\";i:1;}}s:8:\"advanced\";a:1:{s:14:\"_section_style\";a:2:{s:14:\"_margin_mobile\";i:1;s:15:\"_padding_mobile\";i:1;}}}}s:9:\"icon-list\";a:2:{s:5:\"count\";i:3;s:8:\"controls\";a:3:{s:7:\"content\";a:1:{s:12:\"section_icon\";a:2:{s:4:\"view\";i:1;s:9:\"icon_list\";i:3;}}s:5:\"style\";a:3:{s:17:\"section_icon_list\";a:6:{s:13:\"space_between\";i:3;s:10:\"icon_align\";i:1;s:17:\"icon_align_tablet\";i:3;s:20:\"space_between_mobile\";i:1;s:20:\"space_between_tablet\";i:1;s:17:\"icon_align_mobile\";i:2;}s:18:\"section_icon_style\";a:4:{s:10:\"icon_color\";i:3;s:9:\"icon_size\";i:1;s:16:\"icon_color_hover\";i:1;s:16:\"icon_size_mobile\";i:1;}s:18:\"section_text_style\";a:6:{s:10:\"text_color\";i:2;s:11:\"text_indent\";i:2;s:26:\"icon_typography_typography\";i:2;s:27:\"icon_typography_font_family\";i:2;s:25:\"icon_typography_font_size\";i:2;s:27:\"icon_typography_font_weight\";i:2;}}s:8:\"advanced\";a:1:{s:14:\"_section_style\";a:1:{s:7:\"_margin\";i:1;}}}}s:7:\"heading\";a:2:{s:5:\"count\";i:4;s:8:\"controls\";a:2:{s:7:\"content\";a:1:{s:13:\"section_title\";a:5:{s:5:\"title\";i:4;s:5:\"align\";i:4;s:12:\"align_tablet\";i:3;s:11:\"header_size\";i:3;s:12:\"align_mobile\";i:3;}}s:5:\"style\";a:1:{s:19:\"section_title_style\";a:6:{s:11:\"title_color\";i:4;s:21:\"typography_typography\";i:4;s:22:\"typography_font_family\";i:4;s:20:\"typography_font_size\";i:4;s:22:\"typography_font_weight\";i:4;s:25:\"typography_text_transform\";i:4;}}}}s:8:\"nav-menu\";a:2:{s:5:\"count\";i:1;s:8:\"controls\";a:3:{s:7:\"content\";a:1:{s:14:\"section_layout\";a:4:{s:6:\"layout\";i:1;s:11:\"align_items\";i:1;s:8:\"dropdown\";i:1;s:10:\"text_align\";i:1;}}s:5:\"style\";a:3:{s:23:\"section_style_main-menu\";a:11:{s:26:\"menu_typography_typography\";i:1;s:27:\"menu_typography_font_family\";i:1;s:25:\"menu_typography_font_size\";i:1;s:27:\"menu_typography_font_weight\";i:1;s:30:\"menu_typography_text_transform\";i:1;s:15:\"color_menu_item\";i:1;s:21:\"color_menu_item_hover\";i:1;s:13:\"pointer_width\";i:1;s:28:\"padding_horizontal_menu_item\";i:1;s:26:\"padding_vertical_menu_item\";i:1;s:18:\"menu_space_between\";i:1;}s:22:\"section_style_dropdown\";a:18:{s:19:\"color_dropdown_item\";i:1;s:25:\"color_dropdown_item_hover\";i:1;s:36:\"background_color_dropdown_item_hover\";i:1;s:26:\"color_dropdown_item_active\";i:1;s:37:\"background_color_dropdown_item_active\";i:1;s:30:\"dropdown_typography_typography\";i:1;s:31:\"dropdown_typography_font_family\";i:1;s:29:\"dropdown_typography_font_size\";i:1;s:36:\"dropdown_typography_font_size_mobile\";i:1;s:31:\"dropdown_typography_font_weight\";i:1;s:35:\"dropdown_box_shadow_box_shadow_type\";i:1;s:30:\"dropdown_box_shadow_box_shadow\";i:1;s:32:\"padding_horizontal_dropdown_item\";i:1;s:30:\"padding_vertical_dropdown_item\";i:1;s:37:\"padding_vertical_dropdown_item_mobile\";i:1;s:21:\"dropdown_top_distance\";i:1;s:28:\"dropdown_top_distance_tablet\";i:1;s:28:\"dropdown_top_distance_mobile\";i:1;}s:12:\"style_toggle\";a:2:{s:12:\"toggle_color\";i:1;s:23:\"toggle_background_color\";i:1;}}s:8:\"advanced\";a:1:{s:14:\"_section_style\";a:1:{s:14:\"_margin_mobile\";i:1;}}}}}s:7:\"wp-page\";a:13:{s:6:\"spacer\";a:2:{s:5:\"count\";i:9;s:8:\"controls\";a:2:{s:7:\"content\";a:1:{s:14:\"section_spacer\";a:3:{s:5:\"space\";i:6;s:12:\"space_mobile\";i:3;s:12:\"space_tablet\";i:1;}}s:8:\"advanced\";a:2:{s:15:\"_section_border\";a:1:{s:22:\"_box_shadow_box_shadow\";i:3;}s:14:\"_section_style\";a:1:{s:15:\"_padding_mobile\";i:1;}}}}s:7:\"heading\";a:2:{s:5:\"count\";i:34;s:8:\"controls\";a:3:{s:7:\"content\";a:1:{s:13:\"section_title\";a:7:{s:5:\"title\";i:34;s:11:\"header_size\";i:24;s:12:\"align_mobile\";i:20;s:5:\"align\";i:13;s:4:\"size\";i:11;s:4:\"link\";i:5;s:12:\"align_tablet\";i:5;}}s:5:\"style\";a:1:{s:19:\"section_title_style\";a:17:{s:11:\"title_color\";i:33;s:21:\"typography_typography\";i:34;s:20:\"typography_font_size\";i:34;s:27:\"typography_font_size_mobile\";i:20;s:22:\"typography_font_family\";i:34;s:22:\"typography_font_weight\";i:29;s:25:\"typography_text_transform\";i:15;s:22:\"typography_line_height\";i:9;s:25:\"typography_letter_spacing\";i:9;s:27:\"typography_font_size_tablet\";i:14;s:23:\"text_shadow_text_shadow\";i:2;s:29:\"typography_line_height_tablet\";i:5;s:29:\"typography_line_height_mobile\";i:5;s:32:\"typography_letter_spacing_tablet\";i:5;s:32:\"typography_letter_spacing_mobile\";i:5;s:26:\"typography_text_decoration\";i:1;s:28:\"text_shadow_text_shadow_type\";i:1;}}s:8:\"advanced\";a:2:{s:15:\"_section_border\";a:1:{s:22:\"_box_shadow_box_shadow\";i:5;}s:14:\"_section_style\";a:2:{s:14:\"_margin_mobile\";i:1;s:7:\"_margin\";i:1;}}}}s:6:\"column\";a:2:{s:5:\"count\";i:66;s:8:\"controls\";a:3:{s:6:\"layout\";a:1:{s:6:\"layout\";a:7:{s:12:\"_inline_size\";i:36;s:19:\"_inline_size_tablet\";i:12;s:16:\"content_position\";i:5;s:19:\"_inline_size_mobile\";i:2;s:5:\"align\";i:1;s:21:\"space_between_widgets\";i:5;s:28:\"space_between_widgets_mobile\";i:2;}}s:8:\"advanced\";a:2:{s:16:\"section_advanced\";a:8:{s:7:\"padding\";i:26;s:14:\"padding_mobile\";i:24;s:6:\"margin\";i:9;s:14:\"padding_tablet\";i:15;s:13:\"margin_mobile\";i:7;s:13:\"margin_tablet\";i:7;s:9:\"screen_sm\";i:11;s:15:\"screen_sm_width\";i:11;}s:15:\"section_effects\";a:0:{}}s:5:\"style\";a:3:{s:14:\"section_border\";a:2:{s:21:\"box_shadow_box_shadow\";i:12;s:26:\"box_shadow_box_shadow_type\";i:1;}s:13:\"section_style\";a:8:{s:21:\"background_background\";i:7;s:16:\"background_color\";i:3;s:16:\"background_image\";i:1;s:19:\"background_position\";i:1;s:17:\"background_repeat\";i:1;s:15:\"background_size\";i:1;s:28:\"background_slideshow_gallery\";i:1;s:37:\"background_slideshow_slide_transition\";i:1;}s:12:\"section_typo\";a:1:{s:10:\"text_align\";i:2;}}}}s:7:\"section\";a:2:{s:5:\"count\";i:41;s:8:\"controls\";a:3:{s:6:\"layout\";a:2:{s:14:\"section_layout\";a:12:{s:13:\"content_width\";i:28;s:13:\"custom_height\";i:15;s:16:\"content_position\";i:20;s:6:\"_title\";i:25;s:6:\"layout\";i:10;s:6:\"height\";i:4;s:15:\"stretch_section\";i:3;s:3:\"gap\";i:4;s:19:\"custom_height_inner\";i:2;s:15:\"column_position\";i:2;s:20:\"custom_height_tablet\";i:1;s:20:\"custom_height_mobile\";i:2;}s:17:\"section_structure\";a:1:{s:9:\"structure\";i:22;}}s:5:\"style\";a:5:{s:18:\"section_background\";a:8:{s:21:\"background_background\";i:20;s:16:\"background_color\";i:13;s:28:\"background_slideshow_gallery\";i:7;s:16:\"background_image\";i:3;s:19:\"background_position\";i:4;s:17:\"background_repeat\";i:4;s:15:\"background_size\";i:5;s:21:\"background_attachment\";i:1;}s:26:\"section_background_overlay\";a:5:{s:29:\"background_overlay_background\";i:10;s:24:\"background_overlay_color\";i:7;s:26:\"background_overlay_opacity\";i:14;s:24:\"background_overlay_image\";i:2;s:23:\"background_overlay_size\";i:2;}s:21:\"section_shape_divider\";a:1:{s:17:\"shape_divider_top\";i:2;}s:14:\"section_border\";a:1:{s:21:\"box_shadow_box_shadow\";i:7;}s:12:\"section_typo\";a:1:{s:10:\"text_align\";i:1;}}s:8:\"advanced\";a:3:{s:16:\"section_advanced\";a:5:{s:7:\"padding\";i:23;s:14:\"padding_tablet\";i:21;s:14:\"padding_mobile\";i:15;s:6:\"margin\";i:10;s:13:\"margin_tablet\";i:3;}s:19:\"_section_responsive\";a:2:{s:20:\"reverse_order_mobile\";i:7;s:20:\"reverse_order_tablet\";i:1;}s:15:\"section_effects\";a:5:{s:29:\"motion_fx_motion_fx_scrolling\";i:1;s:27:\"motion_fx_translateY_effect\";i:1;s:30:\"motion_fx_translateY_direction\";i:1;s:26:\"motion_fx_translateY_speed\";i:1;s:34:\"motion_fx_translateY_affectedRange\";i:1;}}}}s:11:\"text-editor\";a:2:{s:5:\"count\";i:23;s:8:\"controls\";a:3:{s:7:\"content\";a:1:{s:14:\"section_editor\";a:1:{s:6:\"editor\";i:23;}}s:5:\"style\";a:1:{s:13:\"section_style\";a:16:{s:12:\"align_mobile\";i:12;s:21:\"typography_typography\";i:22;s:22:\"typography_font_family\";i:22;s:10:\"text_color\";i:20;s:5:\"align\";i:7;s:20:\"typography_font_size\";i:13;s:22:\"typography_font_weight\";i:13;s:22:\"typography_line_height\";i:6;s:25:\"typography_letter_spacing\";i:7;s:27:\"typography_font_size_tablet\";i:6;s:27:\"typography_font_size_mobile\";i:7;s:29:\"typography_line_height_tablet\";i:4;s:29:\"typography_line_height_mobile\";i:4;s:32:\"typography_letter_spacing_tablet\";i:4;s:32:\"typography_letter_spacing_mobile\";i:4;s:12:\"align_tablet\";i:3;}}s:8:\"advanced\";a:2:{s:15:\"_section_border\";a:1:{s:22:\"_box_shadow_box_shadow\";i:4;}s:14:\"_section_style\";a:2:{s:8:\"_padding\";i:4;s:15:\"_padding_mobile\";i:2;}}}}s:6:\"button\";a:2:{s:5:\"count\";i:19;s:8:\"controls\";a:3:{s:7:\"content\";a:1:{s:14:\"section_button\";a:9:{s:4:\"text\";i:19;s:5:\"align\";i:17;s:12:\"align_mobile\";i:10;s:4:\"size\";i:11;s:10:\"icon_align\";i:9;s:13:\"selected_icon\";i:11;s:4:\"link\";i:19;s:11:\"icon_indent\";i:2;s:12:\"align_tablet\";i:1;}}s:5:\"style\";a:1:{s:13:\"section_style\";a:22:{s:21:\"typography_typography\";i:13;s:22:\"typography_font_family\";i:13;s:16:\"background_color\";i:19;s:29:\"button_background_hover_color\";i:15;s:13:\"border_radius\";i:12;s:27:\"typography_font_size_tablet\";i:4;s:17:\"button_text_color\";i:2;s:20:\"typography_font_size\";i:2;s:22:\"typography_font_weight\";i:3;s:25:\"typography_text_transform\";i:2;s:11:\"hover_color\";i:2;s:22:\"typography_line_height\";i:1;s:25:\"typography_letter_spacing\";i:1;s:13:\"border_border\";i:1;s:12:\"border_width\";i:1;s:25:\"button_hover_border_color\";i:1;s:27:\"typography_font_size_mobile\";i:1;s:29:\"typography_line_height_tablet\";i:1;s:29:\"typography_line_height_mobile\";i:1;s:32:\"typography_letter_spacing_tablet\";i:1;s:32:\"typography_letter_spacing_mobile\";i:1;s:28:\"text_shadow_text_shadow_type\";i:1;}}s:8:\"advanced\";a:2:{s:14:\"_section_style\";a:1:{s:8:\"_padding\";i:1;}s:15:\"_section_border\";a:1:{s:22:\"_box_shadow_box_shadow\";i:1;}}}}s:5:\"image\";a:2:{s:5:\"count\";i:24;s:8:\"controls\";a:3:{s:7:\"content\";a:1:{s:13:\"section_image\";a:7:{s:5:\"image\";i:24;s:10:\"image_size\";i:15;s:5:\"align\";i:5;s:12:\"align_tablet\";i:5;s:4:\"link\";i:1;s:12:\"align_mobile\";i:3;s:22:\"image_custom_dimension\";i:1;}}s:5:\"style\";a:2:{s:19:\"section_style_image\";a:12:{s:19:\"image_border_border\";i:7;s:18:\"image_border_width\";i:7;s:18:\"image_border_color\";i:7;s:32:\"image_box_shadow_box_shadow_type\";i:7;s:27:\"image_box_shadow_box_shadow\";i:8;s:5:\"width\";i:6;s:15:\"hover_animation\";i:7;s:5:\"space\";i:1;s:7:\"opacity\";i:1;s:12:\"space_mobile\";i:2;s:12:\"width_mobile\";i:3;s:12:\"width_tablet\";i:2;}s:21:\"section_style_caption\";a:9:{s:28:\"caption_typography_font_size\";i:1;s:30:\"caption_typography_line_height\";i:1;s:33:\"caption_typography_letter_spacing\";i:1;s:35:\"caption_typography_font_size_tablet\";i:1;s:35:\"caption_typography_font_size_mobile\";i:1;s:37:\"caption_typography_line_height_tablet\";i:1;s:37:\"caption_typography_line_height_mobile\";i:1;s:40:\"caption_typography_letter_spacing_tablet\";i:1;s:40:\"caption_typography_letter_spacing_mobile\";i:1;}}s:8:\"advanced\";a:4:{s:14:\"_section_style\";a:5:{s:15:\"_padding_mobile\";i:10;s:14:\"_margin_mobile\";i:1;s:8:\"_padding\";i:1;s:7:\"_margin\";i:1;s:14:\"_margin_tablet\";i:1;}s:19:\"_section_attributes\";a:1:{s:11:\"_attributes\";i:7;}s:15:\"_section_border\";a:4:{s:22:\"_box_shadow_box_shadow\";i:1;s:14:\"_border_border\";i:1;s:13:\"_border_width\";i:1;s:14:\"_border_radius\";i:1;}s:15:\"section_effects\";a:3:{s:30:\"motion_fx_translateY_direction\";i:1;s:26:\"motion_fx_translateY_speed\";i:1;s:23:\"motion_fx_opacity_range\";i:4;}}}}s:7:\"divider\";a:2:{s:5:\"count\";i:5;s:8:\"controls\";a:3:{s:5:\"style\";a:1:{s:21:\"section_divider_style\";a:3:{s:6:\"weight\";i:5;s:5:\"color\";i:5;s:3:\"gap\";i:5;}}s:7:\"content\";a:1:{s:15:\"section_divider\";a:7:{s:5:\"width\";i:5;s:4:\"text\";i:5;s:12:\"align_mobile\";i:2;s:5:\"style\";i:1;s:12:\"width_tablet\";i:1;s:12:\"align_tablet\";i:1;s:12:\"width_mobile\";i:1;}}s:8:\"advanced\";a:1:{s:15:\"_section_border\";a:1:{s:22:\"_box_shadow_box_shadow\";i:4;}}}}s:11:\"google_maps\";a:2:{s:5:\"count\";i:2;s:8:\"controls\";a:2:{s:7:\"content\";a:1:{s:11:\"section_map\";a:3:{s:7:\"address\";i:2;s:4:\"zoom\";i:1;s:6:\"height\";i:1;}}s:8:\"advanced\";a:1:{s:15:\"_section_border\";a:1:{s:22:\"_box_shadow_box_shadow\";i:1;}}}}s:14:\"image-carousel\";a:2:{s:5:\"count\";i:2;s:8:\"controls\";a:2:{s:7:\"content\";a:2:{s:22:\"section_image_carousel\";a:6:{s:8:\"carousel\";i:2;s:14:\"thumbnail_size\";i:2;s:26:\"thumbnail_custom_dimension\";i:1;s:14:\"slides_to_show\";i:1;s:16:\"slides_to_scroll\";i:1;s:10:\"navigation\";i:1;}s:26:\"section_additional_options\";a:5:{s:8:\"autoplay\";i:1;s:14:\"pause_on_hover\";i:1;s:20:\"pause_on_interaction\";i:1;s:14:\"autoplay_speed\";i:1;s:5:\"speed\";i:1;}}s:5:\"style\";a:2:{s:24:\"section_style_navigation\";a:2:{s:15:\"arrows_position\";i:1;s:11:\"arrows_size\";i:1;}s:19:\"section_style_image\";a:2:{s:13:\"image_spacing\";i:1;s:19:\"image_border_radius\";i:1;}}}}s:20:\"woocommerce-products\";a:2:{s:5:\"count\";i:1;s:8:\"controls\";a:1:{s:5:\"style\";a:2:{s:22:\"section_products_style\";a:7:{s:17:\"column_gap_mobile\";i:1;s:14:\"row_gap_mobile\";i:1;s:12:\"align_mobile\";i:1;s:11:\"title_color\";i:1;s:11:\"price_color\";i:1;s:15:\"old_price_color\";i:1;s:17:\"button_text_color\";i:1;}s:18:\"section_design_box\";a:1:{s:17:\"box_border_radius\";i:1;}}}}s:9:\"icon-list\";a:2:{s:5:\"count\";i:1;s:8:\"controls\";a:3:{s:7:\"content\";a:1:{s:12:\"section_icon\";a:1:{s:9:\"icon_list\";i:1;}}s:5:\"style\";a:2:{s:18:\"section_icon_style\";a:2:{s:10:\"icon_color\";i:1;s:9:\"icon_size\";i:1;}s:18:\"section_text_style\";a:12:{s:11:\"text_indent\";i:1;s:10:\"text_color\";i:1;s:26:\"icon_typography_typography\";i:1;s:25:\"icon_typography_font_size\";i:1;s:27:\"icon_typography_line_height\";i:1;s:30:\"icon_typography_letter_spacing\";i:1;s:32:\"icon_typography_font_size_tablet\";i:1;s:32:\"icon_typography_font_size_mobile\";i:1;s:34:\"icon_typography_line_height_tablet\";i:1;s:34:\"icon_typography_line_height_mobile\";i:1;s:37:\"icon_typography_letter_spacing_tablet\";i:1;s:37:\"icon_typography_letter_spacing_mobile\";i:1;}}s:8:\"advanced\";a:2:{s:15:\"_section_border\";a:1:{s:22:\"_box_shadow_box_shadow\";i:1;}s:14:\"_section_style\";a:2:{s:14:\"_margin_mobile\";i:1;s:15:\"_padding_mobile\";i:1;}}}}s:4:\"form\";a:2:{s:5:\"count\";i:1;s:8:\"controls\";a:2:{s:7:\"content\";a:3:{s:19:\"section_form_fields\";a:3:{s:9:\"form_name\";i:1;s:11:\"form_fields\";i:1;s:11:\"show_labels\";i:1;}s:15:\"section_buttons\";a:3:{s:11:\"button_text\";i:1;s:12:\"button_align\";i:1;s:19:\"button_align_mobile\";i:1;}s:20:\"section_form_options\";a:4:{s:15:\"success_message\";i:1;s:13:\"error_message\";i:1;s:22:\"required_field_message\";i:1;s:15:\"invalid_message\";i:1;}}s:5:\"style\";a:2:{s:19:\"section_field_style\";a:5:{s:27:\"field_typography_typography\";i:1;s:28:\"field_typography_font_family\";i:1;s:28:\"field_typography_font_weight\";i:1;s:18:\"field_border_width\";i:1;s:19:\"field_border_radius\";i:1;}s:20:\"section_button_style\";a:9:{s:28:\"button_typography_typography\";i:1;s:27:\"button_typography_font_size\";i:1;s:29:\"button_typography_font_family\";i:1;s:29:\"button_typography_font_weight\";i:1;s:32:\"button_typography_text_transform\";i:1;s:32:\"button_typography_letter_spacing\";i:1;s:23:\"button_background_color\";i:1;s:20:\"button_border_radius\";i:1;s:29:\"button_background_hover_color\";i:1;}}}}}s:4:\"page\";a:8:{s:6:\"spacer\";a:2:{s:5:\"count\";i:1;s:8:\"controls\";a:1:{s:7:\"content\";a:1:{s:14:\"section_spacer\";a:1:{s:5:\"space\";i:1;}}}}s:7:\"heading\";a:2:{s:5:\"count\";i:4;s:8:\"controls\";a:2:{s:7:\"content\";a:1:{s:13:\"section_title\";a:4:{s:5:\"title\";i:4;s:11:\"header_size\";i:4;s:12:\"align_mobile\";i:4;s:5:\"align\";i:1;}}s:5:\"style\";a:1:{s:19:\"section_title_style\";a:6:{s:11:\"title_color\";i:4;s:21:\"typography_typography\";i:4;s:20:\"typography_font_size\";i:4;s:27:\"typography_font_size_mobile\";i:2;s:22:\"typography_font_family\";i:4;s:22:\"typography_font_weight\";i:4;}}}}s:6:\"column\";a:2:{s:5:\"count\";i:7;s:8:\"controls\";a:2:{s:6:\"layout\";a:1:{s:6:\"layout\";a:2:{s:12:\"_inline_size\";i:1;s:19:\"_inline_size_tablet\";i:2;}}s:8:\"advanced\";a:1:{s:16:\"section_advanced\";a:3:{s:7:\"padding\";i:4;s:14:\"padding_mobile\";i:2;s:6:\"margin\";i:2;}}}}s:7:\"section\";a:2:{s:5:\"count\";i:4;s:8:\"controls\";a:3:{s:6:\"layout\";a:2:{s:14:\"section_layout\";a:5:{s:13:\"content_width\";i:4;s:13:\"custom_height\";i:2;s:16:\"content_position\";i:4;s:6:\"_title\";i:4;s:6:\"layout\";i:2;}s:17:\"section_structure\";a:1:{s:9:\"structure\";i:3;}}s:5:\"style\";a:3:{s:18:\"section_background\";a:3:{s:21:\"background_background\";i:4;s:16:\"background_color\";i:2;s:28:\"background_slideshow_gallery\";i:2;}s:26:\"section_background_overlay\";a:3:{s:29:\"background_overlay_background\";i:2;s:24:\"background_overlay_color\";i:2;s:26:\"background_overlay_opacity\";i:2;}s:21:\"section_shape_divider\";a:1:{s:17:\"shape_divider_top\";i:1;}}s:8:\"advanced\";a:2:{s:16:\"section_advanced\";a:3:{s:7:\"padding\";i:4;s:14:\"padding_tablet\";i:4;s:14:\"padding_mobile\";i:2;}s:19:\"_section_responsive\";a:1:{s:20:\"reverse_order_mobile\";i:1;}}}}s:25:\"woocommerce-product-price\";a:2:{s:5:\"count\";i:1;s:8:\"controls\";a:1:{s:5:\"style\";a:1:{s:19:\"section_price_style\";a:1:{s:11:\"price_color\";i:1;}}}}s:11:\"text-editor\";a:2:{s:5:\"count\";i:2;s:8:\"controls\";a:2:{s:7:\"content\";a:1:{s:14:\"section_editor\";a:1:{s:6:\"editor\";i:2;}}s:5:\"style\";a:1:{s:13:\"section_style\";a:3:{s:12:\"align_mobile\";i:2;s:21:\"typography_typography\";i:2;s:22:\"typography_font_family\";i:2;}}}}s:6:\"button\";a:2:{s:5:\"count\";i:3;s:8:\"controls\";a:2:{s:7:\"content\";a:1:{s:14:\"section_button\";a:7:{s:4:\"text\";i:3;s:5:\"align\";i:3;s:12:\"align_mobile\";i:3;s:4:\"size\";i:3;s:10:\"icon_align\";i:3;s:13:\"selected_icon\";i:2;s:4:\"link\";i:2;}}s:5:\"style\";a:1:{s:13:\"section_style\";a:6:{s:21:\"typography_typography\";i:3;s:22:\"typography_font_family\";i:3;s:16:\"background_color\";i:3;s:29:\"button_background_hover_color\";i:3;s:13:\"border_radius\";i:3;s:27:\"typography_font_size_tablet\";i:1;}}}}s:5:\"image\";a:2:{s:5:\"count\";i:2;s:8:\"controls\";a:3:{s:7:\"content\";a:1:{s:13:\"section_image\";a:2:{s:5:\"image\";i:2;s:10:\"image_size\";i:2;}}s:5:\"style\";a:1:{s:19:\"section_style_image\";a:6:{s:19:\"image_border_border\";i:2;s:18:\"image_border_width\";i:2;s:18:\"image_border_color\";i:2;s:32:\"image_box_shadow_box_shadow_type\";i:2;s:27:\"image_box_shadow_box_shadow\";i:2;s:5:\"width\";i:2;}}s:8:\"advanced\";a:2:{s:14:\"_section_style\";a:1:{s:15:\"_padding_mobile\";i:2;}s:19:\"_section_attributes\";a:1:{s:11:\"_attributes\";i:2;}}}}}s:11:\"single-page\";a:11:{s:5:\"image\";a:2:{s:5:\"count\";i:2;s:8:\"controls\";a:3:{s:7:\"content\";a:1:{s:13:\"section_image\";a:6:{s:5:\"image\";i:2;s:5:\"align\";i:1;s:4:\"link\";i:1;s:12:\"align_tablet\";i:1;s:12:\"align_mobile\";i:1;s:10:\"image_size\";i:1;}}s:5:\"style\";a:2:{s:19:\"section_style_image\";a:3:{s:5:\"space\";i:1;s:7:\"opacity\";i:1;s:27:\"image_box_shadow_box_shadow\";i:1;}s:21:\"section_style_caption\";a:9:{s:28:\"caption_typography_font_size\";i:1;s:30:\"caption_typography_line_height\";i:1;s:33:\"caption_typography_letter_spacing\";i:1;s:35:\"caption_typography_font_size_tablet\";i:1;s:35:\"caption_typography_font_size_mobile\";i:1;s:37:\"caption_typography_line_height_tablet\";i:1;s:37:\"caption_typography_line_height_mobile\";i:1;s:40:\"caption_typography_letter_spacing_tablet\";i:1;s:40:\"caption_typography_letter_spacing_mobile\";i:1;}}s:8:\"advanced\";a:1:{s:15:\"_section_border\";a:1:{s:22:\"_box_shadow_box_shadow\";i:1;}}}}s:11:\"text-editor\";a:2:{s:5:\"count\";i:5;s:8:\"controls\";a:3:{s:7:\"content\";a:1:{s:14:\"section_editor\";a:1:{s:6:\"editor\";i:5;}}s:5:\"style\";a:1:{s:13:\"section_style\";a:15:{s:5:\"align\";i:1;s:10:\"text_color\";i:5;s:21:\"typography_typography\";i:4;s:22:\"typography_font_family\";i:3;s:20:\"typography_font_size\";i:5;s:22:\"typography_font_weight\";i:3;s:22:\"typography_line_height\";i:4;s:25:\"typography_letter_spacing\";i:4;s:12:\"align_mobile\";i:1;s:27:\"typography_font_size_tablet\";i:4;s:27:\"typography_font_size_mobile\";i:4;s:29:\"typography_line_height_tablet\";i:4;s:29:\"typography_line_height_mobile\";i:4;s:32:\"typography_letter_spacing_tablet\";i:4;s:32:\"typography_letter_spacing_mobile\";i:4;}}s:8:\"advanced\";a:2:{s:15:\"_section_border\";a:1:{s:22:\"_box_shadow_box_shadow\";i:4;}s:14:\"_section_style\";a:2:{s:15:\"_padding_mobile\";i:1;s:8:\"_padding\";i:1;}}}}s:6:\"button\";a:2:{s:5:\"count\";i:4;s:8:\"controls\";a:3:{s:7:\"content\";a:1:{s:14:\"section_button\";a:4:{s:4:\"text\";i:4;s:5:\"align\";i:4;s:4:\"link\";i:1;s:11:\"icon_indent\";i:1;}}s:5:\"style\";a:1:{s:13:\"section_style\";a:21:{s:16:\"background_color\";i:4;s:29:\"button_background_hover_color\";i:2;s:17:\"button_text_color\";i:1;s:21:\"typography_typography\";i:1;s:20:\"typography_font_size\";i:1;s:22:\"typography_font_family\";i:1;s:22:\"typography_font_weight\";i:1;s:25:\"typography_text_transform\";i:1;s:22:\"typography_line_height\";i:1;s:25:\"typography_letter_spacing\";i:1;s:13:\"border_border\";i:1;s:12:\"border_width\";i:1;s:13:\"border_radius\";i:1;s:11:\"hover_color\";i:1;s:25:\"button_hover_border_color\";i:1;s:27:\"typography_font_size_tablet\";i:1;s:27:\"typography_font_size_mobile\";i:1;s:29:\"typography_line_height_tablet\";i:1;s:29:\"typography_line_height_mobile\";i:1;s:32:\"typography_letter_spacing_tablet\";i:1;s:32:\"typography_letter_spacing_mobile\";i:1;}}s:8:\"advanced\";a:2:{s:14:\"_section_style\";a:1:{s:8:\"_padding\";i:1;}s:15:\"_section_border\";a:1:{s:22:\"_box_shadow_box_shadow\";i:1;}}}}s:6:\"column\";a:2:{s:5:\"count\";i:11;s:8:\"controls\";a:3:{s:8:\"advanced\";a:1:{s:16:\"section_advanced\";a:7:{s:9:\"screen_sm\";i:11;s:15:\"screen_sm_width\";i:11;s:6:\"margin\";i:1;s:7:\"padding\";i:4;s:14:\"padding_tablet\";i:2;s:14:\"padding_mobile\";i:6;s:13:\"margin_mobile\";i:1;}}s:5:\"style\";a:3:{s:14:\"section_border\";a:1:{s:21:\"box_shadow_box_shadow\";i:11;}s:13:\"section_style\";a:8:{s:21:\"background_background\";i:4;s:16:\"background_color\";i:2;s:16:\"background_image\";i:1;s:19:\"background_position\";i:1;s:17:\"background_repeat\";i:1;s:15:\"background_size\";i:1;s:28:\"background_slideshow_gallery\";i:1;s:37:\"background_slideshow_slide_transition\";i:1;}s:12:\"section_typo\";a:1:{s:10:\"text_align\";i:2;}}s:6:\"layout\";a:1:{s:6:\"layout\";a:3:{s:16:\"content_position\";i:1;s:5:\"align\";i:1;s:12:\"_inline_size\";i:2;}}}}s:7:\"section\";a:2:{s:5:\"count\";i:7;s:8:\"controls\";a:3:{s:6:\"layout\";a:2:{s:14:\"section_layout\";a:9:{s:13:\"content_width\";i:7;s:6:\"height\";i:1;s:13:\"custom_height\";i:5;s:16:\"content_position\";i:6;s:6:\"_title\";i:5;s:6:\"layout\";i:1;s:15:\"stretch_section\";i:3;s:3:\"gap\";i:3;s:19:\"custom_height_inner\";i:2;}s:17:\"section_structure\";a:1:{s:9:\"structure\";i:4;}}s:5:\"style\";a:4:{s:18:\"section_background\";a:7:{s:21:\"background_background\";i:3;s:16:\"background_color\";i:2;s:16:\"background_image\";i:2;s:19:\"background_position\";i:2;s:17:\"background_repeat\";i:2;s:15:\"background_size\";i:2;s:21:\"background_attachment\";i:1;}s:26:\"section_background_overlay\";a:3:{s:29:\"background_overlay_background\";i:2;s:24:\"background_overlay_color\";i:2;s:26:\"background_overlay_opacity\";i:7;}s:14:\"section_border\";a:1:{s:21:\"box_shadow_box_shadow\";i:7;}s:12:\"section_typo\";a:1:{s:10:\"text_align\";i:1;}}s:8:\"advanced\";a:2:{s:16:\"section_advanced\";a:4:{s:7:\"padding\";i:5;s:6:\"margin\";i:2;s:14:\"padding_mobile\";i:3;s:14:\"padding_tablet\";i:1;}s:19:\"_section_responsive\";a:1:{s:20:\"reverse_order_mobile\";i:1;}}}}s:7:\"heading\";a:2:{s:5:\"count\";i:6;s:8:\"controls\";a:3:{s:7:\"content\";a:1:{s:13:\"section_title\";a:6:{s:5:\"title\";i:6;s:4:\"link\";i:5;s:4:\"size\";i:5;s:12:\"align_mobile\";i:2;s:11:\"header_size\";i:2;s:5:\"align\";i:1;}}s:5:\"style\";a:1:{s:19:\"section_title_style\";a:17:{s:11:\"title_color\";i:6;s:21:\"typography_typography\";i:6;s:20:\"typography_font_size\";i:6;s:22:\"typography_font_family\";i:6;s:25:\"typography_text_transform\";i:4;s:22:\"typography_line_height\";i:5;s:25:\"typography_letter_spacing\";i:5;s:27:\"typography_font_size_tablet\";i:5;s:27:\"typography_font_size_mobile\";i:5;s:29:\"typography_line_height_tablet\";i:5;s:29:\"typography_line_height_mobile\";i:5;s:32:\"typography_letter_spacing_tablet\";i:5;s:32:\"typography_letter_spacing_mobile\";i:5;s:22:\"typography_font_weight\";i:1;s:26:\"typography_text_decoration\";i:1;s:28:\"text_shadow_text_shadow_type\";i:1;s:23:\"text_shadow_text_shadow\";i:1;}}s:8:\"advanced\";a:1:{s:15:\"_section_border\";a:1:{s:22:\"_box_shadow_box_shadow\";i:5;}}}}s:7:\"divider\";a:2:{s:5:\"count\";i:4;s:8:\"controls\";a:3:{s:5:\"style\";a:1:{s:21:\"section_divider_style\";a:3:{s:6:\"weight\";i:4;s:5:\"color\";i:4;s:3:\"gap\";i:4;}}s:7:\"content\";a:1:{s:15:\"section_divider\";a:3:{s:5:\"width\";i:4;s:12:\"align_mobile\";i:2;s:4:\"text\";i:4;}}s:8:\"advanced\";a:1:{s:15:\"_section_border\";a:1:{s:22:\"_box_shadow_box_shadow\";i:4;}}}}s:6:\"spacer\";a:2:{s:5:\"count\";i:4;s:8:\"controls\";a:2:{s:7:\"content\";a:1:{s:14:\"section_spacer\";a:2:{s:5:\"space\";i:4;s:12:\"space_tablet\";i:1;}}s:8:\"advanced\";a:2:{s:15:\"_section_border\";a:1:{s:22:\"_box_shadow_box_shadow\";i:3;}s:14:\"_section_style\";a:1:{s:15:\"_padding_mobile\";i:1;}}}}s:14:\"image-carousel\";a:2:{s:5:\"count\";i:1;s:8:\"controls\";a:2:{s:7:\"content\";a:2:{s:22:\"section_image_carousel\";a:6:{s:8:\"carousel\";i:1;s:14:\"thumbnail_size\";i:1;s:26:\"thumbnail_custom_dimension\";i:1;s:14:\"slides_to_show\";i:1;s:16:\"slides_to_scroll\";i:1;s:10:\"navigation\";i:1;}s:26:\"section_additional_options\";a:5:{s:8:\"autoplay\";i:1;s:14:\"pause_on_hover\";i:1;s:20:\"pause_on_interaction\";i:1;s:14:\"autoplay_speed\";i:1;s:5:\"speed\";i:1;}}s:5:\"style\";a:2:{s:24:\"section_style_navigation\";a:2:{s:15:\"arrows_position\";i:1;s:11:\"arrows_size\";i:1;}s:19:\"section_style_image\";a:2:{s:13:\"image_spacing\";i:1;s:19:\"image_border_radius\";i:1;}}}}s:9:\"icon-list\";a:2:{s:5:\"count\";i:1;s:8:\"controls\";a:3:{s:7:\"content\";a:1:{s:12:\"section_icon\";a:1:{s:9:\"icon_list\";i:1;}}s:5:\"style\";a:2:{s:18:\"section_icon_style\";a:2:{s:10:\"icon_color\";i:1;s:9:\"icon_size\";i:1;}s:18:\"section_text_style\";a:12:{s:11:\"text_indent\";i:1;s:10:\"text_color\";i:1;s:26:\"icon_typography_typography\";i:1;s:25:\"icon_typography_font_size\";i:1;s:27:\"icon_typography_line_height\";i:1;s:30:\"icon_typography_letter_spacing\";i:1;s:32:\"icon_typography_font_size_tablet\";i:1;s:32:\"icon_typography_font_size_mobile\";i:1;s:34:\"icon_typography_line_height_tablet\";i:1;s:34:\"icon_typography_line_height_mobile\";i:1;s:37:\"icon_typography_letter_spacing_tablet\";i:1;s:37:\"icon_typography_letter_spacing_mobile\";i:1;}}s:8:\"advanced\";a:2:{s:15:\"_section_border\";a:1:{s:22:\"_box_shadow_box_shadow\";i:1;}s:14:\"_section_style\";a:2:{s:14:\"_margin_mobile\";i:1;s:15:\"_padding_mobile\";i:1;}}}}s:11:\"google_maps\";a:2:{s:5:\"count\";i:1;s:8:\"controls\";a:2:{s:7:\"content\";a:1:{s:11:\"section_map\";a:3:{s:7:\"address\";i:1;s:4:\"zoom\";i:1;s:6:\"height\";i:1;}}s:8:\"advanced\";a:1:{s:15:\"_section_border\";a:1:{s:22:\"_box_shadow_box_shadow\";i:1;}}}}}s:7:\"product\";a:13:{s:26:\"woocommerce-product-images\";a:2:{s:5:\"count\";i:1;s:8:\"controls\";a:1:{s:5:\"style\";a:1:{s:29:\"section_product_gallery_style\";a:2:{s:18:\"image_border_width\";i:1;s:18:\"image_border_color\";i:1;}}}}s:6:\"column\";a:2:{s:5:\"count\";i:6;s:8:\"controls\";a:3:{s:6:\"layout\";a:1:{s:6:\"layout\";a:1:{s:12:\"_inline_size\";i:6;}}s:5:\"style\";a:1:{s:13:\"section_style\";a:1:{s:21:\"background_background\";i:1;}}s:8:\"advanced\";a:1:{s:16:\"section_advanced\";a:4:{s:13:\"margin_mobile\";i:1;s:14:\"padding_mobile\";i:4;s:14:\"padding_tablet\";i:4;s:7:\"padding\";i:2;}}}}s:22:\"woocommerce-breadcrumb\";a:2:{s:5:\"count\";i:1;s:8:\"controls\";a:1:{s:5:\"style\";a:1:{s:28:\"section_product_rating_style\";a:7:{s:10:\"text_color\";i:1;s:10:\"link_color\";i:1;s:26:\"text_typography_typography\";i:1;s:27:\"text_typography_font_family\";i:1;s:25:\"text_typography_font_size\";i:1;s:27:\"text_typography_font_weight\";i:1;s:27:\"text_typography_line_height\";i:1;}}}}s:25:\"woocommerce-product-title\";a:2:{s:5:\"count\";i:2;s:8:\"controls\";a:3:{s:7:\"general\";a:1:{s:11:\"__dynamic__\";a:1:{s:5:\"count\";i:2;}}s:7:\"content\";a:1:{s:13:\"section_title\";a:1:{s:5:\"title\";i:2;}}s:5:\"style\";a:1:{s:19:\"section_title_style\";a:5:{s:21:\"typography_typography\";i:2;s:22:\"typography_font_family\";i:2;s:20:\"typography_font_size\";i:2;s:25:\"typography_text_transform\";i:2;s:11:\"title_color\";i:1;}}}}s:26:\"woocommerce-product-rating\";a:2:{s:5:\"count\";i:1;s:8:\"controls\";a:1:{s:5:\"style\";a:1:{s:28:\"section_product_rating_style\";a:7:{s:26:\"text_typography_typography\";i:1;s:27:\"text_typography_font_family\";i:1;s:25:\"text_typography_font_size\";i:1;s:27:\"text_typography_font_weight\";i:1;s:27:\"text_typography_line_height\";i:1;s:10:\"link_color\";i:1;s:9:\"star_size\";i:1;}}}}s:37:\"woocommerce-product-short-description\";a:2:{s:5:\"count\";i:1;s:8:\"controls\";a:2:{s:5:\"style\";a:1:{s:33:\"section_product_description_style\";a:6:{s:10:\"text_align\";i:1;s:26:\"text_typography_typography\";i:1;s:25:\"text_typography_font_size\";i:1;s:27:\"text_typography_font_weight\";i:1;s:27:\"text_typography_font_family\";i:1;s:27:\"text_typography_line_height\";i:1;}}s:8:\"advanced\";a:1:{s:14:\"_section_style\";a:1:{s:7:\"_margin\";i:1;}}}}s:25:\"woocommerce-product-price\";a:2:{s:5:\"count\";i:1;s:8:\"controls\";a:2:{s:5:\"style\";a:1:{s:19:\"section_price_style\";a:14:{s:10:\"text_align\";i:1;s:11:\"price_color\";i:1;s:21:\"typography_typography\";i:1;s:22:\"typography_font_family\";i:1;s:22:\"typography_font_weight\";i:1;s:20:\"typography_font_size\";i:1;s:25:\"typography_text_transform\";i:1;s:25:\"typography_letter_spacing\";i:1;s:18:\"sale_price_spacing\";i:1;s:11:\"price_block\";i:1;s:16:\"sale_price_color\";i:1;s:32:\"sale_price_typography_typography\";i:1;s:31:\"sale_price_typography_font_size\";i:1;s:33:\"sale_price_typography_font_weight\";i:1;}}s:8:\"advanced\";a:1:{s:14:\"_section_style\";a:1:{s:7:\"_margin\";i:1;}}}}s:31:\"woocommerce-product-add-to-cart\";a:2:{s:5:\"count\";i:1;s:8:\"controls\";a:1:{s:5:\"style\";a:2:{s:24:\"section_atc_button_style\";a:12:{s:20:\"button_border_radius\";i:1;s:14:\"button_padding\";i:1;s:20:\"button_border_border\";i:1;s:19:\"button_border_width\";i:1;s:17:\"button_text_color\";i:1;s:15:\"button_bg_color\";i:1;s:19:\"button_border_color\";i:1;s:23:\"button_text_color_hover\";i:1;s:21:\"button_bg_color_hover\";i:1;s:25:\"button_border_color_hover\";i:1;s:28:\"button_typography_typography\";i:1;s:29:\"button_typography_font_family\";i:1;}s:26:\"section_atc_quantity_style\";a:5:{s:22:\"quantity_border_radius\";i:1;s:19:\"quantity_text_color\";i:1;s:17:\"quantity_bg_color\";i:1;s:21:\"quantity_border_color\";i:1;s:25:\"quantity_text_color_focus\";i:1;}}}}s:7:\"section\";a:2:{s:5:\"count\";i:3;s:8:\"controls\";a:3:{s:6:\"layout\";a:2:{s:14:\"section_layout\";a:3:{s:13:\"custom_height\";i:1;s:3:\"gap\";i:2;s:16:\"content_position\";i:1;}s:17:\"section_structure\";a:1:{s:9:\"structure\";i:3;}}s:8:\"advanced\";a:2:{s:16:\"section_advanced\";a:4:{s:6:\"margin\";i:2;s:13:\"margin_tablet\";i:2;s:7:\"padding\";i:1;s:14:\"padding_tablet\";i:1;}s:19:\"_section_responsive\";a:1:{s:20:\"reverse_order_mobile\";i:1;}}s:5:\"style\";a:1:{s:14:\"section_border\";a:4:{s:13:\"border_border\";i:1;s:12:\"border_width\";i:1;s:12:\"border_color\";i:1;s:13:\"border_radius\";i:1;}}}}s:27:\"woocommerce-product-related\";a:2:{s:5:\"count\";i:1;s:8:\"controls\";a:2:{s:7:\"content\";a:1:{s:32:\"section_related_products_content\";a:2:{s:14:\"posts_per_page\";i:1;s:7:\"columns\";i:1;}}s:5:\"style\";a:3:{s:22:\"section_products_style\";a:18:{s:5:\"align\";i:1;s:18:\"image_border_width\";i:1;s:18:\"image_border_color\";i:1;s:11:\"title_color\";i:1;s:11:\"price_color\";i:1;s:15:\"old_price_color\";i:1;s:20:\"button_border_border\";i:1;s:19:\"button_border_width\";i:1;s:20:\"button_border_radius\";i:1;s:14:\"button_spacing\";i:1;s:27:\"title_typography_typography\";i:1;s:28:\"title_typography_font_family\";i:1;s:27:\"price_typography_typography\";i:1;s:28:\"price_typography_font_family\";i:1;s:23:\"button_background_color\";i:1;s:19:\"button_border_color\";i:1;s:28:\"button_typography_typography\";i:1;s:29:\"button_typography_font_family\";i:1;}s:21:\"section_heading_style\";a:7:{s:13:\"heading_color\";i:1;s:29:\"heading_typography_typography\";i:1;s:30:\"heading_typography_font_family\";i:1;s:28:\"heading_typography_font_size\";i:1;s:30:\"heading_typography_font_weight\";i:1;s:33:\"heading_typography_text_transform\";i:1;s:18:\"heading_text_align\";i:1;}s:18:\"section_design_box\";a:1:{s:17:\"box_border_radius\";i:1;}}}}s:26:\"woocommerce-product-upsell\";a:2:{s:5:\"count\";i:1;s:8:\"controls\";a:3:{s:7:\"content\";a:1:{s:22:\"section_upsell_content\";a:1:{s:7:\"columns\";i:1;}}s:5:\"style\";a:3:{s:22:\"section_products_style\";a:18:{s:5:\"align\";i:1;s:18:\"image_border_width\";i:1;s:18:\"image_border_color\";i:1;s:11:\"title_color\";i:1;s:11:\"price_color\";i:1;s:15:\"old_price_color\";i:1;s:20:\"button_border_border\";i:1;s:19:\"button_border_width\";i:1;s:20:\"button_border_radius\";i:1;s:14:\"button_spacing\";i:1;s:27:\"title_typography_typography\";i:1;s:28:\"title_typography_font_family\";i:1;s:27:\"price_typography_typography\";i:1;s:28:\"price_typography_font_family\";i:1;s:23:\"button_background_color\";i:1;s:19:\"button_border_color\";i:1;s:28:\"button_typography_typography\";i:1;s:29:\"button_typography_font_family\";i:1;}s:21:\"section_heading_style\";a:7:{s:13:\"heading_color\";i:1;s:29:\"heading_typography_typography\";i:1;s:30:\"heading_typography_font_family\";i:1;s:28:\"heading_typography_font_size\";i:1;s:30:\"heading_typography_font_weight\";i:1;s:33:\"heading_typography_text_transform\";i:1;s:18:\"heading_text_align\";i:1;}s:18:\"section_design_box\";a:1:{s:17:\"box_border_radius\";i:1;}}s:8:\"advanced\";a:1:{s:14:\"_section_style\";a:1:{s:7:\"_margin\";i:1;}}}}s:24:\"woocommerce-product-meta\";a:2:{s:5:\"count\";i:1;s:8:\"controls\";a:1:{s:5:\"style\";a:1:{s:26:\"section_product_meta_style\";a:5:{s:26:\"text_typography_typography\";i:1;s:27:\"text_typography_font_family\";i:1;s:10:\"text_color\";i:1;s:10:\"link_color\";i:1;s:25:\"text_typography_font_size\";i:1;}}}}s:29:\"woocommerce-product-data-tabs\";a:2:{s:5:\"count\";i:1;s:8:\"controls\";a:1:{s:5:\"style\";a:2:{s:27:\"section_product_panel_style\";a:11:{s:13:\"heading_color\";i:1;s:29:\"content_typography_typography\";i:1;s:30:\"content_typography_font_family\";i:1;s:30:\"content_typography_font_weight\";i:1;s:37:\"content_heading_typography_typography\";i:1;s:38:\"content_heading_typography_font_family\";i:1;s:38:\"content_heading_typography_font_weight\";i:1;s:28:\"content_typography_font_size\";i:1;s:30:\"content_typography_line_height\";i:1;s:36:\"content_heading_typography_font_size\";i:1;s:19:\"panel_border_radius\";i:1;}s:26:\"section_product_tabs_style\";a:5:{s:25:\"tab_typography_typography\";i:1;s:26:\"tab_typography_font_family\";i:1;s:19:\"active_tab_bg_color\";i:1;s:17:\"tab_border_radius\";i:1;s:12:\"tab_bg_color\";i:1;}}}}}s:12:\"product-post\";a:3:{s:11:\"text-editor\";a:2:{s:5:\"count\";i:1;s:8:\"controls\";a:1:{s:7:\"content\";a:1:{s:14:\"section_editor\";a:1:{s:6:\"editor\";i:1;}}}}s:6:\"column\";a:2:{s:5:\"count\";i:1;s:8:\"controls\";a:0:{}}s:7:\"section\";a:2:{s:5:\"count\";i:1;s:8:\"controls\";a:0:{}}}s:6:\"header\";a:7:{s:9:\"icon-list\";a:2:{s:5:\"count\";i:1;s:8:\"controls\";a:3:{s:7:\"content\";a:1:{s:12:\"section_icon\";a:3:{s:4:\"view\";i:1;s:9:\"icon_list\";i:1;s:10:\"link_click\";i:1;}}s:5:\"style\";a:3:{s:17:\"section_icon_list\";a:3:{s:13:\"space_between\";i:1;s:20:\"space_between_mobile\";i:1;s:17:\"icon_align_mobile\";i:1;}s:18:\"section_icon_style\";a:2:{s:10:\"icon_color\";i:1;s:16:\"icon_color_hover\";i:1;}s:18:\"section_text_style\";a:5:{s:10:\"text_color\";i:1;s:11:\"text_indent\";i:1;s:26:\"icon_typography_typography\";i:1;s:25:\"icon_typography_font_size\";i:1;s:34:\"icon_typography_line_height_mobile\";i:1;}}s:8:\"advanced\";a:1:{s:19:\"_section_responsive\";a:1:{s:11:\"hide_mobile\";i:1;}}}}s:6:\"column\";a:2:{s:5:\"count\";i:3;s:8:\"controls\";a:2:{s:6:\"layout\";a:1:{s:6:\"layout\";a:2:{s:12:\"_inline_size\";i:3;s:19:\"_inline_size_tablet\";i:2;}}s:8:\"advanced\";a:1:{s:16:\"section_advanced\";a:1:{s:13:\"margin_mobile\";i:1;}}}}s:12:\"social-icons\";a:2:{s:5:\"count\";i:1;s:8:\"controls\";a:3:{s:7:\"content\";a:1:{s:19:\"section_social_icon\";a:4:{s:16:\"social_icon_list\";i:1;s:5:\"align\";i:1;s:5:\"shape\";i:1;s:12:\"align_mobile\";i:1;}}s:5:\"style\";a:2:{s:20:\"section_social_style\";a:7:{s:10:\"icon_color\";i:1;s:18:\"icon_primary_color\";i:1;s:20:\"icon_secondary_color\";i:1;s:9:\"icon_size\";i:1;s:12:\"icon_padding\";i:1;s:12:\"icon_spacing\";i:1;s:19:\"icon_padding_tablet\";i:1;}s:20:\"section_social_hover\";a:1:{s:19:\"hover_primary_color\";i:1;}}s:8:\"advanced\";a:1:{s:14:\"_section_style\";a:4:{s:7:\"_margin\";i:1;s:8:\"_padding\";i:1;s:14:\"_margin_mobile\";i:1;s:15:\"_padding_mobile\";i:1;}}}}s:7:\"section\";a:2:{s:5:\"count\";i:2;s:8:\"controls\";a:3:{s:6:\"layout\";a:2:{s:14:\"section_layout\";a:4:{s:6:\"height\";i:1;s:13:\"custom_height\";i:1;s:16:\"content_position\";i:1;s:3:\"gap\";i:1;}s:17:\"section_structure\";a:1:{s:9:\"structure\";i:1;}}s:5:\"style\";a:1:{s:18:\"section_background\";a:2:{s:21:\"background_background\";i:1;s:16:\"background_color\";i:1;}}s:8:\"advanced\";a:1:{s:16:\"section_advanced\";a:2:{s:14:\"padding_tablet\";i:1;s:14:\"padding_mobile\";i:1;}}}}s:6:\"spacer\";a:2:{s:5:\"count\";i:1;s:8:\"controls\";a:1:{s:7:\"content\";a:1:{s:14:\"section_spacer\";a:1:{s:5:\"space\";i:1;}}}}s:15:\"theme-site-logo\";a:2:{s:5:\"count\";i:1;s:8:\"controls\";a:3:{s:7:\"general\";a:1:{s:11:\"__dynamic__\";a:1:{s:5:\"count\";i:2;}}s:5:\"style\";a:1:{s:19:\"section_style_image\";a:2:{s:5:\"width\";i:1;s:12:\"width_mobile\";i:1;}}s:7:\"content\";a:1:{s:13:\"section_image\";a:2:{s:5:\"image\";i:1;s:4:\"link\";i:1;}}}}s:8:\"nav-menu\";a:2:{s:5:\"count\";i:1;s:8:\"controls\";a:3:{s:7:\"content\";a:1:{s:14:\"section_layout\";a:3:{s:11:\"align_items\";i:1;s:12:\"toggle_align\";i:1;s:10:\"full_width\";i:1;}}s:5:\"style\";a:3:{s:23:\"section_style_main-menu\";a:10:{s:15:\"color_menu_item\";i:1;s:29:\"pointer_color_menu_item_hover\";i:1;s:26:\"menu_typography_typography\";i:1;s:25:\"menu_typography_font_size\";i:1;s:27:\"menu_typography_font_weight\";i:1;s:13:\"pointer_width\";i:1;s:26:\"padding_vertical_menu_item\";i:1;s:28:\"padding_horizontal_menu_item\";i:1;s:18:\"menu_space_between\";i:1;s:21:\"color_menu_item_hover\";i:1;}s:22:\"section_style_dropdown\";a:3:{s:36:\"background_color_dropdown_item_hover\";i:1;s:30:\"background_color_dropdown_item\";i:1;s:28:\"dropdown_top_distance_mobile\";i:1;}s:12:\"style_toggle\";a:2:{s:23:\"toggle_background_color\";i:1;s:18:\"toggle_color_hover\";i:1;}}s:8:\"advanced\";a:1:{s:19:\"_section_background\";a:2:{s:22:\"_background_background\";i:1;s:17:\"_background_color\";i:1;}}}}}s:6:\"footer\";a:7:{s:14:\"image-carousel\";a:2:{s:5:\"count\";i:1;s:8:\"controls\";a:2:{s:7:\"content\";a:1:{s:22:\"section_image_carousel\";a:8:{s:8:\"carousel\";i:1;s:14:\"thumbnail_size\";i:1;s:14:\"slides_to_show\";i:1;s:16:\"slides_to_scroll\";i:1;s:10:\"navigation\";i:1;s:21:\"slides_to_show_tablet\";i:1;s:23:\"slides_to_scroll_tablet\";i:1;s:7:\"link_to\";i:1;}}s:5:\"style\";a:1:{s:19:\"section_style_image\";a:3:{s:22:\"gallery_vertical_align\";i:1;s:20:\"image_spacing_custom\";i:1;s:19:\"image_border_radius\";i:1;}}}}s:6:\"column\";a:2:{s:5:\"count\";i:10;s:8:\"controls\";a:3:{s:5:\"style\";a:1:{s:14:\"section_border\";a:3:{s:13:\"border_border\";i:1;s:12:\"border_width\";i:1;s:12:\"border_color\";i:1;}}s:8:\"advanced\";a:1:{s:16:\"section_advanced\";a:6:{s:7:\"padding\";i:3;s:14:\"padding_tablet\";i:1;s:14:\"padding_mobile\";i:1;s:13:\"margin_mobile\";i:2;s:6:\"margin\";i:1;s:13:\"margin_tablet\";i:1;}}s:6:\"layout\";a:1:{s:6:\"layout\";a:2:{s:12:\"_inline_size\";i:6;s:19:\"_inline_size_tablet\";i:3;}}}}s:7:\"section\";a:2:{s:5:\"count\";i:6;s:8:\"controls\";a:3:{s:6:\"layout\";a:2:{s:14:\"section_layout\";a:4:{s:6:\"height\";i:2;s:13:\"custom_height\";i:2;s:6:\"_title\";i:2;s:13:\"content_width\";i:4;}s:17:\"section_structure\";a:1:{s:9:\"structure\";i:2;}}s:5:\"style\";a:3:{s:18:\"section_background\";a:7:{s:21:\"background_background\";i:2;s:16:\"background_color\";i:1;s:16:\"background_image\";i:1;s:17:\"background_repeat\";i:1;s:15:\"background_size\";i:1;s:26:\"background_position_tablet\";i:1;s:26:\"background_position_mobile\";i:1;}s:14:\"section_border\";a:3:{s:13:\"border_border\";i:1;s:12:\"border_width\";i:1;s:12:\"border_color\";i:1;}s:26:\"section_background_overlay\";a:3:{s:29:\"background_overlay_background\";i:1;s:24:\"background_overlay_color\";i:1;s:26:\"background_overlay_opacity\";i:1;}}s:8:\"advanced\";a:1:{s:16:\"section_advanced\";a:5:{s:7:\"padding\";i:1;s:13:\"margin_mobile\";i:2;s:14:\"padding_tablet\";i:1;s:6:\"margin\";i:1;s:13:\"margin_tablet\";i:1;}}}}s:11:\"text-editor\";a:2:{s:5:\"count\";i:1;s:8:\"controls\";a:3:{s:5:\"style\";a:1:{s:13:\"section_style\";a:8:{s:5:\"align\";i:1;s:10:\"text_color\";i:1;s:21:\"typography_typography\";i:1;s:22:\"typography_font_family\";i:1;s:20:\"typography_font_size\";i:1;s:22:\"typography_font_weight\";i:1;s:12:\"align_tablet\";i:1;s:25:\"typography_text_transform\";i:1;}}s:7:\"content\";a:1:{s:14:\"section_editor\";a:1:{s:6:\"editor\";i:1;}}s:8:\"advanced\";a:1:{s:14:\"_section_style\";a:2:{s:14:\"_margin_mobile\";i:1;s:15:\"_padding_mobile\";i:1;}}}}s:9:\"icon-list\";a:2:{s:5:\"count\";i:3;s:8:\"controls\";a:3:{s:7:\"content\";a:1:{s:12:\"section_icon\";a:2:{s:4:\"view\";i:1;s:9:\"icon_list\";i:3;}}s:5:\"style\";a:3:{s:17:\"section_icon_list\";a:6:{s:13:\"space_between\";i:3;s:10:\"icon_align\";i:1;s:17:\"icon_align_tablet\";i:3;s:20:\"space_between_mobile\";i:1;s:20:\"space_between_tablet\";i:1;s:17:\"icon_align_mobile\";i:2;}s:18:\"section_icon_style\";a:4:{s:10:\"icon_color\";i:3;s:9:\"icon_size\";i:1;s:16:\"icon_color_hover\";i:1;s:16:\"icon_size_mobile\";i:1;}s:18:\"section_text_style\";a:6:{s:10:\"text_color\";i:2;s:11:\"text_indent\";i:2;s:26:\"icon_typography_typography\";i:2;s:27:\"icon_typography_font_family\";i:2;s:25:\"icon_typography_font_size\";i:2;s:27:\"icon_typography_font_weight\";i:2;}}s:8:\"advanced\";a:1:{s:14:\"_section_style\";a:1:{s:7:\"_margin\";i:1;}}}}s:7:\"heading\";a:2:{s:5:\"count\";i:6;s:8:\"controls\";a:2:{s:7:\"content\";a:1:{s:13:\"section_title\";a:6:{s:5:\"title\";i:6;s:5:\"align\";i:6;s:12:\"align_tablet\";i:3;s:11:\"header_size\";i:3;s:12:\"align_mobile\";i:3;s:4:\"link\";i:2;}}s:5:\"style\";a:1:{s:19:\"section_title_style\";a:6:{s:11:\"title_color\";i:6;s:21:\"typography_typography\";i:6;s:22:\"typography_font_family\";i:6;s:20:\"typography_font_size\";i:6;s:22:\"typography_font_weight\";i:6;s:25:\"typography_text_transform\";i:4;}}}}s:8:\"nav-menu\";a:2:{s:5:\"count\";i:1;s:8:\"controls\";a:3:{s:7:\"content\";a:1:{s:14:\"section_layout\";a:4:{s:6:\"layout\";i:1;s:11:\"align_items\";i:1;s:8:\"dropdown\";i:1;s:10:\"text_align\";i:1;}}s:5:\"style\";a:3:{s:23:\"section_style_main-menu\";a:11:{s:26:\"menu_typography_typography\";i:1;s:27:\"menu_typography_font_family\";i:1;s:25:\"menu_typography_font_size\";i:1;s:27:\"menu_typography_font_weight\";i:1;s:30:\"menu_typography_text_transform\";i:1;s:15:\"color_menu_item\";i:1;s:21:\"color_menu_item_hover\";i:1;s:13:\"pointer_width\";i:1;s:28:\"padding_horizontal_menu_item\";i:1;s:26:\"padding_vertical_menu_item\";i:1;s:18:\"menu_space_between\";i:1;}s:22:\"section_style_dropdown\";a:18:{s:19:\"color_dropdown_item\";i:1;s:25:\"color_dropdown_item_hover\";i:1;s:36:\"background_color_dropdown_item_hover\";i:1;s:26:\"color_dropdown_item_active\";i:1;s:37:\"background_color_dropdown_item_active\";i:1;s:30:\"dropdown_typography_typography\";i:1;s:31:\"dropdown_typography_font_family\";i:1;s:29:\"dropdown_typography_font_size\";i:1;s:36:\"dropdown_typography_font_size_mobile\";i:1;s:31:\"dropdown_typography_font_weight\";i:1;s:35:\"dropdown_box_shadow_box_shadow_type\";i:1;s:30:\"dropdown_box_shadow_box_shadow\";i:1;s:32:\"padding_horizontal_dropdown_item\";i:1;s:30:\"padding_vertical_dropdown_item\";i:1;s:37:\"padding_vertical_dropdown_item_mobile\";i:1;s:21:\"dropdown_top_distance\";i:1;s:28:\"dropdown_top_distance_tablet\";i:1;s:28:\"dropdown_top_distance_mobile\";i:1;}s:12:\"style_toggle\";a:2:{s:12:\"toggle_color\";i:1;s:23:\"toggle_background_color\";i:1;}}s:8:\"advanced\";a:1:{s:14:\"_section_style\";a:1:{s:14:\"_margin_mobile\";i:1;}}}}}}", "no");
INSERT INTO `psm_options` VALUES("7026", "elementor_1_elementor_updater_batch_c04ede77fe24faf1bb25c1c6b7d4", "a:2:{i:0;a:1:{s:8:\"callback\";a:2:{i:0;s:31:\"Elementor\\Core\\Upgrade\\Upgrades\";i:1;s:16:\"_on_each_version\";}}i:1;a:1:{s:8:\"callback\";a:2:{i:0;s:31:\"Elementor\\Core\\Upgrade\\Upgrades\";i:1;s:42:\"_v_3_2_0_migrate_breakpoints_to_new_system\";}}}", "no");
INSERT INTO `psm_options` VALUES("7173", "installed_appointment-hour-booking", "1632270578", "yes");
INSERT INTO `psm_options` VALUES("7174", "cp_cpappb_last_verified", "2021-10-04 14:40:25", "yes");
INSERT INTO `psm_options` VALUES("7175", "_transient_codepeople_promote_banner_appointment-hour-booking", "1632270580", "yes");
INSERT INTO `psm_options` VALUES("7194", "jetpack_log", "a:1:{i:0;a:5:{s:4:\"time\";i:1632304717;s:7:\"user_id\";i:0;s:7:\"blog_id\";b:0;s:4:\"code\";s:11:\"autoupdates\";s:4:\"data\";a:3:{s:7:\"results\";a:1:{s:11:\"translation\";a:2:{i:0;O:8:\"stdClass\":4:{s:4:\"item\";O:8:\"stdClass\":7:{s:4:\"type\";s:6:\"plugin\";s:4:\"slug\";s:14:\"contact-form-7\";s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:5:\"5.4.2\";s:7:\"updated\";s:19:\"2021-08-12 06:02:59\";s:7:\"package\";s:81:\"https://downloads.wordpress.org/translation/plugin/contact-form-7/5.4.2/fr_FR.zip\";s:10:\"autoupdate\";b:1;}s:6:\"result\";a:7:{s:6:\"source\";s:62:\"/Applications/MAMP/htdocs/psm/wp-content/upgrade/fr_FR-rUxn3X/\";s:12:\"source_files\";a:3:{i:0;s:23:\"contact-form-7-fr_FR.po\";i:1;s:58:\"contact-form-7-fr_FR-28b2966727a4eeea158f98250ee5b44b.json\";i:2;s:23:\"contact-form-7-fr_FR.mo\";}s:11:\"destination\";s:58:\"/Applications/MAMP/htdocs/psm/wp-content/languages/plugins\";s:16:\"destination_name\";s:0:\"\";s:17:\"local_destination\";s:58:\"/Applications/MAMP/htdocs/psm/wp-content/languages/plugins\";s:18:\"remote_destination\";s:59:\"/Applications/MAMP/htdocs/psm/wp-content/languages/plugins/\";s:17:\"clear_destination\";b:1;}s:4:\"name\";s:31:\"Traductions pour Contact Form 7\";s:8:\"messages\";a:6:{i:0;s:62:\"Mise à jour de la traduction de Contact Form 7 (fr_FR)&#8230;\";i:1;s:124:\"Téléchargement des traductions depuis https://downloads.wordpress.org/translation/plugin/contact-form-7/5.4.2/fr_FR.zip…\";i:2;s:40:\"Décompression de la mise à jour&#8230;\";i:3;s:43:\"Installation de la dernière version&#8230;\";i:4;s:51:\"Retrait de l’ancienne version de la traduction…\";i:5;s:40:\"La traduction a bien été mise à jour.\";}}i:1;O:8:\"stdClass\":4:{s:4:\"item\";O:8:\"stdClass\":7:{s:4:\"type\";s:6:\"plugin\";s:4:\"slug\";s:9:\"elementor\";s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:5:\"3.4.4\";s:7:\"updated\";s:19:\"2021-09-17 14:36:39\";s:7:\"package\";s:76:\"https://downloads.wordpress.org/translation/plugin/elementor/3.4.4/fr_FR.zip\";s:10:\"autoupdate\";b:1;}s:6:\"result\";a:7:{s:6:\"source\";s:62:\"/Applications/MAMP/htdocs/psm/wp-content/upgrade/fr_FR-IEibGT/\";s:12:\"source_files\";a:15:{i:0;s:53:\"elementor-fr_FR-8b6e2710018c32facf5c92283650c03a.json\";i:1;s:53:\"elementor-fr_FR-e16f2427ce816c4dc38ad0b36edc3ef2.json\";i:2;s:18:\"elementor-fr_FR.po\";i:3;s:53:\"elementor-fr_FR-21b2026463ef175722764b7eaf9022f0.json\";i:4;s:53:\"elementor-fr_FR-41155a71eced148d0eaa5aceebbad4ad.json\";i:5;s:53:\"elementor-fr_FR-dde11340ced68bea09c9fd29c9ed4534.json\";i:6;s:53:\"elementor-fr_FR-abe7facb531349e3b9bd791c4c0f183e.json\";i:7;s:53:\"elementor-fr_FR-ac76f1d75eb777f747e6708b19d31b78.json\";i:8;s:53:\"elementor-fr_FR-9de15ead6aa7b3bb8a1ea30a49991974.json\";i:9;s:53:\"elementor-fr_FR-1dbb8b6c1e3d0a728637a838a81040c6.json\";i:10;s:18:\"elementor-fr_FR.mo\";i:11;s:53:\"elementor-fr_FR-8b95a20e21550730e7b5557f56908c73.json\";i:12;s:53:\"elementor-fr_FR-50f7bdee322f202b88cb992c0ace0ac3.json\";i:13;s:53:\"elementor-fr_FR-4a9aafdf461c74b88a1c7041526ae1d6.json\";i:14;s:53:\"elementor-fr_FR-f98be19bec7bc848ce3ed383c60037c1.json\";}s:11:\"destination\";s:58:\"/Applications/MAMP/htdocs/psm/wp-content/languages/plugins\";s:16:\"destination_name\";s:0:\"\";s:17:\"local_destination\";s:58:\"/Applications/MAMP/htdocs/psm/wp-content/languages/plugins\";s:18:\"remote_destination\";s:59:\"/Applications/MAMP/htdocs/psm/wp-content/languages/plugins/\";s:17:\"clear_destination\";b:1;}s:4:\"name\";s:26:\"Traductions pour Elementor\";s:8:\"messages\";a:6:{i:0;s:57:\"Mise à jour de la traduction de Elementor (fr_FR)&#8230;\";i:1;s:119:\"Téléchargement des traductions depuis https://downloads.wordpress.org/translation/plugin/elementor/3.4.4/fr_FR.zip…\";i:2;s:40:\"Décompression de la mise à jour&#8230;\";i:3;s:43:\"Installation de la dernière version&#8230;\";i:4;s:51:\"Retrait de l’ancienne version de la traduction…\";i:5;s:40:\"La traduction a bien été mise à jour.\";}}}}s:6:\"failed\";a:2:{s:6:\"plugin\";a:0:{}s:5:\"theme\";a:0:{}}s:7:\"success\";a:3:{s:6:\"plugin\";a:0:{}s:5:\"theme\";a:0:{}s:11:\"translation\";a:2:{i:0;s:21:\"plugin:contact-form-7\";i:1;s:16:\"plugin:elementor\";}}}}}", "no");
INSERT INTO `psm_options` VALUES("7338", "_transient_timeout_wc_term_counts", "1635335835", "no");
INSERT INTO `psm_options` VALUES("7339", "_transient_wc_term_counts", "a:11:{i:15;s:1:\"1\";i:25;s:1:\"1\";i:26;s:1:\"1\";i:28;s:1:\"1\";i:27;s:1:\"2\";i:30;s:1:\"2\";i:24;s:1:\"2\";i:31;s:1:\"1\";i:22;s:1:\"1\";i:29;s:1:\"1\";i:23;s:1:\"1\";}", "no");
INSERT INTO `psm_options` VALUES("7396", "rewrite_rules", "a:213:{s:24:\"^wc-auth/v([1]{1})/(.*)?\";s:63:\"index.php?wc-auth-version=$matches[1]&wc-auth-route=$matches[2]\";s:22:\"^wc-api/v([1-3]{1})/?$\";s:51:\"index.php?wc-api-version=$matches[1]&wc-api-route=/\";s:24:\"^wc-api/v([1-3]{1})(.*)?\";s:61:\"index.php?wc-api-version=$matches[1]&wc-api-route=$matches[2]\";s:19:\"sitemap_index\\.xml$\";s:19:\"index.php?sitemap=1\";s:31:\"([^/]+?)-sitemap([0-9]+)?\\.xml$\";s:51:\"index.php?sitemap=$matches[1]&sitemap_n=$matches[2]\";s:24:\"([a-z]+)?-?sitemap\\.xsl$\";s:39:\"index.php?yoast-sitemap-xsl=$matches[1]\";s:11:\"boutique/?$\";s:27:\"index.php?post_type=product\";s:41:\"boutique/feed/(feed|rdf|rss|rss2|atom)/?$\";s:44:\"index.php?post_type=product&feed=$matches[1]\";s:36:\"boutique/(feed|rdf|rss|rss2|atom)/?$\";s:44:\"index.php?post_type=product&feed=$matches[1]\";s:28:\"boutique/page/([0-9]{1,})/?$\";s:45:\"index.php?post_type=product&paged=$matches[1]\";s:11:\"^wp-json/?$\";s:22:\"index.php?rest_route=/\";s:14:\"^wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:21:\"^index.php/wp-json/?$\";s:22:\"index.php?rest_route=/\";s:24:\"^index.php/wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:17:\"^wp-sitemap\\.xml$\";s:23:\"index.php?sitemap=index\";s:17:\"^wp-sitemap\\.xsl$\";s:36:\"index.php?sitemap-stylesheet=sitemap\";s:23:\"^wp-sitemap-index\\.xsl$\";s:34:\"index.php?sitemap-stylesheet=index\";s:48:\"^wp-sitemap-([a-z]+?)-([a-z\\d_-]+?)-(\\d+?)\\.xml$\";s:75:\"index.php?sitemap=$matches[1]&sitemap-subtype=$matches[2]&paged=$matches[3]\";s:34:\"^wp-sitemap-([a-z]+?)-(\\d+?)\\.xml$\";s:47:\"index.php?sitemap=$matches[1]&paged=$matches[2]\";s:61:\"^\\.well-known\\/apple-developer-merchantid-domain-association$\";s:57:\"index.php?apple-developer-merchantid-domain-association=1\";s:49:\"language/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?lang=$matches[1]&feed=$matches[2]\";s:44:\"language/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?lang=$matches[1]&feed=$matches[2]\";s:25:\"language/([^/]+)/embed/?$\";s:37:\"index.php?lang=$matches[1]&embed=true\";s:37:\"language/([^/]+)/page/?([0-9]{1,})/?$\";s:44:\"index.php?lang=$matches[1]&paged=$matches[2]\";s:19:\"language/([^/]+)/?$\";s:26:\"index.php?lang=$matches[1]\";s:47:\"category/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:42:\"category/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:23:\"category/(.+?)/embed/?$\";s:46:\"index.php?category_name=$matches[1]&embed=true\";s:35:\"category/(.+?)/page/?([0-9]{1,})/?$\";s:53:\"index.php?category_name=$matches[1]&paged=$matches[2]\";s:32:\"category/(.+?)/wc-api(/(.*))?/?$\";s:54:\"index.php?category_name=$matches[1]&wc-api=$matches[3]\";s:17:\"category/(.+?)/?$\";s:35:\"index.php?category_name=$matches[1]\";s:44:\"tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:39:\"tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:20:\"tag/([^/]+)/embed/?$\";s:36:\"index.php?tag=$matches[1]&embed=true\";s:32:\"tag/([^/]+)/page/?([0-9]{1,})/?$\";s:43:\"index.php?tag=$matches[1]&paged=$matches[2]\";s:29:\"tag/([^/]+)/wc-api(/(.*))?/?$\";s:44:\"index.php?tag=$matches[1]&wc-api=$matches[3]\";s:14:\"tag/([^/]+)/?$\";s:25:\"index.php?tag=$matches[1]\";s:45:\"type/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:40:\"type/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:21:\"type/([^/]+)/embed/?$\";s:44:\"index.php?post_format=$matches[1]&embed=true\";s:33:\"type/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?post_format=$matches[1]&paged=$matches[2]\";s:15:\"type/([^/]+)/?$\";s:33:\"index.php?post_format=$matches[1]\";s:42:\"e-landing-page/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:52:\"e-landing-page/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:72:\"e-landing-page/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:67:\"e-landing-page/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:67:\"e-landing-page/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:48:\"e-landing-page/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:31:\"e-landing-page/([^/]+)/embed/?$\";s:47:\"index.php?e-landing-page=$matches[1]&embed=true\";s:35:\"e-landing-page/([^/]+)/trackback/?$\";s:41:\"index.php?e-landing-page=$matches[1]&tb=1\";s:43:\"e-landing-page/([^/]+)/page/?([0-9]{1,})/?$\";s:54:\"index.php?e-landing-page=$matches[1]&paged=$matches[2]\";s:50:\"e-landing-page/([^/]+)/comment-page-([0-9]{1,})/?$\";s:54:\"index.php?e-landing-page=$matches[1]&cpage=$matches[2]\";s:40:\"e-landing-page/([^/]+)/wc-api(/(.*))?/?$\";s:55:\"index.php?e-landing-page=$matches[1]&wc-api=$matches[3]\";s:46:\"e-landing-page/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:57:\"e-landing-page/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:39:\"e-landing-page/([^/]+)(?:/([0-9]+))?/?$\";s:53:\"index.php?e-landing-page=$matches[1]&page=$matches[2]\";s:31:\"e-landing-page/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:41:\"e-landing-page/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:61:\"e-landing-page/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:56:\"e-landing-page/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:56:\"e-landing-page/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:37:\"e-landing-page/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:56:\"categorie-produit/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?product_cat=$matches[1]&feed=$matches[2]\";s:51:\"categorie-produit/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?product_cat=$matches[1]&feed=$matches[2]\";s:32:\"categorie-produit/(.+?)/embed/?$\";s:44:\"index.php?product_cat=$matches[1]&embed=true\";s:44:\"categorie-produit/(.+?)/page/?([0-9]{1,})/?$\";s:51:\"index.php?product_cat=$matches[1]&paged=$matches[2]\";s:26:\"categorie-produit/(.+?)/?$\";s:33:\"index.php?product_cat=$matches[1]\";s:58:\"etiquette-produit/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?product_tag=$matches[1]&feed=$matches[2]\";s:53:\"etiquette-produit/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?product_tag=$matches[1]&feed=$matches[2]\";s:34:\"etiquette-produit/([^/]+)/embed/?$\";s:44:\"index.php?product_tag=$matches[1]&embed=true\";s:46:\"etiquette-produit/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?product_tag=$matches[1]&paged=$matches[2]\";s:28:\"etiquette-produit/([^/]+)/?$\";s:33:\"index.php?product_tag=$matches[1]\";s:35:\"produit/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:45:\"produit/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:65:\"produit/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"produit/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"produit/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:41:\"produit/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:24:\"produit/([^/]+)/embed/?$\";s:40:\"index.php?product=$matches[1]&embed=true\";s:28:\"produit/([^/]+)/trackback/?$\";s:34:\"index.php?product=$matches[1]&tb=1\";s:48:\"produit/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:46:\"index.php?product=$matches[1]&feed=$matches[2]\";s:43:\"produit/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:46:\"index.php?product=$matches[1]&feed=$matches[2]\";s:36:\"produit/([^/]+)/page/?([0-9]{1,})/?$\";s:47:\"index.php?product=$matches[1]&paged=$matches[2]\";s:43:\"produit/([^/]+)/comment-page-([0-9]{1,})/?$\";s:47:\"index.php?product=$matches[1]&cpage=$matches[2]\";s:33:\"produit/([^/]+)/wc-api(/(.*))?/?$\";s:48:\"index.php?product=$matches[1]&wc-api=$matches[3]\";s:39:\"produit/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:50:\"produit/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:32:\"produit/([^/]+)(?:/([0-9]+))?/?$\";s:46:\"index.php?product=$matches[1]&page=$matches[2]\";s:24:\"produit/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:34:\"produit/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:54:\"produit/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:49:\"produit/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:49:\"produit/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:30:\"produit/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:55:\"fb_product_set/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:53:\"index.php?fb_product_set=$matches[1]&feed=$matches[2]\";s:50:\"fb_product_set/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:53:\"index.php?fb_product_set=$matches[1]&feed=$matches[2]\";s:31:\"fb_product_set/([^/]+)/embed/?$\";s:47:\"index.php?fb_product_set=$matches[1]&embed=true\";s:43:\"fb_product_set/([^/]+)/page/?([0-9]{1,})/?$\";s:54:\"index.php?fb_product_set=$matches[1]&paged=$matches[2]\";s:25:\"fb_product_set/([^/]+)/?$\";s:36:\"index.php?fb_product_set=$matches[1]\";s:40:\"elementor-hf/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:50:\"elementor-hf/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:70:\"elementor-hf/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:65:\"elementor-hf/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:65:\"elementor-hf/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:46:\"elementor-hf/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:29:\"elementor-hf/([^/]+)/embed/?$\";s:45:\"index.php?elementor-hf=$matches[1]&embed=true\";s:33:\"elementor-hf/([^/]+)/trackback/?$\";s:39:\"index.php?elementor-hf=$matches[1]&tb=1\";s:41:\"elementor-hf/([^/]+)/page/?([0-9]{1,})/?$\";s:52:\"index.php?elementor-hf=$matches[1]&paged=$matches[2]\";s:48:\"elementor-hf/([^/]+)/comment-page-([0-9]{1,})/?$\";s:52:\"index.php?elementor-hf=$matches[1]&cpage=$matches[2]\";s:38:\"elementor-hf/([^/]+)/wc-api(/(.*))?/?$\";s:53:\"index.php?elementor-hf=$matches[1]&wc-api=$matches[3]\";s:44:\"elementor-hf/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:55:\"elementor-hf/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:37:\"elementor-hf/([^/]+)(?:/([0-9]+))?/?$\";s:51:\"index.php?elementor-hf=$matches[1]&page=$matches[2]\";s:29:\"elementor-hf/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:39:\"elementor-hf/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:59:\"elementor-hf/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:54:\"elementor-hf/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:54:\"elementor-hf/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:35:\"elementor-hf/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:48:\".*wp-(atom|rdf|rss|rss2|feed|commentsrss2)\\.php$\";s:18:\"index.php?feed=old\";s:20:\".*wp-app\\.php(/.*)?$\";s:19:\"index.php?error=403\";s:18:\".*wp-register.php$\";s:23:\"index.php?register=true\";s:32:\"feed/(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:27:\"(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:8:\"embed/?$\";s:21:\"index.php?&embed=true\";s:20:\"page/?([0-9]{1,})/?$\";s:28:\"index.php?&paged=$matches[1]\";s:27:\"comment-page-([0-9]{1,})/?$\";s:39:\"index.php?&page_id=88&cpage=$matches[1]\";s:17:\"wc-api(/(.*))?/?$\";s:29:\"index.php?&wc-api=$matches[2]\";s:41:\"comments/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:36:\"comments/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:17:\"comments/embed/?$\";s:21:\"index.php?&embed=true\";s:26:\"comments/wc-api(/(.*))?/?$\";s:29:\"index.php?&wc-api=$matches[2]\";s:44:\"search/(.+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:39:\"search/(.+)/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:20:\"search/(.+)/embed/?$\";s:34:\"index.php?s=$matches[1]&embed=true\";s:32:\"search/(.+)/page/?([0-9]{1,})/?$\";s:41:\"index.php?s=$matches[1]&paged=$matches[2]\";s:29:\"search/(.+)/wc-api(/(.*))?/?$\";s:42:\"index.php?s=$matches[1]&wc-api=$matches[3]\";s:14:\"search/(.+)/?$\";s:23:\"index.php?s=$matches[1]\";s:47:\"author/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:42:\"author/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:23:\"author/([^/]+)/embed/?$\";s:44:\"index.php?author_name=$matches[1]&embed=true\";s:35:\"author/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?author_name=$matches[1]&paged=$matches[2]\";s:32:\"author/([^/]+)/wc-api(/(.*))?/?$\";s:52:\"index.php?author_name=$matches[1]&wc-api=$matches[3]\";s:17:\"author/([^/]+)/?$\";s:33:\"index.php?author_name=$matches[1]\";s:69:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:64:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:45:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/embed/?$\";s:74:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&embed=true\";s:57:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:81:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&paged=$matches[4]\";s:54:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/wc-api(/(.*))?/?$\";s:82:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&wc-api=$matches[5]\";s:39:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/?$\";s:63:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]\";s:56:\"([0-9]{4})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:51:\"([0-9]{4})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:32:\"([0-9]{4})/([0-9]{1,2})/embed/?$\";s:58:\"index.php?year=$matches[1]&monthnum=$matches[2]&embed=true\";s:44:\"([0-9]{4})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:65:\"index.php?year=$matches[1]&monthnum=$matches[2]&paged=$matches[3]\";s:41:\"([0-9]{4})/([0-9]{1,2})/wc-api(/(.*))?/?$\";s:66:\"index.php?year=$matches[1]&monthnum=$matches[2]&wc-api=$matches[4]\";s:26:\"([0-9]{4})/([0-9]{1,2})/?$\";s:47:\"index.php?year=$matches[1]&monthnum=$matches[2]\";s:43:\"([0-9]{4})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:38:\"([0-9]{4})/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:19:\"([0-9]{4})/embed/?$\";s:37:\"index.php?year=$matches[1]&embed=true\";s:31:\"([0-9]{4})/page/?([0-9]{1,})/?$\";s:44:\"index.php?year=$matches[1]&paged=$matches[2]\";s:28:\"([0-9]{4})/wc-api(/(.*))?/?$\";s:45:\"index.php?year=$matches[1]&wc-api=$matches[3]\";s:13:\"([0-9]{4})/?$\";s:26:\"index.php?year=$matches[1]\";s:27:\".?.+?/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\".?.+?/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\".?.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\".?.+?/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"(.?.+?)/embed/?$\";s:41:\"index.php?pagename=$matches[1]&embed=true\";s:20:\"(.?.+?)/trackback/?$\";s:35:\"index.php?pagename=$matches[1]&tb=1\";s:40:\"(.?.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:35:\"(.?.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:28:\"(.?.+?)/page/?([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&paged=$matches[2]\";s:35:\"(.?.+?)/comment-page-([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&cpage=$matches[2]\";s:25:\"(.?.+?)/wc-api(/(.*))?/?$\";s:49:\"index.php?pagename=$matches[1]&wc-api=$matches[3]\";s:28:\"(.?.+?)/order-pay(/(.*))?/?$\";s:52:\"index.php?pagename=$matches[1]&order-pay=$matches[3]\";s:33:\"(.?.+?)/order-received(/(.*))?/?$\";s:57:\"index.php?pagename=$matches[1]&order-received=$matches[3]\";s:25:\"(.?.+?)/orders(/(.*))?/?$\";s:49:\"index.php?pagename=$matches[1]&orders=$matches[3]\";s:29:\"(.?.+?)/view-order(/(.*))?/?$\";s:53:\"index.php?pagename=$matches[1]&view-order=$matches[3]\";s:28:\"(.?.+?)/downloads(/(.*))?/?$\";s:52:\"index.php?pagename=$matches[1]&downloads=$matches[3]\";s:31:\"(.?.+?)/edit-account(/(.*))?/?$\";s:55:\"index.php?pagename=$matches[1]&edit-account=$matches[3]\";s:31:\"(.?.+?)/edit-address(/(.*))?/?$\";s:55:\"index.php?pagename=$matches[1]&edit-address=$matches[3]\";s:34:\"(.?.+?)/payment-methods(/(.*))?/?$\";s:58:\"index.php?pagename=$matches[1]&payment-methods=$matches[3]\";s:32:\"(.?.+?)/lost-password(/(.*))?/?$\";s:56:\"index.php?pagename=$matches[1]&lost-password=$matches[3]\";s:34:\"(.?.+?)/customer-logout(/(.*))?/?$\";s:58:\"index.php?pagename=$matches[1]&customer-logout=$matches[3]\";s:37:\"(.?.+?)/add-payment-method(/(.*))?/?$\";s:61:\"index.php?pagename=$matches[1]&add-payment-method=$matches[3]\";s:40:\"(.?.+?)/delete-payment-method(/(.*))?/?$\";s:64:\"index.php?pagename=$matches[1]&delete-payment-method=$matches[3]\";s:45:\"(.?.+?)/set-default-payment-method(/(.*))?/?$\";s:69:\"index.php?pagename=$matches[1]&set-default-payment-method=$matches[3]\";s:31:\".?.+?/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:42:\".?.+?/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:24:\"(.?.+?)(?:/([0-9]+))?/?$\";s:47:\"index.php?pagename=$matches[1]&page=$matches[2]\";s:27:\"[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\"[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\"[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\"[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"([^/]+)/embed/?$\";s:37:\"index.php?name=$matches[1]&embed=true\";s:20:\"([^/]+)/trackback/?$\";s:31:\"index.php?name=$matches[1]&tb=1\";s:40:\"([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?name=$matches[1]&feed=$matches[2]\";s:35:\"([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?name=$matches[1]&feed=$matches[2]\";s:28:\"([^/]+)/page/?([0-9]{1,})/?$\";s:44:\"index.php?name=$matches[1]&paged=$matches[2]\";s:35:\"([^/]+)/comment-page-([0-9]{1,})/?$\";s:44:\"index.php?name=$matches[1]&cpage=$matches[2]\";s:25:\"([^/]+)/wc-api(/(.*))?/?$\";s:45:\"index.php?name=$matches[1]&wc-api=$matches[3]\";s:31:\"[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:42:\"[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:24:\"([^/]+)(?:/([0-9]+))?/?$\";s:43:\"index.php?name=$matches[1]&page=$matches[2]\";s:16:\"[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:26:\"[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:46:\"[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:41:\"[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:41:\"[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:22:\"[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";}", "yes");
INSERT INTO `psm_options` VALUES("7446", "theme_mods_elementor-safe", "a:1:{s:18:\"custom_css_post_id\";i:-1;}", "yes");
INSERT INTO `psm_options` VALUES("7573", "_elementor_global_css", "a:6:{s:4:\"time\";i:1632743835;s:5:\"fonts\";a:0:{}s:5:\"icons\";a:0:{}s:20:\"dynamic_elements_ids\";a:0:{}s:6:\"status\";s:4:\"file\";i:0;b:0;}", "yes");
INSERT INTO `psm_options` VALUES("7713", "_transient_timeout_elementor_rollback_versions_3.4.4", "1633624100", "no");
INSERT INTO `psm_options` VALUES("7714", "_transient_elementor_rollback_versions_3.4.4", "a:30:{i:0;s:5:\"3.4.3\";i:1;s:5:\"3.4.2\";i:2;s:5:\"3.4.1\";i:3;s:5:\"3.4.0\";i:4;s:5:\"3.3.1\";i:5;s:5:\"3.3.0\";i:6;s:5:\"3.2.5\";i:7;s:5:\"3.2.4\";i:8;s:5:\"3.2.3\";i:9;s:5:\"3.2.2\";i:10;s:5:\"3.2.1\";i:11;s:5:\"3.2.0\";i:12;s:5:\"3.1.4\";i:13;s:5:\"3.1.3\";i:14;s:5:\"3.1.2\";i:15;s:5:\"3.1.1\";i:16;s:5:\"3.1.0\";i:17;s:5:\"3.0.9\";i:18;s:7:\"3.0.8.1\";i:19;s:5:\"3.0.8\";i:20;s:5:\"3.0.7\";i:21;s:5:\"3.0.6\";i:22;s:5:\"3.0.5\";i:23;s:5:\"3.0.4\";i:24;s:5:\"3.0.3\";i:25;s:5:\"3.0.2\";i:26;s:6:\"3.0.16\";i:27;s:6:\"3.0.15\";i:28;s:6:\"3.0.14\";i:29;s:6:\"3.0.13\";}", "no");
INSERT INTO `psm_options` VALUES("7722", "_site_transient_timeout_php_check_9dfe9c1407d8720f2aa82fbeb25ecdd3", "1633624123", "no");
INSERT INTO `psm_options` VALUES("7723", "_site_transient_php_check_9dfe9c1407d8720f2aa82fbeb25ecdd3", "a:5:{s:19:\"recommended_version\";s:3:\"7.4\";s:15:\"minimum_version\";s:6:\"5.6.20\";s:12:\"is_supported\";b:1;s:9:\"is_secure\";b:1;s:13:\"is_acceptable\";b:1;}", "no");
INSERT INTO `psm_options` VALUES("7742", "_transient_timeout_wpseo_total_unindexed_posts", "1633366217", "no");
INSERT INTO `psm_options` VALUES("7743", "_transient_wpseo_total_unindexed_posts", "0", "no");
INSERT INTO `psm_options` VALUES("7744", "_transient_timeout_wpseo_total_unindexed_terms", "1633366217", "no");
INSERT INTO `psm_options` VALUES("7745", "_transient_wpseo_total_unindexed_terms", "0", "no");
INSERT INTO `psm_options` VALUES("7746", "_transient_timeout_wpseo_total_unindexed_post_type_archives", "1633366217", "no");
INSERT INTO `psm_options` VALUES("7747", "_transient_wpseo_total_unindexed_post_type_archives", "0", "no");
INSERT INTO `psm_options` VALUES("7748", "_transient_timeout_wpseo_unindexed_post_link_count", "1633366217", "no");
INSERT INTO `psm_options` VALUES("7749", "_transient_wpseo_unindexed_post_link_count", "0", "no");
INSERT INTO `psm_options` VALUES("7750", "_transient_timeout_wpseo_unindexed_term_link_count", "1633366217", "no");
INSERT INTO `psm_options` VALUES("7751", "_transient_wpseo_unindexed_term_link_count", "0", "no");
INSERT INTO `psm_options` VALUES("7760", "_transient_timeout_wc_related_170", "1633369563", "no");
INSERT INTO `psm_options` VALUES("7761", "_transient_wc_related_170", "a:1:{s:51:\"limit=2&exclude_ids%5B0%5D=0&exclude_ids%5B1%5D=170\";a:1:{i:0;s:3:\"204\";}}", "no");
INSERT INTO `psm_options` VALUES("7768", "_transient_timeout_jetpack_https_test", "1633367895", "no");
INSERT INTO `psm_options` VALUES("7769", "_transient_jetpack_https_test", "0", "no");
INSERT INTO `psm_options` VALUES("7770", "_transient_timeout_jetpack_https_test_message", "1633367895", "no");
INSERT INTO `psm_options` VALUES("7771", "_transient_jetpack_https_test_message", "WordPress ne rapporte aucun support pour SSL sur votre site", "no");
INSERT INTO `psm_options` VALUES("7774", "_transient_timeout_wc_report_sales_by_date", "1633435773", "no");
INSERT INTO `psm_options` VALUES("7775", "_transient_wc_report_sales_by_date", "a:16:{s:32:\"75e25a3e17d42a26863384ad802bf819\";a:0:{}s:32:\"a1148eb15bd94e738842836d1e03c3b1\";a:0:{}s:32:\"b08c74a0eed877dd1ca6c3544d520750\";a:0:{}s:32:\"e220423cecfa13c42a719322613f6da3\";N;s:32:\"534082ab920087c70f8d2be2d0e2ba09\";a:0:{}s:32:\"f2207d9e8c7358a41241aedd5ced558f\";a:0:{}s:32:\"78f4605eb600e7f5bd96b3f6c05899bb\";a:0:{}s:32:\"ccf4a8e98e1e04935305ff734e9ba508\";a:0:{}s:32:\"e2628175b3a2175309fa055de711af0c\";a:0:{}s:32:\"4aa1c6682fa8ad09256db0388e704a06\";a:0:{}s:32:\"e33b6c37d89c4aaa67b21c70e83567ba\";a:0:{}s:32:\"6537117303fa5615c74b18a850431021\";N;s:32:\"e53841c787e54838b3fd3c7bfe89cb53\";a:0:{}s:32:\"fb4882c82a0900259165fe9b43174e9e\";a:0:{}s:32:\"4da54f892e9c3a070b34bfa41853a2ad\";a:0:{}s:32:\"5af028000a0c4cdf726feea981309f11\";a:0:{}}", "no");
INSERT INTO `psm_options` VALUES("7776", "_transient_timeout_wc_admin_report", "1633435773", "no");
INSERT INTO `psm_options` VALUES("7777", "_transient_wc_admin_report", "a:2:{s:32:\"ea88a181a53899c89a4653a328478722\";a:0:{}s:32:\"08590b7acb17840668d6626f62380827\";a:0:{}}", "no");
INSERT INTO `psm_options` VALUES("7794", "_transient_timeout_wc_related_204", "1633369528", "no");
INSERT INTO `psm_options` VALUES("7795", "_transient_wc_related_204", "a:1:{s:51:\"limit=2&exclude_ids%5B0%5D=0&exclude_ids%5B1%5D=204\";a:1:{i:0;s:3:\"170\";}}", "no");
INSERT INTO `psm_options` VALUES("7798", "_transient_timeout_jetpack_a8c_data", "1633368559", "no");
INSERT INTO `psm_options` VALUES("7799", "_transient_jetpack_a8c_data", "a:4:{s:4:\"a12s\";i:1763;s:9:\"countries\";i:90;s:9:\"languages\";i:113;s:16:\"featured_plugins\";a:4:{i:0;s:11:\"woocommerce\";i:1;s:14:\"wp-super-cache\";i:2;s:14:\"wp-job-manager\";i:3;s:15:\"co-authors-plus\";}}", "no");
INSERT INTO `psm_options` VALUES("7810", "_transient_timeout_sv_wc_plugin_wc_versions", "1633887432", "no");
INSERT INTO `psm_options` VALUES("7811", "_transient_sv_wc_plugin_wc_versions", "a:135:{i:0;s:5:\"5.7.1\";i:1;s:5:\"5.7.0\";i:2;s:5:\"5.6.1\";i:3;s:5:\"5.6.0\";i:4;s:5:\"5.5.3\";i:5;s:5:\"5.5.2\";i:6;s:5:\"5.5.1\";i:7;s:5:\"5.5.0\";i:8;s:5:\"5.4.3\";i:9;s:5:\"5.4.2\";i:10;s:5:\"5.4.1\";i:11;s:5:\"5.4.0\";i:12;s:5:\"5.3.2\";i:13;s:5:\"5.3.1\";i:14;s:5:\"5.3.0\";i:15;s:5:\"5.2.4\";i:16;s:5:\"5.2.3\";i:17;s:5:\"5.2.2\";i:18;s:5:\"5.2.1\";i:19;s:5:\"5.2.0\";i:20;s:5:\"5.1.2\";i:21;s:5:\"5.1.1\";i:22;s:5:\"5.1.0\";i:23;s:5:\"5.0.2\";i:24;s:5:\"5.0.1\";i:25;s:5:\"5.0.0\";i:26;s:5:\"4.9.4\";i:27;s:5:\"4.9.3\";i:28;s:5:\"4.9.2\";i:29;s:5:\"4.9.1\";i:30;s:5:\"4.9.0\";i:31;s:5:\"4.8.2\";i:32;s:5:\"4.8.1\";i:33;s:5:\"4.8.0\";i:34;s:5:\"4.7.3\";i:35;s:5:\"4.7.2\";i:36;s:5:\"4.7.1\";i:37;s:5:\"4.7.0\";i:38;s:5:\"4.6.4\";i:39;s:5:\"4.6.3\";i:40;s:5:\"4.6.2\";i:41;s:5:\"4.6.1\";i:42;s:5:\"4.6.0\";i:43;s:5:\"4.5.4\";i:44;s:5:\"4.5.3\";i:45;s:5:\"4.5.2\";i:46;s:5:\"4.5.1\";i:47;s:5:\"4.5.0\";i:48;s:5:\"4.4.3\";i:49;s:5:\"4.4.2\";i:50;s:5:\"4.4.1\";i:51;s:5:\"4.4.0\";i:52;s:5:\"4.3.5\";i:53;s:5:\"4.3.4\";i:54;s:5:\"4.3.3\";i:55;s:5:\"4.3.2\";i:56;s:5:\"4.3.1\";i:57;s:5:\"4.3.0\";i:58;s:5:\"4.2.4\";i:59;s:5:\"4.2.3\";i:60;s:5:\"4.2.2\";i:61;s:5:\"4.2.1\";i:62;s:5:\"4.2.0\";i:63;s:5:\"4.1.3\";i:64;s:5:\"4.1.2\";i:65;s:5:\"4.1.1\";i:66;s:5:\"4.1.0\";i:67;s:5:\"4.0.3\";i:68;s:5:\"4.0.2\";i:69;s:5:\"4.0.1\";i:70;s:5:\"4.0.0\";i:71;s:5:\"3.9.4\";i:72;s:5:\"3.9.3\";i:73;s:5:\"3.9.2\";i:74;s:5:\"3.9.1\";i:75;s:5:\"3.9.0\";i:76;s:5:\"3.8.2\";i:77;s:5:\"3.8.1\";i:78;s:5:\"3.8.0\";i:79;s:5:\"3.7.2\";i:80;s:5:\"3.7.1\";i:81;s:5:\"3.7.0\";i:82;s:5:\"3.6.6\";i:83;s:5:\"3.6.5\";i:84;s:5:\"3.6.4\";i:85;s:5:\"3.6.3\";i:86;s:5:\"3.6.2\";i:87;s:5:\"3.6.1\";i:88;s:5:\"3.6.0\";i:89;s:5:\"3.5.9\";i:90;s:5:\"3.5.8\";i:91;s:5:\"3.5.7\";i:92;s:5:\"3.5.6\";i:93;s:5:\"3.5.5\";i:94;s:5:\"3.5.4\";i:95;s:5:\"3.5.3\";i:96;s:5:\"3.5.2\";i:97;s:5:\"3.5.1\";i:98;s:5:\"3.5.0\";i:99;s:5:\"3.4.8\";i:100;s:5:\"3.4.7\";i:101;s:5:\"3.4.6\";i:102;s:5:\"3.4.5\";i:103;s:5:\"3.4.4\";i:104;s:5:\"3.4.3\";i:105;s:5:\"3.4.2\";i:106;s:5:\"3.4.1\";i:107;s:5:\"3.4.0\";i:108;s:5:\"3.3.6\";i:109;s:5:\"3.3.5\";i:110;s:5:\"3.3.4\";i:111;s:5:\"3.3.3\";i:112;s:5:\"3.3.2\";i:113;s:5:\"3.3.1\";i:114;s:5:\"3.3.0\";i:115;s:5:\"3.2.6\";i:116;s:5:\"3.2.5\";i:117;s:5:\"3.2.4\";i:118;s:5:\"3.2.3\";i:119;s:5:\"3.2.2\";i:120;s:5:\"3.2.1\";i:121;s:5:\"3.2.0\";i:122;s:5:\"3.1.2\";i:123;s:5:\"3.1.1\";i:124;s:5:\"3.1.0\";i:125;s:5:\"3.0.9\";i:126;s:5:\"3.0.8\";i:127;s:5:\"3.0.7\";i:128;s:5:\"3.0.6\";i:129;s:5:\"3.0.5\";i:130;s:5:\"3.0.4\";i:131;s:5:\"3.0.3\";i:132;s:5:\"3.0.2\";i:133;s:5:\"3.0.1\";i:134;s:5:\"3.0.0\";}", "no");
INSERT INTO `psm_options` VALUES("7832", "_transient_timeout_orders-all-statuses", "1633888515", "no");
INSERT INTO `psm_options` VALUES("7833", "_transient_orders-all-statuses", "a:2:{s:7:\"version\";s:10:\"1617122731\";s:5:\"value\";a:0:{}}", "no");
INSERT INTO `psm_options` VALUES("7853", "_transient_timeout_yoast_i18n_wordpress-seo_fr_FR", "1633371067", "no");
INSERT INTO `psm_options` VALUES("7854", "_transient_yoast_i18n_wordpress-seo_fr_FR", "O:8:\"stdClass\":14:{s:2:\"id\";i:396146;s:4:\"name\";s:15:\"French (France)\";s:4:\"slug\";s:7:\"default\";s:10:\"project_id\";i:3158;s:6:\"locale\";s:2:\"fr\";s:13:\"current_count\";i:1360;s:18:\"untranslated_count\";i:0;s:13:\"waiting_count\";i:0;s:11:\"fuzzy_count\";i:0;s:9:\"all_count\";i:1360;s:14:\"warnings_count\";i:0;s:18:\"percent_translated\";i:100;s:9:\"wp_locale\";s:5:\"fr_FR\";s:13:\"last_modified\";s:19:\"2021-09-29 13:24:46\";}", "no");
INSERT INTO `psm_options` VALUES("7857", "_site_transient_timeout_browser_c13b7200c84cded4537ab2a9bd2a7ad6", "1633889533", "no");
INSERT INTO `psm_options` VALUES("7858", "_site_transient_browser_c13b7200c84cded4537ab2a9bd2a7ad6", "a:10:{s:4:\"name\";s:6:\"Chrome\";s:7:\"version\";s:12:\"93.0.4577.82\";s:8:\"platform\";s:9:\"Macintosh\";s:10:\"update_url\";s:29:\"https://www.google.com/chrome\";s:7:\"img_src\";s:43:\"http://s.w.org/images/browsers/chrome.png?1\";s:11:\"img_src_ssl\";s:44:\"https://s.w.org/images/browsers/chrome.png?1\";s:15:\"current_version\";s:2:\"18\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;s:6:\"mobile\";b:0;}", "no");
INSERT INTO `psm_options` VALUES("7935", "_transient_timeout__woocommerce_helper_updates", "1633383817", "no");
INSERT INTO `psm_options` VALUES("7936", "_transient__woocommerce_helper_updates", "a:4:{s:4:\"hash\";s:32:\"d751713988987e9331980363e24189ce\";s:7:\"updated\";i:1633340617;s:8:\"products\";a:0:{}s:6:\"errors\";a:1:{i:0;s:10:\"http-error\";}}", "no");
INSERT INTO `psm_options` VALUES("7957", "_transient_timeout_elementor_remote_info_api_data_3.4.4", "1633387020", "no");
INSERT INTO `psm_options` VALUES("7958", "_transient_elementor_remote_info_api_data_3.4.4", "a:4:{s:9:\"timestamp\";s:10:\"1633341103\";s:14:\"upgrade_notice\";a:3:{s:7:\"version\";s:5:\"2.0.0\";s:7:\"message\";s:0:\"\";s:11:\"update_link\";s:0:\"\";}s:11:\"pro_widgets\";a:64:{i:0;a:4:{s:4:\"name\";s:5:\"posts\";s:5:\"title\";s:5:\"Posts\";s:4:\"icon\";s:15:\"eicon-post-list\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:1;a:4:{s:4:\"name\";s:9:\"portfolio\";s:5:\"title\";s:9:\"Portfolio\";s:4:\"icon\";s:18:\"eicon-gallery-grid\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:2;a:4:{s:4:\"name\";s:7:\"gallery\";s:5:\"title\";s:7:\"Gallery\";s:4:\"icon\";s:23:\"eicon-gallery-justified\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:3;a:4:{s:4:\"name\";s:4:\"form\";s:5:\"title\";s:4:\"Form\";s:4:\"icon\";s:21:\"eicon-form-horizontal\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:4;a:4:{s:4:\"name\";s:5:\"login\";s:5:\"title\";s:5:\"Login\";s:4:\"icon\";s:15:\"eicon-lock-user\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:5;a:4:{s:4:\"name\";s:6:\"slides\";s:5:\"title\";s:6:\"Slides\";s:4:\"icon\";s:12:\"eicon-slides\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:6;a:4:{s:4:\"name\";s:8:\"nav-menu\";s:5:\"title\";s:8:\"Nav Menu\";s:4:\"icon\";s:14:\"eicon-nav-menu\";s:10:\"categories\";s:33:\"[\"pro-elements\",\"theme-elements\"]\";}i:7;a:4:{s:4:\"name\";s:17:\"animated-headline\";s:5:\"title\";s:17:\"Animated Headline\";s:4:\"icon\";s:23:\"eicon-animated-headline\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:8;a:4:{s:4:\"name\";s:10:\"price-list\";s:5:\"title\";s:10:\"Price List\";s:4:\"icon\";s:16:\"eicon-price-list\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:9;a:4:{s:4:\"name\";s:11:\"price-table\";s:5:\"title\";s:11:\"Price Table\";s:4:\"icon\";s:17:\"eicon-price-table\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:10;a:4:{s:4:\"name\";s:8:\"flip-box\";s:5:\"title\";s:8:\"Flip Box\";s:4:\"icon\";s:14:\"eicon-flip-box\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:11;a:4:{s:4:\"name\";s:14:\"call-to-action\";s:5:\"title\";s:14:\"Call to Action\";s:4:\"icon\";s:20:\"eicon-image-rollover\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:12;a:4:{s:4:\"name\";s:14:\"media-carousel\";s:5:\"title\";s:14:\"Media Carousel\";s:4:\"icon\";s:20:\"eicon-media-carousel\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:13;a:4:{s:4:\"name\";s:20:\"testimonial-carousel\";s:5:\"title\";s:20:\"Testimonial Carousel\";s:4:\"icon\";s:26:\"eicon-testimonial-carousel\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:14;a:4:{s:4:\"name\";s:7:\"reviews\";s:5:\"title\";s:7:\"Reviews\";s:4:\"icon\";s:12:\"eicon-review\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:15;a:4:{s:4:\"name\";s:17:\"table-of-contents\";s:5:\"title\";s:17:\"Table of Contents\";s:4:\"icon\";s:23:\"eicon-table-of-contents\";s:10:\"categories\";s:33:\"[\"pro-elements\",\"theme-elements\"]\";}i:16;a:4:{s:4:\"name\";s:9:\"countdown\";s:5:\"title\";s:9:\"Countdown\";s:4:\"icon\";s:15:\"eicon-countdown\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:17;a:4:{s:4:\"name\";s:13:\"share-buttons\";s:5:\"title\";s:13:\"Share Buttons\";s:4:\"icon\";s:11:\"eicon-share\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:18;a:4:{s:4:\"name\";s:11:\"search-form\";s:5:\"title\";s:11:\"Search Form\";s:4:\"icon\";s:17:\"eicon-site-search\";s:10:\"categories\";s:18:\"[\"theme-elements\"]\";}i:19;a:4:{s:4:\"name\";s:10:\"author-box\";s:5:\"title\";s:10:\"Author Box\";s:4:\"icon\";s:12:\"eicon-person\";s:10:\"categories\";s:18:\"[\"theme-elements\"]\";}i:20;a:4:{s:4:\"name\";s:13:\"post-comments\";s:5:\"title\";s:13:\"Post Comments\";s:4:\"icon\";s:14:\"eicon-comments\";s:10:\"categories\";s:18:\"[\"theme-elements\"]\";}i:21;a:4:{s:4:\"name\";s:15:\"post-navigation\";s:5:\"title\";s:15:\"Post Navigation\";s:4:\"icon\";s:21:\"eicon-post-navigation\";s:10:\"categories\";s:18:\"[\"theme-elements\"]\";}i:22;a:4:{s:4:\"name\";s:9:\"post-info\";s:5:\"title\";s:9:\"Post Info\";s:4:\"icon\";s:15:\"eicon-post-info\";s:10:\"categories\";s:18:\"[\"theme-elements\"]\";}i:23;a:4:{s:4:\"name\";s:7:\"sitemap\";s:5:\"title\";s:7:\"Sitemap\";s:4:\"icon\";s:13:\"eicon-sitemap\";s:10:\"categories\";s:18:\"[\"theme-elements\"]\";}i:24;a:4:{s:4:\"name\";s:11:\"breadcrumbs\";s:5:\"title\";s:11:\"Breadcrumbs\";s:4:\"icon\";s:11:\"eicon-yoast\";s:10:\"categories\";s:18:\"[\"theme-elements\"]\";}i:25;a:4:{s:4:\"name\";s:10:\"blockquote\";s:5:\"title\";s:10:\"Blockquote\";s:4:\"icon\";s:16:\"eicon-blockquote\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:26;a:4:{s:4:\"name\";s:19:\"wc-archive-products\";s:5:\"title\";s:16:\"Archive Products\";s:4:\"icon\";s:14:\"eicon-products\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:27;a:4:{s:4:\"name\";s:31:\"woocommerce-archive-description\";s:5:\"title\";s:19:\"Archive Description\";s:4:\"icon\";s:25:\"eicon-product-description\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:28;a:4:{s:4:\"name\";s:20:\"woocommerce-products\";s:5:\"title\";s:8:\"Products\";s:4:\"icon\";s:14:\"eicon-products\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:29;a:4:{s:4:\"name\";s:22:\"woocommerce-breadcrumb\";s:5:\"title\";s:23:\"WooCommerce Breadcrumbs\";s:4:\"icon\";s:25:\"eicon-product-breadcrumbs\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:30;a:4:{s:4:\"name\";s:14:\"wc-add-to-cart\";s:5:\"title\";s:18:\"Custom Add To Cart\";s:4:\"icon\";s:17:\"eicon-woocommerce\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:31;a:4:{s:4:\"name\";s:11:\"wc-elements\";s:5:\"title\";s:17:\"WooCommerce Pages\";s:4:\"icon\";s:19:\"eicon-product-pages\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:32;a:4:{s:4:\"name\";s:13:\"wc-categories\";s:5:\"title\";s:18:\"Product Categories\";s:4:\"icon\";s:24:\"eicon-product-categories\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:33;a:4:{s:4:\"name\";s:21:\"woocommerce-menu-cart\";s:5:\"title\";s:9:\"Menu Cart\";s:4:\"icon\";s:10:\"eicon-cart\";s:10:\"categories\";s:41:\"[\"theme-elements\",\"woocommerce-elements\"]\";}i:34;a:4:{s:4:\"name\";s:25:\"woocommerce-product-title\";s:5:\"title\";s:13:\"Product Title\";s:4:\"icon\";s:19:\"eicon-product-title\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:35;a:4:{s:4:\"name\";s:26:\"woocommerce-product-images\";s:5:\"title\";s:14:\"Product Images\";s:4:\"icon\";s:20:\"eicon-product-images\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:36;a:4:{s:4:\"name\";s:25:\"woocommerce-product-price\";s:5:\"title\";s:13:\"Product Price\";s:4:\"icon\";s:19:\"eicon-product-price\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:37;a:4:{s:4:\"name\";s:31:\"woocommerce-product-add-to-cart\";s:5:\"title\";s:11:\"Add To Cart\";s:4:\"icon\";s:25:\"eicon-product-add-to-cart\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:38;a:4:{s:4:\"name\";s:26:\"woocommerce-product-rating\";s:5:\"title\";s:14:\"Product Rating\";s:4:\"icon\";s:20:\"eicon-product-rating\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:39;a:4:{s:4:\"name\";s:25:\"woocommerce-product-stock\";s:5:\"title\";s:13:\"Product Stock\";s:4:\"icon\";s:19:\"eicon-product-stock\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:40;a:4:{s:4:\"name\";s:24:\"woocommerce-product-meta\";s:5:\"title\";s:12:\"Product Meta\";s:4:\"icon\";s:18:\"eicon-product-meta\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:41;a:4:{s:4:\"name\";s:37:\"woocommerce-product-short-description\";s:5:\"title\";s:17:\"Short Description\";s:4:\"icon\";s:25:\"eicon-product-description\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:42;a:4:{s:4:\"name\";s:29:\"woocommerce-product-data-tabs\";s:5:\"title\";s:17:\"Product Data Tabs\";s:4:\"icon\";s:18:\"eicon-product-tabs\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:43;a:4:{s:4:\"name\";s:42:\"woocommerce-product-additional-information\";s:5:\"title\";s:22:\"Additional Information\";s:4:\"icon\";s:19:\" eicon-product-info\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:44;a:4:{s:4:\"name\";s:27:\"woocommerce-product-related\";s:5:\"title\";s:15:\"Product Related\";s:4:\"icon\";s:21:\"eicon-product-related\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:45;a:4:{s:4:\"name\";s:26:\"woocommerce-product-upsell\";s:5:\"title\";s:7:\"Upsells\";s:4:\"icon\";s:20:\"eicon-product-upsell\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:46;a:4:{s:4:\"name\";s:6:\"lottie\";s:5:\"title\";s:6:\"Lottie\";s:4:\"icon\";s:12:\"eicon-lottie\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:47;a:4:{s:4:\"name\";s:15:\"facebook-button\";s:5:\"title\";s:15:\"Facebook Button\";s:4:\"icon\";s:23:\"eicon-facebook-like-box\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:48;a:4:{s:4:\"name\";s:17:\"facebook-comments\";s:5:\"title\";s:17:\"Facebook Comments\";s:4:\"icon\";s:23:\"eicon-facebook-comments\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:49;a:4:{s:4:\"name\";s:14:\"facebook-embed\";s:5:\"title\";s:14:\"Facebook Embed\";s:4:\"icon\";s:14:\"eicon-fb-embed\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:50;a:4:{s:4:\"name\";s:13:\"facebook-page\";s:5:\"title\";s:13:\"Facebook Page\";s:4:\"icon\";s:13:\"eicon-fb-feed\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:51;a:4:{s:4:\"name\";s:7:\"hotspot\";s:5:\"title\";s:7:\"Hotspot\";s:4:\"icon\";s:19:\"eicon-image-hotspot\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:52;a:4:{s:4:\"name\";s:13:\"paypal-button\";s:5:\"title\";s:13:\"PayPal Button\";s:4:\"icon\";s:19:\"eicon-paypal-button\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:53;a:4:{s:4:\"name\";s:14:\"code-highlight\";s:5:\"title\";s:14:\"Code Highlight\";s:4:\"icon\";s:20:\"eicon-code-highlight\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:54;a:4:{s:4:\"name\";s:14:\"video-playlist\";s:5:\"title\";s:14:\"Video Playlist\";s:4:\"icon\";s:20:\"eicon-video-playlist\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:55;a:4:{s:4:\"name\";s:8:\"template\";s:5:\"title\";s:8:\"Template\";s:4:\"icon\";s:19:\"eicon-document-file\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:56;a:4:{s:4:\"name\";s:15:\"theme-site-logo\";s:5:\"title\";s:9:\"Site Logo\";s:4:\"icon\";s:15:\"eicon-site-logo\";s:10:\"categories\";s:18:\"[\"theme-elements\"]\";}i:57;a:4:{s:4:\"name\";s:16:\"theme-site-title\";s:5:\"title\";s:10:\"Site Title\";s:4:\"icon\";s:16:\"eicon-site-title\";s:10:\"categories\";s:18:\"[\"theme-elements\"]\";}i:58;a:4:{s:4:\"name\";s:16:\"theme-page-title\";s:5:\"title\";s:10:\"Page Title\";s:4:\"icon\";s:19:\"eicon-archive-title\";s:10:\"categories\";s:18:\"[\"theme-elements\"]\";}i:59;a:4:{s:4:\"name\";s:16:\"theme-post-title\";s:5:\"title\";s:10:\"Post Title\";s:4:\"icon\";s:16:\"eicon-post-title\";s:10:\"categories\";s:18:\"[\"theme-elements\"]\";}i:60;a:4:{s:4:\"name\";s:18:\"theme-post-excerpt\";s:5:\"title\";s:12:\"Post Excerpt\";s:4:\"icon\";s:18:\"eicon-post-excerpt\";s:10:\"categories\";s:18:\"[\"theme-elements\"]\";}i:61;a:4:{s:4:\"name\";s:25:\"theme-post-featured-image\";s:5:\"title\";s:14:\"Featured Image\";s:4:\"icon\";s:20:\"eicon-featured-image\";s:10:\"categories\";s:18:\"[\"theme-elements\"]\";}i:62;a:4:{s:4:\"name\";s:19:\"theme-archive-title\";s:5:\"title\";s:13:\"Archive Title\";s:4:\"icon\";s:19:\"eicon-archive-title\";s:10:\"categories\";s:18:\"[\"theme-elements\"]\";}i:63;a:4:{s:4:\"name\";s:13:\"archive-posts\";s:5:\"title\";s:13:\"Archive Posts\";s:4:\"icon\";s:19:\"eicon-archive-posts\";s:10:\"categories\";s:18:\"[\"theme-elements\"]\";}}s:17:\"canary_deployment\";a:2:{s:11:\"plugin_info\";a:11:{s:2:\"id\";s:23:\"w.org/plugins/elementor\";s:4:\"slug\";s:9:\"elementor\";s:6:\"plugin\";s:23:\"elementor/elementor.php\";s:11:\"new_version\";s:5:\"3.4.0\";s:7:\"package\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.4.0.zip\";s:3:\"url\";s:40:\"https://wordpress.org/plugins/elementor/\";s:5:\"icons\";a:3:{s:2:\"2x\";s:62:\"https://ps.w.org/elementor/assets/icon-256x256.png?rev=1427768\";s:2:\"1x\";s:54:\"https://ps.w.org/elementor/assets/icon.svg?rev=1426809\";s:3:\"svg\";s:54:\"https://ps.w.org/elementor/assets/icon.svg?rev=1426809\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:65:\"https://ps.w.org/elementor/assets/banner-1544x500.png?rev=1475479\";s:2:\"1x\";s:64:\"https://ps.w.org/elementor/assets/banner-772x250.png?rev=1475479\";}s:11:\"banners_rtl\";a:0:{}s:6:\"tested\";s:5:\"5.8.1\";s:12:\"requires_php\";s:3:\"5.6\";}s:10:\"conditions\";a:1:{i:0;a:1:{i:0;a:3:{s:4:\"type\";s:8:\"language\";s:9:\"languages\";a:26:{i:0;s:5:\"he_IL\";i:1;s:5:\"en_GB\";i:2;s:5:\"en_NZ\";i:3;s:5:\"en_ZA\";i:4;s:5:\"en_AU\";i:5;s:5:\"en_CA\";i:6;s:5:\"sv_SE\";i:7;s:5:\"da_DK\";i:8;s:5:\"fr_FR\";i:9;s:5:\"nl_NL\";i:10;s:5:\"nb_NO\";i:11;s:5:\"de_AT\";i:12;s:2:\"fi\";i:13;s:5:\"it_IT\";i:14;s:5:\"nn_NO\";i:15;s:5:\"de_CH\";i:16;s:5:\"en_GB\";i:17;s:5:\"is_IS\";i:18;s:2:\"ga\";i:19;s:5:\"fr_BE\";i:20;s:5:\"nl_BE\";i:21;s:3:\"ast\";i:22;s:5:\"lb_LU\";i:23;s:5:\"es_ES\";i:24;s:5:\"pt_PT\";i:25;s:3:\"mlt\";}s:8:\"operator\";s:2:\"in\";}}}}}", "no");
INSERT INTO `psm_options` VALUES("8016", "_site_transient_timeout_poptags_40cd750bba9870f18aada2478b24840a", "1633359689", "no");
INSERT INTO `psm_options` VALUES("8017", "_site_transient_poptags_40cd750bba9870f18aada2478b24840a", "O:8:\"stdClass\":100:{s:11:\"woocommerce\";a:3:{s:4:\"name\";s:11:\"woocommerce\";s:4:\"slug\";s:11:\"woocommerce\";s:5:\"count\";i:5169;}s:6:\"widget\";a:3:{s:4:\"name\";s:6:\"widget\";s:4:\"slug\";s:6:\"widget\";s:5:\"count\";i:4767;}s:4:\"post\";a:3:{s:4:\"name\";s:4:\"post\";s:4:\"slug\";s:4:\"post\";s:5:\"count\";i:2732;}s:5:\"admin\";a:3:{s:4:\"name\";s:5:\"admin\";s:4:\"slug\";s:5:\"admin\";s:5:\"count\";i:2603;}s:5:\"posts\";a:3:{s:4:\"name\";s:5:\"posts\";s:4:\"slug\";s:5:\"posts\";s:5:\"count\";i:2014;}s:9:\"shortcode\";a:3:{s:4:\"name\";s:9:\"shortcode\";s:4:\"slug\";s:9:\"shortcode\";s:5:\"count\";i:1868;}s:8:\"comments\";a:3:{s:4:\"name\";s:8:\"comments\";s:4:\"slug\";s:8:\"comments\";s:5:\"count\";i:1855;}s:6:\"images\";a:3:{s:4:\"name\";s:6:\"images\";s:4:\"slug\";s:6:\"images\";s:5:\"count\";i:1528;}s:3:\"seo\";a:3:{s:4:\"name\";s:3:\"seo\";s:4:\"slug\";s:3:\"seo\";s:5:\"count\";i:1519;}s:6:\"google\";a:3:{s:4:\"name\";s:6:\"google\";s:4:\"slug\";s:6:\"google\";s:5:\"count\";i:1508;}s:5:\"image\";a:3:{s:4:\"name\";s:5:\"image\";s:4:\"slug\";s:5:\"image\";s:5:\"count\";i:1503;}s:7:\"twitter\";a:3:{s:4:\"name\";s:7:\"twitter\";s:4:\"slug\";s:7:\"twitter\";s:5:\"count\";i:1501;}s:8:\"facebook\";a:3:{s:4:\"name\";s:8:\"facebook\";s:4:\"slug\";s:8:\"facebook\";s:5:\"count\";i:1474;}s:7:\"sidebar\";a:3:{s:4:\"name\";s:7:\"sidebar\";s:4:\"slug\";s:7:\"sidebar\";s:5:\"count\";i:1312;}s:5:\"email\";a:3:{s:4:\"name\";s:5:\"email\";s:4:\"slug\";s:5:\"email\";s:5:\"count\";i:1285;}s:9:\"ecommerce\";a:3:{s:4:\"name\";s:9:\"ecommerce\";s:4:\"slug\";s:9:\"ecommerce\";s:5:\"count\";i:1284;}s:7:\"gallery\";a:3:{s:4:\"name\";s:7:\"gallery\";s:4:\"slug\";s:7:\"gallery\";s:5:\"count\";i:1239;}s:4:\"page\";a:3:{s:4:\"name\";s:4:\"page\";s:4:\"slug\";s:4:\"page\";s:5:\"count\";i:1162;}s:6:\"social\";a:3:{s:4:\"name\";s:6:\"social\";s:4:\"slug\";s:6:\"social\";s:5:\"count\";i:1131;}s:5:\"login\";a:3:{s:4:\"name\";s:5:\"login\";s:4:\"slug\";s:5:\"login\";s:5:\"count\";i:1069;}s:8:\"security\";a:3:{s:4:\"name\";s:8:\"security\";s:4:\"slug\";s:8:\"security\";s:5:\"count\";i:974;}s:5:\"video\";a:3:{s:4:\"name\";s:5:\"video\";s:4:\"slug\";s:5:\"video\";s:5:\"count\";i:939;}s:7:\"widgets\";a:3:{s:4:\"name\";s:7:\"widgets\";s:4:\"slug\";s:7:\"widgets\";s:5:\"count\";i:916;}s:10:\"e-commerce\";a:3:{s:4:\"name\";s:10:\"e-commerce\";s:4:\"slug\";s:10:\"e-commerce\";s:5:\"count\";i:902;}s:5:\"links\";a:3:{s:4:\"name\";s:5:\"links\";s:4:\"slug\";s:5:\"links\";s:5:\"count\";i:888;}s:4:\"spam\";a:3:{s:4:\"name\";s:4:\"spam\";s:4:\"slug\";s:4:\"spam\";s:5:\"count\";i:841;}s:7:\"content\";a:3:{s:4:\"name\";s:7:\"content\";s:4:\"slug\";s:7:\"content\";s:5:\"count\";i:825;}s:6:\"slider\";a:3:{s:4:\"name\";s:6:\"slider\";s:4:\"slug\";s:6:\"slider\";s:5:\"count\";i:819;}s:9:\"analytics\";a:3:{s:4:\"name\";s:9:\"analytics\";s:4:\"slug\";s:9:\"analytics\";s:5:\"count\";i:816;}s:4:\"form\";a:3:{s:4:\"name\";s:4:\"form\";s:4:\"slug\";s:4:\"form\";s:5:\"count\";i:800;}s:10:\"buddypress\";a:3:{s:4:\"name\";s:10:\"buddypress\";s:4:\"slug\";s:10:\"buddypress\";s:5:\"count\";i:762;}s:5:\"media\";a:3:{s:4:\"name\";s:5:\"media\";s:4:\"slug\";s:5:\"media\";s:5:\"count\";i:755;}s:6:\"search\";a:3:{s:4:\"name\";s:6:\"search\";s:4:\"slug\";s:6:\"search\";s:5:\"count\";i:734;}s:6:\"editor\";a:3:{s:4:\"name\";s:6:\"editor\";s:4:\"slug\";s:6:\"editor\";s:5:\"count\";i:730;}s:3:\"rss\";a:3:{s:4:\"name\";s:3:\"rss\";s:4:\"slug\";s:3:\"rss\";s:5:\"count\";i:730;}s:7:\"payment\";a:3:{s:4:\"name\";s:7:\"payment\";s:4:\"slug\";s:7:\"payment\";s:5:\"count\";i:727;}s:5:\"pages\";a:3:{s:4:\"name\";s:5:\"pages\";s:4:\"slug\";s:5:\"pages\";s:5:\"count\";i:717;}s:4:\"menu\";a:3:{s:4:\"name\";s:4:\"menu\";s:4:\"slug\";s:4:\"menu\";s:5:\"count\";i:689;}s:9:\"gutenberg\";a:3:{s:4:\"name\";s:9:\"gutenberg\";s:4:\"slug\";s:9:\"gutenberg\";s:5:\"count\";i:674;}s:12:\"contact-form\";a:3:{s:4:\"name\";s:12:\"contact form\";s:4:\"slug\";s:12:\"contact-form\";s:5:\"count\";i:670;}s:4:\"feed\";a:3:{s:4:\"name\";s:4:\"feed\";s:4:\"slug\";s:4:\"feed\";s:5:\"count\";i:668;}s:8:\"category\";a:3:{s:4:\"name\";s:8:\"category\";s:4:\"slug\";s:8:\"category\";s:5:\"count\";i:666;}s:6:\"jquery\";a:3:{s:4:\"name\";s:6:\"jquery\";s:4:\"slug\";s:6:\"jquery\";s:5:\"count\";i:665;}s:5:\"embed\";a:3:{s:4:\"name\";s:5:\"embed\";s:4:\"slug\";s:5:\"embed\";s:5:\"count\";i:663;}s:4:\"ajax\";a:3:{s:4:\"name\";s:4:\"ajax\";s:4:\"slug\";s:4:\"ajax\";s:5:\"count\";i:654;}s:15:\"payment-gateway\";a:3:{s:4:\"name\";s:15:\"payment gateway\";s:4:\"slug\";s:15:\"payment-gateway\";s:5:\"count\";i:650;}s:7:\"youtube\";a:3:{s:4:\"name\";s:7:\"youtube\";s:4:\"slug\";s:7:\"youtube\";s:5:\"count\";i:602;}s:3:\"css\";a:3:{s:4:\"name\";s:3:\"css\";s:4:\"slug\";s:3:\"css\";s:5:\"count\";i:600;}s:4:\"link\";a:3:{s:4:\"name\";s:4:\"link\";s:4:\"slug\";s:4:\"link\";s:5:\"count\";i:593;}s:10:\"javascript\";a:3:{s:4:\"name\";s:10:\"javascript\";s:4:\"slug\";s:10:\"javascript\";s:5:\"count\";i:593;}s:9:\"affiliate\";a:3:{s:4:\"name\";s:9:\"affiliate\";s:4:\"slug\";s:9:\"affiliate\";s:5:\"count\";i:578;}s:5:\"share\";a:3:{s:4:\"name\";s:5:\"share\";s:4:\"slug\";s:5:\"share\";s:5:\"count\";i:576;}s:10:\"responsive\";a:3:{s:4:\"name\";s:10:\"responsive\";s:4:\"slug\";s:10:\"responsive\";s:5:\"count\";i:569;}s:9:\"dashboard\";a:3:{s:4:\"name\";s:9:\"dashboard\";s:4:\"slug\";s:9:\"dashboard\";s:5:\"count\";i:568;}s:5:\"theme\";a:3:{s:4:\"name\";s:5:\"theme\";s:4:\"slug\";s:5:\"theme\";s:5:\"count\";i:565;}s:3:\"api\";a:3:{s:4:\"name\";s:3:\"api\";s:4:\"slug\";s:3:\"api\";s:5:\"count\";i:560;}s:7:\"comment\";a:3:{s:4:\"name\";s:7:\"comment\";s:4:\"slug\";s:7:\"comment\";s:5:\"count\";i:556;}s:7:\"contact\";a:3:{s:4:\"name\";s:7:\"contact\";s:4:\"slug\";s:7:\"contact\";s:5:\"count\";i:553;}s:9:\"elementor\";a:3:{s:4:\"name\";s:9:\"elementor\";s:4:\"slug\";s:9:\"elementor\";s:5:\"count\";i:552;}s:3:\"ads\";a:3:{s:4:\"name\";s:3:\"ads\";s:4:\"slug\";s:3:\"ads\";s:5:\"count\";i:551;}s:5:\"block\";a:3:{s:4:\"name\";s:5:\"block\";s:4:\"slug\";s:5:\"block\";s:5:\"count\";i:549;}s:6:\"custom\";a:3:{s:4:\"name\";s:6:\"custom\";s:4:\"slug\";s:6:\"custom\";s:5:\"count\";i:538;}s:10:\"categories\";a:3:{s:4:\"name\";s:10:\"categories\";s:4:\"slug\";s:10:\"categories\";s:5:\"count\";i:535;}s:4:\"user\";a:3:{s:4:\"name\";s:4:\"user\";s:4:\"slug\";s:4:\"user\";s:5:\"count\";i:523;}s:6:\"button\";a:3:{s:4:\"name\";s:6:\"button\";s:4:\"slug\";s:6:\"button\";s:5:\"count\";i:514;}s:6:\"events\";a:3:{s:4:\"name\";s:6:\"events\";s:4:\"slug\";s:6:\"events\";s:5:\"count\";i:511;}s:9:\"marketing\";a:3:{s:4:\"name\";s:9:\"marketing\";s:4:\"slug\";s:9:\"marketing\";s:5:\"count\";i:501;}s:6:\"mobile\";a:3:{s:4:\"name\";s:6:\"mobile\";s:4:\"slug\";s:6:\"mobile\";s:5:\"count\";i:500;}s:4:\"tags\";a:3:{s:4:\"name\";s:4:\"tags\";s:4:\"slug\";s:4:\"tags\";s:5:\"count\";i:500;}s:4:\"chat\";a:3:{s:4:\"name\";s:4:\"chat\";s:4:\"slug\";s:4:\"chat\";s:5:\"count\";i:489;}s:5:\"users\";a:3:{s:4:\"name\";s:5:\"users\";s:4:\"slug\";s:5:\"users\";s:5:\"count\";i:487;}s:5:\"popup\";a:3:{s:4:\"name\";s:5:\"popup\";s:4:\"slug\";s:5:\"popup\";s:5:\"count\";i:474;}s:8:\"shipping\";a:3:{s:4:\"name\";s:8:\"shipping\";s:4:\"slug\";s:8:\"shipping\";s:5:\"count\";i:472;}s:8:\"calendar\";a:3:{s:4:\"name\";s:8:\"calendar\";s:4:\"slug\";s:8:\"calendar\";s:5:\"count\";i:470;}s:14:\"contact-form-7\";a:3:{s:4:\"name\";s:14:\"contact form 7\";s:4:\"slug\";s:14:\"contact-form-7\";s:5:\"count\";i:469;}s:5:\"forms\";a:3:{s:4:\"name\";s:5:\"forms\";s:4:\"slug\";s:5:\"forms\";s:5:\"count\";i:468;}s:10:\"newsletter\";a:3:{s:4:\"name\";s:10:\"newsletter\";s:4:\"slug\";s:10:\"newsletter\";s:5:\"count\";i:453;}s:10:\"navigation\";a:3:{s:4:\"name\";s:10:\"navigation\";s:4:\"slug\";s:10:\"navigation\";s:5:\"count\";i:450;}s:5:\"photo\";a:3:{s:4:\"name\";s:5:\"photo\";s:4:\"slug\";s:5:\"photo\";s:5:\"count\";i:446;}s:9:\"slideshow\";a:3:{s:4:\"name\";s:9:\"slideshow\";s:4:\"slug\";s:9:\"slideshow\";s:5:\"count\";i:444;}s:5:\"stats\";a:3:{s:4:\"name\";s:5:\"stats\";s:4:\"slug\";s:5:\"stats\";s:5:\"count\";i:434;}s:6:\"photos\";a:3:{s:4:\"name\";s:6:\"photos\";s:4:\"slug\";s:6:\"photos\";s:5:\"count\";i:427;}s:10:\"statistics\";a:3:{s:4:\"name\";s:10:\"statistics\";s:4:\"slug\";s:10:\"statistics\";s:5:\"count\";i:423;}s:11:\"performance\";a:3:{s:4:\"name\";s:11:\"performance\";s:4:\"slug\";s:11:\"performance\";s:5:\"count\";i:421;}s:12:\"social-media\";a:3:{s:4:\"name\";s:12:\"social media\";s:4:\"slug\";s:12:\"social-media\";s:5:\"count\";i:412;}s:8:\"redirect\";a:3:{s:4:\"name\";s:8:\"redirect\";s:4:\"slug\";s:8:\"redirect\";s:5:\"count\";i:412;}s:4:\"news\";a:3:{s:4:\"name\";s:4:\"news\";s:4:\"slug\";s:4:\"news\";s:5:\"count\";i:407;}s:10:\"shortcodes\";a:3:{s:4:\"name\";s:10:\"shortcodes\";s:4:\"slug\";s:10:\"shortcodes\";s:5:\"count\";i:402;}s:12:\"notification\";a:3:{s:4:\"name\";s:12:\"notification\";s:4:\"slug\";s:12:\"notification\";s:5:\"count\";i:402;}s:4:\"code\";a:3:{s:4:\"name\";s:4:\"code\";s:4:\"slug\";s:4:\"code\";s:5:\"count\";i:391;}s:7:\"plugins\";a:3:{s:4:\"name\";s:7:\"plugins\";s:4:\"slug\";s:7:\"plugins\";s:5:\"count\";i:390;}s:8:\"tracking\";a:3:{s:4:\"name\";s:8:\"tracking\";s:4:\"slug\";s:8:\"tracking\";s:5:\"count\";i:385;}s:9:\"multisite\";a:3:{s:4:\"name\";s:9:\"multisite\";s:4:\"slug\";s:9:\"multisite\";s:5:\"count\";i:384;}s:6:\"import\";a:3:{s:4:\"name\";s:6:\"import\";s:4:\"slug\";s:6:\"import\";s:5:\"count\";i:381;}s:3:\"url\";a:3:{s:4:\"name\";s:3:\"url\";s:4:\"slug\";s:3:\"url\";s:5:\"count\";i:380;}s:6:\"blocks\";a:3:{s:4:\"name\";s:6:\"blocks\";s:4:\"slug\";s:6:\"blocks\";s:5:\"count\";i:375;}s:4:\"meta\";a:3:{s:4:\"name\";s:4:\"meta\";s:4:\"slug\";s:4:\"meta\";s:5:\"count\";i:373;}s:4:\"list\";a:3:{s:4:\"name\";s:4:\"list\";s:4:\"slug\";s:4:\"list\";s:5:\"count\";i:372;}s:5:\"cache\";a:3:{s:4:\"name\";s:5:\"cache\";s:4:\"slug\";s:5:\"cache\";s:5:\"count\";i:360;}s:16:\"google-analytics\";a:3:{s:4:\"name\";s:16:\"google analytics\";s:4:\"slug\";s:16:\"google-analytics\";s:5:\"count\";i:360;}}", "no");
INSERT INTO `psm_options` VALUES("8028", "duplicator_settings", "a:17:{s:7:\"version\";s:5:\"1.4.3\";s:18:\"uninstall_settings\";b:1;s:15:\"uninstall_files\";b:1;s:16:\"uninstall_tables\";b:1;s:13:\"package_debug\";b:0;s:17:\"package_mysqldump\";b:1;s:22:\"package_mysqldump_path\";s:0:\"\";s:24:\"package_phpdump_qrylimit\";s:3:\"100\";s:17:\"package_zip_flush\";b:0;s:19:\"installer_name_mode\";s:6:\"simple\";s:16:\"storage_position\";s:6:\"wpcont\";s:20:\"storage_htaccess_off\";b:0;s:18:\"archive_build_mode\";i:2;s:17:\"skip_archive_scan\";b:0;s:21:\"unhook_third_party_js\";b:0;s:22:\"unhook_third_party_css\";b:0;s:17:\"active_package_id\";i:1;}", "yes");
INSERT INTO `psm_options` VALUES("8029", "duplicator_version_plugin", "1.4.3", "yes");
INSERT INTO `psm_options` VALUES("8030", "_transient_timeout_wc_upgrade_notice_5.7.1", "1633435425", "no");
INSERT INTO `psm_options` VALUES("8031", "_transient_wc_upgrade_notice_5.7.1", "", "no");
INSERT INTO `psm_options` VALUES("8054", "_site_transient_timeout_elementor_pro_api_request_277b604563d01df", "1633435616", "no");
INSERT INTO `psm_options` VALUES("8055", "_site_transient_elementor_pro_api_request_277b604563d01df", "O:8:\"stdClass\":11:{s:4:\"name\";s:13:\"Elementor Pro\";s:4:\"slug\";s:13:\"elementor-pro\";s:6:\"author\";s:50:\"<a href=\"https://elementor.com/\">Elementor.com</a>\";s:8:\"homepage\";s:22:\"https://elementor.com/\";s:8:\"requires\";s:3:\"5.0\";s:6:\"tested\";s:5:\"5.8.1\";s:7:\"version\";s:5:\"3.4.1\";s:12:\"last_updated\";s:19:\"2021-08-31 15:40:43\";s:13:\"download_link\";s:209:\"https://my.elementor.com/edd-sl/package_download/MTYzMzQzNTYxNjplcC1yNE96U1RGMGw2aG91RnpGaGRIVTE2MTk1MTg1NTBKNXFIMGNLUTJEZWo6MToxMzVkOThlYTkwZGQ2M2U0ZDNlYTU1YmUzMTI1MmZlNjpodHRwQC8vbG9jYWxob3N0QDg4ODgvcHNtOjA=\";s:7:\"banners\";a:2:{s:4:\"high\";s:65:\"https://ps.w.org/elementor/assets/banner-1544x500.png?rev=1494133\";s:3:\"low\";s:65:\"https://ps.w.org/elementor/assets/banner-1544x500.png?rev=1494133\";}s:8:\"sections\";a:2:{s:11:\"description\";s:161:\"Elementor Pro adds new features to the Elementor Page Builder plugin. Control your conversions, your user engagement, your entire website, from one page builder.\";s:9:\"changelog\";s:31708:\"<h4>3.4.1 - 2021-09-01</h4>\n<ul>\n<li>Fix: Sticky functionality is not working if the Additional Custom Breakpoints experiment is active (<a href=\"https://github.com/elementor/elementor/issues/16186\">#16186</a>)</li>\n<li>Fix: Slideshow skin UI glitch in Media Carousel widget</li>\n<li>Fix: Product price typography weight control is not working as expected in Menu Cart widget</li>\n</ul>\n<h4>3.4.0 - 2021-09-01</h4>\n<ul>\n<li>Tweak: Added new Mini Cart layout type in Menu Cart widget (<a href=\"https://github.com/elementor/elementor/issues/11312\">#11312</a>)</li>\n<li>Tweak: Added styling options for Cart, Products, and Cart buttons in Menu Cart widget (<a href=\"https://github.com/elementor/elementor/issues/14952\">#14952</a>)</li>\n<li>Tweak: Added the ability to open cart automatically when an item is added in Menu Cart widget (<a href=\"https://github.com/elementor/elementor/issues/14119\">#14119</a>)</li>\n<li>Tweak: Added the ability to remove an item from cart without reloading the page with an AJAX request (<a href=\"https://github.com/elementor/elementor/issues/9531\">#9531</a>, <a href=\"https://github.com/elementor/elementor/issues/10875\">#10875</a>, <a href=\"https://github.com/elementor/elementor/issues/11309\">#11309</a>)</li>\n<li>Tweak: Added Load More AJAX functionality to Posts widget (<a href=\"https://github.com/elementor/elementor/issues/12126\">#12126</a>, <a href=\"https://github.com/elementor/elementor/issues/1284\">#1284</a>, <a href=\"https://github.com/elementor/elementor/issues/14557\">#14557</a>)</li>\n<li>Tweak: Added Vimeo support to the Video Playlist widget (<a href=\"https://github.com/elementor/elementor/issues/15319\">#15319</a>)</li>\n<li>Tweak: Improved asset loading performance by serving lighter JS files (<a href=\"https://github.com/elementor/elementor/issues/8572\">#8572</a>)</li>\n<li>Tweak: Added query string to the URL only after the first video is played in Video Playlist widget (<a href=\"https://github.com/elementor/elementor/issues/15348\">#15348</a>)</li>\n<li>Tweak: Added various layout options with more responsive controls and cart structure options in Menu Cart widget</li>\n<li>Tweak: Added the option to open the menu cart by click or hover in Menu Cart widget</li>\n<li>Tweak: Added the ability to choose a specific product to draw data from in WooCommerce Dynamic tags</li>\n<li>Tweak: Removed auto-scroll to the widget location when arriving from external URL in Video Playlist widget</li>\n<li>Tweak: Removed the Video Playlist widget from the Experiments list</li>\n<li>Tweak: Added descriptive error messages for MailChimp action after submit and on form submit in Forms widget</li>\n<li>Tweak: Added tooltip trigger None and Hover for link in Hotspot widget</li>\n<li>Tweak: Added responsive controls to Offset and Effects Offset in Sticky options</li>\n<li>Tweak: Added responsive control to Alignment in Testimonial Carousel widget</li>\n<li>Tweak: Adjusted Motion Effects module to support future feature</li>\n<li>Tweak: Added future compatibility to support better loading of <code>eicons</code> font</li>\n<li>Tweak: Changed Rename Part title and button color in Theme Builder</li>\n<li>Fix: Products don\'t appear on the cart while editing in Menu Cart widget (<a href=\"https://github.com/elementor/elementor/issues/15451\">#15451</a>)</li>\n<li>Fix: Videos always start muted in the Video Playlist widget (<a href=\"https://github.com/elementor/elementor/issues/15292\">#15292</a>)</li>\n<li>Fix: Unnecessary spacing if submenu indicator is set to None in Nav Menu widget (<a href=\"https://github.com/elementor/elementor/issues/15365\">#15365</a>)</li>\n<li>Fix: MailChimp double opt-in feature doesn\'t work in Forms widget</li>\n<li>Fix: Fetching MailChimp groups field blocks the loading of the rest of the fields in the Form widget</li>\n<li>Fix: Missing field IDs causes forms not to be sent in Forms widget</li>\n<li>Fix: Full Content Skin is not working properly when inserted twice on the same page in Posts widget</li>\n<li>Fix: Avoid Duplicates option doesn\'t exclude manual selections in Posts widget</li>\n<li>Fix: Submenu indicator alignment issue in Nav menu widget</li>\n<li>Fix: Query control deprecated message appears when debug mode is defined</li>\n<li>Fix: Tweet Button icon incorrect color and size when the icon is rendered as SVG in Blockquote widget</li>\n<li>Fix: Video icon size is not changing on Active state in Video Playlist widget</li>\n<li>Fix: Header icon color is not working in Table Of Content widget</li>\n<li>Fix: Icons style glitches when Font Awesome Inline experiment is active in Video Playlist widget</li>\n<li>Fix: Bullet markers are not visible on preview mode when Font Awesome Inline experiment is active in Table of Content widget</li>\n<li>Fix: UI Glitch when Font-Awesome Inline experiment is active in Price Table widget</li>\n<li>Fix: Submenu Indicator appears larger when Font Awesome Inline experiment is active in Nav Menu widget</li>\n<li>Fix: Part name is deleted when clicking on the &quot;Change&quot; Button without changing the name in Theme Builder</li>\n<li>Fix: Redundant pagination queries in the Editor</li>\n<li>Deprecated: Remove all usages of <code>Elementor\\Utils::get_create_new_post_url()</code></li>\n<li>Deprecated: See all deprecations to this version in our <a href=\"https://developers.elementor.com/v3-4-planned-deprecations/\">Developers Deprecations Post</a></li>\n</ul>\n<h4>3.3.8 - 2021-08-23</h4>\n<ul>\n<li>Fix: Products grid width issue when adjusting columns and rows in Products widget (<a href=\"https://github.com/elementor/elementor/issues/16001\">#16001</a>)</li>\n<li>Fix: Font Awesome Inline experiment causes icons glitch in Price Table widget (<a href=\"https://github.com/elementor/elementor/issues/16045\">#16045</a>)</li>\n<li>Fix: reCAPTCHA v3 <code>z-index</code> is lower than the Section\'s background color</li>\n<li>Fix: Style missing when Font Awesome inline experiment is active in Post Info widget</li>\n<li>Fix: Font Awesome icons were not loaded in Post Info widget</li>\n<li>Fix: Zero character can\'t be used as a placeholder in Number field in Form widget</li>\n<li>Fix: Carousels are not working properly in the Editor when Additional Custom Breakpoints experiment is active</li>\n</ul>\n<h4>3.3.7 - 2021-08-15</h4>\n<ul>\n<li>Tweak: Added support for Additional Custom Breakpoints in Nav Menu widget</li>\n<li>Tweak: Added support for Additional Custom breakpoints in Motion Effects</li>\n<li>Fix: Columns didn\'t respond to changes in Gallery widget if Additional Custom Breakpoints Experiment is active</li>\n</ul>\n<h4>3.3.6 - 2021-08-10</h4>\n<ul>\n<li>Tweak: Added support for future feature in Nav Menu widget</li>\n<li>Fix: WooCommerce responsive grid styles are not being reflected in Product Related widget (<a href=\"https://github.com/elementor/elementor/issues/15857\">#15857</a>)</li>\n<li>Fix: WooCommerce responsive grid styles are not being reflected in Upsells widget (<a href=\"https://github.com/elementor/elementor/issues/15857\">#15857</a>)</li>\n<li>Fix: WooCommerce responsive grid styles are not being reflected in Product Categories widget (<a href=\"https://github.com/elementor/elementor/issues/15857\">#15857</a>)</li>\n</ul>\n<h4>3.3.5 - 2021-08-01</h4>\n<ul>\n<li>Fix: Responsive layout glitches in Products and Products Archive widgets (<a href=\"https://github.com/elementor/elementor/issues/15773\">#15773</a>)</li>\n<li>Fix: reCAPTCHA V3 integration conflict with required fields validation in Forms widget</li>\n</ul>\n<h4>3.3.4 - 2021-07-21</h4>\n<ul>\n<li>Fix: Grid layout glitch in WooCommerce Products Archive widget (<a href=\"https://github.com/elementor/elementor/issues/15718\">#15718</a>)</li>\n</ul>\n<h4>3.3.3 - 2021-07-20</h4>\n<ul>\n<li>Tweak: Added a descriptive message in Collect Submissions action after submit</li>\n<li>Tweak: Added future compatibility for Additional Custom Breakpoints for Pro widgets</li>\n<li>Fix: Some widget style breaks when Improved CSS Loading Experiment is active in certain cases (<a href=\"https://github.com/elementor/elementor/issues/15632\">#15632</a>, <a href=\"https://github.com/elementor/elementor/issues/15683\">#15683</a>, <a href=\"https://github.com/elementor/elementor/issues/15660\">#15660</a>)</li>\n<li>Fix: Translation update keep appearing as available after install (<a href=\"https://github.com/elementor/elementor/issues/14297\">#14297</a>)</li>\n<li>Fix: Wrong default icon color when using Font Awesome icons as inline SVG in Call to Action widget</li>\n</ul>\n<h4>3.3.2 - 2021-07-13</h4>\n<ul>\n<li>Tweak: Updated plugin description</li>\n<li>Fix: MailChimp tags in form widget replaced existing tags (<a href=\"https://github.com/elementor/elementor/issues/11111\">#11111</a>)</li>\n<li>Fix: Clicking videos from the items list in edit mode doesn’t initiate videos properly</li>\n<li>Fix: User unauthorized message when activated but not connected in Kit Library</li>\n<li>Fix: Carousel widgets did not support additional custom breakpoint responsive values</li>\n<li>Fix: Tab border is overridden by the Section background color in Video Playlist widget</li>\n<li>Fix: Widgets style breaks when Improved CSS Load experiment is active in a Single Page template and Post Content widget</li>\n</ul>\n<h4>3.3.1 - 2021-06-20</h4>\n<ul>\n<li>Tweak: Added support for more Theme Builder display conditions in Export / Import experiment</li>\n<li>Tweak: Adjusted License page heading structure for future feature</li>\n<li>Tweak: Adjusted Font Awesome icon for allowing support for future feature</li>\n<li>Fix: <code>frontend.min.js</code> file size increased in Elementor Pro 3.3.0 (<a href=\"https://github.com/elementor/elementor/issues/15278\">#15278</a>)</li>\n<li>Fix: Prevent conditions from being reset when object cache is enabled in site (<a href=\"https://github.com/elementor/elementor/issues/13299\">#13299</a>)</li>\n<li>Fix: Custom Code publish modal responsiveness issues (<a href=\"https://github.com/elementor/elementor/issues/14519\">#14519</a>)</li>\n<li>Fix: Populating fields with options programmatically doesn\'t appear in Submissions screen (<a href=\"https://github.com/elementor/elementor/issues/10671\">#10671</a>)</li>\n<li>Fix: Large images are not shown on the Image Carousel widget when set via Toolset dynamic tag</li>\n<li>Fix: Enable inline editing to the inner content tabs in Video Playlist widget</li>\n<li>Fix: Clicking on the video list doesn\'t play videos properly in Video Playlist widget</li>\n<li>Fix: Hide Play Icon control when Image overlay is toggled off in Video Playlist widget</li>\n<li>Fix: Removed extra space below the player when viewing from mobile view in Video Playlist widget</li>\n<li>Fix: Import button is not working properly in Theme Builder interface</li>\n<li>Fix: Preview Dynamic Content as control is not updating preview and throws an error in Popup Builder</li>\n</ul>\n<h4>3.3.0 - 2021-06-08</h4>\n<ul>\n<li>New: Video Playlist widget - Add Engaging Video Content to Your Website (<a href=\"https://github.com/elementor/elementor/issues/11859\">#11859</a>, <a href=\"https://github.com/elementor/elementor/issues/7803\">#7803</a>)</li>\n<li>New: Hotspot widget - Create Interactive Images With Contextually Relevant Information (<a href=\"https://github.com/elementor/elementor/issues/7282\">#7282</a>, <a href=\"https://github.com/elementor/elementor/issues/2768\">#2768</a>)</li>\n<li>Tweak: Accessibility improvements for sub-menus in Nav Menu widget (<a href=\"https://github.com/elementor/elementor/issues/13859\">#13859</a>, <a href=\"https://github.com/elementor/elementor/issues/13810\">#13810</a>)</li>\n<li>Tweak: MailChimp action after submit can now add new tags to existing subscribers in Forms widget (<a href=\"https://github.com/elementor/elementor/issues/11111\">#11111</a>)</li>\n<li>Tweak: Added <code>elementor_pro/forms/record/actions_before</code> to filter the record before it sent to Actions After Submit in Forms widget (<a href=\"https://github.com/elementor/elementor/issues/14261\">#14261</a>)</li>\n<li>Tweak: Yoast SEO breadcrumbs widget can be used in Elementor without the need of enabling them in Yoast setting</li>\n<li>Tweak: Added future support for widgets CSS conditional loading (<a href=\"https://github.com/elementor/elementor/issues/10329\">#10329</a>, <a href=\"https://github.com/elementor/elementor/issues/14229\">#14229</a>)</li>\n<li>Tweak: Added future support for Sticky JS library conditional loading</li>\n<li>Tweak: Added future support for Import / Export experiment</li>\n<li>Tweak: Preparations and fixes for Import Export Experiment in Pro version</li>\n<li>Tweak: Added gradient button capabilities to Login widget buttons</li>\n<li>Tweak: Added gradient button capabilities to Slides widget button</li>\n<li>Tweak: Added gradient button capabilities to Price Table widget button</li>\n<li>Tweak: Added gradient button capabilities to Flip Box widget button</li>\n<li>Tweak: Added Code Highlight widget Developers Documentation</li>\n<li>Tweak: Adjusted Submissions page for future updates</li>\n<li>Tweak: Added <code>em</code> and <code>%</code> units for padding control in Carousel widgets</li>\n<li>Tweak: Shorten currency name to currency symbol in PayPal button widget</li>\n<li>Fix: Custom Fonts URLs should be replaced when replace URL is triggered (<a href=\"https://github.com/elementor/elementor/issues/7376\">#7376</a>, <a href=\"https://github.com/elementor/elementor/issues/10382\">#10382</a>)</li>\n<li>Fix: The currency symbol size changed in the Price Table widget if enabling sale (<a href=\"https://github.com/elementor/elementor/issues/13519\">#13519</a>)</li>\n<li>Fix: Nav Menu widget is not loading Font Awesome submenu icons (<a href=\"https://github.com/elementor/elementor/issues/9907\">#9907</a>)</li>\n<li>Fix: Hamburger toggle is not working in Nav menu widget</li>\n<li>Fix: Activation bug for IDN domains</li>\n<li>Fix: Conditions modal responsive glitches in Custom Code</li>\n<li>Fix: Duplicated strings in Custom Code module</li>\n<li>Fix: Enable resize option for code input field in Custom Code</li>\n<li>Fix: &quot;Save &amp; Close &quot;button in Custom Code\'s Conditions modal was not visible on small screen sizes</li>\n<li>Fix: Removing a column from a section in the navigator resulted in an empty section</li>\n<li>Fix: Recommend option is cut If the layout is not &quot;Standard&quot; in the Facebook Button widget</li>\n<li>Fix: Video item does not play without adding an image in Media Carousel widget</li>\n<li>Fix: <code>search-plus</code> icon missing from panel in Media Carousel widget</li>\n<li>Fix: UI hover state glitch in Media Carousel widget</li>\n<li>Fix: PHP notice was thrown when trying to import a kit without overrideConditions parameter in Kit Import flow</li>\n<li>Fix: Templates conditions not imported if there are no conflicts in Import Export Experiment</li>\n<li>Fix: Non english values are not encoded properly on Submissions export</li>\n<li>Fix: Theme Builder import is not working properly</li>\n<li>Fix: UI glitch when no global widgets were found in Editor Panel</li>\n<li>Deprecated: See all deprecations to this version in our <a href=\"https://developers.elementor.com/v3-3-planned-deprecations/\">Developers Deprecations Post</a></li>\n</ul>\n<h4>3.2.2 - 2021-05-05</h4>\n<ul>\n<li>Tweak: Added support for Expert tier templates in Templates Library</li>\n<li>Tweak: Updated compatibility tag to support Elementor v3.2.x</li>\n<li>Tweak: Added compatibility for future Library improvements</li>\n<li>Fix: Toolset image dynamic field is not working with Gallery widget</li>\n</ul>\n<h4>3.2.1 - 2021-03-21</h4>\n<ul>\n<li>Tweak: Added strings context in PayPal button and Price Table widgets</li>\n<li>Tweak: Added support for future Import / Export Kit feature</li>\n<li>Fix: Submissions with over than 191 characters weren\'t indexed properly</li>\n</ul>\n<h4>3.2.0 - 2021-03-16</h4>\n<ul>\n<li>New: PayPal Button widget - Collect PayPal payments directly from your site</li>\n<li>Experiment: Submissions - Save all of your form submissions in one place (<a href=\"https://github.com/elementor/elementor/issues/1686\">#1686</a>)</li>\n<li>Tweak: Added Stay In Column option to Inner Section element (<a href=\"https://github.com/elementor/elementor/issues/7956\">#7956</a>)</li>\n<li>Tweak: Adjusted \'Max Height\' control range in Table of Contents widget</li>\n<li>Tweak: Changed descriptive text in Create Custom Code screen</li>\n<li>Tweak: Added support for dynamic capabilities in Code Highlight widget</li>\n<li>Tweak: Added support for future load on demand for <code>share-link</code> library</li>\n<li>Tweak: Added support for future load on demand for <code>dialog</code> library in Popup</li>\n<li>Tweak: Allow overwriting the assets URL when using a mirror domain</li>\n<li>Fix: Animation was triggered multiple times when accessing the viewport in certain cases in Animated Headline widget (<a href=\"https://github.com/elementor/elementor/issues/13951\">#13951</a>)</li>\n<li>Fix: Location is not being updated after a Custom Code snippet is published (<a href=\"https://github.com/elementor/elementor/issues/13971\">#13971</a>)</li>\n<li>Fix: Custom Fonts CSS files were not updated after regenerating CSS files</li>\n<li>Fix: Conditions modal is not responsive in Custom Code</li>\n<li>Fix: Empty order buttons are displayed in Custom Fonts screen</li>\n<li>Fix: Typo in \'Reply To\' Email action after submit placeholder in Forms widget</li>\n<li>Fix: Unnecessary Save Draft button in Custom Code</li>\n<li>Fix: RTL glitches in Custom Code</li>\n<li>Fix: Sanitized options in the editor to enforce better security policies</li>\n<li>Deprecated: See all deprecations to this version in our (<a href=\"https://developers.elementor.com/v3-2-planned-deprecations/\">Developers Deprecations Post</a>)</li>\n</ul>\n<h4>3.1.1 - 2021-02-23</h4>\n<ul>\n<li>Tweak: Adjusted \'Max Height\' control range in Table of Contents widget</li>\n<li>Fix: Popup event handler is undefined (<a href=\"https://github.com/elementor/elementor/issues/11475\">#11475</a>, <a href=\"https://github.com/elementor/elementor/issues/10690\">#10690</a>)</li>\n<li>Fix: Conditions modal is not responsive in Custom Code</li>\n<li>Fix: RTL glitches in Code Highlight widget</li>\n<li>Fix: Minor UI glitches in Code Highlight widget</li>\n<li>Fix: Users can\'t get Pro Developer Edition version updates</li>\n</ul>\n<h4>3.1.0 - 2021-02-16</h4>\n<ul>\n<li>New: Introducing Custom Code - Add custom code snippets to your site, including <code>head</code>, <code>body</code> start and <code>body</code> end</li>\n<li>New: Meet Code Highlight widget - showcase any syntax with highlighted UI (<a href=\"https://github.com/elementor/elementor/issues/5815\">#5815</a>)</li>\n<li>Experiment: Improved Pro widgets performance by loading JS and Swiper assets conditionally in frontend (<a href=\"https://github.com/elementor/elementor/issues/8572\">#8572</a>, <a href=\"https://developers.elementor.com/experiment-optimized-asset-loading/\">Developer Documentation</a>)</li>\n<li>Tweak: Added Compatibility Tag support in Elementor Pro (<a href=\"https://developers.elementor.com/compatibility-tag/\">Developer Documentation</a>)</li>\n<li>Tweak: Added Dynamic capabilities to Rotating Text animation in Animated Headline widget (<a href=\"https://github.com/elementor/elementor/issues/4625\">#4625</a>, <a href=\"https://github.com/elementor/elementor/issues/8569\">#8569</a>)</li>\n<li>Tweak: Added an option to set Selected color for Typing effect in Animated Headline widget (<a href=\"https://github.com/elementor/elementor/issues/5403\">#5403</a>, <a href=\"https://github.com/elementor/elementor/issues/7826\">#7826</a>)</li>\n<li>Tweak: Added animation Loop option for Animated Headline (<a href=\"https://github.com/elementor/elementor/issues/9749\">#9749</a>, <a href=\"https://github.com/elementor/elementor/issues/2457\">#2457</a>)</li>\n<li>Tweak: Added timing options for Animated Headline widget (<a href=\"https://github.com/elementor/elementor/issues/4392\">#4392</a>)</li>\n<li>Tweak: Added dynamic capabilities for Testimonial Carousel widget (<a href=\"https://github.com/elementor/elementor/issues/8569\">#8569</a>)</li>\n<li>Tweak: Added dynamic capabilities for Price Table widget (<a href=\"https://github.com/elementor/elementor/issues/4242\">#4242</a>, <a href=\"https://github.com/elementor/elementor/issues/8569\">#8569</a>)</li>\n<li>Tweak: Added Word Wrap control to Code Highlight widget (<a href=\"https://github.com/elementor/elementor/issues/13577\">#13577</a>)</li>\n<li>Tweak: Upgraded Font Awesome Pro library to v5.15.1</li>\n<li>Tweak: Improved method of loading field mapping repeater in Form widget (<a href=\"https://developers.elementor.com/how-to-add-a-repeater-control-to-elementor-add-on/\">Developer Documentation</a>)</li>\n<li>Tweak: Added &quot;Show on Browsers&quot; Popup Advanced Rule</li>\n<li>Tweak: Added real-time JS handling to prevent redundant renders in Slides widget and all Carousel widgets</li>\n<li>Tweak: Import scroll utility from core and remove it from Pro</li>\n<li>Tweak: Added alignment options for Post Excerpt widget (<a href=\"https://github.com/elementor/elementor/issues/9757\">#9757</a>)</li>\n<li>Tweak: Changed alignment control to work with selectors in Share Buttons</li>\n<li>Tweak: Upgraded to Webpack 5, Grunt-Webpack 4 and TerserPlugin instead of UglifyJsPlugin</li>\n<li>Fix: Steps Divider is not vertically aligned in Multi Step Form widget (<a href=\"https://github.com/elementor/elementor/issues/12569\">#12569</a>)</li>\n<li>Fix: Slides are playing in an infinite loop mode even when the option is disabled in Slides Widget (<a href=\"https://github.com/elementor/elementor/issues/6726\">#6726</a>)</li>\n<li>Fix: Redundant spacing is added to Share Buttons widget</li>\n<li>Fix: Step buttons text is not updated without a page reload in Forms widget</li>\n<li>Fix: Overflow issue in certain animations in Animated Headline widget</li>\n<li>Fix: When dragging a new Testimonial Carousel there is a console error thrown</li>\n<li>Fix: Step Buttons are cut in mobile view in Multi Step Form</li>\n<li>Fix: Submit and Step buttons size differences when using Twenty Twenty theme</li>\n<li>Fix: Duplicate button Text Color control in Slides widget</li>\n<li>Fix: JS error is thrown when editing and saving global widgets</li>\n<li>Fix: <code>get_version</code> API function may fail with Redis / DB cache</li>\n<li>Fix: Multiple license check requests are created in certain cases</li>\n<li>Deprecated: Deprecate methods prefixed with an underscore and replace them with unprefixed methods</li>\n<li>Deprecated: See all deprecations to this version in our <a href=\"https://developers.elementor.com/v3-1-planned-deprecations/\">Developers Deprecations Post</a></li>\n</ul>\n<h4>3.0.10 - 2021-01-20</h4>\n<ul>\n<li>Tweak: Added Editing Handles string translation compatibility with Elementor Pro v3.1</li>\n</ul>\n<h4>3.0.9 - 2020-12-29</h4>\n<ul>\n<li>Tweak: Added compatibility to support Elementor 3.1.0</li>\n<li>Fix: Wrong phrasing of Import template success message in Theme Builder</li>\n<li>Fix: Border color glitch in Theme Builder</li>\n</ul>\n<h4>3.0.8 - 2020-11-26</h4>\n<ul>\n<li>Fix: Navigation arrows UI glitch in Media Carousel widget (<a href=\"https://github.com/elementor/elementor/issues/13172\">#13172</a>)</li>\n</ul>\n<h4>3.0.7 - 2020-11-25</h4>\n<ul>\n<li>Fix: Console Error when dragging Testimonials Carousel widget</li>\n<li>Fix: Arrows of Testimonial and Reviews Carousel widgets navigate to the wrong direction in RTL websites</li>\n<li>Fix: Removed the conditional loading of Webpack</li>\n<li>Fix: Fatal error is thrown after deleting an associated custom taxonomy when Posts widget with Cards skin has a badge</li>\n<li>Fix: Upload JSON files only when the user allowed to prevent security issues</li>\n<li>Fix: Gallery not displayed in Theme Builder templates preview</li>\n</ul>\n<h4>3.0.6 - 2020-11-04</h4>\n<ul>\n<li>Tweak: Updated the embedded post in Facebook Embed widget</li>\n<li>Fix: Minor UI glitches in Theme Builder\'s conditions screen footer</li>\n<li>Fix: Template type changes into Single Page after conditions change in Theme Builder</li>\n<li>Fix: Redundant Custom Caption option in Site Logo widget</li>\n<li>Fix: Removed unused code in Drip integration</li>\n<li>Fix: Removed Weibo and WeChat social networks due to website and links inactivity from Share Buttons widget</li>\n<li>Fix: Removed redundant code from Portfolio and Post Navigation widgets</li>\n</ul>\n<h4>3.0.5 - 2020-09-23</h4>\n<ul>\n<li>Fix: If the default page layout is set to &quot;Canvas&quot; Headers and Footers cannot be edited</li>\n<li>Fix: Product Image Dynamic Tag throws an error when no image is set</li>\n<li>Fix: Missing Single document placeholder in Theme Builder</li>\n<li>Fix: Document editing handles inherit the <code>font-family</code> from 3rd party source</li>\n<li>Fix: Can\'t add linebreaks to Textarea input when used as Multi Step Form</li>\n<li>Fix: Incorrect width in Facebook Page widget</li>\n<li>Fix: Added compatibility to allow the use of \'get_create_url\' in Theme Builder</li>\n</ul>\n<h4>3.0.4 - 2020-09-09</h4>\n<ul>\n<li>Fix: Autogenerated screenshots appear in WP Media Library modal (<a href=\"https://github.com/elementor/elementor/issues/12304\">#12304</a>)</li>\n<li>Fix: Make sure Elementor Posts widget Pagination doesn\'t interfere with 3rd party plugins (<a href=\"https://github.com/elementor/elementor/issues/12126\">#12126</a>, <a href=\"https://github.com/elementor/elementor/issues/12127\">#12127</a>)</li>\n<li>Fix: Shrinking conditions indicator in Theme Builder</li>\n<li>Fix: Column can\'t be dragged and dropped if it populates a Global widget</li>\n<li>Fix: Styles are missing from Single templates in some edge cases</li>\n</ul>\n<h4>3.0.3 - 2020-09-02</h4>\n<ul>\n<li>Fix: Pagination doesn\'t work in WordPress 5.5 (<a href=\"https://github.com/elementor/elementor/issues/12126\">#12126</a>, <a href=\"https://github.com/elementor/elementor/issues/12127\">#12127</a>)</li>\n<li>Fix: Change delete template action to &quot;Move to Trash&quot; in the new Theme Builder view</li>\n</ul>\n<h4>3.0.2 - 2020-08-31</h4>\n<ul>\n<li>Tweak: Replaced WordPress &quot;Learn More&quot; links with dynamic links for better control over time (<a href=\"https://github.com/elementor/elementor/issues/12312\">#12312</a>)</li>\n<li>Tweak: UI tweaks to the Conditions screen In the new Theme Builder</li>\n<li>Fix: Motion Effects not working when assigned to a column and throws JS error when DOM optimization is disabled (<a href=\"https://github.com/elementor/elementor/issues/12299\">#12299</a>, <a href=\"https://github.com/elementor/elementor/issues/12275\">#12275</a>)</li>\n<li>Fix: Multiple Galleries display all the images in the Lightbox slideshow (<a href=\"https://github.com/elementor/elementor/issues/11809\">#11809</a>)</li>\n<li>Fix: Old Theme Builder is being opened when accessing through the Finder</li>\n<li>Fix: Mixed templates import glitch in Theme Builder</li>\n<li>Fix: Card icon sizes in Theme Builder</li>\n<li>Fix: Preview button leads to <code>render_mode</code> instead of preview when importing a template from the new Theme Builder</li>\n</ul>\n<h4>3.0.1 - 2020-08-26</h4>\n<ul